/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Metered;
import com.ryantenney.metrics.spring.AbstractMetricMethodInterceptor;
import com.ryantenney.metrics.spring.AdviceFactory;
import com.ryantenney.metrics.spring.AnnotationFilter;
import com.ryantenney.metrics.spring.Util;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.util.ReflectionUtils;

class MeteredMethodInterceptor
extends AbstractMetricMethodInterceptor<Metered, Meter> {
    public static final Class<Metered> ANNOTATION = Metered.class;
    public static final Pointcut POINTCUT = new AnnotationMatchingPointcut(null, ANNOTATION);
    public static final ReflectionUtils.MethodFilter METHOD_FILTER = new AnnotationFilter(ANNOTATION, 2469);

    public MeteredMethodInterceptor(MetricRegistry metricRegistry, Class<?> targetClass) {
        super(metricRegistry, targetClass, ANNOTATION, METHOD_FILTER);
    }

    @Override
    protected Object invoke(MethodInvocation invocation, Meter meter, Metered annotation) throws Throwable {
        meter.mark();
        return invocation.proceed();
    }

    @Override
    protected Meter buildMetric(MetricRegistry metricRegistry, String metricName, Metered annotation) {
        return metricRegistry.meter(metricName);
    }

    @Override
    protected String buildMetricName(Class<?> targetClass, Method method, Metered annotation) {
        return Util.forMeteredMethod(targetClass, method, annotation);
    }

    static AdviceFactory adviceFactory(final MetricRegistry metricRegistry) {
        return new AdviceFactory(){

            @Override
            public Advice getAdvice(Object bean, Class<?> targetClass) {
                return new MeteredMethodInterceptor(metricRegistry, targetClass);
            }
        };
    }
}

