/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

class AnnotationFilter
implements ReflectionUtils.MethodFilter,
ReflectionUtils.FieldFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationFilter.class);
    public static final int FIELDS = 223;
    public static final int METHODS = 3519;
    public static final int INJECTABLE_FIELDS = 199;
    public static final int INSTANCE_FIELDS = 215;
    public static final int INSTANCE_METHODS = 2487;
    public static final int PROXYABLE_METHODS = 2469;
    private final Class<? extends Annotation> clazz;
    private final int methodModifiers;
    private final int fieldModifiers;

    public AnnotationFilter(Class<? extends Annotation> clazz) {
        this(clazz, 3519, 223);
    }

    public AnnotationFilter(Class<? extends Annotation> clazz, int modifiers) {
        this(clazz, modifiers, modifiers);
    }

    public AnnotationFilter(Class<? extends Annotation> clazz, int methodModifiers, int fieldModifiers) {
        this.clazz = clazz;
        this.methodModifiers = methodModifiers & 0xDBF;
        this.fieldModifiers = fieldModifiers & 0xDF;
    }

    public boolean matches(Method method) {
        if (ReflectionUtils.USER_DECLARED_METHODS.matches(method) && method.isAnnotationPresent(this.clazz)) {
            if (this.checkModifiers(method, this.methodModifiers)) {
                return true;
            }
            LOG.warn("Ignoring @{} on method {}.{} due to illegal modifiers: {}", new Object[]{this.clazz.getSimpleName(), method.getDeclaringClass().getCanonicalName(), method.getName(), Modifier.toString(method.getModifiers() & ~this.methodModifiers)});
        }
        return false;
    }

    public boolean matches(Field field) {
        if (field.isAnnotationPresent(this.clazz)) {
            if (this.checkModifiers(field, this.fieldModifiers)) {
                return true;
            }
            LOG.warn("Ignoring @{} on field {}.{} due to illegal modifiers: {}", new Object[]{this.clazz.getSimpleName(), field.getDeclaringClass().getCanonicalName(), field.getName(), Modifier.toString(field.getModifiers() & ~this.fieldModifiers)});
        }
        return false;
    }

    private boolean checkModifiers(Member member, int allowed) {
        int modifiers = member.getModifiers();
        return (modifiers & allowed) == modifiers;
    }

    public String toString() {
        return "[AnnotationFilter: @" + this.clazz.getSimpleName() + ", methodModifiers: (" + Modifier.toString(this.methodModifiers) + "), fieldModifiers: (" + Modifier.toString(this.fieldModifiers) + ")]";
    }
}

