/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.migrator;

import com.typesafe.config.Config;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.AttachmentInfo;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.json.CiSerializerHelper;
import com.xebialabs.xlrelease.migrator.Migrator;
import com.xebialabs.xlrelease.migrator.config.Services;
import com.xebialabs.xlrelease.migrator.util.CloseableWorkDir;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000b\u001a\u00020\u0007J\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0082\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/xebialabs/xlrelease/migrator/ArchiveMigrator;", "Lcom/xebialabs/xlrelease/migrator/Migrator;", "services", "Lcom/xebialabs/xlrelease/migrator/config/Services;", "migratorConfig", "Lcom/typesafe/config/Config;", "skipErrors", "", "(Lcom/xebialabs/xlrelease/migrator/config/Services;Lcom/typesafe/config/Config;Z)V", "getServices", "()Lcom/xebialabs/xlrelease/migrator/config/Services;", "migrate", "migrateArchive", "", "page", "", "pageSize", "xl-release-sql-migrator"})
public final class ArchiveMigrator
extends Migrator {
    @NotNull
    private final Services services;

    public final boolean migrate() {
        new WorkDirContext(new WorkDirFactory("work-archive-migration"));
        this.getLogger().info("Start migrating archive db...");
        this.migrateArchive(0L, this.getPageSize());
        this.getLogger().info("Finished archive db migration");
        return !this.getErrorsFound();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void migrateArchive(long page, long pageSize) {
        while (true) {
            List<String> archivedReleasesIds = this.services.getArchivedReleaseIdsSearch().searchReleaseIds(pageSize, page);
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            Closeable closeable = new CloseableWorkDir();
            Throwable throwable = null;
            try {
                void skippedCount;
                CloseableWorkDir it = (CloseableWorkDir)closeable;
                Iterable $receiver$iv = archivedReleasesIds;
                for (Object element$iv : $receiver$iv) {
                    String releaseId = (String)element$iv;
                    ArchivedReleases archivedReleases = this.services.getNewArchivedReleases();
                    if (archivedReleases == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!archivedReleases.exists(releaseId)) {
                        this.getLogger().info("migrating archive release " + releaseId + "...");
                        Release archivedRelease = this.services.getArchivingService().getRelease(releaseId);
                        List activityLogs = this.services.getArchivedActivityLogsService().getActivityLogs(releaseId);
                        this.trySkipErrors((Function0<Unit>)((Function0)new Function0<Unit>(activityLogs, archivedRelease, releaseId, this, archivedReleasesIds, (Ref.IntRef)skippedCount){
                            final /* synthetic */ List $activityLogs;
                            final /* synthetic */ Release $archivedRelease;
                            final /* synthetic */ String $releaseId;
                            final /* synthetic */ ArchiveMigrator this$0;
                            final /* synthetic */ List $archivedReleasesIds$inlined;
                            final /* synthetic */ Ref.IntRef $skippedCount$inlined;
                            {
                                this.$activityLogs = list;
                                this.$archivedRelease = release;
                                this.$releaseId = string;
                                this.this$0 = archiveMigrator;
                                this.$archivedReleasesIds$inlined = list2;
                                this.$skippedCount$inlined = intRef;
                                super(0);
                            }

                            public final void invoke() {
                                Attachment attachment;
                                Attachment it;
                                Collection collection;
                                Iterable $receiver$iv$iv;
                                String activityLogsSerialized = CiSerializerHelper.serialize((List)this.$activityLogs, (ConfigurationItemConverter)((ConfigurationItemConverter)new WriteWithoutPasswordCiConverter()));
                                String serializedRelease = CiSerializerHelper.serialize((ConfigurationItem)((ConfigurationItem)this.$archivedRelease), (ConfigurationItemConverter)((ConfigurationItemConverter)new WriteWithoutPasswordCiConverter()));
                                this.this$0.getServices().getNewArchivedReleases().insert(this.$archivedRelease, serializedRelease, activityLogsSerialized);
                                Release release = this.$archivedRelease;
                                Intrinsics.checkExpressionValueIsNotNull((Object)release, (String)"archivedRelease");
                                List list = release.getAttachments();
                                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"archivedRelease.attachments");
                                Iterable $receiver$iv = list;
                                Iterable iterable = $receiver$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                                for (T item$iv$iv : $receiver$iv$iv) {
                                    Attachment attachment2 = (Attachment)item$iv$iv;
                                    collection = destination$iv$iv;
                                    ArchivingService archivingService = this.this$0.getServices().getArchivingService();
                                    void v3 = it;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                                    attachment = archivingService.getAttachment(v3.getId());
                                    collection.add(attachment);
                                }
                                $receiver$iv = (List)destination$iv$iv;
                                $receiver$iv$iv = $receiver$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                                for (T item$iv$iv : $receiver$iv$iv) {
                                    it = (Attachment)item$iv$iv;
                                    collection = destination$iv$iv;
                                    Attachment attachment3 = it;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)attachment3, (String)"it");
                                    String string = attachment3.getId();
                                    OverthereFile overthereFile = it.getFile();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)overthereFile, (String)"it.file");
                                    String string2 = overthereFile.getName();
                                    OverthereFile overthereFile2 = it.getFile();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)overthereFile2, (String)"it.file");
                                    attachment = new AttachmentInfo(string, string2, overthereFile2.getInputStream());
                                    collection.add(attachment);
                                }
                                $receiver$iv = (List)destination$iv$iv;
                                for (E element$iv : $receiver$iv) {
                                    AttachmentInfo it2 = (AttachmentInfo)element$iv;
                                    this.this$0.getServices().getNewArchivedReleases().insertAttachment(this.$releaseId, it2);
                                }
                            }
                        }));
                        continue;
                    }
                    this.getLogger().debug("Release [" + releaseId + "] has already been migrated");
                    int n = skippedCount.element;
                    skippedCount.element = n + 1;
                }
                if (skippedCount.element > 0) {
                    this.getLogger().info("Skipped " + skippedCount.element + " releases as they have already been migrated");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if ((long)archivedReleasesIds.size() < pageSize) break;
            ++page;
        }
    }

    @NotNull
    public final Services getServices() {
        return this.services;
    }

    public ArchiveMigrator(@NotNull Services services, @NotNull Config migratorConfig, boolean skipErrors) {
        Intrinsics.checkParameterIsNotNull((Object)services, (String)"services");
        Intrinsics.checkParameterIsNotNull((Object)migratorConfig, (String)"migratorConfig");
        super(migratorConfig, skipErrors);
        this.services = services;
    }

    public /* synthetic */ ArchiveMigrator(Services services, Config config, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(services, config, bl);
    }
}

