/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.jcr.JcrQueryTemplate;
import com.xebialabs.deployit.repository.QueryTemplate;
import com.xebialabs.xlrelease.repository.query.JcrPredicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class JcrQueryBuilder {
    private StringBuilder query = new StringBuilder();
    private JcrPredicate predicate;

    private JcrQueryBuilder(String ... selectedFields) {
        this.query.append("SELECT ");
        this.query.append(selectedFields[0]);
        for (int i = 1; i < selectedFields.length; ++i) {
            this.query.append(", ").append(selectedFields[i]);
        }
    }

    public static JcrQueryBuilder select(String ... fields) {
        return new JcrQueryBuilder(fields);
    }

    public JcrQueryBuilder selectTypeAs(String selector, String alias) {
        this.query.append(", ").append(selector).append(".[").append("$configuration.item.type");
        this.query.append("] AS ").append(alias);
        return this;
    }

    public JcrQueryBuilder from(String selector) {
        this.query.append(" FROM [");
        this.query.append("deployit:configurationItem");
        this.query.append("] AS ");
        this.query.append(selector);
        return this;
    }

    public JcrQueryBuilder joinWithParent(String childSelector, String parentSelector) {
        this.query.append(" INNER JOIN [");
        this.query.append("deployit:configurationItem");
        this.query.append("] AS ");
        this.query.append(parentSelector);
        this.query.append(" ON ");
        this.query.append(JcrPredicate.isDescendantNode(childSelector, parentSelector).getQuery());
        return this;
    }

    public JcrQueryBuilder where(JcrPredicate predicate) {
        this.query.append(" WHERE %s ");
        this.predicate = predicate;
        return this;
    }

    public JcrQueryBuilder orderBy(String expression) {
        this.query.append(" ORDER BY ");
        this.query.append(expression);
        return this;
    }

    public QueryTemplate build() {
        int count = 0;
        HashMap parameters = Maps.newHashMap();
        ArrayList variables = Lists.newArrayList();
        for (Object value : this.predicate.getParameters()) {
            String key = String.format("_%s", count);
            parameters.put(key, value);
            variables.add(key);
            ++count;
        }
        String conditions = String.format(this.predicate.getQuery(), variables.toArray());
        return new JcrQueryTemplate(String.format(this.query.toString(), conditions), (Map)parameters);
    }
}

