/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Objects;
import jnr.ffi.LibraryLoader;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.annotations.In;
import jnr.ffi.annotations.Out;
import jnr.ffi.byref.IntByReference;
import jnr.ffi.byref.NativeLongByReference;
import jnr.ffi.byref.PointerByReference;
import jnr.ffi.types.size_t;
import org.lmdbjava.LmdbException;

final class Library {
    public static final String DISABLE_EXTRACT_PROP = "lmdbjava.disable.extract";
    public static final boolean SHOULD_EXTRACT = !Boolean.getBoolean("lmdbjava.disable.extract");
    static final Lmdb LIB;
    static final Runtime RUNTIME;
    private static final String LIB_NAME = "lmdb";

    private Library() {
    }

    private static String extract(String name) {
        String suffix = name.substring(name.lastIndexOf(46));
        try {
            File file = File.createTempFile("lmdbjava-native-library-", suffix);
            file.deleteOnExit();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try (InputStream in = cl.getResourceAsStream(name);
                 FileOutputStream out = new FileOutputStream(file);){
                int bytes;
                Objects.requireNonNull(in, "Classpath resource not found");
                byte[] buffer = new byte[4096];
                while (-1 != (bytes = in.read(buffer))) {
                    ((OutputStream)out).write(buffer, 0, bytes);
                }
            }
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            throw new LmdbException("Failed to extract " + name, e);
        }
    }

    static {
        String arch = System.getProperty("os.arch");
        boolean arch64 = "x64".equals(arch) || "amd64".equals(arch) || "x86_64".equals(arch);
        String os = System.getProperty("os.name");
        boolean linux = os.toLowerCase(Locale.ENGLISH).startsWith("linux");
        boolean osx = os.startsWith("Mac OS X");
        boolean windows = os.startsWith("Windows");
        String libToLoad = SHOULD_EXTRACT && arch64 && linux ? Library.extract("org/lmdbjava/lmdbjava-native-linux-x86_64.so") : (SHOULD_EXTRACT && arch64 && osx ? Library.extract("org/lmdbjava/lmdbjava-native-osx-x86_64.dylib") : (SHOULD_EXTRACT && arch64 && windows ? Library.extract("org/lmdbjava/lmdbjava-native-windows-x86_64.dll") : LIB_NAME));
        LIB = (Lmdb)LibraryLoader.create(Lmdb.class).load(libToLoad);
        RUNTIME = Runtime.getRuntime((Object)LIB);
    }

    public static interface Lmdb {
        public void mdb_cursor_close(@In Pointer var1);

        public int mdb_cursor_count(@In Pointer var1, NativeLongByReference var2);

        public int mdb_cursor_del(@In Pointer var1, int var2);

        public int mdb_cursor_get(@In Pointer var1, Pointer var2, @Out Pointer var3, int var4);

        public int mdb_cursor_open(@In Pointer var1, @In Pointer var2, PointerByReference var3);

        public int mdb_cursor_put(@In Pointer var1, @In Pointer var2, @In Pointer var3, int var4);

        public int mdb_cursor_renew(@In Pointer var1, @In Pointer var2);

        public void mdb_dbi_close(@In Pointer var1, @In Pointer var2);

        public int mdb_dbi_flags(@In Pointer var1, @In Pointer var2, int var3);

        public int mdb_dbi_open(@In Pointer var1, @In byte[] var2, int var3, @In Pointer var4);

        public int mdb_del(@In Pointer var1, @In Pointer var2, @In Pointer var3, @In Pointer var4);

        public int mdb_drop(@In Pointer var1, @In Pointer var2, int var3);

        public void mdb_env_close(@In Pointer var1);

        public int mdb_env_copy2(@In Pointer var1, @In String var2, int var3);

        public int mdb_env_create(PointerByReference var1);

        public int mdb_env_get_fd(@In Pointer var1, @In Pointer var2);

        public int mdb_env_get_flags(@In Pointer var1, int var2);

        public int mdb_env_get_maxkeysize(@In Pointer var1);

        public int mdb_env_get_maxreaders(@In Pointer var1, int var2);

        public int mdb_env_get_path(@In Pointer var1, String var2);

        public int mdb_env_info(@In Pointer var1, @Out MDB_envinfo var2);

        public int mdb_env_open(@In Pointer var1, @In String var2, int var3, int var4);

        public int mdb_env_set_flags(@In Pointer var1, int var2, int var3);

        public int mdb_env_set_mapsize(@In Pointer var1, @size_t long var2);

        public int mdb_env_set_maxdbs(@In Pointer var1, int var2);

        public int mdb_env_set_maxreaders(@In Pointer var1, int var2);

        public int mdb_env_stat(@In Pointer var1, @Out MDB_stat var2);

        public int mdb_env_sync(@In Pointer var1, int var2);

        public int mdb_get(@In Pointer var1, @In Pointer var2, @In Pointer var3, @Out Pointer var4);

        public int mdb_put(@In Pointer var1, @In Pointer var2, @In Pointer var3, @In Pointer var4, int var5);

        public int mdb_reader_check(@In Pointer var1, int var2);

        public int mdb_stat(@In Pointer var1, @In Pointer var2, @Out MDB_stat var3);

        public String mdb_strerror(int var1);

        public void mdb_txn_abort(@In Pointer var1);

        public int mdb_txn_begin(@In Pointer var1, @In Pointer var2, int var3, Pointer var4);

        public int mdb_txn_commit(@In Pointer var1);

        public Pointer mdb_txn_env(@In Pointer var1);

        public long mdb_txn_id(@In Pointer var1);

        public int mdb_txn_renew(@In Pointer var1);

        public void mdb_txn_reset(@In Pointer var1);

        public Pointer mdb_version(IntByReference var1, IntByReference var2, IntByReference var3);
    }

    public static final class MDB_stat
    extends Struct {
        public final Struct.u_int32_t f0_ms_psize = new Struct.u_int32_t((Struct)this);
        public final Struct.u_int32_t f1_ms_depth = new Struct.u_int32_t((Struct)this);
        public final Struct.size_t f2_ms_branch_pages = new Struct.size_t((Struct)this);
        public final Struct.size_t f3_ms_leaf_pages = new Struct.size_t((Struct)this);
        public final Struct.size_t f4_ms_overflow_pages = new Struct.size_t((Struct)this);
        public final Struct.size_t f5_ms_entries = new Struct.size_t((Struct)this);

        MDB_stat(Runtime runtime) {
            super(runtime);
        }
    }

    public static final class MDB_envinfo
    extends Struct {
        public final Struct.Pointer f0_me_mapaddr = new Struct.Pointer((Struct)this);
        public final Struct.size_t f1_me_mapsize = new Struct.size_t((Struct)this);
        public final Struct.size_t f2_me_last_pgno = new Struct.size_t((Struct)this);
        public final Struct.size_t f3_me_last_txnid = new Struct.size_t((Struct)this);
        public final Struct.u_int32_t f4_me_maxreaders = new Struct.u_int32_t((Struct)this);
        public final Struct.u_int32_t f5_me_numreaders = new Struct.u_int32_t((Struct)this);

        MDB_envinfo(Runtime runtime) {
            super(runtime);
        }
    }
}

