/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.akka.extension.quartz;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ExtensionId;
import akka.event.EventStream;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import com.typesafe.akka.extension.quartz.QuartzCalendars$;
import com.typesafe.akka.extension.quartz.QuartzCronSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedulerExtension$;
import com.typesafe.akka.extension.quartz.QuartzSchedules$;
import com.typesafe.akka.extension.quartz.SimpleActorMessageJob;
import com.typesafe.akka.extension.quartz.package$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.quartz.Calendar;
import org.quartz.CronExpression;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.core.jmx.JobDataMapSupport;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tmv!B\u0001\u0003\u0011\u0003i\u0011\u0001G)vCJ$(pU2iK\u0012,H.\u001a:FqR,gn]5p]*\u00111\u0001B\u0001\u0007cV\f'\u000f\u001e>\u000b\u0005\u00151\u0011!C3yi\u0016t7/[8o\u0015\t9\u0001\"\u0001\u0003bW.\f'BA\u0005\u000b\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0011\u00059yQ\"\u0001\u0002\u0007\u000bA\u0011\u0001\u0012A\t\u00031E+\u0018M\u001d;{'\u000eDW\rZ;mKJ,\u0005\u0010^3og&|gn\u0005\u0002\u0010%A\u00191cF\r\u000e\u0003QQ!!\u0006\f\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003\u001dI!\u0001\u0007\u000b\u0003\u0019\u0015CH/\u001a8tS>t7*Z=\u0011\u00059Qb\u0001\u0002\t\u0003\u0001m\u00192A\u0007\u000f#!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fMB\u00111cI\u0005\u0003IQ\u0011\u0011\"\u0012=uK:\u001c\u0018n\u001c8\t\u0011\u0019R\"\u0011!Q\u0001\n\u001d\naa]=ti\u0016l\u0007CA\n)\u0013\tICCA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W\u000eC\u0003,5\u0011\u0005A&\u0001\u0004=S:LGO\u0010\u000b\u000335BQA\n\u0016A\u0002\u001dBqa\f\u000eC\u0002\u0013%\u0001'A\u0002m_\u001e,\u0012!\r\t\u0003eUj\u0011a\r\u0006\u0003iY\tQ!\u001a<f]RL!AN\u001a\u0003\u001d1{wmZ5oO\u0006#\u0017\r\u001d;fe\"1\u0001H\u0007Q\u0001\nE\nA\u0001\\8hA!)!H\u0007C\u0001w\u0005i1o\u00195fIVdWM\u001d(b[\u0016,\u0012\u0001\u0010\t\u0003{\u0011s!A\u0010\"\u0011\u0005}rR\"\u0001!\u000b\u0005\u0005c\u0011A\u0002\u001fs_>$h(\u0003\u0002D=\u00051\u0001K]3eK\u001aL!!\u0012$\u0003\rM#(/\u001b8h\u0015\t\u0019e\u0004C\u0004I5\t\u0007I\u0011C%\u0002\r\r|gNZ5h+\u0005Q\u0005CA&N\u001b\u0005a%B\u0001%\t\u0013\tqEJ\u0001\u0004D_:4\u0017n\u001a\u0005\u0007!j\u0001\u000b\u0011\u0002&\u0002\u000f\r|gNZ5hA!A!K\u0007EC\u0002\u0013\u0005\u0011*A\u0007eK\u001a\fW\u000f\u001c;D_:4\u0017n\u001a\u0005\b)j\u0011\r\u0011\"\u0001V\u0003-!\bN]3bI\u000e{WO\u001c;\u0016\u0003Y\u0003\"!H,\n\u0005as\"aA%oi\"1!L\u0007Q\u0001\nY\u000bA\u0002\u001e5sK\u0006$7i\\;oi\u0002Bq\u0001\u0018\u000eC\u0002\u0013\u0005Q+\u0001\buQJ,\u0017\r\u001a)sS>\u0014\u0018\u000e^=\t\ryS\u0002\u0015!\u0003W\u0003=!\bN]3bIB\u0013\u0018n\u001c:jif\u0004\u0003b\u00021\u001b\u0005\u0004%\t!Y\u0001\u0015I\u0006,Wn\u001c8UQJ,\u0017\rZ:`IEl\u0017M]6\u0016\u0003\t\u0004\"!H2\n\u0005\u0011t\"a\u0002\"p_2,\u0017M\u001c\u0005\u0007Mj\u0001\u000b\u0011\u00022\u0002+\u0011\fW-\\8o)\"\u0014X-\u00193t?\u0012\nX.\u0019:lA!9\u0001N\u0007b\u0001\n\u0003I\u0017a\u00043fM\u0006,H\u000e\u001e+j[\u0016TxN\\3\u0016\u0003)\u0004\"a\u001b9\u000e\u00031T!!\u001c8\u0002\tU$\u0018\u000e\u001c\u0006\u0002_\u0006!!.\u0019<b\u0013\t\tHN\u0001\u0005US6,'l\u001c8f\u0011\u0019\u0019(\u0004)A\u0005U\u0006\u0001B-\u001a4bk2$H+[7fu>tW\r\t\u0005\bkj\u0001\r\u0011\"\u0001w\u0003%\u00198\r[3ek2,7/F\u0001x!\u0011AX\u0010P@\u000e\u0003eT!A_>\u0002\u0013%lW.\u001e;bE2,'B\u0001?\u001f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003}f\u00141!T1q!\rq\u0011\u0011A\u0005\u0004\u0003\u0007\u0011!AD)vCJ$(pU2iK\u0012,H.\u001a\u0005\n\u0003\u000fQ\u0002\u0019!C\u0001\u0003\u0013\tQb]2iK\u0012,H.Z:`I\u0015\fH\u0003BA\u0006\u0003#\u00012!HA\u0007\u0013\r\tyA\b\u0002\u0005+:LG\u000fC\u0005\u0002\u0014\u0005\u0015\u0011\u0011!a\u0001o\u0006\u0019\u0001\u0010J\u0019\t\u000f\u0005]!\u0004)Q\u0005o\u0006Q1o\u00195fIVdWm\u001d\u0011\t\u0013\u0005m!D1A\u0005\u0002\u0005u\u0011a\u0003:v]:Lgn\u001a&pEN,\"!a\b\u0011\u000f\u0005\u0005\u0012q\u0005\u001f\u0002*5\u0011\u00111\u0005\u0006\u0004\u0003KY\u0018aB7vi\u0006\u0014G.Z\u0005\u0004}\u0006\r\u0002\u0003BA\u0016\u0003gi!!!\f\u000b\u0007\r\tyC\u0003\u0002\u00022\u0005\u0019qN]4\n\t\u0005U\u0012Q\u0006\u0002\u0007\u0015>\u00147*Z=\t\u0011\u0005e\"\u0004)A\u0005\u0003?\tAB];o]&twMS8cg\u0002Bq!!\u0010\u001b\t\u0003\ty$A\u0004ti\u0006tGMY=\u0015\u0005\u0005-\u0001BBA\"5\u0011\u0005\u0011-A\bjg&s7\u000b^1oI\nLXj\u001c3f\u0011\u001d\t9E\u0007C\u0001\u0003\u0013\nQa\u001d;beR$\u0012A\u0019\u0005\u0007\u0003\u001bRB\u0011A1\u0002\u0013%\u001c8\u000b^1si\u0016$\u0007bBA)5\u0011\u0005\u00111K\u0001\f]\u0016DH\u000f\u0016:jO\u001e,'\u000f\u0006\u0003\u0002V\u0005\u0005\u0004#B\u000f\u0002X\u0005m\u0013bAA-=\t1q\n\u001d;j_:\u00042a[A/\u0013\r\ty\u0006\u001c\u0002\u0005\t\u0006$X\rC\u0004\u0002d\u0005=\u0003\u0019\u0001\u001f\u0002\t9\fW.\u001a\u0005\b\u0003ORB\u0011AA \u0003)\u0019Xo\u001d9f]\u0012\fE\u000e\u001c\u0005\b\u0003WRB\u0011AA7\u0003!\u0019\b.\u001e;e_^tG\u0003BA\u0006\u0003_B\u0011\"!\u001d\u0002jA\u0005\t\u0019\u00012\u0002+]\f\u0017\u000e\u001e$pe*{'m\u001d+p\u0007>l\u0007\u000f\\3uK\"9\u0011Q\u000f\u000e\u0005\u0002\u0005]\u0014AC:vgB,g\u000e\u001a&pER\u0019!-!\u001f\t\u000f\u0005\r\u00141\u000fa\u0001y!9\u0011Q\u0010\u000e\u0005\u0002\u0005}\u0014!\u0003:fgVlWMS8c)\r\u0011\u0017\u0011\u0011\u0005\b\u0003G\nY\b1\u0001=\u0011\u001d\t)I\u0007C\u0001\u0003\u007f\t\u0011B]3tk6,\u0017\t\u001c7\t\u000f\u0005%%\u0004\"\u0001\u0002\f\u0006I1-\u00198dK2TuN\u0019\u000b\u0004E\u00065\u0005bBA2\u0003\u000f\u0003\r\u0001\u0010\u0005\b\u0003#SB\u0011AAJ\u00039\u0019'/Z1uKN\u001b\u0007.\u001a3vY\u0016$B\"a\u0003\u0002\u0016\u0006]\u0015QTAQ\u0003KCq!a\u0019\u0002\u0010\u0002\u0007A\b\u0003\u0006\u0002\u001a\u0006=\u0005\u0013!a\u0001\u00037\u000b1\u0002Z3tGJL\u0007\u000f^5p]B!Q$a\u0016=\u0011\u001d\ty*a$A\u0002q\nab\u0019:p]\u0016C\bO]3tg&|g\u000e\u0003\u0006\u0002$\u0006=\u0005\u0013!a\u0001\u00037\u000b\u0001bY1mK:$\u0017M\u001d\u0005\n\u0003O\u000by\t%AA\u0002)\f\u0001\u0002^5nKj|g.\u001a\u0005\b\u0003WSB\u0011AAW\u00035\u0011Xm]2iK\u0012,H.\u001a&pER\u0001\u00121LAX\u0003c\u000bY,a0\u0002B\u0006\r\u0017Q\u0019\u0005\b\u0003G\nI\u000b1\u0001=\u0011!\t\u0019,!+A\u0002\u0005U\u0016\u0001\u0003:fG\u0016Lg/\u001a:\u0011\u0007M\t9,C\u0002\u0002:R\u0011\u0001\"Q2u_J\u0014VM\u001a\u0005\b\u0003{\u000bI\u000b1\u0001\u001d\u0003\ri7o\u001a\u0005\u000b\u00033\u000bI\u000b%AA\u0002\u0005m\u0005bBAP\u0003S\u0003\r\u0001\u0010\u0005\u000b\u0003G\u000bI\u000b%AA\u0002\u0005m\u0005\"CAT\u0003S\u0003\n\u00111\u0001k\u0011\u001d\tIM\u0007C\u0005\u0003\u0017\faB]3n_Z,7k\u00195fIVdW\r\u0006\u0003\u0002\f\u00055\u0007bBA2\u0003\u000f\u0004\r\u0001\u0010\u0005\b\u0003#TB\u0011AAj\u0003!\u00198\r[3ek2,G\u0003CA.\u0003+\f9.!7\t\u000f\u0005\r\u0014q\u001aa\u0001y!A\u00111WAh\u0001\u0004\t)\fC\u0004\u0002>\u0006=\u0007\u0019\u0001\u000f\t\u000f\u0005E'\u0004\"\u0001\u0002^RA\u00111LAp\u0003C\fI\u000fC\u0004\u0002d\u0005m\u0007\u0019\u0001\u001f\t\u0011\u0005M\u00161\u001ca\u0001\u0003G\u00042aEAs\u0013\r\t9\u000f\u0006\u0002\u000f\u0003\u000e$xN]*fY\u0016\u001cG/[8o\u0011\u001d\ti,a7A\u0002qAq!!5\u001b\t\u0003\ti\u000f\u0006\u0005\u0002\\\u0005=\u0018\u0011_A}\u0011\u001d\t\u0019'a;A\u0002qB\u0001\"a-\u0002l\u0002\u0007\u00111\u001f\t\u0004e\u0005U\u0018bAA|g\tYQI^3oiN#(/Z1n\u0011\u001d\ti,a;A\u0002qAq!!5\u001b\t\u0003\ti\u0010\u0006\u0006\u0002\\\u0005}(\u0011\u0001B\u0002\u0005\u000bAq!a\u0019\u0002|\u0002\u0007A\b\u0003\u0005\u00024\u0006m\b\u0019AA[\u0011\u001d\ti,a?A\u0002qA\u0001Ba\u0002\u0002|\u0002\u0007\u0011QK\u0001\ngR\f'\u000f\u001e#bi\u0016Dq!!5\u001b\t\u0003\u0011Y\u0001\u0006\u0006\u0002\\\t5!q\u0002B\t\u0005'Aq!a\u0019\u0003\n\u0001\u0007A\b\u0003\u0005\u00024\n%\u0001\u0019AAr\u0011\u001d\tiL!\u0003A\u0002qA\u0001Ba\u0002\u0003\n\u0001\u0007\u0011Q\u000b\u0005\b\u0003#TB\u0011\u0001B\f))\tYF!\u0007\u0003\u001c\tu!q\u0004\u0005\b\u0003G\u0012)\u00021\u0001=\u0011!\t\u0019L!\u0006A\u0002\u0005M\bbBA_\u0005+\u0001\r\u0001\b\u0005\t\u0005\u000f\u0011)\u00021\u0001\u0002V!9!1\u0005\u000e\u0005\n\t\u0015\u0012\u0001E:dQ\u0016$W\u000f\\3J]R,'O\\1m))\tYFa\n\u0003*\t-\"Q\u0006\u0005\b\u0003G\u0012\t\u00031\u0001=\u0011\u001d\t\u0019L!\tA\u0002qAq!!0\u0003\"\u0001\u0007A\u0004\u0003\u0005\u0003\b\t\u0005\u0002\u0019AA+\u0011\u001d\u0011\tD\u0007C\t\u0005g\t1b]2iK\u0012,H.\u001a&pERQ!Q\u0007B\u001d\u0005w\u0011iDa\u0010\u0015\t\u0005m#q\u0007\u0005\b\u0003#\u0014y\u00031\u0001\u0000\u0011\u001d\t\u0019Ga\fA\u0002qBq!a-\u00030\u0001\u0007A\u0004C\u0004\u0002>\n=\u0002\u0019\u0001\u000f\t\u0011\t\u001d!q\u0006a\u0001\u0003+BqAa\u0011\u001b\t#\ty$A\nj]&$\u0018.\u00197jg\u0016\u001c\u0015\r\\3oI\u0006\u00148\u000f\u0003\u0006\u0003HiA)\u0019!C\t\u0005\u0013\n!\u0002\u001e5sK\u0006$\u0007k\\8m+\t\u0011Y\u0005\u0005\u0003\u0003N\tMSB\u0001B(\u0015\u0011\u0011\t&!\f\u0002\u000bMLW\u000e\u001d7\n\t\tU#q\n\u0002\u0011'&l\u0007\u000f\\3UQJ,\u0017\r\u001a)p_2D!B!\u0017\u001b\u0011\u000b\u0007I\u0011\u0003B.\u0003!QwNY*u_J,WC\u0001B/!\u0011\u0011iEa\u0018\n\t\t\u0005$q\n\u0002\f%\u0006k%j\u001c2Ti>\u0014X\r\u0003\u0006\u0003fiA)\u0019!C\t\u0005O\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0005\t%\u0004\u0003BA\u0016\u0005WJAA!\u001c\u0002.\tI1k\u00195fIVdWM\u001d\u0005\n\u0005cR\u0012\u0013!C\u0001\u0005g\n!c\u001d5vi\u0012|wO\u001c\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!Q\u000f\u0016\u0004E\n]4F\u0001B=!\u0011\u0011YH!\"\u000e\u0005\tu$\u0002\u0002B@\u0005\u0003\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\re$\u0001\u0006b]:|G/\u0019;j_:LAAa\"\u0003~\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t-%$%A\u0005\u0002\t5\u0015\u0001G2sK\u0006$XmU2iK\u0012,H.\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0012\u0016\u0005\u00037\u00139\bC\u0005\u0003\u0014j\t\n\u0011\"\u0001\u0003\u000e\u0006A2M]3bi\u0016\u001c6\r[3ek2,G\u0005Z3gCVdG\u000f\n\u001b\t\u0013\t]%$%A\u0005\u0002\te\u0015\u0001G2sK\u0006$XmU2iK\u0012,H.\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!1\u0014\u0016\u0004U\n]\u0004\"\u0003BP5E\u0005I\u0011\u0001BG\u0003]\u0011Xm]2iK\u0012,H.\u001a&pE\u0012\"WMZ1vYR$C\u0007C\u0005\u0003$j\t\n\u0011\"\u0001\u0003\u000e\u00069\"/Z:dQ\u0016$W\u000f\\3K_\n$C-\u001a4bk2$HE\u000e\u0005\n\u0005OS\u0012\u0013!C\u0001\u00053\u000bqC]3tG\",G-\u001e7f\u0015>\u0014G\u0005Z3gCVdG\u000fJ\u001c\t\r-zA\u0011\u0001BV)\u0005i\u0001b\u0002BX\u001f\u0011\u0005#\u0011W\u0001\u0004O\u0016$HcA\r\u00034\"9aE!,A\u0002\tU\u0006cA\n\u00038&\u0019!\u0011\u0018\u000b\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c")
public class QuartzSchedulerExtension
implements Extension {
    private Config defaultConfig;
    private SimpleThreadPool threadPool;
    private RAMJobStore jobStore;
    private Scheduler scheduler;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final Config config;
    private final int threadCount;
    private final int threadPriority;
    private final boolean daemonThreads_$qmark;
    private final TimeZone defaultTimezone;
    private scala.collection.immutable.Map<String, QuartzSchedule> schedules;
    private final scala.collection.mutable.Map<String, JobKey> runningJobs;
    private volatile byte bitmap$0;

    public static QuartzSchedulerExtension get(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.get(actorSystem);
    }

    public static Extension get(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.apply(actorSystem);
    }

    public static Extension createExtension(ExtendedActorSystem extendedActorSystem) {
        return QuartzSchedulerExtension$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ExtensionId<QuartzSchedulerExtension> lookup() {
        return QuartzSchedulerExtension$.MODULE$.lookup();
    }

    private LoggingAdapter log() {
        return this.log;
    }

    public String schedulerName() {
        return new StringOps(Predef$.MODULE$.augmentString("QuartzScheduler~%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.system.name()}));
    }

    public Config config() {
        return this.config;
    }

    private Config defaultConfig$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.defaultConfig = ConfigFactory.parseString((String)new StringOps(Predef$.MODULE$.augmentString("\n    akka.quartz {\n      threadPool {\n        threadCount = 1\n        threadPriority = 5\n        daemonThreads = true\n      }\n      defaultTimezone = UTC\n    }\n                                                      ")).stripMargin());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.defaultConfig;
    }

    public Config defaultConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.defaultConfig$lzycompute() : this.defaultConfig;
    }

    public int threadCount() {
        return this.threadCount;
    }

    public int threadPriority() {
        return this.threadPriority;
    }

    public boolean daemonThreads_$qmark() {
        return this.daemonThreads_$qmark;
    }

    public TimeZone defaultTimezone() {
        return this.defaultTimezone;
    }

    public scala.collection.immutable.Map<String, QuartzSchedule> schedules() {
        return this.schedules;
    }

    public void schedules_$eq(scala.collection.immutable.Map<String, QuartzSchedule> x$1) {
        this.schedules = x$1;
    }

    public scala.collection.mutable.Map<String, JobKey> runningJobs() {
        return this.runningJobs;
    }

    public void standby() {
        this.scheduler().standby();
    }

    public boolean isInStandbyMode() {
        return this.scheduler().isInStandbyMode();
    }

    public boolean start() {
        boolean bl;
        boolean bl2 = this.isStarted();
        if (bl2) {
            this.log().warning("Cannot start scheduler, already started.");
            bl = false;
        } else if (!bl2) {
            this.scheduler().start();
            bl = true;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl2));
        }
        return bl;
    }

    public boolean isStarted() {
        return this.scheduler().isStarted();
    }

    public Option<Date> nextTrigger(String name) {
        return this.runningJobs().get((Object)name).flatMap((Function1 & Serializable & scala.Serializable)jobKey -> ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.scheduler().getTriggersOfJob(jobKey)).asScala()).headOption().map((Function1 & Serializable & scala.Serializable)trigger -> trigger.getNextFireTime()));
    }

    public void suspendAll() {
        this.log().info("Suspending all Quartz jobs.");
        this.scheduler().pauseAll();
    }

    public void shutdown(boolean waitForJobsToComplete) {
        this.scheduler().shutdown(waitForJobsToComplete);
    }

    public boolean shutdown$default$1() {
        return false;
    }

    public boolean suspendJob(String name) {
        boolean bl;
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Suspending Quartz Job '{}'", (Object)name);
            this.scheduler().pauseJob(job);
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot suspend", (Object)name);
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public boolean resumeJob(String name) {
        boolean bl;
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Resuming Quartz Job '{}'", (Object)name);
            this.scheduler().resumeJob(job);
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot unpause", (Object)name);
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public void resumeAll() {
        this.log().info("Resuming all Quartz jobs.");
        this.scheduler().resumeAll();
    }

    public boolean cancelJob(String name) {
        boolean bl;
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Cancelling Quartz Job '{}'", (Object)name);
            boolean result = this.scheduler().deleteJob(job);
            this.runningJobs().$minus$eq((Object)name);
            bl = result;
        } else if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot cancel", (Object)name);
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public void createSchedule(String name, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        CronExpression cronExpression2;
        Option option = this.schedules().get((Object)name.toUpperCase());
        if (option instanceof Some) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A schedule with this name already exists: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
        if (None$.MODULE$.equals(option)) {
            CronExpression expr;
            Either either = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ParseException.class})).either((Function0 & Serializable & scala.Serializable)() -> new CronExpression(cronExpression));
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable t = (Throwable)left.value();
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid 'expression' for Cron Schedule '", "'. Failed to validate CronExpression."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
            }
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            cronExpression2 = expr = (CronExpression)right.value();
        } else {
            throw new MatchError((Object)option);
        }
        CronExpression expression = cronExpression2;
        QuartzCronSchedule quartzSchedule = new QuartzCronSchedule(name, description, expression, timezone, calendar);
        this.schedules_$eq((scala.collection.immutable.Map<String, QuartzSchedule>)this.schedules().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name.toUpperCase()), (Object)quartzSchedule)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Option<String> createSchedule$default$2() {
        return None$.MODULE$;
    }

    public Option<String> createSchedule$default$4() {
        return None$.MODULE$;
    }

    public TimeZone createSchedule$default$5() {
        return this.defaultTimezone();
    }

    public Date rescheduleJob(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        this.cancelJob(name);
        this.removeSchedule(name);
        this.createSchedule(name, description, cronExpression, calendar, timezone);
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Option<String> rescheduleJob$default$4() {
        return None$.MODULE$;
    }

    public Option<String> rescheduleJob$default$6() {
        return None$.MODULE$;
    }

    public TimeZone rescheduleJob$default$7() {
        return this.defaultTimezone();
    }

    private void removeSchedule(String name) {
        this.schedules_$eq((scala.collection.immutable.Map<String, QuartzSchedule>)((scala.collection.immutable.Map)this.schedules().$minus((Object)name.toUpperCase())));
    }

    public Date schedule(String name, ActorRef receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, EventStream receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, ActorRef receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, EventStream receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    private Date scheduleInternal(String name, Object receiver, Object msg, Option<Date> startDate) {
        Option option = this.schedules().get((Object)name.toUpperCase());
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("No matching quartz configuration found for schedule '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        QuartzSchedule schedule = (QuartzSchedule)some.value();
        Date date = this.scheduleJob(name, receiver, msg, startDate, schedule);
        return date;
    }

    public Date scheduleJob(String name, Object receiver, Object msg, Option<Date> startDate, QuartzSchedule schedule) {
        this.log().info("Setting up scheduled job '{}', with '{}'", (Object)name, (Object)schedule);
        scala.collection.immutable.Map jobDataMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logBus"), (Object)this.system.eventStream()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"receiver"), receiver), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), msg)}));
        JobDataMap jobData = JobDataMapSupport.newJobDataMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)jobDataMap).asJava()));
        JobDetail job = JobBuilder.newJob(SimpleActorMessageJob.class).withIdentity(name + "_Job").usingJobData(jobData).withDescription((String)schedule.description().orNull(Predef$.MODULE$.$conforms())).build();
        this.log().debug("Adding jobKey {} to runningJobs map.", (Object)job.getKey());
        this.runningJobs().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)job.getKey()));
        this.log().debug("Building Trigger with startDate '{}", startDate.getOrElse((Function0 & Serializable & scala.Serializable)() -> new Date()));
        Trigger trigger = schedule.buildTrigger(name, startDate);
        this.log().debug("Scheduling Job '{}' and Trigger '{}'. Is Scheduler Running? {}", (Object)job, (Object)trigger, (Object)BoxesRunTime.boxToBoolean((boolean)this.scheduler().isStarted()));
        return this.scheduler().scheduleJob(job, trigger);
    }

    public void initialiseCalendars() {
        QuartzCalendars$.MODULE$.apply(this.config(), this.defaultTimezone()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)QuartzSchedulerExtension.$anonfun$initialiseCalendars$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            QuartzSchedulerExtension.$anonfun$initialiseCalendars$2(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private SimpleThreadPool threadPool$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                void var2_2;
                SimpleThreadPool _tp = new SimpleThreadPool(this.threadCount(), this.threadPriority());
                _tp.setThreadNamePrefix("AKKA_QRTZ_");
                _tp.setMakeThreadsDaemons(this.daemonThreads_$qmark());
                this.threadPool = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.threadPool;
    }

    public SimpleThreadPool threadPool() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.threadPool$lzycompute() : this.threadPool;
    }

    private RAMJobStore jobStore$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.jobStore = new RAMJobStore();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.jobStore;
    }

    public RAMJobStore jobStore() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.jobStore$lzycompute() : this.jobStore;
    }

    /*
     * WARNING - void declaration
     */
    private Scheduler scheduler$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                void var2_2;
                DirectSchedulerFactory.getInstance().createScheduler(this.schedulerName(), this.system.name(), (ThreadPool)this.threadPool(), (JobStore)this.jobStore());
                Scheduler scheduler = DirectSchedulerFactory.getInstance().getScheduler(this.schedulerName());
                this.log().debug("Initialized a Quartz Scheduler '{}'", (Object)scheduler);
                this.system.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    this.log().info("Shutting down Quartz Scheduler with ActorSystem Termination (Any jobs awaiting completion will end as well, as actors are ending)...");
                    scheduler.shutdown(false);
                });
                this.scheduler = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.scheduler;
    }

    public Scheduler scheduler() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.scheduler$lzycompute() : this.scheduler;
    }

    public static final /* synthetic */ boolean $anonfun$initialiseCalendars$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$initialiseCalendars$2(QuartzSchedulerExtension $this, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        Calendar calendar = (Calendar)tuple2._2();
        $this.log().info("Configuring Calendar '{}'", (Object)name);
        $this.scheduler().addCalendar(name.toUpperCase(), calendar, true, true);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public QuartzSchedulerExtension(ExtendedActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, (Object)this, package$.MODULE$.quartzExtensionLoggerType());
        this.config = system.settings().config().withFallback((ConfigMergeable)this.defaultConfig()).getConfig("akka.quartz").root().toConfig();
        this.threadCount = this.config().getInt("threadPool.threadCount");
        this.threadPriority = this.config().getInt("threadPool.threadPriority");
        Predef$.MODULE$.require(this.threadPriority() >= 1 && this.threadPriority() <= 10, (Function0 & Serializable & scala.Serializable)() -> "Quartz Thread Priority (akka.quartz.threadPool.threadPriority) must be a positive integer between 1 (lowest) and 10 (highest).");
        this.daemonThreads_$qmark = this.config().getBoolean("threadPool.daemonThreads");
        this.defaultTimezone = TimeZone.getTimeZone(this.config().getString("defaultTimezone"));
        this.schedules = (scala.collection.immutable.Map)QuartzSchedules$.MODULE$.apply(this.config(), this.defaultTimezone()).map((Function1 & Serializable & scala.Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((String)kv._1()).toUpperCase()), kv._2()), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        this.runningJobs = Map$.MODULE$.empty();
        this.log().debug("Configured Schedules: {}", this.schedules());
        this.scheduler().start();
        this.initialiseCalendars();
    }
}

