/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.snapshot.local;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.SupervisorStrategy;
import akka.dispatch.MessageDispatcher;
import akka.event.LoggingAdapter;
import akka.pattern.CircuitBreaker;
import akka.persistence.DeleteSnapshotsFailure;
import akka.persistence.DeleteSnapshotsSuccess;
import akka.persistence.Persistence;
import akka.persistence.SaveSnapshotFailure;
import akka.persistence.SaveSnapshotSuccess;
import akka.persistence.SelectedSnapshot;
import akka.persistence.SnapshotMetadata;
import akka.persistence.SnapshotMetadata$;
import akka.persistence.SnapshotSelectionCriteria;
import akka.persistence.serialization.Snapshot;
import akka.persistence.serialization.package$;
import akka.persistence.snapshot.SnapshotStore;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.util.ByteString$;
import akka.util.Helpers;
import akka.util.Helpers$;
import com.typesafe.config.Config;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t]h!B\u0001\u0003\u0001\u0019Q!A\u0005'pG\u0006d7K\\1qg\"|Go\u0015;pe\u0016T!a\u0001\u0003\u0002\u000b1|7-\u00197\u000b\u0005\u00151\u0011\u0001C:oCB\u001c\bn\u001c;\u000b\u0005\u001dA\u0011a\u00039feNL7\u000f^3oG\u0016T\u0011!C\u0001\u0005C.\\\u0017m\u0005\u0003\u0001\u0017E)\u0002C\u0001\u0007\u0010\u001b\u0005i!\"\u0001\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ai!AB!osJ+g\r\u0005\u0002\u0013'5\tA!\u0003\u0002\u0015\t\ti1K\\1qg\"|Go\u0015;pe\u0016\u0004\"AF\r\u000e\u0003]Q!\u0001\u0007\u0005\u0002\u000b\u0005\u001cGo\u001c:\n\u0005i9\"\u0001D!di>\u0014Hj\\4hS:<\u0007\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\r\r|gNZ5h\u0007\u0001\u0001\"aH\u0013\u000e\u0003\u0001R!\u0001H\u0011\u000b\u0005\t\u001a\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u0011\n1aY8n\u0013\t1\u0003E\u0001\u0004D_:4\u0017n\u001a\u0005\u0006Q\u0001!\t!K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005)b\u0003CA\u0016\u0001\u001b\u0005\u0011\u0001\"\u0002\u000f(\u0001\u0004q\u0002b\u0002\u0018\u0001\u0005\u0004%IaL\u0001\u0010\r&dWM\\1nKB\u000bG\u000f^3s]V\t\u0001\u0007\u0005\u00022m5\t!G\u0003\u00024i\u0005AQ.\u0019;dQ&twM\u0003\u00026\u001b\u0005!Q\u000f^5m\u0013\t9$GA\u0003SK\u001e,\u0007\u0010\u0003\u0004:\u0001\u0001\u0006I\u0001M\u0001\u0011\r&dWM\\1nKB\u000bG\u000f^3s]\u0002Bqa\u000f\u0001C\u0002\u0013%A(A\u000bqKJ\u001c\u0018n\u001d;f]\u000e,\u0017\nZ*uCJ$\u0018\n\u001a=\u0016\u0003u\u0002\"\u0001\u0004 \n\u0005}j!aA%oi\"1\u0011\t\u0001Q\u0001\nu\na\u0003]3sg&\u001cH/\u001a8dK&#7\u000b^1si&#\u0007\u0010\t\u0005\b\u0007\u0002\u0011\r\u0011\"\u0003=\u0003=i\u0017\r\u001f'pC\u0012\fE\u000f^3naR\u001c\bBB#\u0001A\u0003%Q(\u0001\tnCbdu.\u00193BiR,W\u000e\u001d;tA!9q\t\u0001b\u0001\n\u0013A\u0015\u0001E:ue\u0016\fW\u000eR5ta\u0006$8\r[3s+\u0005I\u0005C\u0001&N\u001b\u0005Y%B\u0001'\t\u0003!!\u0017n\u001d9bi\u000eD\u0017B\u0001(L\u0005EiUm]:bO\u0016$\u0015n\u001d9bi\u000eDWM\u001d\u0005\u0007!\u0002\u0001\u000b\u0011B%\u0002#M$(/Z1n\t&\u001c\b/\u0019;dQ\u0016\u0014\b\u0005C\u0004S\u0001\t\u0007I\u0011B*\u0002\u0007\u0011L'/F\u0001U!\t)&,D\u0001W\u0015\t9\u0006,\u0001\u0002j_*\t\u0011,\u0001\u0003kCZ\f\u0017BA.W\u0005\u00111\u0015\u000e\\3\t\ru\u0003\u0001\u0015!\u0003U\u0003\u0011!\u0017N\u001d\u0011\t\u000f}\u0003!\u0019!C\u0005A\u000612/\u001a:jC2L'0\u0019;j_:,\u0005\u0010^3og&|g.F\u0001b!\t\u0011W-D\u0001d\u0015\t!\u0007\"A\u0007tKJL\u0017\r\\5{CRLwN\\\u0005\u0003M\u000e\u0014QbU3sS\u0006d\u0017N_1uS>t\u0007B\u00025\u0001A\u0003%\u0011-A\ftKJL\u0017\r\\5{CRLwN\\#yi\u0016t7/[8oA!9!\u000e\u0001a\u0001\n\u0013Y\u0017AB:bm&tw-F\u0001m!\ri'\u000f^\u0007\u0002]*\u0011q\u000e]\u0001\nS6lW\u000f^1cY\u0016T!!]\u0007\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002t]\n\u00191+\u001a;\u0011\u0005U4X\"\u0001\u0004\n\u0005]4!\u0001E*oCB\u001c\bn\u001c;NKR\fG-\u0019;b\u0011\u001dI\b\u00011A\u0005\ni\f!b]1wS:<w\fJ3r)\tYh\u0010\u0005\u0002\ry&\u0011Q0\u0004\u0002\u0005+:LG\u000fC\u0004\u0000q\u0006\u0005\t\u0019\u00017\u0002\u0007a$\u0013\u0007C\u0004\u0002\u0004\u0001\u0001\u000b\u0015\u00027\u0002\u000fM\fg/\u001b8hA!9\u0011q\u0001\u0001\u0005B\u0005%\u0011!\u00037pC\u0012\f5/\u001f8d)\u0019\tY!a\t\u0002>A1\u0011QBA\n\u0003/i!!a\u0004\u000b\u0007\u0005EQ\"\u0001\u0006d_:\u001cWO\u001d:f]RLA!!\u0006\u0002\u0010\t1a)\u001e;ve\u0016\u0004R\u0001DA\r\u0003;I1!a\u0007\u000e\u0005\u0019y\u0005\u000f^5p]B\u0019Q/a\b\n\u0007\u0005\u0005bA\u0001\tTK2,7\r^3e':\f\u0007o\u001d5pi\"A\u0011QEA\u0003\u0001\u0004\t9#A\u0007qKJ\u001c\u0018n\u001d;f]\u000e,\u0017\n\u001a\t\u0005\u0003S\t9D\u0004\u0003\u0002,\u0005M\u0002cAA\u0017\u001b5\u0011\u0011q\u0006\u0006\u0004\u0003ci\u0012A\u0002\u001fs_>$h(C\u0002\u000265\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u001d\u0003w\u0011aa\u0015;sS:<'bAA\u001b\u001b!A\u0011qHA\u0003\u0001\u0004\t\t%\u0001\u0005de&$XM]5b!\r)\u00181I\u0005\u0004\u0003\u000b2!!G*oCB\u001c\bn\u001c;TK2,7\r^5p]\u000e\u0013\u0018\u000e^3sS\u0006Dq!!\u0013\u0001\t\u0003\nY%A\u0005tCZ,\u0017i]=oGR1\u0011QJA(\u0003'\u0002R!!\u0004\u0002\u0014mDq!!\u0015\u0002H\u0001\u0007A/\u0001\u0005nKR\fG-\u0019;b\u0011\u001d)\u0011q\ta\u0001\u0003+\u00022\u0001DA,\u0013\r\tI&\u0004\u0002\u0004\u0003:L\bbBA/\u0001\u0011\u0005\u0013qL\u0001\fI\u0016dW\r^3Bgft7\r\u0006\u0003\u0002N\u0005\u0005\u0004bBA)\u00037\u0002\r\u0001\u001e\u0005\b\u0003;\u0002A\u0011IA3)\u0019\ti%a\u001a\u0002j!A\u0011QEA2\u0001\u0004\t9\u0003\u0003\u0005\u0002@\u0005\r\u0004\u0019AA!\u0011\u001d\ti\u0007\u0001C!\u0003_\nQC]3dK&4X\r\u00157vO&t\u0017J\u001c;fe:\fG.\u0006\u0002\u0002rA!\u00111OA;\u001b\u0005\u0001\u0011\u0002BA<\u0003s\u0012qAU3dK&4X-C\u0002\u0002|]\u0011Q!Q2u_JDq!a \u0001\t\u0013\t\t)A\u0007t]\u0006\u00048\u000f[8u\r&dWm\u001d\u000b\u0005\u0003\u0007\u000bI\t\u0005\u0003n\u0003\u000b#\u0016bAAD]\n\u00191+Z9\t\u000f\u0005E\u0013Q\u0010a\u0001i\"9\u0011Q\u0012\u0001\u0005\n\u0005=\u0015\u0001\u00027pC\u0012$B!!%\u0002\u001aB1\u00111SAK\u0003/i\u0011\u0001N\u0005\u0004\u0003/#$a\u0001+ss\"A\u0011\u0011KAF\u0001\u0004\tY\n\u0005\u0003n\u0003\u000b#\b\u0006BAF\u0003?\u0003B!!)\u0002(6\u0011\u00111\u0015\u0006\u0004\u0003Kk\u0011AC1o]>$\u0018\r^5p]&!\u0011\u0011VAR\u0005\u001d!\u0018-\u001b7sK\u000eDq!!,\u0001\t#\ty+\u0001\u0003tCZ,G#B>\u00022\u0006M\u0006bBA)\u0003W\u0003\r\u0001\u001e\u0005\b\u000b\u0005-\u0006\u0019AA+\u0011\u001d\t9\f\u0001C\t\u0003s\u000b1\u0002Z3tKJL\u0017\r\\5{KR!\u00111XAc!\u0011\ti,!1\u000e\u0005\u0005}&B\u00013\u0007\u0013\u0011\t\u0019-a0\u0003\u0011Ms\u0017\r]:i_RD\u0001\"a2\u00026\u0002\u0007\u0011\u0011Z\u0001\fS:\u0004X\u000f^*ue\u0016\fW\u000eE\u0002V\u0003\u0017L1!!4W\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000f\u0005E\u0007\u0001\"\u0005\u0002T\u0006I1/\u001a:jC2L'0\u001a\u000b\u0006w\u0006U\u0017q\u001c\u0005\t\u0003/\fy\r1\u0001\u0002Z\u0006aq.\u001e;qkR\u001cFO]3b[B\u0019Q+a7\n\u0007\u0005ugK\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0006\u0003\u001f\u0004\r!a/\t\u000f\u0005\r\b\u0001\"\u0005\u0002f\u0006\u0001r/\u001b;i\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u000b\u0005\u0003O\f\u0019\u0010F\u0002U\u0003SD\u0001\"a;\u0002b\u0002\u0007\u0011Q^\u0001\u0002aB1A\"a<\u0002ZnL1!!=\u000e\u0005%1UO\\2uS>t\u0017\u0007C\u0004\u0002R\u0005\u0005\b\u0019\u0001;\t\u000f\u0005]\b\u0001\"\u0003\u0002z\u0006yq/\u001b;i\u0013:\u0004X\u000f^*ue\u0016\fW.\u0006\u0003\u0002|\n\rA\u0003BA\u007f\u0005'!B!a@\u0003\u0010A!!\u0011\u0001B\u0002\u0019\u0001!\u0001B!\u0002\u0002v\n\u0007!q\u0001\u0002\u0002)F!!\u0011BA+!\ra!1B\u0005\u0004\u0005\u001bi!a\u0002(pi\"Lgn\u001a\u0005\t\u0003W\f)\u00101\u0001\u0003\u0012A9A\"a<\u0002J\u0006}\bbBA)\u0003k\u0004\r\u0001\u001e\u0005\b\u0005/\u0001A\u0011\u0002B\r\u0003)9\u0018\u000e\u001e5TiJ,\u0017-\\\u000b\u0007\u00057\u0011ICa\b\u0015\r\tu!1\u0005B\u001b!\u0011\u0011\tAa\b\u0005\u0011\t\u0005\"Q\u0003b\u0001\u0005\u000f\u0011\u0011A\u0011\u0005\t\u0005K\u0011)\u00021\u0001\u0003(\u000511\u000f\u001e:fC6\u0004BA!\u0001\u0003*\u0011A!1\u0006B\u000b\u0005\u0004\u0011iCA\u0001B#\u0011\u0011IAa\f\u0011\u0007U\u0013\t$C\u0002\u00034Y\u0013\u0011b\u00117pg\u0016\f'\r\\3\t\u0011\u0005-(Q\u0003a\u0001\u0005o\u0001r\u0001DAx\u0005O\u0011i\u0002C\u0004\u0003<\u0001!\tB!\u0010\u0002)Mt\u0017\r]:i_R4\u0015\u000e\\3G_J<&/\u001b;f)\u0015!&q\bB!\u0011\u001d\t\tF!\u000fA\u0002QD!Ba\u0011\u0003:A\u0005\t\u0019AA\u0014\u0003%)\u0007\u0010^3og&|g\u000eC\u0004\u0003H\u0001!IA!\u0013\u0002#Mt\u0017\r]:i_RlU\r^1eCR\f7\u000f\u0006\u0004\u0002\u001c\n-#Q\n\u0005\t\u0003K\u0011)\u00051\u0001\u0002(!A\u0011q\bB#\u0001\u0004\t\t\u0005C\u0004\u0003R\u0001!\tEa\u0015\u0002\u0011A\u0014Xm\u0015;beR$\u0012a\u001f\u0005\b\u0005/\u0002A\u0011\u0002B-\u0003-\u0019h.\u00199tQ>$H)\u001b:\u0015\u0003Q3aA!\u0018\u0001\r\t}#AF*oCB\u001c\bn\u001c;GS2,g.Y7f\r&dG/\u001a:\u0014\r\tm#\u0011\rB7!\u0011\u0011\u0019G!\u001b\u000e\u0005\t\u0015$b\u0001B41\u0006!A.\u00198h\u0013\u0011\u0011YG!\u001a\u0003\r=\u0013'.Z2u!\r)&qN\u0005\u0004\u0005c2&A\u0004$jY\u0016t\u0017-\\3GS2$XM\u001d\u0005\f\u0003K\u0011YF!A!\u0002\u0013\t9\u0003C\u0004)\u00057\"\tAa\u001e\u0015\t\te$1\u0010\t\u0005\u0003g\u0012Y\u0006\u0003\u0005\u0002&\tU\u0004\u0019AA\u0014\u0011)\u0011yHa\u0017C\u0002\u0013\u0005!\u0011Q\u0001\u0015K:\u001cw\u000eZ3e!\u0016\u00148/[:uK:\u001cW-\u00133\u0016\u0005\t\r\u0005\u0003\u0002B2\u0005\u000bKA!!\u000f\u0003f!I!\u0011\u0012B.A\u0003%!1Q\u0001\u0016K:\u001cw\u000eZ3e!\u0016\u00148/[:uK:\u001cW-\u00133!\u0011!\u0011iIa\u0017\u0005\u0002\t=\u0015AB1dG\u0016\u0004H\u000f\u0006\u0004\u0003\u0012\n]%\u0011\u0014\t\u0004\u0019\tM\u0015b\u0001BK\u001b\t9!i\\8mK\u0006t\u0007B\u0002*\u0003\f\u0002\u0007A\u000b\u0003\u0005\u0003\u001c\n-\u0005\u0019AA\u0014\u0003\u0011q\u0017-\\3\u0007\r\t}\u0005A\u0002BQ\u0005m\u0019f.\u00199tQ>$8+Z9Oe\u001aKG.\u001a8b[\u00164\u0015\u000e\u001c;feN1!Q\u0014B1\u0005[B!B!*\u0003\u001e\n\u0005\t\u0015!\u0003u\u0003\tiG\rC\u0004)\u0005;#\tA!+\u0015\t\t-&Q\u0016\t\u0005\u0003g\u0012i\nC\u0004\u0003&\n\u001d\u0006\u0019\u0001;\t\u0011\tE&Q\u0014C\u0007\u0005g\u000bq!\\1uG\",7\u000f\u0006\u0005\u0003\u0012\nU&\u0011\u0018B_\u0011!\u00119La,A\u0002\u0005\u001d\u0012a\u00019jI\"A!1\u0018BX\u0001\u0004\t9#A\u0002t]JD\u0001Ba0\u00030\u0002\u0007\u0011qE\u0001\u0004i6\u001c\b\u0002\u0003BG\u0005;#\tAa1\u0015\r\tE%Q\u0019Bd\u0011\u0019\u0011&\u0011\u0019a\u0001)\"A!1\u0014Ba\u0001\u0004\t9\u0003C\u0004\u0003L\u0002!IA!4\u0002\u001f\u0015DHO]1di6+G/\u00193bi\u0006$BAa4\u0003^B)A\"!\u0007\u0003RBIABa5\u0002(\t]'q[\u0005\u0004\u0005+l!A\u0002+va2,7\u0007E\u0002\r\u00053L1Aa7\u000e\u0005\u0011auN\\4\t\u0011\t}'\u0011\u001aa\u0001\u0003O\t\u0001BZ5mK:\fW.\u001a\u0005\n\u0005G\u0004\u0011\u0013!C\t\u0005K\fad\u001d8baNDw\u000e\u001e$jY\u00164uN],sSR,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u001d(\u0006BA\u0014\u0005S\\#Aa;\u0011\t\t5(1_\u0007\u0003\u0005_TAA!=\u0002$\u0006IQO\\2iK\u000e\\W\rZ\u0005\u0005\u0005k\u0014yOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class LocalSnapshotStore
implements SnapshotStore {
    private final Regex akka$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern;
    private final int akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx;
    private final int maxLoadAttempts;
    private final MessageDispatcher streamDispatcher;
    private final File dir;
    private final Serialization serializationExtension;
    private Set<SnapshotMetadata> akka$persistence$snapshot$local$LocalSnapshotStore$$saving;
    private final Persistence akka$persistence$snapshot$SnapshotStore$$extension;
    private final boolean akka$persistence$snapshot$SnapshotStore$$publish;
    private final CircuitBreaker akka$persistence$snapshot$SnapshotStore$$breaker;
    private final PartialFunction<Object, BoxedUnit> receiveSnapshotStore;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public final PartialFunction<Object, BoxedUnit> receive() {
        return SnapshotStore.receive$(this);
    }

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void postStop() throws Exception {
        Actor.postStop$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    @Override
    public Persistence akka$persistence$snapshot$SnapshotStore$$extension() {
        return this.akka$persistence$snapshot$SnapshotStore$$extension;
    }

    @Override
    public boolean akka$persistence$snapshot$SnapshotStore$$publish() {
        return this.akka$persistence$snapshot$SnapshotStore$$publish;
    }

    @Override
    public CircuitBreaker akka$persistence$snapshot$SnapshotStore$$breaker() {
        return this.akka$persistence$snapshot$SnapshotStore$$breaker;
    }

    @Override
    public final PartialFunction<Object, BoxedUnit> receiveSnapshotStore() {
        return this.receiveSnapshotStore;
    }

    @Override
    public final void akka$persistence$snapshot$SnapshotStore$_setter_$akka$persistence$snapshot$SnapshotStore$$extension_$eq(Persistence x$1) {
        this.akka$persistence$snapshot$SnapshotStore$$extension = x$1;
    }

    @Override
    public final void akka$persistence$snapshot$SnapshotStore$_setter_$akka$persistence$snapshot$SnapshotStore$$publish_$eq(boolean x$1) {
        this.akka$persistence$snapshot$SnapshotStore$$publish = x$1;
    }

    @Override
    public final void akka$persistence$snapshot$SnapshotStore$_setter_$akka$persistence$snapshot$SnapshotStore$$breaker_$eq(CircuitBreaker x$1) {
        this.akka$persistence$snapshot$SnapshotStore$$breaker = x$1;
    }

    @Override
    public final void akka$persistence$snapshot$SnapshotStore$_setter_$receiveSnapshotStore_$eq(PartialFunction<Object, BoxedUnit> x$1) {
        this.receiveSnapshotStore = x$1;
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Regex akka$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern() {
        return this.akka$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern;
    }

    public int akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx() {
        return this.akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx;
    }

    private int maxLoadAttempts() {
        return this.maxLoadAttempts;
    }

    private MessageDispatcher streamDispatcher() {
        return this.streamDispatcher;
    }

    private File dir() {
        return this.dir;
    }

    private Serialization serializationExtension() {
        return this.serializationExtension;
    }

    public Set<SnapshotMetadata> akka$persistence$snapshot$local$LocalSnapshotStore$$saving() {
        return this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving;
    }

    public void akka$persistence$snapshot$local$LocalSnapshotStore$$saving_$eq(Set<SnapshotMetadata> x$1) {
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving = x$1;
    }

    @Override
    public Future<Option<SelectedSnapshot>> loadAsync(String persistenceId, SnapshotSelectionCriteria criteria) {
        scala.collection.immutable.Seq metadata = (scala.collection.immutable.Seq)((IterableLike)this.snapshotMetadatas(persistenceId, criteria).sorted(SnapshotMetadata$.MODULE$.ordering())).takeRight(this.maxLoadAttempts());
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Option s;
            Try<Option<SelectedSnapshot>> try_ = this.load((scala.collection.immutable.Seq<SnapshotMetadata>)metadata);
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    throw e;
                }
                throw new MatchError(try_);
            }
            Success success = (Success)try_;
            Option option = s = (Option)success.value();
            return option;
        }, (ExecutionContext)this.streamDispatcher());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Future<BoxedUnit> saveAsync(SnapshotMetadata metadata, Object snapshot) {
        void var3_3;
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving_$eq((Set<SnapshotMetadata>)((Set)this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving().$plus((Object)metadata)));
        Future completion = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.save(metadata, snapshot), (ExecutionContext)this.streamDispatcher());
        return var3_3;
    }

    @Override
    public Future<BoxedUnit> deleteAsync(SnapshotMetadata metadata) {
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving_$eq((Set<SnapshotMetadata>)((Set)this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving().$minus((Object)metadata)));
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Seq)this.snapshotFiles(metadata).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.delete()), Seq$.MODULE$.canBuildFrom()), (ExecutionContext)this.streamDispatcher()).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            LocalSnapshotStore.$anonfun$deleteAsync$3(x$3);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.streamDispatcher());
    }

    @Override
    public Future<BoxedUnit> deleteAsync(String persistenceId, SnapshotSelectionCriteria criteria) {
        scala.collection.immutable.Seq<SnapshotMetadata> metadatas = this.snapshotMetadatas(persistenceId, criteria);
        return Future$.MODULE$.sequence((TraversableOnce)metadatas.map((Function1 & Serializable & scala.Serializable)metadata -> this.deleteAsync((SnapshotMetadata)metadata), Seq$.MODULE$.canBuildFrom()), scala.collection.package$.MODULE$.breakOut(Predef$.MODULE$.fallbackStringCanBuildFrom()), (ExecutionContext)this.streamDispatcher()).map((Function1 & Serializable & scala.Serializable)x$4 -> {
            LocalSnapshotStore.$anonfun$deleteAsync$5(x$4);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.streamDispatcher());
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receivePluginInternal() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LocalSnapshotStore $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof SaveSnapshotSuccess) {
                    SaveSnapshotSuccess saveSnapshotSuccess = (SaveSnapshotSuccess)A1;
                    SnapshotMetadata metadata = saveSnapshotSuccess.metadata();
                    this.$outer.akka$persistence$snapshot$local$LocalSnapshotStore$$saving_$eq((Set<SnapshotMetadata>)((Set)this.$outer.akka$persistence$snapshot$local$LocalSnapshotStore$$saving().$minus((Object)metadata)));
                    object = BoxedUnit.UNIT;
                } else {
                    object = A1 instanceof SaveSnapshotFailure ? BoxedUnit.UNIT : (A1 instanceof DeleteSnapshotsSuccess ? BoxedUnit.UNIT : (A1 instanceof DeleteSnapshotsFailure ? BoxedUnit.UNIT : function1.apply(x1)));
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof SaveSnapshotSuccess ? true : (object instanceof SaveSnapshotFailure ? true : (object instanceof DeleteSnapshotsSuccess ? true : object instanceof DeleteSnapshotsFailure));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private scala.collection.immutable.Seq<File> snapshotFiles(SnapshotMetadata metadata) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.snapshotDir().listFiles(new SnapshotSeqNrFilenameFilter(this, metadata)))).toVector();
    }

    private Try<Option<SelectedSnapshot>> load(scala.collection.immutable.Seq<SnapshotMetadata> metadata) {
        Success success;
        block3: {
            Option option;
            block4: {
                Success success2;
                block5: {
                    Try try_;
                    block6: {
                        Throwable e;
                        while (true) {
                            if (None$.MODULE$.equals(option = metadata.lastOption())) {
                                success = new Success((Object)None$.MODULE$);
                                break block3;
                            }
                            if (!(option instanceof Some)) break block4;
                            Some some = (Some)option;
                            SnapshotMetadata md = (SnapshotMetadata)some.value();
                            try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Snapshot)this.withInputStream(md, (Function1 & Serializable & scala.Serializable)inputStream -> this.deserialize((InputStream)inputStream)));
                            if (try_ instanceof Success) {
                                Success success3 = (Success)try_;
                                Snapshot s = (Snapshot)success3.value();
                                success2 = new Success((Object)new Some((Object)new SelectedSnapshot(md, s.data())));
                                break block5;
                            }
                            if (!(try_ instanceof Failure)) break block6;
                            Failure failure = (Failure)try_;
                            e = failure.exception();
                            scala.collection.immutable.Seq remaining = (scala.collection.immutable.Seq)metadata.init();
                            this.log().error(e, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error loading snapshot [{}], remaining attempts: [{}]"})).s((Seq)Nil$.MODULE$), (Object)md, (Object)BoxesRunTime.boxToInteger((int)remaining.size()));
                            if (remaining.isEmpty()) break;
                            metadata = remaining;
                        }
                        success2 = new Failure(e);
                        break block5;
                    }
                    throw new MatchError((Object)try_);
                }
                success = success2;
                break block3;
            }
            throw new MatchError((Object)option);
        }
        return success;
    }

    public void save(SnapshotMetadata metadata, Object snapshot) {
        File tmpFile = this.withOutputStream(metadata, (Function1<OutputStream, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$5 -> {
            this.serialize(x$5, new Snapshot(snapshot));
            return BoxedUnit.UNIT;
        });
        tmpFile.renameTo(this.snapshotFileForWrite(metadata, this.snapshotFileForWrite$default$2()));
    }

    public Snapshot deserialize(InputStream inputStream) {
        return (Snapshot)this.serializationExtension().deserialize(package$.MODULE$.streamToBytes(inputStream), Snapshot.class).get();
    }

    public void serialize(OutputStream outputStream, Snapshot snapshot) {
        outputStream.write(this.serializationExtension().findSerializerFor((Object)snapshot).toBinary((Object)snapshot));
    }

    /*
     * WARNING - void declaration
     */
    public File withOutputStream(SnapshotMetadata metadata, Function1<OutputStream, BoxedUnit> p) {
        void var3_3;
        File tmpFile = this.snapshotFileForWrite(metadata, "tmp");
        this.withStream(new BufferedOutputStream(Files.newOutputStream(tmpFile.toPath(), new OpenOption[0])), p);
        return var3_3;
    }

    private <T> T withInputStream(SnapshotMetadata metadata, Function1<InputStream, T> p) {
        return this.withStream(new BufferedInputStream(Files.newInputStream(this.snapshotFileForWrite(metadata, this.snapshotFileForWrite$default$2()).toPath(), new OpenOption[0])), p);
    }

    private <A extends Closeable, B> B withStream(A stream, Function1<A, B> p) {
        Object object;
        try {
            object = p.apply(stream);
        }
        finally {
            stream.close();
        }
        return (B)object;
    }

    public File snapshotFileForWrite(SnapshotMetadata metadata, String extension) {
        return new File(this.snapshotDir(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"snapshot-", "-", "-", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{URLEncoder.encode(metadata.persistenceId(), ByteString$.MODULE$.UTF_8()), BoxesRunTime.boxToLong((long)metadata.sequenceNr()), BoxesRunTime.boxToLong((long)metadata.timestamp()), extension})));
    }

    public String snapshotFileForWrite$default$2() {
        return "";
    }

    private scala.collection.immutable.Seq<SnapshotMetadata> snapshotMetadatas(String persistenceId, SnapshotSelectionCriteria criteria) {
        File[] files = this.snapshotDir().listFiles(new SnapshotFilenameFilter(persistenceId));
        return files == null ? Nil$.MODULE$ : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).flatMap((Function1 & Serializable & scala.Serializable)filename -> Option$.MODULE$.option2Iterable(this.extractMetadata((String)filename).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String pid = (String)tuple3._1();
            long snr = BoxesRunTime.unboxToLong((Object)tuple3._2());
            long tms = BoxesRunTime.unboxToLong((Object)tuple3._3());
            SnapshotMetadata snapshotMetadata = new SnapshotMetadata(URLDecoder.decode(pid, ByteString$.MODULE$.UTF_8()), snr, tms);
            return snapshotMetadata;
        })), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SnapshotMetadata.class))))).filter((Function1 & Serializable & scala.Serializable)md -> BoxesRunTime.boxToBoolean((boolean)LocalSnapshotStore.$anonfun$snapshotMetadatas$4(this, criteria, md))))).toVector();
    }

    public void preStart() {
        this.snapshotDir();
        Actor.preStart$((Actor)this);
    }

    private File snapshotDir() {
        if (!(this.dir().isDirectory() || this.dir().mkdirs() || this.dir().isDirectory())) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create snapshot directory [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir().getCanonicalPath()})));
        }
        return this.dir();
    }

    private Option<Tuple3<String, Object, Object>> extractMetadata(String filename) {
        None$ none$;
        int sequenceNumberEndIdx = filename.lastIndexOf(45);
        int persistenceIdEndIdx = filename.lastIndexOf(45, sequenceNumberEndIdx - 1);
        String timestampString = filename.substring(sequenceNumberEndIdx + 1);
        if (this.akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx() >= persistenceIdEndIdx || new StringOps(Predef$.MODULE$.augmentString(timestampString)).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LocalSnapshotStore.$anonfun$extractMetadata$1(BoxesRunTime.unboxToChar((Object)x$7))))) {
            none$ = None$.MODULE$;
        } else {
            String persistenceId = filename.substring(this.akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx(), persistenceIdEndIdx);
            long sequenceNumber = new StringOps(Predef$.MODULE$.augmentString(filename.substring(persistenceIdEndIdx + 1, sequenceNumberEndIdx))).toLong();
            long timestamp = new StringOps(Predef$.MODULE$.augmentString(filename.substring(sequenceNumberEndIdx + 1))).toLong();
            none$ = new Some((Object)new Tuple3((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)sequenceNumber), (Object)BoxesRunTime.boxToLong((long)timestamp)));
        }
        return none$;
    }

    public static final /* synthetic */ void $anonfun$deleteAsync$3(scala.collection.immutable.Seq x$3) {
    }

    public static final /* synthetic */ void $anonfun$deleteAsync$5(scala.collection.immutable.Seq x$4) {
    }

    public static final /* synthetic */ boolean $anonfun$snapshotMetadatas$4(LocalSnapshotStore $this, SnapshotSelectionCriteria criteria$1, SnapshotMetadata md) {
        return criteria$1.matches(md) && !$this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving().contains((Object)md);
    }

    public static final /* synthetic */ boolean $anonfun$extractMetadata$1(char x$7) {
        return !RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(x$7));
    }

    public LocalSnapshotStore(Config config) {
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        SnapshotStore.$init$(this);
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern = new StringOps(Predef$.MODULE$.augmentString("^snapshot-(.+)-(\\d+)-(\\d+)")).r();
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx = 9;
        this.maxLoadAttempts = BoxesRunTime.unboxToInt((Object)Helpers.Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring((Object)BoxesRunTime.boxToInteger((int)config.getInt("max-load-attempts"))), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 > 1, (Function0 & Serializable & scala.Serializable)() -> "max-load-attempts must be >= 1"));
        this.streamDispatcher = this.context().system().dispatchers().lookup(config.getString("stream-dispatcher"));
        this.dir = new File(config.getString("dir"));
        this.serializationExtension = (Serialization)SerializationExtension$.MODULE$.apply(this.context().system());
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving = Set$.MODULE$.empty();
    }

    public final class SnapshotFilenameFilter
    implements FilenameFilter {
        private final String encodedPersistenceId;

        public String encodedPersistenceId() {
            return this.encodedPersistenceId;
        }

        @Override
        public boolean accept(File dir, String name) {
            int persistenceIdEndIdx = name.lastIndexOf(45, name.lastIndexOf(45) - 1);
            return LocalSnapshotStore.this.akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx() + this.encodedPersistenceId().length() == persistenceIdEndIdx && name.startsWith(this.encodedPersistenceId(), LocalSnapshotStore.this.akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx());
        }

        public SnapshotFilenameFilter(String persistenceId) {
            if (LocalSnapshotStore.this == null) {
                throw null;
            }
            this.encodedPersistenceId = URLEncoder.encode(persistenceId);
        }
    }

    public final class SnapshotSeqNrFilenameFilter
    implements FilenameFilter {
        private final SnapshotMetadata md;
        private final /* synthetic */ LocalSnapshotStore $outer;

        private final boolean matches(String pid, String snr, String tms) {
            return pid.equals(URLEncoder.encode(this.md.persistenceId())) && BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(snr)).toLong() == $this.md.sequenceNr() && ($this.md.timestamp() == 0L || new StringOps(Predef$.MODULE$.augmentString(tms)).toLong() == $this.md.timestamp())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean bl;
            String string = name;
            Option option = this.$outer.akka$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
                String pid = (String)((LinearSeqOptimized)option.get()).apply(0);
                String snr = (String)((LinearSeqOptimized)option.get()).apply(1);
                String tms = (String)((LinearSeqOptimized)option.get()).apply(2);
                bl = this.matches(pid, snr, tms);
            } else {
                bl = false;
            }
            return bl;
        }

        public SnapshotSeqNrFilenameFilter(LocalSnapshotStore $outer, SnapshotMetadata md) {
            this.md = md;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

