/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.variables.reference;

import com.google.common.base.Joiner;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;

public enum ReleasePropertyVariableKey {
    ID("id", BaseConfigurationItem::getId),
    TITLE("title", PlanItem::getTitle),
    STATUS("status", release -> Optional.ofNullable(release.getStatus()).map(ReleaseStatus::value).orElse(null)),
    OWNER("owner", PlanItem::getOwner),
    DESCRIPTION("description", PlanItem::getDescription),
    FLAG_STATUS("flagStatus", release -> Optional.ofNullable(release.getFlagStatus()).map(Enum::toString).orElse(null)),
    FLAG_COMMENT("flagComment", PlanItem::getFlagComment),
    TAGS("tags", release -> Optional.ofNullable(release.getTags()).map(tags -> Joiner.on((String)", ").join((Iterable)tags)).orElse(null));

    private String key;
    private Function<Release, String> valueGetter;

    private ReleasePropertyVariableKey(String propertyName, Function<Release, String> valueGetter) {
        this.key = String.format("${release.%s}", propertyName);
        this.valueGetter = valueGetter;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue(Release release) {
        return this.valueGetter.apply(release);
    }

    public static boolean isReleasePropertyVariableKey(String key) {
        return Arrays.stream(ReleasePropertyVariableKey.values()).map(ReleasePropertyVariableKey::getKey).anyMatch(k -> k.equals(VariableHelper.formatVariableIfNeeded(key)));
    }
}

