/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public abstract class PlanItem
extends BaseConfigurationItem
implements VisitableItem {
    public static final Comparator<PlanItem> BY_TITLE = (left, right) -> {
        String leftTitle = Strings.nullToEmpty((String)left.getTitle());
        String rightTitle = Strings.nullToEmpty((String)right.getTitle());
        return ComparisonChain.start().compare((Comparable)((Object)leftTitle), (Comparable)((Object)rightTitle)).result();
    };
    @Property(description="The title of the item.")
    protected String title;
    @Property(required=false, description="The description of the item.")
    protected String description;
    @Property(required=false, description="The owner of the item.")
    protected String owner;
    @Property(required=false, description="The date that the item is supposed to start.")
    protected Date scheduledStartDate;
    @Property(required=false, description="The date that the item is supposed to end.")
    protected Date dueDate;
    @Property(required=false, description="The actual start date.")
    protected Date startDate;
    @Property(required=false, description="The actual end date.")
    protected Date endDate;
    @Property(required=false, description="The time that the item is supposed to take to complete, in seconds.")
    protected Integer plannedDuration;
    @Property(description="Flags indicate that an item needs attention.", defaultValue="OK")
    protected FlagStatus flagStatus = FlagStatus.OK;
    @Property(required=false, description="The reason the item is flagged.")
    protected String flagComment;
    @Property(required=false, category="internal")
    protected boolean overdueNotified;

    @PublicApiMember
    public String getTitle() {
        return this.title;
    }

    @PublicApiMember
    public void setTitle(String title) {
        this.title = title;
    }

    @PublicApiMember
    public String getDescription() {
        return this.description;
    }

    @PublicApiMember
    public void setDescription(String value) {
        this.description = value;
    }

    @PublicApiMember
    public String getOwner() {
        return this.owner;
    }

    @PublicApiMember
    public void setOwner(String value) {
        this.owner = value;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public boolean hasOwner(String releaseOwner) {
        return this.getOwner() != null && this.getOwner().equals(releaseOwner);
    }

    @PublicApiMember
    public Date getDueDate() {
        return this.dueDate;
    }

    @PublicApiMember
    public void setDueDate(Date value) {
        this.dueDate = value;
    }

    @PublicApiMember
    public Date getStartDate() {
        return this.startDate;
    }

    @PublicApiMember
    public void setStartDate(Date value) {
        this.startDate = value;
    }

    @PublicApiMember
    public Date getScheduledStartDate() {
        return this.scheduledStartDate;
    }

    @PublicApiMember
    public void setScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
    }

    @PublicApiMember
    public Date getEndDate() {
        return this.endDate;
    }

    @PublicApiMember
    public void setEndDate(Date value) {
        this.endDate = value;
    }

    @PublicApiMember
    public Integer getPlannedDuration() {
        return this.plannedDuration;
    }

    @PublicApiMember
    public void setPlannedDuration(Integer plannedDuration) {
        this.plannedDuration = plannedDuration;
    }

    public boolean hasPlannedDuration() {
        return this.getPlannedDuration() != null;
    }

    @PublicApiMember
    public FlagStatus getFlagStatus() {
        return this.flagStatus;
    }

    @PublicApiMember
    public void setFlagStatus(FlagStatus flagStatus) {
        this.flagStatus = flagStatus;
    }

    @PublicApiMember
    public String getFlagComment() {
        return this.flagComment;
    }

    @PublicApiMember
    public void setFlagComment(String flagComment) {
        this.flagComment = flagComment;
    }

    public boolean isFlagged() {
        return FlagStatus.OK != this.flagStatus;
    }

    public void checkDatesValidity(Date scheduledStartDate, Date dueDate, Integer plannedDuration) {
        Preconditions.checkArgument((plannedDuration == null || (long)plannedDuration.intValue() >= 0L ? 1 : 0) != 0, (Object)"Planned duration cannot be negative");
        if (scheduledStartDate != null && dueDate != null && plannedDuration != null) {
            Preconditions.checkArgument(((dueDate.getTime() - scheduledStartDate.getTime()) / 1000L == (long)plannedDuration.intValue() ? 1 : 0) != 0, (Object)"start date and due date must be consistent with the duration");
        }
    }

    public void updateDates(Date scheduledStartDate, Date dueDate, Integer plannedDuration) {
        Date scheduledOrStartDate;
        Preconditions.checkArgument((plannedDuration == null || (long)plannedDuration.intValue() >= 0L ? 1 : 0) != 0, (Object)"Planned duration cannot be negative");
        Date date = scheduledOrStartDate = this.hasBeenStarted() ? this.getStartDate() : scheduledStartDate;
        if (scheduledOrStartDate != null && dueDate != null && plannedDuration != null) {
            Preconditions.checkArgument(((dueDate.getTime() - scheduledOrStartDate.getTime()) / 1000L == (long)plannedDuration.intValue() ? 1 : 0) != 0, (Object)"start date and due date must be consistent with the duration");
        }
        if (!this.hasBeenStarted()) {
            this.setScheduledStartDate(scheduledStartDate);
        }
        this.setDueDate(dueDate);
        this.setPlannedDuration(plannedDuration);
    }

    public Changes moveChildren(int offsetInSeconds) {
        Changes changes = new Changes();
        for (PlanItem item : this.getChildren()) {
            changes.addAll(item.setDates(offsetInSeconds));
        }
        return changes;
    }

    public boolean hasStartOrScheduledDate() {
        return this.getStartOrScheduledDate() != null;
    }

    public Date getStartOrScheduledDate() {
        if (this.hasStartDate()) {
            return this.getStartDate();
        }
        if (this.hasScheduledStartDate()) {
            return this.getScheduledStartDate();
        }
        return null;
    }

    public boolean hasEndOrDueDate() {
        return this.getEndOrDueDate() != null;
    }

    public Date getEndOrDueDate() {
        if (this.hasEndDate()) {
            return this.getEndDate();
        }
        if (this.hasDueDate()) {
            return this.getDueDate();
        }
        return null;
    }

    public boolean hasScheduledStartDate() {
        return this.getScheduledStartDate() != null;
    }

    public boolean hasStartDate() {
        return this.getStartDate() != null;
    }

    public boolean hasDueDate() {
        return this.getDueDate() != null;
    }

    public boolean hasEndDate() {
        return this.getEndDate() != null;
    }

    public Changes setDates(int offsetInSeconds) {
        Changes changes = new Changes();
        if (this.getScheduledStartDate() != null) {
            DateTime newScheduledStartDate = new DateTime((Object)this.getScheduledStartDate()).plusSeconds(offsetInSeconds);
            this.setScheduledStartDate(newScheduledStartDate.toDate());
            changes.update((ConfigurationItem)this);
        }
        if (this.getDueDate() != null) {
            DateTime newDueStartDate = new DateTime((Object)this.getDueDate()).plusSeconds(offsetInSeconds);
            this.setDueDate(newDueStartDate.toDate());
            changes.update((ConfigurationItem)this);
        }
        return changes;
    }

    public boolean hasTitle() {
        return com.xebialabs.deployit.booter.local.utils.Strings.isNotEmpty((String)this.getTitle());
    }

    public boolean hasTitle(String candidateTitle) {
        return this.title.equals(candidateTitle);
    }

    public boolean isTitleContaining(String candidateTitle) {
        if (this.title == null) {
            return true;
        }
        if (candidateTitle == null) {
            return true;
        }
        return this.title.contains(candidateTitle);
    }

    public boolean hasValidStartDates() {
        if (this.hasScheduledStartDate() && this.hasDueDate()) {
            return new DateTime((Object)this.getScheduledStartDate()).isBefore((ReadableInstant)new DateTime((Object)this.getDueDate()));
        }
        return true;
    }

    public abstract List<PlanItem> getChildren();

    public void setStartAndEndDatesIfEmpty() {
        if (!this.hasStartDate()) {
            this.setStartDate(new Date());
        }
        if (!this.hasEndDate()) {
            this.setEndDate(new Date());
        }
    }

    public boolean isOverdue() {
        Optional<Date> optional = this.getOrCalculateDueDate();
        return optional.map(date -> date.before(new Date())).orElse(false);
    }

    public void setOverdueNotified(boolean overdueNotified) {
        this.overdueNotified = overdueNotified;
    }

    public boolean isOverdueNotified() {
        return this.overdueNotified;
    }

    public boolean shouldNotifyOverdue() {
        return !this.overdueNotified && this.isOverdue();
    }

    public abstract boolean hasBeenStarted();

    public abstract boolean isDone();

    public abstract Release getRelease();

    public abstract boolean isUpdatable();

    public abstract String getDisplayPath();

    public abstract boolean isAborted();

    public abstract boolean isActive();

    public abstract List<UsagePoint> getVariableUsages();

    protected Optional<Date> calculateDueDate(Integer plannedDuration) {
        if (!this.hasStartDate() || plannedDuration == null) {
            return Optional.empty();
        }
        DateTime dueDateTime = new DateTime((Object)this.startDate).plusSeconds(plannedDuration.intValue());
        return Optional.ofNullable(dueDateTime.toDate());
    }

    public Optional<Date> getOrCalculateDueDate() {
        if (this.hasDueDate()) {
            return Optional.ofNullable(this.dueDate);
        }
        if (this.hasPlannedDuration()) {
            return this.calculateDueDate(this.plannedDuration);
        }
        return Optional.empty();
    }
}

