/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.dsl.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.ReleaseInfo;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.dsl.service.DslFormatter$;
import com.xebialabs.xlrelease.dsl.service.renderer.DefaultRenderer;
import com.xebialabs.xlrelease.dsl.service.renderer.DslRendererContext;
import com.xebialabs.xlrelease.repository.Ids;
import java.io.OutputStream;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Predef$;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u001b\tYAi\u001d7FqB|'\u000f^3s\u0015\t\u0019A!A\u0004tKJ4\u0018nY3\u000b\u0005\u00151\u0011a\u00013tY*\u0011q\u0001C\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0003\u0006\u0002\u0013a,'-[1mC\n\u001c(\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0003=!WMZ1vYR\u0014VM\u001c3fe\u0016\u0014\bCA\f\u001b\u001b\u0005A\"BA\r\u0003\u0003!\u0011XM\u001c3fe\u0016\u0014\u0018BA\u000e\u0019\u0005=!UMZ1vYR\u0014VM\u001c3fe\u0016\u0014\b\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\b\u0006\u0002 CA\u0011\u0001\u0005A\u0007\u0002\u0005!)Q\u0003\ba\u0001-!\u0012Ad\t\t\u0003I=j\u0011!\n\u0006\u0003M\u001d\n!\"\u00198o_R\fG/[8o\u0015\tA\u0013&A\u0004gC\u000e$xN]=\u000b\u0005)Z\u0013!\u00022fC:\u001c(B\u0001\u0017.\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001\u0018\u0002\u0007=\u0014x-\u0003\u00021K\tI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006e\u0001!\taM\u0001\u000fKb\u0004xN\u001d;UK6\u0004H.\u0019;f)\r!tg\u0010\t\u0003\u001fUJ!A\u000e\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006qE\u0002\r!O\u0001\ti\u0016l\u0007\u000f\\1uKB\u0011!(P\u0007\u0002w)\u0011AHB\u0001\u0007I>l\u0017-\u001b8\n\u0005yZ$a\u0002*fY\u0016\f7/\u001a\u0005\u0006\u0001F\u0002\r!Q\u0001\r_V$\b/\u001e;TiJ,\u0017-\u001c\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000b!![8\u000b\u0003\u0019\u000bAA[1wC&\u0011\u0001j\u0011\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0015\u0003c)\u0003\"aS)\u000e\u00031S!AJ'\u000b\u00059{\u0015aB7fiJL7m\u001d\u0006\u0003!*\t\u0001bY8eC\"\fG.Z\u0005\u0003%2\u0013Q\u0001V5nK\u0012DQ\u0001\u0016\u0001\u0005\nU\u000b!\"\u00193e12\u0014H+Y4t)\t1\u0016\r\u0005\u0002X=:\u0011\u0001\f\u0018\t\u00033Bi\u0011A\u0017\u0006\u000372\ta\u0001\u0010:p_Rt\u0014BA/\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011q\f\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u\u0003\u0002\"\u00022T\u0001\u00041\u0016a\u0003;f[Bd\u0017\r^3Eg2DQ\u0001\u001a\u0001\u0005\n\u0015\f!#\u00193e\u001b\u0016$\u0018-\u00138g_Jl\u0017\r^5p]R\u0019aKZ4\t\u000ba\u001a\u0007\u0019A\u001d\t\u000b\t\u001c\u0007\u0019\u0001,)\u0005\u0001I\u0007C\u00016n\u001b\u0005Y'B\u00017,\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0003].\u0014\u0011bQ8na>tWM\u001c;")
public class DslExporter {
    private final DefaultRenderer defaultRenderer;

    @Timed
    public void exportTemplate(Release template, OutputStream outputStream) {
        DslRendererContext rendererContext = new DslRendererContext();
        String templateDsl = this.addXlrTags(this.defaultRenderer.dsl(rendererContext, (ConfigurationItem)template));
        String dslOut = this.addMetaInformation(template, DslFormatter$.MODULE$.format((String)new StringOps(Predef$.MODULE$.augmentString(rendererContext.context())).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(templateDsl)), Predef$.MODULE$.StringCanBuildFrom())));
        outputStream.write(dslOut.getBytes("UTF-8"));
    }

    private String addXlrTags(String templateDsl) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"xlr {\n       |", "\n       |}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{templateDsl})))).stripMargin();
    }

    private String addMetaInformation(Release template, String templateDsl) {
        String templateId = Ids.releasePathInRootFolder((String)template.getId()).replaceAll("/", "-");
        ReleaseInfo releaseInfo = new ReleaseInfo("com/xebialabs/deployit/release.properties");
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|// Exported from:        ", "#/templates/", "/releasefile\n        |// XL Release version:   ", "\n        |// Date created:         ", "\n        |\n        |", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ServerConfiguration.getInstance().getServerUrl(), templateId, releaseInfo.getVersion(), new Date(), templateDsl})))).stripMargin();
    }

    @Autowired
    public DslExporter(DefaultRenderer defaultRenderer) {
        this.defaultRenderer = defaultRenderer;
    }
}

