/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.dsl.service;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.dsl.service.CiProcessor;
import com.xebialabs.xlrelease.dsl.service.DslProcessingContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Primary
@Component
public class DslCiProcessor
implements CiProcessor {
    private Map<Type, CiProcessor> processorMap = new HashMap<Type, CiProcessor>();

    @Autowired
    public DslCiProcessor(List<CiProcessor> processors) {
        processors.forEach(processor -> this.processorMap.put(processor.getType(), (CiProcessor)processor));
    }

    public void process(DslProcessingContext processingContext, ConfigurationItem ci) {
        Type ciType = ci.getType();
        if (this.processorMap.containsKey(ciType)) {
            this.processorMap.get(ciType).process(processingContext, ci);
        }
    }

    @Override
    public Type getType() {
        return Type.valueOf(ConfigurationItem.class);
    }
}

