/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.dsl.service;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class CiTreeVisitor {
    private ConfigurationItem root;
    private Set<ConfigurationItem> visitedCis = new HashSet<ConfigurationItem>();

    private CiTreeVisitor(ConfigurationItem root) {
        this.root = root;
    }

    public static CiTreeVisitor of(ConfigurationItem root) {
        return new CiTreeVisitor(root);
    }

    public void with(VisitAction action) {
        this.visit(this.root, action);
    }

    private void visit(ConfigurationItem ci, VisitAction action) {
        if (null != ci && !this.visitedCis.contains(ci)) {
            this.visitedCis.add(ci);
            action.execute(ci);
            ci.getType().getDescriptor().getPropertyDescriptors().forEach(pd -> {
                switch (pd.getKind()) {
                    case CI: {
                        ConfigurationItem ciToVisit = (ConfigurationItem)ci.getProperty(pd.getName());
                        this.checkIdentity(ciToVisit, ci, (PropertyDescriptor)pd);
                        this.visit(ciToVisit, action);
                        break;
                    }
                    case LIST_OF_CI: 
                    case SET_OF_CI: {
                        Collection cis = (Collection)ci.getProperty(pd.getName());
                        cis.forEach(item -> {
                            this.checkIdentity((ConfigurationItem)item, ci, (PropertyDescriptor)pd);
                            this.visit((ConfigurationItem)item, action);
                        });
                    }
                }
            });
        }
    }

    private void checkIdentity(ConfigurationItem ciToVisit, ConfigurationItem ci, PropertyDescriptor pd) {
        if (ciToVisit != null && ciToVisit.getId() == null) {
            throw new IllegalStateException(String.format("Property '%s' of CI '%s' has null ID", pd.getFqn(), ci.getId()));
        }
    }

    @FunctionalInterface
    static interface VisitAction {
        public void execute(ConfigurationItem var1);
    }
}

