/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.util.DeployitKeyStoreException;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.io.Console;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Recovery {
    private final ServerLaunchOptions launchOptions;
    protected final ServerConfiguration serverConfiguration;
    private static final Logger logger = LoggerFactory.getLogger(Recovery.class);

    public Recovery(ServerLaunchOptions launchOptions, ServerConfigFile serverConfigFile) {
        this.launchOptions = launchOptions;
        this.serverConfiguration = this.initializeConfig(serverConfigFile);
        LocalBooter.boot();
    }

    private ServerConfiguration initializeConfig(ServerConfigFile serverConfigFile) {
        ServerConfiguration config = serverConfigFile.loadConfig(false, false);
        String password = this.launchOptions.getRepositoryKeystorePassword();
        String repositoryKeyStorePassword = password != null ? password : config.getRepositoryKeyStorePassword();
        try {
            SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)repositoryKeyStorePassword);
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        }
        catch (DeployitKeyStoreException e) {
            System.out.println("Could not load the encryption key. Cannot start the recovery.");
            throw e;
        }
        config.loadEncryptedPasswords();
        return config;
    }

    protected abstract void recover();

    public void run() {
        this.displayWarning();
        try {
            SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)this.launchOptions.getRepositoryKeystorePassword());
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        }
        catch (DeployitKeyStoreException e) {
            System.out.println("Could not load the encryption key.");
            return;
        }
        this.recover();
    }

    private void displayWarning() {
        System.out.println("*** We're going to attempt to run a recovery process on your repository. ***");
        System.out.println("***    It is HIGHLY recommended to make a backup before you proceed.     ***");
        System.out.println("***                 Are you sure you wish to continue?                   ***");
        Console console = System.console();
        if (console == null) {
            throw new IllegalStateException("Not running in interactive mode, please run recovery from a console. Quitting now.");
        }
        String s = console.readLine("Please enter 'yes' if you wish to continue. [no] > ", new Object[0]);
        if (!s.equalsIgnoreCase("yes")) {
            System.exit(99);
        }
    }
}

