/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.TzUrl;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.Configurator;
import net.fortuna.ical4j.util.ResourceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeZoneRegistryImpl
implements TimeZoneRegistry {
    private static final String DEFAULT_RESOURCE_PREFIX = "zoneinfo/";
    private static final Pattern TZ_ID_SUFFIX;
    private static final String UPDATE_ENABLED = "net.fortuna.ical4j.timezone.update.enabled";
    private static final Map DEFAULT_TIMEZONES;
    private static final Properties ALIASES;
    private Map timezones;
    private String resourcePrefix;
    static /* synthetic */ Class class$0;

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [3 : 191->194)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public TimeZoneRegistryImpl() {
        this(DEFAULT_RESOURCE_PREFIX);
    }

    public TimeZoneRegistryImpl(String resourcePrefix) {
        this.resourcePrefix = resourcePrefix;
        this.timezones = new ConcurrentHashMap();
    }

    public final void register(TimeZone timezone) {
        this.register(timezone, false);
    }

    public final void register(TimeZone timezone, boolean update) {
        if (update) {
            this.timezones.put(timezone.getID(), new TimeZone(this.updateDefinition(timezone.getVTimeZone())));
        } else {
            this.timezones.put(timezone.getID(), timezone);
        }
    }

    public final void clear() {
        this.timezones.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TimeZone getTimeZone(String id) {
        TimeZone timezone = (TimeZone)this.timezones.get(id);
        if (timezone == null && (timezone = (TimeZone)DEFAULT_TIMEZONES.get(id)) == null) {
            String alias = ALIASES.getProperty(id);
            if (alias != null) {
                return this.getTimeZone(alias);
            }
            Map map = DEFAULT_TIMEZONES;
            synchronized (map) {
                timezone = (TimeZone)DEFAULT_TIMEZONES.get(id);
                if (timezone == null) {
                    try {
                        Matcher matcher;
                        VTimeZone vTimeZone = this.loadVTimeZone(id);
                        if (vTimeZone != null) {
                            timezone = new TimeZone(vTimeZone);
                            DEFAULT_TIMEZONES.put(timezone.getID(), timezone);
                        } else if (CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed") && (matcher = TZ_ID_SUFFIX.matcher(id)).find()) {
                            return this.getTimeZone(matcher.group());
                        }
                    }
                    catch (Exception e) {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("net.fortuna.ical4j.model.TimeZoneRegistryImpl");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log log = LogFactory.getLog((Class)clazz);
                        log.warn((Object)"Error occurred loading VTimeZone", (Throwable)e);
                    }
                }
            }
        }
        return timezone;
    }

    private VTimeZone loadVTimeZone(String id) throws IOException, ParserException {
        URL resource = ResourceLoader.getResource(String.valueOf(this.resourcePrefix) + id + ".ics");
        if (resource != null) {
            CalendarBuilder builder = new CalendarBuilder();
            Calendar calendar = builder.build(resource.openStream());
            VTimeZone vTimeZone = (VTimeZone)calendar.getComponent("VTIMEZONE");
            if (!"false".equals(Configurator.getProperty(UPDATE_ENABLED))) {
                return this.updateDefinition(vTimeZone);
            }
            return vTimeZone;
        }
        return null;
    }

    private VTimeZone updateDefinition(VTimeZone vTimeZone) {
        TzUrl tzUrl = vTimeZone.getTimeZoneUrl();
        if (tzUrl != null) {
            try {
                CalendarBuilder builder = new CalendarBuilder();
                Calendar calendar = builder.build(tzUrl.getUri().toURL().openStream());
                VTimeZone updatedVTimeZone = (VTimeZone)calendar.getComponent("VTIMEZONE");
                if (updatedVTimeZone != null) {
                    return updatedVTimeZone;
                }
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("net.fortuna.ical4j.model.TimeZoneRegistryImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log log = LogFactory.getLog((Class)clazz);
                log.warn((Object)("Unable to retrieve updates for timezone: " + vTimeZone.getTimeZoneId().getValue()), (Throwable)e);
            }
        }
        return vTimeZone;
    }
}

