/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.userdata;

import com.xebialabs.xlrelease.userdata.DefaultUserDataProvider;
import com.xebialabs.xlrelease.userdata.UserData;
import com.xebialabs.xlrelease.userdata.UserDataProvider;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticator;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.search.LdapUserSearch;

public class LdapUserDataProvider
implements UserDataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapUserDataProvider.class);
    private LdapUserSearch userSearch;
    private final DefaultUserDataProvider defaultUserDataProvider;

    LdapUserDataProvider(LdapAuthenticationProvider authProvider, DefaultUserDataProvider defaultUserDataProvider) {
        try {
            BindAuthenticator authenticator = LdapUserDataProvider.invokePrivateMethod(authProvider, LdapAuthenticationProvider.class, "getAuthenticator", BindAuthenticator.class);
            this.userSearch = LdapUserDataProvider.invokePrivateMethod(authenticator, AbstractLdapAuthenticator.class, "getUserSearch", LdapUserSearch.class);
        }
        catch (Exception ex) {
            LOGGER.warn("Error constructing LdapUserDataProvider", (Throwable)ex);
        }
        this.defaultUserDataProvider = defaultUserDataProvider;
    }

    LdapUserDataProvider(LdapUserSearch userSearch, DefaultUserDataProvider defaultUserDataProvider) {
        this.userSearch = userSearch;
        this.defaultUserDataProvider = defaultUserDataProvider;
    }

    @Override
    public UserData getUserData(String username) {
        UserData defaultUserData = this.defaultUserDataProvider.getUserData(username);
        if (defaultUserData.isFound()) {
            return defaultUserData;
        }
        DirContextOperations data = this.getDirContextOperations(username);
        if (data == null) {
            return UserData.NOT_FOUND;
        }
        String email = this.readAttribute(username, data, "mail");
        String fullName = this.readAttribute(username, data, "displayName");
        LOGGER.info("Email: {} and displayName: {} have been read from LDAP", (Object)email, (Object)fullName);
        return new UserData(email, fullName);
    }

    private DirContextOperations getDirContextOperations(String username) {
        try {
            return this.userSearch.searchForUser(username);
        }
        catch (UsernameNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            LOGGER.warn("Error accessing LDAP server", (Throwable)e);
            return null;
        }
    }

    private String readAttribute(String username, DirContextOperations data, String attribute) {
        if (data == null) {
            return null;
        }
        if (!data.attributeExists(attribute)) {
            LOGGER.warn("LDAP entry for user {} has no '{}' attribute", (Object)username, (Object)attribute);
        } else {
            try {
                return data.getStringAttribute(attribute);
            }
            catch (ClassCastException e) {
                LOGGER.warn("'mail' attribute of LDAP entry for user {} should be a String", (Object)username);
            }
        }
        return null;
    }

    private static <T, R> R invokePrivateMethod(Object target, Class<T> targetClass, String methodName, Class<R> returnType) throws Exception {
        Method method = targetClass.getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        return returnType.cast(method.invoke(target, new Object[0]));
    }
}

