/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.migrator;

import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.db.XLReleaseDbInitializer;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.migrator.ArchiveMigrator;
import com.xebialabs.xlrelease.migrator.DbInitializerKt;
import com.xebialabs.xlrelease.migrator.DefaultEnvironmentVariables;
import com.xebialabs.xlrelease.migrator.IntroductionScreen;
import com.xebialabs.xlrelease.migrator.SqlMigrator;
import com.xebialabs.xlrelease.migrator.VersionCheckerKt;
import com.xebialabs.xlrelease.migrator.config.ServerConnection;
import com.xebialabs.xlrelease.migrator.config.Services;
import com.xebialabs.xlrelease.migrator.config.ServicesFactory;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"main", "", "args", "", "", "([Ljava/lang/String;)V", "xl-release-sql-migrator"})
public final class MainKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Closeable closeable = new ServerConnection();
        Throwable throwable = null;
        try {
            ServerConnection it = (ServerConnection)closeable;
            IntroductionScreen.Companion.show(it.getMigratorConfig());
            Services services = new ServicesFactory(it).build();
            boolean migrationSuccess = true;
            try {
                if (DefaultEnvironmentVariables.INSTANCE.isMigrateRepository()) {
                    VersionCheckerKt.checkMinServerVersion((RepositoryVersionService)services.getJcrRepositoryVersionService());
                    SqlBuilder.Dialect dialect = services.getReleasePersistence().dialect();
                    Intrinsics.checkExpressionValueIsNotNull((Object)dialect, (String)"services.releasePersistence.dialect()");
                    DbInitializerKt.initializeRepositoryDatabase(dialect, services.getReleasesDbInitializers(), services.getSecurablePersistence());
                    SqlMigrator sqlMigrator = new SqlMigrator(services, it.getMigratorConfig(), DefaultEnvironmentVariables.INSTANCE.isSkipErrors());
                    migrationSuccess = sqlMigrator.migrateJcr();
                }
                if (DefaultEnvironmentVariables.INSTANCE.isMigrateArchive() && it.getNewReportingDataSource() != null) {
                    XLReleaseDbInitializer xLReleaseDbInitializer = services.getNewReportingDbInitializer();
                    if (xLReleaseDbInitializer == null) {
                        Intrinsics.throwNpe();
                    }
                    DbInitializerKt.initializeArchiveDatabase(xLReleaseDbInitializer);
                    ArchiveMigrator archiveMigrator = new ArchiveMigrator(services, it.getMigratorConfig(), DefaultEnvironmentVariables.INSTANCE.isSkipErrors());
                    migrationSuccess = migrationSuccess && archiveMigrator.migrate();
                }
            }
            finally {
                it.getReleasesDataSource().close();
                it.getReportingDataSource().close();
                HikariDataSource hikariDataSource = it.getNewReportingDataSource();
                if (hikariDataSource != null) {
                    hikariDataSource.close();
                }
            }
            String string = "Migration process is done";
            System.out.println((Object)string);
            if (!migrationSuccess) {
                string = "Some errors happened during migration, see xl-release-sql-migrator-error.log for more details";
                System.out.println((Object)string);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

