/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.logging.LogFactory;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.ResultSetCache;
import liquibase.snapshot.SnapshotControl;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.JdbcUtils;

public class JdbcDatabaseSnapshot
extends DatabaseSnapshot {
    private boolean warnedAboutDbaRecycleBin = false;
    private CachingDatabaseMetaData cachingDatabaseMetaData;
    private Set<String> userDefinedTypes;

    public JdbcDatabaseSnapshot(DatabaseObject[] examples, Database database, SnapshotControl snapshotControl) throws DatabaseException, InvalidExampleException {
        super(examples, database, snapshotControl);
    }

    public JdbcDatabaseSnapshot(DatabaseObject[] examples, Database database) throws DatabaseException, InvalidExampleException {
        super(examples, database);
    }

    public CachingDatabaseMetaData getMetaData() throws SQLException {
        if (this.cachingDatabaseMetaData == null) {
            DatabaseMetaData databaseMetaData = null;
            if (this.getDatabase().getConnection() != null) {
                databaseMetaData = ((JdbcConnection)this.getDatabase().getConnection()).getUnderlyingConnection().getMetaData();
            }
            this.cachingDatabaseMetaData = new CachingDatabaseMetaData(this.getDatabase(), databaseMetaData);
        }
        return this.cachingDatabaseMetaData;
    }

    public class CachingDatabaseMetaData {
        private DatabaseMetaData databaseMetaData;
        private Database database;

        public CachingDatabaseMetaData(Database database, DatabaseMetaData metaData) {
            this.databaseMetaData = metaData;
            this.database = database;
        }

        public DatabaseMetaData getDatabaseMetaData() {
            return this.databaseMetaData;
        }

        public List<CachedRow> getForeignKeys(final String catalogName, final String schemaName, final String tableName, final String fkName) throws DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getImportedKeys").get(new ResultSetCache.UnionResultSetExtractor(this.database){

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("FKTABLE_CAT"), row.getString("FKTABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("FKTABLE_NAME"), row.getString("FK_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, tableName, fkName);
                }

                @Override
                public List<CachedRow> fastFetch() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    ArrayList<CachedRow> returnList = new ArrayList<CachedRow>();
                    ArrayList<String> tables = new ArrayList<String>();
                    String jdbcCatalogName = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema);
                    String jdbcSchemaName = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                    if (CachingDatabaseMetaData.this.database instanceof DB2Database) {
                        String sql = this.getDB2Sql(jdbcSchemaName);
                        if (tableName != null) {
                            sql = sql.replace(" ORDER BY ", " AND fk_col.tabname='" + tableName + "' ORDER BY ");
                        }
                        return this.executeAndExtract(sql, CachingDatabaseMetaData.this.database);
                    }
                    if (tableName == null) {
                        for (CachedRow row : CachingDatabaseMetaData.this.getTables(jdbcCatalogName, jdbcSchemaName, null)) {
                            tables.add(row.getString("TABLE_NAME"));
                        }
                    } else {
                        tables.add(tableName);
                    }
                    for (String foundTable : tables) {
                        if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                            throw new RuntimeException("Should have bulk selected");
                        }
                        returnList.addAll(this.extract(CachingDatabaseMetaData.this.databaseMetaData.getImportedKeys(jdbcCatalogName, jdbcSchemaName, foundTable)));
                    }
                    return returnList;
                }

                @Override
                public List<CachedRow> bulkFetch() throws SQLException, DatabaseException {
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                        String jdbcSchemaName = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                        String sql = "SELECT  /*+rule*/  NULL AS pktable_cat,    p.owner as pktable_schem,    p.table_name as pktable_name,    pc.column_name as pkcolumn_name,    NULL as fktable_cat,    f.owner as fktable_schem,    f.table_name as fktable_name,    fc.column_name as fkcolumn_name,    fc.position as key_seq,    NULL as update_rule,    decode (f.delete_rule, 'CASCADE', 0, 'SET NULL', 2, 1) as delete_rule,    f.constraint_name as fk_name,    p.constraint_name as pk_name,    decode(f.deferrable, 'DEFERRABLE', 5, 'NOT DEFERRABLE', 7, 'DEFERRED', 6) deferrability  FROM all_cons_columns pc INNER JOIN all_constraints p ON pc.owner = p.owner AND pc.constraint_name = p.constraint_name INNER JOIN all_constraints f ON pc.owner = f.r_owner AND pc.constraint_name = f.r_constraint_name INNER JOIN all_cons_columns fc ON fc.owner = f.owner AND fc.constraint_name = f.constraint_name AND fc.position = pc.position WHERE f.owner = '" + jdbcSchemaName + "' " + "AND p.constraint_type in ('P', 'U') " + "AND f.constraint_type = 'R' " + "AND p.table_name NOT LIKE 'BIN$%' " + "ORDER BY fktable_schem, fktable_name, key_seq";
                        return this.executeAndExtract(sql, CachingDatabaseMetaData.this.database);
                    }
                    if (CachingDatabaseMetaData.this.database instanceof DB2Database) {
                        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                        String jdbcSchemaName = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                        String sql = this.getDB2Sql(jdbcSchemaName);
                        return this.executeAndExtract(sql, CachingDatabaseMetaData.this.database);
                    }
                    throw new RuntimeException("Cannot bulk select");
                }

                protected String getDB2Sql(String jdbcSchemaName) {
                    return "SELECT    pk_col.tabschema AS pktable_cat,    pk_col.tabname as pktable_name,    pk_col.colname as pkcolumn_name,   fk_col.tabschema as fktable_cat,    fk_col.tabname as fktable_name,    fk_col.colname as fkcolumn_name,   fk_col.colseq as key_seq,    decode (ref.updaterule, 'A', 3, 'R', 1, 1) as update_rule,    decode (ref.deleterule, 'A', 3, 'C', 0, 'N', 2, 'R', 1, 1) as delete_rule,    ref.constname as fk_name,    ref.refkeyname as pk_name,    7 as deferrability  FROM syscat.references ref join syscat.keycoluse fk_col on ref.constname=fk_col.constname and ref.tabschema=fk_col.tabschema and ref.tabname=fk_col.tabname join syscat.keycoluse pk_col on ref.refkeyname=pk_col.constname and ref.reftabschema=pk_col.tabschema and ref.reftabname=pk_col.tabname WHERE ref.tabschema = '" + jdbcSchemaName + "' " + "and pk_col.colseq=fk_col.colseq " + "ORDER BY fk_col.colseq";
                }

                @Override
                boolean shouldBulkSelect(String schemaKey, ResultSetCache resultSetCache) {
                    if (CachingDatabaseMetaData.this.database instanceof DB2Database) {
                        return super.shouldBulkSelect(schemaKey, resultSetCache);
                    }
                    return CachingDatabaseMetaData.this.database instanceof OracleDatabase;
                }
            });
        }

        public List<CachedRow> getIndexInfo(final String catalogName, final String schemaName, final String tableName, final String indexName) throws DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getIndexInfo").get(new ResultSetCache.UnionResultSetExtractor(this.database){
                public boolean bulkFetch;
                {
                    super(x0);
                    this.bulkFetch = false;
                }

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("TABLE_NAME"), row.getString("INDEX_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, tableName, indexName);
                }

                @Override
                public List<CachedRow> fastFetch() throws SQLException, DatabaseException {
                    ArrayList<CachedRow> returnList = new ArrayList<CachedRow>();
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        CachingDatabaseMetaData.this.warnAboutDbaRecycleBin();
                        String sql = "SELECT c.INDEX_NAME, 3 AS TYPE, c.TABLE_NAME, c.COLUMN_NAME, c.COLUMN_POSITION AS ORDINAL_POSITION, e.COLUMN_EXPRESSION AS FILTER_CONDITION, CASE I.UNIQUENESS WHEN 'UNIQUE' THEN 0 ELSE 1 END AS NON_UNIQUE, CASE c.DESCEND WHEN 'Y' THEN 'D' WHEN 'N' THEN 'A' END AS ASC_OR_DESC FROM ALL_IND_COLUMNS c JOIN ALL_INDEXES i ON (i.index_name = c.index_name and i.table_owner = c.table_owner)LEFT JOIN " + (((OracleDatabase)CachingDatabaseMetaData.this.database).canAccessDbaRecycleBin() ? "dba_recyclebin" : "user_recyclebin") + " d ON d.object_name=c.table_name " + "LEFT JOIN all_ind_expressions e ON e.column_position = c.column_position AND e.index_name = c.index_name " + "WHERE c.TABLE_OWNER = '" + CachingDatabaseMetaData.this.database.correctObjectName(catalogAndSchema.getCatalogName(), Schema.class) + "' " + "AND d.object_name IS NULL " + "AND i.OWNER = c.TABLE_OWNER";
                        if (!this.bulkFetch && tableName != null) {
                            sql = sql + " AND c.TABLE_NAME='" + tableName + "'";
                        }
                        if (!this.bulkFetch && indexName != null) {
                            sql = sql + " AND c.INDEX_NAME='" + indexName + "'";
                        }
                        sql = sql + " ORDER BY c.INDEX_NAME, ORDINAL_POSITION";
                        returnList.addAll(this.executeAndExtract(sql, CachingDatabaseMetaData.this.database));
                    } else {
                        ArrayList<String> tables = new ArrayList<String>();
                        if (tableName == null) {
                            for (CachedRow row : CachingDatabaseMetaData.this.getTables(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), null)) {
                                tables.add(row.getString("TABLE_NAME"));
                            }
                        } else {
                            tables.add(tableName);
                        }
                        for (String tableName2 : tables) {
                            ResultSet rs = CachingDatabaseMetaData.this.databaseMetaData.getIndexInfo(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), tableName2, false, true);
                            List<CachedRow> rows = this.extract(rs, CachingDatabaseMetaData.this.database instanceof InformixDatabase);
                            returnList.addAll(rows);
                        }
                    }
                    return returnList;
                }

                @Override
                public List<CachedRow> bulkFetch() throws SQLException, DatabaseException {
                    this.bulkFetch = true;
                    return this.fastFetch();
                }

                @Override
                boolean shouldBulkSelect(String schemaKey, ResultSetCache resultSetCache) {
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return super.shouldBulkSelect(schemaKey, resultSetCache);
                    }
                    return false;
                }
            });
        }

        protected void warnAboutDbaRecycleBin() {
            if (!JdbcDatabaseSnapshot.this.warnedAboutDbaRecycleBin && !((OracleDatabase)this.database).canAccessDbaRecycleBin()) {
                LogFactory.getInstance().getLog().warning(((OracleDatabase)this.database).getDbaRecycleBinWarning());
                JdbcDatabaseSnapshot.this.warnedAboutDbaRecycleBin = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<CachedRow> getColumns(final String catalogName, final String schemaName, final String tableName, final String columnName) throws SQLException, DatabaseException {
            if (this.database instanceof MSSQLDatabase && JdbcDatabaseSnapshot.this.userDefinedTypes == null) {
                JdbcDatabaseSnapshot.this.userDefinedTypes = new HashSet();
                DatabaseConnection databaseConnection = this.database.getConnection();
                if (databaseConnection instanceof JdbcConnection) {
                    Statement stmt = null;
                    ResultSet resultSet = null;
                    try {
                        String sql = this.database.getDatabaseMajorVersion() >= 9 ? "select name from sys.types where is_user_defined=1" : "SELECT * FROM SysTypes WHERE xusertype > 256";
                        stmt = ((JdbcConnection)databaseConnection).getUnderlyingConnection().createStatement();
                        resultSet = stmt.executeQuery(sql);
                        while (resultSet.next()) {
                            JdbcDatabaseSnapshot.this.userDefinedTypes.add(resultSet.getString("name").toLowerCase());
                        }
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.close(resultSet, stmt);
                        throw throwable;
                    }
                    JdbcUtils.close(resultSet, stmt);
                }
            }
            return JdbcDatabaseSnapshot.this.getResultSetCache("getColumns").get(new ResultSetCache.SingleResultSetExtractor(this.database){

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("TABLE_NAME"), row.getString("COLUMN_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, tableName, columnName);
                }

                @Override
                boolean shouldBulkSelect(String schemaKey, ResultSetCache resultSetCache) {
                    return !tableName.equalsIgnoreCase(CachingDatabaseMetaData.this.database.getDatabaseChangeLogTableName()) && !tableName.equalsIgnoreCase(CachingDatabaseMetaData.this.database.getDatabaseChangeLogLockTableName());
                }

                @Override
                public List<CachedRow> fastFetchQuery() throws SQLException, DatabaseException {
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return this.oracleQuery(false);
                    }
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    try {
                        return this.extract(CachingDatabaseMetaData.this.databaseMetaData.getColumns(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), tableName, null));
                    }
                    catch (SQLException e) {
                        if (this.shouldReturnEmptyColumns(e)) {
                            return new ArrayList<CachedRow>();
                        }
                        throw e;
                    }
                }

                @Override
                public List<CachedRow> bulkFetchQuery() throws SQLException, DatabaseException {
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return this.oracleQuery(true);
                    }
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    try {
                        return this.extract(CachingDatabaseMetaData.this.databaseMetaData.getColumns(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), null, null));
                    }
                    catch (SQLException e) {
                        if (this.shouldReturnEmptyColumns(e)) {
                            return new ArrayList<CachedRow>();
                        }
                        throw e;
                    }
                }

                protected boolean shouldReturnEmptyColumns(SQLException e) {
                    return e.getMessage().contains("references invalid table");
                }

                protected List<CachedRow> oracleQuery(boolean bulk) throws DatabaseException, SQLException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    boolean getMapDateToTimestamp = true;
                    String sql = "select NULL AS TABLE_CAT, OWNER AS TABLE_SCHEM, 'NO' as IS_AUTOINCREMENT, cc.COMMENTS AS REMARKS,OWNER, TABLE_NAME, COLUMN_NAME, DATA_TYPE AS DATA_TYPE_NAME, DATA_TYPE_MOD, DATA_TYPE_OWNER, DECODE (c.data_type, 'CHAR', 1, 'VARCHAR2', 12, 'NUMBER', 3, 'LONG', -1, 'DATE', " + (getMapDateToTimestamp ? "93" : "91") + ", 'RAW', -3, 'LONG RAW', -4, 'BLOB', 2004, 'CLOB', 2005, 'BFILE', -13, 'FLOAT', 6, 'TIMESTAMP(6)', 93, 'TIMESTAMP(6) WITH TIME ZONE', -101, 'TIMESTAMP(6) WITH LOCAL TIME ZONE', -102, 'INTERVAL YEAR(2) TO MONTH', -103, 'INTERVAL DAY(2) TO SECOND(6)', -104, 'BINARY_FLOAT', 100, 'BINARY_DOUBLE', 101, 'XMLTYPE', 2009, 1111) AS data_type, " + "DECODE( CHAR_USED, 'C',CHAR_LENGTH, DATA_LENGTH ) as DATA_LENGTH, " + "DATA_PRECISION, DATA_SCALE, NULLABLE, COLUMN_ID as ORDINAL_POSITION, DEFAULT_LENGTH, " + "DATA_DEFAULT, " + "NUM_BUCKETS, CHARACTER_SET_NAME, " + "CHAR_COL_DECL_LENGTH, CHAR_LENGTH, " + "CHAR_USED, VIRTUAL_COLUMN " + "FROM ALL_TAB_COLS c " + "JOIN ALL_COL_COMMENTS cc USING ( OWNER, TABLE_NAME, COLUMN_NAME ) " + "WHERE OWNER='" + ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema) + "' AND hidden_column='NO'";
                    if (!bulk) {
                        if (tableName != null) {
                            sql = sql + " AND TABLE_NAME='" + CachingDatabaseMetaData.this.database.escapeStringForDatabase(tableName) + "'";
                        }
                        if (columnName != null) {
                            sql = sql + " AND COLUMN_NAME='" + CachingDatabaseMetaData.this.database.escapeStringForDatabase(columnName) + "'";
                        }
                    }
                    sql = sql + " ORDER BY OWNER, TABLE_NAME, c.COLUMN_ID";
                    return this.executeAndExtract(sql, CachingDatabaseMetaData.this.database);
                }

                @Override
                protected List<CachedRow> extract(ResultSet resultSet, boolean informixIndexTrimHint) throws SQLException {
                    List<CachedRow> rows = super.extract(resultSet, informixIndexTrimHint);
                    if (CachingDatabaseMetaData.this.database instanceof MSSQLDatabase && JdbcDatabaseSnapshot.this.userDefinedTypes.size() > 0) {
                        for (CachedRow row : rows) {
                            String dataType = (String)row.get("TYPE_NAME");
                            if (!JdbcDatabaseSnapshot.this.userDefinedTypes.contains(dataType.toLowerCase())) continue;
                            row.set("COLUMN_SIZE", null);
                            row.set("DECIMAL_DIGITS ", null);
                        }
                    }
                    return rows;
                }
            });
        }

        public List<CachedRow> getTables(final String catalogName, final String schemaName, final String table) throws SQLException, DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getTables").get(new ResultSetCache.SingleResultSetExtractor(this.database){

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("TABLE_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, table);
                }

                @Override
                public List<CachedRow> fastFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return this.queryOracle(catalogAndSchema, table);
                    }
                    String catalog = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema);
                    String schema = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                    return this.extract(CachingDatabaseMetaData.this.databaseMetaData.getTables(catalog, schema, table, new String[]{"TABLE"}));
                }

                @Override
                public List<CachedRow> bulkFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return this.queryOracle(catalogAndSchema, null);
                    }
                    String catalog = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema);
                    String schema = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                    return this.extract(CachingDatabaseMetaData.this.databaseMetaData.getTables(catalog, schema, null, new String[]{"TABLE"}));
                }

                private List<CachedRow> queryOracle(CatalogAndSchema catalogAndSchema, String tableName) throws DatabaseException, SQLException {
                    String ownerName = CachingDatabaseMetaData.this.database.correctObjectName(catalogAndSchema.getCatalogName(), Schema.class);
                    String sql = "SELECT null as TABLE_CAT, a.OWNER as TABLE_SCHEM, a.TABLE_NAME as TABLE_NAME, a.TEMPORARY as TEMPORARY, a.DURATION as DURATION, 'TABLE' as TABLE_TYPE, c.COMMENTS as REMARKS from ALL_TABLES a join ALL_TAB_COMMENTS c on a.TABLE_NAME=c.table_name and a.owner=c.owner WHERE a.OWNER='" + ownerName + "'";
                    if (tableName != null) {
                        sql = sql + " AND a.TABLE_NAME='" + tableName + "'";
                    }
                    return this.executeAndExtract(sql, CachingDatabaseMetaData.this.database);
                }
            });
        }

        public List<CachedRow> getViews(final String catalogName, final String schemaName, final String view) throws SQLException, DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getViews").get(new ResultSetCache.SingleResultSetExtractor(this.database){

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("TABLE_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, view);
                }

                @Override
                public List<CachedRow> fastFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return this.queryOracle(catalogAndSchema, view);
                    }
                    String catalog = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema);
                    String schema = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                    return this.extract(CachingDatabaseMetaData.this.databaseMetaData.getTables(catalog, schema, view, new String[]{"VIEW"}));
                }

                @Override
                public List<CachedRow> bulkFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return this.queryOracle(catalogAndSchema, null);
                    }
                    String catalog = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema);
                    String schema = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                    return this.extract(CachingDatabaseMetaData.this.databaseMetaData.getTables(catalog, schema, null, new String[]{"VIEW"}));
                }

                private List<CachedRow> queryOracle(CatalogAndSchema catalogAndSchema, String viewName) throws DatabaseException, SQLException {
                    String ownerName = CachingDatabaseMetaData.this.database.correctObjectName(catalogAndSchema.getCatalogName(), Schema.class);
                    String sql = "SELECT null as TABLE_CAT, a.OWNER as TABLE_SCHEM, a.VIEW_NAME as TABLE_NAME, 'TABLE' as TABLE_TYPE, c.COMMENTS as REMARKS, TEXT as OBJECT_BODY from ALL_VIEWS a join ALL_TAB_COMMENTS c on a.VIEW_NAME=c.table_name and a.owner=c.owner WHERE a.OWNER='" + ownerName + "'";
                    if (viewName != null) {
                        sql = sql + " AND a.VIEW_NAME='" + viewName + "'";
                    }
                    sql = sql + " AND a.VIEW_NAME not in (select mv.name from all_registered_mviews mv where mv.owner='" + ownerName + "')";
                    return this.executeAndExtract(sql, CachingDatabaseMetaData.this.database);
                }
            });
        }

        public List<CachedRow> getPrimaryKeys(final String catalogName, final String schemaName, final String table) throws SQLException, DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getPrimaryKeys").get(new ResultSetCache.SingleResultSetExtractor(this.database){

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("TABLE_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, table);
                }

                @Override
                public List<CachedRow> fastFetchQuery() throws SQLException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    try {
                        ArrayList<CachedRow> foundPks = new ArrayList<CachedRow>();
                        if (table == null) {
                            List<CachedRow> tables = CachingDatabaseMetaData.this.getTables(catalogName, schemaName, null);
                            for (CachedRow table2 : tables) {
                                List<CachedRow> pkInfo = this.getPkInfo(schemaName, catalogAndSchema, table2.getString("TABLE_NAME"));
                                if (pkInfo == null) continue;
                                foundPks.addAll(pkInfo);
                            }
                            return foundPks;
                        }
                        List<CachedRow> pkInfo = this.getPkInfo(schemaName, catalogAndSchema, table);
                        if (pkInfo != null) {
                            foundPks.addAll(pkInfo);
                        }
                        return foundPks;
                    }
                    catch (DatabaseException e) {
                        throw new SQLException(e);
                    }
                }

                private List<CachedRow> getPkInfo(String schemaName2, CatalogAndSchema catalogAndSchema, String tableName) throws DatabaseException, SQLException {
                    if (!(CachingDatabaseMetaData.this.database instanceof MSSQLDatabase) || CachingDatabaseMetaData.this.database.getDatabaseMajorVersion() < 8) {
                        if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                            CachingDatabaseMetaData.this.warnAboutDbaRecycleBin();
                            String sql = "SELECT NULL AS table_cat, c.owner AS table_schem, c.table_name, c.column_name, c.position AS key_seq, c.constraint_name AS pk_name FROM all_cons_columns c, all_constraints k LEFT JOIN " + (((OracleDatabase)CachingDatabaseMetaData.this.database).canAccessDbaRecycleBin() ? "dba_recyclebin" : "user_recyclebin") + " d ON d.object_name=k.table_name " + "WHERE k.constraint_type = 'P' " + "AND d.object_name IS NULL " + "AND k.table_name = '" + table + "' " + "AND k.owner = '" + ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema) + "' " + "AND k.constraint_name = c.constraint_name " + "AND k.table_name = c.table_name " + "AND k.owner = c.owner " + "ORDER BY column_name";
                            try {
                                return this.executeAndExtract(sql, CachingDatabaseMetaData.this.database);
                            }
                            catch (DatabaseException e) {
                                throw new SQLException(e);
                            }
                        }
                        return this.extract(CachingDatabaseMetaData.this.databaseMetaData.getPrimaryKeys(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), table));
                    }
                    String sql = CachingDatabaseMetaData.this.database.getDatabaseMajorVersion() >= 9 ? "SELECT DB_NAME() AS [TABLE_CAT], [s].[name] AS [TABLE_SCHEM], [t].[name] AS [TABLE_NAME], [c].[name] AS [COLUMN_NAME], CASE [ic].[is_descending_key] WHEN 0 THEN N'A' WHEN 1 THEN N'D' END AS [ASC_OR_DESC], [ic].[key_ordinal] AS [KEY_SEQ], [kc].[name] AS [PK_NAME] FROM [sys].[schemas] AS [s] INNER JOIN [sys].[tables] AS [t] ON [t].[schema_id] = [s].[schema_id] INNER JOIN [sys].[key_constraints] AS [kc] ON [kc].[parent_object_id] = [t].[object_id] INNER JOIN [sys].[indexes] AS [i] ON [i].[object_id] = [kc].[parent_object_id] AND [i].[index_id] = [kc].[unique_index_id] INNER JOIN [sys].[index_columns] AS [ic] ON [ic].[object_id] = [i].[object_id] AND [ic].[index_id] = [i].[index_id] INNER JOIN [sys].[columns] AS [c] ON [c].[object_id] = [ic].[object_id] AND [c].[column_id] = [ic].[column_id] WHERE [s].[name] = N'" + CachingDatabaseMetaData.this.database.escapeStringForDatabase(catalogAndSchema.getSchemaName()) + "' " + "AND [t].[name] = N'" + CachingDatabaseMetaData.this.database.escapeStringForDatabase(CachingDatabaseMetaData.this.database.correctObjectName(tableName, Table.class)) + "' " + "AND [kc].[type] = 'PK' " + "AND [ic].[key_ordinal] > 0 " + "ORDER BY " + "[ic].[key_ordinal]" : "SELECT DB_NAME() AS [TABLE_CAT], [s].[name] AS [TABLE_SCHEM], [t].[name] AS [TABLE_NAME], [c].[name] AS [COLUMN_NAME], CASE INDEXKEY_PROPERTY([ic].[id], [ic].[indid], [ic].[keyno], 'IsDescending') WHEN 0 THEN N'A' WHEN 1 THEN N'D' END AS [ASC_OR_DESC], [ic].[keyno] AS [KEY_SEQ], [kc].[name] AS [PK_NAME] FROM [dbo].[sysusers] AS [s] INNER JOIN [dbo].[sysobjects] AS [t] ON [t].[uid] = [s].[uid] INNER JOIN [dbo].[sysobjects] AS [kc] ON [kc].[parent_obj] = [t].[id] INNER JOIN [dbo].[sysindexes] AS [i] ON [i].[id] = [kc].[parent_obj] AND [i].[name] = [kc].[name] INNER JOIN [dbo].[sysindexkeys] AS [ic] ON [ic].[id] = [i].[id] AND [ic].[indid] = [i].[indid] INNER JOIN [dbo].[syscolumns] AS [c] ON [c].[id] = [ic].[id] AND [c].[colid] = [ic].[colid] WHERE [s].[name] =  N'" + CachingDatabaseMetaData.this.database.escapeStringForDatabase(catalogAndSchema.getSchemaName()) + "' " + "AND [t].[name] = N'" + CachingDatabaseMetaData.this.database.escapeStringForDatabase(CachingDatabaseMetaData.this.database.correctObjectName(tableName, Table.class)) + "' " + "AND [kc].[xtype] = 'PK' " + "ORDER BY " + "[ic].[keyno]";
                    List<CachedRow> pkInfo = this.executeAndExtract(sql, CachingDatabaseMetaData.this.database);
                    return pkInfo;
                }

                @Override
                public List<CachedRow> bulkFetchQuery() throws SQLException {
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                        CachingDatabaseMetaData.this.warnAboutDbaRecycleBin();
                        try {
                            return this.executeAndExtract("SELECT NULL AS table_cat, c.owner AS table_schem, c.table_name, c.column_name, c.position AS key_seq,c.constraint_name AS pk_name FROM all_cons_columns c, all_constraints k LEFT JOIN " + (((OracleDatabase)CachingDatabaseMetaData.this.database).canAccessDbaRecycleBin() ? "dba_recyclebin" : "user_recyclebin") + " d ON d.object_name=k.table_name " + "WHERE k.constraint_type = 'P' " + "AND d.object_name IS NULL " + "AND k.owner='" + catalogAndSchema.getCatalogName() + "' " + "AND k.constraint_name = c.constraint_name " + "AND k.table_name = c.table_name " + "AND k.owner = c.owner " + "ORDER BY column_name", CachingDatabaseMetaData.this.database);
                        }
                        catch (DatabaseException e) {
                            throw new SQLException(e);
                        }
                    }
                    return null;
                }

                @Override
                boolean shouldBulkSelect(String schemaKey, ResultSetCache resultSetCache) {
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return super.shouldBulkSelect(schemaKey, resultSetCache);
                    }
                    return false;
                }
            });
        }

        public List<CachedRow> getUniqueConstraints(final String catalogName, final String schemaName, final String tableName) throws SQLException, DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getUniqueConstraints").get(new ResultSetCache.SingleResultSetExtractor(this.database){

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, row.getString("TABLE_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, tableName);
                }

                @Override
                public List<CachedRow> fastFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    return this.executeAndExtract(this.createSql(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), tableName), JdbcDatabaseSnapshot.this.getDatabase(), CachingDatabaseMetaData.this.database instanceof InformixDatabase);
                }

                @Override
                public List<CachedRow> bulkFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    return this.executeAndExtract(this.createSql(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), null), JdbcDatabaseSnapshot.this.getDatabase());
                }

                private String createSql(String catalogName2, String schemaName2, String tableName2) throws SQLException {
                    String sql;
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName2, schemaName2).customize(CachingDatabaseMetaData.this.database);
                    String jdbcCatalogName = CachingDatabaseMetaData.this.database.correctObjectName(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), Catalog.class);
                    String jdbcSchemaName = CachingDatabaseMetaData.this.database.correctObjectName(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), Schema.class);
                    Database database = JdbcDatabaseSnapshot.this.getDatabase();
                    if (database instanceof MySQLDatabase || database instanceof HsqlDatabase) {
                        sql = "select CONSTRAINT_NAME, TABLE_NAME from " + database.getSystemSchema() + ".table_constraints " + "where constraint_schema='" + jdbcCatalogName + "' " + "and constraint_type='UNIQUE'";
                        if (tableName2 != null) {
                            sql = sql + " and table_name='" + tableName2 + "'";
                        }
                    } else if (database instanceof PostgresDatabase) {
                        sql = "select CONSTRAINT_NAME, TABLE_NAME from " + database.getSystemSchema() + ".table_constraints " + "where constraint_catalog='" + jdbcCatalogName + "' " + "and constraint_schema='" + jdbcSchemaName + "' " + "and constraint_type='UNIQUE'";
                        if (tableName2 != null) {
                            sql = sql + " and table_name='" + tableName2 + "'";
                        }
                    } else if (database instanceof MSSQLDatabase) {
                        sql = "SELECT [TC].[CONSTRAINT_NAME], [TC].[TABLE_NAME], [IDX].[TYPE_DESC] FROM [INFORMATION_SCHEMA].[TABLE_CONSTRAINTS] AS [TC] JOIN SYS.INDEXES AS IDX ON IDX.name=[TC].[CONSTRAINT_NAME] AND object_schema_name(object_id)=[TC].[CONSTRAINT_SCHEMA] WHERE [TC].[CONSTRAINT_TYPE] = 'UNIQUE' AND [TC].[CONSTRAINT_CATALOG] = N'" + database.escapeStringForDatabase(jdbcCatalogName) + "' " + "AND [TC].[CONSTRAINT_SCHEMA] = N'" + database.escapeStringForDatabase(jdbcSchemaName) + "'";
                        if (tableName2 != null) {
                            sql = sql + " AND [TC].[TABLE_NAME] = N'" + database.escapeStringForDatabase(database.correctObjectName(tableName2, Table.class)) + "'";
                        }
                    } else if (database instanceof OracleDatabase) {
                        CachingDatabaseMetaData.this.warnAboutDbaRecycleBin();
                        sql = "select uc.constraint_name, uc.table_name,uc.status,uc.deferrable,uc.deferred,ui.tablespace_name, ui.index_name, ui.owner as INDEX_CATALOG from all_constraints uc join all_indexes ui on uc.index_name = ui.index_name and uc.owner=ui.table_owner LEFT JOIN " + (((OracleDatabase)database).canAccessDbaRecycleBin() ? "dba_recyclebin" : "user_recyclebin") + " d ON d.object_name=ui.table_name " + "where uc.constraint_type='U' " + "and uc.owner = '" + jdbcSchemaName + "'" + "AND d.object_name IS NULL ";
                        if (tableName2 != null) {
                            sql = sql + " and uc.table_name = '" + tableName2 + "'";
                        }
                    } else if (database instanceof DB2Database) {
                        if (database.getDatabaseProductName().startsWith("DB2 UDB for AS/400")) {
                            sql = "select constraint_name as constraint_name, table_name as table_name from QSYS2.TABLE_CONSTRAINTS where table_schema='" + jdbcSchemaName + "' and constraint_type='UNIQUE'";
                            if (tableName2 != null) {
                                sql = sql + " and table_name = '" + tableName2 + "'";
                            }
                        } else {
                            sql = "select distinct k.constname as constraint_name, t.tabname as TABLE_NAME from syscat.keycoluse k, syscat.tabconst t where k.constname = t.constname and t.tabschema = '" + jdbcSchemaName + "' " + "and t.type='U'";
                            if (tableName2 != null) {
                                sql = sql + " and t.tabname = '" + tableName2 + "'";
                            }
                        }
                    } else if (database instanceof FirebirdDatabase) {
                        sql = "SELECT RDB$INDICES.RDB$INDEX_NAME AS CONSTRAINT_NAME, RDB$INDICES.RDB$RELATION_NAME AS TABLE_NAME FROM RDB$INDICES LEFT JOIN RDB$RELATION_CONSTRAINTS ON RDB$RELATION_CONSTRAINTS.RDB$INDEX_NAME = RDB$INDICES.RDB$INDEX_NAME WHERE RDB$INDICES.RDB$UNIQUE_FLAG IS NOT NULL AND RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_TYPE != 'PRIMARY KEY' AND NOT(RDB$INDICES.RDB$INDEX_NAME LIKE 'RDB$%')";
                        if (tableName2 != null) {
                            sql = sql + " AND RDB$INDICES.RDB$RELATION_NAME='" + tableName2 + "'";
                        }
                    } else if (database instanceof DerbyDatabase) {
                        sql = "select c.constraintname as CONSTRAINT_NAME, tablename AS TABLE_NAME from sys.systables t, sys.sysconstraints c, sys.sysschemas s where s.schemaname='" + jdbcCatalogName + "' " + "and t.tableid = c.tableid " + "and t.schemaid=s.schemaid " + "and c.type = 'U'";
                        if (tableName2 != null) {
                            sql = sql + " AND t.tablename = '" + tableName2 + "'";
                        }
                    } else if (database instanceof InformixDatabase) {
                        sql = "select unique sysindexes.idxname as CONSTRAINT_NAME, sysindexes.idxtype, systables.tabname as TABLE_NAME from sysindexes, systables left outer join sysconstraints on sysconstraints.tabid = systables.tabid and sysconstraints.constrtype = 'P' where sysindexes.tabid = systables.tabid and sysindexes.idxtype = 'U' and sysconstraints.idxname != sysindexes.idxname and sysconstraints.tabid = sysindexes.tabid";
                        if (tableName2 != null) {
                            sql = sql + " and systables.tabname = '" + database.correctObjectName(tableName2, Table.class) + "'";
                        }
                    } else {
                        if (database instanceof SybaseDatabase) {
                            LogFactory.getLogger().warning("Finding unique constraints not currently supported for Sybase");
                            return null;
                        }
                        if (database instanceof SybaseASADatabase) {
                            sql = "select sysconstraint.constraint_name, sysconstraint.constraint_type, systable.table_name from sysconstraint, systable where sysconstraint.table_object_id = systable.object_id and sysconstraint.constraint_type = 'U'";
                            if (tableName2 != null) {
                                sql = sql + " and systable.table_name = '" + tableName2 + "'";
                            }
                        } else {
                            sql = "select CONSTRAINT_NAME, CONSTRAINT_TYPE, TABLE_NAME from " + database.getSystemSchema() + ".constraints " + "where constraint_schema='" + jdbcSchemaName + "' " + "and constraint_catalog='" + jdbcCatalogName + "' " + "and constraint_type='UNIQUE'";
                            if (tableName2 != null) {
                                sql = sql + " and table_name='" + tableName2 + "'";
                            }
                        }
                    }
                    return sql;
                }
            });
        }
    }
}

