/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.api.v1.forms.TimeFrame;
import com.xebialabs.xlrelease.db.ArchivedPhasesReports;
import com.xebialabs.xlrelease.db.ArchivedReleasesReports;
import com.xebialabs.xlrelease.db.ArchivedTasksReports;
import com.xebialabs.xlrelease.reports.AverageAndLongestReleaseDuration;
import com.xebialabs.xlrelease.reports.AverageAndLongestTaskDuration;
import com.xebialabs.xlrelease.reports.CompletedReleases;
import com.xebialabs.xlrelease.reports.LongestTaskType;
import com.xebialabs.xlrelease.reports.PhaseDuration;
import com.xebialabs.xlrelease.reports.ReleaseAutomationComputer;
import com.xebialabs.xlrelease.reports.ReleaseAutomationData;
import com.xebialabs.xlrelease.reports.ReleaseDuration;
import com.xebialabs.xlrelease.reports.ReleaseEfficiency;
import com.xebialabs.xlrelease.reports.ReleasesAutomation;
import com.xebialabs.xlrelease.reports.ReleasesDuration;
import com.xebialabs.xlrelease.reports.TaskDuration;
import com.xebialabs.xlrelease.reports.UserParticipation;
import com.xebialabs.xlrelease.views.Point;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportService {
    public static final int TOP_REPORT_SIZE = 100;
    private final ArchivedReleasesReports archivedReleasesReports;
    private final ArchivedPhasesReports archivedPhasesReports;
    private final ArchivedTasksReports archivedTasksReports;

    @Autowired
    public ReportService(ArchivedReleasesReports archivedReleasesReports, ArchivedPhasesReports archivedPhasesReports, ArchivedTasksReports archivedTasksReports) {
        this.archivedReleasesReports = archivedReleasesReports;
        this.archivedPhasesReports = archivedPhasesReports;
        this.archivedTasksReports = archivedTasksReports;
    }

    @Timed
    public ReleasesDuration getReleaseDuration(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        List<Point> releaseDuration = this.archivedReleasesReports.getReleaseDuration(timeFrame, tags, from, to);
        List<ReleaseDuration> topLongestReleases = this.archivedReleasesReports.getLongestReleases(timeFrame, tags, from, to);
        return new ReleasesDuration(releaseDuration, topLongestReleases);
    }

    @Timed
    public CompletedReleases getCompletedReleases(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        return this.archivedReleasesReports.getCompletedReleases(timeFrame, tags, from, to);
    }

    @Timed
    public AverageAndLongestReleaseDuration getAverageAndLongestReleaseDuration(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        return this.archivedReleasesReports.getAverageAndLongestReleaseDuration(timeFrame, tags, from, to);
    }

    @Timed
    public List<UserParticipation> getTopPeopleMostInvolved(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        return this.archivedTasksReports.getTopPeopleInvolved(timeFrame, tags, from, to);
    }

    @Timed
    public List<TaskDuration> getTopLongestTasks(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        return this.archivedTasksReports.getTopLongestTasks(timeFrame, tags, from, to);
    }

    @Timed
    public List<LongestTaskType> getTopLongestTaskTypes(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        return this.archivedTasksReports.getTopLongestTaskTypes(timeFrame, tags, from, to);
    }

    @Timed
    public AverageAndLongestTaskDuration getAverageAndLongestTaskDuration(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        return this.archivedTasksReports.getAverageAndLongestTaskDuration(timeFrame, tags, from, to);
    }

    @Timed
    public ReleasesAutomation getReleaseAutomationSeries(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        ReleaseEfficiency releaseEfficiency = this.archivedTasksReports.getReleaseEfficiency(timeFrame, tags, from, to);
        List<ReleaseAutomationData> releaseAutomationData = this.getReleaseAutomation(timeFrame, tags, from, to, null);
        ReleaseAutomationComputer computer = new ReleaseAutomationComputer(releaseAutomationData, releaseEfficiency);
        return computer.get();
    }

    @Timed
    public List<PhaseDuration> getTopLongestPhases(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        return this.archivedPhasesReports.getTopLongestPhases(timeFrame, tags, from, to);
    }

    @Timed
    public List<Point> getNumberOfReleaseByMonth(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to) {
        return this.archivedReleasesReports.getNumberOfReleaseByMonth(timeFrame, tags, from, to);
    }

    @Timed
    public List<ReleaseAutomationData> getReleaseAutomation(TimeFrame timeFrame, Iterable<String> tags, Date from, Date to, Integer limit) {
        return this.archivedReleasesReports.getReleaseAutomation(timeFrame, tags, from, to, limit);
    }
}

