/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.persistence;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderId$;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleaseStoreException;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder$;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema$DEPENDENCIES$;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema$FOLDERS$;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema$RELEASES$;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.Map;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Profile(value={"sql"})
@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\t\u0005e\u0001B\u0001\u0003\u0001=\u0011Q\u0003R3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cWM\u0003\u0002\u0004\t\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\n\u0015\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u00171\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00035\t1aY8n\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003H\u0007\u00021)\u0011\u0011DG\u0001\u0006g24GG\u001b\u0006\u00027\u0005AqM]5{u2,G-\u0003\u0002\u001e1\t9Aj\\4hS:<\u0007\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011\u0001\u0011\u0002\u0019)$'m\u0019+f[Bd\u0017\r^3\u0016\u0003\u0005\u0002\"AI\u0016\u000e\u0003\rR!\u0001J\u0013\u0002\t\r|'/\u001a\u0006\u0003M\u001d\nAA\u001b3cG*\u0011\u0001&K\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t!&A\u0002pe\u001eL!\u0001L\u0012\u0003\u0019)#'m\u0019+f[Bd\u0017\r^3\t\u00119\u0002!\u0011!Q\u0001\n\u0005\nQB\u001b3cGR+W\u000e\u001d7bi\u0016\u0004\u0003\u0002\u0003\u0019\u0001\u0005\u000b\u0007I1A\u0019\u0002\u0015M\fH\u000eR5bY\u0016\u001cG/F\u00013!\t\u0019dI\u0004\u00025\u0007:\u0011Q'\u0011\b\u0003m}r!a\u000e \u000f\u0005ajdBA\u001d=\u001b\u0005Q$BA\u001e\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u0001\"\t!\u0001\u001a2\n\u0005\u0015\u0011%B\u0001!\t\u0013\t!U)\u0001\u0006Tc2\u0014U/\u001b7eKJT!!\u0002\"\n\u0005\u001dC%a\u0002#jC2,7\r\u001e\u0006\u0003\t\u0016C\u0001B\u0013\u0001\u0003\u0002\u0003\u0006IAM\u0001\fgFdG)[1mK\u000e$\b\u0005C\u0003M\u0001\u0011\u0005Q*\u0001\u0004=S:LGO\u0010\u000b\u0004\u001dB{\u0006CA(\u0001\u001b\u0005\u0011\u0001\"B\u0010L\u0001\u0004\t\u0003\u0006\u0002)S9v\u0003\"a\u0015.\u000e\u0003QS!!\u0016,\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002X1\u00069a-Y2u_JL(BA-(\u0003\u0015\u0011W-\u00198t\u0013\tYFKA\u0005Rk\u0006d\u0017NZ5fe\u0006)a/\u00197vK\u0006\na,A\ryYJ\u0014V\r]8tSR|'/\u001f&eE\u000e$V-\u001c9mCR,\u0007\"\u0002\u0019L\u0001\b\u0011\u0004\u0006B0S9\u0006\f\u0013AY\u0001\u0018q2\u0014(+\u001a9pg&$xN]=Tc2$\u0015.\u00197fGRD#a\u00133\u0011\u0005M+\u0017B\u00014U\u0005%\tU\u000f^8xSJ,G\rC\u0004i\u0001\t\u0007I\u0011B5\u0002\u001b9\fW.\u001a3UK6\u0004H.\u0019;f+\u0005Q\u0007CA6o\u001b\u0005a'BA7$\u0003)q\u0017-\\3ea\u0006\u0014\u0018-\\\u0005\u0003_2\u0014!DT1nK\u0012\u0004\u0016M]1nKR,'O\u00133cGR+W\u000e\u001d7bi\u0016Da!\u001d\u0001!\u0002\u0013Q\u0017A\u00048b[\u0016$G+Z7qY\u0006$X\r\t\u0005\u0006g\u0002!I\u0001^\u0001\bm\u0006\u0014\u0018M]4t+\r)\u00181\u0005\u000b\u0004m\u0006%\u0001#B\txs\u0006\r\u0011B\u0001=\u0013\u0005\u0019!V\u000f\u001d7feA\u0011!P \b\u0003wr\u0004\"!\u000f\n\n\u0005u\u0014\u0012A\u0002)sK\u0012,g-C\u0002\u0000\u0003\u0003\u0011aa\u0015;sS:<'BA?\u0013!\u0011\t\u0012Q\u0001\t\n\u0007\u0005\u001d!CA\u0003BeJ\f\u0017\u0010C\u0004\u0002\fI\u0004\r!!\u0004\u0002\t\u0005\u0014xm\u001d\t\u0007\u0003\u001f\tI\"a\b\u000f\t\u0005E\u0011Q\u0003\b\u0004s\u0005M\u0011\"A\n\n\u0007\u0005]!#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0011Q\u0004\u0002\t\u0013R,'/\u00192mK*\u0019\u0011q\u0003\n\u0011\t\u0005\u0005\u00121\u0005\u0007\u0001\t\u001d\t)C\u001db\u0001\u0003O\u0011\u0011\u0001V\t\u0005\u0003S\ty\u0003E\u0002\u0012\u0003WI1!!\f\u0013\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!EA\u0019\u0013\r\t\u0019D\u0005\u0002\u0004\u0003:L\bbBA\u001c\u0001\u0011%\u0011\u0011H\u0001\rM&dG/\u001a:Ti\u0006$Xo\u001d\u000b\u0004m\u0006m\u0002\u0002CA\u001f\u0003k\u0001\r!a\u0010\u0002\rM$\u0018\r^;t!\u0015\t\u0012\u0011IA#\u0013\r\t\u0019E\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\ti\f9%_\u0005\u0005\u0003\u0013\n\tAA\u0002TKRD\u0011\"!\u0014\u0001\u0005\u0004%I!a\u0014\u0002\u001b\u0011,g-Y;mi6\u000b\u0007\u000f]3s+\t\t\t\u0006E\u0003#\u0003'\n9&C\u0002\u0002V\r\u0012\u0011BU8x\u001b\u0006\u0004\b/\u001a:\u0011\t\u0005e\u0013qL\u0007\u0003\u00037R1!!\u0018\u0003\u0003\u0011!\u0017\r^1\n\t\u0005\u0005\u00141\f\u0002\u000e\t\u0016\u0004XM\u001c3f]\u000eL(k\\<\t\u0011\u0005\u0015\u0004\u0001)A\u0005\u0003#\na\u0002Z3gCVdG/T1qa\u0016\u0014\b\u0005C\u0005\u0002j\u0001\u0011\r\u0011\"\u0003\u0002l\u0005a2\u000bV'U?\u001aKe\nR0C3~;\u0015\tV#`%\u0016cU)Q*F?&#U#A=\t\u000f\u0005=\u0004\u0001)A\u0005s\u0006i2\u000bV'U?\u001aKe\nR0C3~;\u0015\tV#`%\u0016cU)Q*F?&#\u0005\u0005C\u0004\u0002t\u0001!\t!!\u001e\u0002'\u0019Lg\u000e\u001a\"z\u000f\u0006$XMU3mK\u0006\u001cX-\u00133\u0015\t\u0005]\u0014Q\u0010\t\u0007\u0003\u001f\tI(a\u0016\n\t\u0005m\u0014Q\u0004\u0002\u0004'\u0016\f\b\u0002CA@\u0003c\u0002\r!!!\u0002\u0013I,G.Z1tK&#\u0007\u0003BAB\u0003+sA!!\"\u0002\u0012:!\u0011qQAH\u001d\u0011\tI)!$\u000f\u0007Y\nY)\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I1!a%\u0003\u0003\u0011\u0019\u0015.\u00133\n\t\u0005]\u0015\u0011\u0014\u0002\u0005\u0007&LEMC\u0002\u0002\u0014\nAq!!(\u0001\t\u0003\ty*\u0001\fgS:$')\u001f)beRL\u0017\r\u001c+be\u001e,G/\u00133t)\u0019\t9(!)\u0002(\"A\u00111UAN\u0001\u0004\t)+A\u0005qCJ,g\u000e^%egB)!0a\u0012\u0002\u0002\"A\u0011QHAN\u0001\u0004\ty\u0004C\u0005\u0002,\u0002\u0011\r\u0011\"\u0003\u0002l\u0005y1\u000bV'U?\u001aKe\nR0C3~KE\tC\u0004\u00020\u0002\u0001\u000b\u0011B=\u0002!M#V\nV0G\u0013:#uLQ-`\u0013\u0012\u0003\u0003bBAZ\u0001\u0011\u0005\u0011QW\u0001\tM&tGMQ=JIR!\u0011qKA\\\u0011!\tI,!-A\u0002\u0005\u0005\u0015\u0001\u00043fa\u0016tG-\u001a8ds&#\u0007bBA_\u0001\u0011\u0005\u0011qX\u0001\u0010M&tGMQ=UCJ<W\r^%egR1\u0011qOAa\u0003\u000bD\u0001\"a1\u0002<\u0002\u0007\u0011QU\u0001\ni\u0006\u0014x-\u001a;JIND\u0001\"!\u0010\u0002<\u0002\u0007\u0011q\b\u0005\n\u0003\u0013\u0004!\u0019!C\u0005\u0003W\nac\u0015+N)~KejU#S)~#U\tU#O\t\u0016s5)\u0017\u0005\b\u0003\u001b\u0004\u0001\u0015!\u0003z\u0003]\u0019F+\u0014+`\u0013:\u001bVI\u0015+`\t\u0016\u0003VI\u0014#F\u001d\u000eK\u0006\u0005C\u0004\u0002R\u0002!\t!a5\u0002!%t7/\u001a:u\t\u0016\u0004XM\u001c3f]\u000eLH\u0003BAk\u0003[$B!a6\u0002^B\u0019\u0011#!7\n\u0007\u0005m'C\u0001\u0003V]&$\b\u0002CAp\u0003\u001f\u0004\r!!9\u0002\u0015\u0011,\u0007/\u001a8eK:\u001c\u0017\u0010\u0005\u0003\u0002d\u0006%XBAAs\u0015\r\t9\u000fC\u0001\u0007I>l\u0017-\u001b8\n\t\u0005-\u0018Q\u001d\u0002\u000b\t\u0016\u0004XM\u001c3f]\u000eL\b\u0002CAx\u0003\u001f\u0004\r!!=\u0002\u000fI,G.Z1tKB!\u00111]Az\u0013\u0011\t)0!:\u0003\u000fI+G.Z1tK\"I\u0011\u0011 \u0001C\u0002\u0013%\u00111N\u0001\f'RkEk\u0018#F\u0019\u0016#V\tC\u0004\u0002~\u0002\u0001\u000b\u0011B=\u0002\u0019M#V\nV0E\u000b2+E+\u0012\u0011\t\u000f\t\u0005\u0001\u0001\"\u0001\u0003\u0004\u0005\u0001B-\u001a7fi\u0016$U\r]3oI\u0016t7-\u001f\u000b\u0005\u0003/\u0014)\u0001C\u0004\u0003\b\u0005}\b\u0019A=\u0002\u0005%$\u0007b\u0002B\u0001\u0001\u0011\u0005!1\u0002\u000b\u0005\u0003/\u0014i\u0001\u0003\u0005\u0002`\n%\u0001\u0019AAq\u0011%\u0011\t\u0002\u0001b\u0001\n\u0013\tY'\u0001\u000eT)6#v\fR#M\u000bR+uLQ-`%\u0016cU)Q*F?VKE\tC\u0004\u0003\u0016\u0001\u0001\u000b\u0011B=\u00027M#V\nV0E\u000b2+E+R0C3~\u0013V\tT#B'\u0016{V+\u0013#!\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057\t!\u0003Z3mKR,')\u001f*fY\u0016\f7/Z+jIR!!Q\u0004B\u0012!\r\t\"qD\u0005\u0004\u0005C\u0011\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0005K\u00119\u00021\u0001\u0003(\u0005Q!/\u001a7fCN,W+\u001b3\u0011\t\t%\"Q\u0006\b\u0004\u001f\n-\u0012bAA\f\u0005%!!q\u0006B\u0019\u0005\u0015\u0019\u0015.V5e\u0015\r\t9B\u0001\u0005\n\u0005k\u0001!\u0019!C\u0005\u0003W\n1b\u0015+N)~+\u0006\u000bR!U\u000b\"9!\u0011\b\u0001!\u0002\u0013I\u0018\u0001D*U\u001bR{V\u000b\u0015#B)\u0016\u0003\u0003b\u0002B\u001f\u0001\u0011\u0005!qH\u0001\u0011kB$\u0017\r^3EKB,g\u000eZ3oGf$BA!\u0011\u0003FQ!\u0011q\u001bB\"\u0011!\tyNa\u000fA\u0002\u0005\u0005\b\u0002CAx\u0005w\u0001\r!!=\t\u000f\t%\u0003\u0001\"\u0003\u0003L\u0005Qq-\u001a;UCJ<W\r^:\u0015\t\t5#q\n\t\u0005#]L\u0018\u0010\u0003\u0005\u0002`\n\u001d\u0003\u0019AAqQ\r\u0001!1\u000b\t\u0005\u0005+\u0012Y&\u0004\u0002\u0003X)\u0019!\u0011L#\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0005;\u00129FA\bJgR\u0013\u0018M\\:bGRLwN\\1mQ\r\u0001!\u0011\r\t\u0005\u0005G\u0012I'\u0004\u0002\u0003f)\u0019!qM\u0014\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0003l\t\u0015$A\u0003*fa>\u001c\u0018\u000e^8ss\"2\u0001Aa\u001c]\u0005{\u0002BA!\u001d\u0003z5\u0011!1\u000f\u0006\u0004+\nU$b\u0001B<O\u000591m\u001c8uKb$\u0018\u0002\u0002B>\u0005g\u0012q\u0001\u0015:pM&dW\r\f\u0002\u0003\u0000\u0005\nQ\u0001")
public class DependencyPersistence
implements Logging {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect sqlDialect;
    private final NamedParameterJdbcTemplate namedTemplate;
    private final RowMapper<DependencyRow> defaultMapper;
    private final String STMT_FIND_BY_GATE_RELEASE_ID;
    private final String STMT_FIND_BY_ID;
    private final String STMT_INSERT_DEPENDENCY;
    private final String STMT_DELETE;
    private final String STMT_DELETE_BY_RELEASE_UID;
    private final String STMT_UPDATE;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyPersistence dependencyPersistence = this;
        synchronized (dependencyPersistence) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    private NamedParameterJdbcTemplate namedTemplate() {
        return this.namedTemplate;
    }

    private <T> Tuple2<String, Object[]> varargs(Iterable<T> args) {
        Seq seq = args.toSeq();
        Tuple2 tuple2 = new Tuple2((Object)((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x$1 -> "?", Seq$.MODULE$.canBuildFrom())).mkString(", "), ((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.AnyRef()));
        return tuple2;
    }

    private Tuple2<String, Object[]> filterStatus(Option<Set<String>> status) {
        return (Tuple2)status.fold((Function0 & Serializable & scala.Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), Array$.MODULE$.empty(ClassTag$.MODULE$.AnyRef())), (Function1 & Serializable & scala.Serializable)statuses -> {
            Tuple2<String, Object[]> tuple2 = this.varargs((Iterable)statuses);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String placeholdersStatus = (String)tuple2._1();
            Object[] argsStatus = (Object[])tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AND d.", " IN (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.GATE_STATUS(), placeholdersStatus}))), (Object)argsStatus);
            return tuple22;
        });
    }

    private RowMapper<DependencyRow> defaultMapper() {
        return this.defaultMapper;
    }

    private String STMT_FIND_BY_GATE_RELEASE_ID() {
        return this.STMT_FIND_BY_GATE_RELEASE_ID;
    }

    public Seq<DependencyRow> findByGateReleaseId(String releaseId) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Find dependencies by gate releaseId: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})));
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(this.STMT_FIND_BY_GATE_RELEASE_ID(), this.defaultMapper(), new Object[]{Ids.getName((String)CiId$.MODULE$.RichCiId(releaseId).normalized())})).asScala();
    }

    public Seq<DependencyRow> findByPartialTargetIds(Set<String> parentIds, Option<Set<String>> status) {
        Nil$ nil$;
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Find dependencies by targetIds starting with ", " with statuses ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parentIds, status})));
        if (parentIds.isEmpty()) {
            nil$ = Nil$.MODULE$;
        } else {
            String clause = ((TraversableOnce)parentIds.map((Function1 & Serializable & scala.Serializable)id -> {
                Tuple2 tuple2 = new Tuple2((Object)Ids.getReleaselessChildId((String)CiId$.MODULE$.RichCiId((String)id).normalized()), (Object)Ids.getName((String)Ids.releaseIdFrom((String)CiId$.MODULE$.RichCiId((String)id).normalized())));
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    String releaseId = (String)tuple2._2();
                    if (string == null) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.", " LIKE '", "%'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$RELEASES$.MODULE$.RELEASE_ID(), releaseId}));
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                String targetId = (String)tuple2._1();
                String releaseId = (String)tuple2._2();
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d.", " LIKE '", "%' AND t.", " = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.TARGET_ID(), targetId, Schema$RELEASES$.MODULE$.RELEASE_ID(), releaseId}));
            }, Set$.MODULE$.canBuildFrom())).mkString("(", " OR ", ")");
            Tuple2<String, Object[]> tuple2 = this.filterStatus(status);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String statusQuery = (String)tuple2._1();
            Object[] args = (Object[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)statusQuery, (Object)args);
            Tuple2 tuple23 = tuple22;
            String statusQuery2 = (String)tuple23._1();
            Object[] args2 = (Object[])tuple23._2();
            nil$ = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT\n           | d.", ",\n           | ", ",\n           | d.", ",\n           | d.", ",\n           | ", "\n           |  FROM ", " d\n           |  JOIN ", " r ON\n           |    r.", " = d.", "\n           |  JOIN ", " fr ON\n           |    fr.", " = r.", "\n           |  JOIN ", " t ON\n           |    t.", " = d.", "\n           |  JOIN ", " ft ON\n           |    ft.", " = t.", "\n           |  WHERE ", "\n           |  ", "\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID(), ReleasesSqlBuilder$.MODULE$.selectReleaseFullPathSql("r", "fr", Schema$RELEASES$.MODULE$.RELEASE_ID(), this.sqlDialect()), Schema$DEPENDENCIES$.MODULE$.GATE_STATUS(), Schema$DEPENDENCIES$.MODULE$.TARGET_ID(), ReleasesSqlBuilder$.MODULE$.selectReleaseFullPathSql("t", "ft", Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_ID(), this.sqlDialect()), Schema$DEPENDENCIES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.CI_UID(), Schema$DEPENDENCIES$.MODULE$.GATE_RELEASE_UID(), Schema$FOLDERS$.MODULE$.TABLE(), Schema$FOLDERS$.MODULE$.CI_UID(), Schema$RELEASES$.MODULE$.FOLDER_CI_UID(), Schema$RELEASES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.CI_UID(), Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID(), Schema$FOLDERS$.MODULE$.TABLE(), Schema$FOLDERS$.MODULE$.CI_UID(), Schema$RELEASES$.MODULE$.FOLDER_CI_UID(), clause, statusQuery2})))).stripMargin(), args2, this.defaultMapper())).asScala();
        }
        return nil$;
    }

    private String STMT_FIND_BY_ID() {
        return this.STMT_FIND_BY_ID;
    }

    public DependencyRow findById(String dependencyId) {
        DependencyRow d;
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Find dependency by id: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependencyId})));
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (DependencyRow)this.jdbcTemplate().queryForObject(this.STMT_FIND_BY_ID(), this.defaultMapper(), new Object[]{Ids.getReleaselessChildId((String)CiId$.MODULE$.RichCiId(dependencyId).normalized()), Ids.getName((String)Ids.releaseIdFrom((String)CiId$.MODULE$.RichCiId(dependencyId).normalized()))}));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable e = failure.exception();
                if (e instanceof EmptyResultDataAccessException) {
                    EmptyResultDataAccessException emptyResultDataAccessException = (EmptyResultDataAccessException)e;
                    throw new NotFoundException((Throwable)emptyResultDataAccessException, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dependency with Id '", "' not found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependencyId})), new Object[0]);
                }
            }
            if (bl) {
                Throwable t = failure.exception();
                throw t;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        DependencyRow dependencyRow = d = (DependencyRow)success.value();
        return dependencyRow;
    }

    public Seq<DependencyRow> findByTargetIds(Set<String> targetIds, Option<Set<String>> status) {
        Nil$ nil$;
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Find dependencies by targetIds: ", " with statuses ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetIds, status})));
        if (targetIds.isEmpty()) {
            nil$ = Nil$.MODULE$;
        } else {
            String clause = ((TraversableOnce)targetIds.map((Function1 & Serializable & scala.Serializable)id -> {
                Tuple2 tuple2 = new Tuple2((Object)Ids.getReleaselessChildId((String)CiId$.MODULE$.RichCiId((String)id).normalized()), (Object)Ids.getName((String)Ids.releaseIdFrom((String)CiId$.MODULE$.RichCiId((String)id).normalized())));
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    String releaseId = (String)tuple2._2();
                    if (string == null) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d.", " is NULL AND t.", " = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.TARGET_ID(), Schema$RELEASES$.MODULE$.RELEASE_ID(), releaseId}));
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                String targetId = (String)tuple2._1();
                String releaseId = (String)tuple2._2();
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d.", " = '", "' AND t.", " = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.TARGET_ID(), targetId, Schema$RELEASES$.MODULE$.RELEASE_ID(), releaseId}));
            }, Set$.MODULE$.canBuildFrom())).mkString("(", " OR ", ")");
            Tuple2<String, Object[]> tuple2 = this.filterStatus(status);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String statusQuery = (String)tuple2._1();
            Object[] statusArgs = (Object[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)statusQuery, (Object)statusArgs);
            Tuple2 tuple23 = tuple22;
            String statusQuery2 = (String)tuple23._1();
            Object[] statusArgs2 = (Object[])tuple23._2();
            nil$ = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT\n           | d.", ",\n           | ", ",\n           | d.", ",\n           | d.", ",\n           | ", "\n           |  FROM ", " d\n           |  JOIN ", " r ON\n           |    r.", " = d.", "\n           |  JOIN ", " fr ON\n           |    fr.", " = r.", "\n           |  JOIN ", " t ON\n           |    t.", " = d.", "\n           |  JOIN ", " ft ON\n           |    ft.", " = t.", "\n           |  WHERE ", "\n           |  ", "\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID(), ReleasesSqlBuilder$.MODULE$.selectReleaseFullPathSql("r", "fr", Schema$RELEASES$.MODULE$.RELEASE_ID(), this.sqlDialect()), Schema$DEPENDENCIES$.MODULE$.GATE_STATUS(), Schema$DEPENDENCIES$.MODULE$.TARGET_ID(), ReleasesSqlBuilder$.MODULE$.selectReleaseFullPathSql("t", "ft", Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_ID(), this.sqlDialect()), Schema$DEPENDENCIES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.CI_UID(), Schema$DEPENDENCIES$.MODULE$.GATE_RELEASE_UID(), Schema$FOLDERS$.MODULE$.TABLE(), Schema$FOLDERS$.MODULE$.CI_UID(), Schema$RELEASES$.MODULE$.FOLDER_CI_UID(), Schema$RELEASES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.CI_UID(), Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID(), Schema$FOLDERS$.MODULE$.TABLE(), Schema$FOLDERS$.MODULE$.CI_UID(), Schema$RELEASES$.MODULE$.FOLDER_CI_UID(), clause, statusQuery2})))).stripMargin(), statusArgs2, this.defaultMapper())).asScala();
        }
        return nil$;
    }

    private String STMT_INSERT_DEPENDENCY() {
        return this.STMT_INSERT_DEPENDENCY;
    }

    public void insertDependency(Release release, Dependency dependency) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inserting dependency ", " of Gate ", " to Target ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency.getId(), dependency.getGateTask().getId(), dependency.getTargetId()})));
        Tuple2<String, String> tuple2 = this.getTargets(dependency);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String targetId = (String)tuple2._1();
        String targetReleaseId = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)targetId, (Object)targetReleaseId);
        Tuple2 tuple23 = tuple22;
        String targetId2 = (String)tuple23._1();
        String targetReleaseId2 = (String)tuple23._2();
        this.namedTemplate().execute(this.STMT_INSERT_DEPENDENCY(), (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dependencyId"), (Object)Ids.getReleaselessChildId((String)CiId$.MODULE$.RichCiId(dependency.getId()).normalized())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gateReleaseUid"), (Object)release.getCiUid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gateStatus"), (Object)dependency.getGateTask().getStatus().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetId"), (Object)targetId2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetReleaseId"), (Object)targetReleaseId2)}))).asJava(), (PreparedStatementCallback)new PreparedStatementCallback<BoxedUnit>(null, dependency){
            private final Dependency dependency$1;

            public void doInPreparedStatement(PreparedStatement ps) {
                try {
                    ps.execute();
                }
                catch (Throwable e) {
                    throw new ReleaseStoreException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to insert dependency ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dependency$1.getId()})), e);
                }
            }
            {
                this.dependency$1 = dependency$1;
            }
        });
    }

    private String STMT_DELETE() {
        return this.STMT_DELETE;
    }

    public void deleteDependency(String id) {
        this.jdbcTemplate().update(this.STMT_DELETE(), new Object[]{Ids.getReleaselessChildId((String)CiId$.MODULE$.RichCiId(id).normalized()), Ids.getName((String)Ids.releaseIdFrom((String)CiId$.MODULE$.RichCiId(id).normalized()))});
    }

    public void deleteDependency(Dependency dependency) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting dependency ", " of Gate ", " to Target ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency.getId(), dependency.getGateTask().getId(), dependency.getTargetId()})));
        this.deleteDependency(dependency.getId());
    }

    private String STMT_DELETE_BY_RELEASE_UID() {
        return this.STMT_DELETE_BY_RELEASE_UID;
    }

    public boolean deleteByReleaseUid(Integer releaseUid) {
        boolean bl;
        int n = this.namedTemplate().update(this.STMT_DELETE_BY_RELEASE_UID(), (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releaseUid"), (Object)releaseUid)}))).asJava());
        switch (n) {
            case 0: {
                bl = false;
                break;
            }
            default: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    private String STMT_UPDATE() {
        return this.STMT_UPDATE;
    }

    public void updateDependency(Release release, Dependency dependency) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating dependency ", " of Gate ", " to Target ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency.getId(), dependency.getGateTask().getId(), dependency.getTargetId()})));
        Tuple2<String, String> tuple2 = this.getTargets(dependency);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String targetId = (String)tuple2._1();
        String targetReleaseId = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)targetId, (Object)targetReleaseId);
        Tuple2 tuple23 = tuple22;
        String targetId2 = (String)tuple23._1();
        String targetReleaseId2 = (String)tuple23._2();
        this.namedTemplate().execute(this.STMT_UPDATE(), (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gateStatus"), (Object)dependency.getGateTask().getStatus().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetId"), (Object)targetId2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetReleaseId"), (Object)targetReleaseId2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dependencyId"), (Object)Ids.getReleaselessChildId((String)CiId$.MODULE$.RichCiId(dependency.getId()).normalized())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gateReleaseUid"), (Object)release.getCiUid())}))).asJava(), ps -> {
            DependencyPersistence.$anonfun$updateDependency$2(dependency, ps);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<String, String> getTargets(Dependency dependency) {
        String targetId = CiId$.MODULE$.RichCiId(dependency.getTargetId()).normalized();
        return !dependency.hasVariableTarget() && !dependency.isArchived() ? (Ids.isReleaseId((String)targetId) ? new Tuple2(null, (Object)Ids.getName((String)targetId)) : (Tuple2)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)Ids.getReleaselessChildId((String)targetId), (Object)Ids.getName((String)Ids.releaseIdFrom((String)targetId)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)targetId, null))) : new Tuple2((Object)targetId, null);
    }

    public static final /* synthetic */ void $anonfun$updateDependency$2(Dependency dependency$2, PreparedStatement ps) {
        int n;
        try {
            n = ps.executeUpdate();
        }
        catch (Throwable e) {
            throw new ReleaseStoreException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to update dependency ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency$2.getId()})), e);
        }
        int updatedCount = n;
        if (updatedCount == 0) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find dependency to update by ID ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependency$2.getId()})), new Object[0]);
        }
    }

    @Autowired
    public DependencyPersistence(@Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlDialect = sqlDialect;
        Logging.$init$((Logging)this);
        this.namedTemplate = new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate);
        this.defaultMapper = (rs, x$3) -> new DependencyRow(FolderId$.MODULE$.absolute$extension(FolderId$.MODULE$.apply(rs.getString(Schema$RELEASES$.MODULE$.RELEASE_ID()))), rs.getString(Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID()), rs.getString(Schema$DEPENDENCIES$.MODULE$.GATE_STATUS()), (Option<String>)Option$.MODULE$.apply((Object)rs.getString(Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_ID())).map((Function1 & Serializable & scala.Serializable)x$4 -> FolderId$.MODULE$.absolute$extension(FolderId$.MODULE$.apply((String)x$4))), rs.getString(Schema$DEPENDENCIES$.MODULE$.TARGET_ID()));
        this.STMT_FIND_BY_GATE_RELEASE_ID = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT\n       | d.", ",\n       | ", ",\n       | d.", ",\n       | d.", ",\n       | ", "\n       |  FROM ", " d\n       |  JOIN ", " r ON\n       |    d.", " = r.", "\n       |  JOIN ", " fr ON\n       |    fr.", " = r.", "\n       |  JOIN ", " t ON\n       |    t.", " = d.", "\n       |  JOIN ", " ft ON\n       |    ft.", " = t.", "\n       |  WHERE\n       |    r.", " = ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID(), ReleasesSqlBuilder$.MODULE$.selectReleaseFullPathSql("r", "fr", Schema$RELEASES$.MODULE$.RELEASE_ID(), sqlDialect), Schema$DEPENDENCIES$.MODULE$.GATE_STATUS(), Schema$DEPENDENCIES$.MODULE$.TARGET_ID(), ReleasesSqlBuilder$.MODULE$.selectReleaseFullPathSql("t", "ft", Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_ID(), sqlDialect), Schema$DEPENDENCIES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.TABLE(), Schema$DEPENDENCIES$.MODULE$.GATE_RELEASE_UID(), Schema$RELEASES$.MODULE$.CI_UID(), Schema$FOLDERS$.MODULE$.TABLE(), Schema$FOLDERS$.MODULE$.CI_UID(), Schema$RELEASES$.MODULE$.FOLDER_CI_UID(), Schema$RELEASES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.CI_UID(), Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID(), Schema$FOLDERS$.MODULE$.TABLE(), Schema$FOLDERS$.MODULE$.CI_UID(), Schema$RELEASES$.MODULE$.FOLDER_CI_UID(), Schema$RELEASES$.MODULE$.RELEASE_ID()})))).stripMargin();
        this.STMT_FIND_BY_ID = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT\n       | d.", ",\n       | ", ",\n       | d.", ",\n       | d.", ",\n       | ", "\n       |  FROM ", " d\n       |  JOIN ", " r ON\n       |    r.", " = d.", "\n       |  JOIN ", " fr ON\n       |    fr.", " = r.", "\n       |  JOIN ", " t ON\n       |    t.", " = d.", "\n       |  JOIN ", " ft ON\n       |    ft.", " = t.", "\n       |  WHERE\n       |    d.", " = ? AND\n       |    r.", " = ?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID(), ReleasesSqlBuilder$.MODULE$.selectReleaseFullPathSql("r", "fr", Schema$RELEASES$.MODULE$.RELEASE_ID(), sqlDialect), Schema$DEPENDENCIES$.MODULE$.GATE_STATUS(), Schema$DEPENDENCIES$.MODULE$.TARGET_ID(), ReleasesSqlBuilder$.MODULE$.selectReleaseFullPathSql("t", "ft", Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_ID(), sqlDialect), Schema$DEPENDENCIES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.CI_UID(), Schema$DEPENDENCIES$.MODULE$.GATE_RELEASE_UID(), Schema$FOLDERS$.MODULE$.TABLE(), Schema$FOLDERS$.MODULE$.CI_UID(), Schema$RELEASES$.MODULE$.FOLDER_CI_UID(), Schema$RELEASES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.CI_UID(), Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID(), Schema$FOLDERS$.MODULE$.TABLE(), Schema$FOLDERS$.MODULE$.CI_UID(), Schema$RELEASES$.MODULE$.FOLDER_CI_UID(), Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID(), Schema$RELEASES$.MODULE$.RELEASE_ID()})))).stripMargin();
        this.STMT_INSERT_DEPENDENCY = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " (\n       | ", ",\n       | ", ",\n       | ", ",\n       | ", ",\n       | ", "\n       |) VALUES (\n       |  :dependencyId,\n       |  :gateReleaseUid,\n       |  :gateStatus,\n       |  :targetId,\n       |  (SELECT r.", " FROM ", " r WHERE r.", " = :targetReleaseId)\n       |)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.TABLE(), Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID(), Schema$DEPENDENCIES$.MODULE$.GATE_RELEASE_UID(), Schema$DEPENDENCIES$.MODULE$.GATE_STATUS(), Schema$DEPENDENCIES$.MODULE$.TARGET_ID(), Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID(), Schema$RELEASES$.MODULE$.CI_UID(), Schema$RELEASES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.RELEASE_ID()})))).stripMargin();
        this.STMT_DELETE = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", " WHERE\n       | ", " = ? AND\n       | ", " =\n       |   (SELECT ", " FROM ", " WHERE ", " = ?)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.TABLE(), Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID(), Schema$DEPENDENCIES$.MODULE$.GATE_RELEASE_UID(), Schema$RELEASES$.MODULE$.CI_UID(), Schema$RELEASES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.RELEASE_ID()})))).stripMargin();
        this.STMT_DELETE_BY_RELEASE_UID = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM ", " WHERE\n       | ", " = :releaseUid OR ", " = :releaseUid"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.TABLE(), Schema$DEPENDENCIES$.MODULE$.GATE_RELEASE_UID(), Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID()})))).stripMargin();
        this.STMT_UPDATE = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UPDATE ", "\n       | SET\n       | ", " = :gateStatus,\n       | ", " = :targetId,\n       | ", " =\n       |   (SELECT r.", " FROM ", " r WHERE r.", " = :targetReleaseId)\n       |  WHERE\n       |    ", " = :dependencyId AND\n       |    ", " = :gateReleaseUid"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Schema$DEPENDENCIES$.MODULE$.TABLE(), Schema$DEPENDENCIES$.MODULE$.GATE_STATUS(), Schema$DEPENDENCIES$.MODULE$.TARGET_ID(), Schema$DEPENDENCIES$.MODULE$.TARGET_RELEASE_UID(), Schema$RELEASES$.MODULE$.CI_UID(), Schema$RELEASES$.MODULE$.TABLE(), Schema$RELEASES$.MODULE$.RELEASE_ID(), Schema$DEPENDENCIES$.MODULE$.DEPENDENCY_ID(), Schema$DEPENDENCIES$.MODULE$.GATE_RELEASE_UID()})))).stripMargin();
    }
}

