/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.migrator.util;

import com.xebialabs.xlrelease.migrator.util.MemoryUtils;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0006\u0010\u0013\u001a\u00020\u000bJ\"\u0010\u0014\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00152\u0006\u0010\u0018\u001a\u00020\tJ4\u0010\u0019\u001a\"\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001a0\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u0002H\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u001b0\u0015\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\u0018\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/xebialabs/xlrelease/migrator/util/MemoryUtils;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "rt", "Ljava/lang/Runtime;", "format", "", "ms", "Lcom/xebialabs/xlrelease/migrator/util/MemoryUtils$MemStats;", "formatConsumed", "diff", "Lcom/xebialabs/xlrelease/migrator/util/MemoryUtils$MemDiff;", "kb", "", "bytes", "mb", "memoryStats", "trace", "Lkotlin/Function1;", "Lkotlin/Function0;", "", "funcName", "traceVal", "U", "Lkotlin/Pair;", "MemDiff", "MemStats", "xl-release-sql-migrator"})
public final class MemoryUtils {
    private final Logger logger = LoggerFactory.getLogger(MemoryUtils.class);
    private final Runtime rt;

    @NotNull
    public final MemStats memoryStats() {
        return new MemStats(this.rt.freeMemory(), this.rt.totalMemory());
    }

    public final long kb(long bytes) {
        return (long)((double)bytes / 1024.0 * (double)10) / (long)10;
    }

    public final long mb(long bytes) {
        return (long)((double)bytes / 1024.0 / 1024.0 * (double)10) / (long)10;
    }

    @NotNull
    public final String format(@NotNull MemStats ms) {
        Intrinsics.checkParameterIsNotNull((Object)ms, (String)"ms");
        return "Mem: " + this.mb(ms.getUsed()) + '/' + this.mb(ms.getTotal()) + ", free: " + this.mb(ms.getFree()) + " [MB]";
    }

    @NotNull
    public final String formatConsumed(@NotNull MemDiff diff) {
        Intrinsics.checkParameterIsNotNull((Object)diff, (String)"diff");
        String sign = diff.getConsumed() > 0L ? "+" : "";
        return "Mem: " + sign + "" + this.kb(diff.getConsumed()) + " [KB]";
    }

    @NotNull
    public final <U> Function1<Function0<? extends U>, Pair<U, MemDiff>> traceVal(@NotNull String funcName) {
        Intrinsics.checkParameterIsNotNull((Object)funcName, (String)"funcName");
        if (this.logger.isTraceEnabled()) {
            return new Function1<Function0<? extends U>, Pair<? extends U, ? extends MemDiff>>(this, funcName){
                final /* synthetic */ MemoryUtils this$0;
                final /* synthetic */ String $funcName;

                @NotNull
                public final Pair<U, MemDiff> invoke(@NotNull Function0<? extends U> body) {
                    Intrinsics.checkParameterIsNotNull(body, (String)"body");
                    MemStats initial = this.this$0.memoryStats();
                    MemoryUtils.access$getLogger$p(this.this$0).trace("" + this.$funcName + " (before): " + this.this$0.format(initial));
                    Object result = body.invoke();
                    MemStats memStats = this.this$0.memoryStats();
                    MemoryUtils.access$getLogger$p(this.this$0).trace("" + this.$funcName + "  (after): " + this.this$0.format(memStats));
                    MemDiff diff = new MemDiff(initial, memStats);
                    MemoryUtils.access$getLogger$p(this.this$0).trace("" + this.$funcName + "   (diff): " + this.this$0.formatConsumed(diff));
                    return new Pair(result, (Object)diff);
                }
                {
                    this.this$0 = memoryUtils;
                    this.$funcName = string;
                    super(1);
                }
            };
        }
        return traceVal.2.INSTANCE;
    }

    @NotNull
    public final Function1<Function0<Unit>, MemDiff> trace(@NotNull String funcName) {
        Intrinsics.checkParameterIsNotNull((Object)funcName, (String)"funcName");
        return (Function1)new Function1<Function0<? extends Unit>, MemDiff>(this, funcName){
            final /* synthetic */ MemoryUtils this$0;
            final /* synthetic */ String $funcName;

            @Nullable
            public final MemDiff invoke(@NotNull Function0<Unit> body) {
                Intrinsics.checkParameterIsNotNull(body, (String)"body");
                return (MemDiff)((Pair)this.this$0.traceVal(this.$funcName).invoke(body)).getSecond();
            }
            {
                this.this$0 = memoryUtils;
                this.$funcName = string;
                super(1);
            }
        };
    }

    public MemoryUtils() {
        Runtime runtime = Runtime.getRuntime();
        Intrinsics.checkExpressionValueIsNotNull((Object)runtime, (String)"Runtime.getRuntime()");
        this.rt = runtime;
    }

    public static final /* synthetic */ Logger access$getLogger$p(MemoryUtils $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/xebialabs/xlrelease/migrator/util/MemoryUtils$MemStats;", "", "free", "", "total", "(JJ)V", "getFree", "()J", "getTotal", "used", "getUsed", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "xl-release-sql-migrator"})
    public static final class MemStats {
        private final long used;
        private final long free;
        private final long total;

        public final long getUsed() {
            return this.used;
        }

        public final long getFree() {
            return this.free;
        }

        public final long getTotal() {
            return this.total;
        }

        public MemStats(long free, long total) {
            this.free = free;
            this.total = total;
            this.used = this.total - this.free;
        }

        public final long component1() {
            return this.free;
        }

        public final long component2() {
            return this.total;
        }

        @NotNull
        public final MemStats copy(long free, long total) {
            return new MemStats(free, total);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ MemStats copy$default(MemStats memStats, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = memStats.free;
            }
            if ((n & 2) != 0) {
                l2 = memStats.total;
            }
            return memStats.copy(l, l2);
        }

        public String toString() {
            return "MemStats(free=" + this.free + ", total=" + this.total + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.free) * 31 + Long.hashCode(this.total);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MemStats)) break block3;
                    MemStats memStats = (MemStats)object;
                    if (!(this.free == memStats.free) || !(this.total == memStats.total)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/xebialabs/xlrelease/migrator/util/MemoryUtils$MemDiff;", "", "initial", "Lcom/xebialabs/xlrelease/migrator/util/MemoryUtils$MemStats;", "final", "(Lcom/xebialabs/xlrelease/migrator/util/MemoryUtils$MemStats;Lcom/xebialabs/xlrelease/migrator/util/MemoryUtils$MemStats;)V", "consumed", "", "getConsumed", "()J", "getFinal", "()Lcom/xebialabs/xlrelease/migrator/util/MemoryUtils$MemStats;", "getInitial", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "xl-release-sql-migrator"})
    public static final class MemDiff {
        private final long consumed;
        @NotNull
        private final MemStats initial;
        @NotNull
        private final MemStats final;

        public final long getConsumed() {
            return this.consumed;
        }

        @NotNull
        public final MemStats getInitial() {
            return this.initial;
        }

        @NotNull
        public final MemStats getFinal() {
            return this.final;
        }

        public MemDiff(@NotNull MemStats initial, @NotNull MemStats memStats) {
            Intrinsics.checkParameterIsNotNull((Object)initial, (String)"initial");
            Intrinsics.checkParameterIsNotNull((Object)memStats, (String)"final");
            this.initial = initial;
            this.final = memStats;
            this.consumed = this.final.getUsed() - this.initial.getUsed();
        }

        @NotNull
        public final MemStats component1() {
            return this.initial;
        }

        @NotNull
        public final MemStats component2() {
            return this.final;
        }

        @NotNull
        public final MemDiff copy(@NotNull MemStats initial, @NotNull MemStats memStats) {
            Intrinsics.checkParameterIsNotNull((Object)initial, (String)"initial");
            Intrinsics.checkParameterIsNotNull((Object)memStats, (String)"final");
            return new MemDiff(initial, memStats);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ MemDiff copy$default(MemDiff memDiff, MemStats memStats, MemStats memStats2, int n, Object object) {
            if ((n & 1) != 0) {
                memStats = memDiff.initial;
            }
            if ((n & 2) != 0) {
                memStats2 = memDiff.final;
            }
            return memDiff.copy(memStats, memStats2);
        }

        public String toString() {
            return "MemDiff(initial=" + this.initial + ", final=" + this.final + ")";
        }

        public int hashCode() {
            MemStats memStats = this.initial;
            MemStats memStats2 = this.final;
            return (memStats != null ? ((Object)memStats).hashCode() : 0) * 31 + (memStats2 != null ? ((Object)memStats2).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MemDiff)) break block3;
                    MemDiff memDiff = (MemDiff)object;
                    if (!Intrinsics.areEqual((Object)this.initial, (Object)memDiff.initial) || !Intrinsics.areEqual((Object)this.final, (Object)memDiff.final)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

