/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.setup;

import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.XlpJcrRepositoryConfig;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.setup.Setup;
import com.xebialabs.deployit.util.GuavaFiles;
import com.xebialabs.xlplatform.XlRepositoryFactory;
import java.io.File;
import java.io.IOException;
import org.springframework.core.io.Resource;

public abstract class JcrSetup
extends Setup {
    public JcrSetup(String serverName, ServerConfigFile serverConfigFile, ServerLaunchOptions deployitOptions) {
        super(serverName, serverConfigFile, deployitOptions);
    }

    public JcrSetup(String serverName, ServerConfigFile serverConfigFile, ServerLaunchOptions deployitOptions, ServerConfiguration defaultConfiguration) {
        super(serverName, serverConfigFile, deployitOptions, defaultConfiguration);
    }

    protected abstract XlRepositoryFactory getXlRepositoryFactory(Resource var1, XlpJcrRepositoryConfig var2);

    protected abstract XlpJcrRepositoryConfig getXlpRepositoryConfig();

    protected void initializeRepository() {
        Resource homeDirResource = this.resolveRepositoryHome();
        JcrSetup.cleanUpAndReinitializeRepositoryHome(homeDirResource);
        System.setProperty("jcr.repository.path", this.configuration.getJcrRepositoryPath());
        XlpJcrRepositoryConfig deployitRepositoryConfig = this.getXlpRepositoryConfig();
        if (this.storeRepositoryIdWhenInitializingJcr) {
            deployitRepositoryConfig.setRepositoryId(this.repositoryId);
        }
        XlRepositoryFactory repositoryFactoryBean = this.getXlRepositoryFactory(homeDirResource, deployitRepositoryConfig);
        try {
            repositoryFactoryBean.initialize();
        }
        catch (Exception exc) {
            throw new RuntimeException("Cannot initialize JCR repository", exc);
        }
        try {
            repositoryFactoryBean.destroy();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.jcrRepositoryInitialized = true;
        System.out.println("JCR repository initialized.");
        JcrSetup.deleteTaskRecoveryFile();
    }

    protected static void cleanUpAndReinitializeRepositoryHome(Resource repoHomeResource) {
        File repositoryHome;
        try {
            repositoryHome = repoHomeResource.getFile();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Problem resolving absolute path to JCR repository at " + repoHomeResource.getFilename(), (Throwable)e);
        }
        if (repositoryHome.exists()) {
            System.out.println("Deleting JCR repository at " + repositoryHome);
            try {
                GuavaFiles.deleteRecursively((File)repositoryHome);
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot delete JCR repository at " + repositoryHome, (Throwable)exc);
            }
        }
        System.out.println("Creating JCR repository at " + repositoryHome);
        boolean created = repositoryHome.mkdirs();
        if (!created) {
            throw new RuntimeIOException("Unknown error occured while creating JCR repository at " + repoHomeResource);
        }
    }
}

