/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.sftp.PacketType;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.sftp.SFTPPacket;

public final class Response
extends SFTPPacket<Response> {
    private final int protocolVersion;
    private final PacketType type;
    private final long reqID;

    public Response(Buffer<Response> pk, int protocolVersion) throws SFTPException {
        super(pk);
        this.protocolVersion = protocolVersion;
        this.type = this.readType();
        try {
            this.reqID = this.readUInt32();
        }
        catch (Buffer.BufferException be) {
            throw new SFTPException(be);
        }
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public long getRequestID() {
        return this.reqID;
    }

    public PacketType getType() {
        return this.type;
    }

    public StatusCode readStatusCode() throws SFTPException {
        try {
            return StatusCode.fromInt(this.readUInt32AsInt());
        }
        catch (Buffer.BufferException be) {
            throw new SFTPException(be);
        }
    }

    public Response ensurePacketTypeIs(PacketType pt) throws SFTPException {
        if (this.getType() != pt) {
            if (this.getType() == PacketType.STATUS) {
                this.error(this.readStatusCode());
            } else {
                throw new SFTPException("Unexpected packet " + (Object)((Object)this.getType()));
            }
        }
        return this;
    }

    public Response ensureStatusPacketIsOK() throws SFTPException {
        return this.ensurePacketTypeIs(PacketType.STATUS).ensureStatusIs(StatusCode.OK);
    }

    public Response ensureStatusIs(StatusCode acceptable) throws SFTPException {
        StatusCode sc = this.readStatusCode();
        if (sc != acceptable) {
            this.error(sc);
        }
        return this;
    }

    protected String error(StatusCode sc) throws SFTPException {
        try {
            throw new SFTPException(sc, this.protocolVersion < 3 ? sc.toString() : this.readString());
        }
        catch (Buffer.BufferException be) {
            throw new SFTPException(be);
        }
    }

    public static enum StatusCode {
        UNKNOWN(-1),
        OK(0),
        EOF(1),
        NO_SUCH_FILE(2),
        PERMISSION_DENIED(3),
        FAILURE(4),
        BAD_MESSAGE(5),
        NO_CONNECTION(6),
        CONNECITON_LOST(7),
        OP_UNSUPPORTED(8),
        INVALID_HANDLE(9),
        NO_SUCH_PATH(10),
        FILE_ALREADY_EXISTS(11),
        WRITE_PROTECT(12),
        NO_MEDIA(13),
        NO_SPACE_ON_FILESYSTEM(14),
        QUOTA_EXCEEDED(15),
        UNKNOWN_PRINCIPAL(16),
        LOCK_CONFLICT(17),
        DIR_NOT_EMPTY(18),
        NOT_A_DIRECTORY(19),
        INVALID_FILENAME(20),
        LINK_LOOP(21),
        CANNOT_DELETE(22),
        INVALID_PARAMETER(23),
        FILE_IS_A_DIRECTORY(24),
        BYTE_RANGE_LOCK_CONFLICT(25),
        BYTE_RANGE_LOCK_REFUSED(26),
        DELETE_PENDING(27),
        FILE_CORRUPT(28),
        OWNER_INVALID(29),
        GROUP_INVALID(30),
        NO_MATCHING_BYTE_RANGE_LOCK(31);

        private final int code;

        public static StatusCode fromInt(int code) {
            for (StatusCode s : StatusCode.values()) {
                if (s.code != code) continue;
                return s;
            }
            return UNKNOWN;
        }

        private StatusCode(int code) {
            this.code = code;
        }
    }
}

