/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.join.AbstractCondition;
import org.apache.jackrabbit.core.query.lucene.join.ScoreNodeMap;
import org.apache.jackrabbit.spi.commons.query.qom.ChildNodeJoinConditionImpl;
import org.apache.lucene.index.IndexReader;

public class ChildNodeJoin
extends AbstractCondition {
    private final ScoreNodeMap parentIndex = new ScoreNodeMap();
    private final IndexReader reader;
    private final HierarchyResolver resolver;
    private int[] docNums = new int[1];
    private List<ScoreNode[]> tmpScoreNodes = new ArrayList<ScoreNode[]>();

    public ChildNodeJoin(MultiColumnQueryHits parent, IndexReader reader, HierarchyResolver resolver, ChildNodeJoinConditionImpl condition) throws IOException {
        super(parent);
        ScoreNode[] nodes;
        this.reader = reader;
        this.resolver = resolver;
        int idx = ChildNodeJoin.getIndex(parent, condition.getParentSelectorQName());
        while ((nodes = parent.nextScoreNodes()) != null) {
            Integer docNum = nodes[idx].getDoc(reader);
            this.parentIndex.addScoreNodes(docNum, nodes);
        }
    }

    @Override
    public ScoreNode[][] getMatchingScoreNodes(ScoreNode child) throws IOException {
        this.docNums = this.resolver.getParents(child.getDoc(this.reader), this.docNums);
        this.tmpScoreNodes.clear();
        for (int docNum : this.docNums) {
            ScoreNode[][] sn = this.parentIndex.getScoreNodes(docNum);
            if (sn == null) continue;
            for (ScoreNode[] aSn : sn) {
                this.tmpScoreNodes.add(aSn);
            }
        }
        if (this.tmpScoreNodes.isEmpty()) {
            return null;
        }
        return (ScoreNode[][])this.tmpScoreNodes.toArray((T[])new ScoreNode[this.tmpScoreNodes.size()][]);
    }
}

