/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;

public class ScriptHelper {
    public static final String SCRIPT_LOCATION_PROPERTY = "scriptLocation";
    public static final String HIDDEN = "hidden";

    public static String getScript(ConfigurationItem configurationItem) throws IOException {
        String customScriptLocation;
        if (configurationItem.hasProperty(SCRIPT_LOCATION_PROPERTY) && Strings.isNotBlank((String)(customScriptLocation = (String)configurationItem.getProperty(SCRIPT_LOCATION_PROPERTY)))) {
            return ScriptHelper.readScript(customScriptLocation);
        }
        return ScriptHelper.readScript(ScriptHelper.getDefaultPath(configurationItem.getType()));
    }

    static String readScript(String path) throws IOException {
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);){
            if (null == stream) {
                throw new FileNotFoundException("Script not found: " + path);
            }
            String string = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    static String getDefaultPath(Type type) {
        String prefix = type.getPrefix();
        String name = type.getName();
        return prefix + "/" + name + ".py";
    }
}

