/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.git;

import com.google.common.base.Strings;
import java.util.Collection;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GitClient {
    private String root;
    private String branch;
    private String userName;
    private String password;

    public GitClient(String root, String branch, String userName, String password) {
        this.root = root;
        this.branch = branch;
        this.userName = userName;
        this.password = password;
    }

    public String getLatestRevision() throws GitAPIException {
        return this.getLatestRevisionObjectId().getName();
    }

    public ObjectId getLatestRevisionObjectId() throws GitAPIException {
        Collection<Ref> refs = this.fetchRemoteReferences();
        return !Strings.isNullOrEmpty((String)this.branch) ? this.findBranchSha1(refs, this.branch) : this.findDefaultBranchSha1(refs);
    }

    private Collection<Ref> fetchRemoteReferences() throws GitAPIException {
        LsRemoteCommand lsRemoteCommand = Git.lsRemoteRepository().setRemote(this.root).setTags(false);
        if (this.userName != null && this.password != null) {
            lsRemoteCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.userName, this.password));
        }
        return lsRemoteCommand.call();
    }

    private ObjectId findBranchSha1(Collection<Ref> refs, String branch) {
        return this.findSha1(refs, "refs/heads/" + branch);
    }

    private ObjectId findDefaultBranchSha1(Collection<Ref> refs) {
        return this.findSha1(refs, "HEAD");
    }

    private ObjectId findSha1(Collection<Ref> refs, String input) {
        for (Ref ref : refs) {
            if (!ref.getName().equals(input)) continue;
            return ref.getObjectId();
        }
        throw new IllegalArgumentException(String.format("'%s' not found on %s", input, this.root));
    }
}

