/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseOverdueEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskAbortedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCompletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskFailedEvent;
import com.xebialabs.xlrelease.domain.events.TaskOverdueEvent;
import com.xebialabs.xlrelease.domain.events.TaskSkippedEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.events.EventListening;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskProfileUpdated;
import com.xebialabs.xlrelease.risk.service.RiskService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.Executor;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl.javadude.t2bus.AllowConcurrentEvents;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0001\t=a\u0001B\u0001\u0003\u00015\u0011\u0001CU5tW\u00163XM\u001c;IC:$G.\u001a:\u000b\u0005\r!\u0011aB:feZL7-\u001a\u0006\u0003\u000b\u0019\tAA]5tW*\u0011q\u0001C\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0003\u0006\u0002\u0013a,'-[1mC\n\u001c(\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001qAC\u0007\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UAR\"\u0001\f\u000b\u0005]1\u0011AB3wK:$8/\u0003\u0002\u001a-\tqQI^3oi2K7\u000f^3oS:<\u0007CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005y\u0012\u0001C4sSjTH.\u001a3\n\u0005\u0005b\"a\u0002'pO\u001eLgn\u001a\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005I\u0001\u0010\u001c:D_:4\u0017n\u001a\t\u0003K!j\u0011A\n\u0006\u0003O\u0019\taaY8oM&<\u0017BA\u0015'\u0005%AFN]\"p]\u001aLw\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0003]\u0019wN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002.a5\taF\u0003\u00020\r\u0005Q!/\u001a9pg&$xN]=\n\u0005Er#aF\"p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u0011Q&N\u0005\u0003m9\u0012\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0011!A\u0004A!A!\u0002\u0013I\u0014a\u0003:jg.\u001cVM\u001d<jG\u0016\u0004\"AO\u001e\u000e\u0003\tI!\u0001\u0010\u0002\u0003\u0017IK7o[*feZL7-\u001a\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f\u0005a\"/[:l\u0007\u0006d7-\u001e7bi&|gNQ1uG\",\u00050Z2vi>\u0014\bC\u0001!H\u001b\u0005\t%B\u0001\"D\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\t\u0016\u000bA!\u001e;jY*\ta)\u0001\u0003kCZ\f\u0017B\u0001%B\u0005!)\u00050Z2vi>\u0014\b\u0002\u0003&\u0001\u0005\u000b\u0007I\u0011A&\u0002\u0011\u00154XM\u001c;CkN,\u0012\u0001\u0014\t\u0003+5K!A\u0014\f\u0003#ac%+\u001a7fCN,WI^3oi\n+8\u000f\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003M\u0003%)g/\u001a8u\u0005V\u001c\b\u0005C\u0003S\u0001\u0011\u00051+\u0001\u0004=S:LGO\u0010\u000b\b)V3v\u000bW-[!\tQ\u0004\u0001C\u0003$#\u0002\u0007A\u0005C\u0003,#\u0002\u0007A\u0006C\u00034#\u0002\u0007A\u0007C\u00039#\u0002\u0007\u0011\bC\u0003?#\u0002\u0007q\bC\u0003K#\u0002\u0007A\n\u000b\u0002R9B\u0011Q\f[\u0007\u0002=*\u0011q\fY\u0001\u000bC:tw\u000e^1uS>t'BA1c\u0003\u001d1\u0017m\u0019;pefT!a\u00193\u0002\u000b\t,\u0017M\\:\u000b\u0005\u00154\u0017aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\u001d\f1a\u001c:h\u0013\tIgLA\u0005BkR|w/\u001b:fI\")1\u000e\u0001C\u0001Y\u0006q!/\u001a7fCN,7I]3bi\u0016$GCA7q!\tya.\u0003\u0002p!\t!QK\\5u\u0011\u0015\t(\u000e1\u0001s\u0003M\u0011X\r\\3bg\u0016\u001c%/Z1uK\u0012,e/\u001a8u!\t\u0019x/D\u0001u\u0015\t9RO\u0003\u0002w\r\u00051Am\\7bS:L!\u0001\u001f;\u0003'I+G.Z1tK\u000e\u0013X-\u0019;fI\u00163XM\u001c;)\u0005)T\bcA>\u0002\u00065\tAP\u0003\u0002~}\u0006)AO\r2vg*\u0019q0!\u0001\u0002\u0011)\fg/\u00193vI\u0016T!!a\u0001\u0002\u00059d\u0017bAA\u0004y\n)\u0012\t\u001c7po\u000e{gnY;se\u0016tG/\u0012<f]R\u001c\bf\u00016\u0002\fA\u001910!\u0004\n\u0007\u0005=APA\u0005Tk\n\u001c8M]5cK\"9\u00111\u0003\u0001\u0005\u0002\u0005U\u0011A\u0004:fY\u0016\f7/Z+qI\u0006$X\r\u001a\u000b\u0004[\u0006]\u0001\u0002CA\r\u0003#\u0001\r!a\u0007\u0002'I,G.Z1tKV\u0003H-\u0019;fI\u00163XM\u001c;\u0011\u0007M\fi\"C\u0002\u0002 Q\u00141CU3mK\u0006\u001cX-\u00169eCR,G-\u0012<f]RD3!!\u0005{Q\u0011\t\t\"a\u0003\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*\u0005q!/\u001a7fCN,wJ^3sIV,GcA7\u0002,!A\u0011QFA\u0013\u0001\u0004\ty#A\nsK2,\u0017m]3Pm\u0016\u0014H-^3Fm\u0016tG\u000fE\u0002t\u0003cI1!a\ru\u0005M\u0011V\r\\3bg\u0016|e/\u001a:ek\u0016,e/\u001a8uQ\r\t)C\u001f\u0015\u0005\u0003K\tY\u0001C\u0004\u0002<\u0001!\t!!\u0010\u0002\u0015Q\f7o\u001b$bS2,G\rF\u0002n\u0003\u007fA\u0001\"!\u0011\u0002:\u0001\u0007\u00111I\u0001\u0010i\u0006\u001c8NR1jY\u0016$WI^3oiB\u00191/!\u0012\n\u0007\u0005\u001dCOA\bUCN\\g)Y5mK\u0012,e/\u001a8uQ\r\tID\u001f\u0015\u0005\u0003s\tY\u0001C\u0004\u0002P\u0001!\t!!\u0015\u0002\u001bQ\f7o[\"p[BdW\r^3e)\ri\u00171\u000b\u0005\t\u0003+\ni\u00051\u0001\u0002X\u0005\u0011B/Y:l\u0007>l\u0007\u000f\\3uK\u0012,e/\u001a8u!\r\u0019\u0018\u0011L\u0005\u0004\u00037\"(A\u0005+bg.\u001cu.\u001c9mKR,G-\u0012<f]RD3!!\u0014{Q\u0011\ti%a\u0003\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002f\u0005YA/Y:l'.L\u0007\u000f]3e)\ri\u0017q\r\u0005\t\u0003S\n\t\u00071\u0001\u0002l\u0005\u0001B/Y:l'.L\u0007\u000f]3e\u000bZ,g\u000e\u001e\t\u0004g\u00065\u0014bAA8i\n\u0001B+Y:l'.L\u0007\u000f]3e\u000bZ,g\u000e\u001e\u0015\u0004\u0003CR\b\u0006BA1\u0003\u0017Aq!a\u001e\u0001\t\u0003\tI(A\u0006uCN\\\u0017IY8si\u0016$GcA7\u0002|!A\u0011QPA;\u0001\u0004\ty(\u0001\tuCN\\\u0017IY8si\u0016$WI^3oiB\u00191/!!\n\u0007\u0005\rEO\u0001\tUCN\\\u0017IY8si\u0016$WI^3oi\"\u001a\u0011Q\u000f>)\t\u0005U\u00141\u0002\u0005\b\u0003\u0017\u0003A\u0011AAG\u0003-!\u0018m]6Va\u0012\fG/\u001a3\u0015\u00075\fy\t\u0003\u0005\u0002\u0012\u0006%\u0005\u0019AAJ\u0003A!\u0018m]6Va\u0012\fG/\u001a3Fm\u0016tG\u000fE\u0002t\u0003+K1!a&u\u0005A!\u0016m]6Va\u0012\fG/\u001a3Fm\u0016tG\u000fK\u0002\u0002\njDC!!#\u0002\f!9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005\u0016a\u0003;bg.|e/\u001a:ek\u0016$2!\\AR\u0011!\t)+!(A\u0002\u0005\u001d\u0016\u0001\u0005;bg.|e/\u001a:ek\u0016,e/\u001a8u!\r\u0019\u0018\u0011V\u0005\u0004\u0003W#(\u0001\u0005+bg.|e/\u001a:ek\u0016,e/\u001a8uQ\r\tiJ\u001f\u0015\u0005\u0003;\u000bY\u0001C\u0004\u00024\u0002!\t!!.\u0002\u0017Q\f7o\u001b#fY\u0016$X\r\u001a\u000b\u0004[\u0006]\u0006\u0002CA]\u0003c\u0003\r!a/\u0002!Q\f7o\u001b#fY\u0016$X\rZ#wK:$\bcA:\u0002>&\u0019\u0011q\u0018;\u0003!Q\u000b7o\u001b#fY\u0016$X\rZ#wK:$\bfAAYu\"\"\u0011\u0011WA\u0006\u0011\u001d\t9\r\u0001C\u0005\u0003\u0013\fQbY1mGVd\u0017\r^3SSN\\GcA7\u0002L\"A\u0011QZAc\u0001\u0004\ty-A\u0004sK2,\u0017m]3\u0011\t\u0005E\u00171[\u0007\u0002k&\u0019\u0011Q[;\u0003\u000fI+G.Z1tK\"9\u0011\u0011\u001c\u0001\u0005\u0002\u0005m\u0017a\u00065b]\u0012dWMU5tWB\u0013xNZ5mKV\u0003H-\u0019;f)\ri\u0017Q\u001c\u0005\t\u0003?\f9\u000e1\u0001\u0002b\u0006)QM^3oiB!\u00111]Au\u001b\t\t)OC\u0002\u0018\u0003OT!A\u001e\u0003\n\t\u0005-\u0018Q\u001d\u0002\u0013%&\u001c8\u000e\u0015:pM&dW-\u00169eCR,G\r\u000b\u0003\u0002X\u0006-\u0001bBAy\u0001\u0011%\u00111_\u0001\u001eeVt7)\u00197dk2\fG/[8og\u001a{'OU5tWB\u0013xNZ5mKR\u0019Q.!>\t\u0011\u0005]\u0018q\u001ea\u0001\u0003s\f1B]5tWB\u0013xNZ5mKB!\u00111`A\u007f\u001b\t\t9/\u0003\u0003\u0002\u0000\u0006\u001d(a\u0003*jg.\u0004&o\u001c4jY\u0016D3\u0001\u0001B\u0002!\u0011\u0011)Aa\u0003\u000e\u0005\t\u001d!b\u0001B\u0005I\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\t5!q\u0001\u0002\b'\u0016\u0014h/[2f\u0001")
public class RiskEventHandler
implements EventListening,
Logging {
    private final XlrConfig xlrConfig;
    private final ConfigurationRepository configurationRepository;
    private final RiskService riskService;
    private final Executor riskCalculationBatchExecutor;
    private final XLReleaseEventBus eventBus;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @PostConstruct
    public void postConstruct() {
        EventListening.postConstruct$((EventListening)this);
    }

    @PreDestroy
    public void preDestroy() {
        EventListening.preDestroy$((EventListening)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskEventHandler riskEventHandler = this;
        synchronized (riskEventHandler) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void releaseCreated(ReleaseCreatedEvent releaseCreatedEvent) {
        this.calculateRisk(releaseCreatedEvent.release());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void releaseUpdated(ReleaseUpdatedEvent releaseUpdatedEvent) {
        this.calculateRisk(releaseUpdatedEvent.updated());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void releaseOverdue(ReleaseOverdueEvent releaseOverdueEvent) {
        this.calculateRisk(releaseOverdueEvent.release());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void taskFailed(TaskFailedEvent taskFailedEvent) {
        this.calculateRisk(taskFailedEvent.task().getRelease());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void taskCompleted(TaskCompletedEvent taskCompletedEvent) {
        this.calculateRisk(taskCompletedEvent.task().getRelease());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void taskSkipped(TaskSkippedEvent taskSkippedEvent) {
        this.calculateRisk(taskSkippedEvent.task().getRelease());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void taskAborted(TaskAbortedEvent taskAbortedEvent) {
        this.calculateRisk(taskAbortedEvent.task().getRelease());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void taskUpdated(TaskUpdatedEvent taskUpdatedEvent) {
        this.calculateRisk(taskUpdatedEvent.updated().getRelease());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void taskOverdue(TaskOverdueEvent taskOverdueEvent) {
        this.calculateRisk(taskOverdueEvent.task().getRelease());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void taskDeleted(TaskDeletedEvent taskDeletedEvent) {
        this.calculateRisk(taskDeletedEvent.task().getRelease());
    }

    private void calculateRisk(Release release) {
        block0: {
            if (!this.xlrConfig.isRiskCalculationEnabled()) break block0;
            this.riskService.calculateRiskAndUpdateRelease(release);
        }
    }

    @Subscribe
    public void handleRiskProfileUpdate(RiskProfileUpdated event) {
        block0: {
            if (!this.xlrConfig.isRiskCalculationEnabled()) break block0;
            RiskProfile riskProfile = event.riskProfile();
            this.riskCalculationBatchExecutor.execute(() -> this.runCalculationsForRiskProfile(riskProfile));
        }
    }

    private void runCalculationsForRiskProfile(RiskProfile riskProfile) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running risk calculations after Risk profile ", " update"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{riskProfile.getId()})));
        this.configurationRepository.getReferences(riskProfile.getId()).forEach(data -> $this.riskService.calculateRiskAndUpdateRelease(data.id()));
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished running risk calculations after Risk profile ", " update"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{riskProfile.getId()})));
    }

    @Autowired
    public RiskEventHandler(XlrConfig xlrConfig, ConfigurationRepository configurationRepository, ReleaseRepository releaseRepository, RiskService riskService, Executor riskCalculationBatchExecutor, XLReleaseEventBus eventBus) {
        this.xlrConfig = xlrConfig;
        this.configurationRepository = configurationRepository;
        this.riskService = riskService;
        this.riskCalculationBatchExecutor = riskCalculationBatchExecutor;
        this.eventBus = eventBus;
        EventListening.$init$((EventListening)this);
        Logging.$init$((Logging)this);
    }
}

