/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.ResolvableScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.script.ScriptCallback;
import com.xebialabs.xlrelease.script.ScriptLifeCycle;
import com.xebialabs.xlrelease.script.ScriptService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnsupportedScriptService
implements ScriptService {
    private static final Logger logger = LoggerFactory.getLogger(UnsupportedScriptService.class);
    public static final String UNSUPPORTED_ENGINE = "unsupported_engine";
    private Scheduler scheduler;
    private ScriptLifeCycle scriptLifeCycle;

    @Autowired
    public UnsupportedScriptService(Scheduler scheduler, ScriptLifeCycle scriptLifeCycle) {
        this.scheduler = scheduler;
        this.scriptLifeCycle = scriptLifeCycle;
    }

    @Override
    public void executeScriptTask(ResolvableScriptTask task, ScriptCallback onSuccess, ScriptCallback onFailure) {
        this.failScriptTask((Task)task, onFailure);
    }

    @Override
    public void executeCustomScriptTask(CustomScriptTask task, ScriptCallback onSuccess, ScriptCallback onFailure) {
        this.failScriptTask((Task)task, onFailure);
    }

    @Override
    public void executePrecondition(Task task, ScriptCallback preconditionValidCallback, ScriptCallback preconditionInvalidCallback, ScriptCallback preconditionExceptionCallback) {
        this.failScriptTask(task, preconditionExceptionCallback);
    }

    @Override
    public String engine() {
        return UNSUPPORTED_ENGINE;
    }

    private void failScriptTask(Task task, ScriptCallback scriptCallback) {
        this.scriptLifeCycle.register(task.getExecutionId());
        this.scheduler.execute(() -> {
            this.onException(task.getId(), scriptCallback);
            this.scriptLifeCycle.unregister(task.getExecutionId());
        });
    }

    private void onException(String taskId, ScriptCallback onFailure) {
        String errorMsg = String.format("Unable to execute '%s', unsupported script engine", taskId);
        logger.warn(errorMsg);
        try {
            onFailure.setExecutionLog(errorMsg);
            onFailure.run();
        }
        catch (Exception e) {
            logger.warn("Unable to update XL Release task: '{}'", (Object)taskId, (Object)e);
        }
    }
}

