/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery;

import akka.event.LoggingAdapter;
import akka.util.Helpers;
import io.aeron.CncFileDescriptor;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.errors.ErrorLogReader;

public class AeronErrorLog {
    private final File cncFile;
    final MappedByteBuffer cncByteBuffer;
    final DirectBuffer cncMetaDataBuffer;
    final int cncVersion;
    final AtomicBuffer buffer;

    public AeronErrorLog(File file) {
        this.cncFile = file;
        this.cncByteBuffer = IoUtil.mapExistingFile((File)file, (String)"cnc");
        this.cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer((ByteBuffer)this.cncByteBuffer);
        this.cncVersion = this.cncMetaDataBuffer.getInt(CncFileDescriptor.cncVersionOffset((int)0));
        this.buffer = CncFileDescriptor.createErrorLogBuffer((ByteBuffer)this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer);
        if (6 != this.cncVersion) {
            IoUtil.unmap((MappedByteBuffer)this.cncByteBuffer);
            throw new IllegalStateException("CNC version not supported: file version=" + this.cncVersion);
        }
    }

    public long logErrors(LoggingAdapter loggingAdapter, long l3) {
        AtomicLong atomicLong = new AtomicLong(l3);
        ErrorLogReader.read((AtomicBuffer)this.buffer, (n, l, l2, string) -> {
            loggingAdapter.error(String.format("Aeron error: %d observations from %s to %s for:%n %s", n, Helpers.timestamp((long)l), Helpers.timestamp((long)l2), string));
            atomicLong.set(Math.max(atomicLong.get(), l2));
        }, (long)l3);
        return atomicLong.get();
    }

    public void close() {
        IoUtil.unmap((MappedByteBuffer)this.cncByteBuffer);
    }
}

