/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.lmdbjava.Cursor;
import org.lmdbjava.GetOp;

public final class CursorIterator<T>
implements Iterator<KeyVal<T>>,
AutoCloseable {
    private final Cursor<T> cursor;
    private KeyVal<T> entry;
    private boolean first = true;
    private final T key;
    private State state = State.NOT_READY;
    private final IteratorType type;

    CursorIterator(Cursor<T> cursor, T key, IteratorType type) {
        this.cursor = cursor;
        this.type = type;
        this.key = key;
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public boolean hasNext() {
        switch (this.state) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    public Iterable<KeyVal<T>> iterable() {
        return () -> this;
    }

    @Override
    public KeyVal<T> next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        KeyVal<T> result = this.entry;
        this.entry = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void setEntry(boolean success) {
        this.entry = success ? new KeyVal<T>(this.cursor.key(), this.cursor.val()) : null;
    }

    private boolean tryToComputeNext() {
        if (this.first) {
            if (this.key != null) {
                this.setEntry(this.cursor.get(this.key, GetOp.MDB_SET_RANGE));
            } else if (this.type == IteratorType.FORWARD) {
                this.setEntry(this.cursor.first());
            } else {
                this.setEntry(this.cursor.last());
            }
            this.first = false;
            if (this.entry == null) {
                this.state = State.DONE;
                return false;
            }
        } else {
            if (this.type == IteratorType.FORWARD) {
                this.setEntry(this.cursor.next());
            } else {
                this.setEntry(this.cursor.prev());
            }
            if (this.entry == null) {
                this.state = State.DONE;
                return false;
            }
        }
        this.state = State.READY;
        return true;
    }

    static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }

    public static enum IteratorType {
        FORWARD,
        BACKWARD;

    }

    public static final class KeyVal<T> {
        private final T k;
        private final T v;

        public KeyVal(T key, T val) {
            this.k = key;
            this.v = val;
        }

        public T key() {
            return this.k;
        }

        public T val() {
            return this.v;
        }
    }
}

