/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.migrator;

import com.typesafe.config.Config;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.QueryTemplate;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.RepoUser;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.configuration.TaskAccess;
import com.xebialabs.xlrelease.configuration.UserProfile;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.calendar.SpecialDay;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.variables.GlobalVariables;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.migrator.SqlMigrator;
import com.xebialabs.xlrelease.migrator.SqlMigrator$migrateUsers$;
import com.xebialabs.xlrelease.migrator.config.Services;
import com.xebialabs.xlrelease.migrator.util.CloseableWorkDir;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.query.JcrPredicate;
import com.xebialabs.xlrelease.repository.query.JcrQueryBuilder;
import com.xebialabs.xlrelease.upgrade.Components;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.Session;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.security.authentication.CryptedSimpleCredentials;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import scala.Option;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\rJ\u001e\u0010\u0011\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\rH\u0002J\b\u0010\u0018\u001a\u00020\rH\u0002J\b\u0010\u0019\u001a\u00020\rH\u0002J\b\u0010\u001a\u001a\u00020\rH\u0002J\b\u0010\u001b\u001a\u00020\rH\u0002J\b\u0010\u001c\u001a\u00020\rH\u0002J\b\u0010\u001d\u001a\u00020\rH\u0002J\b\u0010\u001e\u001a\u00020\rH\u0002J\b\u0010\u001f\u001a\u00020\rH\u0002J\b\u0010 \u001a\u00020\rH\u0002J\b\u0010!\u001a\u00020\rH\u0002J\b\u0010\"\u001a\u00020\rH\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/xebialabs/xlrelease/migrator/SqlMigrator;", "", "services", "Lcom/xebialabs/xlrelease/migrator/config/Services;", "migratorConfig", "Lcom/typesafe/config/Config;", "(Lcom/xebialabs/xlrelease/migrator/config/Services;Lcom/typesafe/config/Config;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "pageSize", "", "createOrUpdateConfiguration", "", "conf", "Lcom/xebialabs/xlrelease/domain/BaseConfiguration;", "migrate", "migrateActivityLogs", "activityLogs", "", "Lcom/xebialabs/xlrelease/domain/ActivityLogEntry;", "releaseId", "", "migrateCalendarEntries", "migrateFoldersAndTeams", "migrateGlobalVariables", "migrateReleases", "migrateRepositoryVersion", "migrateRolesAndPermissions", "migrateSettings", "migrateSharedConfigurations", "migrateTaskAccess", "migrateUserProfiles", "migrateUsers", "setVersion", "xl-release-sql-migrator"})
public final class SqlMigrator {
    private final Logger logger;
    private final long pageSize;
    private final Services services;

    public final void migrate() {
        new WorkDirContext(new WorkDirFactory("work-migration"));
        this.logger.info("Migrating users");
        this.migrateUsers();
        this.logger.info("Users migrated");
        this.logger.info("Migrating user profiles");
        this.migrateUserProfiles();
        this.logger.info("User profiles migrated");
        this.logger.info("Migrating roles and permissions");
        this.migrateRolesAndPermissions();
        this.logger.info("Roles and permissions migrated");
        this.logger.info("Migrating shared configurations...");
        this.migrateSharedConfigurations();
        this.logger.info("Shared configurations migrated");
        this.logger.info("Migrating folders and teams...");
        this.migrateFoldersAndTeams();
        this.logger.info("Folders migrated");
        this.logger.info("Migrating settings...");
        this.migrateSettings();
        this.logger.info("Settings migrated");
        this.logger.info("Migrating task access settings...");
        this.migrateTaskAccess();
        this.logger.info("Task access settings migrated");
        this.logger.info("Migrating global variables...");
        this.migrateGlobalVariables();
        this.logger.info("Global variables migrated");
        this.logger.info("Migrating calendar entries...");
        this.migrateCalendarEntries();
        this.logger.info("Calendar entries migrated");
        this.logger.info("Migrating repository version...");
        this.migrateRepositoryVersion();
        this.logger.info("Repository version migrated");
        this.logger.info("Migrating releases with activity logs...");
        this.migrateReleases();
        this.logger.info("Releases and activity logs migrated");
        this.setVersion();
        this.logger.info("Migration process is done!");
    }

    private final void migrateRepositoryVersion() {
        Option maybeRepositoryId = this.services.getJcrRepositoryMetadataService().queryRepositoryId();
        if (maybeRepositoryId.isDefined()) {
            this.services.getSqlRepositoryMetadataService().saveRepositoryId((String)maybeRepositoryId.get());
        }
    }

    private final void setVersion() {
        Version version;
        Version version2 = version = this.services.getJcrRepositoryVersionService().readVersionOfComponent(Components.XL_RELEASE_COMPONENT);
        if ((version2 != null ? version2.getVersion() : null) != null) {
            this.logger.info("Setting XL Release xl_version to version " + version.getVersion() + "....");
            this.services.getSqlRepositoryVersionService().storeVersionOfComponent(Version.valueOf((String)Components.XL_RELEASE_COMPONENT, (String)version.getVersion()));
        }
    }

    private final void migrateUserProfiles() {
        SearchParameters query = new SearchParameters().setType(Type.valueOf(UserProfile.class));
        Iterable $receiver$iv = this.services.getRepositoryService().listEntities(query);
        for (Object element$iv : $receiver$iv) {
            UserProfile profile = (UserProfile)element$iv;
            if (!this.services.getSqlUserProfileRepository().exists(profile.getCanonicalId())) {
                this.services.getSqlUserProfileRepository().create(profile);
                continue;
            }
            this.logger.debug("User profile for [" + profile.getCanonicalId() + "] has already been migrated");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void migrateUsers() {
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.services.getJcrUserService().listUsernames();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it, (Object)"jcr_admin") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            String username = (String)element$iv;
            this.services.getJcrTemplate().execute((JcrCallback)new JcrCallback<Object>(username, this){
                final /* synthetic */ String $username;
                final /* synthetic */ SqlMigrator this$0;
                {
                    this.$username = string;
                    this.this$0 = sqlMigrator;
                }

                public final Object doInJcr(Session it) {
                    Session session = it;
                    if (session == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.apache.jackrabbit.api.JackrabbitSession");
                    }
                    UserManager um = ((JackrabbitSession)session).getUserManager();
                    Authorizable authorizable = um.getAuthorizable(this.$username);
                    if (authorizable == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.apache.jackrabbit.api.security.user.User");
                    }
                    User user = (User)authorizable;
                    Credentials credentials = user.getCredentials();
                    if (credentials == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.apache.jackrabbit.core.security.authentication.CryptedSimpleCredentials");
                    }
                    CryptedSimpleCredentials crypted = (CryptedSimpleCredentials)credentials;
                    return SqlMigrator.access$getServices$p(this.this$0).getReleasesTransactionTemplate().execute((TransactionCallback)new TransactionCallback<Object>(this, crypted){
                        final /* synthetic */ migrateUsers$$inlined$forEach$lambda$1 this$0;
                        final /* synthetic */ CryptedSimpleCredentials $crypted;
                        {
                            this.this$0 = var1_1;
                            this.$crypted = cryptedSimpleCredentials;
                        }

                        public final Object doInTransaction(TransactionStatus it) {
                            RepoUser repoUser;
                            try {
                                repoUser = SqlMigrator.access$getServices$p(this.this$0.this$0).getSqlUserService().read(this.this$0.$username);
                            }
                            catch (NotFoundException e) {
                                SqlMigrator.access$getServices$p(this.this$0.this$0).getReleasePersistence().jdbcTemplate().execute("INSERT INTO XL_USERS (USERNAME, PASSWORD) VALUES ('" + this.this$0.$username + "', '" + this.$crypted.getPassword() + "')");
                                repoUser = Unit.INSTANCE;
                            }
                            return repoUser;
                        }
                    });
                }
            });
        }
    }

    private final void migrateSharedConfigurations() {
        Function2<SearchParameters, Long, Unit> searchAndInsertSharedConfigurations$ = new Function2<SearchParameters, Long, Unit>(this){
            final /* synthetic */ SqlMigrator this$0;

            public final void invoke(@NotNull SearchParameters params, long pageNumber) {
                Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
                params.setPage(pageNumber);
                List configurations = SqlMigrator.access$getServices$p(this.this$0).getRepositoryService().listEntities(params);
                Iterable $receiver$iv = configurations;
                for (T element$iv : $receiver$iv) {
                    Configuration conf;
                    Configuration configuration = conf = (Configuration)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"conf");
                    SqlMigrator.access$createOrUpdateConfiguration(this.this$0, (BaseConfiguration)configuration);
                }
                if ((long)configurations.size() >= SqlMigrator.access$getPageSize$p(this.this$0)) {
                    this.invoke(params, pageNumber + 1L);
                }
            }
            {
                this.this$0 = sqlMigrator;
                super(2);
            }
        };
        SearchParameters searchParameters = new SearchParameters().setType(Type.valueOf(Configuration.class)).setPage(this.pageSize);
        Intrinsics.checkExpressionValueIsNotNull((Object)searchParameters, (String)"SearchParameters().setTy\u2026.java)).setPage(pageSize)");
        searchAndInsertSharedConfigurations$.invoke(searchParameters, 0L);
    }

    private final void migrateSettings() {
        List settingsIds = CollectionsKt.mutableListOf((Object[])new String[]{"Configuration/settings/ArchivingSettings", "Configuration/settings/PollingSettings", "Configuration/reports/ReportsSettings", "Configuration/mail/SmtpServer", "Configuration/mail/EmailNotificationSettings"});
        Iterable $receiver$iv = settingsIds;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            if (this.services.getRepositoryService().exists(it)) {
                BaseConfiguration configuration;
                BaseConfiguration baseConfiguration = configuration = (BaseConfiguration)this.services.getRepositoryService().read(it, false);
                Intrinsics.checkExpressionValueIsNotNull((Object)baseConfiguration, (String)"configuration");
                this.createOrUpdateConfiguration(baseConfiguration);
                continue;
            }
            this.logger.info("Skipping migration of non-existing configuration [" + it + ']');
        }
    }

    private final void migrateTaskAccess() {
        SearchParameters params = new SearchParameters().setType(Type.valueOf(TaskAccess.class));
        List taskAccesses = this.services.getRepositoryService().listEntities(params);
        Iterable $receiver$iv = taskAccesses;
        for (Object element$iv : $receiver$iv) {
            TaskAccess ta;
            TaskAccess taskAccess = ta = (TaskAccess)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)taskAccess, (String)"ta");
            this.createOrUpdateConfiguration((BaseConfiguration)taskAccess);
        }
    }

    private final void migrateGlobalVariables() {
        if (this.services.getRepositoryService().exists(GlobalVariables.GLOBAL_VARIABLES_ID)) {
            GlobalVariables globalVariables = (GlobalVariables)this.services.getRepositoryService().read(GlobalVariables.GLOBAL_VARIABLES_ID);
            Iterable $receiver$iv = globalVariables.getVariables();
            for (Object element$iv : $receiver$iv) {
                Variable it;
                Variable variable = it = (Variable)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)variable, (String)"it");
                this.createOrUpdateConfiguration((BaseConfiguration)variable);
            }
        } else {
            this.logger.info("Skipping migration of non-existing global variables");
        }
    }

    private final void migrateCalendarEntries() {
        SearchParameters sdParams = new SearchParameters().setType(Type.valueOf(SpecialDay.class));
        List specialDays = this.services.getRepositoryService().listEntities(sdParams);
        Iterable $receiver$iv = specialDays;
        for (Object element$iv : $receiver$iv) {
            SpecialDay sd = (SpecialDay)element$iv;
            sd.set$token((String)null);
            this.services.getCalendarService().setSpecialDay(sd.getId(), sd);
        }
        SearchParameters boParams = new SearchParameters().setType(Type.valueOf(Blackout.class));
        List blackouts = this.services.getRepositoryService().listEntities(boParams);
        Iterable $receiver$iv2 = blackouts;
        for (Object element$iv : $receiver$iv2) {
            Blackout bo = (Blackout)element$iv;
            bo.set$token((String)null);
            this.services.getCalendarService().addBlackout(bo);
        }
    }

    private final void createOrUpdateConfiguration(BaseConfiguration conf) {
        this.logger.debug("Migrating [" + conf.getId() + ']');
        conf.set$token((String)null);
        this.services.getSqlConfigurationRepository().createOrUpdate(conf);
    }

    private final void migrateRolesAndPermissions() {
        List roleAssignments = this.services.getJcrRoleService().readRoleAssignments();
        this.services.getSqlRoleService().writeRoleAssignments(roleAssignments);
        Map globalPermissionsMap = this.services.getJcrPermissionEditor().readPermissions("global");
        List rolePermissions = new DtoWriter().writeRolePermissions(globalPermissionsMap);
        List roles = this.services.getSqlRoleService().getRoles();
        Map multimap = new DtoReader().readRolePermissions(rolePermissions, roles);
        this.services.getSqlPermissionEditor().editPermissions("global", multimap);
    }

    private final void migrateFoldersAndTeams() {
        Function2<String, Long, Unit> createFolderAndTeams$ = new Function2<String, Long, Unit>(this){
            final /* synthetic */ SqlMigrator this$0;

            public final void invoke(@NotNull String rootFolder, long pageNumber) {
                Intrinsics.checkParameterIsNotNull((Object)rootFolder, (String)"rootFolder");
                QueryTemplate query = JcrQueryBuilder.select((String[])new String[]{"*"}).from("ci").where(JcrPredicate.and((JcrPredicate[])new JcrPredicate[]{JcrPredicate.as((String)"ci", (Type)Type.valueOf((String)"xlrelease.Folder")), JcrPredicate.isChildNode((String)"ci", (String)JcrPathHelper.getAbsolutePathFromId((String)rootFolder))})).orderBy("title ASC").build();
                query.setPage(pageNumber);
                query.setResultsPerPage(SqlMigrator.access$getPageSize$p(this.this$0));
                List folders = SqlMigrator.access$getServices$p(this.this$0).getRepositoryService().listEntities(query);
                Iterable $receiver$iv = folders;
                for (T element$iv : $receiver$iv) {
                    Folder folder = (Folder)element$iv;
                    if (!SqlMigrator.access$getServices$p(this.this$0).getSqlFolderRepository().exists(folder.getId())) {
                        SqlMigrator.access$getLogger$p(this.this$0).debug("Migrating folder [" + folder.getId() + ']');
                        SqlMigrator.access$getServices$p(this.this$0).getReleasesTransactionTemplate().execute((TransactionCallback)new TransactionCallback<List<Team>>(folder, this){
                            final /* synthetic */ Folder $folder;
                            final /* synthetic */ migrateFoldersAndTeams.1 this$0;
                            {
                                this.$folder = folder;
                                this.this$0 = var2_2;
                            }

                            public final List<Team> doInTransaction(TransactionStatus it) {
                                SqlMigrator.access$getServices$p(this.this$0.this$0).getSqlFolderRepository().create(Ids.getParentId((String)this.$folder.getId()), this.$folder);
                                List teams = SqlMigrator.access$getServices$p(this.this$0.this$0).getJcrTeamRepository().getStoredTeams(this.$folder.getId());
                                Iterable $receiver$iv = teams;
                                for (T element$iv : $receiver$iv) {
                                    Team team = (Team)element$iv;
                                    team.setId((String)null);
                                }
                                return SqlMigrator.access$getServices$p(this.this$0.this$0).getTeamService().saveTeamsToPlatform(this.$folder.getId(), teams);
                            }
                        });
                    } else {
                        SqlMigrator.access$getLogger$p(this.this$0).debug("Folder [" + folder.getId() + "] has already been migrated");
                    }
                    String string = folder.getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"folder.id");
                    this.invoke(string, 0L);
                }
                if ((long)folders.size() >= SqlMigrator.access$getPageSize$p(this.this$0)) {
                    this.invoke(rootFolder, pageNumber + 1L);
                }
            }
            {
                this.this$0 = sqlMigrator;
                super(2);
            }
        };
        createFolderAndTeams$.invoke("/Applications", 0L);
    }

    private final void migrateReleases() {
        Function2<SearchParameters, Long, Unit> searchAndInsertReleases$ = new Function2<SearchParameters, Long, Unit>(this){
            final /* synthetic */ SqlMigrator this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull SearchParameters params, long pageNumber) {
                Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
                SqlMigrator.access$getLogger$p(this.this$0).info("Processing items " + pageNumber * SqlMigrator.access$getPageSize$p(this.this$0) + " - " + (pageNumber + 1L) * SqlMigrator.access$getPageSize$p(this.this$0) + "...");
                Closeable closeable = new CloseableWorkDir();
                boolean bl = false;
                try {
                    void $receiver$iv$iv;
                    CloseableWorkDir it = (CloseableWorkDir)closeable;
                    Ref.IntRef intRef = new Ref.IntRef();
                    intRef.element = 0;
                    params.setPage(pageNumber);
                    Iterable $receiver$iv = SqlMigrator.access$getServices$p(this.this$0).getRepositoryService().list(params);
                    Iterable iterable = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it2;
                        ConfigurationItemData configurationItemData = (ConfigurationItemData)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        String string = it2.getId();
                        collection.add(string);
                    }
                    List releaseIds = (List)destination$iv$iv;
                    $receiver$iv = releaseIds;
                    if (!$receiver$iv.isEmpty()) {
                        void skippedCount;
                        $receiver$iv = releaseIds;
                        for (E element$iv : $receiver$iv) {
                            String releaseId = (String)element$iv;
                            if (!SqlMigrator.access$getServices$p(this.this$0).getSqlReleaseRepository().exists(releaseId)) {
                                SqlMigrator.access$getLogger$p(this.this$0).debug("Migrating release " + releaseId);
                                Release release = (Release)SqlMigrator.access$getServices$p(this.this$0).getRepositoryService().read(releaseId, Integer.MAX_VALUE, WorkDirContext.get(), false);
                                SqlMigrator.access$getServices$p(this.this$0).getJcrTeamRepository().decorateWithStoredTeams(release);
                                SqlMigrator.access$getServices$p(this.this$0).getReleasesTransactionTemplate().execute((TransactionCallback)new TransactionCallback<List<Team>>(release, releaseId, (Ref.IntRef)skippedCount, this, params, pageNumber){
                                    final /* synthetic */ Release $release;
                                    final /* synthetic */ String $releaseId;
                                    final /* synthetic */ Ref.IntRef $skippedCount$inlined;
                                    final /* synthetic */ migrateReleases.1 this$0;
                                    final /* synthetic */ SearchParameters $params$inlined;
                                    final /* synthetic */ long $pageNumber$inlined;
                                    {
                                        this.$release = release;
                                        this.$releaseId = string;
                                        this.$skippedCount$inlined = intRef;
                                        this.this$0 = var4_4;
                                        this.$params$inlined = searchParameters;
                                        this.$pageNumber$inlined = l;
                                    }

                                    public final List<Team> doInTransaction(TransactionStatus it) {
                                        SqlMigrator.access$getServices$p(this.this$0.this$0).getSqlReleaseRepository().create(this.$release, null);
                                        List activityLogs = SqlMigrator.access$getServices$p(this.this$0.this$0).getJcrActivityLogRepository().findAllLogsOf(this.$releaseId);
                                        SqlMigrator sqlMigrator = this.this$0.this$0;
                                        List list = activityLogs;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"activityLogs");
                                        String string = this.$releaseId;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"releaseId");
                                        SqlMigrator.access$migrateActivityLogs(sqlMigrator, list, string);
                                        Iterable $receiver$iv = this.$release.getTeams();
                                        for (T element$iv : $receiver$iv) {
                                            Team team = (Team)element$iv;
                                            team.setId((String)null);
                                        }
                                        return SqlMigrator.access$getServices$p(this.this$0.this$0).getTeamService().saveTeamsToPlatform(this.$release);
                                    }
                                });
                                continue;
                            }
                            SqlMigrator.access$getLogger$p(this.this$0).debug("Release [" + releaseId + "] has already been migrated");
                            int n = skippedCount.element;
                            skippedCount.element = n + 1;
                        }
                        if (skippedCount.element > 0) {
                            SqlMigrator.access$getLogger$p(this.this$0).info("Skipped " + skippedCount.element + " releases as they have already been migrated");
                        }
                        if ((long)releaseIds.size() >= SqlMigrator.access$getPageSize$p(this.this$0)) {
                            this.invoke(params, pageNumber + 1L);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Exception exception) {
                    try {
                        bl = true;
                        try {
                            closeable.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        throw (Throwable)exception;
                    }
                    catch (Throwable throwable) {
                        if (!bl) {
                            closeable.close();
                        }
                        throw throwable;
                    }
                }
                closeable.close();
            }
            {
                this.this$0 = sqlMigrator;
                super(2);
            }
        };
        Function2<SearchParameters, Long, Unit> searchAndUpdateDependencies$ = new Function2<SearchParameters, Long, Unit>(this, searchAndInsertReleases$){
            final /* synthetic */ SqlMigrator this$0;
            final /* synthetic */ migrateReleases.1 $searchAndInsertReleases;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull SearchParameters params, long pageNumber) {
                Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
                SqlMigrator.access$getLogger$p(this.this$0).info("Processing items " + pageNumber * SqlMigrator.access$getPageSize$p(this.this$0) + " - " + (pageNumber + 1L) * SqlMigrator.access$getPageSize$p(this.this$0) + "...");
                Closeable closeable = new CloseableWorkDir();
                boolean bl = false;
                try {
                    void $receiver$iv$iv;
                    CloseableWorkDir it = (CloseableWorkDir)closeable;
                    params.setPage(pageNumber);
                    Iterable $receiver$iv = SqlMigrator.access$getServices$p(this.this$0).getRepositoryService().list(params);
                    Iterable iterable = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it2;
                        ConfigurationItemData configurationItemData = (ConfigurationItemData)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        String string = it2.getId();
                        collection.add(string);
                    }
                    List dependenciesIds = (List)destination$iv$iv;
                    $receiver$iv = dependenciesIds;
                    if (!$receiver$iv.isEmpty()) {
                        $receiver$iv = dependenciesIds;
                        for (E element$iv : $receiver$iv) {
                            String dependencyId = (String)element$iv;
                            SqlMigrator.access$getLogger$p(this.this$0).debug("Migrating dependencies for " + Ids.releaseIdFrom((String)dependencyId));
                            Release releaseJcr = (Release)SqlMigrator.access$getServices$p(this.this$0).getRepositoryService().read(Ids.releaseIdFrom((String)dependencyId), Integer.MAX_VALUE, WorkDirContext.get(), false);
                            Release releaseSql = SqlMigrator.access$getServices$p(this.this$0).getSqlReleaseRepository().findById(releaseJcr.getId());
                            Iterable $receiver$iv2 = releaseJcr.getAllGates();
                            for (T element$iv2 : $receiver$iv2) {
                                GateTask gate = (GateTask)element$iv2;
                                Iterable $receiver$iv3 = gate.getDependencies();
                                for (T element$iv3 : $receiver$iv3) {
                                    Dependency dependency = (Dependency)element$iv3;
                                    SqlMigrator.access$getServices$p(this.this$0).getSqlDependencyRepository().update(releaseSql, dependency);
                                }
                            }
                        }
                        if ((long)dependenciesIds.size() >= SqlMigrator.access$getPageSize$p(this.this$0)) {
                            this.$searchAndInsertReleases.invoke(params, pageNumber + 1L);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Exception exception) {
                    try {
                        bl = true;
                        try {
                            closeable.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        throw (Throwable)exception;
                    }
                    catch (Throwable throwable) {
                        if (!bl) {
                            closeable.close();
                        }
                        throw throwable;
                    }
                }
                closeable.close();
            }
            {
                this.this$0 = sqlMigrator;
                this.$searchAndInsertReleases = var2_2;
                super(2);
            }
        };
        SearchParameters releaseParams = new SearchParameters();
        releaseParams.setType(Type.valueOf(Release.class));
        releaseParams.setResultsPerPage(this.pageSize);
        searchAndInsertReleases$.invoke(releaseParams, 0L);
        SearchParameters dependencyParams = new SearchParameters();
        dependencyParams.setType(Type.valueOf(Dependency.class));
        dependencyParams.setResultsPerPage(this.pageSize);
        searchAndUpdateDependencies$.invoke(dependencyParams, 0L);
    }

    private final void migrateActivityLogs(List<ActivityLogEntry> activityLogs, String releaseId) {
        this.logger.debug("Migrating " + activityLogs.size() + " activity logs of release " + releaseId);
        Iterable $receiver$iv = activityLogs;
        for (Object element$iv : $receiver$iv) {
            ActivityLogEntry log = (ActivityLogEntry)element$iv;
            this.logger.trace("Migrating activity log " + log.getId());
            this.services.getSqlActivityLogRepository().log(releaseId, log, log.getUsername());
        }
    }

    public SqlMigrator(@NotNull Services services, @NotNull Config migratorConfig) {
        Intrinsics.checkParameterIsNotNull((Object)services, (String)"services");
        Intrinsics.checkParameterIsNotNull((Object)migratorConfig, (String)"migratorConfig");
        this.services = services;
        this.logger = LoggerFactory.getLogger(SqlMigrator.class);
        this.pageSize = migratorConfig.getLong("xl.migrator.pageSize");
    }

    @NotNull
    public static final /* synthetic */ Services access$getServices$p(SqlMigrator $this) {
        return $this.services;
    }

    public static final /* synthetic */ void access$createOrUpdateConfiguration(SqlMigrator $this, @NotNull BaseConfiguration conf) {
        $this.createOrUpdateConfiguration(conf);
    }

    public static final /* synthetic */ long access$getPageSize$p(SqlMigrator $this) {
        return $this.pageSize;
    }

    public static final /* synthetic */ Logger access$getLogger$p(SqlMigrator $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$migrateActivityLogs(SqlMigrator $this, @NotNull List activityLogs, @NotNull String releaseId) {
        $this.migrateActivityLogs(activityLogs, releaseId);
    }
}

