/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class BooleanElement
extends AtomicElement<Boolean> {
    private final boolean _value;

    public BooleanElement(Element parent, Element current, boolean b) {
        super(parent, current);
        this._value = b;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Boolean getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.BOOL;
    }

    @Override
    public int encode(ByteBuffer b) {
        if (b.hasRemaining()) {
            if (this.isElementOfArray()) {
                b.put(this._value ? (byte)1 : 0);
            } else {
                b.put(this._value ? (byte)65 : 66);
            }
            return 1;
        }
        return 0;
    }
}

