/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.platform.sso.oidc.service;

import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import java.util.List;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.util.StringUtils;

public class XLOidcUserService
extends OidcUserService {
    private final ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy;

    public XLOidcUserService(ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        this.claimsToGrantedAuthoritiesPolicy = claimsToGrantedAuthoritiesPolicy;
    }

    public OidcUser loadUser(OidcUserRequest userRequest) {
        OidcUser user = super.loadUser(userRequest);
        Map oidcClaims = userRequest.getIdToken().getClaims();
        String userNameAttributeName = userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName();
        List<GrantedAuthority> authorities = this.claimsToGrantedAuthoritiesPolicy.claimsToGrantedAuthorities(oidcClaims);
        DefaultOidcUser updatedUser = StringUtils.hasText((String)userNameAttributeName) ? new DefaultOidcUser(authorities, userRequest.getIdToken(), user.getUserInfo(), userNameAttributeName) : new DefaultOidcUser(authorities, userRequest.getIdToken(), user.getUserInfo());
        return updatedUser;
    }
}

