/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.codec.Base64InputStream;
import org.apache.james.mime4j.codec.QuotedPrintableInputStream;
import org.apache.james.mime4j.util.CharsetUtil;

public class DecoderUtil {
    private static Log log = LogFactory.getLog(DecoderUtil.class);
    private static final Pattern PATTERN_ENCODED_WORD = Pattern.compile("(.*?)=\\?([^\\?]+?)\\?(\\w)\\?([^\\?]+?)\\?=", 32);

    public static byte[] decodeQuotedPrintable(String s) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] bytes = s.getBytes("US-ASCII");
            QuotedPrintableInputStream is = new QuotedPrintableInputStream(new ByteArrayInputStream(bytes));
            int b = 0;
            while ((b = is.read()) != -1) {
                baos.write(b);
            }
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new IllegalStateException(e);
        }
        return baos.toByteArray();
    }

    public static byte[] decodeBase64(String s) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] bytes = s.getBytes("US-ASCII");
            Base64InputStream is = new Base64InputStream(new ByteArrayInputStream(bytes));
            int b = 0;
            while ((b = is.read()) != -1) {
                baos.write(b);
            }
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new IllegalStateException(e);
        }
        return baos.toByteArray();
    }

    public static String decodeB(String encodedText, String charset) throws UnsupportedEncodingException {
        byte[] decodedBytes = DecoderUtil.decodeBase64(encodedText);
        return new String(decodedBytes, charset);
    }

    public static String decodeQ(String encodedText, String charset) throws UnsupportedEncodingException {
        encodedText = DecoderUtil.replaceUnderscores(encodedText);
        byte[] decodedBytes = DecoderUtil.decodeQuotedPrintable(encodedText);
        return new String(decodedBytes, charset);
    }

    public static String decodeEncodedWords(String body) {
        int tailIndex = 0;
        boolean lastMatchValid = false;
        StringBuilder sb = new StringBuilder();
        Matcher matcher = PATTERN_ENCODED_WORD.matcher(body);
        while (matcher.find()) {
            String encodedText;
            String encoding;
            String separator = matcher.group(1);
            String mimeCharset = matcher.group(2);
            String decoded = DecoderUtil.tryDecodeEncodedWord(mimeCharset, encoding = matcher.group(3), encodedText = matcher.group(4));
            if (decoded == null) {
                sb.append(matcher.group(0));
            } else {
                if (!lastMatchValid || !CharsetUtil.isWhitespace(separator)) {
                    sb.append(separator);
                }
                sb.append(decoded);
            }
            tailIndex = matcher.end();
            lastMatchValid = decoded != null;
        }
        if (tailIndex == 0) {
            return body;
        }
        sb.append(body.substring(tailIndex));
        return sb.toString();
    }

    private static String tryDecodeEncodedWord(String mimeCharset, String encoding, String encodedText) {
        String charset = CharsetUtil.toJavaCharset(mimeCharset);
        if (charset == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("MIME charset '" + mimeCharset + "' in encoded word '" + DecoderUtil.recombine(mimeCharset, encoding, encodedText) + "' doesn't have a " + "corresponding Java charset"));
            }
            return null;
        }
        if (!CharsetUtil.isDecodingSupported(charset)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Current JDK doesn't support decoding of charset '" + charset + "' (MIME charset '" + mimeCharset + "' in encoded word '" + DecoderUtil.recombine(mimeCharset, encoding, encodedText) + "')"));
            }
            return null;
        }
        if (encodedText.length() == 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Missing encoded text in encoded word: '" + DecoderUtil.recombine(mimeCharset, encoding, encodedText) + "'"));
            }
            return null;
        }
        try {
            if (encoding.equalsIgnoreCase("Q")) {
                return DecoderUtil.decodeQ(encodedText, charset);
            }
            if (encoding.equalsIgnoreCase("B")) {
                return DecoderUtil.decodeB(encodedText, charset);
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)("Warning: Unknown encoding in encoded word '" + DecoderUtil.recombine(mimeCharset, encoding, encodedText) + "'"));
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Unsupported encoding in encoded word '" + DecoderUtil.recombine(mimeCharset, encoding, encodedText) + "'"), (Throwable)e);
            }
            return null;
        }
        catch (RuntimeException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not decode encoded word '" + DecoderUtil.recombine(mimeCharset, encoding, encodedText) + "'"), (Throwable)e);
            }
            return null;
        }
    }

    private static String recombine(String mimeCharset, String encoding, String encodedText) {
        return "=?" + mimeCharset + "?" + encoding + "?" + encodedText + "?=";
    }

    private static String replaceUnderscores(String str) {
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '_') {
                sb.append("=20");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

