/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import lombok.Generated;
import lombok.NonNull;
import org.springframework.data.repository.core.EntityInformation;

public abstract class AbstractEntityInformation<T, ID>
implements EntityInformation<T, ID> {
    @NonNull
    private final Class<T> domainClass;

    @Override
    public boolean isNew(T entity) {
        Object id = this.getId(entity);
        Class idType = this.getIdType();
        if (!idType.isPrimitive()) {
            return id == null;
        }
        if (id instanceof Number) {
            return ((Number)id).longValue() == 0L;
        }
        throw new IllegalArgumentException(String.format("Unsupported primitive id type %s!", idType));
    }

    @Override
    public Class<T> getJavaType() {
        return this.domainClass;
    }

    @Generated
    public AbstractEntityInformation(@NonNull Class<T> domainClass) {
        if (domainClass == null) {
            throw new IllegalArgumentException("domainClass is marked non-null but is null");
        }
        this.domainClass = domainClass;
    }
}

