/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.persistence;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.package;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksSqlBuilder$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.utils.DateVariableUtils;
import java.io.Serializable;
import java.util.Date;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]v!B\u000f\u001f\u0011\u0003Yc!B\u0017\u001f\u0011\u0003q\u0003\"B\u001b\u0002\t\u00031\u0004\"B\u001c\u0002\t\u0003Ad\u0001B\u0017\u001f\u0001%C\u0011B\u0015\u0003\u0003\u0002\u0003\u0006Ya\u00153\t\u000bU\"A\u0011A3\t\u000b!$A\u0011A5\t\u000b)$A\u0011A6\t\r}$A\u0011AA\u0001\u0011\u001d\ty\u0002\u0002C\u0001\u0003CAq!!\f\u0005\t\u0003\ty\u0003C\u0004\u00026\u0011!\t!a\u000e\t\u000f\u0005EC\u0001\"\u0001\u0002T!9\u0011\u0011\f\u0003\u0005\u0002\u0005m\u0003bBA0\t\u0011\u0005\u0011\u0011\r\u0005\b\u0003O\"A\u0011AA5\u0011\u001d\t)\b\u0002C\u0001\u0003oBq!a \u0005\t\u0003\t\t\t\u0003\u0004\u0002\u0012\u0012!\t!\u001b\u0005\u0007\u0003'#A\u0011A5\t\u000f\u0005UE\u0001\"\u0003\u0002\u0018\"9\u0011q\u0014\u0003\u0005\n\u0005\u0005\u0006bBAU\t\u0011%\u0011\u0011\u0015\u0005\b\u0003W#A\u0011BAQ\u0011\u001d\ti\u000b\u0002C\u0005\u0003CCq!a,\u0005\t\u0013\t\t\u000bC\u0004\u00022\u0012!I!!)\t\u000f\u0005MF\u0001\"\u0011\u00026\u0006yA+Y:lgN\u000bHNQ;jY\u0012,'O\u0003\u0002 A\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\t\t#%A\u0002tc2T!a\t\u0013\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002&M\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003O!\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003%\n1aY8n\u0007\u0001\u0001\"\u0001L\u0001\u000e\u0003y\u0011q\u0002V1tWN\u001c\u0016\u000f\u001c\"vS2$WM]\n\u0003\u0003=\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001,\u00035qwN]7bY&TX\rV1hgR\u0011\u0011h\u0012\t\u0004u\u0005#eBA\u001e@!\ta\u0014'D\u0001>\u0015\tq$&\u0001\u0004=e>|GOP\u0005\u0003\u0001F\na\u0001\u0015:fI\u00164\u0017B\u0001\"D\u0005\r\u0019V\r\u001e\u0006\u0003\u0001F\u0002\"AO#\n\u0005\u0019\u001b%AB*ue&tw\rC\u0003I\u0007\u0001\u0007\u0011(\u0001\u0003uC\u001e\u001c8C\u0001\u0003K!\rYu*U\u0007\u0002\u0019*\u0011\u0011%\u0014\u0006\u0003\u001d\u0012\n!\u0001\u001a2\n\u0005Ac%AC*rY\n+\u0018\u000e\u001c3feB\u0011A\u0006B\u0001\bI&\fG.Z2u!\t!\u0016M\u0004\u0002V?:\u0011aK\u0018\b\u0003/vs!\u0001\u0017/\u000f\u0005e[fB\u0001\u001f[\u0013\u0005I\u0013BA\u0014)\u0013\t)c%\u0003\u0002OI%\u0011\u0011%T\u0005\u0003A2\u000b!bU9m\u0005VLG\u000eZ3s\u0013\t\u00117MA\u0004ES\u0006dWm\u0019;\u000b\u0005\u0001d\u0015B\u0001*P)\u00051GCA)h\u0011\u0015\u0011f\u0001q\u0001T\u00031\u0019X\r\\3diR\u000b7o[%e)\u0005\t\u0016\u0001G<ji\"|e.Z(g%\u0016dW-Y:f'R\fG/^:fgR\u0011\u0011\u000b\u001c\u0005\u0006[\"\u0001\rA\\\u0001\tgR\fG/^:fgB\u0019q\u000e^<\u000f\u0005A\u0014hB\u0001\u001fr\u0013\u0005\u0011\u0014BA:2\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001e<\u0003\u0007M+\u0017O\u0003\u0002tcA\u0011\u00010`\u0007\u0002s*\u0011!p_\u0001\u0007gR\fG/^:\u000b\u0005q$\u0013A\u00023p[\u0006Lg.\u0003\u0002\u007fs\ni!+\u001a7fCN,7\u000b^1ukN\fqb^5uQR\u000b7o\u001b+za\u0016tu\u000e\u001e\u000b\u0004#\u0006\r\u0001bBA\u0003\u0013\u0001\u0007\u0011qA\u0001\ti\u0006\u001c8\u000eV=qKB!\u0011\u0011BA\u000e\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011a\u0002:fM2,7\r\u001e\u0006\u0005\u0003#\t\u0019\"A\u0002ba&TA!!\u0006\u0002\u0018\u00051\u0001\u000f\\;hS:T1!!\u0007'\u0003!!W\r\u001d7ps&$\u0018\u0002BA\u000f\u0003\u0017\u0011A\u0001V=qK\u0006)r/\u001b;i\u001f:,wJ\u001a+bg.\u001cF/\u0019;vg\u0016\u001cHcA)\u0002$!1QN\u0003a\u0001\u0003K\u0001Ba\u001c;\u0002(A\u0019\u00010!\u000b\n\u0007\u0005-\u0012P\u0001\u0006UCN\\7\u000b^1ukN\f!b^5uQ\u001aKG\u000e^3s)\r\t\u0016\u0011\u0007\u0005\u0007\u0003gY\u0001\u0019\u0001#\u0002\r\u0019LG\u000e^3s\u0003%9\u0018\u000e\u001e5ECR,7\u000fF\u0003R\u0003s\ti\u0005C\u0004\u0002<1\u0001\r!!\u0010\u0002\t\u0019\u0014x.\u001c\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003\u0011)H/\u001b7\u000b\u0005\u0005\u001d\u0013\u0001\u00026bm\u0006LA!a\u0013\u0002B\t!A)\u0019;f\u0011\u001d\ty\u0005\u0004a\u0001\u0003{\t!\u0001^8\u0002-]LG\u000f[*dQ\u0016$W\u000f\\3e'R\f'\u000f\u001e#bi\u0016$2!UA+\u0011\u001d\t9&\u0004a\u0001\u0003{\tA\u0001Z1uK\u0006iq/\u001b;i\u0003:LxJ\u001a+bON$2!UA/\u0011\u0015Ae\u00021\u0001:\u000359\u0018\u000e\u001e5G_2$WM]%egR\u0019\u0011+a\u0019\t\r\u0005\u0015t\u00021\u0001:\u0003%1w\u000e\u001c3fe&#7/\u0001\txSRD\u0017i]:jO:,G\rV8NKR\u0019\u0011+a\u001b\t\u000f\u00055\u0004\u00031\u0001\u0002p\u0005Q\u0001O]5oG&\u0004\u0018\r\\:\u0011\t=\f\t\bR\u0005\u0004\u0003g2(\u0001C%uKJ\f'\r\\3\u00023]LG\u000f[!tg&<g.\u001a3U_6+wJ]'z)\u0016\fWn\u001d\u000b\u0006#\u0006e\u00141\u0010\u0005\b\u0003[\n\u0002\u0019AA8\u0011\u001d\ti(\u0005a\u0001\u0003_\nqA]8mK&#7/A\u000bxSRD\u0017i]:jO:,G\rV8B]f\u0014w\u000eZ=\u0015\u000fE\u000b\u0019)!\"\u0002\b\"9\u0011Q\u000e\nA\u0002\u0005=\u0004bBA?%\u0001\u0007\u0011q\u000e\u0005\b\u0003\u0013\u0013\u0002\u0019AAF\u0003\u001dI7/\u00113nS:\u00042\u0001MAG\u0013\r\ty)\r\u0002\b\u0005>|G.Z1o\u000359\u0018\u000e\u001e5B]f4\u0015mY3ug\u0006iqN\u001d3fe\nKH+Y:l\u0013\u0012\fqAY5oI&tw\rF\u0002E\u00033Cq!a'\u0016\u0001\u0004\ti*\u0001\u0004wC2,Xm\u001d\t\u0005_\u0006Et&A\u0005k_&tG+Z1ngR\u0011\u00111\u0015\t\u0004a\u0005\u0015\u0016bAATc\t!QK\\5u\u00035Qw.\u001b8UK\u0006l'k\u001c7fg\u0006\u0011\"n\\5o)\u0016\fW\u000e\u0015:j]\u000eL\u0007/\u00197t\u0003MQw.\u001b8UK\u0006l\u0007+\u001a:nSN\u001c\u0018n\u001c8t\u0003-Qw.\u001b8G_2$WM]:\u0002\u0015)|\u0017N\u001c$bG\u0016$8/A\u0006oK^Len\u001d;b]\u000e,W#A)")
public class TasksSqlBuilder
extends SqlBuilder<TasksSqlBuilder> {
    public static Set<String> normalizeTags(Set<String> set) {
        return TasksSqlBuilder$.MODULE$.normalizeTags(set);
    }

    public TasksSqlBuilder selectTaskId() {
        return (TasksSqlBuilder)super.select(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(127).append("SELECT\n         |  DISTINCT tasks.").append(Schema.TASKS$.MODULE$.TASK_ID()).append("\n         |FROM\n         |  ").append(Schema.TASKS$.MODULE$.TABLE()).append(" tasks\n         |  JOIN ").append(Schema.RELEASES$.MODULE$.TABLE()).append(" releases ON tasks.").append(Schema.TASKS$.MODULE$.RELEASE_UID()).append(" = releases.").append(Schema.RELEASES$.MODULE$.CI_UID()).append("\n         ").toString())).stripMargin());
    }

    public TasksSqlBuilder withOneOfReleaseStatuses(Seq<ReleaseStatus> statuses) {
        Object object = statuses.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(15).append("releases.").append(Schema.RELEASES$.MODULE$.STATUS()).append(" IN (").append(this.binding((Iterable<Object>)statuses)).append(")").toString(), (Iterable)statuses.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.value(), Seq$.MODULE$.canBuildFrom()))) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withTaskTypeNot(Type taskType) {
        this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(11).append("tasks.").append(Schema.TASKS$.MODULE$.TASK_TYPE()).append(" != ?").toString(), (Iterable)new .colon.colon((Object)taskType.toString(), (List)Nil$.MODULE$)));
        return this;
    }

    public TasksSqlBuilder withOneOfTaskStatuses(Seq<TaskStatus> statuses) {
        Object object = statuses.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(12).append("tasks.").append(Schema.TASKS$.MODULE$.STATUS()).append(" IN (").append(this.binding((Iterable<Object>)statuses)).append(")").toString(), (Iterable)statuses.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.value(), Seq$.MODULE$.canBuildFrom()))) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withFilter(String filter) {
        Object object = filter != null ? this.likeOr((Seq)new .colon.colon((Object)new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.TITLE()).toString(), (List)new .colon.colon((Object)new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.OWNER()).toString(), (List)new .colon.colon((Object)new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.TEAM()).toString(), (List)new .colon.colon((Object)new StringBuilder(9).append("releases.").append(Schema.RELEASES$.MODULE$.RELEASE_TITLE()).toString(), (List)Nil$.MODULE$)))), filter) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withDates(Date from, Date to) {
        Object object;
        if (from != null && to != null) {
            object = this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(43).append("(? <= tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" OR ? <= tasks.").append(Schema.TASKS$.MODULE$.END_DATE()).append(") AND tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" < ?").toString(), (Iterable)new .colon.colon((Object)from, (List)new .colon.colon((Object)from, (List)new .colon.colon((Object)to, (List)Nil$.MODULE$)))));
        } else {
            Object object2 = from != null ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(28).append("(? <= tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" OR ? <= tasks.").append(Schema.TASKS$.MODULE$.END_DATE()).append(")").toString(), (Iterable)new .colon.colon((Object)from, (List)new .colon.colon((Object)from, (List)Nil$.MODULE$)))) : BoxedUnit.UNIT;
            object = to != null ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(10).append("tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" < ?").toString(), (Iterable)new .colon.colon((Object)to, (List)Nil$.MODULE$))) : BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withScheduledStartDate(Date date) {
        this.conditions().$plus$eq((Object)new package.Sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(32).append("\n         |tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" = ?\n         |").toString())).stripMargin(), (Iterable)new .colon.colon((Object)new Date(Predef$.MODULE$.Long2long(DateVariableUtils.truncateMilliseconds((Long)Predef$.MODULE$.long2Long(date.getTime())))), (List)Nil$.MODULE$)));
        return this;
    }

    public TasksSqlBuilder withAnyOfTags(Set<String> tags) {
        BoxedUnit boxedUnit;
        Set<String> normalizedTags = TasksSqlBuilder$.MODULE$.normalizeTags(tags);
        if (normalizedTags.nonEmpty()) {
            String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(159).append("\n           |tasks.").append(Schema.TASKS$.MODULE$.CI_UID()).append(" IN (\n           |  SELECT DISTINCT task_tags.").append(Schema.TASK_TAGS$.MODULE$.CI_UID()).append("\n           |  FROM ").append(Schema.TASK_TAGS$.MODULE$.TABLE()).append(" task_tags\n           |  WHERE task_tags.").append(Schema.TASK_TAGS$.MODULE$.VALUE()).append(" IN (").append(this.binding((Iterable<Object>)normalizedTags)).append(")\n           |)\n           |").toString())).stripMargin();
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(sql, normalizedTags));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withFolderIds(Set<String> folderIds) {
        BoxedUnit boxedUnit;
        Set normalizedFolderIds = (Set)folderIds.map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getName((String)x$1), Set$.MODULE$.canBuildFrom());
        if (normalizedFolderIds.nonEmpty()) {
            this.joinFolders();
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(14).append("folders.").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append(" IN (").append(this.binding((Iterable<Object>)normalizedFolderIds)).append(")").toString(), (Iterable)normalizedFolderIds));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAssignedToMe(Iterable<String> principals) {
        BoxedUnit boxedUnit;
        if (principals.nonEmpty()) {
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(19).append("LOWER(tasks.").append(Schema.TASKS$.MODULE$.OWNER()).append(") IN (").append(this.binding(principals)).append(")").toString(), (Iterable)principals.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toLowerCase(), Iterable$.MODULE$.canBuildFrom())));
        } else {
            this.nothingToBeFound_$eq(true);
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAssignedToMeOrMyTeams(Iterable<String> principals, Iterable<String> roleIds) {
        this.joinTeams();
        if (principals.nonEmpty()) {
            this.joinTeamPrincipals();
        }
        if (roleIds.nonEmpty()) {
            this.joinTeamRoles();
        }
        this.conditions().$plus$eq((Object)new package.Sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(154).append("|(\n          |").append((Object)(principals.nonEmpty() ? new StringBuilder(19).append("LOWER(tasks.").append(Schema.TASKS$.MODULE$.OWNER()).append(") IN (").append(this.binding(principals)).append(")").toString() : "1 = 0")).append("\n          |OR (\n          | tasks.").append(Schema.TASKS$.MODULE$.TEAM()).append(" = teams.").append(SecuritySchema.ROLES$.MODULE$.name()).append("\n          | AND (\n          |   ").append((Object)(principals.nonEmpty() ? new StringBuilder(28).append("LOWER(teamPrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.principalName()).append(") IN (").append(this.binding(principals)).append(")").toString() : "1 = 0")).append("\n          |   ").append((Object)(roleIds.nonEmpty() ? new StringBuilder(19).append("OR teamRoles.").append(SecuritySchema.ROLE_ROLES$.MODULE$.memberRoleId()).append(" IN (").append(this.binding(roleIds)).append(")").toString() : "")).append("\n          | )\n          |)\n          |)\n       ").toString())).stripMargin(), (Iterable)((TraversableLike)((TraversableLike)principals.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toLowerCase(), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)principals.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toLowerCase(), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).$plus$plus(roleIds, Iterable$.MODULE$.canBuildFrom())));
        return this;
    }

    public TasksSqlBuilder withAssignedToAnybody(Iterable<String> principals, Iterable<String> roleIds, boolean isAdmin) {
        BoxedUnit boxedUnit;
        if (!isAdmin) {
            this.joinTeams();
            this.joinTeamPermissions();
            this.joinTeamPrincipals();
            if (roleIds.nonEmpty()) {
                this.joinTeamRoles();
            }
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(91).append("teamPermissions.").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.permissionName()).append(" = '").append(XLReleasePermissions.VIEW_RELEASE.getPermissionName()).append("'\n           |AND (\n           |  ").append((Object)(principals.nonEmpty() ? new StringBuilder(28).append("LOWER(teamPrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.principalName()).append(") IN (").append(this.binding(principals)).append(")").toString() : "1 = 0")).append("\n           |  ").append((Object)(roleIds.nonEmpty() ? new StringBuilder(19).append("OR teamRoles.").append(SecuritySchema.ROLE_ROLES$.MODULE$.memberRoleId()).append(" IN (").append(this.binding(roleIds)).append(")").toString() : "")).append("\n           |)\n       ").toString())).stripMargin(), (Iterable)((TraversableLike)principals.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toLowerCase(), Iterable$.MODULE$.canBuildFrom())).$plus$plus(roleIds, Iterable$.MODULE$.canBuildFrom())));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAnyFacets() {
        this.joinFacets();
        return this;
    }

    public TasksSqlBuilder orderByTaskId() {
        this.orderBy(new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.TASK_ID()).toString());
        return this;
    }

    private String binding(Iterable<Object> values) {
        return ((TraversableOnce)values.toSeq().map((Function1 & Serializable & scala.Serializable)x$8 -> "?", Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    private void joinTeams() {
        this.addJoin(new StringBuilder(33).append("JOIN ").append(SecuritySchema.ROLES$.MODULE$.TABLE()).append(" teams ON releases.").append(Schema.RELEASES$.MODULE$.SECURITY_UID()).append(" = teams.").append(SecuritySchema.ROLES$.MODULE$.ciId()).toString());
    }

    private void joinTeamRoles() {
        this.addJoin(new StringBuilder(43).append("LEFT JOIN ").append(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE()).append(" teamRoles ON teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = teamRoles.").append(SecuritySchema.ROLE_ROLES$.MODULE$.roleId()).toString());
    }

    private void joinTeamPrincipals() {
        this.addJoin(new StringBuilder(53).append("LEFT JOIN ").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE()).append(" teamPrincipals ON teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = teamPrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId()).toString());
    }

    private void joinTeamPermissions() {
        this.addJoin(new StringBuilder(50).append("JOIN ").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE()).append(" teamPermissions ON teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = teamPermissions.").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.roleId()).toString());
    }

    private void joinFolders() {
        this.addJoin(new StringBuilder(37).append("JOIN ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" folders ON releases.").append(Schema.RELEASES$.MODULE$.FOLDER_CI_UID()).append(" = folders.").append(Schema.FOLDERS$.MODULE$.CI_UID()).toString());
    }

    private void joinFacets() {
        this.addJoin(new StringBuilder(32).append("JOIN ").append(Schema.FACETS$.MODULE$.TABLE()).append(" facets ON tasks.").append(Schema.TASKS$.MODULE$.CI_UID()).append(" = facets.").append(Schema.FACETS$.MODULE$.APPLIED_TO_TASK_UID()).toString());
    }

    public TasksSqlBuilder newInstance() {
        return new TasksSqlBuilder(super.dialect());
    }

    public TasksSqlBuilder(SqlBuilder.Dialect dialect) {
        super(dialect);
    }
}

