/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.Diff$;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlReleaseRepositoryHelper;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\ree\u0001\u0002\u00192\u0001qB\u0001B\u0019\u0001\u0003\u0002\u0003\u0006Ia\u0019\u0005\tS\u0002\u0011)\u0019!C\tU\"Aa\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005p\u0001\t\u0015\r\u0011\"\u0005q\u0011!!\bA!A!\u0002\u0013\t\b\u0002C;\u0001\u0005\u000b\u0007I\u0011\u0003<\t\u0011i\u0004!\u0011!Q\u0001\n]D\u0001b\u001f\u0001\u0003\u0006\u0004%\t\u0002 \u0005\n\u0003\u0003\u0001!\u0011!Q\u0001\nuD!\"a\u0001\u0001\u0005\u000b\u0007I\u0011CA\u0003\u0011)\ti\u0001\u0001B\u0001B\u0003%\u0011q\u0001\u0005\u000b\u0003\u001f\u0001!Q1A\u0005\u0002\u0005E\u0001BCA\u0010\u0001\t\u0005\t\u0015!\u0003\u0002\u0014!Q\u0011\u0011\u0005\u0001\u0003\u0006\u0004%\t!a\t\t\u0015\u0005-\u0002A!A!\u0002\u0013\t)\u0003\u0003\u0006\u0002.\u0001\u0011\t\u0011)A\u0005\u0003_A!\"!\u000e\u0001\u0005\u000b\u0007I1AA\u001c\u0011)\t9\u0007\u0001B\u0001B\u0003%\u0011\u0011\b\u0005\b\u0003S\u0002A\u0011AA6\u0011\u001d\t)\t\u0001C!\u0003\u000fCq!a2\u0001\t\u0003\nI\rC\u0004\u0002b\u0002!\t%a9\t\u000f\u0005\u0005\b\u0001\"\u0011\u0002j\"9\u0011q \u0001\u0005B\t\u0005\u0001b\u0002B\u001e\u0001\u0011\u0005#Q\b\u0005\b\u0005\u000b\u0002A\u0011\u0001B$\u0011\u001d\u0011Y\u0007\u0001C!\u0005[BqAa \u0001\t\u0003\u0011\t\tC\u0004\u0003\u0010\u0002!\tE!%\t\u000f\t\u0015\u0006\u0001\"\u0011\u0003(\"9!Q\u0016\u0001\u0005\n\t=\u0006b\u0002B\\\u0001\u0011\u0005#\u0011\u0018\u0005\b\u0005\u0003\u0004A\u0011\tBb\u0011\u001d\u0011y\r\u0001C!\u0005#DqAa6\u0001\t\u0003\u0012I\u000eC\u0004\u0003d\u0002!\tE!:\t\u000f\t=\b\u0001\"\u0011\u0003r\"9!q \u0001\u0005B\r\u0005\u0001bBB\u0005\u0001\u0011\u000531\u0002\u0005\b\u0007'\u0001A\u0011IB\u000b\u0011\u001d\u0019\u0019\u0002\u0001C!\u00077Aqaa\n\u0001\t\u0003\u001aI\u0003C\u0004\u00042\u0001!\tea\r\t\u000f\r\r\u0003\u0001\"\u0003\u0004F!91Q\r\u0001\u0005\n\r\u001d\u0004bBB7\u0001\u0011\u00053q\u000e\u0005\b\u0007\u0013\u0003A\u0011IBF\u0005Q\u0019\u0016\u000f\u001c*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss*\u0011!gM\u0001\u0004gFd'B\u0001\u001b6\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003m]\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005aJ\u0014!\u0003=fE&\fG.\u00192t\u0015\u0005Q\u0014aA2p[\u000e\u00011\u0003\u0003\u0001>\u0007\u001e\u000b\u0016\fX0\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\r\u0005s\u0017PU3g!\t!U)D\u00014\u0013\t15GA\tSK2,\u0017m]3SKB|7/\u001b;pef\u00042\u0001S%L\u001b\u0005\t\u0014B\u0001&2\u0005UIe\u000e^3sG\u0016\u0004H/\u001a3SKB|7/\u001b;pef\u0004\"\u0001T(\u000e\u00035S!AT\u001b\u0002\r\u0011|W.Y5o\u0013\t\u0001VJA\u0004SK2,\u0017m]3\u0011\u0005I;V\"A*\u000b\u0005Q+\u0016!B:mMRR'\"\u0001,\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!\u0001W*\u0003\u000f1{wmZ5oOB\u0011\u0001JW\u0005\u00037F\u0012a\u0003R3tKJL\u0017\r\\5{CRLwN\\*vaB|'\u000f\u001e\t\u0003\u0011vK!AX\u0019\u0003=\r{gNZ5hkJ\fG/[8o%\u00164WM]3oG\u0016\u001c8+\u001e9q_J$\bC\u0001%a\u0013\t\t\u0017G\u0001\u000eTc2\u0014V\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f%fYB,'/\u0001\nsK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007C\u00013h\u001b\u0005)'B\u000142\u0003-\u0001XM]:jgR,gnY3\n\u0005!,'A\u0005*fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016\fq\u0002^1tWB+'o]5ti\u0016t7-Z\u000b\u0002WB\u0011A\r\\\u0005\u0003[\u0016\u0014q\u0002V1tWB+'o]5ti\u0016t7-Z\u0001\u0011i\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dK\u0002\nQ\u0003Z3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW-F\u0001r!\t!'/\u0003\u0002tK\n)B)\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0017A\u00063fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-\u001a\u0011\u0002%\r|W.\\3oiB+'o]5ti\u0016t7-Z\u000b\u0002oB\u0011A\r_\u0005\u0003s\u0016\u0014!cQ8n[\u0016tG\u000fU3sg&\u001cH/\u001a8dK\u0006\u00192m\\7nK:$\b+\u001a:tSN$XM\\2fA\u0005qA/Z1n%\u0016\u0004xn]5u_JLX#A?\u0011\u0005\u0011s\u0018BA@4\u00059!V-Y7SKB|7/\u001b;pef\fq\u0002^3b[J+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u001ce\u0016dW-Y:f\u000bb$XM\\:j_:\u001c(+\u001a9pg&$xN]=\u0016\u0005\u0005\u001d\u0001c\u0001#\u0002\n%\u0019\u00111B\u001a\u00037I+G.Z1tK\u0016CH/\u001a8tS>t7OU3q_NLGo\u001c:z\u0003q\u0011X\r\\3bg\u0016,\u0005\u0010^3og&|gn\u001d*fa>\u001c\u0018\u000e^8ss\u0002\n\u0001dY8oM&<WO]1uS>t\u0007+\u001a:tSN$XM\\2f+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tI\"Z\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\t\u0005u\u0011q\u0003\u0002\"\u0007>tg-[4ve\u0006$\u0018n\u001c8SK\u001a,'/\u001a8dKB+'o]5ti\u0016t7-Z\u0001\u001aG>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\tsKB|7/\u001b;pef\fE-\u00199uKJ,\"!!\n\u0011\u0007!\u000b9#C\u0002\u0002*E\u0012AcU9m%\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\u0018A\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0002\n\u0011DZ1dKR\u0014V\r]8tSR|'/\u001f#jgB\fGo\u00195feB\u0019A)!\r\n\u0007\u0005M2GA\rGC\u000e,GOU3q_NLGo\u001c:z\t&\u001c\b/\u0019;dQ\u0016\u0014\u0018AC:rY\u0012K\u0017\r\\3diV\u0011\u0011\u0011\b\t\u0005\u0003w\t\tG\u0004\u0003\u0002>\u0005mc\u0002BA \u0003/rA!!\u0011\u0002T9!\u00111IA)\u001d\u0011\t)%a\u0014\u000f\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u0013<\u0003\u0019a$o\\8u}%\t!(\u0003\u00029s%\u0011agN\u0005\u0004\u0003+*\u0014A\u00013c\u0013\r\u0011\u0014\u0011\f\u0006\u0004\u0003+*\u0014\u0002BA/\u0003?\n!bU9m\u0005VLG\u000eZ3s\u0015\r\u0011\u0014\u0011L\u0005\u0005\u0003G\n)GA\u0004ES\u0006dWm\u0019;\u000b\t\u0005u\u0013qL\u0001\fgFdG)[1mK\u000e$\b%\u0001\u0004=S:LGO\u0010\u000b\u0015\u0003[\n\u0019(!\u001e\u0002x\u0005e\u00141PA?\u0003\u007f\n\t)a!\u0015\t\u0005=\u0014\u0011\u000f\t\u0003\u0011\u0002Aq!!\u000e\u0014\u0001\b\tI\u0004C\u0003c'\u0001\u00071\rC\u0003j'\u0001\u00071\u000eC\u0003p'\u0001\u0007\u0011\u000fC\u0003v'\u0001\u0007q\u000fC\u0003|'\u0001\u0007Q\u0010C\u0004\u0002\u0004M\u0001\r!a\u0002\t\u000f\u0005=1\u00031\u0001\u0002\u0014!9\u0011\u0011E\nA\u0002\u0005\u0015\u0002bBA\u0017'\u0001\u0007\u0011qF\u0001\u0007KbL7\u000f^:\u0015\t\u0005%\u0015q\u0012\t\u0004}\u0005-\u0015bAAG\u007f\t9!i\\8mK\u0006t\u0007bBAI)\u0001\u0007\u00111S\u0001\u0003S\u0012\u0004B!!&\u0002\u001e:!\u0011qSAM!\r\t9eP\u0005\u0004\u00037{\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002 \u0006\u0005&AB*ue&twMC\u0002\u0002\u001c~B3\u0001FAS!\u0011\t9+!,\u000e\u0005\u0005%&\u0002BAV\u0003?\n1\u0002\u001e:b]N\f7\r^5p]&!\u0011qVAU\u0005)I5OU3bI>sG.\u001f\u0015\u0004)\u0005M\u0006\u0003BA[\u0003\u0007l!!a.\u000b\t\u0005e\u00161X\u0001\u000bC:tw\u000e^1uS>t'\u0002BA_\u0003\u007f\u000bq!\\3ue&\u001c7OC\u0002\u0002Bf\n\u0001bY8eC\"\fG.Z\u0005\u0005\u0003\u000b\f9LA\u0003US6,G-\u0001\u0004de\u0016\fG/\u001a\u000b\u0006\u0017\u0006-\u0017q\u001a\u0005\u0007\u0003\u001b,\u0002\u0019A&\u0002\u000fI,G.Z1tK\"9\u0011\u0011[\u000bA\u0002\u0005M\u0017!\u0006:fY\u0016\f7/Z\"sK\u0006$\u0018n\u001c8T_V\u00148-\u001a\t\u0005\u0003+\fY.\u0004\u0002\u0002X*\u0019\u0011\u0011\\'\u0002\r\u00154XM\u001c;t\u0013\u0011\ti.a6\u0003+I+G.Z1tK\u000e\u0013X-\u0019;j_:\u001cv.\u001e:dK\"\u001aQ#a-\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$2aSAs\u0011\u001d\t\tJ\u0006a\u0001\u0003'C3AFAZ)\u0015Y\u00151^Aw\u0011\u001d\t\tj\u0006a\u0001\u0003'Cq!a<\u0018\u0001\u0004\t\t0\u0001\bsKN|GN^3PaRLwN\\:\u0011\t\u0005M\u0018\u0011`\u0007\u0003\u0003kT1!a>4\u0003\u0015\tX/\u001a:z\u0013\u0011\tY0!>\u0003\u001dI+7o\u001c7wK>\u0003H/[8og\"\u001aq#a-\u0002\u001f\u0019Lg\u000eZ%eg\nK8\u000b^1ukN$BAa\u0001\u0003\u0016A1!Q\u0001B\b\u0003'sAAa\u0002\u0003\f9!\u0011q\tB\u0005\u0013\u0005\u0001\u0015b\u0001B\u0007\u007f\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\t\u0005'\u00111aU3r\u0015\r\u0011ia\u0010\u0005\b\u0005/A\u0002\u0019\u0001B\r\u0003!\u0019H/\u0019;vg\u0016\u001c\b#\u0002 \u0003\u001c\t}\u0011b\u0001B\u000f\u007f\tQAH]3qK\u0006$X\r\u001a \u0011\t\t\u0005\"qE\u0007\u0003\u0005GQ1A!\nN\u0003\u0019\u0019H/\u0019;vg&!!\u0011\u0006B\u0012\u00055\u0011V\r\\3bg\u0016\u001cF/\u0019;vg\"\u001a\u0001$!*)\u0007a\t\u0019\fK\u0002\u0019\u0005c\u0001BAa\r\u000385\u0011!Q\u0007\u0006\u0004\u0003s{\u0014\u0002\u0002B\u001d\u0005k\u0011qA^1sCJ<7/A\ngS:$')_\"bY\u0016tG-\u0019:U_.,g\u000eF\u0002L\u0005\u007fAqA!\u0011\u001a\u0001\u0004\t\u0019*A\u0007dC2,g\u000eZ1s)>\\WM\u001c\u0015\u00043\u0005M\u0016\u0001\u00074j]\u0012\f%o\u00195jm\u0006\u0014G.\u001a*fY\u0016\f7/Z%egR1!1\u0001B%\u0005;BqAa\u0013\u001b\u0001\u0004\u0011i%\u0001\u0003eCR,\u0007\u0003\u0002B(\u00053j!A!\u0015\u000b\t\tM#QK\u0001\u0005kRLGN\u0003\u0002\u0003X\u0005!!.\u0019<b\u0013\u0011\u0011YF!\u0015\u0003\t\u0011\u000bG/\u001a\u0005\b\u0005?R\u0002\u0019\u0001B1\u0003!\u0001\u0018mZ3TSj,\u0007c\u0001 \u0003d%\u0019!QM \u0003\u0007%sG\u000fK\u0002\u001b\u0003KC3AGAZ\u00039\u0019X\r\u001e)sK\u0006\u00138\r[5wK\u0012$bAa\u001c\u0003v\te\u0004c\u0001 \u0003r%\u0019!1O \u0003\tUs\u0017\u000e\u001e\u0005\b\u0005oZ\u0002\u0019AAJ\u0003%\u0011X\r\\3bg\u0016LE\rC\u0004\u0003|m\u0001\r!!#\u0002\u0017A\u0014X-\u0011:dQ&4X\r\u001a\u0015\u00047\u0005M\u0016!\u00074j]\u0012\u0004&/Z!sG\"Lg/\u00192mKJ+G.Z1tKN$bAa!\u0003\u0006\n%\u0005#\u0002B\u0003\u0005\u001fY\u0005b\u0002BD9\u0001\u0007!\u0011M\u0001\u0005a\u0006<W\rC\u0004\u0003`q\u0001\rA!\u0019)\u0007q\t)\u000bK\u0002\u001d\u0003g\u000baa]3be\u000eDG\u0003\u0002BJ\u00053\u0003RAa\u0014\u0003\u0016.KAAa&\u0003R\t!A*[:u\u0011\u001d\u0011Y*\ba\u0001\u0005;\u000bAb]3be\u000eD\u0007+\u0019:b[N\u00042\u0001\u0012BP\u0013\r\u0011\tk\r\u0002\u0016%\u0016dW-Y:f'\u0016\f'o\u00195CsB\u000b'/Y7tQ\ri\u00121W\u0001\u0007I\u0016dW\r^3\u0015\t\t=$\u0011\u0016\u0005\b\u0003#s\u0002\u0019AAJQ\rq\u00121W\u0001\u0018I\u0016dW\r^3SK2,\u0017m]3SK\u001a,'/\u001a8dKN$bAa\u001c\u00032\nM\u0006bBAI?\u0001\u0007\u00111\u0013\u0005\b\u0005k{\u0002\u0019\u0001B1\u0003)\u0011X\r\\3bg\u0016,\u0016\u000eZ\u0001\u000eI\u0016dW\r^3XSRDW+\u001b3\u0015\r\t=$1\u0018B_\u0011\u001d\t\t\n\ta\u0001\u0003'CqA!.!\u0001\u0004\u0011\t\u0007K\u0002!\u0003g\u000bA!\\8wKR1!q\u000eBc\u0005\u0013DqAa2\"\u0001\u0004\t\u0019*\u0001\u0006pe&<\u0017N\\1m\u0013\u0012DqAa3\"\u0001\u0004\t\u0019*A\u0003oK^LE\rK\u0002\"\u0003g\u000b\u0011bZ3u'R\fG/^:\u0015\t\t}!1\u001b\u0005\b\u0003#\u0013\u0003\u0019AAJQ\r\u0011\u00131W\u0001\fO\u0016$8\u000b^1ukN,7\u000f\u0006\u0003\u0003\\\nu\u0007C\u0002B\u0003\u0005\u001f\u0011y\u0002C\u0004\u0003`\u000e\u0002\rAa\u0001\u0002\u0007%$7\u000fK\u0002$\u0003g\u000bQbZ3u%&\u001c8nU2pe\u0016\u001cH\u0003\u0002Bt\u0005S\u0004bA!\u0002\u0003\u0010\t\u0005\u0004b\u0002BpI\u0001\u0007!1\u0001\u0015\u0004I\u0005\u0015\u0006f\u0001\u0013\u00024\u0006i1/\u001a;SSN\\7kY8sKN$\u0002Ba\u001c\u0003t\nU(\u0011 \u0005\b\u0005o*\u0003\u0019AAJ\u0011\u001d\u001190\na\u0001\u0005C\nQa]2pe\u0016DqAa?&\u0001\u0004\u0011\t'\u0001\u0006u_R\fGnU2pe\u0016D3!JAZ\u0003)I7\u000fV3na2\fG/\u001a\u000b\u0005\u0003\u0013\u001b\u0019\u0001C\u0004\u0003x\u0019\u0002\r!a%)\u0007\u0019\n)\u000bK\u0002'\u0003g\u000b\u0001bZ3u)&$H.\u001a\u000b\u0005\u0003'\u001bi\u0001C\u0004\u0002\u0012\u001e\u0002\r!a%)\u0007\u001d\n)\u000bK\u0002(\u0003g\u000ba!\u001e9eCR,GcA&\u0004\u0018!1\u0011Q\u001a\u0015A\u0002-C3\u0001KAZ)\u0015Y5QDB\u0011\u0011\u0019\u0019y\"\u000ba\u0001\u0017\u0006AqN]5hS:\fG\u000e\u0003\u0004\u0004$%\u0002\raS\u0001\bkB$\u0017\r^3eQ\rI\u00131W\u0001\be\u0016\u0004H.Y2f)\u0015Y51FB\u0017\u0011\u0019\u0019yB\u000ba\u0001\u0017\"111\u0005\u0016A\u0002-C3AKAZ\u0003)9W\r^!mYR\u000bwm\u001d\u000b\u0005\u0007k\u0019Y\u0004\u0005\u0004\u0003P\r]\u00121S\u0005\u0005\u0007s\u0011\tFA\u0002TKRDqa!\u0010,\u0001\u0004\u0011\t'A\u0006mS6LGOT;nE\u0016\u0014\bfA\u0016\u0002&\"\u001a1&a-\u0002\u0015\u001d,GOU3mK\u0006\u001cX\rF\u0003L\u0007\u000f\u001a\u0019\u0007C\u0004\u0003x1\u0002\ra!\u0013\u0011\t\r-3Q\f\b\u0005\u0007\u001b\u001aIF\u0004\u0003\u0004P\r]c\u0002BB)\u0007+rA!!\u0011\u0004T%\u0011A'N\u0005\u0003eMJ!AZ\u0019\n\u0007\rmS-\u0001\u0003DS&#\u0017\u0002BB0\u0007C\u0012AaQ5JI*\u001911L3\t\u000f\u0005=H\u00061\u0001\u0002r\u0006\u00113\r[3dW&\u001bhj\u001c;SK\u001a,'/\u001a8dK\u0012\u0014\u0015\u0010R3qK:$WM\\2jKN$BAa\u001c\u0004j!911N\u0017A\u0002\r%\u0013a\u00069mC:LE/Z7JI>\u0013\u0018\n^:DQ&dGM]3o\u0003=1\u0017N\u001c3T\u00076#\u0015\r^1Cs&#G\u0003BB9\u0007\u0007\u0003RAPB:\u0007oJ1a!\u001e@\u0005\u0019y\u0005\u000f^5p]B!1\u0011PB@\u001b\t\u0019YH\u0003\u0003\u0004~\tU\u0013\u0001\u00027b]\u001eLAa!!\u0004|\t9\u0011J\u001c;fO\u0016\u0014\bbBAI]\u0001\u0007\u00111\u0013\u0015\u0004]\u0005\u0015\u0006f\u0001\u0018\u00024\u0006)b-\u001b8e\u001fZ,'\u000fZ;f%\u0016dW-Y:f\u0013\u0012\u001cHC\u0001B\u0002Q\ry\u0013Q\u0015\u0015\u0004_\u0005M\u0006f\u0001\u0001\u0004\u0014B!\u0011qUBK\u0013\u0011\u00199*!+\u0003\u001f%\u001bHK]1og\u0006\u001cG/[8oC2\u0004")
public class SqlReleaseRepository
implements ReleaseRepository,
InterceptedRepository<Release>,
Logging,
DeserializationSupport,
ConfigurationReferencesSupport,
SqlReleaseRepositoryHelper {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final DependencyPersistence dependencyPersistence;
    private final CommentPersistence commentPersistence;
    private final TeamRepository teamRepository;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect sqlDialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private Seq<PersistenceInterceptor<Release>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void replaceTasks(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceTasks$(this, original, updated);
    }

    @Override
    public void replaceReleaseExtensions(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseExtensions$(this, original, updated);
    }

    @Override
    public void replaceReleaseTeams(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseTeams$(this, original, updated);
    }

    @Override
    public void updateCommentsOnTasks(Task originalTask, Task updatedTask) {
        SqlReleaseRepositoryHelper.updateCommentsOnTasks$(this, originalTask, updatedTask);
    }

    @Override
    public void insertDependency(Integer gateTaskUid, Dependency dependency) {
        SqlReleaseRepositoryHelper.insertDependency$(this, gateTaskUid, dependency);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Release> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseRepository sqlReleaseRepository = this;
        synchronized (sqlReleaseRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Seq<PersistenceInterceptor<Release>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(Seq<PersistenceInterceptor<Release>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public Seq<String> findIdsByStatus(ReleaseStatus ... statuses) {
        return this.findIdsByStatus((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses));
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public CommentPersistence commentPersistence() {
        return this.commentPersistence;
    }

    public TeamRepository teamRepository() {
        return this.teamRepository;
    }

    public ReleaseExtensionsRepository releaseExtensionsRepository() {
        return this.releaseExtensionsRepository;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String id) {
        return this.releasePersistence.existsRelease(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id)));
    }

    @Timed
    public Release create(Release release, ReleaseCreationSource releaseCreationSource) {
        if (this.releasePersistence.existsRelease(release.getId())) {
            throw new ItemAlreadyExistsException("A release with ID [%s] already exists", new Object[]{release.getId()});
        }
        this.interceptCreate((ConfigurationItem)release);
        this.releasePersistence.insert(release);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            SqlReleaseRepository.$anonfun$create$1(this, release, task);
            return BoxedUnit.UNIT;
        });
        release.getExtensions().forEach(extension -> this.releaseExtensionsRepository().create(extension));
        this.updateConfigurationRefs((CiWithUid)release);
        this.facetRepositoryDispatcher.liveRepository().createFromTasks((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala(), this.facetRepositoryDispatcher.liveRepository().createFromTasks$default$2());
        return release;
    }

    @Timed
    public Release findById(String id) {
        return this.getRelease(id, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public Release findById(String id, ResolveOptions resolveOptions) {
        return this.getRelease(id, resolveOptions);
    }

    @Timed
    @IsReadOnly
    public Seq<String> findIdsByStatus(Seq<ReleaseStatus> statuses) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses(statuses).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    @Timed
    public Release findByCalendarToken(String calendarToken) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withCalendarToken(calendarToken).build();
        Seq<ReleaseRow> releases = this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
        return (Release)releases.headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> this.deserializeRelease((ReleaseRow)x$1, new ResolveOptionsBuilder().withEverything().build())).orNull(Predef$.MODULE$.$conforms());
    }

    @Timed
    @IsReadOnly
    public Seq<String> findArchivableReleaseIds(Date date, int pageSize) {
        ReleasesSqlBuilder qual$1 = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)new .colon.colon((Object)ReleaseStatus.COMPLETED, (List)new .colon.colon((Object)ReleaseStatus.ABORTED, (List)Nil$.MODULE$)))).withEndDateBefore(date).withPage(new Page(0L, (long)pageSize, Predef$.MODULE$.int2Integer(0)));
        boolean x$1 = qual$1.withPreArchived$default$1();
        Tuple2 sqlWithParams = qual$1.withPreArchived(x$1).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    @Timed
    public void setPreArchived(String releaseId, boolean preArchived) {
        this.releasePersistence.setPreArchived(releaseId, preArchived);
    }

    @Timed
    @IsReadOnly
    public Seq<Release> findPreArchivableReleases(int page, int pageSize) {
        Seq inactive = (Seq)new .colon.colon((Object)ReleaseStatus.COMPLETED, (List)new .colon.colon((Object)ReleaseStatus.ABORTED, (List)Nil$.MODULE$));
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withOneOfStatuses((Seq<ReleaseStatus>)inactive).withPreArchived(false).limitAndOffset(pageSize, page * pageSize).build();
        return (Seq)((TraversableLike)((TraversableLike)((TraversableLike)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)x$2, new ResolveOptionsBuilder().withEverything().build())), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isTutorial()))).map((Function1 & Serializable & scala.Serializable)release -> this.releaseExtensionsRepository().decorate(release), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.commentPersistence().decorate((Release)release), Seq$.MODULE$.canBuildFrom());
    }

    @Timed
    public java.util.List<Release> search(ReleaseSearchByParams searchParams) {
        ReleaseSearchByParams releaseSearchByParams = searchParams;
        if (releaseSearchByParams == null) {
            throw new MatchError((Object)releaseSearchByParams);
        }
        Page page = releaseSearchByParams.page();
        Either folderId2 = releaseSearchByParams.folderId();
        ReleaseStatus[] statuses = releaseSearchByParams.statuses();
        String title = releaseSearchByParams.title();
        String rootReleaseId = releaseSearchByParams.rootReleaseId();
        boolean autoStart = releaseSearchByParams.autoStart();
        ReleasesSqlBuilder base = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withTitle(title).withRootReleaseId(rootReleaseId).withPage(page);
        ReleasesSqlBuilder sqlBuilder = folderId2 == null ? base : (ReleasesSqlBuilder)folderId2.fold((Function1 & Serializable & scala.Serializable)folderId -> base.withFolder((String)folderId), (Function1 & Serializable & scala.Serializable)ancestorId -> base.withAncestor((String)ancestorId));
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).nonEmpty() ? sqlBuilder.withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses)) : BoxedUnit.UNIT;
        Object object2 = autoStart ? sqlBuilder.withAutoStart() : BoxedUnit.UNIT;
        java.util.List list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlBuilder.build()).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)x$4, new ResolveOptionsBuilder().withEverything().build())), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.releaseExtensionsRepository().decorate(release), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.commentPersistence().decorate((Release)release), Seq$.MODULE$.canBuildFrom())).asJava();
        return list;
    }

    @Timed
    public void delete(String id) {
        this.checkIsNotReferencedByDependencies(id);
        this.releasePersistence.findUidByReleaseId(id).foreach((Function1 & Serializable & scala.Serializable)uid -> {
            this.deleteReleaseReferences(id, uid);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence.deleteById(id);
    }

    private void deleteReleaseReferences(String id, int releaseUid) {
        this.dependencyPersistence().deleteByReleaseUid(Predef$.MODULE$.int2Integer(releaseUid));
        this.commentPersistence().deleteByRelease(Predef$.MODULE$.int2Integer(releaseUid));
        this.taskPersistence().deleteTasksByReleaseUid(releaseUid);
        this.teamRepository().deleteTeamsFromPlatform(new SecuredCi(id, releaseUid));
        this.releaseExtensionsRepository().deleteAll(id);
        this.deleteConfigurationRefs(Predef$.MODULE$.int2Integer(releaseUid));
        this.interceptDelete(id);
    }

    @Timed
    public void deleteWithUid(String id, int releaseUid) {
        this.deleteReleaseReferences(id, releaseUid);
        this.releasePersistence.deleteById(id);
    }

    @Timed
    public void move(String originalId, String newId) {
        this.releasePersistence.move(originalId, newId);
    }

    @Timed
    public ReleaseStatus getStatus(String id) {
        String status = (String)this.releasePersistence.findReleaseStatus(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).orNull(Predef$.MODULE$.$conforms());
        return status == null ? null : ReleaseStatus.valueOf((String)status.toUpperCase());
    }

    @Timed
    public Seq<ReleaseStatus> getStatuses(Seq<String> ids) {
        return ids.isEmpty() ? (Seq)Nil$.MODULE$ : (Seq)this.releasePersistence.findReleaseStatuses(ids).map((Function1 & Serializable & scala.Serializable)status -> ReleaseStatus.valueOf((String)status.toUpperCase()), Seq$.MODULE$.canBuildFrom());
    }

    @Timed
    @IsReadOnly
    public Seq<Object> getRiskScores(Seq<String> ids) {
        return this.releasePersistence.findReleaseRiskScores(ids);
    }

    @Timed
    public void setRiskScores(String releaseId, int score, int totalScore) {
        this.releasePersistence.updateReleaseRiskScores(releaseId, score, totalScore);
    }

    @Timed
    @IsReadOnly
    public boolean isTemplate(String releaseId) {
        return ReleaseStatus.TEMPLATE.equals(this.getStatus(releaseId));
    }

    @Timed
    @IsReadOnly
    public String getTitle(String id) {
        return (String)this.releasePersistence.findReleaseTitle(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException("Release [%s] not found", new Object[]{id});
        });
    }

    @Timed
    public Release update(Release release) {
        return this.update(null, release);
    }

    @Timed
    public Release update(Release original, Release updated) {
        Option originalReleaseOpt = Option$.MODULE$.apply((Object)original);
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        originalReleaseOpt.foreach((Function1 & Serializable & scala.Serializable)rel -> {
            SqlReleaseRepository.$anonfun$update$1(this, updated, rel);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    public Release replace(Release original, Release updated) {
        if (Ids.isFolderId((String)original.getId())) {
            updated.setTeams(Collections.emptyList());
        }
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            this.replaceTasks(original, updated);
            this.replaceReleaseExtensions(original, updated);
            this.replaceReleaseTeams(original, updated);
        }
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.releasePersistence.findAllTags(limitNumber)).asJava();
    }

    /*
     * WARNING - void declaration
     */
    private Release getRelease(String releaseId, ResolveOptions resolveOptions) {
        void var3_3;
        BoxedUnit boxedUnit;
        Release release = (Release)this.repositoryAdapter().read(releaseId, resolveOptions);
        if (release == null) {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        }
        if (resolveOptions.hasDecorators()) {
            this.releaseExtensionsRepository().decorate(release);
            boxedUnit = this.commentPersistence().decorate(release);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    private void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        Seq externalIncomingDependencies = (Seq)((TraversableLike)this.dependencyPersistence().findByPartialTargetIds((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{planItemIdOrItsChildren}))), (Option<scala.collection.immutable.Set<String>>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$6 -> DependencyRow$.MODULE$.DependencyRowOps((DependencyRow)x$6).fullDependencyId(), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(planItemIdOrItsChildren)))));
        if (externalIncomingDependencies.nonEmpty()) {
            throw new ItemInUseException(new StringBuilder(96).append("Cannot delete [").append(planItemIdOrItsChildren).append("] because it or one of its children is referenced by ").append("one or more dependencies: [").append(externalIncomingDependencies.mkString(", ")).append("]").toString(), new Object[0]);
        }
    }

    @Timed
    @IsReadOnly
    public Option<Integer> findSCMDataById(String id) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Finding scm data for template or release with id ").append(id).toString());
        return this.releasePersistence.findSCMDataById(id).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1));
    }

    @Timed
    @IsReadOnly
    public Seq<String> findOverdueReleaseIds() {
        return this.releasePersistence.findOverdueReleaseIds();
    }

    public static final /* synthetic */ boolean $anonfun$create$2(SqlReleaseRepository $this, Integer taskUid$1, Comment comment) {
        return $this.commentPersistence().create(taskUid$1, CommentPersistence$CommentRow$.MODULE$.fromComment(comment));
    }

    public static final /* synthetic */ void $anonfun$create$1(SqlReleaseRepository $this, Release release$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(release$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)comment -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$create$2($this, taskUid, comment)));
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$3(SqlReleaseRepository $this, Integer taskUid$2, Comment c) {
        return $this.commentPersistence().create(taskUid$2, CommentPersistence$CommentRow$.MODULE$.fromComment(c));
    }

    public static final /* synthetic */ void $anonfun$update$2(SqlReleaseRepository $this, Release updated$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(updated$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$3($this, taskUid, c)));
        ((IterableLike)syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isArchived()))).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$update$1(SqlReleaseRepository $this, Release updated$1, Release rel) {
        Diff$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getAllTasks()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(updated$1.getAllTasks()).asScala()).newValues().foreach((Function1 & Serializable & scala.Serializable)task -> {
            SqlReleaseRepository.$anonfun$update$2($this, updated$1, task);
            return BoxedUnit.UNIT;
        });
    }

    public SqlReleaseRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, DependencyPersistence dependencyPersistence, CommentPersistence commentPersistence, TeamRepository teamRepository, ReleaseExtensionsRepository releaseExtensionsRepository, ConfigurationReferencePersistence configurationPersistence, SqlRepositoryAdapter repositoryAdapter, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect sqlDialect) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.commentPersistence = commentPersistence;
        this.teamRepository = teamRepository;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.configurationPersistence = configurationPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.sqlDialect = sqlDialect;
        InterceptedRepository.$init$((InterceptedRepository)this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        SqlReleaseRepositoryHelper.$init$(this);
    }
}

