/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.vfs.dropbox;

import com.dropbox.core.DbxClient;
import com.dropbox.core.DbxEntry;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxWriteMode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.local.LocalFileName;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;
import org.rzo.vfs.dropbox.DropboxClient;
import org.rzo.vfs.dropbox.DropboxFileProvider;
import org.rzo.vfs.dropbox.auth.TokenData;

class DropboxClientWrapper
implements DropboxClient {
    private final LocalFileName root;
    private final FileSystemOptions fileSystemOptions;
    private DbxClient dbxClient;

    DropboxClientWrapper(LocalFileName root, FileSystemOptions fileSystemOptions) throws FileSystemException {
        this.root = root;
        this.fileSystemOptions = fileSystemOptions;
        this.getDbxClient();
    }

    public LocalFileName getRoot() {
        return this.root;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    private DbxClient createClient() throws FileSystemException {
        DbxClient client;
        char[] token;
        UserAuthenticationData authData;
        block3: {
            LocalFileName rootName = this.getRoot();
            authData = null;
            try {
                authData = UserAuthenticatorUtils.authenticate((FileSystemOptions)this.fileSystemOptions, (UserAuthenticationData.Type[])DropboxFileProvider.AUTHENTICATOR_TYPES);
                token = UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)TokenData.TOKEN, null);
                if (token != null) break block3;
            }
            catch (Throwable throwable) {
                UserAuthenticatorUtils.cleanup(authData);
                throw throwable;
            }
            UserAuthenticatorUtils.cleanup((UserAuthenticationData)authData);
            return null;
        }
        DbxRequestConfig config = new DbxRequestConfig("vfs-dbx/00.01", Locale.getDefault().toString());
        DbxClient dbxClient = client = new DbxClient(config, new String(token));
        UserAuthenticatorUtils.cleanup((UserAuthenticationData)authData);
        return dbxClient;
    }

    private DbxClient getDbxClient() throws FileSystemException {
        if (this.dbxClient == null) {
            this.dbxClient = this.createClient();
        }
        return this.dbxClient;
    }

    @Override
    public boolean isConnected() throws FileSystemException {
        try {
            return this.dbxClient != null;
        }
        catch (Exception e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    @Override
    public void disconnect() throws IOException {
        this.dbxClient = null;
    }

    @Override
    public DbxEntry[] listFiles(String relPath) throws IOException {
        try {
            DbxEntry[] files = this.listFilesInDirectory(relPath);
            return files;
        }
        catch (IOException e) {
            this.disconnect();
            DbxEntry[] files = this.listFilesInDirectory(relPath);
            return files;
        }
    }

    private DbxEntry[] listFilesInDirectory(String relPath) throws IOException {
        DbxEntry.WithChildren listing;
        DbxEntry[] files = null;
        try {
            listing = this.getDbxClient().getMetadataWithChildren(relPath);
        }
        catch (DbxException e) {
            throw new IOException(e);
        }
        if (listing != null) {
            files = listing.children.toArray(new DbxEntry[listing.children.size()]);
        }
        return files;
    }

    @Override
    public boolean removeDirectory(String relPath) throws IOException {
        try {
            this.getDbxClient().delete(this.absolutePath(relPath));
            return true;
        }
        catch (DbxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean deleteFile(String relPath) throws IOException {
        try {
            this.getDbxClient().delete(relPath);
            return true;
        }
        catch (DbxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean rename(String oldName, String newName) throws IOException {
        try {
            return this.getDbxClient().move(oldName, newName) != null;
        }
        catch (DbxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean makeDirectory(String relPath) throws IOException {
        try {
            return this.getDbxClient().createFolder(relPath) != null;
        }
        catch (DbxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public InputStream retrieveFileStream(String relPath) throws IOException {
        try {
            return this.getDbxClient().startGetFile((String)relPath, null).body;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public OutputStream storeFileStream(String relPath) throws IOException {
        try {
            return new DropboxOutputStream(this.getDbxClient().startUploadFile(relPath, DbxWriteMode.force(), -1L));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean abort() throws IOException {
        try {
            this.disconnect();
            return true;
        }
        catch (IOException e) {
            this.disconnect();
            return true;
        }
    }

    private String absolutePath(String relatPath) {
        return String.valueOf(this.root.getPath()) + relatPath;
    }

    @Override
    public long getLastModifiedTime(String path) throws IOException {
        DbxEntry entry;
        try {
            entry = this.getDbxClient().getMetadata(this.absolutePath(path));
        }
        catch (DbxException e) {
            throw new IOException(e);
        }
        if (entry.isFile()) {
            return entry.asFile().lastModified.getTime();
        }
        if (entry.asFolder().lastModified != null) {
            return entry.asFolder().lastModified.getTime();
        }
        return 0L;
    }

    @Override
    public long getContentSize(String path) throws IOException {
        DbxEntry entry;
        try {
            entry = this.getDbxClient().getMetadata(this.absolutePath(path));
        }
        catch (DbxException e) {
            throw new IOException(e);
        }
        if (entry.isFile()) {
            return entry.asFile().numBytes;
        }
        return entry.asFolder().numBytes;
    }

    public class DropboxOutputStream
    extends OutputStream {
        DbxClient.Uploader _uploader;
        OutputStream _out;

        DropboxOutputStream(DbxClient.Uploader uploader) {
            this._uploader = uploader;
            this._out = this._uploader.getBody();
        }

        @Override
        public void write(int b) throws IOException {
            this._out.write(b);
        }

        @Override
        public void close() throws IOException {
            try {
                this._uploader.finish();
            }
            catch (DbxException e) {
                throw new IOException(e);
            }
            this._uploader.close();
        }
    }
}

