/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

public class SVNVersion
implements Comparable<SVNVersion> {
    private final int major;
    private final int minor;
    private final int micro;
    private final String build;

    public static SVNVersion parse(String versionString) {
        if (versionString == null) {
            return null;
        }
        try {
            String[] fields = versionString.split("\\.");
            if (fields.length == 1) {
                int major = Integer.parseInt(fields[0]);
                return new SVNVersion(major, -1, -1, null);
            }
            if (fields.length == 2) {
                int major = Integer.parseInt(fields[0]);
                int minor = Integer.parseInt(fields[1]);
                return new SVNVersion(major, minor, -1, null);
            }
            if (fields.length == 3) {
                int major = Integer.parseInt(fields[0]);
                int minor = Integer.parseInt(fields[1]);
                String[] fields2 = fields[2].split("-");
                if (fields2.length == 1) {
                    int micro = Integer.parseInt(fields2[0]);
                    return new SVNVersion(major, minor, micro, null);
                }
                int micro = Integer.parseInt(fields2[0]);
                String build = fields2[1];
                return new SVNVersion(major, minor, micro, build);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public SVNVersion(int major, int minor, int micro, String build) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.build = build;
    }

    public SVNVersion removeBuild() {
        return new SVNVersion(this.major, this.minor, this.micro, null);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.major);
        if (this.minor >= 0) {
            stringBuilder.append(".");
            stringBuilder.append(this.minor);
        }
        if (this.micro >= 0) {
            stringBuilder.append(".");
            stringBuilder.append(this.micro);
        }
        if (this.build != null) {
            stringBuilder.append("-");
            stringBuilder.append(this.build);
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(SVNVersion o) {
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        int diff = this.major - o.major;
        if (diff != 0) {
            return diff;
        }
        diff = this.minor - o.minor;
        if (diff != 0) {
            return diff;
        }
        diff = this.micro - o.micro;
        if (diff != 0) {
            return diff;
        }
        if (this.build == null) {
            return o.build == null ? 0 : -1;
        }
        if (o.build == null) {
            return 1;
        }
        return this.build.compareTo(o.build);
    }
}

