/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.serialization;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.persistence.serialization.Snapshot;
import akka.serialization.BaseSerializer;
import akka.serialization.Serialization;
import akka.serialization.Serialization$;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.Serializers$;
import akka.util.ByteString$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\b\u0011\u0001]A\u0001b\t\u0001\u0003\u0006\u0004%\t\u0001\n\u0005\tW\u0001\u0011\t\u0011)A\u0005K!)A\u0006\u0001C\u0001[!9\u0011\u0007\u0001b\u0001\n\u0003\u0012\u0004B\u0002\u001c\u0001A\u0003%1\u0007\u0003\u0005\u0012\u0001!\u0015\r\u0011\"\u00038\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0015)\u0007\u0001\"\u0003g\u0011\u0015q\u0007\u0001\"\u0003p\u0011\u0015Q\b\u0001\"\u0003|\u0011\u0015i\b\u0001\"\u0003\u007f\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007Aq!a\t\u0001\t\u0013\t)C\u0001\nT]\u0006\u00048\u000f[8u'\u0016\u0014\u0018.\u00197ju\u0016\u0014(BA\t\u0013\u00035\u0019XM]5bY&T\u0018\r^5p]*\u00111\u0003F\u0001\fa\u0016\u00148/[:uK:\u001cWMC\u0001\u0016\u0003\u0011\t7n[1\u0004\u0001M\u0019\u0001\u0001\u0007\u0010\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g!\ty\u0012%D\u0001!\u0015\t\tB#\u0003\u0002#A\tq!)Y:f'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018AB:zgR,W.F\u0001&!\t1\u0013&D\u0001(\u0015\tAC#A\u0003bGR|'/\u0003\u0002+O\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\u000691/_:uK6\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002/aA\u0011q\u0006A\u0007\u0002!!)1e\u0001a\u0001K\u0005y\u0011N\\2mk\u0012,W*\u00198jM\u0016\u001cH/F\u00014!\tIB'\u0003\u000265\t9!i\\8mK\u0006t\u0017\u0001E5oG2,H-Z'b]&4Wm\u001d;!+\u0005A\u0004CA\u0010:\u0013\tQ\u0004EA\u0007TKJL\u0017\r\\5{CRLwN\\\u0001\ti>\u0014\u0015N\\1ssR\u0011Qh\u0011\t\u00043y\u0002\u0015BA \u001b\u0005\u0015\t%O]1z!\tI\u0012)\u0003\u0002C5\t!!)\u001f;f\u0011\u0015!u\u00011\u0001\u0019\u0003\u0005y\u0017A\u00034s_6\u0014\u0015N\\1ssR\u0019\u0001dR%\t\u000b!C\u0001\u0019A\u001f\u0002\u000b\tLH/Z:\t\u000b)C\u0001\u0019A&\u0002\u00115\fg.\u001b4fgR\u00042!\u0007'O\u0013\ti%D\u0001\u0004PaRLwN\u001c\u0019\u0003\u001fr\u00032\u0001U,[\u001d\t\tV\u000b\u0005\u0002S55\t1K\u0003\u0002U-\u00051AH]8pizJ!A\u0016\u000e\u0002\rA\u0013X\rZ3g\u0013\tA\u0016LA\u0003DY\u0006\u001c8O\u0003\u0002W5A\u00111\f\u0018\u0007\u0001\t%i\u0016*!A\u0001\u0002\u000b\u0005aLA\u0002`IE\n\"a\u00182\u0011\u0005e\u0001\u0017BA1\u001b\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!G2\n\u0005\u0011T\"aA!os\u0006q\u0001.Z1eKJ$vNQ5oCJLHcA\u001fhS\")\u0001.\u0003a\u00011\u0005A1O\\1qg\"|G\u000fC\u0003k\u0013\u0001\u00071.\u0001\nt]\u0006\u00048\u000f[8u'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bCA\u0010m\u0013\ti\u0007E\u0001\u0006TKJL\u0017\r\\5{KJ\f\u0001\u0003[3bI\u0016\u0014hI]8n\u0005&t\u0017M]=\u0015\u0005AL\b\u0003B\rrgZL!A\u001d\u000e\u0003\rQ+\b\u000f\\33!\tIB/\u0003\u0002v5\t\u0019\u0011J\u001c;\u0011\u0005A;\u0018B\u0001=Z\u0005\u0019\u0019FO]5oO\")\u0001J\u0003a\u0001{\u0005\u00012O\\1qg\"|G\u000fV8CS:\f'/\u001f\u000b\u0003{qDQ\u0001[\u0006A\u0002a\t!c\u001d8baNDw\u000e\u001e$s_6\u0014\u0015N\\1ssR\u0011\u0001d \u0005\u0006\u00112\u0001\r!P\u0001\toJLG/Z%oiR1\u0011QAA\u0006\u0003?\u00012!GA\u0004\u0013\r\tIA\u0007\u0002\u0005+:LG\u000fC\u0004\u0002\u000e5\u0001\r!a\u0004\u0002\u0007=,H\u000f\u0005\u0003\u0002\u0012\u0005mQBAA\n\u0015\u0011\t)\"a\u0006\u0002\u0005%|'BAA\r\u0003\u0011Q\u0017M^1\n\t\u0005u\u00111\u0003\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\u0007\u0003Ci\u0001\u0019A:\u0002\u0003%\fqA]3bI&sG\u000fF\u0002t\u0003OAq!!\u000b\u000f\u0001\u0004\tY#\u0001\u0002j]B!\u0011\u0011CA\u0017\u0013\u0011\ty#a\u0005\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c")
public class SnapshotSerializer
implements BaseSerializer {
    private Serialization serialization;
    private final ExtendedActorSystem system;
    private final boolean includeManifest;
    private final int identifier;
    private volatile boolean bitmap$0;

    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.identifierFromConfig$((BaseSerializer)this);
    }

    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes);
    }

    public final Object fromBinary(byte[] bytes, Class<?> clazz) throws NotSerializableException {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes, clazz);
    }

    public int identifier() {
        return this.identifier;
    }

    public void akka$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public boolean includeManifest() {
        return this.includeManifest;
    }

    private Serialization serialization$lzycompute() {
        SnapshotSerializer snapshotSerializer = this;
        synchronized (snapshotSerializer) {
            if (!this.bitmap$0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                this.bitmap$0 = true;
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        return !this.bitmap$0 ? this.serialization$lzycompute() : this.serialization;
    }

    public byte[] toBinary(Object o) {
        Object object = o;
        if (!(object instanceof Snapshot)) {
            throw new IllegalArgumentException(new StringBuilder(31).append("Can't serialize object of type ").append(o.getClass()).toString());
        }
        Snapshot snapshot = (Snapshot)object;
        Object data = snapshot.data();
        byte[] byArray = this.snapshotToBinary(data);
        return byArray;
    }

    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        return new Snapshot(this.snapshotFromBinary(bytes));
    }

    private byte[] headerToBinary(Object snapshot, Serializer snapshotSerializer) {
        ByteArrayOutputStream out;
        block0: {
            out = new ByteArrayOutputStream();
            this.writeInt(out, snapshotSerializer.identifier());
            String ms = Serializers$.MODULE$.manifestFor(snapshotSerializer, snapshot);
            if (!new StringOps(Predef$.MODULE$.augmentString(ms)).nonEmpty()) break block0;
            out.write(ms.getBytes(ByteString$.MODULE$.UTF_8()));
        }
        return out.toByteArray();
    }

    private Tuple2<Object, String> headerFromBinary(byte[] bytes) {
        String string;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        int serializerId = this.readInt(in);
        if ((serializerId & 0xEDAC) == 60844) {
            throw new NotSerializableException("Replaying snapshot from akka 2.3.x version is not supported any more");
        }
        int remaining = in.available();
        if (remaining == 0) {
            string = "";
        } else {
            byte[] manifestBytes = new byte[remaining];
            in.read(manifestBytes);
            string = new String(manifestBytes, ByteString$.MODULE$.UTF_8());
        }
        String manifest = string;
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)serializerId), (Object)manifest);
    }

    private byte[] snapshotToBinary(Object snapshot) {
        byte[] byArray;
        Serialization.Information oldInfo = (Serialization.Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.system().provider().serializationInformation());
            }
            byArray = this.serialize$1(snapshot);
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return byArray;
    }

    private Object snapshotFromBinary(byte[] bytes) {
        int headerLength = this.readInt(new ByteArrayInputStream(bytes));
        byte[] headerBytes = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(4, headerLength + 4);
        byte[] snapshotBytes = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).drop(headerLength + 4);
        Tuple2<Object, String> tuple2 = this.headerFromBinary(headerBytes);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int serializerId = tuple2._1$mcI$sp();
        String manifest = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)serializerId), (Object)manifest);
        Tuple2 tuple23 = tuple22;
        int serializerId2 = tuple23._1$mcI$sp();
        String manifest2 = (String)tuple23._2();
        return this.serialization().deserialize(snapshotBytes, serializerId2, manifest2).get();
    }

    private void writeInt(OutputStream out, int i) {
        out.write(i >>> 0);
        out.write(i >>> 8);
        out.write(i >>> 16);
        out.write(i >>> 24);
    }

    private int readInt(InputStream in) {
        int b1 = in.read();
        int b2 = in.read();
        int b3 = in.read();
        int b4 = in.read();
        if ((b1 | b2 | b3 | b3) == -1) {
            throw new EOFException();
        }
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    private final byte[] serialize$1(Object snapshot$1) {
        Serializer snapshotSerializer = this.serialization().findSerializerFor(snapshot$1);
        byte[] headerBytes = this.headerToBinary(snapshot$1, snapshotSerializer);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(out, headerBytes.length);
        out.write(headerBytes);
        out.write(snapshotSerializer.toBinary(snapshot$1));
        return out.toByteArray();
    }

    public SnapshotSerializer(ExtendedActorSystem system) {
        this.system = system;
        Serializer.$init$((Serializer)this);
        BaseSerializer.$init$((BaseSerializer)this);
        this.includeManifest = false;
    }
}

