/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.platform.sso.oidc.policy.impl;

import com.xebialabs.platform.sso.oidc.exceptions.InsufficientClaimsException;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToUserNamePolicy;
import java.util.Map;
import org.springframework.util.Assert;

public class DefaultClaimsToUserPolicy
implements ClaimsToUserNamePolicy {
    private final String userNameClaimName;

    public DefaultClaimsToUserPolicy(String userNameClaimName) {
        Assert.hasText((String)userNameClaimName, (String)"userNameClaimName must contain a property name");
        this.userNameClaimName = userNameClaimName;
    }

    @Override
    public String claimsToUserName(Map<String, Object> oidcClaims) {
        Object pu = oidcClaims.get(this.userNameClaimName);
        if (pu == null) {
            throw new InsufficientClaimsException("Could not determine username: OIDC claims do not contain a property '" + this.userNameClaimName + "'");
        }
        if (!(pu instanceof String)) {
            throw new InsufficientClaimsException("Could not determine username: OIDC claims do not contain a string property '" + this.userNameClaimName + "'");
        }
        String userName = ((String)pu).toLowerCase();
        if (userName.isEmpty()) {
            throw new InsufficientClaimsException("Could not determine username: OIDC claims contain an empty '" + this.userNameClaimName + "'");
        }
        return userName;
    }
}

