/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.akka;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import com.typesafe.sslconfig.akka.AkkaSSLConfig$;
import com.typesafe.sslconfig.akka.DefaultSSLEngineConfigurator;
import com.typesafe.sslconfig.akka.util.AkkaLoggerFactory;
import com.typesafe.sslconfig.ssl.AlgorithmChecker;
import com.typesafe.sslconfig.ssl.AlgorithmConstraintsParser$;
import com.typesafe.sslconfig.ssl.Ciphers$;
import com.typesafe.sslconfig.ssl.ConfigSSLContextBuilder;
import com.typesafe.sslconfig.ssl.DefaultKeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.DefaultTrustManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.DisabledComplainingHostnameVerifier;
import com.typesafe.sslconfig.ssl.KeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.Protocols$;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.ssl.TrustManagerFactoryWrapper;
import com.typesafe.sslconfig.util.LoggerFactory;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.cert.CertPathValidatorException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ev!B\u0010!\u0011\u0003Ic!B\u0016!\u0011\u0003a\u0003B\u0002'\u0002\t\u0003\tI\tC\u0004\u0002\f\u0006!\t%!$\t\u000f\u0005]\u0015\u0001\"\u0001\u0002\u001a\"9\u0011qT\u0001\u0005B\u0005\u0005\u0006bBAS\u0003\u0011\u0005\u0013q\u0015\u0005\b\u0003W\u000bA\u0011AAW\r\u0011Y\u0003EA\u001e\t\u0011}B!\u0011!Q\u0001\n\u0001C\u0001b\u0011\u0005\u0003\u0006\u0004%\t\u0001\u0012\u0005\t\u0017\"\u0011\t\u0011)A\u0005\u000b\")A\n\u0003C\u0001\u001b\"9\u0001\u000b\u0003b\u0001\n\u0013\t\u0006B\u0002-\tA\u0003%!\u000bC\u0004Z\u0011\t\u0007I\u0011\u0002.\t\r\u0005D\u0001\u0015!\u0003\\\u0011\u0015\u0011\u0007\u0002\"\u0001d\u0011\u00151\u0007\u0002\"\u0001h\u0011\u0015i\u0007\u0002\"\u0001o\u0011\u001dI\bB1A\u0005\u0002iDq!!\u0003\tA\u0003%1\u0010C\u0005\u0002\f!\u0011\r\u0011\"\u0001\u0002\u000e!A\u0011Q\u0003\u0005!\u0002\u0013\ty\u0001C\u0004\u0002\u0018!!\t!!\u0007\t\u000f\u0005\r\u0002\u0002\"\u0001\u0002&!9\u0011q\u0006\u0005\u0005\u0002\u0005E\u0002bBA\u001c\u0011\u0011\u0005\u0011\u0011\b\u0005\b\u0003\u000bBA\u0011AA$\u0011\u001d\tY\u0007\u0003C\u0001\u0003[Bq!!\u001e\t\t\u0013\t9(A\u0007BW.\f7k\u0015'D_:4\u0017n\u001a\u0006\u0003C\t\nA!Y6lC*\u00111\u0005J\u0001\ngNd7m\u001c8gS\u001eT!!\n\u0014\u0002\u0011QL\b/Z:bM\u0016T\u0011aJ\u0001\u0004G>l7\u0001\u0001\t\u0003U\u0005i\u0011\u0001\t\u0002\u000e\u0003.\\\u0017mU*M\u0007>tg-[4\u0014\u000b\u0005i3'a!\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g!\r!\u0004HO\u0007\u0002k)\u0011agN\u0001\u0006C\u000e$xN\u001d\u0006\u0002C%\u0011\u0011(\u000e\u0002\f\u000bb$XM\\:j_:LE\r\u0005\u0002+\u0011M\u0019\u0001\"\f\u001f\u0011\u0005Qj\u0014B\u0001 6\u0005%)\u0005\u0010^3og&|g.\u0001\u0004tsN$X-\u001c\t\u0003i\u0005K!AQ\u001b\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\u0002\r\r|gNZ5h+\u0005)\u0005C\u0001$J\u001b\u00059%B\u0001%#\u0003\r\u00198\u000f\\\u0005\u0003\u0015\u001e\u0013\u0011cU*M\u0007>tg-[4TKR$\u0018N\\4t\u0003\u001d\u0019wN\u001c4jO\u0002\na\u0001P5oSRtDc\u0001\u001eO\u001f\")q\b\u0004a\u0001\u0001\")1\t\u0004a\u0001\u000b\u0006AQn\u001b'pO\u001e,'/F\u0001S!\t\u0019f+D\u0001U\u0015\t)\u0006%\u0001\u0003vi&d\u0017BA,U\u0005E\t5n[1M_\u001e<WM\u001d$bGR|'/_\u0001\n[.dunZ4fe\u0002\n1\u0001\\8h+\u0005Y\u0006C\u0001/`\u001b\u0005i&B\u000108\u0003\u0015)g/\u001a8u\u0013\t\u0001WL\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0002\t1|w\rI\u0001\ro&$\bnU3ui&twm\u001d\u000b\u0003u\u0011DQ!Z\tA\u0002\u0015\u000b\u0011aY\u0001\f[\u0006\u00048+\u001a;uS:<7\u000f\u0006\u0002;Q\")\u0011N\u0005a\u0001U\u0006\ta\r\u0005\u0003/W\u0016+\u0015B\u000170\u0005%1UO\\2uS>t\u0017'A\bd_:4XM\u001d;TKR$\u0018N\\4t)\tQt\u000eC\u0003j'\u0001\u0007\u0001\u000f\u0005\u0003ro\u0016+U\"\u0001:\u000b\u0005M$\u0018\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0005U+(\"\u0001<\u0002\t)\fg/Y\u0005\u0003qJ\u0014\u0001BR;oGRLwN\\\u0001\u0011Q>\u001cHO\\1nKZ+'/\u001b4jKJ,\u0012a\u001f\t\u0004y\u0006\u0015Q\"A?\u000b\u0005!s(bA@\u0002\u0002\u0005\u0019a.\u001a;\u000b\u0005\u0005\r\u0011!\u00026bm\u0006D\u0018bAA\u0004{\n\u0001\u0002j\\:u]\u0006lWMV3sS\u001aLWM]\u0001\u0012Q>\u001cHO\\1nKZ+'/\u001b4jKJ\u0004\u0013!F:tY\u0016sw-\u001b8f\u0007>tg-[4ve\u0006$xN]\u000b\u0003\u0003\u001f\u00012AKA\t\u0013\r\t\u0019\u0002\t\u0002\u001d\t\u00164\u0017-\u001e7u'NcUI\\4j]\u0016\u001cuN\u001c4jOV\u0014\u0018\r^8s\u0003Y\u00198\u000f\\#oO&tWmQ8oM&<WO]1u_J\u0004\u0013A\u00062vS2$7*Z=NC:\fw-\u001a:GC\u000e$xN]=\u0015\t\u0005m\u0011\u0011\u0005\t\u0004\r\u0006u\u0011bAA\u0010\u000f\nA2*Z=NC:\fw-\u001a:GC\u000e$xN]=Xe\u0006\u0004\b/\u001a:\t\u000b!C\u0002\u0019A#\u00021\t,\u0018\u000e\u001c3UeV\u001cH/T1oC\u001e,'OR1di>\u0014\u0018\u0010\u0006\u0003\u0002(\u00055\u0002c\u0001$\u0002*%\u0019\u00111F$\u00035Q\u0013Xo\u001d;NC:\fw-\u001a:GC\u000e$xN]=Xe\u0006\u0004\b/\u001a:\t\u000b!K\u0002\u0019A#\u0002+\t,\u0018\u000e\u001c3I_N$h.Y7f-\u0016\u0014\u0018NZ5feR\u001910a\r\t\r\u0005U\"\u00041\u0001F\u0003\u0011\u0019wN\u001c4\u00027Y\fG.\u001b3bi\u0016$UMZ1vYR$&/^:u\u001b\u0006t\u0017mZ3s)\u0011\tY$!\u0011\u0011\u00079\ni$C\u0002\u0002@=\u0012A!\u00168ji\"1\u00111I\u000eA\u0002\u0015\u000b\u0011b]:m\u0007>tg-[4\u0002%\r|gNZ5hkJ,\u0007K]8u_\u000e|Gn\u001d\u000b\u0007\u0003\u0013\n)'!\u001b\u0011\u000b9\nY%a\u0014\n\u0007\u00055sFA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002R\u0005}c\u0002BA*\u00037\u00022!!\u00160\u001b\t\t9FC\u0002\u0002Z!\na\u0001\u0010:p_Rt\u0014bAA/_\u00051\u0001K]3eK\u001aLA!!\u0019\u0002d\t11\u000b\u001e:j]\u001eT1!!\u00180\u0011\u001d\t9\u0007\ba\u0001\u0003\u0013\n\u0011#\u001a=jgRLgn\u001a)s_R|7m\u001c7t\u0011\u0019\t\u0019\u0005\ba\u0001\u000b\u0006)2m\u001c8gS\u001e,(/Z\"ja\",'oU;ji\u0016\u001cHCBA%\u0003_\n\u0019\bC\u0004\u0002ru\u0001\r!!\u0013\u0002\u001f\u0015D\u0018n\u001d;j]\u001e\u001c\u0015\u000e\u001d5feNDa!a\u0011\u001e\u0001\u0004)\u0015a\u00047p_N,G)[:bE2,7KT%\u0015\t\u0005m\u0012\u0011\u0010\u0005\b\u0003wr\u0002\u0019AA?\u00035!WMZ1vYR\u0004\u0016M]1ngB\u0019A0a \n\u0007\u0005\u0005UPA\u0007T'2\u0003\u0016M]1nKR,'o\u001d\t\u0004i\u0005\u0015\u0015bAADk\t\u0019R\t\u001f;f]NLwN\\%e!J|g/\u001b3feR\t\u0011&A\u0002hKR$2AOAH\u0011\u0019y4\u00011\u0001\u0002\u0012B\u0019A'a%\n\u0007\u0005UUGA\u0006BGR|'oU=ti\u0016l\u0017!B1qa2LHCAAN)\rQ\u0014Q\u0014\u0005\u0007\u007f\u0011\u0001\u001d!!%\u0002\r1|wn[;q)\t\t\u0019K\u0004\u0002+\u0001\u0005y1M]3bi\u0016,\u0005\u0010^3og&|g\u000eF\u0002;\u0003SCQa\u0010\u0004A\u0002\u0001\u000b\u0001\u0004Z3gCVdGoU*M\u0007>tg-[4TKR$\u0018N\\4t)\r)\u0015q\u0016\u0005\u0007\u007f\u001d\u0001\r!!%")
public final class AkkaSSLConfig
implements Extension {
    private final ExtendedActorSystem system;
    private final SSLConfigSettings config;
    private final AkkaLoggerFactory mkLogger;
    private final LoggingAdapter log;
    private final HostnameVerifier hostnameVerifier;
    private final DefaultSSLEngineConfigurator sslEngineConfigurator;

    public static SSLConfigSettings defaultSSLConfigSettings(ActorSystem actorSystem) {
        return AkkaSSLConfig$.MODULE$.defaultSSLConfigSettings(actorSystem);
    }

    public static AkkaSSLConfig createExtension(ExtendedActorSystem extendedActorSystem) {
        return AkkaSSLConfig$.MODULE$.createExtension(extendedActorSystem);
    }

    public static AkkaSSLConfig$ lookup() {
        return AkkaSSLConfig$.MODULE$.lookup();
    }

    public static AkkaSSLConfig apply(ActorSystem actorSystem) {
        return AkkaSSLConfig$.MODULE$.apply(actorSystem);
    }

    public static AkkaSSLConfig get(ActorSystem actorSystem) {
        return AkkaSSLConfig$.MODULE$.get(actorSystem);
    }

    public SSLConfigSettings config() {
        return this.config;
    }

    private AkkaLoggerFactory mkLogger() {
        return this.mkLogger;
    }

    private LoggingAdapter log() {
        return this.log;
    }

    public AkkaSSLConfig withSettings(SSLConfigSettings c) {
        return new AkkaSSLConfig(this.system, c);
    }

    public AkkaSSLConfig mapSettings(Function1<SSLConfigSettings, SSLConfigSettings> f) {
        return new AkkaSSLConfig(this.system, (SSLConfigSettings)f.apply((Object)this.config()));
    }

    public AkkaSSLConfig convertSettings(Function<SSLConfigSettings, SSLConfigSettings> f) {
        return new AkkaSSLConfig(this.system, f.apply(this.config()));
    }

    public HostnameVerifier hostnameVerifier() {
        return this.hostnameVerifier;
    }

    public DefaultSSLEngineConfigurator sslEngineConfigurator() {
        return this.sslEngineConfigurator;
    }

    public KeyManagerFactoryWrapper buildKeyManagerFactory(SSLConfigSettings ssl) {
        String keyManagerAlgorithm = ssl.keyManagerConfig().algorithm();
        return new DefaultKeyManagerFactoryWrapper(keyManagerAlgorithm);
    }

    public TrustManagerFactoryWrapper buildTrustManagerFactory(SSLConfigSettings ssl) {
        String trustManagerAlgorithm = ssl.trustManagerConfig().algorithm();
        return new DefaultTrustManagerFactoryWrapper(trustManagerAlgorithm);
    }

    /*
     * WARNING - void declaration
     */
    public HostnameVerifier buildHostnameVerifier(SSLConfigSettings conf) {
        void var3_3;
        boolean bl = conf != null;
        Class clazz = this.config().loose().disableHostnameVerification() ? DisabledComplainingHostnameVerifier.class : this.config().hostnameVerifierClass();
        HostnameVerifier v = (HostnameVerifier)this.system.dynamicAccess().createInstanceFor(clazz, (scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(HostnameVerifier.class)).orElse((Function0 & Serializable & scala.Serializable)() -> $this.system.dynamicAccess().createInstanceFor(clazz, (scala.collection.immutable.Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(LoggerFactory.class), (Object)this.mkLogger()), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(HostnameVerifier.class))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception(new StringBuilder(46).append("Unable to obtain hostname verifier for class: ").append(clazz).toString());
        });
        this.log().debug("buildHostnameVerifier: created hostname verifier: {}", (Object)v);
        return var3_3;
    }

    public void validateDefaultTrustManager(SSLConfigSettings sslConfig) {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        X509TrustManager trustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        String disabledKeyAlgorithms = sslConfig.disabledKeyAlgorithms().mkString(",");
        Set constraints = ((TraversableOnce)AlgorithmConstraintsParser$.MODULE$.parseAll(AlgorithmConstraintsParser$.MODULE$.line(), (CharSequence)disabledKeyAlgorithms).get()).toSet();
        AkkaLoggerFactory x$1 = this.mkLogger();
        Set x$2 = constraints;
        Set x$3 = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        AlgorithmChecker algorithmChecker = new AlgorithmChecker((LoggerFactory)x$1, x$3, x$2);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trustManager.getAcceptedIssuers())).foreach((Function1 & Serializable & scala.Serializable)cert -> {
            AkkaSSLConfig.$anonfun$validateDefaultTrustManager$1(this, algorithmChecker, cert);
            return BoxedUnit.UNIT;
        });
    }

    public String[] configureProtocols(String[] existingProtocols, SSLConfigSettings sslConfig) {
        String[] definedProtocols;
        block4: {
            String[] stringArray;
            Option option = sslConfig.enabledProtocols();
            if (option instanceof Some) {
                Some some = (Some)option;
                scala.collection.immutable.Seq configuredProtocols = (scala.collection.immutable.Seq)some.value();
                Object[] objectArray = Predef$.MODULE$.refArrayOps((Object[])existingProtocols);
                stringArray = (String[])((TraversableOnce)configuredProtocols.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)AkkaSSLConfig.$anonfun$configureProtocols$1(objectArray, elem)))).toArray(ClassTag$.MODULE$.apply(String.class));
            } else if (None$.MODULE$.equals(option)) {
                Object[] objectArray = Predef$.MODULE$.refArrayOps((Object[])existingProtocols);
                stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Protocols$.MODULE$.recommendedProtocols())).filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)AkkaSSLConfig.$anonfun$configureProtocols$2(objectArray, elem)));
            } else {
                throw new MatchError((Object)option);
            }
            definedProtocols = stringArray;
            boolean allowWeakProtocols = sslConfig.loose().allowWeakProtocols();
            if (allowWeakProtocols) break block4;
            Set deprecatedProtocols = Protocols$.MODULE$.deprecatedProtocols();
            deprecatedProtocols.foreach((Function1 & Serializable & scala.Serializable)deprecatedProtocol -> {
                AkkaSSLConfig.$anonfun$configureProtocols$3(definedProtocols, deprecatedProtocol);
                return BoxedUnit.UNIT;
            });
        }
        return definedProtocols;
    }

    public String[] configureCipherSuites(String[] existingCiphers, SSLConfigSettings sslConfig) {
        String[] definedCiphers;
        block4: {
            String[] stringArray;
            Option option = sslConfig.enabledCipherSuites();
            if (option instanceof Some) {
                Some some = (Some)option;
                scala.collection.immutable.Seq configuredCiphers = (scala.collection.immutable.Seq)some.value();
                stringArray = (String[])((TraversableOnce)configuredCiphers.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AkkaSSLConfig.$anonfun$configureCipherSuites$1(existingCiphers, x$1)))).toArray(ClassTag$.MODULE$.apply(String.class));
            } else if (None$.MODULE$.equals(option)) {
                stringArray = (String[])((TraversableOnce)Ciphers$.MODULE$.recommendedCiphers().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AkkaSSLConfig.$anonfun$configureCipherSuites$2(existingCiphers, x$2)))).toArray(ClassTag$.MODULE$.apply(String.class));
            } else {
                throw new MatchError((Object)option);
            }
            definedCiphers = stringArray;
            boolean allowWeakCiphers = sslConfig.loose().allowWeakCiphers();
            if (allowWeakCiphers) break block4;
            Set deprecatedCiphers = Ciphers$.MODULE$.deprecatedCiphers();
            deprecatedCiphers.foreach((Function1 & Serializable & scala.Serializable)deprecatedCipher -> {
                AkkaSSLConfig.$anonfun$configureCipherSuites$3(definedCiphers, deprecatedCipher);
                return BoxedUnit.UNIT;
            });
        }
        return definedCiphers;
    }

    private void looseDisableSNI(SSLParameters defaultParams) {
        block0: {
            if (!this.config().loose().disableSNI()) break block0;
            this.log().warning("You are using ssl-config.loose.disableSNI=true! It is strongly discouraged to disable Server Name Indication, as it is crucial to preventing man-in-the-middle attacks.");
            defaultParams.setServerNames(Collections.emptyList());
            defaultParams.setSNIMatchers(Collections.emptyList());
        }
    }

    public static final /* synthetic */ void $anonfun$validateDefaultTrustManager$1(AkkaSSLConfig $this, AlgorithmChecker algorithmChecker$1, X509Certificate cert) {
        try {
            algorithmChecker$1.checkKeyAlgorithms(cert);
        }
        catch (CertPathValidatorException e) {
            $this.log().warning("You are using ssl-config.default=true and have a weak certificate in your default trust store! (You can modify akka.ssl-config.disabledKeyAlgorithms to remove this message.)", (Object)e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$configureProtocols$1(Object[] eta$0$1$1, Object elem) {
        return new ArrayOps.ofRef(eta$0$1$1).contains(elem);
    }

    public static final /* synthetic */ boolean $anonfun$configureProtocols$2(Object[] eta$0$2$1, Object elem) {
        return new ArrayOps.ofRef(eta$0$2$1).contains(elem);
    }

    public static final /* synthetic */ void $anonfun$configureProtocols$3(String[] definedProtocols$1, String deprecatedProtocol) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])definedProtocols$1)).contains((Object)deprecatedProtocol)) {
            throw new IllegalStateException(new StringBuilder(45).append("Weak protocol ").append(deprecatedProtocol).append(" found in ssl-config.protocols!").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$configureCipherSuites$1(String[] existingCiphers$1, String x$1) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existingCiphers$1)).contains((Object)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$configureCipherSuites$2(String[] existingCiphers$1, String x$2) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existingCiphers$1)).contains((Object)x$2);
    }

    public static final /* synthetic */ void $anonfun$configureCipherSuites$3(String[] definedCiphers$1, String deprecatedCipher) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])definedCiphers$1)).contains((Object)deprecatedCipher)) {
            throw new IllegalStateException(new StringBuilder(41).append("Weak cipher ").append(deprecatedCipher).append(" found in ssl-config.ciphers!").toString());
        }
    }

    public AkkaSSLConfig(ExtendedActorSystem system, SSLConfigSettings config) {
        SSLContext sSLContext;
        this.system = system;
        this.config = config;
        this.mkLogger = new AkkaLoggerFactory((ActorSystem)system);
        this.log = Logging$.MODULE$.apply((ActorSystem)system, this.getClass(), LogSource$.MODULE$.fromAnyClass());
        this.log().debug("Initializing AkkaSSLConfig extension...");
        this.hostnameVerifier = this.buildHostnameVerifier(config);
        if (config.default()) {
            this.log().info("ssl-config.default is true, using the JDK's default SSLContext");
            this.validateDefaultTrustManager(config);
            sSLContext = SSLContext.getDefault();
        } else {
            KeyManagerFactoryWrapper keyManagerFactory = this.buildKeyManagerFactory(config);
            TrustManagerFactoryWrapper trustManagerFactory = this.buildTrustManagerFactory(config);
            sSLContext = new ConfigSSLContextBuilder((LoggerFactory)this.mkLogger(), config, keyManagerFactory, trustManagerFactory).build();
        }
        SSLContext sslContext = sSLContext;
        SSLParameters defaultParams = sslContext.getDefaultSSLParameters();
        String[] defaultProtocols = defaultParams.getProtocols();
        String[] protocols = this.configureProtocols(defaultProtocols, config);
        String[] defaultCiphers = defaultParams.getCipherSuites();
        String[] cipherSuites = this.configureCipherSuites(defaultCiphers, config);
        this.looseDisableSNI(defaultParams);
        this.sslEngineConfigurator = new DefaultSSLEngineConfigurator(config, protocols, cipherSuites);
    }
}

