(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[4],{

/***/ 100:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return fetchRiskConfig; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return fetchRiskAssessors; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return fetchRiskProfiles; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return fetchRiskProfile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return createRiskProfile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "j", function() { return updateRiskProfile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return deleteRiskProfile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return copyRiskProfile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return fetchReferences; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return RiskSettingsService; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _common_services_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16);



var riskApi = 'api/v1/risks';
var fetchRiskConfig = function fetchRiskConfig() {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_2__[/* httpGET */ "c"])("".concat(riskApi, "/config"));
};
var fetchRiskAssessors = function fetchRiskAssessors() {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_2__[/* httpGET */ "c"])("".concat(riskApi, "/assessors"));
};
var fetchRiskProfiles = function fetchRiskProfiles() {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_2__[/* httpGET */ "c"])("".concat(riskApi, "/profiles"));
};
var fetchRiskProfile = function fetchRiskProfile(riskProfileId) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_2__[/* httpGET */ "c"])("".concat(riskApi, "/profiles/").concat(riskProfileId));
};
var createRiskProfile = function createRiskProfile(riskProfile) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_2__[/* httpPOST */ "d"])("".concat(riskApi, "/profiles"), riskProfile);
};
var updateRiskProfile = function updateRiskProfile(riskProfile) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_2__[/* httpPUT */ "e"])("".concat(riskApi, "/profiles/").concat(riskProfile.id), riskProfile);
};
var deleteRiskProfile = function deleteRiskProfile(riskProfileId) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_2__[/* httpDELETE */ "b"])("".concat(riskApi, "/profiles/").concat(riskProfileId));
};
var copyRiskProfile = function copyRiskProfile(riskProfileId) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_2__[/* httpPOST */ "d"])("".concat(riskApi, "/profiles/").concat(riskProfileId, "/copy"));
};
var fetchReferences = function fetchReferences(riskProfileId) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_2__[/* httpGET */ "c"])("risks/profiles/".concat(riskProfileId, "/references"));
};
var RiskSettingsService = /*#__PURE__*/function () {
  function RiskSettingsService() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, RiskSettingsService);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(RiskSettingsService, [{
    key: "getAll",
    value: function getAll() {
      return fetchRiskProfiles();
    }
  }]);

  return RiskSettingsService;
}();

/***/ }),

/***/ 104:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return isAtRisk; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return isAttentionNeeded; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return isOnTrack; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return isCompleted; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return getRiskStatus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return isPlanItemOverdueMessage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return getRiskIconClasses; });
/* harmony import */ var _js_releases_list_releases_status_service_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(119);
/* harmony import */ var _js_util_ids__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(62);
/* harmony import */ var _release_overview_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(90);



function isAtRisk(release, riskScore, riskThresholds) {
  return !isCompleted(release) && riskScore >= riskThresholds.atRiskFrom;
}
function isAttentionNeeded(release, riskScore, riskThresholds) {
  return !isCompleted(release) && riskScore >= riskThresholds.attentionNeededFrom && riskScore < riskThresholds.atRiskFrom;
}
function isOnTrack(release, riskScore, riskThresholds) {
  return !isCompleted(release) && riskScore < riskThresholds.attentionNeededFrom;
}
function isCompleted(release) {
  return Object(_js_releases_list_releases_status_service_js__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])().hasCompletedStatus(release) || Object(_js_releases_list_releases_status_service_js__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])().isReleaseAborted(release);
}
function getRiskStatus(release, riskScore, riskThresholds) {
  if (isAtRisk(release, riskScore, riskThresholds)) {
    return _release_overview_constants__WEBPACK_IMPORTED_MODULE_2__[/* AT_RISK */ "b"];
  } else if (isAttentionNeeded(release, riskScore, riskThresholds)) {
    return _release_overview_constants__WEBPACK_IMPORTED_MODULE_2__[/* ATTENTION_NEEDED */ "a"];
  } else if (isOnTrack(release, riskScore, riskThresholds)) {
    return _release_overview_constants__WEBPACK_IMPORTED_MODULE_2__[/* ON_TRACK */ "e"];
  }

  return _release_overview_constants__WEBPACK_IMPORTED_MODULE_2__[/* NONE */ "d"];
}
function isPlanItemOverdueMessage(message) {
  var riskAssessorId = message.riskAssessorId;
  return riskAssessorId && (riskAssessorId === 'Applications/ReleaseDueDateRiskAssessor' || riskAssessorId === 'Applications/TaskDueDateRiskAssessor');
}
function getRiskIconClasses(riskAssessor) {
  if (!riskAssessor.riskAssessorId) {
    return _release_overview_constants__WEBPACK_IMPORTED_MODULE_2__[/* RISK_ON_TRACK_ICON */ "g"];
  }

  var id = Object(_js_util_ids__WEBPACK_IMPORTED_MODULE_1__[/* default */ "a"])().toInternalId(riskAssessor.riskAssessorId).replace('RiskAssessor', '');
  return _release_overview_constants__WEBPACK_IMPORTED_MODULE_2__[/* RISK_ASSESSOR_ICONS */ "f"][id];
}

/***/ }),

/***/ 105:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return GlobalPermissions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return Permissions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return PermissionLabels; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AvailableGroupedFolderPermissions; });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25);
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(106);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);



function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }


var GlobalPermissions = {
  ADMINISTRATOR: 'admin',
  AUDIT_ALL: 'all#audit',
  CREATE_TOP_LEVEL_FOLDER: 'folder#create_top_level',
  EDIT_GLOBAL_BLACKOUT: 'global_calendar#edit_blackout',
  EDIT_RISK_PROFILE: 'risk_profile#edit',
  CREATE_GLOBAL_DASHBOARD: 'dashboard#create',
  EDIT_GLOBAL_ENVIRONMENT: 'environment#edit',
  EDIT_GLOBAL_APPLICATION: 'application#edit',
  EDIT_GLOBAL_RESERVATION: 'reservation#edit',
  VIEW_REPORTS: 'reports#view'
};
var Permissions = {
  CREATE_TEMPLATE: 'template#create',
  VIEW_TEMPLATE: 'template#view',
  EDIT_TEMPLATE: 'template#edit',
  CREATE_RELEASE_FROM_TEMPLATE: 'template#create_release',
  EDIT_FOLDER: 'folder#edit',
  CREATE_RELEASE: 'release#create',
  START_RELEASE: 'release#start',
  EDIT_TEMPLATE_TRIGGERS: 'template#edit_triggers',
  EDIT_TRIGGER: 'trigger#edit_trigger',
  VIEW_TRIGGER: 'trigger#view_trigger',
  EDIT_RELEASE_GROUP: 'group#edit',
  EDIT_FOLDER_SECURITY: 'folder#edit_security',
  EDIT_FOLDER_TEAMS: 'folder#edit_teams',
  EDIT_FOLDER_VARIABLES: 'folder#edit_variables'
};
var PermissionLabels = {
  'admin': {
    label: 'Admin',
    description: 'The admin role has system-wide permissions'
  },
  'reports#view': {
    label: 'View reports',
    description: 'View reports'
  },
  'all#audit': {
    label: 'Audit reports',
    description: 'Generate and download audit reports'
  },
  'dashboard#create': {
    label: 'Create dashboards',
    description: 'Create, edit, or delete a custom dashboard'
  },
  'dashboard#view': {
    label: 'View Dashboards tab',
    description: 'View the Dashboards tabs in folders'
  },
  'dashboard#edit': {
    label: 'Edit dashboards',
    description: 'Edit custom dashboards in folders'
  },
  'release#view': {
    label: 'View release',
    description: 'Permission to view all releases in this folder, and any releases that do not have a folder'
  },
  'release#edit': {
    label: 'Edit release',
    description: 'Edit the release by adding and moving tasks and phases; edit release properties and variables'
  },
  'release#edit_security': {
    label: 'Edit release security',
    description: 'Edit teams and permissions in a release, if the release has not already started in a folder'
  },
  'release#start': {
    label: 'Start release',
    description: 'Start a planned release'
  },
  'release#abort': {
    label: 'Abort release',
    description: 'Abort an active or planned release'
  },
  'release#create': {
    label: 'Create release',
    description: 'Create a new release from a template'
  },
  'release#reassign_task': {
    label: 'Assign task ownership',
    clazz: 'inner-permission',
    description: 'Assign task ownership to another user or team. If the user has task ownership, this permission is given by default.'
  },
  'release#edit_task': {
    label: 'All task permissions',
    description: 'The user will inherit all edit task permissions listed below.'
  },
  'release#edit_task_input_output_properties': {
    label: 'Edit task-specific properties',
    clazz: 'inner-permission',
    description: 'Edit configuration data that is specific to the task type; for example, input and output properties on integration tasks, conditions and dependencies on Gate tasks and the variable list on the User Input task.'
  },
  'release#edit_task_configuration_facet': {
    label: 'Edit reporting attributes',
    clazz: 'inner-permission',
    description: 'Edit reporting attributes on tasks in a release'
  },
  'release#edit_task_script': {
    label: 'Edit scripts',
    clazz: 'inner-permission',
    description: 'Edit scripts for Jython, Groovy or External Script tasks'
  },
  'release#edit_blackout': {
    label: 'Allow rescheduling for blackouts and environments',
    clazz: 'inner-permission',
    description: 'Enable or disable the \'Postpone during blackout period\' and \'Check environment availability\' settings at the task level'
  },
  'release#edit_failure_handler': {
    label: 'Edit failure handlers',
    clazz: 'inner-permission',
    description: 'Edit failure handlers on tasks in a release'
  },
  'release#edit_precondition': {
    label: 'Edit preconditions',
    clazz: 'inner-permission',
    description: 'Edit preconditions on tasks in a release'
  },
  'release#lock_task': {
    label: 'Lock tasks',
    description: 'Lock tasks to prevent users without lock permissions from editing them'
  },
  'release#task_transition': {
    label: 'Perform task transitions',
    clazz: 'inner-permission',
    description: 'Change the state of the task. Task transitions include the following actions: Complete, Skip, Fail, Retry, Abort, Reopen.'
  },
  'release#edit_task_tags': {
    label: 'Edit tags',
    clazz: 'inner-permission',
    description: 'Add or remove tags on tasks in a release'
  },
  'release#edit_task_attachments': {
    label: 'Manage attachments',
    clazz: 'inner-permission',
    description: 'Add or remove attachments from tasks in a release'
  },
  'release#edit_task_description': {
    label: 'Edit title and description',
    clazz: 'inner-permission',
    description: 'Edit task title and description'
  },
  'release#edit_task_dates': {
    label: 'Edit dates',
    clazz: 'inner-permission',
    description: 'Change start date, end date, and duration on tasks in a release'
  },
  'release#edit_task_flag': {
    label: 'Edit flag',
    clazz: 'inner-permission',
    description: 'Change the alert status and description for task flags'
  },
  'repo#edit': {
    label: 'Edit repository',
    description: null
  },
  'security#edit': {
    label: 'Edit security',
    description: 'Access the global Roles and Permissions screen and edit security on releases and templates'
  },
  'template#create': {
    label: 'Create template',
    description: 'Create a new template'
  },
  'template#create_release': {
    label: 'Create release',
    description: 'Create a release from a template'
  },
  'template#view': {
    label: 'View templates',
    description: 'View templates in folders and in the Templates screen'
  },
  'template#edit': {
    label: 'Edit templates',
    description: 'Change templates by adding and editing tasks and phases'
  },
  'template#edit_security': {
    label: 'Edit template security',
    description: 'Edit teams and permissions on templates that are not in a folder'
  },
  'template#edit_triggers': {
    label: 'Manage triggers',
    description: 'View, edit, and delete triggers on the template.'
  },
  'template#edit_failure_handler': {
    label: 'Edit task failure handler',
    description: 'Edit the failure handler on a task in a template'
  },
  'template#edit_precondition': {
    label: 'Edit task precondition',
    description: 'Edit the precondition on a task in a template'
  },
  'template#lock_task': {
    label: 'Lock task',
    description: 'When a template task is locked, only users with lock permissions are able to edit or unlock it'
  },
  'global_variables#edit': {
    label: 'Edit global variables',
    description: 'Edit global variables'
  },
  'folder#view': {
    label: 'View folder',
    description: 'Permission to see the folder'
  },
  'folder#edit': {
    label: 'Edit folder',
    description: 'Rename, move, delete, or add a subfolder to the current folder'
  },
  'folder#edit_security': {
    label: 'Edit folder security',
    description: 'Edit the teams and permissions on the current folder'
  },
  'folder#edit_teams': {
    label: 'Edit folder teams and permissions',
    description: 'Edit the teams and permissions on the current folder, with the following limitations: \n' + '[1] Cannot modify teams that have the permissions‚ \'Edit folder security\'‚ or \'Edit folder teams and permissions\'.\n' + '[2] Cannot add or remove the permissions \'Edit folder security\' or \'Edit folder teams and permissions\'.'
  },
  'folder#edit_variables': {
    label: 'Edit folder variables',
    description: 'Edit variables on the current folder'
  },
  'folder#create_top_level': {
    label: 'Create top level folders',
    description: 'Create folders on the top level. To create a folder inside a folder you need the Edit folder permission.'
  },
  'folder#edit_configuration': {
    label: 'Edit configuration',
    description: 'Edit entries in the Configuration tab in a folder'
  },
  'global_calendar#edit_blackout': {
    label: 'Edit blackout periods',
    description: 'Create, edit, or delete a blackout periods'
  },
  'risk_profile#edit': {
    label: 'Edit risk profiles',
    description: 'Create, edit, or delete risk profiles'
  },
  'delivery#view': {
    label: 'View Deliveries tab',
    description: 'View the Deliveries tab in a folder'
  },
  'delivery#edit': {
    label: 'Edit deliveries',
    description: 'View, edit, or create deliveries'
  },
  'delivery#edit_tracked_item': {
    label: 'Edit tracked items',
    description: 'View deliveries and perform operations on their tracked items'
  },
  'delivery_pattern#view': {
    label: 'View delivery patterns',
    description: 'View the Patterns tab in a folder'
  },
  'delivery_pattern#edit': {
    label: 'Edit delivery patterns',
    description: 'View, edit, or create delivery patterns'
  },
  'group#view': {
    label: 'View release groups',
    description: 'View the Groups tab in a folder'
  },
  'group#edit': {
    label: 'Edit release groups',
    description: 'Edit or create release groups'
  },
  'environment#edit': {
    label: 'Edit environments',
    description: 'Create, edit, or delete an environment. This permission is also required to create stages and create environment labels.'
  },
  'application#edit': {
    label: 'Edit applications',
    description: 'Create, edit, or delete an application'
  },
  'reservation#edit': {
    label: 'Edit environment reservations',
    description: 'Access to the Scheduling screen to make a schedule or to reserve an environment'
  },
  'trigger#edit_trigger': {
    label: 'Manage triggers',
    description: 'View, edit, create, delete, enable and disable triggers'
  },
  'trigger#view_trigger': {
    label: 'View triggers',
    description: 'View triggers'
  }
};

var filterPermissions = function filterPermissions(permissions, type) {
  return lodash__WEBPACK_IMPORTED_MODULE_2___default()(permissions).keys().filter(function (permission) {
    return permission.startsWith(type) && !lodash__WEBPACK_IMPORTED_MODULE_2___default.a.includes(GlobalPermissions, permission);
  }).value();
};

var FolderPermissions = filterPermissions(PermissionLabels, 'folder');
var ReleasePermissions = filterPermissions(PermissionLabels, 'release');
var TemplatePermissions = filterPermissions(PermissionLabels, 'template');
var GroupPermissions = filterPermissions(PermissionLabels, 'group');
var DeliveryPermissions = filterPermissions(PermissionLabels, 'delivery');
var DashboardPermissions = filterPermissions(PermissionLabels, 'dashboard');
var AvailableGroupedReleasePermission = [{
  label: 'Templates',
  icon: 'template-icon',
  permissions: ['template#view', 'template#edit', 'template#edit_triggers', 'template#lock_task', 'template#edit_precondition', 'template#edit_failure_handler', 'template#edit_security' // TODO remove this from folder level
  ]
}, {
  label: 'Releases',
  icon: 'release-icon',
  permissions: ['release#view', 'release#edit', 'template#create_release', 'release#start', 'release#abort', 'release#edit_security' // TODO remove this from folder level
  ]
}, {
  label: 'Release tasks',
  icon: 'task-icon',
  permissions: ['release#lock_task', 'release#edit_task', 'release#task_transition', 'release#reassign_task', 'release#edit_task_description', 'release#edit_task_input_output_properties', 'release#edit_task_script', 'release#edit_task_flag', 'release#edit_task_tags', 'release#edit_task_dates', 'release#edit_blackout', 'release#edit_precondition', 'release#edit_failure_handler', 'release#edit_task_configuration_facet', 'release#edit_task_attachments']
}];
var permissionsThatAreNotOnFolderLevel = [{
  label: 'Templates',
  permissions: ['template#edit_triggers', 'template#edit_security']
}, {
  label: 'Releases',
  permissions: ['release#edit_security']
}];
var AvailableGroupedFolderPermissions = [{
  label: 'Folders',
  icon: 'folder-icon',
  permissions: ['folder#view', 'folder#edit', 'folder#edit_variables', 'folder#edit_security', 'folder#edit_teams']
}].concat(_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_1___default()(AvailableGroupedReleasePermission.map(function (group) {
  var groupForModify = permissionsThatAreNotOnFolderLevel.find(function (groupForModify) {
    return groupForModify.label === group.label;
  });
  var permissions = group.permissions;

  if (groupForModify) {
    permissions = lodash__WEBPACK_IMPORTED_MODULE_2___default.a.filter(_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_1___default()(group.permissions), function (permission) {
      return !lodash__WEBPACK_IMPORTED_MODULE_2___default.a.includes(groupForModify.permissions, permission);
    });
  }

  return _objectSpread({}, group, {
    permissions: permissions
  });
})), [{
  label: 'Delivery patterns',
  icon: 'pattern-icon',
  permissions: ['delivery_pattern#view', 'delivery_pattern#edit']
}, {
  label: 'Deliveries',
  icon: 'group-icon',
  permissions: ['delivery#view', 'delivery#edit', 'delivery#edit_tracked_item']
}, {
  label: 'Dashboards',
  icon: 'dashboard-icon',
  permissions: ['dashboard#view', 'dashboard#edit']
}, {
  label: 'Release groups',
  icon: 'collection-icon',
  permissions: ['group#view', 'group#edit']
}, {
  label: 'Configuration',
  icon: 'config-icon',
  permissions: ['folder#edit_configuration']
}, {
  label: 'Triggers',
  icon: 'lightning-icon',
  permissions: ['trigger#view_trigger', 'trigger#edit_trigger']
}]);
angular.module('xlrelease').constant('GlobalPermissions', GlobalPermissions);
angular.module('xlrelease').constant('Permissions', Permissions);
angular.module('xlrelease').constant('PermissionLabels', PermissionLabels);
angular.module('xlrelease').constant('FolderPermissions', FolderPermissions);
angular.module('xlrelease').constant('ReleasePermissions', ReleasePermissions);
angular.module('xlrelease').constant('TemplatePermissions', TemplatePermissions);
angular.module('xlrelease').constant('DeliveryPermissions', DeliveryPermissions);
angular.module('xlrelease').constant('ReleaseGroupPermissions', GroupPermissions);
angular.module('xlrelease').constant('DashboardPermissions', DashboardPermissions);
angular.module('xlrelease').constant('AvailableGroupedFolderPermissions', AvailableGroupedFolderPermissions);
angular.module('xlrelease').constant('AvailableGroupedReleasePermission', AvailableGroupedReleasePermission);

/***/ }),

/***/ 108:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return addConfirmLeavePopup; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return removeConfirmLeavePopup; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return openConfirmationDialog; });
/* harmony import */ var _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8);
/* harmony import */ var _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var redux_saga_effects__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3);
/* harmony import */ var _features_common_services_angular_accessor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(34);


var _marked = /*#__PURE__*/_babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_0___default.a.mark(addConfirmLeavePopup),
    _marked2 = /*#__PURE__*/_babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_0___default.a.mark(removeConfirmLeavePopup),
    _marked3 = /*#__PURE__*/_babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_0___default.a.mark(openConfirmationDialog);



function addConfirmLeavePopup() {
  var confirmLeaveService;
  return _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_0___default.a.wrap(function addConfirmLeavePopup$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.next = 2;
          return Object(redux_saga_effects__WEBPACK_IMPORTED_MODULE_1__[/* call */ "b"])(_features_common_services_angular_accessor__WEBPACK_IMPORTED_MODULE_2__[/* default */ "b"], 'ConfirmLeaveService');

        case 2:
          confirmLeaveService = _context.sent;
          _context.next = 5;
          return Object(redux_saga_effects__WEBPACK_IMPORTED_MODULE_1__[/* call */ "b"])(confirmLeaveService.requireConfirmation.bind(confirmLeaveService));

        case 5:
        case "end":
          return _context.stop();
      }
    }
  }, _marked);
}
function removeConfirmLeavePopup() {
  var confirmLeaveService;
  return _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_0___default.a.wrap(function removeConfirmLeavePopup$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _context2.next = 2;
          return Object(redux_saga_effects__WEBPACK_IMPORTED_MODULE_1__[/* call */ "b"])(_features_common_services_angular_accessor__WEBPACK_IMPORTED_MODULE_2__[/* default */ "b"], 'ConfirmLeaveService');

        case 2:
          confirmLeaveService = _context2.sent;
          _context2.next = 5;
          return Object(redux_saga_effects__WEBPACK_IMPORTED_MODULE_1__[/* call */ "b"])(confirmLeaveService.disableConfirmation.bind(confirmLeaveService));

        case 5:
        case "end":
          return _context2.stop();
      }
    }
  }, _marked2);
}
function openConfirmationDialog() {
  var confirmLeaveService;
  return _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_0___default.a.wrap(function openConfirmationDialog$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          _context3.next = 2;
          return Object(redux_saga_effects__WEBPACK_IMPORTED_MODULE_1__[/* call */ "b"])(_features_common_services_angular_accessor__WEBPACK_IMPORTED_MODULE_2__[/* default */ "b"], 'ConfirmLeaveService');

        case 2:
          confirmLeaveService = _context3.sent;
          _context3.next = 5;
          return Object(redux_saga_effects__WEBPACK_IMPORTED_MODULE_1__[/* call */ "b"])(confirmLeaveService.openConfirmationDialog.bind(confirmLeaveService));

        case 5:
          return _context3.abrupt("return", _context3.sent);

        case 6:
        case "end":
          return _context3.stop();
      }
    }
  }, _marked3);
}

/***/ }),

/***/ 119:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ReleaseStatusFactory; });
function ReleaseStatusFactory() {
  return {
    isReleaseCompleted: function isReleaseCompleted(release) {
      return release && (release.status === 'COMPLETED' || release.status === 'ABORTED');
    },
    isReleaseAborted: function isReleaseAborted(release) {
      return release && release.status === 'ABORTED';
    },
    isReleasePlanned: function isReleasePlanned(release) {
      return release && release.status === 'PLANNED';
    },
    isReleaseInProgress: function isReleaseInProgress(release) {
      return release && release.status === 'IN_PROGRESS';
    },
    isReleaseFailed: function isReleaseFailed(release) {
      return release && release.status === 'FAILED';
    },
    isReleaseFailing: function isReleaseFailing(release) {
      return release && release.status === 'FAILING';
    },
    isReleasePaused: function isReleasePaused(release) {
      return release && release.status === 'PAUSED';
    },
    hasCompletedStatus: function hasCompletedStatus(release) {
      return release && release.status === 'COMPLETED';
    },
    isTemplate: function isTemplate(release) {
      return release && release.status === 'TEMPLATE';
    },
    isReleaseArchived: function isReleaseArchived(release) {
      return release && release.archived;
    },
    isReleaseActive: function isReleaseActive(release) {
      return release && (release.status === 'IN_PROGRESS' || release.status === "FAILED" || release.status === "FAILING" || release.status === "PAUSED");
    }
  };
}

/***/ }),

/***/ 122:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return fetchDeliveries; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return getDelivery; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return deleteDelivery; });
/* unused harmony export createDelivery */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return createDeliveryFromPattern; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return updateDelivery; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return isDeliveryUpdatable; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return getTrackedItemApprovals; });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(142);


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var RELEASE_DELIVERY_API = 'api/v1/deliveries';
var RELEASE_DELIVERY_PATTERN_API = 'api/v1/delivery-patterns';
var RELEASE_DELIVERY_ACTIVITY_LOGS_INTERNAL_API = 'activity';

function reduceFilters(filters) {
  var keys = _.keys(filters);

  return _.reduce(keys, function (reduced, key) {
    if (_.has(_constants__WEBPACK_IMPORTED_MODULE_2__[/* RELEASE_STATUS_FILTER_KEY_TO_STATUS */ "c"], key)) {
      filters[key] && reduced.statuses.push(_constants__WEBPACK_IMPORTED_MODULE_2__[/* RELEASE_STATUS_FILTER_KEY_TO_STATUS */ "c"][key]);
    } else {
      reduced[key] = filters[key];
    }

    return reduced;
  }, {
    statuses: []
  });
}

function fetchDeliveries(data, pageNumber) {
  var itemsPerPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _constants__WEBPACK_IMPORTED_MODULE_2__[/* ITEMS_PER_PAGE */ "b"];
  var params = {
    resultsPerPage: itemsPerPage,
    page: pageNumber,
    orderBy: (data.orderBy || _constants__WEBPACK_IMPORTED_MODULE_2__[/* DEFAULT_ORDER_BY */ "a"]).toUpperCase()
  };
  var url = "".concat(RELEASE_DELIVERY_API, "/search?") + $.param(params);
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPOST */ "d"])(url, _objectSpread({}, reduceFilters(data)));
}
var getDelivery = function getDelivery(deliveryId) {
  var hideAlert = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpGET */ "c"])("".concat(RELEASE_DELIVERY_API, "/").concat(deliveryId), hideAlert);
};
var deleteDelivery = function deleteDelivery(deliveryId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpDELETE */ "b"])("".concat(RELEASE_DELIVERY_API, "/").concat(deliveryId));
};
var createDelivery = function createDelivery(delivery) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPOST */ "d"])(RELEASE_DELIVERY_API, delivery);
};
var createDeliveryFromPattern = function createDeliveryFromPattern(patternId, delivery) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPOST */ "d"])("".concat(RELEASE_DELIVERY_PATTERN_API, "/").concat(patternId, "/create"), delivery);
};
var updateDelivery = function updateDelivery(delivery) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPUT */ "e"])("".concat(RELEASE_DELIVERY_API, "/").concat(delivery.id), delivery);
};
var isDeliveryUpdatable = function isDeliveryUpdatable(delivery) {
  return delivery && delivery.status !== 'COMPLETED';
};
var getTrackedItemApprovals = function getTrackedItemApprovals(deliveryId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpGET */ "c"])("".concat(RELEASE_DELIVERY_ACTIVITY_LOGS_INTERNAL_API, "/").concat(deliveryId, "/approvals"));
};

/***/ }),

/***/ 133:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return fetchReleases; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return fetchRisks; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return startReleases; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return abortReleases; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return fetchReleaseTags; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return fetchArchivedReleaseTags; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return fetchCount; });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _common_services_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(90);


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var fetchReleases = function fetchReleases(filters, pageNumber) {
  var url = "releases/search?depth=3&numberbypage=".concat(_constants__WEBPACK_IMPORTED_MODULE_2__[/* ITEMS_PER_PAGE */ "c"], "&page=").concat(pageNumber, "&filter=").concat(filters.filter) + '&properties=riskScore&extensions=progress';
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpRequest */ "f"])('POST', url, {
    data: filters
  });
};
var fetchRisks = function fetchRisks(releaseId) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpRequest */ "f"])('GET', "api/v1/risks/".concat(releaseId, "/Risk"));
};
var startReleases = function startReleases(releasesIds) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpRequest */ "f"])('POST', "releases/start", {
    data: releasesIds
  });
};
var abortReleases = function abortReleases(releasesIds, abortComment) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpRequest */ "f"])('POST', "releases/abort", {
    data: {
      releasesIds: releasesIds,
      abortComment: abortComment
    }
  });
};
var fetchReleaseTags = function fetchReleaseTags() {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpGET */ "c"])('releases/tags');
};
var fetchArchivedReleaseTags = function fetchArchivedReleaseTags() {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpGET */ "c"])('releases/tags/archived');
};
var fetchCount = function fetchCount(filters) {
  if (filters.onlyArchived) {
    filters.planned = false;
    filters.inProgress = false;
    filters.failing = false;
    filters.failed = false;
    filters.paused = false;
  }

  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPOST */ "d"])('releases/count', _objectSpread({}, filters, {
    onlyArchived: false
  }));
};

/***/ }),

/***/ 137:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return createEnvironment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return loadEnvironment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return updateEnvironment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return searchEnvironments; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return deleteEnvironment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return getDeployableApplicationsForEnvironment; });
/* harmony import */ var _core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);

var createEnvironment = function createEnvironment(environment) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPOST */ "d"])('api/v1/environments', environment);
};
var loadEnvironment = function loadEnvironment(environmentId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpGET */ "c"])("api/v1/environments/".concat(environmentId)).then(function (response) {
    return response.data;
  });
};
var updateEnvironment = function updateEnvironment(environmentId, environment) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPUT */ "e"])("api/v1/environments/".concat(environmentId), environment);
};
var searchEnvironments = function searchEnvironments(_ref) {
  var title = _ref.title,
      stage = _ref.stage;
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPOST */ "d"])('api/v1/environments/search', {
    title: title,
    stage: stage
  }).then(function (response) {
    return response.data;
  });
};
var deleteEnvironment = function deleteEnvironment(environmentId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpDELETE */ "b"])("api/v1/environments/".concat(environmentId));
};
var getDeployableApplicationsForEnvironment = function getDeployableApplicationsForEnvironment(environmentId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpGET */ "c"])("api/v1/environments/".concat(environmentId, "/applications")).then(function (response) {
    return response.data;
  });
};

/***/ }),

/***/ 142:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return ITEMS_PER_PAGE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return DEFAULT_ORDER_BY; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return RELEASE_STATUS_FILTER_KEY_TO_STATUS; });
/* unused harmony export ENTITY_ID_PLACEHOLDER */
var ITEMS_PER_PAGE = 15;
var DEFAULT_ORDER_BY = 'start_date';
var RELEASE_STATUS_FILTER_KEY_TO_STATUS = {
  inProgress: 'IN_PROGRESS',
  completed: 'COMPLETED'
};
var ENTITY_ID_PLACEHOLDER = -1;

/***/ }),

/***/ 155:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return createStage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return searchStages; });
/* unused harmony export getStage */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return updateStage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return deleteStage; });
/* harmony import */ var _core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);

var createStage = function createStage(stage) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPOST */ "d"])('api/v1/environments/stages', stage);
};
var searchStages = function searchStages(title) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPOST */ "d"])('api/v1/environments/stages/search', {
    title: title
  }).then(function (response) {
    return response.data;
  });
};
var getStage = function getStage(stageId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpGET */ "c"])("api/v1/environments/stages/".concat(stageId)).then(function (response) {
    return response.data;
  });
};
var updateStage = function updateStage(stageId, stage) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPUT */ "e"])("api/v1/environments/stages/".concat(stageId), stage);
};
var deleteStage = function deleteStage(stageId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpDELETE */ "b"])("api/v1/environments/stages/".concat(stageId));
};

/***/ }),

/***/ 16:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return registerRequestInterceptor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return registerResponseInterceptors; });
/* unused harmony export directHttpRequest */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return httpRequest; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return httpCodes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return httpGET; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return httpPOST; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return httpPUT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return httpDELETE; });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(198);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_http_backend__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(212);


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var instance = axios__WEBPACK_IMPORTED_MODULE_1___default.a.create();
var registerRequestInterceptor = function registerRequestInterceptor(requestInterceptor) {
  instance.interceptors.request.use(requestInterceptor, function (error) {
    return error;
  });
};
var registerResponseInterceptors = function registerResponseInterceptors(successInterceptor, errorInterceptor) {
  instance.interceptors.response.use(successInterceptor, errorInterceptor);
};
var directHttpRequest = function directHttpRequest(method, url, config, headers) {
  var requestObject = _objectSpread({}, config, {
    headers: headers,
    method: method,
    url: url
  });

  return instance.request(requestObject);
};
var httpRequest = function httpRequest(method, url, config) {
  var accept = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'application/json';
  var cancelTokenSource = _js_http_backend__WEBPACK_IMPORTED_MODULE_2__[/* Backend */ "a"].cancelTokenSource();
  config = config || {};
  config.cancelToken = cancelTokenSource.token;
  return directHttpRequest(method, "".concat(url), config, {
    'Accept': accept,
    'Accept-Type': accept,
    'X-HTTP-Auth-Override': 'true'
  });
};
var httpCodes = {
  UNAUTHORIZED: 401,
  PAYMENT_REQUIRED: 402,
  FORBIDDEN: 403,
  VERSION_CHANGED: 410
};
function httpGET(url) {
  var hideAlert = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  return httpRequest('GET', url, {
    hideAlert: hideAlert
  });
}
function httpPOST(url, data) {
  return httpRequest('POST', url, {
    data: data
  });
}
function httpPUT(url, data) {
  return httpRequest('PUT', url, {
    data: data
  });
}
function httpDELETE(url, data) {
  return httpRequest('DELETE', url, {
    data: data
  });
}

/***/ }),

/***/ 167:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return searchApp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return createApp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return getApp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return updateApp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return deleteApp; });
/* harmony import */ var _core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);

var searchApp = function searchApp(title) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPOST */ "d"])('api/v1/applications/search', {
    title: title
  }).then(function (resp) {
    return resp.data;
  });
};
var createApp = function createApp(application) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPOST */ "d"])('api/v1/applications', application).then(function (response) {
    return response.data;
  });
};
var getApp = function getApp(applicationId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpGET */ "c"])("api/v1/applications/".concat(applicationId)).then(function (response) {
    return response.data;
  });
};
var updateApp = function updateApp(application) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPUT */ "e"])("api/v1/applications/".concat(application.id), application);
};
var deleteApp = function deleteApp(applicationId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpDELETE */ "b"])("api/v1/applications/".concat(applicationId));
};

/***/ }),

/***/ 174:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return XLRelease; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__);



var XLRelease = function XLRelease() {
  _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, XLRelease);
};

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(XLRelease, "version", '9.7.7');



/***/ }),

/***/ 178:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return TIME_FRAME_TYPES; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return TIME_FRAME_LABELS; });
var TIME_FRAME_TYPES = {
  LAST_MONTH: 'LAST_MONTH',
  LAST_THREE_MONTHS: 'LAST_THREE_MONTHS',
  LAST_SIX_MONTHS: 'LAST_SIX_MONTHS',
  LAST_YEAR: 'LAST_YEAR',
  RANGE: 'RANGE'
};
var TIME_FRAME_LABELS = {
  LAST_MONTH: 'Last 30 days',
  LAST_THREE_MONTHS: 'Last 3 months',
  LAST_SIX_MONTHS: 'Last 6 months',
  LAST_YEAR: 'Last year',
  RANGE: 'Range'
};

/***/ }),

/***/ 1954:
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(2280);
__webpack_require__(2285);
__webpack_require__(2271);
__webpack_require__(2268);
__webpack_require__(2267);
__webpack_require__(2276);
__webpack_require__(2270);
__webpack_require__(2275);
__webpack_require__(2272);
__webpack_require__(2273);
__webpack_require__(2279);
__webpack_require__(2287);
module.exports = __webpack_require__(2288);


/***/ }),

/***/ 1955:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1962:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1963:
/***/ (function(module, exports) {

angular.module('xlrelease.dashboard', ['gridster', 'ui.router', 'mgcrea.ngStrap']).config(['$stateProvider', '$urlMatcherFactoryProvider', function ($stateProvider, $urlMatcherFactoryProvider) {
  $urlMatcherFactoryProvider.type('DashboardId', {
    encode: angular.identity,
    decode: angular.identity,
    pattern: /Applications\/Dashboard\w+/
  });
  $urlMatcherFactoryProvider.type('TileId', {
    encode: angular.identity,
    decode: angular.identity,
    pattern: /Applications\/Dashboard\w+\/Tile\w+/
  });
  $stateProvider.state('defaultDashboard', {
    url: '/dashboards',
    template: '<xlr-dashboard-placeholder sub-menu-items="subMenuItems"></xlr-dashboard-placeholder>'
  }).state('dashboards', {
    url: '/dashboards/{dashboardId: DashboardId}?dashboardMode&{refresh:bool}',
    template: '<div xlr-dashboard></div>'
  }).state('folderDashboards', {
    url: '/folders-dashboards/{dashboardId: DashboardId}?dashboardMode&folderId&{refresh:bool}',
    template: '<div xlr-dashboard></div>'
  }).state('folderDashboardsNew', {
    url: '/folders-dashboards/new?folderId',
    template: '<xlr-add-dashboard-page></xlr-add-dashboard-page>'
  }).state('globalDashboardNew', {
    url: '/dashboards/new',
    template: '<xlr-add-dashboard-page></xlr-add-dashboard-page>'
  }).state('globalDashboardDetails', {
    url: '/dashboards/{tileId: TileId}/details',
    templateUrl: 'static/9.7.7/include/DashboardPage/xlr-dashboard-details-mode.html',
    controller: 'xlrelease.dashboard.XlrTileDetailsController',
    controllerAs: 'xlrTileDetailsCtrl',
    resolve: {
      tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService) {
        return XlrDashboardService.loadTile($stateParams.tileId);
      }],
      dashboardPromise: [_.noop],
      releasePromise: [_.noop]
    }
  }).state('folderDashboardDetails', {
    url: '/folders-dashboards/{tileId: TileId}/details',
    templateUrl: 'static/9.7.7/include/DashboardPage/xlr-dashboard-details-mode.html',
    controller: 'xlrelease.dashboard.XlrTileDetailsController',
    controllerAs: 'xlrTileDetailsCtrl',
    resolve: {
      tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', function ($stateParams, XlrDashboardService) {
        return XlrDashboardService.loadTile($stateParams.tileId);
      }],
      dashboardPromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService, Ids) {
        return XlrDashboardService.loadConfiguration(Ids.getParentId($stateParams.tileId));
      }],
      releasePromise: [_.noop]
    }
  }).state('releasesDashboard', {
    url: '/releases/:releaseId/summary/:tileId/details',
    templateUrl: 'static/9.7.7/include/DashboardPage/xlr-dashboard-details-mode.html',
    controller: 'xlrelease.dashboard.XlrTileDetailsController',
    controllerAs: 'xlrTileDetailsCtrl',
    resolve: {
      tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService, Ids) {
        return XlrDashboardService.loadTile(Ids.toDomainId($stateParams.releaseId) + '/summary/' + $stateParams.tileId);
      }],
      dashboardPromise: [_.noop],
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getReleaseWithDependencies($stateParams.releaseId);
      }]
    }
  }).state('templatesDashboard', {
    url: '/templates/:releaseId/summary/:tileId/details',
    templateUrl: 'static/9.7.7/include/DashboardPage/xlr-dashboard-details-mode.html',
    controller: 'xlrelease.dashboard.XlrTileDetailsController',
    controllerAs: 'xlrTileDetailsCtrl',
    resolve: {
      tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService, Ids) {
        return XlrDashboardService.loadTile(Ids.toDomainId($stateParams.releaseId) + '/summary/' + $stateParams.tileId);
      }],
      dashboardPromise: [_.noop],
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getReleaseWithDependencies($stateParams.releaseId);
      }]
    }
  });
}]);
angular.module('xlrelease.dashboard').factory('xlrDashboardConfigProvider', function () {
  return {
    getPlaceholderProperties: function getPlaceholderProperties() {
      return {
        draggable: {
          enabled: false
        },
        resizable: {
          enabled: false
        }
      };
    },
    getConfig: function getConfig(designMode, changeCallback) {
      return {
        minSizeY: 1,
        minSizeX: 1,
        defaultSizeX: 1,
        defaultSizeY: 1,
        pushing: true,
        floating: true,
        // whether to automatically float items up so they stack (you can temporarily disable if you are adding unsorted items with ng-repeat)
        swapping: true,
        // whether or not to have items of the same size switch places instead of pushing down if they are the same size
        colWidth: 'auto',
        minRows: 1,
        rowHeight: 290,
        margins: [10, 10],
        mobileBreakPoint: 60,
        resizable: {
          enabled: designMode,
          handles: ['n', 'e', 's', 'w', 'ne', 'se', 'sw', 'nw'],
          start: function start(event, $element) {
            $element.addClass('dashboard-resizing');
          },
          stop: function stop(event, $element) {
            $element.removeClass('dashboard-resizing');
            changeCallback();
          }
        },
        draggable: {
          enabled: designMode,
          handle: '.xlr-tile-drag-handle',
          stop: function stop() {
            return changeCallback();
          }
        }
      };
    }
  };
});
angular.module('xlrelease').run(['MenuItemsProviderRegistry', 'Backend', '$state', function (MenuItemsProviderRegistry, Backend, $state) {
  MenuItemsProviderRegistry.addProvider('xlrelease.dashboard.provider', function () {
    return Backend.get('dashboards').then(function (resp) {
      var dashboards = resp.data.map(function (dashboard) {
        return {
          label: dashboard.title,
          pathSuffix: "dashboards/".concat(dashboard.id),
          permitted: true
        };
      });

      if ($state.is('globalDashboardNew')) {
        dashboards.push({
          label: 'New dashboard',
          pathSuffix: "dashboards/new",
          permitted: true
        });
      }

      return dashboards;
    });
  });
}]);

/***/ }),

/***/ 1964:
/***/ (function(module, exports) {

var XlrTileTitle = function XlrTileTitle() {
  return {
    restrict: 'A',
    require: ['^xlrTile'],
    transclude: true,
    link: function link(scope, elem, attr, ctrls, transclude) {
      _.head(ctrls).setTitle(transclude);
    }
  };
};

angular.module('xlrelease.dashboard').directive('xlrTileTitle', XlrTileTitle);

/***/ }),

/***/ 1965:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1966:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1967:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1968:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1969:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1970:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1971:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1972:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1973:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1974:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 1978:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2040:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2041:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2042:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2043:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2044:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2045:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2046:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2047:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2048:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2049:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2050:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2051:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2052:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 209:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return NoData; });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(0);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _no_data_less__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(486);
/* harmony import */ var _no_data_less__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_no_data_less__WEBPACK_IMPORTED_MODULE_2__);



var NoData = function NoData(_ref) {
  var className = _ref.className,
      message = _ref.message;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: 'no-data-message' + (className ? " ".concat(className) : '')
  }, message);
};
NoData.propTypes = {
  className: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.string,
  message: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.node.isRequired
};

/***/ }),

/***/ 212:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Backend; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(41);
/* harmony import */ var angular__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(angular__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var ngimport__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(84);
/* harmony import */ var ngimport__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(ngimport__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _xlrelease__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(174);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(198);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_6__);




function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }





var Backend;

var BackendServiceImpl = /*#__PURE__*/function () {
  function BackendServiceImpl() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, BackendServiceImpl);

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2___default()(this, "canceller", ngimport__WEBPACK_IMPORTED_MODULE_4__["$q"].defer());

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2___default()(this, "_cancelTokenSource", axios__WEBPACK_IMPORTED_MODULE_6___default.a.CancelToken.source());
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(BackendServiceImpl, [{
    key: "post",
    value: function post(url, data, config) {
      if (Object(angular__WEBPACK_IMPORTED_MODULE_3__["isUndefined"])(data)) {
        data = {};
      }

      return ngimport__WEBPACK_IMPORTED_MODULE_4__["$http"].post(url, data, this._extendWithTimeout(url, config));
    }
  }, {
    key: "get",
    value: function get(url, config) {
      return ngimport__WEBPACK_IMPORTED_MODULE_4__["$http"].get(url, this._extendWithTimeout(url, this._extendWithVersion(this._extendWithCacheBuster(config))));
    }
  }, {
    key: "put",
    value: function put(url, data, config) {
      if (Object(angular__WEBPACK_IMPORTED_MODULE_3__["isUndefined"])(data)) {
        data = {};
      }

      return ngimport__WEBPACK_IMPORTED_MODULE_4__["$http"].put(url, data, this._extendWithTimeout(url, this._extendWithVersion(config)));
    }
  }, {
    key: "del",
    value: function del(url, config) {
      var extendedConfig = Object(angular__WEBPACK_IMPORTED_MODULE_3__["extend"])({}, BackendServiceImpl.DELETE_CONFIG, config);
      extendedConfig.url = url;
      return Object(ngimport__WEBPACK_IMPORTED_MODULE_4__["$http"])(this._extendWithTimeout(url, this._extendWithVersion(extendedConfig)));
    } // overridden in unit tests

  }, {
    key: "_extendWithCacheBuster",
    value: function _extendWithCacheBuster(config) {
      var cacheBuster = {
        cb: new Date().getTime()
      };
      return this.addParams(config, cacheBuster);
    }
  }, {
    key: "_extendWithVersion",
    value: function _extendWithVersion(config) {
      var version = {
        xlrv: _xlrelease__WEBPACK_IMPORTED_MODULE_5__[/* default */ "a"].version
      };
      return this.addParams(config, version);
    }
  }, {
    key: "_extendWithTimeout",
    value: function _extendWithTimeout(url, config) {
      if ((config === null || config === void 0 ? void 0 : config.timeout) != null) {
        return config;
      } else {
        return _objectSpread({}, config, {
          timeout: this.canceller.promise
        });
      }
    }
  }, {
    key: "addParams",
    value: function addParams(config, params) {
      var extendedConfig = config ? Object(angular__WEBPACK_IMPORTED_MODULE_3__["copy"])(config) : {};
      extendedConfig.params = Object(angular__WEBPACK_IMPORTED_MODULE_3__["extend"])({}, extendedConfig.params || {}, params);
      return extendedConfig;
    }
  }, {
    key: "cancel",
    value: function cancel() {
      this._cancelTokenSource.cancel("Cancelled by backend");

      this._cancelTokenSource = axios__WEBPACK_IMPORTED_MODULE_6___default.a.CancelToken.source();
      this.canceller.resolve("Cancelled");
      this.canceller = ngimport__WEBPACK_IMPORTED_MODULE_4__["$q"].defer();
    }
  }, {
    key: "cancelTokenSource",
    value: function cancelTokenSource() {
      return this._cancelTokenSource;
    }
  }]);

  return BackendServiceImpl;
}();

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2___default()(BackendServiceImpl, "DELETE_CONFIG", {
  method: 'DELETE',
  // IE 8 do not support $http.delete()
  data: null,
  // Without data, Content-Type is deleted
  headers: {
    'Content-Type': 'application/json' // Without Content-Type, Browser's default Content-Type is used

  }
});

Object(angular__WEBPACK_IMPORTED_MODULE_3__["module"])('xlrelease').service('Backend', BackendServiceImpl);
Object(angular__WEBPACK_IMPORTED_MODULE_3__["module"])('xlrelease').run(function () {
  return Backend = ngimport__WEBPACK_IMPORTED_MODULE_4__["$injector"].get('Backend');
});

/***/ }),

/***/ 213:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/constants.js
var angularJsDateFormatToMomentFormat = {
  'd/M/yy': 'D/M/YY',
  'M/d/yy': 'M/D/YY',
  'dd/MM/yy': 'DD/MM/YY',
  'yy/MM/dd': 'YY/MM/DD',
  'MMM d, y': 'MMM DD, YYYY',
  'dd MMM y': 'DD MMM YYYY',
  'y MMM dd': 'YYYY MMM DD'
};
var angularJsTimeFormatToMomentFormat = {
  'HH:mm': 'HH:mm',
  'h:mm a': 'h:mm A'
};
// EXTERNAL MODULE: ./node_modules/moment/moment.js-exposed
var moment_js_exposed = __webpack_require__(43);
var moment_js_exposed_default = /*#__PURE__*/__webpack_require__.n(moment_js_exposed);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/utils.js
/* unused harmony export parseDateTimeFormat */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return formatDateTime; });


function parseDateTimeFormat(date, dateFormat, timeFormat) {
  var format = "".concat(dateFormat, " ").concat(timeFormat);

  if (angularJsDateFormatToMomentFormat[dateFormat]) {
    format = "".concat(angularJsDateFormatToMomentFormat[dateFormat]);

    if (angularJsTimeFormatToMomentFormat[timeFormat]) {
      format = "".concat(format, " ").concat(angularJsTimeFormatToMomentFormat[timeFormat]);
    } else {
      format = "".concat(format, " ").concat(timeFormat);
    }
  } else {
    // can't find an appropriate format, use default
    format = "YYYY-MM-DD h:mm A";
  }

  return format;
}
function formatDateTime(date, dateFormat, timeFormat) {
  return moment_js_exposed_default()(date).format(parseDateTimeFormat(date, dateFormat, timeFormat));
}

/***/ }),

/***/ 214:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return showError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return showServerDownError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AlertsFactory; });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(193);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_isFunction__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(89);
/* harmony import */ var lodash_isFunction__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_isFunction__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util_toastrFactory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(51);
/* harmony import */ var pluralize__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(76);
/* harmony import */ var pluralize__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(pluralize__WEBPACK_IMPORTED_MODULE_3__);





function getResponseData(response) {
  var contentType = getHeader(response, 'content-type');

  if (contentType && !contentType.includes('text/html')) {
    if (response.data instanceof Blob) {
      return 'Requested file is not found';
    }

    if (getHeader(response, 'x-validation-exception', "false") === "true") {
      return extractValidationMessages(response);
    }

    return response.data;
  }

  return '';
}

function extractValidationMessages(response) {
  var validationMessages = response.data["validation-messages"];
  var messages = validationMessages.map(function (item) {
    return "<p>".concat(item.message, "</p>");
  });
  return "There ".concat(pluralize__WEBPACK_IMPORTED_MODULE_3___default()('was', validationMessages.length), " ").concat(validationMessages.length, " validation ").concat(pluralize__WEBPACK_IMPORTED_MODULE_3___default()('error', validationMessages.length), ". ").concat(messages.join(""));
}

function getHeader(response, headerName) {
  var defaultVal = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';

  //we need this logic because we are still using different approaches to call a server
  if (lodash_isFunction__WEBPACK_IMPORTED_MODULE_1___default()(response.headers)) {
    //this is true for calls from $http
    return lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(response.headers(), headerName, defaultVal);
  } else {
    return lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(response.headers, headerName, defaultVal); //this is true for calls from axios
  }
}

function getAlertMsg(response) {
  var responseData = getResponseData(response);
  var path = getHeader(response, 'x-path', response.config.url);
  var date = getHeader(response, 'date');
  return "\n        <div class='alert-details'>\n            <p>".concat(responseData, "</p>\n            <p>Status code: ").concat(response.status, "</p>\n            <p><strong>").concat(response.config.method, " ").concat(path, "</strong></p>\n            <p>").concat(date, "</p>\n        </div>").split('\n').join('');
}

var toaster = Object(_js_util_toastrFactory__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])();
function showError(response) {
  toaster.error(getAlertMsg(response), 'An error occurred', {
    escapeHtml: false
  });
}
function showServerDownError() {
  toaster.error('The Release server is not available', 'An error occurred');
}
function AlertsFactory() {
  return {
    error: showError,
    serverDownError: showServerDownError
  };
}

/***/ }),

/***/ 216:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return createLabel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return searchLabels; });
/* unused harmony export getLabel */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return updateLabel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return deleteLabel; });
/* harmony import */ var _core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);

var createLabel = function createLabel(envLabel) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPOST */ "d"])('api/v1/environments/labels', envLabel);
};
var searchLabels = function searchLabels(title) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPOST */ "d"])('api/v1/environments/labels/search', {
    title: title
  }).then(function (response) {
    return response.data;
  });
};
var getLabel = function getLabel(envLabelId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpGET */ "c"])("api/v1/environments/labels/".concat(envLabelId)).then(function (response) {
    return response.data;
  });
};
var updateLabel = function updateLabel(envLabelId, envLabel) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPUT */ "e"])("api/v1/environments/labels/".concat(envLabelId), envLabel);
};
var deleteLabel = function deleteLabel(envLabelId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpDELETE */ "b"])("api/v1/environments/labels/".concat(envLabelId));
};

/***/ }),

/***/ 2175:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2177:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2178:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2179:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2182:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2183:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2184:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2185:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2195:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2196:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2197:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2198:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2199:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2200:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2201:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2202:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2203:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2204:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2205:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2206:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2207:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2208:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2209:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2210:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2211:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2212:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2213:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2214:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2215:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2216:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2217:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2218:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('donutChart', ['reportConfigurationService', 'Events', function (reportConfigurationService, Events) {
  return {
    scope: {
      data: '=',
      options: '='
      /*
      topTitleText: Text/Function(scope.data)
      bottomTitleText: Text/Function(scope.data)
      series: Function(scope.data) => [{name: 'Tasks', data: [...]}]
      showLegend: true/false
      donutThickness: 70%
      */

    },
    link: function link(scope, element) {
      var chart = [];

      function addTitle() {
        if (this.title) {
          this.title.destroy();
        } // store chart so we can trigger when draw when the file finished resizing


        chart = this;
        var r = this.renderer,
            x = this.series[0].center[0] + this.plotLeft,
            y = this.series[0].center[1] + this.plotTop;
        var topTitleText = applyOrGet(scope.options.topTitleText, scope.data);
        var bottomTitleText = applyOrGet(scope.options.bottomTitleText, scope.data);
        var titleHtml = "<div><span>" + topTitleText + "</span><br><span>" + bottomTitleText + "</span></div>";
        this.title = r.label(titleHtml, x - 53, y - 12, 'rect', 0, 0, true, true, 'two-part-title').add();
        chart.container.onclick = null;
      }

      function applyOrGet(textOrFunction, args) {
        return angular.isFunction(textOrFunction) ? textOrFunction(args) : "" + textOrFunction;
      }

      var series = scope.options.series(scope.data);
      series.forEach(function (serie) {
        serie.type = 'pie';
        serie.dataLabels = {
          enabled: false
        };
      });
      element.highcharts(reportConfigurationService.getHighchartsOptions({
        tooltip: {
          hideDelay: 0
        },
        chart: {
          events: {
            load: addTitle,
            redraw: addTitle
          }
        },
        plotOptions: {
          pie: {
            showInLegend: scope.options.showLegend,
            allowPointSelect: false,
            innerSize: scope.options.donutThickness,
            borderWidth: 0,
            point: {
              events: {
                legendItemClick: function legendItemClick(e) {
                  e.preventDefault();
                }
              }
            }
          }
        },
        title: {
          text: "",
          floating: true
        },
        series: series
      }));
      scope.$on(Events.tile.resized, function () {
        chart.reflow();
      });
    }
  };
}]);

/***/ }),

/***/ 2219:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2220:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2221:
/***/ (function(module, exports) {

var ReleaseProgressTileViewController = function ReleaseProgressTileViewController($scope, ReleasesService, TasksService, Planner, RegionalSettings) {
  var vm = this;
  vm.isReleaseCompleted = isReleaseCompleted;
  vm.refresh = refresh;
  vm.release = $scope.release;
  vm.getStatus = getStatus;
  vm.calculateDelay = calculateDelay;
  vm.mediumDateFormat = RegionalSettings.currentMediumDateFormat;
  vm.chartOptions = {
    topTitleText: function topTitleText(data) {
      return data.completed + "/" + (data.completed + data.planned);
    },
    bottomTitleText: "tasks",
    legend: {
      borderRadius: 0
    },
    series: function series(data) {
      return [{
        name: 'Tasks',
        data: [{
          y: data.completed,
          name: "Completed",
          color: "#498500"
        }, {
          y: data.planned,
          name: "Planned",
          color: "#DDD"
        }]
      }];
    },
    showLegend: true,
    donutThickness: '90%'
  }; ///

  refresh();

  function refresh() {
    var flattenedTasks = ReleasesService.getLeafTasks(vm.release);
    var completedTasks = calculateCompletedTasks(flattenedTasks);
    vm.chartData = {
      completed: completedTasks.length,
      planned: flattenedTasks.length - completedTasks.length
    };
    vm.progress = calculateProgress(completedTasks.length, flattenedTasks.length);
    vm.estimatedEndDate = calculateEstimatedEndDate(vm.release);
  }

  function isReleaseCompleted() {
    return ReleasesService.isReleaseCompleted(vm.release);
  }

  function calculateCompletedTasks(tasks) {
    return _.filter(tasks, TasksService.isTaskReadOnly);
  }

  function calculateProgress(completed, total) {
    var progress = 0;

    if (angular.isNumber(completed) && angular.isNumber(total) && total !== 0) {
      progress = completed / total * 100;
    }

    return progress;
  }

  function calculateEstimatedEndDate(release) {
    Planner.setRelease(release);
    Planner.setReleaseTree(release.tree);
    var plan = Planner.makePlan(false);
    return plan.plannedEndDate;
  }

  function calculateDelay() {
    return moment.duration(vm.estimatedEndDate.diff(moment(vm.release.dueDate)));
  }

  function getStatus() {
    var status = "";

    if (isAborted()) {
      status = "ABORTED";
    } else if (isOnTime()) {
      status = "ON_TIME";
    } else {
      status = "DELAYED";
    }

    return status;
  }

  function isOnTime() {
    return !vm.estimatedEndDate.isAfter(moment(vm.release.dueDate));
  }

  function isAborted() {
    return ReleasesService.isReleaseAborted(vm.release);
  }
};

ReleaseProgressTileViewController.$inject = ['$scope', 'ReleasesService', 'TasksService', 'Planner', 'RegionalSettings'];
angular.module('xlrelease').controller('summary.ReleaseProgressTileViewController', ReleaseProgressTileViewController);

/***/ }),

/***/ 2222:
/***/ (function(module, exports) {

var ReleaseSummaryPageController = function ReleaseSummaryPageController($scope, ReleasesService, TasksService) {
  var vm = this;
  var xlrDashboard = $scope.xlrDashboard;
  vm.release = xlrDashboard.release;
  vm.isReleaseInProgress = ReleasesService.isReleaseInProgress;
  vm.isReleaseFailing = ReleasesService.isReleaseFailing;
  vm.isReleasePaused = ReleasesService.isReleasePaused;
  vm.isReleaseFailed = ReleasesService.isReleaseFailed;
  vm.isReleasePlanned = ReleasesService.isReleasePlanned;
  vm.isReleaseAborted = ReleasesService.isReleaseAborted;
  vm.isReleaseCompleted = ReleasesService.isReleaseCompleted;
  vm.hasCompletedStatus = ReleasesService.hasCompletedStatus;
  vm.isReleaseArchived = ReleasesService.isReleaseArchived;
  vm.flattenedTasks = ReleasesService.getLeafTasks(vm.release);
  vm.numberOfCompletedTasks = _.filter(vm.flattenedTasks, TasksService.isTaskReadOnly).length;
};

ReleaseSummaryPageController.$inject = ['$scope', 'ReleasesService', 'TasksService'];
angular.module('xlrelease').controller('summary.ReleaseSummaryPageController', ReleaseSummaryPageController);

/***/ }),

/***/ 2223:
/***/ (function(module, exports) {

var ReleaseSummaryTileViewController = function ReleaseSummaryTileViewController($scope, DateService) {
  var vm = this;
  var release = $scope.release;
  vm.isOverdue = DateService.isOverdue;
  vm.variables = release.variables;
  refresh();

  function refresh() {
    vm.releaseCurrentPhase = getActivePhase(release);
    vm.startDate = getStartDate(release);
    vm.dueDate = getDueDate(release);
    vm.releaseDuration = getDuration(release);
    vm.owner = release.owner;
  }

  function getActivePhase(release) {
    var activePhase = _.filter(release.phases, {
      'active': true
    });

    if (activePhase && activePhase.length > 0) {
      return activePhase[0].title;
    }

    return "Not started";
  }

  function getStartDate(release) {
    return DateService.getStartOrScheduledDate(release);
  }

  function getDueDate(release) {
    return DateService.getEndOrDueDate(release);
  }

  function getDuration(release) {
    var start = DateService.getStartOrScheduledDate(release);
    var end = DateService.getEndOrDueDate(release);
    return start && end && end >= start ? end - start : undefined;
  }
};

ReleaseSummaryTileViewController.$inject = ['$scope', 'DateService'];
angular.module('xlrelease').controller('summary.ReleaseSummaryTileViewController', ReleaseSummaryTileViewController);

/***/ }),

/***/ 2224:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('statusBadge', function () {
  return {
    restrict: 'E',
    scope: {
      status: '='
    },
    template: '<span class="label {{badge.style}}">{{ badge.message }}</span>',
    link: function link($scope) {
      var badgesStyle = [];
      badgesStyle.NOT_FOUND = {
        style: 'label label-warning-failed',
        message: 'Not found'
      };
      badgesStyle.IN_PROGRESS = {
        style: 'label label-active',
        message: 'In progress'
      };
      badgesStyle.COMPLETED = {
        style: 'label label-completed',
        message: 'Completed'
      };
      badgesStyle.FAILED = {
        style: 'label label-warning-failed',
        message: 'Failed'
      };
      badgesStyle.FAILING = {
        style: 'label label-warning-failing',
        message: 'Failing'
      };
      badgesStyle.WAITING_FOR_INPUT = {
        style: 'label label-waiting',
        message: 'Needs input'
      };
      badgesStyle.PLANNED = {
        style: 'label label-planned',
        message: 'Planned'
      };
      badgesStyle.PENDING = {
        style: 'label label-pending',
        message: 'Pending'
      };
      badgesStyle.SKIPPED = {
        style: 'label label-default',
        message: 'Skipped'
      };
      badgesStyle.PAUSED = {
        style: 'label label-paused',
        message: 'Paused'
      };
      badgesStyle.ABORTED = {
        style: 'label label-aborted',
        message: 'Aborted'
      };
      badgesStyle.PRECONDITION_IN_PROGRESS = {
        style: 'label label-preconditioninprogress',
        message: 'Precondition'
      };
      badgesStyle.COMPLETED_IN_ADVANCE = {
        style: 'label label-completed',
        message: 'Completed'
      };
      badgesStyle.SKIPPED_IN_ADVANCE = {
        style: 'label label-default',
        message: 'Skipped'
      };
      badgesStyle.FAILURE_HANDLER_IN_PROGRESS = {
        style: 'label label-warning-failing',
        message: 'Handling failure'
      };
      badgesStyle.FACET_CHECK_IN_PROGRESS = {
        style: 'label label-preconditioninprogress',
        message: 'Verifying'
      };
      $scope.badge = badgesStyle[$scope.status.toUpperCase()];
    }
  };
});

/***/ }),

/***/ 2225:
/***/ (function(module, exports) {

var XlrTimelineDirectiveControllerInject = ['ColorService', 'DateService', 'RegionalSettings', '$filter'];

var XlrTimelineDirectiveController = function XlrTimelineDirectiveController(ColorService, DateService, RegionalSettings, $filter) {
  var vm = this;
  vm._$filter = $filter;
  vm.elapsedWidth = 0;
  vm.plannedWidth = 0;
  vm.estimatedWidth = 0;
  vm.delayWidth = 0;
  vm.timeline = {};
  vm.phases = [];
  vm.timelineHeight = 30;
  vm.phasesMargin = 85;
  vm.outgoingDependencies = [];
  vm.incomingDependencies = [];
  vm.showTimeIndicator = false;
  vm.redrawTimeline = redrawTimeline;
  vm.init = init;

  vm.buildReleaseLink = function (releaseId) {
    return "#/releases/".concat(releaseId, "/summary");
  };

  var CHARACTER_WIDTH = 8;
  var TIMELINE = {
    QUARTER_OF_HOUR: 15,
    HOURS_IN_A_DAY: 24,
    DAYS_IN_A_WEEK: 7,
    DAYS_IN_MONTH: 30
  };
  var METRICS = {
    MINUTES: 'minutes',
    HOURS: 'hours',
    DAYS: 'days',
    WEEKS: 'weeks',
    MONTHS: 'months'
  };
  var TIMELINE_FORMATS = {
    HOURS: function HOURS() {
      return RegionalSettings.currentTimeFormat.replace('mm', '00');
    },
    DAYS: function DAYS() {
      return RegionalSettings.currentDateFormat;
    },
    MONTHS: _.constant('MMM yyyy')
  };
  var COMPARE_FORMAT = {
    HOURS: 'YYYY-MM-DD HH',
    DAYS: 'YYYY-MM-DD'
  };
  var STEP_INDENT = 5;
  var day = 24;
  var week = 168;
  var month = 672;

  function redrawTimeline(width, height) {
    if (vm.timelineData.timeline && width) {
      vm.timelineWidth = Math.ceil(width);
      vm.timelineHeight = height;
      vm.elapsedWidth = 0;
      vm.plannedWidth = 0;
      vm.delayWidth = 0;
      vm.timeline = {};
      vm.showTimeIndicator = vm.timelineData.timeline.release.status === 'IN_PROGRESS' || vm.timelineData.timeline.release.status === 'PLANNED';
      vm.phases = [];
      drawTimeline(vm.timelineData.timeline);
    }
  }

  function init(width, height) {
    redrawTimeline(width, height);
  }

  function buildPhase(phases, release) {
    var currentPhaseX = 0;
    return _.map(phases, function (phase) {
      phase.color = ColorService.computePhaseColor(release, phase);
      var calculatedPhaseX = getPhaseX(phase, vm.timeline);

      if (calculatedPhaseX < currentPhaseX) {
        phase.x = currentPhaseX;
        var widthDiff = currentPhaseX - calculatedPhaseX;
        phase.width = getPhaseWidth(phase, vm.timeline) - widthDiff;
      } else {
        phase.x = calculatedPhaseX;
        phase.width = getPhaseWidth(phase, vm.timeline);
      }

      phase.shortTitle = calculateShortTitle(phase.plainTitle ? phase.plainTitle : phase.title, phase.width);
      currentPhaseX = phase.x + phase.width;
      return phase;
    });
  }

  function buildTimelinePeriods(startDay, format, timelineScale, containerSize) {
    var timeline = [];

    for (var i = 0; i < containerSize; i++) {
      timeline.push({
        title: vm._$filter('date')(startDay.toDate(), format)
      });
      startDay = startDay.add(1, timelineScale);
    }

    return timeline;
  }

  function buildContainer(startDay, endDay, timelineScale) {
    var container = {};
    var timelineStart = moment(startDay.format(COMPARE_FORMAT.DAYS));
    var timelineEnd = moment(endDay.format(COMPARE_FORMAT.DAYS));
    container.stepUnit = 1;
    container[timelineScale] = [];
    container.size = Math.ceil(timelineEnd.diff(timelineStart, timelineScale, true) + 1);

    switch (timelineScale) {
      case METRICS.HOURS:
        container.segments = TIMELINE.QUARTER_OF_HOUR;
        container.minimalMetric = METRICS.MINUTES;
        container.stepUnit = 4;
        timelineStart = moment(startDay.format(COMPARE_FORMAT.HOURS));
        timelineEnd = moment(endDay.format(COMPARE_FORMAT.HOURS));
        container.size = Math.ceil(timelineEnd.diff(timelineStart, timelineScale, true) + 1);
        container[timelineScale] = buildTimelinePeriods(startDay, TIMELINE_FORMATS.HOURS(), timelineScale, container.size);
        break;

      case METRICS.DAYS:
        container.segments = TIMELINE.HOURS_IN_A_DAY;
        container.minimalMetric = METRICS.HOURS;
        container[timelineScale] = buildTimelinePeriods(startDay, TIMELINE_FORMATS.DAYS(), timelineScale, container.size);
        break;

      case METRICS.WEEKS:
        container.segments = TIMELINE.DAYS_IN_A_WEEK;
        container.minimalMetric = METRICS.DAYS;
        container[timelineScale] = buildTimelinePeriods(startDay, TIMELINE_FORMATS.DAYS(), timelineScale, container.size);
        break;

      case METRICS.MONTHS:
        timelineStart = DateService.getTodayWithTime().year(startDay.year()).month(startDay.month()).date(startDay.date());
        timelineEnd = moment(endDay.endOf('month'));
        container.size = Math.ceil(timelineEnd.diff(timelineStart, timelineScale, true) + 1);
        container.segments = TIMELINE.DAYS_IN_MONTH;
        container.minimalMetric = METRICS.DAYS;
        container[timelineScale] = buildTimelinePeriods(startDay, TIMELINE_FORMATS.MONTHS(), timelineScale, container.size);
        break;

      default:
        throw 'Unknown timeline scale';
    }

    container.timelineStart = timelineStart;
    container.timelineEnd = timelineEnd;
    container.metric = timelineScale;
    return container;
  }

  function drawTimeline(data) {
    if (!data || data.startDate === null || data.expectedEndDate === null) return;
    var startDay = data.startDate.clone();
    var endDay = data.expectedEndDate.clone();
    var detectMetric = calculateMetrics(startDay, endDay);
    vm.timeline = createTimeline(detectMetric);
    vm.phases = buildPhase(data.phases, data.release);
    vm.elapsedWidth = getElapsedSectionWidth(vm.timeline);
    vm.delayX = getPlannedSectionWidth(data.endDate, vm.timeline);
    vm.estimatedWidth = getPlannedSectionWidth(data.expectedEndDate, vm.timeline) - vm.phases[0].x;
    var delay = getDelaySectionWidth(data.endDate, data.expectedEndDate, vm.timeline) - vm.delayX;
    vm.delayWidth = delay > 0 ? delay : 0;
    vm.incomingDependencies = buildReleasesViews(vm.timelineData.incomingDependencies);
    vm.outgoingDependencies = buildReleasesViews(vm.timelineData.outgoingDependencies);

    if (vm.isDetailsView) {
      vm.phasesMargin = calculatePhaseMargin();
      vm.timelineHeight = calculateHeight();
    }
  }

  function calculateShortTitle(title, width) {
    if (title) {
      var actual = title;
      var maxLengthOfString = width / CHARACTER_WIDTH;

      if (actual.length > maxLengthOfString) {
        actual = actual.substring(0, maxLengthOfString);
        actual = actual + '...';
      }

      return actual;
    }
  }

  function calculateHeight() {
    var initialHeight = 250;
    var inLength = vm.incomingDependencies.length;

    if (inLength > 2) {
      initialHeight += inLength * 30;
    }

    var outLength = vm.outgoingDependencies.length;

    if (outLength > 2) {
      var delta = outLength - 2;
      initialHeight += delta * 30;
    }

    return initialHeight;
  }

  function calculatePhaseMargin() {
    var initialMargin = 120;
    var inLength = vm.incomingDependencies.length;

    if (inLength > 2) {
      var delta = inLength - 2;
      return initialMargin + delta * 30;
    }

    return initialMargin;
  }

  function calculateMetrics(startDay, endDay) {
    var container = {};
    var diff = endDay.diff(startDay, 'hours');

    if (diff < day * 1.5) {
      return buildContainer(startDay, endDay, 'hours');
    }

    if (diff >= day * 1.5 && diff < week * 3) {
      return buildContainer(startDay, endDay, 'days');
    }

    if (diff >= week * 3 && diff < month * 3) {
      return buildContainer(startDay, endDay, 'weeks');
    }

    if (diff >= month * 3) {
      return buildContainer(startDay, endDay, 'months');
    }

    return container;
  }

  function buildReleasesViews(releases) {
    return _.map(releases, function (release) {
      var releaseCoordinateX = getReleaseX(moment(release.startDate), moment(release.scheduledStartDate));
      var releaseWidth = getReleaseWidth(moment(release.startDate), moment(release.scheduledStartDate), moment(release.endDate), moment(release.dueDate));
      var actualWidth = releaseCoordinateX + releaseWidth > vm.timelineWidth ? vm.timelineWidth - releaseCoordinateX : releaseWidth;
      return {
        id: release.releaseId,
        xCord: releaseCoordinateX,
        width: actualWidth,
        title: release.releaseTitle,
        shortTitle: calculateShortTitle(release.releaseTitle, actualWidth - 30)
      };
    });
  }

  function getReleaseX(startDate, estimatedStartDate) {
    var start = startDate;

    if (!startDate.isValid()) {
      start = estimatedStartDate;
    }

    if (angular.isDefined(vm.timeline.start) && angular.isDefined(start) && start.isAfter(vm.timeline.start)) {
      var time = start.diff(vm.timeline.start, vm.timeline.minimalMetric, true);
      return time * vm.timeline.step / vm.timeline.unit;
    }

    return 0;
  }

  function getReleaseWidth(startDate, estimatedStartDate, endDate, estimatedDueDate) {
    var start = startDate;
    var end = endDate;

    if (startDate && !startDate.isValid()) {
      start = estimatedStartDate;
    }

    if (endDate && !endDate.isValid()) {
      end = estimatedDueDate;
    }

    if (angular.isDefined(vm.timeline.start) && angular.isDefined(start) && angular.isDefined(end)) {
      var time = end.diff(start, vm.timeline.minimalMetric, true);
      return time * vm.timeline.step / vm.timeline.unit;
    }

    return 0;
  }

  function getPhaseWidth(phase, timeline) {
    if (angular.isDefined(timeline.start) && angular.isDefined(phase.startDate)) {
      var time = phase.endDate.diff(phase.startDate, timeline.minimalMetric, true);
      return time * timeline.step / timeline.unit;
    }

    return 0;
  }

  function getPhaseX(phase, timeline) {
    if (angular.isDefined(timeline.start) && angular.isDefined(phase.startDate)) {
      var time = phase.startDate.diff(timeline.start, timeline.minimalMetric, true);
      return time * timeline.step / timeline.unit;
    }

    return 0;
  }

  function getPlannedSectionWidth(endDate, timeline) {
    if (angular.isDefined(endDate) && angular.isDefined(timeline.start)) {
      var time = endDate.diff(timeline.start, timeline.minimalMetric, true);
      return Math.ceil(time * timeline.step / timeline.unit);
    }

    return 0;
  }

  function getDelaySectionWidth(endDate, expectedEndDate, timeline) {
    if (expectedEndDate.isAfter(endDate)) {
      var time = expectedEndDate.diff(timeline.start, timeline.minimalMetric, true);
      return Math.ceil(time * timeline.step / timeline.unit);
    }

    return 0;
  }

  function getElapsedSectionWidth(timeline) {
    if (angular.isObject(timeline) && angular.isDefined(timeline.start)) {
      var end = DateService.getTodayWithTime();
      var time = end.diff(timeline.start, timeline.minimalMetric, true);
      return time * timeline.step / timeline.unit;
    }

    return 0;
  }

  function createTimeline(container) {
    var timeline = {};
    timeline.minimalMetric = container.minimalMetric;
    timeline.columnWidth = vm.timelineWidth / container.size;
    timeline.step = timeline.columnWidth / container.segments;
    timeline.textIndent = STEP_INDENT;
    timeline.titles = container[container.metric];
    timeline.range = [];
    timeline.unit = container.stepUnit;
    timeline.start = container.timelineStart;
    timeline.end = container.timelineEnd;

    for (var i = 0; i < container.size; i++) {
      timeline.range.push(i);
    }

    return timeline;
  }
};

XlrTimelineDirectiveController.$inject = XlrTimelineDirectiveControllerInject;
var XlrTimelineChartInject = ['$window', '$timeout', 'Events'];

var XlrTimelineChart = function XlrTimelineChart($window, $timeout, Events) {
  return {
    bindToController: {
      timelineData: '=',
      isDetailsView: '=detailView'
    },
    require: ['xlrTimelineChart', '?^xlrTile'],
    link: function link($scope, elem, attr, ctrls) {
      var ctrl = ctrls[0];
      var xlrTile = ctrls[1];
      var PANEL_BODY_PADDING = 60;

      if (ctrl.isDetailsView) {
        var resizeFn = function resizeFn() {
          $timeout(function () {
            ctrl.redrawTimeline($window.innerWidth - 110);
          }, 200);
        };

        angular.element($window).bind('resize', resizeFn);
        $scope.$on('$destroy', function () {
          angular.element($window).unbind('resize', resizeFn);
        });
        ctrl.init($window.innerWidth - 110);
      } else {
        if (xlrTile) {
          ctrl.init(xlrTile.width, xlrTile.height - PANEL_BODY_PADDING);
        }

        $scope.$on(Events.tile.resized, function () {
          if (xlrTile) {
            ctrl.redrawTimeline(xlrTile.width, xlrTile.height - PANEL_BODY_PADDING);
          }
        });
      }
    },
    controller: 'xlrTimelineDirectiveController',
    controllerAs: 'timelineCtrl',
    templateUrl: 'static/9.7.7/include/TimelineTile/partials/timeline-chart.html'
  };
};

XlrTimelineChart.$inject = XlrTimelineChartInject;
angular.module('xlrelease').controller('xlrTimelineDirectiveController', XlrTimelineDirectiveController);
angular.module('xlrelease').directive('xlrTimelineChart', XlrTimelineChart);

/***/ }),

/***/ 2226:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('Timeline', ['Planner', function (Planner) {
  return {
    init: function init(currentRelease, currentReleaseTree) {
      Planner.setRelease(currentRelease);
      Planner.setReleaseTree(currentReleaseTree);
      var plan = Planner.makePlan();
      var releasePlan = plan.plan;
      var expectedEndDate = plan.plannedEndDate;
      var startDate = plan.elements[0].displayStartDate;
      var endDate = releasePlan.displayEndDate;

      var phaseDetails = _(plan.elements).filter({
        type: 'xlrelease.Phase'
      }).map(function (phase) {
        return {
          title: phase.text,
          plainTitle: phase.plainText,
          startDate: moment(phase.start_date),
          endDate: moment(phase.end_date),
          color: phase.planItem.color
        };
      }).value();

      return {
        release: currentRelease,
        startDate: startDate,
        expectedEndDate: expectedEndDate,
        endDate: endDate,
        phases: phaseDetails
      };
    }
  };
}]);

/***/ }),

/***/ 2227:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2228:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2229:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2230:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2231:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2232:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2233:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2234:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2235:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2236:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2238:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2239:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2240:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2241:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2242:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2243:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2244:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2245:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2246:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2247:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2248:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2249:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2250:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2254:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2255:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2256:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2257:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2258:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2259:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2260:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2261:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2262:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2263:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2264:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2265:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2267:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/classCallCheck.js
var classCallCheck = __webpack_require__(4);
var classCallCheck_default = /*#__PURE__*/__webpack_require__.n(classCallCheck);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/createClass.js
var createClass = __webpack_require__(5);
var createClass_default = /*#__PURE__*/__webpack_require__.n(createClass);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/defineProperty.js
var defineProperty = __webpack_require__(1);
var defineProperty_default = /*#__PURE__*/__webpack_require__.n(defineProperty);

// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/services/index.js
var services = __webpack_require__(122);

// EXTERNAL MODULE: ./core/xlr-ui/app/features/common/services/http.js
var http = __webpack_require__(16);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/delivery-pattern.service.js


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }


var API_URL = 'api/v1/delivery-patterns';
function delivery_pattern_service_fetchDeliveryPattern(patternId) {
  return Object(http["c" /* httpGET */])("".concat(API_URL, "/").concat(patternId), true).then(function (res) {
    return res.data;
  }).catch(function () {
    return {
      id: null,
      title: null
    };
  });
}
function createDeliveryPattern(deliveryPattern) {
  return Object(http["d" /* httpPOST */])(API_URL, _objectSpread({
    id: '',
    type: 'delivery.Delivery'
  }, deliveryPattern, {
    status: 'template'
  })).then(function (res) {
    return res.data;
  });
}
function copyDeliveryPattern(deliveryPattern) {
  return Object(http["d" /* httpPOST */])("".concat(API_URL, "/").concat(deliveryPattern.id, "/duplicate"), {
    title: deliveryPattern.title,
    description: deliveryPattern.description
  }).then(function (res) {
    return res.data;
  });
}
function updateDeliveryPattern(deliveryPattern) {
  return Object(http["e" /* httpPUT */])("".concat(API_URL, "/").concat(deliveryPattern.id), _objectSpread({
    type: 'delivery.Delivery'
  }, deliveryPattern, {
    status: 'template'
  })).then(function (res) {
    return res.data;
  });
}
function delivery_pattern_service_deleteDeliveryPattern(patternId) {
  return Object(http["b" /* httpDELETE */])("".concat(API_URL, "/").concat(patternId));
}
function searchDeliveryPatterns() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _ref$title = _ref.title,
      title = _ref$title === void 0 ? '' : _ref$title,
      _ref$folderId = _ref.folderId,
      folderId = _ref$folderId === void 0 ? undefined : _ref$folderId,
      _ref$pageNumber = _ref.pageNumber,
      pageNumber = _ref$pageNumber === void 0 ? 0 : _ref$pageNumber,
      _ref$itemsPerPage = _ref.itemsPerPage,
      itemsPerPage = _ref$itemsPerPage === void 0 ? 100 : _ref$itemsPerPage;

  var params = {
    page: pageNumber,
    resultsPerPage: itemsPerPage
  };
  var url = "".concat(API_URL, "/search?") + $.param(params);
  return Object(http["d" /* httpPOST */])(url, {
    title: title,
    folderId: folderId
  }).then(function (res) {
    return res.data;
  });
}
function fetchStages(defId) {
  return Object(http["c" /* httpGET */])("".concat(API_URL, "/").concat(defId, "/stages")).then(function (res) {
    return res.data;
  });
}
function deleteStage(stageId) {
  return Object(http["b" /* httpDELETE */])("".concat(API_URL, "/").concat(stageId));
}
function updateStage(stageId, title) {
  return Object(http["e" /* httpPUT */])("".concat(API_URL, "/").concat(stageId), {
    id: stageId,
    title: title,
    type: 'delivery.Stage'
  }).then(function (res) {
    return res.data;
  });
}
function addStage(defId) {
  return Object(http["d" /* httpPOST */])("".concat(API_URL, "/").concat(defId, "/stages"), {
    id: null,
    title: null,
    type: 'delivery.Stage'
  }).then(function (res) {
    return res.data;
  });
}
function addTransition(stageId) {
  return Object(http["d" /* httpPOST */])("".concat(API_URL, "/").concat(stageId, "/transitions"), {
    id: null,
    title: 'New Transition',
    type: 'delivery.Transition'
  }).then(function (res) {
    return res.data;
  });
}
function updateTransition(transition) {
  return Object(http["e" /* httpPUT */])("".concat(API_URL, "/").concat(transition.id), _objectSpread({}, transition, {
    type: 'delivery.Transition',
    stage: undefined
  })).then(function (res) {
    return res.data;
  });
}
function deleteTransition(transitionId) {
  return Object(http["b" /* httpDELETE */])("".concat(API_URL, "/").concat(transitionId));
}
function checkTitle(id, title) {
  return Object(http["d" /* httpPOST */])("".concat(API_URL, "/checkTitle"), {
    id: id,
    title: title
  }).then(function (res) {
    return res.data;
  });
}
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/js/components/delivery-selector.js





var delivery_selector_template = "\n<div class=\"form-group\">\n    <label class=\"col-xs-3 control-label\" for=\"deliveryId\">\n        {{$ctrl.propertyDefinition.label}} <span class=\"error\">*</span>\n    </label>\n\n    <div class=\"col-sm-9\">\n        <div ng-if=\"$ctrl.isLoaded\" xlr-dropdown-with-variables\n             name=\"$ctrl.propertyDefinition.name\"\n             model=\"$ctrl.selectedDelivery\"\n             variables=\"$ctrl.variables\"\n             metadata=\"{name: $ctrl.propertyDefinition.name}\"\n             on-change=\"$ctrl.onVariableChange()\"\n             reset-value-on-toggle=\"true\"\n             on-new=\"$ctrl.onVariableCreate(name, variableType, createdCallback)\"\n             options=\"{placeholder: 'Select ' + $ctrl.propertyDefinition.label.toLowerCase() + '...', handlers: $ctrl.deliveryHandlers, required: true}\"\n             read-only=\"$ctrl.readOnly\"\n        ></div>\n        <div class=\"description\" ng-class=\"{'error': !$ctrl.isDeliveryExist}\">{{$ctrl.description}}</div>\n    </div>\n</div>\n";

var delivery_selector_DeliverySelectorController = /*#__PURE__*/function () {
  function DeliverySelectorController($q, VariablesService, Ids) {
    classCallCheck_default()(this, DeliverySelectorController);

    this.VariablesService = VariablesService;
    this.$q = $q;
    this.Ids = Ids;
  }

  createClass_default()(DeliverySelectorController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;

      this.isLoaded = false;
      this.isDeliveryExist = true;
      this.description = this.propertyDefinition.description;
      this.selectedDelivery = {
        variable: undefined,
        value: undefined
      };

      if (this.VariablesService.containsOnlyVariable(this.deliveryId)) {
        this.selectedDelivery.variable = this.deliveryId;
        this.isLoaded = true;
      } else if (this.deliveryId) {
        this.$q.when(this.fetchDelivery(this.deliveryId)).then(function (delivery) {
          _this.selectedDelivery.value = delivery;

          _this.fireOnChange(_this.selectedDelivery, true);
        }, function (err) {
          if (err.response.status === 404) {
            _this.isDeliveryExist = false;
            _this.selectedDelivery = {
              variable: undefined,
              value: {
                id: _this.deliveryId,
                title: _this.deliveryId
              }
            };
            _this.description = 'Currently selected delivery was deleted';
          }
        }).finally(function () {
          return _this.isLoaded = true;
        });
      } else {
        this.isLoaded = true;
      }

      this.searchDeliveries("").then(function (deliveries) {
        return _this.cachedDeliveries = deliveries;
      });
      this.deliveryHandlers = {
        addCandidates: function addCandidates(metadata, options) {
          return _this.autocompleteHandler(_this.cachedDeliveries, options.term);
        },
        onSelect: function onSelect(newDelivery) {
          _this.selectedDelivery = {
            value: newDelivery,
            variable: undefined
          };
          _this.description = _this.propertyDefinition.description;
          _this.isDeliveryExist = true;

          _this.fireOnChange(_this.selectedDelivery);
        },
        removeElement: function removeElement() {
          _this.selectedDelivery = {
            value: undefined,
            variable: undefined
          };
          _this.description = _this.propertyDefinition.description;
          _this.isDeliveryExist = true;

          _this.fireOnChange(_this.selectedDelivery);
        }
      };
    }
  }, {
    key: "autocompleteHandler",
    value: function autocompleteHandler(items, term) {
      var candidates = _.filter(items, function (item) {
        return item.title.toLowerCase().includes(term.toLowerCase());
      });

      return candidates.length > 0 ? Promise.resolve(candidates) : this.searchDeliveries(term);
    }
  }, {
    key: "onVariableCreate",
    value: function onVariableCreate(name, variableType, createdCallback) {
      this.onNewVariable({
        name: name,
        variableType: variableType,
        createdCallback: createdCallback
      });
      this.fireOnChange(this.selectedDelivery);
    }
  }, {
    key: "onVariableChange",
    value: function onVariableChange() {
      this.selectedDelivery = {
        value: undefined,
        variable: this.selectedDelivery.variable
      };
      this.description = this.propertyDefinition.description;
      this.isDeliveryExist = true;
      this.fireOnChange(this.selectedDelivery);
    }
  }, {
    key: "fireOnChange",
    value: function fireOnChange(delivery, initialLoad) {
      this.onChange({
        deliveryId: delivery.variable || (delivery.value || {}).id,
        delivery: delivery.value,
        initialLoad: initialLoad
      });
    }
  }, {
    key: "isPatternMode",
    value: function isPatternMode() {
      return this.mode === 'PATTERN';
    }
  }, {
    key: "fetchDelivery",
    value: function fetchDelivery(deliveryId) {
      if (this.isPatternMode()) {
        return delivery_pattern_service_fetchDeliveryPattern(deliveryId);
      } else {
        return Object(services["d" /* getDelivery */])(this.deliveryId, true).then(function (response) {
          return response.data;
        });
      }
    }
  }, {
    key: "searchDeliveries",
    value: function searchDeliveries(term) {
      if (this.isPatternMode()) {
        return searchDeliveryPatterns({
          title: term
        }).then(function (results) {
          return _.sortBy(results, 'title');
        });
      } else {
        return Object(services["c" /* fetchDeliveries */])({
          inProgress: true,
          title: term
        }, 0, 100).then(function (response) {
          return _.sortBy(response.data, 'title');
        });
      }
    }
  }, {
    key: "getName",
    value: function getName(id) {
      return this.Ids.getName(id);
    }
  }]);

  return DeliverySelectorController;
}();

defineProperty_default()(delivery_selector_DeliverySelectorController, "$inject", ['$q', 'VariablesService', 'Ids']);

var DeliverySelector = {
  bindings: {
    deliveryId: '<',
    propertyDefinition: '<',
    variables: '<',
    readOnly: '<',
    onChange: '&',
    onNewVariable: '&',
    mode: '@'
  },
  controller: delivery_selector_DeliverySelectorController,
  template: delivery_selector_template
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/js/components/delivery-item-selector.js



var delivery_item_selector_template = "\n<div class=\"form-group\">\n    <label class=\"col-sm-3 control-label\">{{$ctrl.propertyDefinition.label}} <span class=\"error\">*</span></label>\n\n    <div class=\"col-sm-9\">\n        <div xlr-template-from-value-or-variable-selector\n             name=\"$ctrl.propertyDefinition.name\"\n             model=\"$ctrl.selectedItem\"\n             variables=\"$ctrl.variables\"\n             metadata=\"{name: $ctrl.propertyDefinition.name}\"\n             on-change=\"$ctrl.onVariableChange()\"\n             on-new=\"$ctrl.onVariableCreate(name, variableType, createdCallback)\"\n             options=\"{placeholder: 'Select ' + $ctrl.propertyDefinition.label.toLowerCase() + '...', handlers: $ctrl.handlers, required: true}\"\n             read-only=\"$ctrl.readOnly\"\n        ></div>\n         <div class=\"description\">{{$ctrl.propertyDefinition.description}}<span ng-show=\"$ctrl.isLinkEnabled()\">. <a ng-click=\"$ctrl.onGetStages()\" style=\"cursor: pointer;\">Use delivery patterns to filter the list of stages</a></span></div>\n         </div>\n</div>\n";

var delivery_item_selector_DeliveryItemSelectorController = /*#__PURE__*/function () {
  function DeliveryItemSelectorController(VariablesService) {
    classCallCheck_default()(this, DeliveryItemSelectorController);

    this.VariablesService = VariablesService;
  }

  createClass_default()(DeliveryItemSelectorController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;

      this.setSelectedItem(this.itemId, this.items);
      this.handlers = {
        addCandidates: function addCandidates(metadata, options) {
          var matches = (_this.items || []).filter(function (item) {
            return item.title.toLowerCase().includes(options.term.toLowerCase());
          });
          return Promise.resolve(matches);
        },
        onSelect: function onSelect(newItem) {
          _this.selectedItem = {
            value: newItem,
            variable: undefined
          };

          _this.fireOnChange(_this.selectedItem);
        },
        removeElement: function removeElement() {
          _this.selectedItem = {
            value: undefined,
            variable: undefined
          };

          _this.fireOnChange(_this.selectedItem);
        }
      };
    }
  }, {
    key: "$onChanges",
    value: function $onChanges(changes) {
      if (changes.itemId) {
        this.setSelectedItem(changes.itemId.currentValue, this.items);
      }

      if (changes.items && changes.items.currentValue) {
        this.setSelectedItem(this.itemId, changes.items.currentValue);
      }
    }
  }, {
    key: "setSelectedItem",
    value: function setSelectedItem(itemId, items) {
      var _this2 = this;

      var isVariable = this.VariablesService.containsOnlyVariable(this.itemId);
      var variable = isVariable ? this.itemId : undefined;
      var value = !isVariable && items ? items.find(function (item) {
        return item.id === _this2.itemId || item.title === _this2.itemId;
      }) || {
        title: this.itemId
      } : undefined;
      this.selectedItem = {
        variable: variable,
        value: value
      };
    }
  }, {
    key: "onVariableCreate",
    value: function onVariableCreate(name, variableType, createdCallback) {
      this.onNewVariable({
        name: name,
        variableType: variableType,
        createdCallback: createdCallback
      });
      this.fireOnChange(this.selectedItem);
    }
  }, {
    key: "onVariableChange",
    value: function onVariableChange() {
      this.selectedItem = {
        value: undefined,
        variable: this.selectedItem.variable
      };
      this.fireOnChange(this.selectedItem);
    }
  }, {
    key: "fireOnChange",
    value: function fireOnChange(item, initialLoad) {
      this.onChange({
        itemId: item.variable || (item.value || {}).id,
        initialLoad: initialLoad
      });
    }
  }, {
    key: "isLinkEnabled",
    value: function isLinkEnabled() {
      return this.propertyDefinition && this.propertyDefinition.name === 'stage' && !this.readOnly && !this.delivery;
    }
  }]);

  return DeliveryItemSelectorController;
}();

defineProperty_default()(delivery_item_selector_DeliveryItemSelectorController, "$inject", ['VariablesService']);

var DeliveryItemSelector = {
  bindings: {
    delivery: '<?',
    itemId: '<',
    items: '<',
    propertyDefinition: '<',
    variables: '<',
    readOnly: '<',
    onChange: '&',
    onNewVariable: '&',
    onGetStages: '&'
  },
  controller: delivery_item_selector_DeliveryItemSelectorController,
  template: delivery_item_selector_template
};
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/js/components/delivery-task-details.less
var delivery_task_details = __webpack_require__(2183);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/js/components/delivery-task-details.js





var delivery_task_details_template = "\n<div class=\"delivery-task-details\">\n    <div class=\"form-horizontal\" ng-form=\"releaseSyncTaskForm\">\n        <div class=\"properties\">\n            <ng-transclude></ng-transclude>\n        </div>\n    </div>\n</div>\n";

var delivery_task_details_DeliveryTaskDetailsController = /*#__PURE__*/function () {
  function DeliveryTaskDetailsController($scope, VariablesService) {
    var _this = this;

    classCallCheck_default()(this, DeliveryTaskDetailsController);

    defineProperty_default()(this, "updateComponentModels", function (task) {
      _this.deliveryId = task.inputProperties.deliveryId;

      if (!task.inputProperties.patternId || _this.pattern.id !== task.inputProperties.patternId) {
        _this.pattern = null;
      }

      _this.stageId = task.inputProperties.stage;
    });

    this.$scope = $scope;
    this.VariablesService = VariablesService;
  }

  createClass_default()(DeliveryTaskDetailsController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      this.deliveryId = this.task.inputProperties.deliveryId;

      if (this.VariablesService.containsOnlyVariable(this.deliveryId)) {
        this.delivery = null;
      }

      if (this.task.inputProperties.status) {
        this.status = this.task.inputProperties.status.value || "READY";
        this.statusOptions = [];

        if (this.task.scriptDefinitionType === 'delivery.WaitForTrackedItems') {
          this.statusOptions = [{
            title: 'Completed',
            value: 'READY'
          }, {
            title: 'Available',
            value: 'NOT_READY'
          }];
        } else if (this.task.scriptDefinitionType === 'delivery.MarkTrackedItems') {
          this.statusOptions = [{
            title: 'Completed',
            value: 'READY'
          }, {
            title: 'Skipped',
            value: 'SKIPPED'
          }];
        }
      }

      if (this.task.inputProperties.patternId) {
        this.fetchDeliveryPattern();
      }

      this.stageId = this.task.inputProperties.stage;
      this.dpHandlers = {
        addCandidates: function addCandidates(metadata, options) {
          return searchDeliveryPatterns({
            title: options.term
          });
        },
        onSelect: function onSelect(newPattern) {
          _this2.task.inputProperties.patternId = newPattern.id;
          _this2.task.inputProperties.stage = _this2.updateStageValue(_this2.task.inputProperties.stage);

          _this2.onChange(_this2.task);

          _this2.updateComponentModels(_this2.task);
        },
        removeElement: function removeElement() {
          _this2.task.inputProperties.patternId = null;
          _this2.task.inputProperties.stage = _this2.updateStageValue(_this2.task.inputProperties.stage);

          _this2.onChange(_this2.task);

          _this2.updateComponentModels(_this2.task);
        }
      };
      this.showDeliveryPattern = !!this.task.inputProperties.patternId && !!this.deliveryId;
    }
  }, {
    key: "fetchDeliveryPattern",
    value: function fetchDeliveryPattern() {
      var _this3 = this;

      searchDeliveryPatterns().then(function (data) {
        _this3.pattern = data.find(function (p) {
          return p.id === _this3.task.inputProperties.patternId;
        });

        _this3.$scope.$digest();
      });
    }
  }, {
    key: "onGetStages",
    value: function onGetStages() {
      this.showDeliveryPattern = true;
    }
  }, {
    key: "onDeliveryChange",
    value: function onDeliveryChange(deliveryId, delivery, initialLoad) {
      this.delivery = delivery;
      this.task.inputProperties.deliveryId = deliveryId;

      if (initialLoad) {
        this.$scope.$digest(); // React...
      } else {
        if (!delivery && this.VariablesService.containsOnlyVariable(deliveryId) && !this.showDeliveryPattern) {
          this.task.inputProperties.stage = this.updateStageValue(this.task.inputProperties.stage);
        }

        if (!!delivery || !deliveryId && !delivery) {
          this.showDeliveryPattern = false;
          this.task.inputProperties.patternId = null;
          this.task.inputProperties.stage = this.updateStageValue(this.task.inputProperties.stage);
        }

        this.onChange(this.task);
        this.updateComponentModels(this.task);
      }
    }
  }, {
    key: "onStageChange",
    value: function onStageChange(stageId, initialLoad) {
      this.task.inputProperties.stage = stageId;

      if (!initialLoad) {
        this.onChange(this.task);
        this.updateComponentModels(this.task);
      }
    }
  }, {
    key: "updateStageValue",
    value: function updateStageValue(stage) {
      var isStageVariable = this.VariablesService.containsOnlyVariable(this.stageId);

      if (isStageVariable) {
        return stage;
      } else {
        return null;
      }
    }
  }, {
    key: "inputMetadataWithout",
    value: function inputMetadataWithout(excludedProperties) {
      if (!this.filteredInputMetadata && this.inputMetadata) {
        this.filteredInputMetadata = this.inputMetadata.filter(function (property) {
          return !excludedProperties.includes(property.name);
        });
      }

      return this.filteredInputMetadata;
    }
  }, {
    key: "hasProperty",
    value: function hasProperty(propertyName) {
      return !!this.getProperty(propertyName);
    }
  }, {
    key: "getProperty",
    value: function getProperty(propertyName) {
      return this.inputMetadata ? this.inputMetadata.find(function (property) {
        return property.name === propertyName;
      }) : undefined;
    }
  }, {
    key: "onStatusChange",
    value: function onStatusChange() {
      this.task.inputProperties.status = {
        value: this.status
      };
      this.onChange(this.task);
    }
  }, {
    key: "stages",
    get: function get() {
      if (this.showDeliveryPattern && !!this.pattern) {
        return this.pattern.stages;
      } else if (!this.showDeliveryPattern && !!this.delivery) {
        return this.delivery.stages;
      }
    }
  }]);

  return DeliveryTaskDetailsController;
}();

defineProperty_default()(delivery_task_details_DeliveryTaskDetailsController, "$inject", ['$scope', 'VariablesService']);

var DeliveryTaskDetails = {
  bindings: {
    task: '<',
    variables: '<',
    readOnly: '<',
    onNewVariable: '&',
    onChange: '&',
    inputMetadata: '<'
  },
  transclude: true,
  controller: delivery_task_details_DeliveryTaskDetailsController,
  template: delivery_task_details_template
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/js/components/find-or-create-delivery-task-details.js



var find_or_create_delivery_task_details_template = "\n<div class=\"find-or-create-delivery-task-details\">\n    <div class=\"form-horizontal\" data-ng-form=\"releaseSyncTaskForm\">\n        <div class=\"properties\">\n            <ng-transclude></ng-transclude>\n        </div>\n    </div>\n</div>\n";

var find_or_create_delivery_task_details_FindOrCreateDeliveryTaskDetailsController = /*#__PURE__*/function () {
  function FindOrCreateDeliveryTaskDetailsController($scope) {
    classCallCheck_default()(this, FindOrCreateDeliveryTaskDetailsController);

    this.$scope = $scope;
  }

  createClass_default()(FindOrCreateDeliveryTaskDetailsController, [{
    key: "$onInit",
    value: function $onInit() {
      this.patternId = this.task.inputProperties.patternId;
    }
  }, {
    key: "onPatternChange",
    value: function onPatternChange(patternId, pattern, initialLoad) {
      this.pattern = pattern;
      this.task.inputProperties.patternId = patternId;

      if (initialLoad) {
        this.$scope.$digest(); // React...
      } else {
        this.onChange(this.task);
      }
    }
  }, {
    key: "inputMetadataWithout",
    value: function inputMetadataWithout(excludedProperties) {
      if (!this.filteredInputMetadata && this.inputMetadata) {
        this.filteredInputMetadata = this.inputMetadata.filter(function (property) {
          return !excludedProperties.includes(property.name);
        });
      }

      return this.filteredInputMetadata;
    }
  }, {
    key: "hasProperty",
    value: function hasProperty(propertyName) {
      return !!this.getProperty(propertyName);
    }
  }, {
    key: "getProperty",
    value: function getProperty(propertyName) {
      return this.inputMetadata ? this.inputMetadata.find(function (property) {
        return property.name === propertyName;
      }) : undefined;
    }
  }, {
    key: "searchStrategyInputProperty",
    get: function get() {
      if (!this.searchStrategyInput) {
        this.searchStrategyInput = this.getProperty('searchStrategy');
      }

      return this.searchStrategyInput;
    }
  }, {
    key: "nameFilterInputProperty",
    get: function get() {
      if (!this.nameFilterInput) {
        this.nameFilterInput = this.getProperty('nameFilter');
      }

      return this.nameFilterInput;
    }
  }, {
    key: "selectionStrategyInputProperty",
    get: function get() {
      if (!this.selectionStrategyInput) {
        this.selectionStrategyInput = this.getProperty('selectionStrategy');
      }

      return this.selectionStrategyInput;
    }
  }, {
    key: "fallbackProperty",
    get: function get() {
      if (!this.fallback) {
        this.fallback = this.getProperty('fallback');
      }

      return this.fallback;
    }
  }]);

  return FindOrCreateDeliveryTaskDetailsController;
}();

defineProperty_default()(find_or_create_delivery_task_details_FindOrCreateDeliveryTaskDetailsController, "$inject", ['$scope']);

var FindOrCreateDeliveryTaskDetails = {
  bindings: {
    task: '<',
    variables: '<',
    readOnly: '<',
    onNewVariable: '&',
    onChange: '&',
    inputMetadata: '<'
  },
  transclude: true,
  controller: find_or_create_delivery_task_details_FindOrCreateDeliveryTaskDetailsController,
  template: find_or_create_delivery_task_details_template
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/js/components/index.js




angular.module('xlrelease').component('deliverySelector', DeliverySelector).component('deliveryItemSelector', DeliveryItemSelector).component('deliveryTaskDetails', DeliveryTaskDetails).component('findOrCreateDeliveryTaskDetails', FindOrCreateDeliveryTaskDetails);
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/js/index.js

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/index.js

// EXTERNAL MODULE: ./core/xlr-ui/app/features/release-overview/release-status-label/index.js
var release_status_label = __webpack_require__(266);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-list/delivery-list-controller.js



var delivery_list_controller_DeliveryListController = /*#__PURE__*/function () {
  function DeliveryListController() {
    classCallCheck_default()(this, DeliveryListController);
  }

  createClass_default()(DeliveryListController, [{
    key: "showMore",
    value: function showMore() {
      this.onShowMoreDeliveries();
    }
  }, {
    key: "getDeliveries",
    value: function getDeliveries() {
      return this.deliveries.toJS();
    }
  }, {
    key: "hasDeliveries",
    value: function hasDeliveries() {
      return _.get(this, ['deliveries', 'size']);
    }
  }, {
    key: "hasMoreDeliveries",
    value: function hasMoreDeliveries() {
      return this.deliveriesHasMore && !this.deliveriesLoadingStatus;
    }
  }]);

  return DeliveryListController;
}();


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-list/delivery-list-tpl.html
/* harmony default export */ var delivery_list_tpl = ("<div class=\"content-under-header fc-list-items\">\n    <div class=\"row\" ng-if=\"$ctrl.deliveries.size\">\n        <div class=\"col-xs-12\">\n            <xlr-infinite-scroll-wrapper\n                    on-show-more=\"$ctrl.showMore()\"\n                    disable-when=\"!$ctrl.hasMoreDeliveries()\"\n                    show-loader-when=\"$ctrl.deliveriesLoadingStatus\">\n                <div ng-repeat=\"delivery in $ctrl.getDeliveries()\"\n                     ng-class=\"{'fc-list-item-first': $first}\"\n                     class=\"row fc-list-item fc-list-loaded\"\n                     xlr-infinite-scroll>\n                    <xlr-delivery-row delivery=\"delivery\"></xlr-delivery-row>\n                </div>\n            </xlr-infinite-scroll-wrapper>\n        </div>\n    </div>\n    <div class=\"alert notice fc-list-loaded\" ng-if=\"!$ctrl.hasDeliveries() && !$ctrl.deliveriesLoadingStatus\">\n        No deliveries found.\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-list/index.js


var deliveryListComponent = {
  bindings: {
    deliveries: '<',
    deliveriesLoadingStatus: '<',
    deliveriesHasMore: '<',
    onShowMoreDeliveries: '&'
  },
  controller: delivery_list_controller_DeliveryListController,
  template: delivery_list_tpl
};
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/actions/deliveries-actions.js
var deliveries_actions = __webpack_require__(72);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/global.constants.js
var global_constants = __webpack_require__(46);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-row/delivery-row-controller.js







var delivery_row_controller_DeliveryRowController = /*#__PURE__*/function () {
  function DeliveryRowController(Authenticator, ReleasesService, DateService, $ngRedux, $location, $uibModal) {
    classCallCheck_default()(this, DeliveryRowController);

    this._releasesService = ReleasesService;
    this._dateService = DateService;
    this._security = Authenticator;
    this._$location = $location;
    this._$uibModal = $uibModal;
    this._unsubscribe = $ngRedux.connect(this._mapStateToThis, this._mapDispatchToThis.bind(this))(this);
  }

  createClass_default()(DeliveryRowController, [{
    key: "$onDestroy",
    value: function $onDestroy() {
      this._unsubscribe();
    }
  }, {
    key: "_mapDispatchToThis",
    value: function _mapDispatchToThis(dispatch) {
      return {
        delete: function _delete(id) {
          return dispatch(Object(deliveries_actions["c" /* deleteDelivery */])(id));
        }
      };
    }
  }, {
    key: "hasDuration",
    value: function hasDuration() {
      return this.delivery.status === 'IN_PROGRESS' && this.delivery.startDate && this.delivery.endDate;
    }
  }, {
    key: "getFormattedDuration",
    value: function getFormattedDuration() {
      if (this.hasDuration()) {
        return this._dateService.getRemainingDuration(this.delivery.endDate);
      }
    }
  }, {
    key: "getNumberOfTrackedItems",
    value: function getNumberOfTrackedItems() {
      return _.get(this.delivery, ['trackedItems', 'length']) || 0;
    }
  }, {
    key: "isUpdatable",
    value: function isUpdatable(delivery) {
      return Object(services["f" /* isDeliveryUpdatable */])(delivery) && this._security.hasDeliveryEditPermission(delivery);
    }
  }, {
    key: "isOverdue",
    value: function isOverdue(date) {
      return date.includes('Overdue') || this._dateService.isOverdue(date, global_constants["a" /* dateTimeFormat */].duration);
    }
  }, {
    key: "deleteDelivery",
    value: function deleteDelivery(_delivery) {
      var _this = this;

      this._$uibModal.open({
        animation: false,
        component: 'confirmDeleteDelivery',
        resolve: {
          delivery: function delivery() {
            return _delivery;
          }
        }
      }).result.then(function (confirm) {
        if (confirm) {
          _this.delete(_delivery.id);
        }
      });
    }
  }, {
    key: "updateDelivery",
    value: function updateDelivery(delivery) {
      this._$location.url("/deliveries/".concat(delivery.id));
    }
  }]);

  return DeliveryRowController;
}();

defineProperty_default()(delivery_row_controller_DeliveryRowController, "$inject", ['Authenticator', 'ReleasesService', 'DateService', '$ngRedux', '$location', '$uibModal']);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-row/delivery-row-tpl.html
/* harmony default export */ var delivery_row_tpl = ("<div class=\"col-xs-12 raised-link-wrapper\">\n    <div class=\"fc-list-item-line\">\n        <div class=\"row\">\n            <div class=\"fc-list-item-wrapper\">\n                <a class=\"col-xs-6 raised-link\" href=\"#/deliveries/{{$ctrl.delivery.id}}\"></a>\n                <div class=\"col-xs-3 fc-list-item-title-wrapper\">\n                    <div class=\"fc-list-item-title\">\n                      <i class=\"xl-icon group-icon icon-l\"></i>\n                      <strong class=\"raised-link-target\">\n                          {{$ctrl.delivery.title}}\n                      </strong>\n                    </div>\n                    <div class=\"fc-list-item-item-count\">\n                        <ng-pluralize count=\"$ctrl.getNumberOfTrackedItems()\"\n                                      when=\"{'one': '{} tracked item', 'other': '{} tracked items'}\"></ng-pluralize>\n                    </div>\n                </div>\n                <div class=\"col-xs-9 fc-list-item-content-wrapper\">\n                    <div class=\"row\">\n                        <div class=\"col-xs-2 col-xs-offset-2 fc-list-item-content\">\n                            <delivery-status-label release=\"$ctrl.delivery\" show-archived=\"true\"></delivery-status-label>\n                        </div>\n                        <div class=\"col-xs-2 fc-list-item-content\">\n                            <span ng-if=\"$ctrl.delivery.startDate\">\n                                {{$ctrl.delivery.startDate | date: 'short'}}\n                            </span>\n                        </div>\n                        <div class=\"col-xs-2 fc-list-item-content\">\n                            <span ng-if=\"$ctrl.delivery.endDate\">\n                                {{$ctrl.delivery.endDate | date: 'short'}}\n                            </span>\n                        </div>\n                        <div class=\"col-xs-2 duration fc-list-item-content\" ng-class=\"{'date-overdue': $ctrl.hasDuration() && $ctrl.isOverdue($ctrl.getFormattedDuration())}\">\n                            <span ng-if=\"$ctrl.hasDuration()\">{{$ctrl.getFormattedDuration()}}</span>\n                        </div>\n                        <div class=\"col-xs-2 text-centered fc-list-item-actions\">\n                            <div class=\"fc-list-item-actions-button fc-item-update link\" ng-if=\"$ctrl.isUpdatable($ctrl.delivery)\"\n                                  ng-click=\"$ctrl.updateDelivery($ctrl.delivery)\">\n                                <i class=\"xl-icon edit-icon\"></i>\n                                <span class=\"action-label\">Edit</span>\n                            </div>\n                            <div class=\"fc-list-item-actions-button fc-item-delete link\" ng-if=\"$ctrl.isUpdatable($ctrl.delivery)\"\n                                  ng-click=\"$ctrl.deleteDelivery($ctrl.delivery)\">\n                                <i class=\"xl-icon delete-icon\"></i>\n                                <span class=\"action-label\">Delete</span>\n                            </div>\n\n                            <div class=\"fc-list-item-actions-button fc-item-view link\" ng-if=\"!$ctrl.isUpdatable($ctrl.delivery)\"\n                                 ng-click=\"$ctrl.updateDelivery($ctrl.delivery)\">\n                                <i class=\"xl-icon visibility-on-icon\" title=\"view\"></i>\n                                <span class=\"action-label\">View</span>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-row/index.js


var deliveryRowComponent = {
  bindToController: true,
  bindings: {
    delivery: '<'
  },
  controllerAs: '$ctrl',
  controller: delivery_row_controller_DeliveryRowController,
  template: delivery_row_tpl
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/components/delete-deliveries-modal-component.js
var delete_deliveries_modal_component_template = "\n    <div class=\"modal-header\">\n        <h4 class=\"modal-title pull-left\" id=\"modal-title\">Delete release delivery</h4>\n        <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.close()\"><i class=\"xl-icon close-icon\"/></button>\n        <div class=\"clearfix\"/>\n    </div>\n    <div class=\"modal-body\" id=\"modal-body\">\n        You are about to delete the release delivery <strong>{{::$ctrl.resolve.delivery.title}}</strong>.\n    </div>\n    <div class=\"modal-footer\">\n        <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button class=\"button continue primary\" type=\"button\" focus-on=\"true\" ng-click=\"$ctrl.close({$value: true})\">Delete</button>\n    </div>\n";
var ConfirmDeleteDelivery = {
  bindings: {
    resolve: '<',
    close: '&',
    dismiss: '&'
  },
  template: delete_deliveries_modal_component_template
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-filter/delivery-filter-tpl.html
/* harmony default export */ var delivery_filter_tpl = ("<filter class=\"fc-list-header-filter\" filters=\"$ctrl.filters\" on-change=\"$ctrl.filtersChanged(filters)\">\n    <div class=\"fc-list-header-filter-basic\">\n        <text-filter field=\"'title'\" class=\"delivery\" placeholder=\"'Search for deliveries...'\"></text-filter>\n        <span>\n            <ci-filter-status statuses=\"$ctrl.statusOptions\"></ci-filter-status>\n            <order-by-filter order-options=\"$ctrl.orderOptions\" class=\"filter last\"></order-by-filter>\n        </span>\n        <div class=\"buttons\">\n            <span class=\"pull-right filter-all\" ng-if=\"$ctrl.itemsCount.live.total > 0\"\n                  bs-tooltip placement=\"bottom\" template=\"{{$ctrl.itemCountTemplate}}\">\n                <span ng-pluralize\n                      count=\"$ctrl.itemsCount.live.total\"\n                      when=\"{'1': '{} delivery', 'other': '{} deliveries', 'few': '{} deliveries', 'many': '{} deliveries'}\"\n                      style=\"font-weight: bold\"></span>\n            </span>\n\n            <span class=\"fc-list-header-doc-icon\" doc-icon=\"deliveries.html\"></span>\n        </div>\n    </div>\n</filter>\n");
// EXTERNAL MODULE: ./node_modules/xl-react-components/dist/index.js
var dist = __webpack_require__(21);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/colors.js
var colors = __webpack_require__(23);

// EXTERNAL MODULE: ./core/xlr-ui/app/partials/items-count/items-count-tpl.html
var items_count_tpl = __webpack_require__(265);

// EXTERNAL MODULE: ./core/xlr-ui/app/partials/items-count/items-count.less
var items_count = __webpack_require__(2184);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-filter/delivery-filter-controller.js







var delivery_filter_controller_DeliveryListHeaderController = /*#__PURE__*/function () {
  function DeliveryListHeaderController() {
    classCallCheck_default()(this, DeliveryListHeaderController);
  }

  createClass_default()(DeliveryListHeaderController, [{
    key: "$onInit",
    value: function $onInit() {
      this.statusOptions = [{
        label: 'In progress',
        value: 'In progress',
        color: colors["a" /* default */].blue
      }, {
        label: 'Completed',
        value: 'Completed',
        color: colors["a" /* default */].green
      }];
      this.orderOptions = [{
        label: 'Start date',
        filter: 'start_date'
      }, {
        label: 'End date',
        filter: 'end_date'
      }];
      this.itemCountTemplate = items_count_tpl["a" /* default */];
    }
  }]);

  return DeliveryListHeaderController;
}();


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-filter/index.js


var deliveryFilter = {
  bindings: {
    filters: '<',
    itemsCount: '<',
    filtersChanged: '&'
  },
  template: delivery_filter_tpl,
  controller: delivery_filter_controller_DeliveryListHeaderController
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-sub-header/delivery-sub-header-tpl.html
/* harmony default export */ var delivery_sub_header_tpl = ("<div class=\"container-fluid fc-list-sub-header\" ng-if=\"$ctrl.hasDeliveries()\">\n    <div class=\"col-xs-12\">\n        <div class=\"row\">\n            <div class=\"col-xs-3\">\n                <div class=\"release-table-text\">Name</div>\n            </div>\n            <div class=\"col-xs-9\">\n                <div class=\"row\">\n                    <div class=\"col-xs-4\"></div>\n                    <div class=\"col-xs-2\">\n                        <div class=\"release-table-text\">Start date</div>\n                    </div>\n                    <div class=\"col-xs-2\">\n                        <div class=\"release-table-text\">End date</div>\n                    </div>\n                    <div class=\"col-xs-2\">\n                        <div class=\"release-table-text\">Remaining duration</div>\n                    </div>\n                    <div class=\"col-xs-2\"></div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-sub-header/index.js

var deliverySubHeader = {
  bindings: {
    hasDeliveries: '&'
  },
  template: delivery_sub_header_tpl
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/deliveries-tpl.html
/* harmony default export */ var deliveries_tpl = ("<div class=\"fc-list f-deliveries header\" id=\"deliveries\">\n    <div class=\"fc-list-header\">\n        <div class=\"fc-list-header-actions\">\n            <delivery-filter filters=\"$ctrl.filters\"\n                             filters-changed=\"$ctrl.filtersChanged()\"\n                             items-count=\"$ctrl.itemsCount\"></delivery-filter>\n            <delivery-sub-header has-deliveries=\"$ctrl.hasDeliveries()\"></delivery-sub-header>\n        </div>\n    </div>\n    <div class=\"fc-list-items-wrapper\">\n        <xlr-delivery-list deliveries=\"$ctrl.deliveries\"\n                           deliveries-loading-status=\"$ctrl.loading\"\n                           deliveries-has-more=\"$ctrl.hasMoreDeliveries\"\n                           on-show-more-deliveries=\"$ctrl.loadMoreDeliveries()\">\n        </xlr-delivery-list>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/deliveries-controller.js





var deliveries_controller_DeliveriesController = /*#__PURE__*/function () {
  function DeliveriesController($scope, Events, $uibModal, $ngRedux) {
    classCallCheck_default()(this, DeliveriesController);

    this._$scope = $scope;
    this._Events = Events;
    this._unsubscribe = $ngRedux.connect(this._mapStateToThis, this._mapDispatchToThis.call(this, $uibModal))(this);
  }

  createClass_default()(DeliveriesController, [{
    key: "$onInit",
    value: function $onInit() {
      if (this.folder) {
        this.filters.folderId = this.folder.id;
      }

      this._$scope.$emit(this._Events.permission.refresh);
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this._unsubscribe();
    }
  }, {
    key: "_mapDispatchToThis",
    value: function _mapDispatchToThis(uibModalService) {
      return function (dispatch) {
        return {
          loadMoreDeliveries: function loadMoreDeliveries() {
            dispatch(Object(deliveries_actions["e" /* getMoreDeliveries */])());
          },
          updateFilters: function updateFilters(filters) {
            dispatch(Object(deliveries_actions["f" /* setFilters */])(filters, true));
          },
          deleteDelivery: function deleteDelivery() {
            dispatch(Object(deliveries_actions["c" /* deleteDelivery */])(uibModalService));
          }
        };
      };
    }
  }, {
    key: "_mapStateToThis",
    value: function _mapStateToThis(state) {
      var reducer = state.deliveries;
      return {
        deliveries: reducer.deliveries,
        itemsCount: reducer.itemsCount,
        loading: reducer.loading,
        hasMoreDeliveries: reducer.hasMoreDeliveries,
        filters: reducer.filters.toJS()
      };
    }
  }, {
    key: "filtersChanged",
    value: function filtersChanged() {
      this.updateFilters(this.filters);
    }
  }, {
    key: "hasDeliveries",
    value: function hasDeliveries() {
      return !!_.get(this.deliveries, 'size');
    }
  }]);

  return DeliveriesController;
}();

defineProperty_default()(deliveries_controller_DeliveriesController, "$inject", ['$scope', 'Events', '$uibModal', '$ngRedux']);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/deliveries-component.js


/* harmony default export */ var deliveries_component = ({
  bindings: {
    filters: '<'
  },
  controller: deliveries_controller_DeliveriesController,
  template: deliveries_tpl
});
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/deliveries.less
var deliveries = __webpack_require__(2185);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/index.js








/* harmony default export */ var include_deliveries = (angular.module('xlrelease.deliveries', []).component('deliveryStatusLabel', release_status_label["a" /* releaseStatusLabelComponent */]).component('xlrDeliveryList', deliveryListComponent).component('xlrDeliveryRow', deliveryRowComponent).component('confirmDeleteDelivery', ConfirmDeleteDelivery).component('deliveryFilter', deliveryFilter).component('deliverySubHeader', deliverySubHeader).component('deliveries', deliveries_component).config(['$stateProvider', function ($stateProvider) {
  $stateProvider.state('deliveries', {
    url: '/deliveries',
    reloadOnSearch: false,
    controller: ['filters', function (filters) {
      this.filters = filters;
    }],
    template: '<deliveries filters="$ctrl.filters" />',
    controllerAs: '$ctrl',
    resolve: {
      filters: ['Filters', function (Filters) {
        return Filters.getDeliveriesFilterSettings();
      }]
    }
  });
}]).name);
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/header/delivery-header-controller.js



var delivery_header_controller_DeliveryHeaderController = /*#__PURE__*/function () {
  function DeliveryHeaderController($parse, $location, UiExtensionsService, Page) {
    var _this = this;

    classCallCheck_default()(this, DeliveryHeaderController);

    defineProperty_default()(this, "isSubpageDisplayed", function (subpage) {
      if (_.isString(subpage.displayIf)) {
        var displayFunction = _this._$parse(subpage.displayIf);

        return displayFunction(_this);
      }

      return !subpage.hidden;
    });

    defineProperty_default()(this, "getSubpageLink", function (subpage) {
      return "#/".concat(_this.delivery.status === 'TEMPLATE' ? 'delivery-patterns' : 'deliveries', "/").concat(_this.delivery.id).concat(subpage.path);
    });

    this._$parse = $parse;
    this._$location = $location;
    this._UiExtensionsService = UiExtensionsService;
    this._Page = Page;
    this._isBreadCrumbInitialized = false;
    this.isSubpageDropdownAvailable = false;
  }

  createClass_default()(DeliveryHeaderController, [{
    key: "$onInit",
    value: function $onInit() {
      if (this.delivery) {
        this._initDropdown();
      }
    }
  }, {
    key: "$onChanges",
    value: function $onChanges(changes) {
      var delivery = changes.delivery;

      if (delivery && delivery.previousValue === null && delivery.currentValue !== null) {
        this._initDropdown();
      }
    }
  }, {
    key: "_initDropdown",
    value: function _initDropdown() {
      this._setBreadcrumbs(this.delivery);

      this._generateSubpages(this.delivery);
    }
  }, {
    key: "_generateSubpages",
    value: function _generateSubpages(delivery) {
      var _this2 = this;

      this.isSubpageDropdownAvailable = angular.isDefined(delivery) && !!delivery;

      this._extendSubpages(delivery).then(function (extendedSubpages) {
        _this2.deliverySubpages = extendedSubpages;

        var notDefaultPages = _.omit(_this2.deliverySubpages, '');

        _this2.page = _.find(notDefaultPages, function (aPage) {
          var regexp = new RegExp(aPage.path, 'i');
          return _this2._$location.path().match(regexp); // if current location ends with one of the subpages
        });
        _this2.page = _this2.page || _this2.deliverySubpages[''];
      });
    }
  }, {
    key: "_extendSubpages",
    value: function _extendSubpages(delivery) {
      var menuId = delivery.status === 'TEMPLATE' ? 'xlrelease.DeliveryPatternPageMenu' : 'xlrelease.DeliveryPageMenu';
      return this._UiExtensionsService.getMenuItems(menuId, delivery).then(function (extensions) {
        var extendedSubpages = [];

        _(extensions).filter({
          permitted: true
        }).forEach(function (extension) {
          extendedSubpages[extension.pathSuffix] = {
            path: '/' + extension.pathSuffix,
            label: extension.label,
            weight: extension.weight
          };
        });

        extendedSubpages = _(extendedSubpages).toPairs().sortBy(function (keyValue) {
          return keyValue[1].weight;
        }).fromPairs().value();
        return extendedSubpages;
      });
    }
  }, {
    key: "_setBreadcrumbs",
    value: function _setBreadcrumbs(delivery) {
      if (!this._isBreadCrumbInitialized) {
        this._Page.setFolderEntityOpened(delivery.folderId, delivery);

        this._isBreadCrumbInitialized = true;
      }
    }
  }]);

  return DeliveryHeaderController;
}();

defineProperty_default()(delivery_header_controller_DeliveryHeaderController, "$inject", ['$parse', '$location', 'UiExtensionsService', 'Page']);
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/header/delivery-header.html
/* harmony default export */ var delivery_header = ("<div id=\"delivery-header\" class=\"header\">\n    <div class=\"subpage-links\" ng-if=\"$ctrl.isSubpageDropdownAvailable\">\n        <span class=\"show-label\">Show</span>\n        <button type=\"button\" class=\"button dropdown-button\" bs-popover\n                data-content-template=\"static/9.7.7/include/deliveries-details/header/delivery-subpages.html\"\n                data-placement=\"bottom\"\n                auto-close=\"true\">\n            {{ $ctrl.page.label }} <span class=\"caret\"></span>\n        </button>\n    </div>\n\n    <span class=\"header-container-flex\" ng-transclude></span>\n</div>\n");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/header/index.js


var deliveryDetailsHeader = {
  bindings: {
    delivery: '<?'
  },
  template: delivery_header,
  replace: true,
  transclude: true,
  controller: delivery_header_controller_DeliveryHeaderController,
  controllerAs: '$ctrl'
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/delivery-details-page-extension-container.html
/* harmony default export */ var delivery_details_page_extension_container = ("<div style=\"height: 100%\" ng-if=\"deliveryDetailsPageExtension.pageExtension.uri\"\n     ng-include=\"'static/9.7.7/' + deliveryDetailsPageExtension.pageExtension.uri\"></div>\n<div ng-if=\"deliveryDetailsPageExtension.pageExtension && !deliveryDetailsPageExtension.pageExtension.uri\">\n    <xlr-delivery-details-header delivery=\"deliveryDetailsPageExtension.delivery\"/>\n    <div class=\"content-under-header\">\n        <h4>\n            No <strong>uri</strong> parameter specified in delivery menu item [{{ deliveryDetailsPageExtension.pageExtension.label }}]. Please check your plugin.\n            <pre>\n                {{deliveryDetailsPageExtension.pageExtension}}\n            </pre>\n        </h4>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/delivery-pattern.constants.js
var DELIVERY_PATTERN_EDIT_PERMISSION = "delivery_pattern#edit";
var DELIVERY_EDIT_PERMISSION = "delivery#edit";
var DELIVERY_TRACKED_ITEM_EDIT_PERMISSION = "delivery#edit_tracked_item";
var FOLDER_VIEW_PERMISSION = "folder#view";
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/deliveries-details-page-extension-controller.js




var deliveries_details_page_extension_controller_DeliveryDetailsPageExtensionController = /*#__PURE__*/function () {
  function DeliveryDetailsPageExtensionController($location, $stateParams, UiExtensionsService, Page, FoldersService, deliveryPromise, Authenticator) {
    classCallCheck_default()(this, DeliveryDetailsPageExtensionController);

    this._$location = $location;
    this._$stateParams = $stateParams;
    this._UiExtensionsService = UiExtensionsService;
    this._Page = Page;
    this._FoldersService = FoldersService;
    this._Authenticator = Authenticator;

    if (deliveryPromise.length === 2) {
      this.delivery = deliveryPromise[0].data;
      this.releases = deliveryPromise[1];
    } else {
      this.releases = [];
      this.delivery = deliveryPromise.data || deliveryPromise;
    }

    this.delivery.isEditable = Authenticator.hasPermission(this.delivery.status === 'TEMPLATE' ? DELIVERY_PATTERN_EDIT_PERMISSION : DELIVERY_EDIT_PERMISSION, this.delivery.$metadata);
    this.delivery.isTrackedItemEditable = Authenticator.hasAnyOfPermissions(this.delivery.status === 'TEMPLATE' ? [DELIVERY_PATTERN_EDIT_PERMISSION] : [DELIVERY_EDIT_PERMISSION, DELIVERY_TRACKED_ITEM_EDIT_PERMISSION], this.delivery.$metadata);
    this.delivery.canCreateDelivery = Authenticator.hasPermission(DELIVERY_EDIT_PERMISSION, this.delivery.$metadata);
  }

  createClass_default()(DeliveryDetailsPageExtensionController, [{
    key: "$onInit",
    value: function $onInit() {
      this._loadPageExtension();
    }
  }, {
    key: "_redirectToDefaultPage",
    value: function _redirectToDefaultPage() {
      // If the current URL is /deliveries/Delivery1, we redirect the user to 'deliveries'
      var defaultPage = this._$location.path().substring(1);

      defaultPage = defaultPage.substring(0, defaultPage.indexOf('/'));

      this._$location.url(defaultPage);
    }
  }, {
    key: "_loadPageExtension",
    value: function _loadPageExtension() {
      var _this = this;

      var canViewFolder = this._Authenticator.hasPermission(FOLDER_VIEW_PERMISSION, this.delivery.$metadata);

      var menuId = this.delivery.status === 'TEMPLATE' ? 'xlrelease.DeliveryPatternPageMenu' : 'xlrelease.DeliveryPageMenu';

      var getExtension = function getExtension(list) {
        return _.find(list, {
          pathSuffix: _this._$stateParams.extensionPath || "",
          permitted: true
        });
      };

      if (canViewFolder) {
        this._FoldersService.get(this.delivery.folderId).then(function (folder) {
          _this.folder = folder;

          _this._UiExtensionsService.getMenuItems(menuId, folder).then(function (extensions) {
            _this.pageExtension = getExtension(extensions);

            if (_this.pageExtension) {
              _this._Page.setFolderEntityOpened(_this.delivery.folderId, _this.delivery);
            } else {
              _this._redirectToDefaultPage();
            }
          });
        });
      } else {
        this._UiExtensionsService.getMenuItems(menuId).then(function (extensions) {
          _this.pageExtension = getExtension(extensions);

          if (_this.pageExtension) {
            _this._Page.setDeliveryOpened(_this.delivery);
          } else {
            _this._redirectToDefaultPage();
          }
        });
      }
    }
  }]);

  return DeliveryDetailsPageExtensionController;
}();

defineProperty_default()(deliveries_details_page_extension_controller_DeliveryDetailsPageExtensionController, "$inject", ['$location', '$stateParams', 'UiExtensionsService', 'Page', 'FoldersService', 'deliveryPromise', 'Authenticator']);
// EXTERNAL MODULE: ./node_modules/react2angular/index.js
var react2angular = __webpack_require__(64);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/inherits.js
var inherits = __webpack_require__(12);
var inherits_default = /*#__PURE__*/__webpack_require__.n(inherits);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js
var possibleConstructorReturn = __webpack_require__(11);
var possibleConstructorReturn_default = /*#__PURE__*/__webpack_require__.n(possibleConstructorReturn);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/getPrototypeOf.js
var getPrototypeOf = __webpack_require__(9);
var getPrototypeOf_default = /*#__PURE__*/__webpack_require__.n(getPrototypeOf);

// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(0);
var react_default = /*#__PURE__*/__webpack_require__.n(react);

// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__(2);
var prop_types_default = /*#__PURE__*/__webpack_require__.n(prop_types);

// EXTERNAL MODULE: ./node_modules/react-redux/es/index.js + 22 modules
var es = __webpack_require__(30);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/regenerator/index.js
var regenerator = __webpack_require__(8);
var regenerator_default = /*#__PURE__*/__webpack_require__.n(regenerator);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/typeof.js
var helpers_typeof = __webpack_require__(86);
var typeof_default = /*#__PURE__*/__webpack_require__.n(helpers_typeof);

// EXTERNAL MODULE: ./node_modules/redux/es/redux.js
var redux = __webpack_require__(55);

// EXTERNAL MODULE: ./node_modules/redux-saga/dist/redux-saga-core-npm-proxy.esm.js + 2 modules
var redux_saga_core_npm_proxy_esm = __webpack_require__(147);

// EXTERNAL MODULE: ./node_modules/redux-saga/dist/redux-saga-effects-npm-proxy.esm.js + 1 modules
var redux_saga_effects_npm_proxy_esm = __webpack_require__(3);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/toConsumableArray.js
var toConsumableArray = __webpack_require__(25);
var toConsumableArray_default = /*#__PURE__*/__webpack_require__.n(toConsumableArray);

// EXTERNAL MODULE: ./node_modules/lodash/differenceBy.js
var differenceBy = __webpack_require__(437);
var differenceBy_default = /*#__PURE__*/__webpack_require__.n(differenceBy);

// EXTERNAL MODULE: ./node_modules/lodash/intersectionBy.js
var intersectionBy = __webpack_require__(818);
var intersectionBy_default = /*#__PURE__*/__webpack_require__.n(intersectionBy);

// EXTERNAL MODULE: ./node_modules/lodash/last.js
var last = __webpack_require__(210);
var last_default = /*#__PURE__*/__webpack_require__.n(last);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/ducks/delivery-flow.actions.js
var actionTypes = {
  FULL_DELIVERY_DETAILS_REQUEST: 'FULL_DELIVERY_DETAILS_REQUEST',
  TRACKED_ITEM_CREATE_OR_UPDATE_REQUEST: 'TRACKED_ITEM_DELIVERY_FLOW/CREATE_OR_UPDATE_REQUEST',
  TRACKED_ITEM_CREATE_OR_UPDATE_SUCCESS: 'TRACKED_ITEM_DELIVERY_FLOW/CREATE_OR_UPDATE_SUCCESS',
  TRACKED_ITEM_REMOVE_REQUEST: 'TRACKED_ITEM_DELIVERY_FLOW/REMOVE_REQUEST',
  TRACKED_ITEM_REMOVE_SUCCESS: 'TRACKED_ITEM_DELIVERY_FLOW/REMOVE_SUCCESS',
  TRACKED_ITEM_DESCOPE_REQUEST: 'TRACKED_ITEM_DELIVERY_FLOW/DESCOPE_REQUEST',
  TRACKED_ITEM_RESCOPE_REQUEST: 'TRACKED_ITEM_DELIVERY_FLOW/RESCOPE_REQUEST',
  TRACKED_ITEM_SKIP_REQUEST: 'TRACKED_ITEM_DELIVERY_FLOW/SKIP_REQUEST',
  TRACKED_ITEM_COMPLETE_REQUEST: 'TRACKED_ITEM_DELIVERY_FLOW/COMPLETE_REQUEST',
  TRACKED_ITEM_SKIP_SUCCESS: 'TRACKED_ITEM_DELIVERY_FLOW/SKIP_SUCCESS',
  TRACKED_ITEM_COMPLETE_SUCCESS: 'TRACKED_ITEM_DELIVERY_FLOW/COMPLETE_SUCCESS',
  TRACKED_ITEM_UPDATE_DATA: 'TRACKED_ITEM_DELIVERY_FLOW/UPDATE_DATA',
  TRACKED_ITEM_STAGE_RELEASE_REQUEST: 'TRACKED_ITEM_DELIVERY_FLOW/STAGE_RELEASE_REQUEST',
  TRACKED_ITEM_STAGE_RELEASE_SUCCESS: 'TRACKED_ITEM_DELIVERY_FLOW/STAGE_RELEASE_SUCCESS',
  TRACKED_ITEM_STAGE_TRANSITION_REQUEST: 'TRACKED_ITEM_DELIVERY_FLOW/STAGE_TRANSITION_REQUEST',
  TRACKED_ITEM_DELIVERY_DETAIL_START_POLLING: 'TRACKED_ITEM_DELIVERY_FLOW/TRACKED_ITEM_DELIVERY_DETAIL_START_POLLING',
  TRACKED_ITEM_DELIVERY_DETAIL_STOP_POLLING: 'TRACKED_ITEM_DELIVERY_FLOW/TRACKED_ITEM_DELIVERY_DETAIL_STOP_POLLING',
  TRACKED_ITEM_DELIVERY_DETAIL_POLLING_FAILURE: 'TRACKED_ITEM_DELIVERY_FLOW/TRACKED_ITEM_DELIVERY_DETAIL_POLLING_FAILURE',
  STAGE_COMPLETE_REQUEST: 'STAGE/COMPLETE_REQUEST',
  STAGE_COMPLETE_SUCCESS: 'STAGE/COMPLETE_SUCCESS',
  STAGE_REOPEN_REQUEST: 'STAGE/REOPEN_REQUEST',
  STAGE_REOPEN_SUCCESS: 'STAGE/REOPEN_SUCCESS',
  TRACKED_ITEM_APPROVALS_REQUEST: 'TRACKED_ITEM_APPROVALS_REQUEST',
  TRACKED_ITEM_APPROVALS_UPDATE: 'TRACKED_ITEM_APPROVALS_UPDATE',
  TRANSITION_ACTIVATE_REQUEST: 'TRANSITION/ACTIVATE_REQUEST',
  TRANSITION_ACTIVATE: 'TRANSITION/ACTIVATE',
  TRANSITION_DEACTIVATE_REQUEST: 'TRANSITION/DEACTIVATE_REQUEST',
  TRANSITION_DEACTIVATE: 'TRANSITION/DEACTIVATE',
  TRANSITION_SELECTION_UPDATE: 'TRANSITION/SELECTION_UPDATE',
  TRANSITION_TAB_CHANGE_REQUEST: 'TRANSITION/TRANSITION_TAB_CHANGE_REQUEST',
  TRANSITION_TAB_CHANGE: 'TRANSITION/TRANSITION_TAB_CHANGE',
  CONDITIONS_SAVE_REQUEST: 'TRANSITION/CONDITIONS_SAVE_REQUEST',
  CONDITION_UPDATE_SUCCESS: 'TRANSITION/CONDITION_UPDATE_SUCCESS',
  CONDITION_RESET_SUCCESS: 'TRANSITION/CONDITION_RESET_SUCCESS',
  CONDITION_EDIT_MODE_CHANGE_REQUEST: 'TRANSITION/CONDITION_EDIT_MODE_CHANGE_REQUEST',
  CONDITION_EDIT_MODE_CHANGE_RESPONSE: 'TRANSITION/CONDITION_EDIT_MODE_CHANGE_RESPONSE',
  SET_DATETIME_FORMAT_REQUEST: 'DELIVERY/SET_DATETIME_FORMAT_REQUEST',
  SET_DATETIME_FORMAT_SUCCESS: 'DELIVERY/SET_DATETIME_FORMAT_SUCCESS',
  MARK_TRANSITION_AUTOMATED: 'TRANSITION/MARK_AUTOMATED_SUCCESS'
};
var createOrUpdateTrackedItem = function createOrUpdateTrackedItem(trackedItem, deliveryId) {
  return {
    type: actionTypes.TRACKED_ITEM_CREATE_OR_UPDATE_REQUEST,
    payload: {
      trackedItem: trackedItem,
      deliveryId: deliveryId
    }
  };
};
var fetchDeliveryDetails = function fetchDeliveryDetails(deliveryId) {
  return {
    type: actionTypes.TRACKED_ITEM_CREATE_OR_UPDATE_SUCCESS,
    payload: deliveryId
  };
};
var delivery_flow_actions_requestTrackedItemApprovals = function requestTrackedItemApprovals(deliveryId) {
  return {
    type: actionTypes.TRACKED_ITEM_APPROVALS_REQUEST,
    payload: deliveryId
  };
};
var updateTrackedItemApprovals = function updateTrackedItemApprovals(logs) {
  return {
    type: actionTypes.TRACKED_ITEM_APPROVALS_UPDATE,
    payload: logs
  };
};
var updateDataState = function updateDataState(delivery) {
  return {
    type: actionTypes.TRACKED_ITEM_UPDATE_DATA,
    payload: delivery
  };
};
var removeTrackedItem = function removeTrackedItem(id) {
  return {
    type: actionTypes.TRACKED_ITEM_REMOVE_REQUEST,
    payload: id
  };
};
var removedTrackedItem = function removedTrackedItem(id) {
  return {
    type: actionTypes.TRACKED_ITEM_REMOVE_SUCCESS,
    payload: id
  };
};
var delivery_flow_actions_descopeTrackedItem = function descopeTrackedItem(id) {
  return {
    type: actionTypes.TRACKED_ITEM_DESCOPE_REQUEST,
    payload: id
  };
};
var delivery_flow_actions_rescopeTrackedItem = function rescopeTrackedItem(id) {
  return {
    type: actionTypes.TRACKED_ITEM_RESCOPE_REQUEST,
    payload: id
  };
};
var delivery_flow_actions_skipTrackedItem = function skipTrackedItem(stage, trackedItem) {
  return {
    type: actionTypes.TRACKED_ITEM_SKIP_REQUEST,
    payload: {
      stage: stage,
      trackedItem: trackedItem
    }
  };
};
var delivery_flow_actions_completeTrackedItem = function completeTrackedItem(stage, trackedItem) {
  return {
    type: actionTypes.TRACKED_ITEM_COMPLETE_REQUEST,
    payload: {
      stage: stage,
      trackedItem: trackedItem
    }
  };
};
var trackedItemSkipped = function trackedItemSkipped(stage, trackedItem) {
  return {
    type: actionTypes.TRACKED_ITEM_SKIP_SUCCESS,
    payload: {
      stage: stage,
      trackedItem: trackedItem
    }
  };
};
var trackedItemCompleted = function trackedItemCompleted(stage, trackedItem) {
  return {
    type: actionTypes.TRACKED_ITEM_COMPLETE_SUCCESS,
    payload: {
      stage: stage,
      trackedItem: trackedItem
    }
  };
};
var delivery_flow_actions_getStageReleaseDetails = function getStageReleaseDetails(deliveryId) {
  return {
    type: actionTypes.TRACKED_ITEM_STAGE_RELEASE_REQUEST,
    payload: deliveryId
  };
};
var fetchStageReleasesSuccess = function fetchStageReleasesSuccess(releaseListDetails) {
  return {
    type: actionTypes.TRACKED_ITEM_STAGE_RELEASE_SUCCESS,
    payload: releaseListDetails
  };
};
var delivery_flow_actions_postTransitionDetails = function postTransitionDetails(deliveryId, transition, transitionItems) {
  return {
    type: actionTypes.TRACKED_ITEM_STAGE_TRANSITION_REQUEST,
    payload: {
      deliveryId: deliveryId,
      transition: transition,
      transitionItems: transitionItems
    }
  };
};
var delivery_flow_actions_fetchDeliveryDetailsWithPolling = function fetchDeliveryDetailsWithPolling(deliveryId) {
  return {
    type: actionTypes.TRACKED_ITEM_DELIVERY_DETAIL_START_POLLING,
    payload: {
      deliveryId: deliveryId
    }
  };
};
var delivery_flow_actions_stopPolling = function stopPolling() {
  return {
    type: actionTypes.TRACKED_ITEM_DELIVERY_DETAIL_STOP_POLLING
  };
};
var delivery_flow_actions_completeStage = function completeStage(id) {
  return {
    type: actionTypes.STAGE_COMPLETE_REQUEST,
    payload: id
  };
};
var delivery_flow_actions_reopenStage = function reopenStage(id) {
  return {
    type: actionTypes.STAGE_REOPEN_REQUEST,
    payload: id
  };
};
var delivery_flow_actions_activateTransition = function activateTransition(stage) {
  return {
    type: actionTypes.TRANSITION_ACTIVATE_REQUEST,
    payload: stage
  };
};
var updateActivateTransition = function updateActivateTransition(stage) {
  return {
    type: actionTypes.TRANSITION_ACTIVATE,
    payload: stage
  };
};
var delivery_flow_actions_deactivateTransition = function deactivateTransition() {
  return {
    type: actionTypes.TRANSITION_DEACTIVATE_REQUEST
  };
};
var updateDeactivateTransition = function updateDeactivateTransition() {
  return {
    type: actionTypes.TRANSITION_DEACTIVATE
  };
};
var delivery_flow_actions_updateTransitionSelection = function updateTransitionSelection(selection) {
  return {
    type: actionTypes.TRANSITION_SELECTION_UPDATE,
    payload: selection
  };
};
var delivery_flow_actions_changeTransitionTab = function changeTransitionTab(tab) {
  return {
    type: actionTypes.TRANSITION_TAB_CHANGE_REQUEST,
    payload: tab
  };
};
var updateTransitionTabValue = function updateTransitionTabValue(tab) {
  return {
    type: actionTypes.TRANSITION_TAB_CHANGE,
    payload: tab
  };
};
var delivery_flow_actions_saveConditions = function saveConditions() {
  return {
    type: actionTypes.CONDITIONS_SAVE_REQUEST
  };
};
var delivery_flow_actions_updateCondition = function updateCondition(conditionId, fixedDate) {
  return {
    type: actionTypes.CONDITION_UPDATE_SUCCESS,
    payload: {
      conditionId: conditionId,
      fixedDate: fixedDate
    }
  };
};
var delivery_flow_actions_resetConditions = function resetConditions() {
  return {
    type: actionTypes.CONDITION_RESET_SUCCESS
  };
};
var delivery_flow_actions_showConditionEditMode = function showConditionEditMode(isConditionEditMode) {
  return {
    type: actionTypes.CONDITION_EDIT_MODE_CHANGE_REQUEST,
    payload: isConditionEditMode
  };
};
var changeConditionEditMode = function changeConditionEditMode(isConditionEditMode) {
  return {
    type: actionTypes.CONDITION_EDIT_MODE_CHANGE_RESPONSE,
    payload: isConditionEditMode
  };
};
var delivery_flow_actions_setDateTimeFormat = function setDateTimeFormat() {
  return {
    type: actionTypes.SET_DATETIME_FORMAT_REQUEST
  };
};
var dateTimeFormatSet = function dateTimeFormatSet(data) {
  return {
    type: actionTypes.SET_DATETIME_FORMAT_SUCCESS,
    payload: data
  };
};
var delivery_flow_actions_markTransitionAutomated = function markTransitionAutomated() {
  return {
    type: actionTypes.MARK_TRANSITION_AUTOMATED
  };
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/delivery-flow.utils.js
var countSelectedTransitionItems = function countSelectedTransitionItems(items) {
  return items.filter(function (item) {
    return item.transitionItem && !item.transitionItem.disabled && item.transitionItem.checked;
  }).length;
};
var isDisabledTransition = function isDisabledTransition(transition) {
  return transition.selectedTransitionItemCount === 0 && !transition.closeStages;
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/delivery-flow.constants.js
var trackedItemStatus = {
  notReady: 'NOT_READY',
  ready: 'READY',
  skipped: 'SKIPPED'
};
var deliveryStatus = {
  inProgress: 'IN_PROGRESS',
  completed: 'COMPLETED',
  pattern: 'TEMPLATE'
};
var activePhaseStatuses = ['IN_PROGRESS', 'FAILING', 'FAILED'];
var activeTaskStatus = ['PENDING', 'PRECONDITION_IN_PROGRESS', 'FAILURE_HANDLER_IN_PROGRESS', 'IN_PROGRESS', 'FAILING', 'FAILED', 'WAITING_FOR_INPUT'];
var transitionTabs = [{
  value: 0,
  label: 'Automated'
}, {
  value: 1,
  label: 'Manual'
}];
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/ducks/delivery-flow.reducer.js



function delivery_flow_reducer_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function delivery_flow_reducer_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_flow_reducer_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_flow_reducer_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }






 // -- REDUCER --

var delivery_flow_reducer_initialState = function initialState() {
  return {
    activeStageReleases: [],
    loadingReleasesInfo: false,
    trackedItems: [],
    stages: [],
    status: '',
    trackedItemApprovals: [],
    activeTransition: {
      id: null,
      items: [],
      status: null,
      automated: null
    },
    activeTransitionTab: transitionTabs[0].value,
    conditionChanges: [],
    // [ {id: conditionId1, time: time1}, {id: conditionId2, time: time2} ]
    isConditionEditMode: false,
    dateFormat: 'MMM DD, YYYY',
    timeFormat: 'h:mm a'
  };
};

var delivery_flow_reducer_deliveryFlow = function deliveryFlow() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : delivery_flow_reducer_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case actionTypes.TRACKED_ITEM_APPROVALS_UPDATE:
      {
        return delivery_flow_reducer_objectSpread({}, state, {
          trackedItemApprovals: action.payload
        });
      }

    case actionTypes.TRACKED_ITEM_UPDATE_DATA:
      {
        var activeTransition = state.activeTransition;
        var _action$payload = action.payload,
            trackedItems = _action$payload.trackedItems,
            stages = _action$payload.stages,
            status = _action$payload.status;
        var formattedStages = delivery_flow_reducer_mapTransitionsInStages(stages, trackedItems, state.activeTransition);

        if (!!activeTransition.id) {
          var activeStage = formattedStages.find(function (s) {
            return s.transition && s.transition.id === activeTransition.id;
          });

          if (!!activeStage) {
            activeTransition.items = activeStage.items.filter(function (item) {
              return item.transitionItem !== null;
            });
            activeTransition.status = activeStage.transition;
          }
        }

        return delivery_flow_reducer_objectSpread({}, state, {
          trackedItems: trackedItems,
          stages: formattedStages,
          status: status
        });
      }

    case actionTypes.TRACKED_ITEM_REMOVE_SUCCESS:
      {
        var _trackedItems = state.trackedItems,
            _activeTransition = state.activeTransition;

        if (!!_activeTransition.id) {
          _activeTransition.items = toConsumableArray_default()(_activeTransition.items.filter(function (item) {
            return item.trackedItemId !== action.payload;
          }));
        }

        return delivery_flow_reducer_objectSpread({}, state, {
          trackedItems: _trackedItems.filter(function (item) {
            return item.id !== action.payload;
          })
        });
      }

    case actionTypes.TRACKED_ITEM_STAGE_RELEASE_REQUEST:
      {
        return delivery_flow_reducer_objectSpread({}, state, {
          loadingReleasesInfo: true
        });
      }

    case actionTypes.TRACKED_ITEM_STAGE_RELEASE_SUCCESS:
      {
        return delivery_flow_reducer_objectSpread({}, state, {
          activeStageReleases: action.payload,
          loadingReleasesInfo: false
        });
      }

    case actionTypes.TRANSITION_ACTIVATE:
      {
        return delivery_flow_reducer_objectSpread({}, state, {
          activeTransition: action.payload,
          activeTransitionTab: delivery_flow_reducer_initialState().activeTransitionTab
        });
      }

    case actionTypes.TRANSITION_DEACTIVATE:
      {
        return delivery_flow_reducer_objectSpread({}, state, {
          activeTransition: delivery_flow_reducer_initialState().activeTransition
        });
      }

    case actionTypes.TRANSITION_SELECTION_UPDATE:
      {
        return delivery_flow_reducer_objectSpread({}, state, {
          activeTransition: {
            id: state.activeTransition.id,
            items: action.payload.items,
            status: action.payload.status
          }
        });
      }

    case actionTypes.TRANSITION_TAB_CHANGE:
      {
        return delivery_flow_reducer_objectSpread({}, state, {
          activeTransitionTab: action.payload
        });
      }

    case actionTypes.TRACKED_ITEM_SKIP_SUCCESS:
      {
        var _stages = state.stages,
            _activeTransition2 = state.activeTransition,
            _trackedItems2 = state.trackedItems;
        var _action$payload2 = action.payload,
            stage = _action$payload2.stage,
            trackedItem = _action$payload2.trackedItem;
        var updatedState = delivery_flow_reducer_updateItemStatus(_stages, _activeTransition2, stage, trackedItem, trackedItemStatus.skipped, _trackedItems2);
        return delivery_flow_reducer_objectSpread({}, state, {
          stages: updatedState.stages,
          activeTransition: updatedState.activeTransition
        });
      }

    case actionTypes.TRACKED_ITEM_COMPLETE_SUCCESS:
      {
        var _stages2 = state.stages,
            _activeTransition3 = state.activeTransition,
            _trackedItems3 = state.trackedItems;
        var _action$payload3 = action.payload,
            _stage = _action$payload3.stage,
            _trackedItem = _action$payload3.trackedItem;

        var _updatedState = delivery_flow_reducer_updateItemStatus(_stages2, _activeTransition3, _stage, _trackedItem, trackedItemStatus.ready, _trackedItems3);

        return delivery_flow_reducer_objectSpread({}, state, {
          stages: _updatedState.stages,
          activeTransition: _updatedState.activeTransition
        });
      }

    case actionTypes.CONDITION_UPDATE_SUCCESS:
      {
        var _action$payload4 = action.payload,
            conditionId = _action$payload4.conditionId,
            fixedDate = _action$payload4.fixedDate;
        var conditionChanges = state.conditionChanges.map(function (c) {
          return delivery_flow_reducer_objectSpread({}, c);
        }) || [];
        var found = conditionChanges.find(function (c) {
          return c.id === conditionId;
        });

        if (found) {
          found.fixedDate = fixedDate;
        } else {
          conditionChanges.push({
            id: conditionId,
            fixedDate: fixedDate
          });
        }

        return delivery_flow_reducer_objectSpread({}, state, {
          conditionChanges: conditionChanges
        });
      }

    case actionTypes.CONDITION_RESET_SUCCESS:
      {
        return delivery_flow_reducer_objectSpread({}, state, {
          conditionChanges: []
        });
      }

    case actionTypes.CONDITION_EDIT_MODE_CHANGE_RESPONSE:
      {
        return delivery_flow_reducer_objectSpread({}, state, {
          isConditionEditMode: action.payload
        });
      }

    case actionTypes.SET_DATETIME_FORMAT_SUCCESS:
      {
        return delivery_flow_reducer_objectSpread({}, state, {
          dateFormat: action.payload.mediumDate,
          timeFormat: action.payload.shortTime
        });
      }

    case actionTypes.MARK_TRANSITION_AUTOMATED:
      {
        return delivery_flow_reducer_objectSpread({}, state, {
          activeTransition: delivery_flow_reducer_objectSpread({}, state.activeTransition, {
            status: delivery_flow_reducer_objectSpread({}, state.activeTransition.status, {
              automated: true
            })
          })
        });
      }

    default:
      return state;
  }
};

var delivery_flow_reducer_updateItemStatus = function updateItemStatus(oldStages, activeTransition, stage, trackedItem, itemStatus, trackedItems) {
  var stagesWithUpdatedItem = oldStages.map(function (s) {
    if (s.id === stage.id) {
      var items = s.items.map(function (item) {
        if (item.trackedItemId === trackedItem.id) {
          return delivery_flow_reducer_objectSpread({}, item, {
            status: itemStatus
          });
        }

        return delivery_flow_reducer_objectSpread({}, item);
      });
      return delivery_flow_reducer_objectSpread({}, s, {
        items: items
      });
    }

    return s;
  });
  var stages = stagesWithUpdatedItem.map(function (s, stageIndex) {
    if (s.transition) {
      var expandedStage = delivery_flow_reducer_formatTransitionOnStage(s.transition, trackedItems, activeTransition, stagesWithUpdatedItem, stageIndex);
      return expandedStage;
    } else {
      return s;
    }
  });

  if (!!activeTransition.id) {
    var stageWithActiveTransition = stages.find(function (s) {
      return s.id === activeTransition.status.stage;
    });
    activeTransition.items = stageWithActiveTransition.items.filter(function (item) {
      return item.transitionItem !== null;
    });
    activeTransition.status.selectedTransitionItemCount = countSelectedTransitionItems(stageWithActiveTransition.items);
  }

  return {
    stages: stages,
    activeTransition: activeTransition
  };
};

var delivery_flow_reducer_mapTransitionsInStages = function mapTransitionsInStages(stages, trackedItems, activeTransition) {
  // create an object with transitions and tracked item status whether its moved to other
  // stage or not this will help us to decide whether to show the checkbox as checked or not
  var modifiedStages = [];

  for (var stageIndex = 0; stageIndex < stages.length - 1; stageIndex++) {
    var transition = stages[stageIndex].transition;

    if (transition && !!transition) {
      var expandedStage = delivery_flow_reducer_formatTransitionOnStage(transition, trackedItems, activeTransition, stages, stageIndex);
      modifiedStages.push(expandedStage);
    } else {
      modifiedStages.push(stages[stageIndex]);
    }
  }

  modifiedStages.push(last_default()(stages));
  return modifiedStages;
};

var delivery_flow_reducer_formatTransitionOnStage = function formatTransitionOnStage(transition, trackedItems, activeTransition, stages, stageIndex) {
  var isItemDoneInStage = function isItemDoneInStage(stage, trackedItemId) {
    return stage.items.some(function (stageItem) {
      return stageItem.trackedItemId === trackedItemId && (stageItem.status === trackedItemStatus.ready || stageItem.status === trackedItemStatus.skipped);
    });
  }; // completed items for checkbox visibility


  var listOfReadyItemsInCurrentStage = stages[stageIndex].items.filter(function (currItem) {
    return !trackedItems.find(function (item) {
      return item.id === currItem.trackedItemId;
    }).descoped && stages.slice(0, stageIndex + 1).every(function (stage) {
      return isItemDoneInStage(stage, currItem.trackedItemId);
    });
  });
  var listOfItemsInNextStage = stages[stageIndex + 1].items; // compare next stage for availability

  var readyItems = differenceBy_default()(listOfReadyItemsInCurrentStage, listOfItemsInNextStage, 'trackedItemId');
  var alreadyTransitionedItems = intersectionBy_default()(listOfReadyItemsInCurrentStage, listOfItemsInNextStage, 'trackedItemId');
  var readyItemsExpanded = readyItems.map(function (item) {
    return delivery_flow_reducer_objectSpread({}, item, {
      transitionItem: {
        disabled: false,
        checked: true
      }
    });
  });
  var alreadyTransitionedItemsExpanded = alreadyTransitionedItems.map(function (item) {
    return delivery_flow_reducer_objectSpread({}, item, {
      transitionItem: {
        disabled: true,
        checked: true
      }
    });
  });
  var transitionItems = [].concat(toConsumableArray_default()(readyItemsExpanded), toConsumableArray_default()(alreadyTransitionedItemsExpanded));

  if (activeTransition.id && transition.id === activeTransition.id) {
    transitionItems.filter(function (item) {
      return !item.transitionItem.disabled;
    }).forEach(function (item) {
      var activeItem = activeTransition.items.find(function (i) {
        return i.id === item.id;
      });

      if (activeItem && activeItem.transitionItem) {
        item.transitionItem.checked = activeItem.transitionItem.checked;
        item.transitionItem.disabled = activeItem.transitionItem.disabled;
      } else {
        item.transitionItem.checked = false;
      }
    });
  }

  var items = stages[stageIndex].items.map(function (item) {
    var i = transitionItems.find(function (transitionItem) {
      return transitionItem.trackedItemId === item.trackedItemId;
    });

    if (i) {
      return delivery_flow_reducer_objectSpread({}, i);
    } else {
      return delivery_flow_reducer_objectSpread({}, item, {
        transitionItem: null
      });
    }
  });

  var expandedStage = delivery_flow_reducer_objectSpread({}, stages[stageIndex], {
    items: items,
    transition: delivery_flow_reducer_objectSpread({}, transition, {
      selectedTransitionItemCount: countSelectedTransitionItems(items),
      closeStages: activeTransition.status ? activeTransition.status.closeStages : false
    }),
    selectableItemsCount: readyItems.length
  });

  expandedStage.transition.disabledTransition = isDisabledTransition(expandedStage.transition);
  return expandedStage;
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/delivery-flow.service.js


function delivery_flow_service_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function delivery_flow_service_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_flow_service_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_flow_service_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }


var delivery_flow_service_API_URL = 'api/v1/deliveries';

function createItem(deliveryId, item) {
  return Object(http["d" /* httpPOST */])("".concat(delivery_flow_service_API_URL, "/").concat(deliveryId, "/tracked-items"), delivery_flow_service_objectSpread({}, item, {
    id: null,
    type: 'delivery.TrackedItem'
  })).then(function (res) {
    return res.data;
  });
}

function updateItem(item) {
  return Object(http["e" /* httpPUT */])("".concat(delivery_flow_service_API_URL, "/").concat(item.id), item).then(function (res) {
    return res.data;
  });
}

function removeItem(itemId) {
  return Object(http["b" /* httpDELETE */])("".concat(delivery_flow_service_API_URL, "/").concat(itemId)).then(function (res) {
    return res.data;
  });
}

function descopeItem(itemId) {
  return Object(http["e" /* httpPUT */])("".concat(delivery_flow_service_API_URL, "/").concat(itemId, "/descope")).then(function (res) {
    return res.data;
  });
}

function rescopeItem(itemId) {
  return Object(http["e" /* httpPUT */])("".concat(delivery_flow_service_API_URL, "/").concat(itemId, "/rescope")).then(function (res) {
    return res.data;
  });
}

function skipItem(stageId, trackedItemId) {
  return Object(http["e" /* httpPUT */])("".concat(delivery_flow_service_API_URL, "/").concat(stageId, "/").concat(trackedItemId, "/skip")).then(function (res) {
    return res.data;
  });
}

function completeItem(stageId, trackedItemId) {
  return Object(http["e" /* httpPUT */])("".concat(delivery_flow_service_API_URL, "/").concat(stageId, "/").concat(trackedItemId, "/complete")).then(function (res) {
    return res.data;
  });
}

function delivery_flow_service_list(deliveryId) {
  return Object(http["c" /* httpGET */])("".concat(delivery_flow_service_API_URL, "/").concat(deliveryId, "/tracked-items")).then(function (res) {
    return res.data;
  });
}

function fetchStageReleases(deliveryId) {
  return Object(http["c" /* httpGET */])("".concat(delivery_flow_service_API_URL, "/").concat(deliveryId, "/releasesInfo")).then(function (res) {
    return res.data;
  });
}

function makeTransition(transitionId, completableTrackedItems) {
  return Object(http["d" /* httpPOST */])("".concat(delivery_flow_service_API_URL, "/").concat(transitionId, "/complete"), completableTrackedItems);
}

function delivery_flow_service_completeStage(stageId) {
  return Object(http["d" /* httpPOST */])("".concat(delivery_flow_service_API_URL, "/").concat(stageId, "/complete"));
}

function delivery_flow_service_reopenStage(stageId) {
  return Object(http["d" /* httpPOST */])("".concat(delivery_flow_service_API_URL, "/").concat(stageId, "/reopen"));
}

function delivery_flow_service_updateTransition(transition) {
  return Object(http["e" /* httpPUT */])("".concat(delivery_flow_service_API_URL, "/").concat(transition.id), delivery_flow_service_objectSpread({}, transition, {
    type: 'delivery.Transition',
    stage: undefined
  }));
}

var deliveryFlowService = {
  createItem: createItem,
  updateItem: updateItem,
  removeItem: removeItem,
  descopeItem: descopeItem,
  rescopeItem: rescopeItem,
  skipItem: skipItem,
  completeItem: completeItem,
  list: delivery_flow_service_list,
  fetchStageReleases: fetchStageReleases,
  makeTransition: makeTransition,
  completeStage: delivery_flow_service_completeStage,
  reopenStage: delivery_flow_service_reopenStage,
  updateTransition: delivery_flow_service_updateTransition
};
// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/ids.js
var util_ids = __webpack_require__(62);

// EXTERNAL MODULE: ./core/xlr-ui/app/react/utils/sagas.js
var sagas = __webpack_require__(108);

// EXTERNAL MODULE: ./node_modules/lodash/cloneDeep.js
var cloneDeep = __webpack_require__(102);
var cloneDeep_default = /*#__PURE__*/__webpack_require__.n(cloneDeep);

// EXTERNAL MODULE: ./core/xlr-ui/app/features/common/services/angular-accessor.js
var angular_accessor = __webpack_require__(34);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/ducks/delivery-flow.sagas.js


var _marked = /*#__PURE__*/regenerator_default.a.mark(createOrUpdateItem),
    _marked2 = /*#__PURE__*/regenerator_default.a.mark(delivery_flow_sagas_removeItem),
    _marked3 = /*#__PURE__*/regenerator_default.a.mark(delivery_flow_sagas_descopeItem),
    _marked4 = /*#__PURE__*/regenerator_default.a.mark(delivery_flow_sagas_rescopeItem),
    _marked5 = /*#__PURE__*/regenerator_default.a.mark(delivery_flow_sagas_skipItem),
    _marked6 = /*#__PURE__*/regenerator_default.a.mark(delivery_flow_sagas_completeItem),
    _marked7 = /*#__PURE__*/regenerator_default.a.mark(delivery_flow_sagas_fetchDelivery),
    _marked8 = /*#__PURE__*/regenerator_default.a.mark(fetchTrackedItemApprovals),
    _marked9 = /*#__PURE__*/regenerator_default.a.mark(fetchStagesReleases),
    _marked10 = /*#__PURE__*/regenerator_default.a.mark(postTransition),
    _marked11 = /*#__PURE__*/regenerator_default.a.mark(fetchWithPolling),
    _marked12 = /*#__PURE__*/regenerator_default.a.mark(fetchFullDeliveryDetails),
    _marked13 = /*#__PURE__*/regenerator_default.a.mark(watchFetchDeliveryWithPollingSaga),
    _marked14 = /*#__PURE__*/regenerator_default.a.mark(completeStageInDelivery),
    _marked15 = /*#__PURE__*/regenerator_default.a.mark(reopenStageInDelivery),
    _marked16 = /*#__PURE__*/regenerator_default.a.mark(changeConditionDisplayMode),
    _marked17 = /*#__PURE__*/regenerator_default.a.mark(saveConditionChanges),
    _marked18 = /*#__PURE__*/regenerator_default.a.mark(onActivateTransition),
    _marked19 = /*#__PURE__*/regenerator_default.a.mark(onDeactivateTransition),
    _marked20 = /*#__PURE__*/regenerator_default.a.mark(onTransitionTabChange),
    _marked21 = /*#__PURE__*/regenerator_default.a.mark(checkIsAvailableToLeaveConditionBlock),
    _marked22 = /*#__PURE__*/regenerator_default.a.mark(setupDateTimeFormat),
    _marked23 = /*#__PURE__*/regenerator_default.a.mark(deliveryFlowSagas);









var POLLING_INTERVAL = 5000; // -- SAGAS --

function createOrUpdateItem(action) {
  var _action$payload, trackedItem, deliveryId;

  return regenerator_default.a.wrap(function createOrUpdateItem$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _action$payload = action.payload, trackedItem = _action$payload.trackedItem, deliveryId = _action$payload.deliveryId;

          if (!trackedItem.id) {
            _context.next = 9;
            break;
          }

          _context.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.updateItem, trackedItem);

        case 5:
          _context.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(fetchDeliveryDetails(deliveryId));

        case 7:
          _context.next = 13;
          break;

        case 9:
          _context.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.createItem, deliveryId, trackedItem);

        case 11:
          _context.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(fetchDeliveryDetails(deliveryId));

        case 13:
          _context.next = 18;
          break;

        case 15:
          _context.prev = 15;
          _context.t0 = _context["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Something went wrong while creating or updating tracking item...', _context.t0);
          /* eslint-enable */

        case 18:
        case "end":
          return _context.stop();
      }
    }
  }, _marked, null, [[0, 15]]);
}

function delivery_flow_sagas_removeItem(action) {
  var id;
  return regenerator_default.a.wrap(function removeItem$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          id = action.payload;
          _context2.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.removeItem, id);

        case 4:
          _context2.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(removedTrackedItem(id));

        case 6:
          _context2.next = 11;
          break;

        case 8:
          _context2.prev = 8;
          _context2.t0 = _context2["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Something went wrong while removing tracking item...', _context2.t0);
          /* eslint-enable */

        case 11:
        case "end":
          return _context2.stop();
      }
    }
  }, _marked2, null, [[0, 8]]);
}

function delivery_flow_sagas_descopeItem(action) {
  var id;
  return regenerator_default.a.wrap(function descopeItem$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          _context3.prev = 0;
          id = action.payload;
          _context3.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.descopeItem, id);

        case 4:
          _context3.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(fetchDeliveryDetails(Object(util_ids["a" /* default */])().getParentId(id)));

        case 6:
          _context3.next = 11;
          break;

        case 8:
          _context3.prev = 8;
          _context3.t0 = _context3["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Something went wrong while descoping tracking item...', _context3.t0);
          /* eslint-enable */

        case 11:
        case "end":
          return _context3.stop();
      }
    }
  }, _marked3, null, [[0, 8]]);
}

function delivery_flow_sagas_rescopeItem(action) {
  var id;
  return regenerator_default.a.wrap(function rescopeItem$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _context4.prev = 0;
          id = action.payload;
          _context4.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.rescopeItem, id);

        case 4:
          _context4.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(fetchDeliveryDetails(Object(util_ids["a" /* default */])().getParentId(id)));

        case 6:
          _context4.next = 11;
          break;

        case 8:
          _context4.prev = 8;
          _context4.t0 = _context4["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Something went wrong while rescoping tracked item...', _context4.t0);
          /* eslint-enable */

        case 11:
        case "end":
          return _context4.stop();
      }
    }
  }, _marked4, null, [[0, 8]]);
}

function delivery_flow_sagas_skipItem(action) {
  var _action$payload2, stage, trackedItem;

  return regenerator_default.a.wrap(function skipItem$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _context5.prev = 0;
          _action$payload2 = action.payload, stage = _action$payload2.stage, trackedItem = _action$payload2.trackedItem;
          _context5.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.skipItem, stage.id, trackedItem.id);

        case 4:
          _context5.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(trackedItemSkipped(stage, trackedItem));

        case 6:
          _context5.next = 11;
          break;

        case 8:
          _context5.prev = 8;
          _context5.t0 = _context5["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Something went wrong while skipping tracking item...', _context5.t0);
          /* eslint-enable */

        case 11:
        case "end":
          return _context5.stop();
      }
    }
  }, _marked5, null, [[0, 8]]);
}

function delivery_flow_sagas_completeItem(action) {
  var _action$payload3, stage, trackedItem;

  return regenerator_default.a.wrap(function completeItem$(_context6) {
    while (1) {
      switch (_context6.prev = _context6.next) {
        case 0:
          _context6.prev = 0;
          _action$payload3 = action.payload, stage = _action$payload3.stage, trackedItem = _action$payload3.trackedItem;
          _context6.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.completeItem, stage.id, trackedItem.id);

        case 4:
          _context6.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(trackedItemCompleted(stage, trackedItem));

        case 6:
          _context6.next = 11;
          break;

        case 8:
          _context6.prev = 8;
          _context6.t0 = _context6["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Something went wrong while completing tracking item...', _context6.t0);
          /* eslint-enable */

        case 11:
        case "end":
          return _context6.stop();
      }
    }
  }, _marked6, null, [[0, 8]]);
}

function delivery_flow_sagas_fetchDelivery(action) {
  var deliveryResponse;
  return regenerator_default.a.wrap(function fetchDelivery$(_context7) {
    while (1) {
      switch (_context7.prev = _context7.next) {
        case 0:
          _context7.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(services["d" /* getDelivery */], action.payload);

        case 2:
          deliveryResponse = _context7.sent;
          _context7.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(updateDataState(deliveryResponse.data));

        case 5:
        case "end":
          return _context7.stop();
      }
    }
  }, _marked7);
}

function fetchTrackedItemApprovals(action) {
  var response;
  return regenerator_default.a.wrap(function fetchTrackedItemApprovals$(_context8) {
    while (1) {
      switch (_context8.prev = _context8.next) {
        case 0:
          _context8.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(services["e" /* getTrackedItemApprovals */], action.payload);

        case 2:
          response = _context8.sent;
          _context8.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(updateTrackedItemApprovals(response.data));

        case 5:
        case "end":
          return _context8.stop();
      }
    }
  }, _marked8);
}

function fetchStagesReleases(action) {
  var releaseDetailsList;
  return regenerator_default.a.wrap(function fetchStagesReleases$(_context9) {
    while (1) {
      switch (_context9.prev = _context9.next) {
        case 0:
          _context9.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.fetchStageReleases, action.payload);

        case 2:
          releaseDetailsList = _context9.sent;
          _context9.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(fetchStageReleasesSuccess(releaseDetailsList));

        case 5:
        case "end":
          return _context9.stop();
      }
    }
  }, _marked9);
}

function postTransition(action) {
  var _action$payload4, deliveryId, transition, transitionItems;

  return regenerator_default.a.wrap(function postTransition$(_context10) {
    while (1) {
      switch (_context10.prev = _context10.next) {
        case 0:
          _context10.prev = 0;
          _action$payload4 = action.payload, deliveryId = _action$payload4.deliveryId, transition = _action$payload4.transition, transitionItems = _action$payload4.transitionItems;
          _context10.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.makeTransition, transition.id, {
            transitionItems: transitionItems,
            closeStages: transition.closeStages
          });

        case 4:
          _context10.next = 6;
          return fetchFullDeliveryDetails(deliveryId);

        case 6:
          _context10.next = 11;
          break;

        case 8:
          _context10.prev = 8;
          _context10.t0 = _context10["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Something went wrong while posting transition...', _context10.t0);
          /* eslint-enable */

        case 11:
        case "end":
          return _context10.stop();
      }
    }
  }, _marked10, null, [[0, 8]]);
}

function delay(duration) {
  var promise = new Promise(function (resolve) {
    setTimeout(function () {
      return resolve(true);
    }, duration);
  });
  return promise;
}

function fetchWithPolling(action) {
  var deliveryId;
  return regenerator_default.a.wrap(function fetchWithPolling$(_context11) {
    while (1) {
      switch (_context11.prev = _context11.next) {
        case 0:
          if (false) {}

          _context11.prev = 1;
          deliveryId = action.payload.deliveryId;
          _context11.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(delay, POLLING_INTERVAL);

        case 5:
          _context11.next = 7;
          return fetchFullDeliveryDetails(deliveryId);

        case 7:
          _context11.next = 13;
          break;

        case 9:
          _context11.prev = 9;
          _context11.t0 = _context11["catch"](1);
          _context11.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: actionTypes.TRACKED_ITEM_DELIVERY_DETAIL_POLLING_FAILURE,
            payload: _context11.t0
          });

        case 13:
          _context11.next = 0;
          break;

        case 15:
        case "end":
          return _context11.stop();
      }
    }
  }, _marked11, null, [[1, 9]]);
}

function fetchFullDeliveryDetails(deliveryId) {
  return regenerator_default.a.wrap(function fetchFullDeliveryDetails$(_context12) {
    while (1) {
      switch (_context12.prev = _context12.next) {
        case 0:
          _context12.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(fetchDeliveryDetails(deliveryId));

        case 2:
          _context12.next = 4;
          return fetchStagesReleases({
            payload: deliveryId
          });

        case 4:
          _context12.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(delivery_flow_actions_requestTrackedItemApprovals(deliveryId));

        case 6:
        case "end":
          return _context12.stop();
      }
    }
  }, _marked12);
}

function watchFetchDeliveryWithPollingSaga() {
  var myAction;
  return regenerator_default.a.wrap(function watchFetchDeliveryWithPollingSaga$(_context13) {
    while (1) {
      switch (_context13.prev = _context13.next) {
        case 0:
          if (false) {}

          _context13.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["j" /* take */])(actionTypes.TRACKED_ITEM_DELIVERY_DETAIL_START_POLLING);

        case 3:
          myAction = _context13.sent;
          _context13.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["h" /* race */])([Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(fetchWithPolling, myAction), Object(redux_saga_effects_npm_proxy_esm["j" /* take */])(actionTypes.TRACKED_ITEM_DELIVERY_DETAIL_STOP_POLLING)]);

        case 6:
          _context13.next = 0;
          break;

        case 8:
        case "end":
          return _context13.stop();
      }
    }
  }, _marked13);
}

function completeStageInDelivery(action) {
  var id;
  return regenerator_default.a.wrap(function completeStageInDelivery$(_context14) {
    while (1) {
      switch (_context14.prev = _context14.next) {
        case 0:
          id = action.payload;
          _context14.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.completeStage, id);

        case 3:
          _context14.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(fetchDeliveryDetails(Object(util_ids["a" /* default */])().getParentId(id)));

        case 5:
        case "end":
          return _context14.stop();
      }
    }
  }, _marked14);
}

function reopenStageInDelivery(action) {
  var id;
  return regenerator_default.a.wrap(function reopenStageInDelivery$(_context15) {
    while (1) {
      switch (_context15.prev = _context15.next) {
        case 0:
          id = action.payload;
          _context15.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.reopenStage, id);

        case 3:
          _context15.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(fetchDeliveryDetails(Object(util_ids["a" /* default */])().getParentId(id)));

        case 5:
        case "end":
          return _context15.stop();
      }
    }
  }, _marked15);
}

var getConditionChanges = function getConditionChanges(state) {
  return state.deliveryFlow.conditionChanges;
};
var delivery_flow_sagas_getStages = function getStages(state) {
  return state.deliveryFlow.stages;
};
var getActiveTransition = function getActiveTransition(state) {
  return state.deliveryFlow.activeTransition;
};
var getConditionEditMode = function getConditionEditMode(state) {
  return state.deliveryFlow.isConditionEditMode;
};
var delivery_flow_sagas_prepareTransition = function prepareTransition(stages, transitionId, changes, automated) {
  var stageId = Object(util_ids["a" /* default */])().getParentId(transitionId);
  var transition = cloneDeep_default()(stages.find(function (s) {
    return s.id === stageId;
  }).transition);
  ['selectedTransitionItemCount', 'closeStages', 'disabledTransition'].forEach(function (prop) {
    return delete transition[prop];
  });
  var conditions = transition.conditions[0].conditions.flatMap(function (c) {
    return c.conditions;
  });
  changes.forEach(function (change) {
    conditions.find(function (cond) {
      return cond.id === change.id;
    }).fixedDate = change.fixedDate;
  });
  transition.automated = automated;
  return {
    deliveryId: Object(util_ids["a" /* default */])().getParentId(stageId),
    transition: transition
  };
};
function changeConditionDisplayMode(action) {
  var isEditMode;
  return regenerator_default.a.wrap(function changeConditionDisplayMode$(_context16) {
    while (1) {
      switch (_context16.prev = _context16.next) {
        case 0:
          isEditMode = action.payload;
          _context16.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(changeConditionEditMode(isEditMode));

        case 3:
          _context16.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(delivery_flow_actions_resetConditions());

        case 5:
          if (isEditMode) {
            _context16.next = 8;
            break;
          }

          _context16.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 8:
        case "end":
          return _context16.stop();
      }
    }
  }, _marked16);
}
function saveConditionChanges() {
  var changes, activeTransition, stages, _yield$call, deliveryId, transition;

  return regenerator_default.a.wrap(function saveConditionChanges$(_context17) {
    while (1) {
      switch (_context17.prev = _context17.next) {
        case 0:
          _context17.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getConditionChanges);

        case 2:
          changes = _context17.sent;
          _context17.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getActiveTransition);

        case 5:
          activeTransition = _context17.sent;

          if (!(changes.length > 0 || activeTransition.status.automated)) {
            _context17.next = 25;
            break;
          }

          _context17.next = 9;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(delivery_flow_sagas_getStages);

        case 9:
          stages = _context17.sent;
          _context17.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(delivery_flow_sagas_prepareTransition, stages, activeTransition.id, changes, activeTransition.status.automated);

        case 12:
          _yield$call = _context17.sent;
          deliveryId = _yield$call.deliveryId;
          transition = _yield$call.transition;
          _context17.next = 17;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.updateTransition, transition);

        case 17:
          _context17.next = 19;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(fetchDeliveryDetails(deliveryId));

        case 19:
          _context17.next = 21;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(changeConditionEditMode(false));

        case 21:
          _context17.next = 23;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 23:
          _context17.next = 25;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(delivery_flow_actions_resetConditions());

        case 25:
        case "end":
          return _context17.stop();
      }
    }
  }, _marked17);
}

function onActivateTransition(action) {
  var isChangeable;
  return regenerator_default.a.wrap(function onActivateTransition$(_context18) {
    while (1) {
      switch (_context18.prev = _context18.next) {
        case 0:
          _context18.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(checkIsAvailableToLeaveConditionBlock);

        case 2:
          isChangeable = _context18.sent;

          if (!isChangeable) {
            _context18.next = 6;
            break;
          }

          _context18.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(updateActivateTransition(action.payload));

        case 6:
        case "end":
          return _context18.stop();
      }
    }
  }, _marked18);
}

function onDeactivateTransition() {
  var isChangeable;
  return regenerator_default.a.wrap(function onDeactivateTransition$(_context19) {
    while (1) {
      switch (_context19.prev = _context19.next) {
        case 0:
          _context19.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(checkIsAvailableToLeaveConditionBlock);

        case 2:
          isChangeable = _context19.sent;

          if (!isChangeable) {
            _context19.next = 6;
            break;
          }

          _context19.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(updateDeactivateTransition());

        case 6:
        case "end":
          return _context19.stop();
      }
    }
  }, _marked19);
}

function onTransitionTabChange(action) {
  var isChangeable;
  return regenerator_default.a.wrap(function onTransitionTabChange$(_context20) {
    while (1) {
      switch (_context20.prev = _context20.next) {
        case 0:
          _context20.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(checkIsAvailableToLeaveConditionBlock);

        case 2:
          isChangeable = _context20.sent;

          if (!isChangeable) {
            _context20.next = 6;
            break;
          }

          _context20.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(updateTransitionTabValue(action.payload));

        case 6:
        case "end":
          return _context20.stop();
      }
    }
  }, _marked20);
}

function checkIsAvailableToLeaveConditionBlock() {
  var isConditionEditMode, changes;
  return regenerator_default.a.wrap(function checkIsAvailableToLeaveConditionBlock$(_context21) {
    while (1) {
      switch (_context21.prev = _context21.next) {
        case 0:
          _context21.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getConditionEditMode);

        case 2:
          isConditionEditMode = _context21.sent;
          _context21.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getConditionChanges);

        case 5:
          changes = _context21.sent;

          if (!(isConditionEditMode && changes.length > 0)) {
            _context21.next = 22;
            break;
          }

          _context21.prev = 7;
          _context21.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["b" /* openConfirmationDialog */]);

        case 10:
          _context21.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(changeConditionEditMode(false));

        case 12:
          return _context21.abrupt("return", true);

        case 15:
          _context21.prev = 15;
          _context21.t0 = _context21["catch"](7);
          _context21.next = 19;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(changeConditionEditMode(true));

        case 19:
          return _context21.abrupt("return", false);

        case 20:
          _context21.next = 23;
          break;

        case 22:
          return _context21.abrupt("return", true);

        case 23:
        case "end":
          return _context21.stop();
      }
    }
  }, _marked21, null, [[7, 15]]);
}

function setupDateTimeFormat() {
  var locale;
  return regenerator_default.a.wrap(function setupDateTimeFormat$(_context22) {
    while (1) {
      switch (_context22.prev = _context22.next) {
        case 0:
          _context22.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$locale');

        case 2:
          locale = _context22.sent;
          _context22.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(dateTimeFormatSet(locale.DATETIME_FORMATS));

        case 5:
        case "end":
          return _context22.stop();
      }
    }
  }, _marked22);
}

function deliveryFlowSagas() {
  return regenerator_default.a.wrap(function deliveryFlowSagas$(_context23) {
    while (1) {
      switch (_context23.prev = _context23.next) {
        case 0:
          _context23.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_CREATE_OR_UPDATE_REQUEST, createOrUpdateItem), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_REMOVE_REQUEST, delivery_flow_sagas_removeItem), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_DESCOPE_REQUEST, delivery_flow_sagas_descopeItem), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_RESCOPE_REQUEST, delivery_flow_sagas_rescopeItem), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_SKIP_REQUEST, delivery_flow_sagas_skipItem), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_COMPLETE_REQUEST, delivery_flow_sagas_completeItem), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_CREATE_OR_UPDATE_SUCCESS, delivery_flow_sagas_fetchDelivery), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_APPROVALS_REQUEST, fetchTrackedItemApprovals), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_STAGE_RELEASE_REQUEST, fetchStagesReleases), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_STAGE_TRANSITION_REQUEST, postTransition), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.STAGE_COMPLETE_REQUEST, completeStageInDelivery), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.STAGE_REOPEN_REQUEST, reopenStageInDelivery), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRANSITION_ACTIVATE_REQUEST, onActivateTransition), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRANSITION_DEACTIVATE_REQUEST, onDeactivateTransition), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRANSITION_TAB_CHANGE_REQUEST, onTransitionTabChange), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.CONDITION_EDIT_MODE_CHANGE_REQUEST, changeConditionDisplayMode), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.CONDITION_UPDATE_SUCCESS, sagas["a" /* addConfirmLeavePopup */]), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.CONDITIONS_SAVE_REQUEST, saveConditionChanges), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.SET_DATETIME_FORMAT_REQUEST, setupDateTimeFormat), watchFetchDeliveryWithPollingSaga()]);

        case 2:
        case "end":
          return _context23.stop();
      }
    }
  }, _marked23);
}
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/ducks/index.js


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/delivery-flow.store.js



var delivery_flow_store_marked = /*#__PURE__*/regenerator_default.a.mark(combinedSaga);

/* global window */




var sagaMiddleware = Object(redux_saga_core_npm_proxy_esm["a" /* default */])();
/* eslint-disable no-underscore-dangle, angular/typecheck-object, angular/module-getter, no-console, angular/log, lodash/prefer-lodash-typecheck */

var composeEnhancers = (typeof window === "undefined" ? "undefined" : typeof_default()(window)) === 'object' && window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ ? window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__({
  name: 'delivery-flow' // Specify extension’s options like name, actionsBlacklist, actionsCreators, serialize...

}) : redux["compose"];

function combinedSaga() {
  return regenerator_default.a.wrap(function combinedSaga$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          if (false) {}

          _context.prev = 1;
          _context.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowSagas)]);

        case 4:
          _context.next = 9;
          break;

        case 6:
          _context.prev = 6;
          _context.t0 = _context["catch"](1);
          console.error('Release delivery flow saga:', _context.t0);

        case 9:
          _context.next = 0;
          break;

        case 11:
        case "end":
          return _context.stop();
      }
    }
  }, delivery_flow_store_marked, null, [[1, 6]]);
}

function configureStore(preloadedState) {
  var enhancer = composeEnhancers(Object(redux["applyMiddleware"])(sagaMiddleware));
  var store = Object(redux["createStore"])(Object(redux["combineReducers"])({
    deliveryFlow: delivery_flow_reducer_deliveryFlow
  }), preloadedState, enhancer);
  sagaMiddleware.run(combinedSaga);
  return store;
}

var delivery_flow_store_store = configureStore();
/* eslint-enable no-underscore-dangle, angular/typecheck-object, angular/module-getter, no-console, angular/log, lodash/prefer-lodash-typecheck */
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/assertThisInitialized.js
var assertThisInitialized = __webpack_require__(6);
var assertThisInitialized_default = /*#__PURE__*/__webpack_require__.n(assertThisInitialized);

// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__(13);
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: ./node_modules/lodash/findLast.js
var findLast = __webpack_require__(819);
var findLast_default = /*#__PURE__*/__webpack_require__.n(findLast);

// EXTERNAL MODULE: ./node_modules/lodash/includes.js
var includes = __webpack_require__(65);
var includes_default = /*#__PURE__*/__webpack_require__.n(includes);

// EXTERNAL MODULE: ./node_modules/lodash/isUndefined.js
var isUndefined = __webpack_require__(196);
var isUndefined_default = /*#__PURE__*/__webpack_require__.n(isUndefined);

// EXTERNAL MODULE: ./node_modules/lodash/map.js
var map = __webpack_require__(66);
var map_default = /*#__PURE__*/__webpack_require__.n(map);

// EXTERNAL MODULE: ./node_modules/lodash/startCase.js
var startCase = __webpack_require__(820);
var startCase_default = /*#__PURE__*/__webpack_require__.n(startCase);

// EXTERNAL MODULE: ./node_modules/lodash/toLower.js
var toLower = __webpack_require__(821);
var toLower_default = /*#__PURE__*/__webpack_require__.n(toLower);

// EXTERNAL MODULE: ./node_modules/lodash/upperFirst.js
var upperFirst = __webpack_require__(412);
var upperFirst_default = /*#__PURE__*/__webpack_require__.n(upperFirst);

// EXTERNAL MODULE: ./node_modules/moment/moment.js-exposed
var moment_js_exposed = __webpack_require__(43);
var moment_js_exposed_default = /*#__PURE__*/__webpack_require__.n(moment_js_exposed);

// EXTERNAL MODULE: ./core/xlr-ui/app/react/utils/validators.js
var validators = __webpack_require__(39);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/delivery-flow.types.js

var TrackedItem = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  title: prop_types_default.a.string
});
var ReleaseInfo = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  title: prop_types_default.a.string,
  status: prop_types_default.a.string,
  startDate: prop_types_default.a.number,
  endDate: prop_types_default.a.number,
  archived: prop_types_default.a.bool,
  fullId: prop_types_default.a.string
});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/track-item-edit-modal/tracked-item-edit-modal.component.js








function tracked_item_edit_modal_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function tracked_item_edit_modal_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { tracked_item_edit_modal_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { tracked_item_edit_modal_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }







var cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var nameOptions = {
  label: 'Name',
  description: 'Name of the tracked item',
  required: true
};

var tracked_item_edit_modal_component_nameValidator = function nameValidator(trackedItemList) {
  var id = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  return function (title) {
    return {
      condition: Object(validators["b" /* itemAlreadyDefined */])(trackedItemList, id, 'title', title),
      message: Object(validators["a" /* createErrorMessage */])('Tracked item already exists')
    };
  };
};

var tracked_item_edit_modal_component_maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: Object(validators["e" /* validateMaxLength */])(inputText, maxLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};

var tracked_item_edit_modal_component_TrackedItemEditModalComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(TrackedItemEditModalComponent, _Component);

  var _super = _createSuper(TrackedItemEditModalComponent);

  createClass_default()(TrackedItemEditModalComponent, null, [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(props, state) {
      if (!state.trackedItem || props.model.title !== state.prevModel.title || props.model.title === state.prevModel.title && props.model.id !== state.prevModel.id) {
        return tracked_item_edit_modal_component_objectSpread({}, state, {
          trackedItem: props.model,
          prevModel: props.model
        });
      }

      return null;
    }
  }]);

  function TrackedItemEditModalComponent(props) {
    var _this;

    classCallCheck_default()(this, TrackedItemEditModalComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onRegister", function (componentApi) {
      componentApi.focus();
      _this.componentApi = componentApi;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "closeModal", function () {
      _this.handleButtonClick(cancelButton.action);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCheckboxClick", function (value) {
      _this.setState({
        createAnother: value.target.checked
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "resetForm", function () {
      _this.setState({
        trackedItem: null,
        prevModel: null
      });

      if (_this.componentApi) {
        _this.componentApi.resetPristinity();

        _this.componentApi.focus();
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleButtonClick", function (action) {
      var _this$props = _this.props,
          onCancel = _this$props.onCancel,
          onSave = _this$props.onSave;
      var _this$state = _this.state,
          trackedItem = _this$state.trackedItem,
          createAnother = _this$state.createAnother;

      switch (action) {
        case 'update':
          onSave(trackedItem, createAnother);
          break;

        case 'cancel':
          onCancel();

          _this.setState({
            createAnother: false
          });

          break;

        default:
          throw 'Unknown action';
      }

      _this.resetForm();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleModelChange", function (newTitle) {
      var trackedItem = _this.state.trackedItem;

      if (newTitle !== trackedItem.title) {
        _this.setState({
          trackedItem: tracked_item_edit_modal_component_objectSpread({}, trackedItem, {
            title: newTitle
          })
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleValidityChange", function (valid) {
      _this.isValid = valid;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handlePristinityChange", function (pristine) {
      _this.isPristine = pristine;
    });

    _this.state = {
      trackedItem: null,
      prevModel: null,
      createAnother: false
    };
    _this.isPristine = null;
    _this.isValid = null;
    _this.componentApi = null;
    return _this;
  }

  createClass_default()(TrackedItemEditModalComponent, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          isOpened = _this$props2.isOpened,
          trackedItems = _this$props2.trackedItems;
      var trackedItem = this.state.trackedItem;
      var disableSaving = this.isPristine || !this.isValid;
      var updateButton = {
        action: 'update',
        className: 'button primary',
        disabled: disableSaving,
        keyCodes: [13],
        label: 'Save'
      };
      var modalHeader = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, this.props.modalTitle, /*#__PURE__*/react_default.a.createElement("button", {
        className: "btn-close",
        onClick: this.closeModal,
        type: "button"
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [cancelButton, updateButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.handleButtonClick,
        onCheckboxClick: this.onCheckboxClick,
        show: isOpened,
        skin: this.props.modalTitle !== 'Edit tracked item' ? 'checkbox' : 'default',
        title: modalHeader
      }, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetString"], {
        metadata: nameOptions,
        model: trackedItem.title,
        onModelChange: this.handleModelChange,
        onPristinityChange: this.handlePristinityChange,
        onValidityChange: this.handleValidityChange,
        register: this.onRegister,
        validators: [tracked_item_edit_modal_component_nameValidator(trackedItems, trackedItem.id), tracked_item_edit_modal_component_maxLengthValidator(nameOptions.label, 255), Object(validators["c" /* reservedCharactersValidator */])(nameOptions.label)]
      }));
    }
  }]);

  return TrackedItemEditModalComponent;
}(react["Component"]);

defineProperty_default()(tracked_item_edit_modal_component_TrackedItemEditModalComponent, "propTypes", {
  isOpened: prop_types_default.a.bool.isRequired,
  modalTitle: prop_types_default.a.string.isRequired,
  model: TrackedItem.isRequired,
  onCancel: prop_types_default.a.func.isRequired,
  onSave: prop_types_default.a.func.isRequired,
  trackedItems: prop_types_default.a.arrayOf(TrackedItem).isRequired
});


// EXTERNAL MODULE: ./node_modules/antd/es/popover/index.js + 15 modules
var popover = __webpack_require__(2291);

// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-timeline/delivery-timeline.less
var delivery_timeline = __webpack_require__(2195);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-timeline/delivery-timeline.component.js








function delivery_timeline_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_timeline_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_timeline_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var delivery_timeline_component_DeliveryTimelineComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryTimelineComponent, _Component);

  var _super = delivery_timeline_component_createSuper(DeliveryTimelineComponent);

  function DeliveryTimelineComponent() {
    var _this;

    classCallCheck_default()(this, DeliveryTimelineComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "getPopoverContent", function (endDate) {
      var current = moment_js_exposed_default()().startOf('day');
      var duration = moment_js_exposed_default.a.duration(endDate.diff(current, 'days'), 'days').asDays();
      var calculatedDuration = duration > 0 ? duration : 0;
      var humanizedDuration = "".concat(calculatedDuration, " ").concat(calculatedDuration === 1 ? 'day' : 'days');
      return "Delivery start and end date (".concat(humanizedDuration, " left)");
    });

    return _this;
  }

  createClass_default()(DeliveryTimelineComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          startDate = _this$props.startDate,
          endDate = _this$props.endDate;
      return /*#__PURE__*/react_default.a.createElement(popover["a" /* default */], {
        content: this.getPopoverContent(endDate),
        overlayClassName: "delivery-timeline-popover",
        placement: "bottom",
        trigger: "hover"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        id: "delivery-timeline"
      }, /*#__PURE__*/react_default.a.createElement("span", null, startDate.format('ll')), /*#__PURE__*/react_default.a.createElement("i", {
        className: "inline-item-icon xl-icon icon-l back-icon flip-icon"
      }), /*#__PURE__*/react_default.a.createElement("span", null, endDate.format('ll'))));
    }
  }]);

  return DeliveryTimelineComponent;
}(react["Component"]);

defineProperty_default()(delivery_timeline_component_DeliveryTimelineComponent, "propTypes", {
  endDate: prop_types_default.a.instanceOf(moment_js_exposed_default.a).isRequired,
  startDate: prop_types_default.a.instanceOf(moment_js_exposed_default.a).isRequired
});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/delivery-properties.constants.js
var delivery_properties_constants_deliveryStatus = {
  inProgress: 'IN_PROGRESS',
  completed: 'COMPLETED'
};
var stageStatus = {
  open: 'OPEN',
  closed: 'CLOSED'
};
var ciTypes = {
  delivery: 'delivery.Delivery',
  stage: 'delivery.Stage'
};
// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/index.js + 25 modules
var components = __webpack_require__(27);

// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/stage-header.component.less
var stage_header_component = __webpack_require__(2196);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/stage-header.component.js








function stage_header_component_createSuper(Derived) { var hasNativeReflectConstruct = stage_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function stage_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }








var CONFIRM_ACTIONS = {
  reopen: 'reopen',
  complete: 'complete'
};
var stage_header_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var completeButton = {
  action: CONFIRM_ACTIONS.complete,
  className: 'button primary',
  keyCodes: [13],
  label: 'Complete'
};
var reopenButton = {
  action: CONFIRM_ACTIONS.reopen,
  className: 'button primary',
  keyCodes: [13],
  label: 'Reopen'
};
var stage_header_component_StageHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(StageHeaderComponent, _Component);

  var _super = stage_header_component_createSuper(StageHeaderComponent);

  function StageHeaderComponent(props) {
    var _this;

    classCallCheck_default()(this, StageHeaderComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "handleCompleteConfirmClose", function () {
      _this.setState({
        showCloseConfirm: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleCompleteConfirmAction", function (action) {
      var _this$props = _this.props,
          completeStage = _this$props.completeStage,
          stage = _this$props.stage;

      if (action === CONFIRM_ACTIONS.complete) {
        completeStage(stage.id);
      }

      _this.setState({
        showCloseConfirm: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleReopenConfirmClose", function () {
      _this.setState({
        showReopenConfirm: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleReopenConfirmAction", function (action) {
      var _this$props2 = _this.props,
          reopenStage = _this$props2.reopenStage,
          stage = _this$props2.stage;

      if (action === CONFIRM_ACTIONS.reopen) {
        reopenStage(stage.id);
      }

      _this.setState({
        showReopenConfirm: false
      });
    });

    _this.state = {
      showCloseConfirm: false,
      showReopenConfirm: false
    };
    return _this;
  }

  createClass_default()(StageHeaderComponent, [{
    key: "buildModalHeader",
    value: function buildModalHeader(caption, fn) {
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement("span", {
        className: "delivery-header-text"
      }, caption, /*#__PURE__*/react_default.a.createElement("button", {
        className: "btn-close",
        onClick: fn,
        type: "button"
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon close-icon"
      }))));
    }
  }, {
    key: "renderCompleteConfirmDialog",
    value: function renderCompleteConfirmDialog() {
      var _this$props3 = this.props,
          delivery = _this$props3.delivery,
          stage = _this$props3.stage,
          trackedItems = _this$props3.trackedItems;
      var showCloseConfirm = this.state.showCloseConfirm;
      var modalHeader = this.buildModalHeader('Complete stage', this.handleCompleteConfirmClose);
      var descopedItemIds = new Set(trackedItems.filter(function (i) {
        return i.descoped;
      }).map(function (i) {
        return i.id;
      }));
      var itemIds = stage.items.filter(function (item) {
        return !descopedItemIds.has(item.trackedItemId) && item.status === trackedItemStatus.notReady;
      }).map(function (item) {
        return item.trackedItemId;
      });
      var isLastStage = delivery.stages.slice(-1)[0].id === stage.id;
      return /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [stage_header_component_cancelButton, completeButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.handleCompleteConfirmAction,
        show: showCloseConfirm,
        title: modalHeader
      }, isLastStage && /*#__PURE__*/react_default.a.createElement("p", {
        className: "alert alert-warning"
      }, "This stage is the last in this delivery. Completing this stage will complete the delivery. You will not be able to close/reopen stages in the completed delivery."), /*#__PURE__*/react_default.a.createElement("p", null, "You are about to close the stage ", /*#__PURE__*/react_default.a.createElement("span", {
        className: "stage-name"
      }, stage.title), "."), itemIds.length > 0 && /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement("p", null, "By closing this stage the following not ready items will be marked as descoped in this delivery."), /*#__PURE__*/react_default.a.createElement("p", {
        className: "tracked-item-list-msg"
      }, "Tracked items that will be descoped (", itemIds.length, ")"), /*#__PURE__*/react_default.a.createElement("div", {
        className: "tracked-item-container"
      }, trackedItems.filter(function (ti) {
        return itemIds.includes(ti.id);
      }).map(function (item, index) {
        return /*#__PURE__*/react_default.a.createElement("p", {
          className: "tracked-item-row",
          key: index
        }, item.title);
      }))));
    }
  }, {
    key: "renderReopenConfirmDialog",
    value: function renderReopenConfirmDialog() {
      var stage = this.props.stage;
      var showReopenConfirm = this.state.showReopenConfirm;
      var modalHeader = this.buildModalHeader('Reopen stage', this.handleReopenConfirmClose);
      return /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [stage_header_component_cancelButton, reopenButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.handleReopenConfirmAction,
        show: showReopenConfirm,
        title: modalHeader
      }, /*#__PURE__*/react_default.a.createElement("p", null, "You are about to reopen the stage ", /*#__PURE__*/react_default.a.createElement("span", {
        className: "stage-name"
      }, stage.title), "."));
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props4 = this.props,
          collapseStage = _this$props4.collapseStage,
          isActive = _this$props4.isActive,
          isClosed = _this$props4.isClosed,
          isMenuVisible = _this$props4.isMenuVisible,
          stage = _this$props4.stage;
      var isEditable = this.props.delivery.isEditable;
      var menuOptions = [{
        label: 'Complete',
        handler: function handler() {
          _this2.setState({
            showCloseConfirm: true
          });
        },
        isVisible: !isClosed
      }, {
        label: 'Reopen',
        handler: function handler() {
          _this2.setState({
            showReopenConfirm: true
          });
        },
        isVisible: isClosed
      }];
      return /*#__PURE__*/react_default.a.createElement("span", {
        className: classnames_default()('header-cell', 'stage-header', 'curved-border-top', {
          'active': isActive
        }, {
          'closed': isClosed
        }),
        key: stage.id
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "stage-title-wrapper"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "stage-title"
      }, /*#__PURE__*/react_default.a.createElement("h6", {
        className: "truncate-title",
        title: stage.title
      }, stage.title)), /*#__PURE__*/react_default.a.createElement("div", {
        className: "stage-actions"
      }, isClosed && /*#__PURE__*/react_default.a.createElement("div", {
        className: "label label-completed"
      }, "Completed"), isActive && /*#__PURE__*/react_default.a.createElement("a", {
        className: "link-collapse-stage",
        onClick: collapseStage
      }, "Close detail view"), isEditable && isMenuVisible && /*#__PURE__*/react_default.a.createElement(components["c" /* ContextMenuComponent */], {
        menuName: stage.title,
        menuOptions: menuOptions,
        menuWrapperClassName: "stage-header-menu"
      }))), this.renderCompleteConfirmDialog(), this.renderReopenConfirmDialog());
    }
  }]);

  return StageHeaderComponent;
}(react["Component"]);

defineProperty_default()(stage_header_component_StageHeaderComponent, "propTypes", {
  collapseStage: prop_types_default.a.func.isRequired,
  completeStage: prop_types_default.a.func.isRequired,
  delivery: prop_types_default.a.any.isRequired,
  isActive: prop_types_default.a.bool.isRequired,
  isClosed: prop_types_default.a.bool.isRequired,
  isMenuVisible: prop_types_default.a.bool.isRequired,
  reopenStage: prop_types_default.a.func.isRequired,
  stage: prop_types_default.a.any.isRequired,
  trackedItems: prop_types_default.a.arrayOf(prop_types_default.a.any).isRequired
});
// EXTERNAL MODULE: ./node_modules/lodash/intersectionWith.js
var intersectionWith = __webpack_require__(822);
var intersectionWith_default = /*#__PURE__*/__webpack_require__.n(intersectionWith);

// EXTERNAL MODULE: ./node_modules/react-content-loader/dist/react-content-loader.es.js
var react_content_loader_es = __webpack_require__(434);

// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/release-list/release-list.less
var release_list = __webpack_require__(2197);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/release-list/release-list.component.js








function release_list_component_createSuper(Derived) { var hasNativeReflectConstruct = release_list_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function release_list_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var release_list_component_ReleaseListComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ReleaseListComponent, _Component);

  var _super = release_list_component_createSuper(ReleaseListComponent);

  function ReleaseListComponent() {
    var _this;

    classCallCheck_default()(this, ReleaseListComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "renderReleaseRows", function (releaseList) {
      return releaseList.map(function (releaseDetail, i) {
        var releaseUrl = "#/releases/".concat(releaseDetail.fullId.replace(/^Applications\//, '').replace(/\//g, '-'));
        return /*#__PURE__*/react_default.a.createElement("div", {
          className: "col-xs-12 release-list-modal-release-row release",
          key: i
        }, /*#__PURE__*/react_default.a.createElement("div", {
          className: "adjust-release-line release-modal-line release-line"
        }, /*#__PURE__*/react_default.a.createElement("div", {
          className: "row-wrapper"
        }, /*#__PURE__*/react_default.a.createElement("div", {
          className: "col-xs-3 release-title-wrapper"
        }, /*#__PURE__*/react_default.a.createElement("strong", {
          className: "release-title raised-link-target"
        }, /*#__PURE__*/react_default.a.createElement("a", {
          className: "black-text",
          href: releaseUrl
        }, releaseDetail.title))), /*#__PURE__*/react_default.a.createElement("div", {
          className: "col-xs-3 text-left"
        }, /*#__PURE__*/react_default.a.createElement(components["m" /* ReleaseStatusComponent */], {
          isArchived: releaseDetail.archived,
          status: releaseDetail.status
        })), /*#__PURE__*/react_default.a.createElement("div", {
          className: "col-xs-3 text-left calendar-link"
        }, /*#__PURE__*/react_default.a.createElement("div", null, /*#__PURE__*/react_default.a.createElement("span", null, moment(releaseDetail.startDate).format('lll')))), /*#__PURE__*/react_default.a.createElement("div", {
          className: "col-xs-3 text-left calendar-link"
        }, /*#__PURE__*/react_default.a.createElement("div", null, /*#__PURE__*/react_default.a.createElement("span", null, releaseDetail.endDate ? moment(releaseDetail.endDate).format('lll') : ''))))));
      });
    });

    return _this;
  }

  createClass_default()(ReleaseListComponent, [{
    key: "render",
    value: function render() {
      var releaseList = this.props.releaseList;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "f-add-release"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "releases-list-modal-sub-header"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "row"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "col-xs-6"
      }, /*#__PURE__*/react_default.a.createElement("div", null, /*#__PURE__*/react_default.a.createElement("label", null, /*#__PURE__*/react_default.a.createElement("span", {
        className: "header"
      }, "Releases")))), /*#__PURE__*/react_default.a.createElement("div", {
        className: "col-xs-3 text-left"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "release-table-text"
      }, "Start date")), /*#__PURE__*/react_default.a.createElement("div", {
        className: "col-xs-3 text-left end-date"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "release-table-text"
      }, "End date")))), /*#__PURE__*/react_default.a.createElement("div", {
        className: "release-modal-list"
      }, this.renderReleaseRows(releaseList)));
    }
  }]);

  return ReleaseListComponent;
}(react["Component"]);

defineProperty_default()(release_list_component_ReleaseListComponent, "propTypes", {
  releaseList: prop_types_default.a.arrayOf(ReleaseInfo)
});
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/stage-cell.component.less
var stage_cell_component = __webpack_require__(2198);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/stage-cell.component.js








function stage_cell_component_createSuper(Derived) { var hasNativeReflectConstruct = stage_cell_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function stage_cell_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }














var stage_cell_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var stage_cell_component_Ids = Object(util_ids["a" /* default */])();
var stage_cell_component_StageCellComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(StageCellComponent, _Component);

  var _super = stage_cell_component_createSuper(StageCellComponent);

  function StageCellComponent(props) {
    var _this;

    classCallCheck_default()(this, StageCellComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "openReleaseListModal", function () {
      _this.setState({
        showReleaseList: true
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "openFailingReleasesModal", function () {
      _this.setState({
        showReleaseList: true,
        onlyFailing: true
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "closeReleaseListModal", function () {
      _this.setState({
        showReleaseList: false,
        onlyFailing: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "isFailing", function (rel) {
      return rel.status === 'failed' || rel.status === 'failing';
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "buildContent", function (leftRenderer) {
      var rightRenderer = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement("div", {
        className: "cell-data-content-left"
      }, leftRenderer()), rightRenderer && /*#__PURE__*/react_default.a.createElement("div", {
        className: "cell-data-content-right"
      }, rightRenderer()));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderContent", function () {
      var _this$props = _this.props,
          stageItem = _this$props.stageItem,
          trackedItem = _this$props.trackedItem,
          isExpanded = _this$props.isExpanded,
          expandedStageReleases = _this$props.expandedStageReleases,
          isMenuVisible = _this$props.isMenuVisible,
          stageMenuOptions = _this$props.stageMenuOptions;
      var content = null;
      var status = null;

      if (trackedItem.descoped) {
        status = /*#__PURE__*/react_default.a.createElement("i", {
          className: "xl-icon icon-xl circle-outline-cross-icon"
        });
        content = _this.buildContent(_.constant('Descoped'), function () {
          return _this.renderReleaseCount(trackedItem.releaseIds);
        });
      } else if (stageItem) {
        switch (stageItem.status) {
          case trackedItemStatus.ready:
            {
              status = /*#__PURE__*/react_default.a.createElement("i", {
                className: "xl-icon icon-xl circle-check-icon"
              });
              content = _this.buildContent(_.constant('Completed this stage'), function () {
                return _this.renderReleaseCount(trackedItem.releaseIds);
              });
              break;
            }

          case trackedItemStatus.notReady:
            {
              if (trackedItem.releaseIds && trackedItem.releaseIds.length === 0) {
                status = /*#__PURE__*/react_default.a.createElement("i", {
                  className: "xl-icon icon-xl pending-icon"
                });
                content = _this.buildContent(_.constant('Waiting for activity'), function () {
                  return _this.renderMenu(stageMenuOptions, isMenuVisible);
                });
                break;
              } else if (expandedStageReleases.length && trackedItem.releaseIds.length) {
                content = _this.renderRegisteredItemContent();
              }

              status = /*#__PURE__*/react_default.a.createElement("i", {
                className: "xl-icon icon-xl progress-icon"
              }, !isExpanded && expandedStageReleases.find(function (rel) {
                return _this.isFailing(rel) && (trackedItem.releaseIds || []).map(function (id) {
                  return stage_cell_component_Ids.getName(id);
                }).includes(rel.id);
              }) && /*#__PURE__*/react_default.a.createElement("i", {
                className: "xl-icon circle-exclamation-icon top-right"
              }));
              break;
            }

          case trackedItemStatus.skipped:
            {
              status = /*#__PURE__*/react_default.a.createElement("i", {
                className: "xl-icon icon-xl circle-minus-icon"
              });
              content = _this.buildContent(_.constant('Skipped'), function () {
                return _this.renderReleaseCount(trackedItem.releaseIds);
              });
              break;
            }

          default:
            throw 'Unknown tracked item status';
        }
      }

      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, status && /*#__PURE__*/react_default.a.createElement("span", {
        className: "details-status"
      }, status) || /*#__PURE__*/react_default.a.createElement("span", null, "\xA0"), isExpanded && /*#__PURE__*/react_default.a.createElement("span", {
        className: "details-content"
      }, content));
    });

    _this.state = {
      showReleaseList: false,
      onlyFailing: false
    };
    return _this;
  }

  createClass_default()(StageCellComponent, [{
    key: "renderDeliveryMemberList",
    value: function renderDeliveryMemberList() {
      var _this$props2 = this.props,
          trackedItem = _this$props2.trackedItem,
          expandedStageReleases = _this$props2.expandedStageReleases;
      var showReleaseList = this.state.showReleaseList;
      var releaseList = intersectionWith_default()(expandedStageReleases, (trackedItem.releaseIds || []).map(function (id) {
        return stage_cell_component_Ids.getName(id);
      }), function (_ref, releaseId) {
        var id = _ref.id;
        return id === releaseId;
      });
      var modalHeader = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, "Linked Releases (", releaseList.length, ")", /*#__PURE__*/react_default.a.createElement("button", {
        className: "btn-close",
        onClick: this.closeReleaseListModal,
        type: "button"
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon close-icon"
      })));
      releaseList.forEach(function (item) {
        item.fullId = trackedItem.releaseIds.find(function (id) {
          return stage_cell_component_Ids.getName(id) === item.id;
        });
      });
      return /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [stage_cell_component_cancelButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.closeReleaseListModal,
        show: showReleaseList,
        title: modalHeader
      }, /*#__PURE__*/react_default.a.createElement(release_list_component_ReleaseListComponent, {
        releaseList: this.state.onlyFailing ? releaseList.filter(this.isFailing) : releaseList
      }));
    }
  }, {
    key: "renderMenu",
    value: function renderMenu(stageMenuOptions, isVisible) {
      return isVisible && /*#__PURE__*/react_default.a.createElement(components["c" /* ContextMenuComponent */], {
        menuOptions: stageMenuOptions,
        menuWrapperClassName: "stage-menu-wrapper"
      });
    }
  }, {
    key: "renderReleaseCount",
    value: function renderReleaseCount(releaseIds) {
      return releaseIds.length > 0 && /*#__PURE__*/react_default.a.createElement("a", {
        className: "release-counter",
        onClick: this.openReleaseListModal
      }, releaseIds.length, " releases");
    }
  }, {
    key: "renderRegisteredItemContent",
    value: function renderRegisteredItemContent() {
      var _this2 = this;

      var _this$props3 = this.props,
          trackedItem = _this$props3.trackedItem,
          expandedStageReleases = _this$props3.expandedStageReleases,
          stageMenuOptions = _this$props3.stageMenuOptions,
          isMenuVisible = _this$props3.isMenuVisible;

      var getReleaseInfo = function getReleaseInfo(releases, releaseId) {
        var failing = releases.find(_this2.isFailing);
        return failing || releases.find(function (rel) {
          return rel.id === releaseId;
        });
      };

      var ids = (trackedItem.releaseIds || []).map(function (id) {
        return stage_cell_component_Ids.getName(id);
      });
      var stageReleases = expandedStageReleases.filter(function (r) {
        return ids.includes(r.id);
      });
      var failingCount = stageReleases.filter(this.isFailing).length;
      var release = getReleaseInfo(stageReleases, last_default()(ids));
      var leftContent = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, failingCount === 0 && /*#__PURE__*/react_default.a.createElement("span", {
        className: "release-title"
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon icon-xl release-icon"
      }), release && release.title), failingCount > 0 && /*#__PURE__*/react_default.a.createElement("div", null, /*#__PURE__*/react_default.a.createElement("div", null, "In progress"), /*#__PURE__*/react_default.a.createElement("span", {
        className: "release-title failed"
      }, failingCount === 1 && /*#__PURE__*/react_default.a.createElement("span", null, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon circle-exclamation-icon"
      }), /*#__PURE__*/react_default.a.createElement("a", {
        href: "#/releases/" + release.id
      }, release.title, " is failing")), failingCount > 1 && /*#__PURE__*/react_default.a.createElement("span", null, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon circle-exclamation-icon"
      }), /*#__PURE__*/react_default.a.createElement("a", {
        onClick: this.openFailingReleasesModal
      }, failingCount, " releases are failing")))));
      var rightContent = /*#__PURE__*/react_default.a.createElement("span", {
        className: "counter-and-menu-wrapper"
      }, this.renderMenu(stageMenuOptions, isMenuVisible), this.renderReleaseCount(trackedItem.releaseIds));
      return this.buildContent(function () {
        return leftContent;
      }, function () {
        return rightContent;
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props4 = this.props,
          isExpanded = _this$props4.isExpanded,
          loading = _this$props4.loading;
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement("div", {
        className: classnames_default()('stage-cell-content', isExpanded ? 'active' : '')
      }, loading && isExpanded && /*#__PURE__*/react_default.a.createElement(react_content_loader_es["a" /* default */], {
        height: 50,
        speed: 1,
        width: 500
      }, /*#__PURE__*/react_default.a.createElement("rect", {
        height: "30",
        rx: "20",
        ry: "20",
        width: "30",
        x: "0",
        y: "0"
      }), /*#__PURE__*/react_default.a.createElement("rect", {
        height: "14",
        rx: "4",
        ry: "4",
        width: "450",
        x: "50",
        y: "9"
      })), !(isExpanded && loading) && this.renderContent()), this.renderDeliveryMemberList());
    }
  }]);

  return StageCellComponent;
}(react["Component"]);

defineProperty_default()(stage_cell_component_StageCellComponent, "propTypes", {
  expandedStageReleases: prop_types_default.a.arrayOf(ReleaseInfo),
  isExpanded: prop_types_default.a.bool.isRequired,
  isMenuVisible: prop_types_default.a.bool.isRequired,
  loading: prop_types_default.a.bool.isRequired,
  stageItem: prop_types_default.a.any,
  stageMenuOptions: prop_types_default.a.arrayOf(prop_types_default.a.shape({
    label: prop_types_default.a.string,
    handler: prop_types_default.a.func
  })),
  trackedItem: prop_types_default.a.any.isRequired
});
// EXTERNAL MODULE: ./node_modules/lodash/noop.js
var noop = __webpack_require__(112);
var noop_default = /*#__PURE__*/__webpack_require__.n(noop);

// EXTERNAL MODULE: ./core/xlr-ui/app/react/widgets/index.js + 4 modules
var widgets = __webpack_require__(237);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/stage.actions.js
var stage_actions_actionTypes = {
  STAGE_LIST_REQUESTED: "STAGE/LIST_REQUESTED",
  STAGE_LIST_SUCCEEDED: "STAGE/LIST_SUCCEEDED",
  STAGE_DELETE_REQUESTED: "STAGE/DELETE_REQUESTED",
  STAGE_DELETE_SUCCEEDED: "STAGE/DELETE_SUCCEEDED",
  STAGE_EDIT_REQUESTED: "STAGE/EDIT_REQUESTED",
  STAGE_EDIT_SUCCEEDED: "STAGE/EDIT_SUCCEEDED",
  STAGE_ADD_REQUESTED: "STAGE/ADD_REQUESTED",
  STAGE_ADD_SUCCEEDED: "STAGE/ADD_SUCCEEDED"
};
var loadStages = function loadStages(deliveryId) {
  return {
    type: stage_actions_actionTypes.STAGE_LIST_REQUESTED,
    payload: deliveryId
  };
};
var stagesLoaded = function stagesLoaded(list) {
  return {
    type: stage_actions_actionTypes.STAGE_LIST_SUCCEEDED,
    payload: list
  };
};
var stage_actions_deleteStage = function deleteStage(stageId) {
  return {
    type: stage_actions_actionTypes.STAGE_DELETE_REQUESTED,
    payload: stageId
  };
};
var stageDeleted = function stageDeleted(stageId) {
  return {
    type: stage_actions_actionTypes.STAGE_DELETE_SUCCEEDED,
    payload: stageId
  };
};
var editStage = function editStage(stageId, title) {
  return {
    type: stage_actions_actionTypes.STAGE_EDIT_REQUESTED,
    payload: {
      id: stageId,
      title: title
    }
  };
};
var stageEdited = function stageEdited(stage) {
  return {
    type: stage_actions_actionTypes.STAGE_EDIT_SUCCEEDED,
    payload: stage
  };
};
var stage_actions_addStage = function addStage() {
  return {
    type: stage_actions_actionTypes.STAGE_ADD_REQUESTED
  };
};
var stageAdded = function stageAdded(stage) {
  return {
    type: stage_actions_actionTypes.STAGE_ADD_SUCCEEDED,
    payload: stage
  };
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/transition.actions.js
var transition_actions_actionTypes = {
  TRANSITION_ADD_REQUESTED: "TRANSITION/ADD_REQUESTED",
  TRANSITION_ADD_SUCCEEDED: "TRANSITION/ADD_SUCCEEDED",
  TRANSITION_UPDATE_REQUESTED: "TRANSITION/UPDATE_REQUESTED",
  TRANSITION_UPDATE_SUCCEEDED: "TRANSITION/UPDATE_SUCCEEDED",
  TRANSITION_DELETE_REQUESTED: "TRANSITION/DELETE_REQUESTED",
  TRANSITION_DELETE_SUCCEEDED: "TRANSITION/DELETE_SUCCEEDED",
  TRANSITION_ADD_CONDITION_REQUESTED: "TRANSITION/ADD_CONDITION_REQUESTED",
  TRANSITION_UPDATE_CONDITION_REQUESTED: "TRANSITION/UPDATE_CONDITION_REQUESTED",
  TRANSITION_DELETE_CONDITION_REQUESTED: "TRANSITION/DELETE_CONDITION_REQUESTED",
  TRANSITION_TOGGLE_OPERATOR_REQUESTED: "TRANSITION/TOGGLE_OPERATOR_REQUESTED",
  TRANSITION_TOGGLE_OPERATOR_SUCCEEDED: "TRANSITION/TOGGLE_OPERATOR_SUCCEEDED"
};
var transition_actions_addTransition = function addTransition(stageId) {
  return {
    type: transition_actions_actionTypes.TRANSITION_ADD_REQUESTED,
    payload: stageId
  };
};
var transitionAdded = function transitionAdded(transition) {
  return {
    type: transition_actions_actionTypes.TRANSITION_ADD_SUCCEEDED,
    payload: transition
  };
};
var transition_actions_updateTransition = function updateTransition(id, stageId, title) {
  return {
    type: transition_actions_actionTypes.TRANSITION_UPDATE_REQUESTED,
    payload: {
      id: id,
      stageId: stageId,
      title: title
    }
  };
};
var transitionUpdated = function transitionUpdated(transition) {
  return {
    type: transition_actions_actionTypes.TRANSITION_UPDATE_SUCCEEDED,
    payload: transition
  };
};
var transition_actions_deleteTransition = function deleteTransition(id) {
  return {
    type: transition_actions_actionTypes.TRANSITION_DELETE_REQUESTED,
    payload: id
  };
};
var transitionDeleted = function transitionDeleted(transition) {
  return {
    type: transition_actions_actionTypes.TRANSITION_DELETE_SUCCEEDED,
    payload: transition
  };
};
var addCondition = function addCondition(transitionId, groupId) {
  return {
    type: transition_actions_actionTypes.TRANSITION_ADD_CONDITION_REQUESTED,
    payload: {
      transitionId: transitionId,
      groupId: groupId
    }
  };
};
var transition_actions_updateCondition = function updateCondition(transitionId, conditionId, change) {
  return {
    type: transition_actions_actionTypes.TRANSITION_UPDATE_CONDITION_REQUESTED,
    payload: {
      transitionId: transitionId,
      conditionId: conditionId,
      change: change
    }
  };
};
var deleteCondition = function deleteCondition(transitionId, conditionId) {
  return {
    type: transition_actions_actionTypes.TRANSITION_DELETE_CONDITION_REQUESTED,
    payload: {
      transitionId: transitionId,
      conditionId: conditionId
    }
  };
};
var toggleConditionOperator = function toggleConditionOperator(transitionId) {
  return {
    type: transition_actions_actionTypes.TRANSITION_TOGGLE_OPERATOR_REQUESTED,
    payload: transitionId
  };
};
var conditionOperatorToggled = function conditionOperatorToggled(transitionId, operator) {
  return {
    type: transition_actions_actionTypes.TRANSITION_TOGGLE_OPERATOR_SUCCEEDED,
    payload: {
      transitionId: transitionId,
      operator: operator
    }
  };
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/delivery-pattern.types.js


var _conditionValueOpts;


var DeliveryPattern = prop_types_default.a.shape({
  description: prop_types_default.a.string,
  plannedDuration: prop_types_default.a.number,
  id: prop_types_default.a.string,
  title: prop_types_default.a.string.isRequired
});
var Condition = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  type: prop_types_default.a.oneOf(['delivery.ItemsCompletionCondition', 'delivery.TimeCondition']),
  value: prop_types_default.a.string
});
var ConditionGroup = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  type: prop_types_default.a.string,
  value: prop_types_default.a.string,
  operator: prop_types_default.a.string,
  conditions: prop_types_default.a.arrayOf(Condition).isRequired
});
var RootConditionGroup = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  type: prop_types_default.a.string,
  value: prop_types_default.a.string,
  operator: prop_types_default.a.string,
  conditions: prop_types_default.a.arrayOf(ConditionGroup).isRequired
});
var Transition = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  title: prop_types_default.a.string.isRequired,
  stage: prop_types_default.a.string,
  conditions: prop_types_default.a.arrayOf(RootConditionGroup).isRequired
});
var Stage = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  title: prop_types_default.a.string.isRequired,
  transition: Transition
});
var conditionTypes = {
  STATE: 'delivery.ItemsCompletionCondition',
  TIMED: 'delivery.TimeCondition',
  GROUP: 'delivery.ConditionGroup'
};
var isTimeCondition = function isTimeCondition(condition) {
  return condition.type === conditionTypes.TIMED;
};
var isGroupCondition = function isGroupCondition(condition) {
  return condition.type === conditionTypes.GROUP;
};
var isStateCondition = function isStateCondition(condition) {
  return condition.type === conditionTypes.STATE;
};
var conditionValueOpts = (_conditionValueOpts = {}, defineProperty_default()(_conditionValueOpts, "".concat(conditionTypes.STATE), 'All items are completed in previous stage'), defineProperty_default()(_conditionValueOpts, "".concat(conditionTypes.TIMED), 'Scheduled'), _conditionValueOpts);
var conditionOperator = {
  AND: 'AND',
  OR: 'OR'
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/stage.reducer.js



function stage_reducer_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function stage_reducer_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { stage_reducer_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { stage_reducer_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }






var stage_reducer_initialState = function initialState() {
  return {
    list: [],
    operators: {},
    // {transitionId1: rootOperator1, transitionId2: rootOperator2}
    isCreateDeliveryDisabled: true
  };
};
var stage_reducer_stages = function stages() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : stage_reducer_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case stage_actions_actionTypes.STAGE_LIST_SUCCEEDED:
      {
        var list = action.payload.map(function (stage) {
          return {
            id: stage.id,
            title: stage.title,
            transition: stage.transition
          };
        });
        var operators = {};
        list.forEach(function (stage) {
          if (stage.transition) {
            operators[stage.transition.id] = stage.transition.conditions.length > 0 ? stage.transition.conditions[0].operator : conditionOperator.OR;
          }
        });
        return stage_reducer_objectSpread({}, state, {
          list: list,
          operators: operators,
          isCreateDeliveryDisabled: stage_reducer_isCreateDeliveryDisabled(list)
        });
      }

    case stage_actions_actionTypes.STAGE_DELETE_SUCCEEDED:
      {
        var updated = cloneDeep_default()(state.list);
        var index = updated.findIndex(function (stage) {
          return stage.id === action.payload;
        });

        if (index > -1) {
          if (index > 0 && updated.length - 1 === index) {
            var prevIndex = index - 1;

            if (!isUndefined_default()(updated[prevIndex].transition)) {
              updated[prevIndex].transition = null;
            }
          }

          updated.splice(index, 1);
        }

        return stage_reducer_objectSpread({}, state, {
          list: toConsumableArray_default()(updated),
          isCreateDeliveryDisabled: stage_reducer_isCreateDeliveryDisabled(updated)
        });
      }

    case stage_actions_actionTypes.STAGE_EDIT_SUCCEEDED:
      {
        var _list = state.list;
        var _action$payload = action.payload,
            id = _action$payload.id,
            title = _action$payload.title;
        return stage_reducer_objectSpread({}, state, {
          list: _list.map(function (stage) {
            return stage.id === id ? stage_reducer_objectSpread({}, stage, {
              title: title
            }) : stage;
          })
        });
      }

    case stage_actions_actionTypes.STAGE_ADD_SUCCEEDED:
      {
        return stage_reducer_objectSpread({}, state, {
          list: [].concat(toConsumableArray_default()(state.list), [{
            id: action.payload.id,
            title: action.payload.title
          }]),
          isCreateDeliveryDisabled: false
        });
      }

    case transition_actions_actionTypes.TRANSITION_ADD_SUCCEEDED:
      {
        var transition = action.payload;
        var _operators = state.operators,
            _list2 = state.list;
        return stage_reducer_objectSpread({}, state, {
          list: _list2.map(function (stage) {
            return stage.id === transition.stage ? stage_reducer_objectSpread({}, stage, {
              transition: {
                id: transition.id,
                title: transition.title,
                stage: transition.stage,
                automated: transition.automated,
                conditions: transition.conditions
              }
            }) : stage_reducer_objectSpread({}, stage);
          }),
          operators: stage_reducer_objectSpread({}, _operators, defineProperty_default()({}, "".concat(transition.id), conditionOperator.OR))
        });
      }

    case transition_actions_actionTypes.TRANSITION_UPDATE_SUCCEEDED:
      {
        var _list3 = state.list,
            _operators2 = state.operators;
        var _transition = action.payload;
        return stage_reducer_objectSpread({}, state, {
          operators: Object.keys(_operators2).reduce(function (obj, key) {
            obj[key] = conditionOperator.OR;
            obj[key] = key === _transition.id && _transition.conditions.length > 0 ? _transition.conditions[0].operator : _operators2[key];
            return obj;
          }, {}),
          list: _list3.map(function (stage) {
            return stage.id === _transition.stage ? stage_reducer_objectSpread({}, stage, {
              transition: stage_reducer_objectSpread({}, _transition, {
                title: _transition.title,
                automated: _transition.automated,
                conditions: _transition.conditions
              })
            }) : stage;
          })
        });
      }

    case transition_actions_actionTypes.TRANSITION_DELETE_SUCCEEDED:
      {
        var _list4 = state.list;
        var transitionId = action.payload;
        return stage_reducer_objectSpread({}, state, {
          list: _list4.map(function (stage) {
            return stage_reducer_objectSpread({}, stage, {
              transition: stage.transition && stage.transition.id === transitionId ? null : stage.transition
            });
          })
        });
      }

    case transition_actions_actionTypes.TRANSITION_TOGGLE_OPERATOR_SUCCEEDED:
      {
        var _action$payload2 = action.payload,
            _transitionId = _action$payload2.transitionId,
            operator = _action$payload2.operator;
        var _operators3 = state.operators;
        return stage_reducer_objectSpread({}, state, {
          operators: Object.keys(_operators3).reduce(function (obj, key) {
            obj[key] = key === _transitionId ? stage_reducer_inverseOperator(operator) : _operators3[key];
            return obj;
          }, {})
        });
      }

    default:
      return state;
  }
};

function stage_reducer_isCreateDeliveryDisabled(stages) {
  return stages.length === 0;
}

var stage_reducer_inverseOperator = function inverseOperator(op) {
  return op === conditionOperator.AND ? conditionOperator.OR : conditionOperator.AND;
};
// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/utils.js + 1 modules
var utils = __webpack_require__(213);

// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-tabs/automated-tab.component.less
var automated_tab_component = __webpack_require__(2199);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-tabs/automated-tab.component.js








function automated_tab_component_createSuper(Derived) { var hasNativeReflectConstruct = automated_tab_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function automated_tab_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }











var actions = [{
  caption: 'Move to next stage',
  items: [{
    iconClass: 'circle-check-icon',
    text: 'Items that are completed'
  }, {
    iconClass: 'circle-minus-icon',
    text: 'Items that are skipped'
  }]
}, {
  caption: 'Descope',
  items: [{
    iconClass: 'pending-icon',
    text: 'Items in waiting state'
  }, {
    iconClass: 'progress-icon',
    text: 'Items in progress state'
  }]
}];
var automated_tab_component_AutomatedTabComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(AutomatedTabComponent, _Component);

  var _super = automated_tab_component_createSuper(AutomatedTabComponent);

  function AutomatedTabComponent(props) {
    var _this;

    classCallCheck_default()(this, AutomatedTabComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "enterEditMode", function () {
      _this.props.showConditionEditMode(true);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "cancelEditMode", function () {
      _this.props.showConditionEditMode(false);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onSave", function () {
      _this.props.saveConditions();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderConditionLabel", function (conditionType) {
      switch (conditionType) {
        case conditionTypes.TIMED:
          return 'Scheduled';

        case conditionTypes.STATE:
          return 'All items are completed';

        default:
          return "Not defined type ".concat(conditionType, ". Please add or change case statement");
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderConditionStatusIcon", function (condition) {
      var isPendingStateCondition = isStateCondition(condition) && !condition.satisfied;
      var addMargin = !isGroupCondition(condition) && !isPendingStateCondition && (condition.satisfied || !_this.props.isConditionEditMode);
      var statusIconClass = classnames_default()('xl-icon', {
        'extra-margin': addMargin,
        'circle-check-icon': condition.satisfied,
        'pending-icon': !condition.satisfied
      });
      return /*#__PURE__*/react_default.a.createElement("i", {
        className: statusIconClass
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderConditionBlockStatusLabel", function (conditionGroup) {
      var automated = _this.props.transition.automated;
      var statusLabelClass = classnames_default()('label', {
        'label-paused': !automated,
        'label-completed': automated && conditionGroup.satisfied,
        'label-pending': automated && !conditionGroup.satisfied
      });
      var text = !automated ? 'Paused' : conditionGroup.satisfied ? "Satisfied" : "Pending";
      return /*#__PURE__*/react_default.a.createElement("p", null, /*#__PURE__*/react_default.a.createElement("span", {
        className: statusLabelClass
      }, text));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "isConditionEditable", function (group, condition) {
      return !group.satisfied && !condition.satisfied && isTimeCondition(condition);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onConditionTimeChange", function (oldValue, newValue, condition) {
      if (oldValue.getTime() !== newValue.getTime()) {
        _this.props.updateCondition(condition.id, newValue);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onValidityChange", function (valid, conditionId) {
      var invalid = _this.state.invalid;

      if (!valid && !invalid.includes(conditionId)) {
        invalid.push(conditionId);

        _this.setState({
          invalid: invalid
        });
      } else if (valid && invalid.includes(conditionId)) {
        invalid.splice(invalid.indexOf(conditionId), 1);

        _this.setState({
          invalid: invalid
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "doNotShowConditionStatusIcon", function (group, condition) {
      var transition = _this.props.transition;
      var isNotSatisfiedInSatisfiedGroup = group.satisfied && !condition.satisfied;
      var isTransitionNotAutomated = !transition.automated;
      return isNotSatisfiedInSatisfiedGroup || isTransitionNotAutomated;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderCondition", function (group, condition, idx) {
      var _this$props = _this.props,
          isConditionEditMode = _this$props.isConditionEditMode,
          conditionChanges = _this$props.conditionChanges,
          dateTimeFormat = _this$props.dateTimeFormat;
      var change = conditionChanges.find(function (c) {
        return c.id === condition.id;
      });
      var changedDate = change ? change.fixedDate : null;
      var model = changedDate || new Date(condition.fixedDate) || new Date();
      var conditionClass = classnames_default()('condition-item', {
        ignored: group.satisfied && !condition.satisfied
      });
      var formats = dateTimeFormat.split('-');
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, {
        key: condition.id
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: conditionClass
      }, _this.renderConditionLabel(condition.type), _this.doNotShowConditionStatusIcon(group, condition) || _this.renderConditionStatusIcon(condition), isConditionEditMode && _this.isConditionEditable(group, condition) && /*#__PURE__*/react_default.a.createElement(widgets["a" /* WidgetDateTime */], {
        metadata: {
          description: 'Select time to perform the transition'
        },
        minDate: new Date(),
        model: model,
        onDatePristinityChange: noop_default.a,
        onModelChange: function onModelChange(newValue) {
          return _this.onConditionTimeChange(model, newValue, condition);
        },
        onTimePristinityChange: noop_default.a,
        onValidityChange: function onValidityChange(valid) {
          return _this.onValidityChange(valid, condition.id);
        }
      }) || (isTimeCondition(condition) || condition.satisfied) && /*#__PURE__*/react_default.a.createElement("div", null, Object(utils["a" /* formatDateTime */])(condition.satisfiedDate || condition.fixedDate, formats[0], formats[1]))), group.conditions.length !== idx + 1 && /*#__PURE__*/react_default.a.createElement("h4", {
        className: "condition-expr"
      }, /*#__PURE__*/react_default.a.createElement("span", null, group.operator)));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderGroupExpr", function (op) {
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "condition-group-expr"
      }, stage_reducer_inverseOperator(op));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderConditionGroup", function (count, group, idx) {
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, {
        key: group.id
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "condition-group"
      }, _this.renderConditionBlockStatusLabel(group), group.conditions.map(function (c, jdx) {
        return _this.renderCondition(group, c, jdx);
      })), count !== idx + 1 && _this.renderGroupExpr(group.operator));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderActions", function () {
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "actions-container"
      }, /*#__PURE__*/react_default.a.createElement("h4", null, "Actions"), /*#__PURE__*/react_default.a.createElement("div", null, actions.map(function (action, i) {
        return /*#__PURE__*/react_default.a.createElement("div", {
          className: "action",
          key: i
        }, /*#__PURE__*/react_default.a.createElement("span", {
          className: "caption"
        }, action.caption), action.items.map(function (item, j) {
          return /*#__PURE__*/react_default.a.createElement("div", {
            className: "item",
            key: j
          }, /*#__PURE__*/react_default.a.createElement("i", {
            className: "xl-icon ".concat(item.iconClass)
          }), item.text);
        }));
      })));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "resumeTransition", function () {
      _this.props.markTransitionAutomated();

      _this.props.saveConditions();
    });

    _this.state = {
      invalid: []
    };
    return _this;
  }

  createClass_default()(AutomatedTabComponent, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.cancelEditMode();
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props2 = this.props,
          conditionChanges = _this$props2.conditionChanges,
          isEditable = _this$props2.isEditable,
          isConditionEditMode = _this$props2.isConditionEditMode,
          transition = _this$props2.transition,
          isClosed = _this$props2.isClosed;
      var conditions = transition.conditions;
      var invalid = this.state.invalid;
      var rootGroup = conditions.length === 1 ? conditions[0] : null;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "automated-tab-container"
      }, /*#__PURE__*/react_default.a.createElement("h4", null, isConditionEditMode && 'Edit conditions' || 'Conditions', isEditable && !isConditionEditMode && rootGroup && /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon edit-icon",
        onClick: this.enterEditMode
      })), isEditable && !isConditionEditMode && !isClosed && !transition.automated && /*#__PURE__*/react_default.a.createElement(components["a" /* AlertMessage */], {
        alertType: components["q" /* alertType */].WARNING
      }, /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement("div", null, "Transition was reopened but automation conditions are paused"), /*#__PURE__*/react_default.a.createElement("div", {
        className: "link"
      }, /*#__PURE__*/react_default.a.createElement("a", {
        onClick: this.resumeTransition
      }, "Resume automation")))), /*#__PURE__*/react_default.a.createElement("div", {
        className: "transition-action-form"
      }, rootGroup && rootGroup.conditions.map(function (group, idx) {
        return _this2.renderConditionGroup(rootGroup.conditions.length, group, idx);
      })), isConditionEditMode && /*#__PURE__*/react_default.a.createElement("div", {
        className: "buttons"
      }, /*#__PURE__*/react_default.a.createElement("button", {
        className: "button cancel",
        onClick: this.cancelEditMode
      }, "Cancel"), /*#__PURE__*/react_default.a.createElement("button", {
        className: "button primary",
        disabled: conditionChanges.length === 0 || invalid.length > 0,
        onClick: this.onSave
      }, "Save")), !isConditionEditMode && this.renderActions());
    }
  }]);

  return AutomatedTabComponent;
}(react["Component"]);

defineProperty_default()(automated_tab_component_AutomatedTabComponent, "propTypes", {
  conditionChanges: prop_types_default.a.arrayOf(prop_types_default.a.any).isRequired,
  dateTimeFormat: prop_types_default.a.string.isRequired,
  isClosed: prop_types_default.a.bool,
  isConditionEditMode: prop_types_default.a.bool,
  isEditable: prop_types_default.a.bool.isRequired,
  markTransitionAutomated: prop_types_default.a.func.isRequired,
  resetConditions: prop_types_default.a.func.isRequired,
  saveConditions: prop_types_default.a.func.isRequired,
  showConditionEditMode: prop_types_default.a.func.isRequired,
  transition: prop_types_default.a.any.isRequired,
  updateCondition: prop_types_default.a.func.isRequired
});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-tabs/manual-tab.component.js







function manual_tab_component_createSuper(Derived) { var hasNativeReflectConstruct = manual_tab_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function manual_tab_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }




var manual_tab_component_ManualTabComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ManualTabComponent, _Component);

  var _super = manual_tab_component_createSuper(ManualTabComponent);

  function ManualTabComponent() {
    classCallCheck_default()(this, ManualTabComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(ManualTabComponent, [{
    key: "renderActionBoxWhenStageOpenedWithSelectableItems",
    value: function renderActionBoxWhenStageOpenedWithSelectableItems(transition, handleTransitionClick, handleCompletePrevStageChange, isEditable) {
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement("h5", {
        className: "transition-title"
      }, "Action"), /*#__PURE__*/react_default.a.createElement("div", null, "Select the tracked items that should transition to the next stage"), /*#__PURE__*/react_default.a.createElement("div", {
        className: "transition-action-form"
      }, /*#__PURE__*/react_default.a.createElement("div", null, /*#__PURE__*/react_default.a.createElement("input", {
        checked: transition.closeStages,
        disabled: !isEditable,
        onChange: function onChange(event) {
          return handleCompletePrevStageChange(event.target.checked);
        },
        type: "checkbox"
      }), /*#__PURE__*/react_default.a.createElement("span", {
        className: "transition-action-label ".concat(!isEditable && 'disabled'),
        onClick: function onClick() {
          return isEditable && handleCompletePrevStageChange(!transition.closeStages);
        }
      }, "Complete the previous stages"))), transition.closeStages && /*#__PURE__*/react_default.a.createElement("div", {
        className: "transition-action-warning"
      }, /*#__PURE__*/react_default.a.createElement(components["a" /* AlertMessage */], {
        alertType: components["q" /* alertType */].WARNING
      }, /*#__PURE__*/react_default.a.createElement("span", null, "Not completed items will be descoped when completing stages"))), /*#__PURE__*/react_default.a.createElement("button", {
        className: "button primary btn-transition",
        disabled: transition.disabledTransition || !isEditable,
        onClick: handleTransitionClick
      }, "Transition (", transition.selectedTransitionItemCount, ") tracked items"));
    }
  }, {
    key: "renderActionBoxWhenStageOpenedWithoutSelectableItems",
    value: function renderActionBoxWhenStageOpenedWithoutSelectableItems() {
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement("h5", {
        className: "transition-title"
      }, "Action"), /*#__PURE__*/react_default.a.createElement("div", {
        className: "no-items"
      }, "There are currently no tracked items available to transition to the next stage"), /*#__PURE__*/react_default.a.createElement("button", {
        className: "button primary btn-transition",
        disabled: true
      }, "Transition (0) tracked items"));
    }
  }, {
    key: "renderActionBoxWhenStageClosedWithSelectableItems",
    value: function renderActionBoxWhenStageClosedWithSelectableItems() {
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement("h5", {
        className: "transition-title"
      }, "Action"), /*#__PURE__*/react_default.a.createElement("div", null, "Some tracked item(s) did not transition to the next stage, please reopen the stage to make a transition."));
    }
  }, {
    key: "renderActionBoxWhenStageClosedWithoutSelectableItems",
    value: function renderActionBoxWhenStageClosedWithoutSelectableItems() {
      return /*#__PURE__*/react_default.a.createElement("div", null);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          isClosed = _this$props.isClosed,
          isSelectable = _this$props.isSelectable,
          transition = _this$props.transition,
          isEditable = _this$props.isEditable,
          handleCompletePrevStageChange = _this$props.handleCompletePrevStageChange,
          handleTransitionClick = _this$props.handleTransitionClick;

      if (isClosed) {
        return isSelectable ? this.renderActionBoxWhenStageClosedWithSelectableItems() : this.renderActionBoxWhenStageClosedWithoutSelectableItems();
      } else {
        return isSelectable ? this.renderActionBoxWhenStageOpenedWithSelectableItems(transition, handleTransitionClick, handleCompletePrevStageChange, isEditable) : this.renderActionBoxWhenStageOpenedWithoutSelectableItems();
      }
    }
  }]);

  return ManualTabComponent;
}(react["Component"]);

defineProperty_default()(manual_tab_component_ManualTabComponent, "propTypes", {
  handleCompletePrevStageChange: prop_types_default.a.func.isRequired,
  handleTransitionClick: prop_types_default.a.func.isRequired,
  isClosed: prop_types_default.a.bool.isRequired,
  isEditable: prop_types_default.a.bool.isRequired,
  isSelectable: prop_types_default.a.bool.isRequired,
  transition: prop_types_default.a.any.isRequired
});
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-action.component.less
var transition_action_component = __webpack_require__(2200);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-action.component.js







function transition_action_component_createSuper(Derived) { var hasNativeReflectConstruct = transition_action_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function transition_action_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }








var transition_action_component_TransitionActionComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(TransitionActionComponent, _Component);

  var _super = transition_action_component_createSuper(TransitionActionComponent);

  function TransitionActionComponent() {
    classCallCheck_default()(this, TransitionActionComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(TransitionActionComponent, [{
    key: "conditionsDefined",
    value: function conditionsDefined(transition) {
      return transition.conditions.length > 0 && transition.conditions[0].conditions.length > 0;
    }
  }, {
    key: "isAutomated",
    value: function isAutomated(selectedTab, transition) {
      return selectedTab === transitionTabs[0].value && this.conditionsDefined(transition);
    }
  }, {
    key: "isManual",
    value: function isManual(selectedTab, transition) {
      return selectedTab === transitionTabs[1].value || transition.conditions.length === 0 || transition.conditions[0].conditions.length === 0;
    }
  }, {
    key: "renderTabs",
    value: function renderTabs(activeTab, onTabChange) {
      return transitionTabs.map(function (tab) {
        return /*#__PURE__*/react_default.a.createElement("h5", {
          className: classnames_default()('link', {
            'active': activeTab === tab.value
          }),
          key: tab.value,
          onClick: function onClick() {
            return onTabChange(tab.value);
          }
        }, tab.label);
      });
    }
  }, {
    key: "renderManualTitle",
    value: function renderManualTitle() {
      return /*#__PURE__*/react_default.a.createElement("h5", {
        className: "full-width active"
      }, transitionTabs[1].label);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          conditionChanges = _this$props.conditionChanges,
          dateTimeFormat = _this$props.dateTimeFormat,
          isClosed = _this$props.isClosed,
          isSelectable = _this$props.isSelectable,
          isEditable = _this$props.isEditable,
          markTransitionAutomated = _this$props.markTransitionAutomated,
          selectedTab = _this$props.selectedTab,
          transition = _this$props.transition,
          onTabChange = _this$props.onTabChange,
          containerHeight = _this$props.containerHeight,
          handleCompletePrevStageChange = _this$props.handleCompletePrevStageChange,
          handleTransitionClick = _this$props.handleTransitionClick,
          resetConditions = _this$props.resetConditions,
          saveConditions = _this$props.saveConditions,
          updateCondition = _this$props.updateCondition,
          isConditionEditMode = _this$props.isConditionEditMode,
          showConditionEditMode = _this$props.showConditionEditMode;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: classnames_default()('transition-action-container', {
          'full-width': this.isAutomated(selectedTab, transition)
        }),
        style: {
          height: containerHeight
        }
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "transition-tab-nav"
      }, this.conditionsDefined(transition) && this.renderTabs(selectedTab, onTabChange) || this.renderManualTitle()), /*#__PURE__*/react_default.a.createElement("div", {
        className: "transition-tab-content"
      }, this.isAutomated(selectedTab, transition) && /*#__PURE__*/react_default.a.createElement(automated_tab_component_AutomatedTabComponent, {
        conditionChanges: conditionChanges,
        dateTimeFormat: dateTimeFormat,
        isClosed: isClosed,
        isConditionEditMode: isConditionEditMode,
        isEditable: isEditable && !isClosed,
        markTransitionAutomated: markTransitionAutomated,
        resetConditions: resetConditions,
        saveConditions: saveConditions,
        showConditionEditMode: showConditionEditMode,
        transition: transition,
        updateCondition: updateCondition
      }), this.isManual(selectedTab, transition) && /*#__PURE__*/react_default.a.createElement(manual_tab_component_ManualTabComponent, {
        handleCompletePrevStageChange: handleCompletePrevStageChange,
        handleTransitionClick: handleTransitionClick,
        isClosed: isClosed,
        isEditable: isEditable,
        isSelectable: isSelectable,
        transition: transition
      })));
    }
  }]);

  return TransitionActionComponent;
}(react["Component"]);

defineProperty_default()(transition_action_component_TransitionActionComponent, "propTypes", {
  conditionChanges: prop_types_default.a.arrayOf(prop_types_default.a.any).isRequired,
  containerHeight: prop_types_default.a.string.isRequired,
  dateTimeFormat: prop_types_default.a.string.isRequired,
  handleCompletePrevStageChange: prop_types_default.a.func.isRequired,
  handleTransitionClick: prop_types_default.a.func.isRequired,
  isClosed: prop_types_default.a.bool.isRequired,
  isConditionEditMode: prop_types_default.a.bool,
  isEditable: prop_types_default.a.bool.isRequired,
  isSelectable: prop_types_default.a.bool.isRequired,
  markTransitionAutomated: prop_types_default.a.func.isRequired,
  onTabChange: prop_types_default.a.func.isRequired,
  resetConditions: prop_types_default.a.func.isRequired,
  saveConditions: prop_types_default.a.func.isRequired,
  selectedTab: prop_types_default.a.number.isRequired,
  showConditionEditMode: prop_types_default.a.func.isRequired,
  transition: prop_types_default.a.any.isRequired,
  updateCondition: prop_types_default.a.func.isRequired
});
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-header.component.less
var transition_header_component = __webpack_require__(2201);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-header.component.js








function transition_header_component_createSuper(Derived) { var hasNativeReflectConstruct = transition_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function transition_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var transition_header_component_TransitionHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(TransitionHeaderComponent, _Component);

  var _super = transition_header_component_createSuper(TransitionHeaderComponent);

  function TransitionHeaderComponent() {
    var _this;

    classCallCheck_default()(this, TransitionHeaderComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "renderTransitionActionBox", function (transition, isActionSelectable, isEditable, isClosed, handleTransitionClick, handleCompletePrevStageChange, containerHeight, selectedTab, onTabChange) {
      var _this$props = _this.props,
          conditionChanges = _this$props.conditionChanges,
          dateTimeFormat = _this$props.dateTimeFormat,
          markTransitionAutomated = _this$props.markTransitionAutomated,
          resetConditions = _this$props.resetConditions,
          saveConditions = _this$props.saveConditions,
          updateCondition = _this$props.updateCondition,
          isConditionEditMode = _this$props.isConditionEditMode,
          showConditionEditMode = _this$props.showConditionEditMode;
      return /*#__PURE__*/react_default.a.createElement("span", {
        className: "transition-action-wrapper"
      }, /*#__PURE__*/react_default.a.createElement(transition_action_component_TransitionActionComponent, {
        conditionChanges: conditionChanges,
        containerHeight: containerHeight,
        dateTimeFormat: dateTimeFormat,
        handleCompletePrevStageChange: handleCompletePrevStageChange,
        handleTransitionClick: handleTransitionClick,
        isClosed: isClosed,
        isConditionEditMode: isConditionEditMode,
        isEditable: isEditable,
        isSelectable: isActionSelectable,
        markTransitionAutomated: markTransitionAutomated,
        onTabChange: onTabChange,
        resetConditions: resetConditions,
        saveConditions: saveConditions,
        selectedTab: selectedTab,
        showConditionEditMode: showConditionEditMode,
        transition: transition,
        updateCondition: updateCondition
      }));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderHeaderCheckbox", function (isEditable, isSelectedAll, onTransitionColumnSelectChange) {
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, isEditable && isSelectedAll && /*#__PURE__*/react_default.a.createElement("div", {
        className: "header-checkbox selected",
        onClick: function onClick() {
          return onTransitionColumnSelectChange(false);
        }
      }, "\xA0"), isEditable && !isSelectedAll && /*#__PURE__*/react_default.a.createElement("div", {
        className: "header-checkbox",
        onClick: function onClick() {
          return onTransitionColumnSelectChange(true);
        }
      }, "\xA0"), !isEditable && /*#__PURE__*/react_default.a.createElement("div", {
        className: "header-checkbox disabled"
      }, "\xA0"));
    });

    return _this;
  }

  createClass_default()(TransitionHeaderComponent, [{
    key: "renderToggleButton",
    value: function renderToggleButton(isExpanded, toggleColumn) {
      return /*#__PURE__*/react_default.a.createElement("span", {
        className: "transition-toggle-button",
        onClick: function onClick() {
          return toggleColumn();
        }
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: classnames_default()('xl-icon', {
          'chevron-left-icon': isExpanded
        }, {
          'chevron-right-icon': !isExpanded
        })
      }));
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          isExpanded = _this$props2.isExpanded,
          isSelectable = _this$props2.isSelectable,
          isSelectedAll = _this$props2.isSelectedAll,
          isCompleted = _this$props2.isCompleted,
          name = _this$props2.name,
          onTransitionColumnSelectChange = _this$props2.onTransitionColumnSelectChange,
          toggleColumn = _this$props2.toggleColumn,
          isEditable = _this$props2.isEditable,
          transition = _this$props2.transition,
          containerHeight = _this$props2.containerHeight,
          isClosed = _this$props2.isClosed,
          isManual = _this$props2.isManual,
          handleTransitionClick = _this$props2.handleTransitionClick,
          handleCompletePrevStageChange = _this$props2.handleCompletePrevStageChange,
          selectedTab = _this$props2.selectedTab,
          onTabChange = _this$props2.onTabChange;
      return /*#__PURE__*/react_default.a.createElement("span", {
        className: classnames_default()('header-cell', 'transition-header', {
          'active': isExpanded
        }, {
          'closed': isCompleted
        })
      }, isExpanded && /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement("div", {
        className: classnames_default()('transition-cell-data', {
          'empty-content': !isManual
        })
      }, !isClosed && isSelectable && isManual && this.renderHeaderCheckbox(isEditable, isSelectedAll, onTransitionColumnSelectChange), this.renderTransitionActionBox(transition, isSelectable, isEditable, isClosed, handleTransitionClick, handleCompletePrevStageChange, containerHeight, selectedTab, onTabChange)), /*#__PURE__*/react_default.a.createElement("div", {
        className: "transition-cell-actions"
      }, /*#__PURE__*/react_default.a.createElement("h6", {
        className: "transition-name",
        title: name
      }, name))), this.renderToggleButton(isExpanded, toggleColumn, isEditable));
    }
  }]);

  return TransitionHeaderComponent;
}(react["Component"]);

defineProperty_default()(transition_header_component_TransitionHeaderComponent, "propTypes", {
  conditionChanges: prop_types_default.a.arrayOf(prop_types_default.a.any).isRequired,
  containerHeight: prop_types_default.a.any,
  dateTimeFormat: prop_types_default.a.string.isRequired,
  handleCompletePrevStageChange: prop_types_default.a.func.isRequired,
  handleTransitionClick: prop_types_default.a.func.isRequired,
  isClosed: prop_types_default.a.bool.isRequired,
  isCompleted: prop_types_default.a.bool.isRequired,
  isConditionEditMode: prop_types_default.a.bool,
  isEditable: prop_types_default.a.bool.isRequired,
  isExpanded: prop_types_default.a.bool.isRequired,
  isManual: prop_types_default.a.bool.isRequired,
  isSelectable: prop_types_default.a.bool.isRequired,
  isSelectedAll: prop_types_default.a.bool.isRequired,
  markTransitionAutomated: prop_types_default.a.func.isRequired,
  name: prop_types_default.a.string.isRequired,
  onTabChange: prop_types_default.a.func.isRequired,
  onTransitionColumnSelectChange: prop_types_default.a.func.isRequired,
  resetConditions: prop_types_default.a.func.isRequired,
  saveConditions: prop_types_default.a.func.isRequired,
  selectedTab: prop_types_default.a.number.isRequired,
  showConditionEditMode: prop_types_default.a.func.isRequired,
  toggleColumn: prop_types_default.a.func.isRequired,
  tooltipTitle: prop_types_default.a.string.isRequired,
  transition: prop_types_default.a.any,
  updateCondition: prop_types_default.a.func.isRequired
});
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-cell.component.less
var transition_cell_component = __webpack_require__(2202);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-cell.component.js








function transition_cell_component_createSuper(Derived) { var hasNativeReflectConstruct = transition_cell_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function transition_cell_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var transition_cell_component_TransitionCellComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(TransitionCellComponent, _Component);

  var _super = transition_cell_component_createSuper(TransitionCellComponent);

  function TransitionCellComponent() {
    var _this;

    classCallCheck_default()(this, TransitionCellComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "renderWithPopover", function (content, body) {
      return /*#__PURE__*/react_default.a.createElement(popover["a" /* default */], {
        arrowPointAtCenter: true,
        content: content,
        mouseLeaveDelay: 0,
        overlayClassName: "transition-approval-popover",
        placement: "left",
        trigger: "hover"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "transition-popover-body"
      }, body));
    });

    return _this;
  }

  createClass_default()(TransitionCellComponent, [{
    key: "renderApprovalContent",
    value: function renderApprovalContent(approvalDetails) {
      return "".concat(moment(approvalDetails.eventTime).format('ll'), " - Transitioned by ").concat(approvalDetails.user.username);
    }
  }, {
    key: "renderCellData",
    value: function renderCellData(transitionItem, handleTransitionSelectChange, isClosed, isEditable) {
      return transitionItem && !(isClosed && !transitionItem.disabled) && /*#__PURE__*/react_default.a.createElement("input", {
        checked: transitionItem.checked && (transitionItem.disabled || isEditable),
        disabled: transitionItem.disabled || !isEditable,
        onChange: function onChange(event) {
          return handleTransitionSelectChange(event.target.checked);
        },
        type: "checkbox"
      });
    }
  }, {
    key: "renderCompletedTransition",
    value: function renderCompletedTransition(approvalContent) {
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "closed-transition-content"
      }, approvalContent);
    }
  }, {
    key: "renderOpenedTransition",
    value: function renderOpenedTransition(transitionItem, handleTransitionSelectChange, approvalContent, isClosed, isEditable) {
      var cellData = this.renderCellData(transitionItem, handleTransitionSelectChange, isClosed, isEditable);
      return approvalContent ? this.renderWithPopover(approvalContent, cellData) : cellData;
    }
  }, {
    key: "renderExpandedCell",
    value: function renderExpandedCell() {
      var _this$props = this.props,
          isEditable = _this$props.isEditable,
          approvalDetails = _this$props.approvalDetails,
          isClosed = _this$props.isClosed,
          isCompleted = _this$props.isCompleted,
          isManual = _this$props.isManual,
          transitionItem = _this$props.transitionItem,
          handleTransitionSelectChange = _this$props.handleTransitionSelectChange;
      var approvalContent = approvalDetails && this.renderApprovalContent(approvalDetails);
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, isCompleted ? this.renderCompletedTransition(approvalContent) : isManual && this.renderOpenedTransition(transitionItem, handleTransitionSelectChange, approvalContent, isClosed, isEditable));
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          isExpanded = _this$props2.isExpanded,
          isManual = _this$props2.isManual;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "transition-cell-data-wrapper"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: classnames_default()('transition-cell-data', {
          'show-strips': isManual
        }, {
          'empty-content': !isManual
        })
      }, isExpanded && this.renderExpandedCell()));
    }
  }]);

  return TransitionCellComponent;
}(react["Component"]);

defineProperty_default()(transition_cell_component_TransitionCellComponent, "propTypes", {
  approvalDetails: prop_types_default.a.any,
  handleTransitionSelectChange: prop_types_default.a.func.isRequired,
  isClosed: prop_types_default.a.bool.isRequired,
  isCompleted: prop_types_default.a.bool.isRequired,
  isEditable: prop_types_default.a.bool.isRequired,
  isExpanded: prop_types_default.a.bool.isRequired,
  isManual: prop_types_default.a.bool.isRequired,
  transitionItem: prop_types_default.a.any
});
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/delivery-flow-view-layout.less
var delivery_flow_view_layout = __webpack_require__(2203);

// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/delivery-flow-view.less
var delivery_flow_view = __webpack_require__(2204);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/delivery-flow-view.component.js








function delivery_flow_view_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_flow_view_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_flow_view_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }


























var filterDeliveryFieldMetadata = {
  placeholder: 'Filter by tracked item...'
};
var deleteButton = {
  action: 'delete',
  className: 'button primary',
  keyCodes: [13],
  label: 'Delete'
};
var descopeButton = {
  action: 'descope',
  className: 'button primary',
  keyCodes: [13],
  label: 'Descope'
};
var rescopeButton = {
  action: 'rescope',
  className: 'button primary',
  keyCodes: [13],
  label: 'Rescope'
};
var delivery_flow_view_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var skipButton = {
  action: 'skip',
  className: 'button primary',
  keyCodes: [13],
  label: 'Skip'
};
var delivery_flow_view_component_completeButton = {
  action: 'complete',
  className: 'button primary',
  keyCodes: [13],
  label: 'Complete'
};
var initTrackItemState = function initTrackItemState() {
  return {
    id: null,
    title: ''
  };
};
var openModalProps = {
  DELETE: 'deleteModalIsOpen',
  DESCOPE: 'descopeModalIsOpen',
  RESCOPE: 'rescopeModalIsOpen',
  SKIP: 'skipModalIsOpen',
  COMPLETE: 'completeModalIsOpen'
};
var headerHeight = 60;
var rowHeight = 60;
var delivery_flow_view_component_DeliveryFlowViewComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryFlowViewComponent, _Component);

  var _super = delivery_flow_view_component_createSuper(DeliveryFlowViewComponent);

  function DeliveryFlowViewComponent(props) {
    var _this;

    classCallCheck_default()(this, DeliveryFlowViewComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "updateContainerClass", function () {
      _this.setState({
        windowResized: !_this.state.windowResized
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleTrackedItemRowFocus", function (trackedItemId) {
      _this.setState({
        activeTrackedItemMenu: trackedItemId
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCloseConfirmModal", function (action) {
      var trackedItem = _this.state.trackedItem;

      switch (action) {
        case deleteButton.action:
          _this.props.deleteTrackedItem(trackedItem.id);

          break;

        case descopeButton.action:
          _this.props.descopeTrackedItem(trackedItem.id);

          break;

        case rescopeButton.action:
          _this.props.rescopeTrackedItem(trackedItem.id);

          break;

        case skipButton.action:
          {
            var stage = _this.state.stage;

            _this.props.skipTrackedItem(stage, trackedItem);

            break;
          }

        case delivery_flow_view_component_completeButton.action:
          {
            var _stage = _this.state.stage;

            _this.props.completeTrackedItem(_stage, trackedItem);

            break;
          }

        case delivery_flow_view_component_cancelButton.action:
          {
            break;
          }

        default:
          throw 'Unknown modal action';
      }

      Object.keys(openModalProps).forEach(function (key) {
        var prop = openModalProps[key];

        if (_this.state[prop]) {
          _this.setState(defineProperty_default()({
            trackedItem: initTrackItemState()
          }, prop, false));
        }
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "expandStage", function (stage) {
      var _this$props = _this.props,
          delivery = _this$props.delivery,
          getStageReleaseDetails = _this$props.getStageReleaseDetails;

      if (_this.state.activeStageId !== stage.id) {
        if (stage.items.length) {
          getStageReleaseDetails(delivery.id);
        }

        _this.setState({
          activeStageId: stage.items.length ? stage.id : null
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "collapseStage", function () {
      _this.setState({
        activeStageId: null
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "toggleTransition", function (transition) {
      var _this$props2 = _this.props,
          activeTransition = _this$props2.activeTransition,
          activateTransition = _this$props2.activateTransition,
          deactivateTransition = _this$props2.deactivateTransition,
          stages = _this$props2.stages;

      if (activeTransition.id === transition.id) {
        deactivateTransition();
      } else {
        var currentStage = stages.find(function (stage) {
          return stage.id === transition.stage;
        });
        activateTransition({
          id: transition.id,
          items: currentStage.items.filter(function (item) {
            return item.transitionItem !== null;
          }),
          status: currentStage.transition
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onTransitionTabChange", function (tabValue) {
      _this.props.changeTransitionTab(tabValue);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleTransition", function (stage) {
      var _this$props3 = _this.props,
          delivery = _this$props3.delivery,
          postTransitionDetails = _this$props3.postTransitionDetails;
      var transitionItems = map_default()(stage.items, function (item) {
        if (item.transitionItem && !item.transitionItem.disabled && item.transitionItem.checked) {
          return item.trackedItemId;
        }
      }).filter(function (item) {
        return !isUndefined_default()(item);
      });
      postTransitionDetails(delivery.id, stage.transition, transitionItems);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showConfirmModal", function (trackedItem, prop) {
      var _this$setState2;

      return _this.setState((_this$setState2 = {}, defineProperty_default()(_this$setState2, prop, true), defineProperty_default()(_this$setState2, "trackedItem", trackedItem), _this$setState2));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showEditModal", function (trackedItem) {
      return _this.setState({
        editModalIsOpen: true,
        trackedItem: trackedItem,
        editModalTitle: 'Edit tracked item'
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCreate", function () {
      _this.setState({
        editModalIsOpen: true,
        editModalTitle: 'Add new tracked item'
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleTrackedItemEditSave", function (trackedItem) {
      var createAnother = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var _this$props4 = _this.props,
          saveTrackedItem = _this$props4.saveTrackedItem,
          delivery = _this$props4.delivery;
      saveTrackedItem(trackedItem, delivery.id);
      var trackItemState = initTrackItemState();

      _this.setState({
        editModalIsOpen: createAnother,
        trackedItem: trackItemState
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleTrackedItemEditCancel", function () {
      var trackItemState = initTrackItemState();

      _this.setState({
        editModalIsOpen: false,
        trackedItem: trackItemState
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNameChange", function (name) {
      _this.setState({
        trackedItemFilterText: name
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onTransitionSelectChange", function (stageId, stageItemId, isSelected) {
      var _this$props5 = _this.props,
          activeTransition = _this$props5.activeTransition,
          stages = _this$props5.stages,
          updateTransitionSelection = _this$props5.updateTransitionSelection;
      var currentStage = stages.find(function (stage) {
        return stage.id === stageId;
      });
      currentStage.items.forEach(function (item) {
        if (item.id === stageItemId) {
          item.transitionItem.checked = isSelected;
        }
      });
      currentStage.transition.selectedTransitionItemCount = countSelectedTransitionItems(currentStage.items);
      currentStage.transition.disabledTransition = isDisabledTransition(currentStage.transition);

      if (activeTransition.id !== null) {
        updateTransitionSelection({
          status: currentStage.transition,
          items: currentStage.items.filter(function (item) {
            return item.transitionItem !== null;
          })
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onTransitionColumnSelectChange", function (stageId, isSelected) {
      var _this$props6 = _this.props,
          stages = _this$props6.stages,
          updateTransitionSelection = _this$props6.updateTransitionSelection;
      var currentStage = stages.find(function (stage) {
        return stage.id === stageId;
      });
      currentStage.items.forEach(function (item) {
        if (item.transitionItem && !item.transitionItem.disabled) {
          item.transitionItem.checked = isSelected;
        }
      });
      currentStage.transition.selectedTransitionItemCount = countSelectedTransitionItems(currentStage.items);
      currentStage.transition.disabledTransition = isDisabledTransition(currentStage.transition);
      updateTransitionSelection({
        items: currentStage.items.filter(function (item) {
          return item.transitionItem !== null;
        }),
        status: currentStage.transition
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCompletePrevStageChange", function (stage, isSelected) {
      var _this$props7 = _this.props,
          stages = _this$props7.stages,
          updateTransitionSelection = _this$props7.updateTransitionSelection;
      var currentStage = stages.find(function (s) {
        return s.id === stage.id;
      });
      currentStage.transition.closeStages = isSelected;
      currentStage.transition.disabledTransition = isDisabledTransition(currentStage.transition);
      updateTransitionSelection({
        items: currentStage.items.filter(function (item) {
          return item.transitionItem !== null;
        }),
        status: currentStage.transition
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "isStageActive", function (stage) {
      var activeStageId = _this.state.activeStageId;
      return !!activeStageId && !!stage && activeStageId === stage.id;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "isTransitionActive", function (transition) {
      var activeTransition = _this.props.activeTransition;
      return !!transition && activeTransition.id === transition.id;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "isManualTransition", function (transition) {
      return transition && transition.conditions.length === 0 || transition.conditions[0].conditions.length === 0 || _this.props.activeTransitionTab === transitionTabs[1].value;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showSkipItemInStageModal", function (stage, trackedItem) {
      var _this$setState3;

      return _this.setState((_this$setState3 = {}, defineProperty_default()(_this$setState3, openModalProps.SKIP, true), defineProperty_default()(_this$setState3, "stage", stage), defineProperty_default()(_this$setState3, "trackedItem", trackedItem), _this$setState3));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showCompleteItemInStageModal", function (stage, trackedItem) {
      var _this$setState4;

      return _this.setState((_this$setState4 = {}, defineProperty_default()(_this$setState4, openModalProps.COMPLETE, true), defineProperty_default()(_this$setState4, "stage", stage), defineProperty_default()(_this$setState4, "trackedItem", trackedItem), _this$setState4));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderTrackedItemEditModal", function (editModalIsOpen, editModalTitle, trackedItem, trackedItems) {
      return /*#__PURE__*/react_default.a.createElement(tracked_item_edit_modal_component_TrackedItemEditModalComponent, {
        isOpened: editModalIsOpen,
        modalTitle: editModalTitle,
        model: trackedItem,
        onCancel: _this.handleTrackedItemEditCancel,
        onSave: _this.handleTrackedItemEditSave,
        trackedItems: trackedItems
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderStageCell", function (stage, stageItem, trackedItem, isStageActive, isTrackedItemEditable) {
      var _this$props8 = _this.props,
          activeStageReleases = _this$props8.activeStageReleases,
          loadingReleasesInfo = _this$props8.loadingReleasesInfo;
      var isMenuVisible = !!stageItem && _this.isRowInFocus(stageItem.trackedItemId) && isTrackedItemEditable;
      var stageMenuOptions = [{
        label: 'Complete',
        handler: function handler() {
          return _this.showCompleteItemInStageModal(stage, trackedItem);
        }
      }, {
        label: 'Skip',
        handler: function handler() {
          return _this.showSkipItemInStageModal(stage, trackedItem);
        }
      }];
      return /*#__PURE__*/react_default.a.createElement(stage_cell_component_StageCellComponent, {
        expandedStageReleases: activeStageReleases,
        isExpanded: isStageActive,
        isMenuVisible: isMenuVisible,
        loading: loadingReleasesInfo,
        stageItem: stageItem,
        stageMenuOptions: stageMenuOptions,
        trackedItem: trackedItem
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderFirstColumnCell", function (item) {
      var _this$props9 = _this.props,
          delivery = _this$props9.delivery,
          status = _this$props9.status;
      var isTrackedItemEditable = delivery.isTrackedItemEditable;
      return _this.buildRowCell(function () {
        return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement("span", {
          className: "text-wrap",
          title: item.title
        }, item.title), _this.isRowInFocus(item.id) && isTrackedItemEditable && status !== deliveryStatus.completed && _this.renderTrackedItemMenu(item));
      }, "item-".concat(item.id), 'tracked-item-cell');
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderTransitionCell", function (stage, stageItem, item, isTransitionActive, isStageCompleted, isStageClosed) {
      var _this$props10 = _this.props,
          activeTransition = _this$props10.activeTransition,
          delivery = _this$props10.delivery,
          trackedItemApprovals = _this$props10.trackedItemApprovals;
      var approval = stageItem && trackedItemApprovals.find(function (approval) {
        return approval.targetId === stageItem.id;
      });
      var currentItem = activeTransition.items.find(function (currItem) {
        return currItem.trackedItemId === item.id;
      });
      var transitionItem = !!currentItem ? currentItem.transitionItem : null;

      var isManual = _this.isManualTransition(stage.transition);

      return /*#__PURE__*/react_default.a.createElement(transition_cell_component_TransitionCellComponent, {
        approvalDetails: approval,
        handleTransitionSelectChange: function handleTransitionSelectChange(isSelected) {
          return _this.onTransitionSelectChange(stage.id, stageItem.id, isSelected);
        },
        isClosed: isStageClosed,
        isCompleted: isStageCompleted,
        isEditable: delivery.isEditable,
        isExpanded: isTransitionActive,
        isManual: isManual,
        key: stage.selectableItemsCount,
        transitionItem: transitionItem
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "buildRow", function (renderer) {
      var rowTrackedItemId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: classnames_default()('table-row', !!rowTrackedItemId ? {
          'hover': _this.isRowInFocus(rowTrackedItemId)
        } : 'last-row'),
        key: "row-".concat(rowTrackedItemId || 'empty'),
        onMouseEnter: function onMouseEnter() {
          return !!rowTrackedItemId && _this.handleTrackedItemRowFocus(rowTrackedItemId);
        },
        onMouseLeave: function onMouseLeave() {
          return !!rowTrackedItemId && _this.handleTrackedItemRowFocus(null);
        }
      }, renderer());
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "buildRowCell", function (renderer, key, rowClass) {
      var isExpanded = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
      var isClosed = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
      var rowClickHandler = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : null;
      var isEnabledExpand = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : true;
      return /*#__PURE__*/react_default.a.createElement("span", {
        className: classnames_default()('body-cell', rowClass, {
          'active': isExpanded && isEnabledExpand,
          'closed': isClosed,
          'disabled-expand': !isEnabledExpand
        }),
        key: key,
        onClick: rowClickHandler
      }, renderer && renderer());
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderStageAndTransitionColumns", function (stage, trackedItem, index, isTrackedItemEditable, isEnabledExpand) {
      var isStageActive = _this.isStageActive(stage);

      var isStageClosed = _this.isStageClosed(stage);

      var isTransitionActive = _this.isTransitionActive(stage.transition);

      var isStageCompleted = _this.isStageCompleted(stage);

      var stageItem = stage.items.find(function (currItem) {
        return currItem.trackedItemId === trackedItem.id;
      });
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, {
        key: "fragment-".concat(stage.id, "-").concat(trackedItem.id, "-").concat(index)
      }, _this.buildRowCell(function () {
        return _this.renderStageCell(stage, stageItem, trackedItem, isStageActive, isTrackedItemEditable);
      }, "stage-".concat(trackedItem.id, "-").concat(index), 'stage-cell', isStageActive, isStageClosed, function () {
        return isEnabledExpand && _this.expandStage(stage);
      }, isEnabledExpand), stage.transition && _this.buildRowCell(function () {
        return _this.renderTransitionCell(stage, stageItem, trackedItem, isTransitionActive, isStageCompleted, isStageClosed);
      }, "transition-".concat(trackedItem.id, "-").concat(index), 'transition-cell', isTransitionActive, isStageCompleted, function () {
        return !isTransitionActive && _this.toggleTransition(stage.transition);
      }));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderStageAndTransitionColumnsForLastRow", function (stage, isEditable, isEnabledExpand, index) {
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, {
        key: "fragment-".concat(stage.id, "-last-row-").concat(index)
      }, _this.buildRowCell(null, "stage-".concat(stage.id, "-last-row"), 'stage-cell', _this.isStageActive(stage), _this.isStageClosed(stage), function () {
        return isEnabledExpand && _this.expandStage(stage);
      }, isEnabledExpand), stage.transition && _this.buildRowCell(function () {
        return /*#__PURE__*/react_default.a.createElement("span", {
          className: "transition-cell-data empty-cell"
        }, _this.isStageCompleted(stage) && /*#__PURE__*/react_default.a.createElement("div", {
          className: "closed-transition-content"
        }, "\xA0"));
      }, "transition-".concat(stage.transition.id, "-last-row}"), 'transition-cell', _this.isTransitionActive(stage.transition), _this.isStageCompleted(stage), function () {
        return !_this.isTransitionActive(stage.transition) && _this.toggleTransition(stage.transition);
      }));
    });

    _this.contentContainerRef = react_default.a.createRef();
    _this.scrollableContentRef = react_default.a.createRef();
    _this.state = {
      editModalIsOpen: false,
      trackedItemFilterText: '',
      editModalTitle: 'Add new tracked item',
      trackedItem: {
        id: null,
        title: null
      },
      activeTrackedItemMenu: null,
      activeStageId: null,
      windowResized: true
    };
    Object.keys(openModalProps).forEach(function (key) {
      return _this.state[key] = false;
    });
    return _this;
  }

  createClass_default()(DeliveryFlowViewComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props11 = this.props,
          updateDeliveryFlowPropsFromDetails = _this$props11.updateDeliveryFlowPropsFromDetails,
          delivery = _this$props11.delivery,
          fetchDeliveryDetailsWithPolling = _this$props11.fetchDeliveryDetailsWithPolling;
      updateDeliveryFlowPropsFromDetails();
      fetchDeliveryDetailsWithPolling(delivery.id);
      window.addEventListener('resize', this.updateContainerClass);
      this.props.setDateTimeFormat();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var stopPolling = this.props.stopPolling;
      stopPolling();
      window.removeEventListener('resize', this.updateContainerClass);
    }
  }, {
    key: "isColumnShort",
    value: function isColumnShort(numOfRows) {
      return this.contentContainerRef && this.contentContainerRef.current ? this.contentContainerRef.current.clientHeight - headerHeight - headerHeight > numOfRows * rowHeight : false;
    }
  }, {
    key: "getTransitionActionBlockHeight",
    value: function getTransitionActionBlockHeight() {
      return this.scrollableContentRef && this.scrollableContentRef.current ? "".concat(this.scrollableContentRef.current.clientHeight - headerHeight - 1, "px") : 'auto';
    }
  }, {
    key: "isStageClosed",
    value: function isStageClosed(stage) {
      return stage.status === stageStatus.closed;
    }
  }, {
    key: "isStageCompleted",
    value: function isStageCompleted(stage) {
      return this.isStageClosed(stage) && stage.selectableItemsCount === 0;
    }
  }, {
    key: "isFirstOpenedStage",
    value: function isFirstOpenedStage(stages, stageId) {
      var _this2 = this;

      var firstOpenedStage = stages.find(function (s) {
        return !_this2.isStageClosed(s);
      });
      return !!firstOpenedStage && firstOpenedStage.id === stageId;
    }
  }, {
    key: "isLastClosedStage",
    value: function isLastClosedStage(stages, stageId) {
      var _this3 = this;

      var lastClosedStage = findLast_default()(stages, function (s) {
        return _this3.isStageClosed(s);
      });
      return !!lastClosedStage && lastClosedStage.id === stageId;
    }
  }, {
    key: "isRowInFocus",
    value: function isRowInFocus(trackedItemId) {
      var activeTrackedItemMenu = this.state.activeTrackedItemMenu;
      return activeTrackedItemMenu === trackedItemId;
    }
  }, {
    key: "renderTrackedItemMenu",
    value: function renderTrackedItemMenu(item) {
      var _this4 = this;

      var menuOptions = [{
        label: 'Edit',
        handler: function handler() {
          return _this4.showEditModal(item);
        }
      }, {
        label: 'Delete',
        handler: function handler() {
          return _this4.showConfirmModal(item, openModalProps.DELETE);
        }
      }, {
        label: 'Rescope',
        handler: function handler() {
          return _this4.showConfirmModal(item, openModalProps.RESCOPE);
        },
        isVisible: item.descoped
      }, {
        label: 'Descope',
        handler: function handler() {
          return _this4.showConfirmModal(item, openModalProps.DESCOPE);
        },
        isVisible: !item.descoped
      }];
      return /*#__PURE__*/react_default.a.createElement(components["c" /* ContextMenuComponent */], {
        menuOptions: menuOptions,
        menuWrapperClassName: "tracked-item-menu-wrapper"
      });
    }
  }, {
    key: "renderDeleteModal",
    value: function renderDeleteModal() {
      var _this5 = this;

      var deleteModalIsOpen = this.state.deleteModalIsOpen;
      var title = this.state.trackedItem.title;
      var modalHeader = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, "Delete tracked item", /*#__PURE__*/react_default.a.createElement("button", {
        className: "btn-close",
        onClick: function onClick() {
          return _this5.onCloseConfirmModal(delivery_flow_view_component_cancelButton.action);
        },
        type: "button"
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [delivery_flow_view_component_cancelButton, deleteButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onCloseConfirmModal,
        show: deleteModalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/react_default.a.createElement("p", null, "You are about to delete tracked item ", /*#__PURE__*/react_default.a.createElement("strong", {
        className: "wrap-text"
      }, title), "."));
    }
  }, {
    key: "renderDescopeModal",
    value: function renderDescopeModal() {
      var _this6 = this;

      var descopeModalIsOpen = this.state.descopeModalIsOpen;
      var title = this.state.trackedItem.title;
      var modalHeader = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, "Descope tracked item", /*#__PURE__*/react_default.a.createElement("button", {
        className: "btn-close",
        onClick: function onClick() {
          return _this6.onCloseConfirmModal(delivery_flow_view_component_cancelButton.action);
        },
        type: "button"
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [delivery_flow_view_component_cancelButton, descopeButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onCloseConfirmModal,
        show: descopeModalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/react_default.a.createElement("p", null, "You are about to descope tracked item ", /*#__PURE__*/react_default.a.createElement("strong", {
        className: "wrap-text"
      }, title), "."));
    }
  }, {
    key: "renderRescopeModal",
    value: function renderRescopeModal() {
      var _this7 = this;

      var rescopeModalIsOpen = this.state.rescopeModalIsOpen;
      var title = this.state.trackedItem.title;
      var modalHeader = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, "Rescope tracked item", /*#__PURE__*/react_default.a.createElement("button", {
        className: "btn-close",
        onClick: function onClick() {
          return _this7.onCloseConfirmModal(delivery_flow_view_component_cancelButton.action);
        },
        type: "button"
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [delivery_flow_view_component_cancelButton, rescopeButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onCloseConfirmModal,
        show: rescopeModalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/react_default.a.createElement("p", null, "You are about to rescope tracked item ", /*#__PURE__*/react_default.a.createElement("strong", {
        className: "wrap-text"
      }, title), "."));
    }
  }, {
    key: "renderSkipModal",
    value: function renderSkipModal() {
      var _this8 = this;

      var skipModalIsOpen = this.state.skipModalIsOpen;
      var title = this.state.trackedItem.title;
      var modalHeader = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, "Skip tracked item", /*#__PURE__*/react_default.a.createElement("button", {
        className: "btn-close",
        onClick: function onClick() {
          return _this8.onCloseConfirmModal(delivery_flow_view_component_cancelButton.action);
        },
        type: "button"
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [delivery_flow_view_component_cancelButton, skipButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onCloseConfirmModal,
        show: skipModalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/react_default.a.createElement("p", null, "You are about to skip tracked item ", /*#__PURE__*/react_default.a.createElement("strong", {
        className: "wrap-text"
      }, title), "."));
    }
  }, {
    key: "renderCompleteModal",
    value: function renderCompleteModal() {
      var _this9 = this;

      var completeModalIsOpen = this.state.completeModalIsOpen;
      var title = this.state.trackedItem.title;
      var modalHeader = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, "Complete tracked item", /*#__PURE__*/react_default.a.createElement("button", {
        className: "btn-close",
        onClick: function onClick() {
          return _this9.onCloseConfirmModal(delivery_flow_view_component_cancelButton.action);
        },
        type: "button"
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [delivery_flow_view_component_cancelButton, delivery_flow_view_component_completeButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onCloseConfirmModal,
        show: completeModalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/react_default.a.createElement("p", null, "You are about to complete tracked item ", /*#__PURE__*/react_default.a.createElement("strong", {
        className: "wrap-text"
      }, title), "."));
    }
  }, {
    key: "renderRows",
    value: function renderRows(trackedItems, isTrackedItemEditable, isEditable, isEnabledExpand) {
      var _this10 = this;

      var stages = this.props.stages;
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, trackedItems.map(function (rowTrackedItem, index) {
        return _this10.buildRow(function () {
          return stages.map(function (stage) {
            return _this10.renderStageAndTransitionColumns(stage, rowTrackedItem, index, isTrackedItemEditable, isEnabledExpand);
          });
        }, rowTrackedItem.id);
      }), // build empty last row
      this.buildRow(function () {
        return stages.map(function (stage, index) {
          return _this10.renderStageAndTransitionColumnsForLastRow(stage, isEditable, isEnabledExpand, index);
        });
      }, null));
    }
  }, {
    key: "renderFirstColumnRows",
    value: function renderFirstColumnRows(trackedItems) {
      var _this11 = this;

      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, trackedItems.map(function (rowTrackedItem, index) {
        return _this11.buildRow(function () {
          return _this11.renderFirstColumnCell(rowTrackedItem, index);
        }, rowTrackedItem.id);
      }));
    }
  }, {
    key: "renderStageHeader",
    value: function renderStageHeader(stage, stages, isEnabledExpand) {
      var _this12 = this;

      var _this$props12 = this.props,
          completeStage = _this$props12.completeStage,
          delivery = _this$props12.delivery,
          reopenStage = _this$props12.reopenStage,
          status = _this$props12.status,
          trackedItems = _this$props12.trackedItems;
      var isStageActive = this.isStageActive(stage);
      var isStageClosed = this.isStageClosed(stage);

      var isMenuVisible = function isMenuVisible(stageId) {
        return status !== deliveryStatus.completed && (_this12.isFirstOpenedStage(stages, stageId) || _this12.isLastClosedStage(stages, stageId));
      };

      return /*#__PURE__*/react_default.a.createElement(stage_header_component_StageHeaderComponent, {
        collapseStage: this.collapseStage,
        completeStage: completeStage,
        delivery: delivery,
        isActive: isStageActive && isEnabledExpand,
        isClosed: isStageClosed,
        isMenuVisible: isMenuVisible(stage.id),
        reopenStage: reopenStage,
        stage: stage,
        trackedItems: trackedItems
      });
    }
  }, {
    key: "renderTransitionHeader",
    value: function renderTransitionHeader(stage, isEditable) {
      var _this13 = this;

      var _this$props13 = this.props,
          activeTransition = _this$props13.activeTransition,
          conditionChanges = _this$props13.conditionChanges,
          dateFormat = _this$props13.dateFormat,
          markTransitionAutomated = _this$props13.markTransitionAutomated,
          resetConditions = _this$props13.resetConditions,
          saveConditions = _this$props13.saveConditions,
          updateCondition = _this$props13.updateCondition,
          isConditionEditMode = _this$props13.isConditionEditMode,
          showConditionEditMode = _this$props13.showConditionEditMode,
          timeFormat = _this$props13.timeFormat,
          activeTransitionTab = _this$props13.activeTransitionTab;
      var isTransitionActive = this.isTransitionActive(stage.transition);
      var allowedItemForSelectCount = stage.items.filter(function (item) {
        return item.transitionItem && !item.transitionItem.disabled;
      }).length;
      var isSelectedAll = stage.transition && stage.transition.selectedTransitionItemCount === allowedItemForSelectCount;
      var activeTransitionStatus = activeTransition.status;
      var isStageClosed = this.isStageClosed(stage);
      var typeName = upperFirst_default()(toLower_default()(startCase_default()(stage.transition.type.split('.')[1])));
      var isManual = this.isManualTransition(stage.transition);
      return /*#__PURE__*/react_default.a.createElement(transition_header_component_TransitionHeaderComponent, {
        conditionChanges: conditionChanges,
        containerHeight: this.getTransitionActionBlockHeight(),
        dateTimeFormat: "".concat(dateFormat, "-").concat(timeFormat),
        handleCompletePrevStageChange: function handleCompletePrevStageChange(isSelected) {
          return _this13.onCompletePrevStageChange(stage, isSelected);
        },
        handleTransitionClick: function handleTransitionClick() {
          return _this13.handleTransition(stage);
        },
        isClosed: isStageClosed,
        isCompleted: this.isStageCompleted(stage),
        isConditionEditMode: isConditionEditMode,
        isEditable: isEditable,
        isExpanded: isTransitionActive,
        isManual: isManual,
        isSelectable: stage.selectableItemsCount > 0,
        isSelectedAll: isSelectedAll,
        key: stage.transition.id,
        markTransitionAutomated: markTransitionAutomated,
        name: stage.transition.title,
        onTabChange: this.onTransitionTabChange,
        onTransitionColumnSelectChange: function onTransitionColumnSelectChange(isSelected) {
          return _this13.onTransitionColumnSelectChange(stage.id, isSelected);
        },
        resetConditions: resetConditions,
        saveConditions: saveConditions,
        selectedTab: activeTransitionTab,
        showConditionEditMode: showConditionEditMode,
        toggleColumn: function toggleColumn() {
          return _this13.toggleTransition(stage.transition);
        },
        tooltipTitle: "".concat(stage.transition.title, " (").concat(typeName, ")"),
        transition: activeTransitionStatus,
        updateCondition: updateCondition
      });
    }
  }, {
    key: "renderStageAndTransitionHeaders",
    value: function renderStageAndTransitionHeaders(stages, isEditable, isEnabledExpand) {
      var _this14 = this;

      return stages.map(function (stage, i) {
        return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, {
          key: "header-fragment-".concat(i)
        }, _this14.renderStageHeader(stage, stages, isEnabledExpand), stage.transition && _this14.renderTransitionHeader(stage, isEditable));
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props14 = this.props,
          stages = _this$props14.stages,
          status = _this$props14.status,
          trackedItems = _this$props14.trackedItems;
      var _this$props$delivery = this.props.delivery,
          isEditable = _this$props$delivery.isEditable,
          isTrackedItemEditable = _this$props$delivery.isTrackedItemEditable;
      var _this$state = this.state,
          editModalIsOpen = _this$state.editModalIsOpen,
          editModalTitle = _this$state.editModalTitle,
          trackedItem = _this$state.trackedItem,
          trackedItemFilterText = _this$state.trackedItemFilterText;
      var filteredTrackedItems = trackedItems.filter(function (ti) {
        return includes_default()(ti.title.toLowerCase(), trackedItemFilterText.toLowerCase());
      });
      var isEnabledExpand = filteredTrackedItems.length > 0;
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, this.renderDeleteModal(), this.renderTrackedItemEditModal(editModalIsOpen, editModalTitle, trackedItem, trackedItems), this.renderDescopeModal(), this.renderRescopeModal(), this.renderSkipModal(), this.renderCompleteModal(), /*#__PURE__*/react_default.a.createElement("div", {
        className: "fixed-container"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "content-container",
        ref: this.contentContainerRef
      }, /*#__PURE__*/react_default.a.createElement("div", {
        id: "fixed-content"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "left-content delivery-header-text"
      }, "Tracked items", /*#__PURE__*/react_default.a.createElement("button", {
        className: "button",
        disabled: !isTrackedItemEditable || status === deliveryStatus.completed,
        onClick: this.onCreate,
        type: "button"
      }, "Add item")), /*#__PURE__*/react_default.a.createElement("div", {
        className: "right-content delivery-header-text"
      }, /*#__PURE__*/react_default.a.createElement("span", null, "Stages"), /*#__PURE__*/react_default.a.createElement("div", {
        className: "timeline-container"
      }, /*#__PURE__*/react_default.a.createElement(delivery_timeline_component_DeliveryTimelineComponent, {
        endDate: moment_js_exposed_default()(this.props.delivery.endDate),
        startDate: moment_js_exposed_default()(this.props.delivery.startDate)
      })))), /*#__PURE__*/react_default.a.createElement("div", {
        id: "scrollable-content",
        ref: this.scrollableContentRef
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: classnames_default()({
          'fill-screen': this.isColumnShort(filteredTrackedItems.length)
        }),
        id: "content"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        id: "top-left"
      }, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetFilter"], {
        metadata: filterDeliveryFieldMetadata,
        onUpdate: this.onNameChange
      })), /*#__PURE__*/react_default.a.createElement("div", {
        className: "content-row",
        id: "top-row"
      }, /*#__PURE__*/react_default.a.createElement("div", null, /*#__PURE__*/react_default.a.createElement("div", {
        className: "header-empty-cell"
      }, "\xA0")), /*#__PURE__*/react_default.a.createElement("div", {
        className: "table-head",
        id: "top-right"
      }, stages && this.renderStageAndTransitionHeaders(stages, isEditable, isEnabledExpand))), /*#__PURE__*/react_default.a.createElement("div", {
        className: classnames_default()('content-row', {
          'empty-row': !isEnabledExpand
        }),
        id: "bottom-row",
        style: {
          minHeight: this.getTransitionActionBlockHeight()
        }
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "table-body",
        id: "left-div"
      }, this.renderFirstColumnRows(filteredTrackedItems)), /*#__PURE__*/react_default.a.createElement("div", {
        className: "table-body",
        id: "center-div"
      }, this.renderRows(filteredTrackedItems, isTrackedItemEditable, isEditable, isEnabledExpand))))))));
    }
  }]);

  return DeliveryFlowViewComponent;
}(react["Component"]);

defineProperty_default()(delivery_flow_view_component_DeliveryFlowViewComponent, "propTypes", {
  activateTransition: prop_types_default.a.func.isRequired,
  activeStageReleases: prop_types_default.a.arrayOf(ReleaseInfo),
  activeTransition: prop_types_default.a.shape({
    id: prop_types_default.a.string,
    items: prop_types_default.a.arrayOf(prop_types_default.a.any),
    status: prop_types_default.a.any
  }).isRequired,
  activeTransitionTab: prop_types_default.a.number.isRequired,
  changeTransitionTab: prop_types_default.a.func.isRequired,
  completeStage: prop_types_default.a.func.isRequired,
  completeTrackedItem: prop_types_default.a.func.isRequired,
  conditionChanges: prop_types_default.a.arrayOf(prop_types_default.a.any).isRequired,
  dateFormat: prop_types_default.a.string.isRequired,
  deactivateTransition: prop_types_default.a.func.isRequired,
  deleteTrackedItem: prop_types_default.a.func.isRequired,
  delivery: prop_types_default.a.any.isRequired,
  descopeTrackedItem: prop_types_default.a.func.isRequired,
  fetchDeliveryDetailsWithPolling: prop_types_default.a.func.isRequired,
  getStageReleaseDetails: prop_types_default.a.func.isRequired,
  isConditionEditMode: prop_types_default.a.bool,
  loadingReleasesInfo: prop_types_default.a.bool.isRequired,
  markTransitionAutomated: prop_types_default.a.func.isRequired,
  postTransitionDetails: prop_types_default.a.func.isRequired,
  reopenStage: prop_types_default.a.func.isRequired,
  rescopeTrackedItem: prop_types_default.a.func.isRequired,
  resetConditions: prop_types_default.a.func.isRequired,
  saveConditions: prop_types_default.a.func.isRequired,
  saveTrackedItem: prop_types_default.a.func.isRequired,
  setDateTimeFormat: prop_types_default.a.func.isRequired,
  showConditionEditMode: prop_types_default.a.func.isRequired,
  skipTrackedItem: prop_types_default.a.func.isRequired,
  stages: prop_types_default.a.arrayOf(prop_types_default.a.any).isRequired,
  status: prop_types_default.a.string.isRequired,
  stopPolling: prop_types_default.a.func.isRequired,
  timeFormat: prop_types_default.a.string.isRequired,
  trackedItemApprovals: prop_types_default.a.arrayOf(prop_types_default.a.any),
  trackedItems: prop_types_default.a.arrayOf(prop_types_default.a.any).isRequired,
  updateCondition: prop_types_default.a.func.isRequired,
  updateDeliveryFlowPropsFromDetails: prop_types_default.a.func.isRequired,
  updateTransitionSelection: prop_types_default.a.func.isRequired
});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/views/delivery-flow.container.js


function delivery_flow_container_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function delivery_flow_container_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_flow_container_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_flow_container_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }





var mapStateToProps = function mapStateToProps(state) {
  var deliveryFlow = state.deliveryFlow;
  return {
    activeTransition: deliveryFlow.activeTransition,
    activeTransitionTab: deliveryFlow.activeTransitionTab,
    conditionChanges: deliveryFlow.conditionChanges,
    dateFormat: deliveryFlow.dateFormat,
    trackedItems: deliveryFlow.trackedItems,
    loadingReleasesInfo: deliveryFlow.loadingReleasesInfo,
    stages: deliveryFlow.stages,
    activeStageReleases: deliveryFlow.activeStageReleases,
    status: deliveryFlow.status,
    timeFormat: deliveryFlow.timeFormat,
    trackedItemApprovals: deliveryFlow.trackedItemApprovals,
    isConditionEditMode: deliveryFlow.isConditionEditMode
  };
};

var mergeProps = function mergeProps(stateProps, dispatchProps, ownProps) {
  return delivery_flow_container_objectSpread({}, ownProps, {}, stateProps, {}, dispatchProps, {
    updateDeliveryFlowPropsFromDetails: function updateDeliveryFlowPropsFromDetails() {
      dispatchProps.updateDeliveryFlowProps(ownProps.delivery);
      dispatchProps.updateActiveStageReleases(ownProps.activeStageReleases);
      dispatchProps.requestTrackedItemApprovals(ownProps.delivery.id);
    }
  });
};

var delivery_flow_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    activateTransition: function activateTransition(stage) {
      return dispatch(delivery_flow_actions_activateTransition(stage));
    },
    updateTransitionSelection: function updateTransitionSelection(selection) {
      return dispatch(delivery_flow_actions_updateTransitionSelection(selection));
    },
    completeStage: function completeStage(id) {
      return dispatch(delivery_flow_actions_completeStage(id));
    },
    deactivateTransition: function deactivateTransition() {
      return dispatch(delivery_flow_actions_deactivateTransition());
    },
    changeTransitionTab: function changeTransitionTab(tab) {
      return dispatch(delivery_flow_actions_changeTransitionTab(tab));
    },
    deleteTrackedItem: function deleteTrackedItem(id) {
      return dispatch(removeTrackedItem(id));
    },
    descopeTrackedItem: function descopeTrackedItem(id) {
      return dispatch(delivery_flow_actions_descopeTrackedItem(id));
    },
    rescopeTrackedItem: function rescopeTrackedItem(id) {
      return dispatch(delivery_flow_actions_rescopeTrackedItem(id));
    },
    reopenStage: function reopenStage(id) {
      return dispatch(delivery_flow_actions_reopenStage(id));
    },
    skipTrackedItem: function skipTrackedItem(stage, trackedItem) {
      return dispatch(delivery_flow_actions_skipTrackedItem(stage, trackedItem));
    },
    completeTrackedItem: function completeTrackedItem(stage, trackedItem) {
      return dispatch(delivery_flow_actions_completeTrackedItem(stage, trackedItem));
    },
    saveTrackedItem: function saveTrackedItem(item, deliveryId) {
      return dispatch(createOrUpdateTrackedItem(item, deliveryId));
    },
    updateDeliveryFlowProps: function updateDeliveryFlowProps(delivery) {
      return dispatch(updateDataState(delivery));
    },
    getStageReleaseDetails: function getStageReleaseDetails(deliveryId) {
      return dispatch(delivery_flow_actions_getStageReleaseDetails(deliveryId));
    },
    postTransitionDetails: function postTransitionDetails(deliveryId, transition, transitionItems) {
      return dispatch(delivery_flow_actions_postTransitionDetails(deliveryId, transition, transitionItems));
    },
    fetchDeliveryDetailsWithPolling: function fetchDeliveryDetailsWithPolling(deliveryId) {
      return dispatch(delivery_flow_actions_fetchDeliveryDetailsWithPolling(deliveryId));
    },
    requestTrackedItemApprovals: function requestTrackedItemApprovals(deliveryId) {
      return dispatch(delivery_flow_actions_requestTrackedItemApprovals(deliveryId));
    },
    resetConditions: function resetConditions() {
      return dispatch(delivery_flow_actions_resetConditions());
    },
    saveConditions: function saveConditions() {
      return dispatch(delivery_flow_actions_saveConditions());
    },
    stopPolling: function stopPolling() {
      return dispatch(delivery_flow_actions_stopPolling());
    },
    updateActiveStageReleases: function updateActiveStageReleases(releases) {
      return dispatch(fetchStageReleasesSuccess(releases));
    },
    updateCondition: function updateCondition(conditionId, time) {
      return dispatch(delivery_flow_actions_updateCondition(conditionId, time));
    },
    showConditionEditMode: function showConditionEditMode(value) {
      return dispatch(delivery_flow_actions_showConditionEditMode(value));
    },
    setDateTimeFormat: function setDateTimeFormat() {
      return dispatch(delivery_flow_actions_setDateTimeFormat());
    },
    markTransitionAutomated: function markTransitionAutomated() {
      return dispatch(delivery_flow_actions_markTransitionAutomated());
    }
  };
};

/* harmony default export */ var delivery_flow_container = (Object(es["connect"])(mapStateToProps, delivery_flow_container_mapDispatchToProps, mergeProps)(delivery_flow_view_component_DeliveryFlowViewComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/views/delivery-flow.page.js







function delivery_flow_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_flow_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_flow_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }








var delivery_flow_page_DeliveryFlowPage = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryFlowPage, _Component);

  var _super = delivery_flow_page_createSuper(DeliveryFlowPage);

  function DeliveryFlowPage() {
    classCallCheck_default()(this, DeliveryFlowPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryFlowPage, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          activeStageReleases = _this$props.activeStageReleases,
          delivery = _this$props.delivery;
      return /*#__PURE__*/react_default.a.createElement(es["Provider"], {
        store: delivery_flow_store_store
      }, /*#__PURE__*/react_default.a.createElement(delivery_flow_container, {
        activeStageReleases: activeStageReleases,
        delivery: delivery
      }));
    }
  }]);

  return DeliveryFlowPage;
}(react["Component"]);

defineProperty_default()(delivery_flow_page_DeliveryFlowPage, "propTypes", {
  activeStageReleases: prop_types_default.a.arrayOf(ReleaseInfo),
  delivery: prop_types_default.a.any.isRequired
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/index.js


angular.module('xlrelease').component('xlrDeliveryFlowView', Object(react2angular["react2angular"])(delivery_flow_page_DeliveryFlowPage));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/ducks/properties.actions.js
var properties_actions_actionTypes = {
  RELEASE_DELIVERY_FORM_INIT_REQUEST: 'RELEASE_DELIVERY/FORM_INIT_REQUEST',
  RELEASE_DELIVERY_CREATE_FORM_INIT_SUCCESS: 'RELEASE_DELIVERY/CREATE_FORM_INIT_SUCCESS',
  RELEASE_DELIVERY_UPDATE_FORM_INIT_SUCCESS: 'RELEASE_DELIVERY/UPDATE_FORM_INIT_SUCCESS',
  RELEASE_DELIVERY_FETCH_FOLDER_LIST_SUCCESS: 'RELEASE_DELIVERY/FETCH_FOLDER_LIST_SUCCESS',
  RELEASE_DELIVERY_FORM_CLEAN: 'RELEASE_DELIVERY/FORM_CLEAN',
  RELEASE_DELIVERY_PRISTINE_CHANGE: 'RELEASE_DELIVERY/PRISTINE_CHANGE',
  RELEASE_DELIVERY_VALIDATION_CHANGE: 'RELEASE_DELIVERY/VALIDATION_CHANGE',
  RELEASE_DELIVERY_MODEL_CHANGE: 'RELEASE_DELIVERY/MODEL_CHANGE',
  RELEASE_DELIVERY_CREATE_OR_UPDATE_REQUEST: 'RELEASE_DELIVERY/CREATE_OR_UPDATE',
  RELEASE_DELIVERY_CREATE_SUCCESS: 'RELEASE_DELIVERY/CREATE_SUCCESS',
  RELEASE_DELIVERY_UPDATE_SUCCESS: 'RELEASE_DELIVERY/UPDATE_SUCCESS',
  RELEASE_DELIVERY_CREATE_CANCEL_REQUEST: 'RELEASE_DELIVERY/CREATE_CANCEL_REQUEST',
  RELEASE_DELIVERY_CREATE_DISCARD_CHANGES_REQUEST: 'RELEASE_DELIVERY/CREATE_DISCARD_CHANGES',
  RELEASE_DELIVERY_GO_TO_PATTERN: 'RELEASE_DELIVERY/GO_TO_PATTERN',
  RELEASE_DELIVERY_GO_TO_FOLDER: 'RELEASE_DELIVERY/GO_TO_FOLDER'
};
var properties_actions_initDeliveryForm = function initDeliveryForm(delivery, patternId, folder) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_FORM_INIT_REQUEST,
    payload: {
      delivery: delivery,
      patternId: patternId,
      folder: folder
    }
  };
};
var initializeCreateFormSuccess = function initializeCreateFormSuccess(pattern, folder) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_FORM_INIT_SUCCESS,
    payload: {
      pattern: pattern,
      folder: folder
    }
  };
};
var initializeUpdateFormSuccess = function initializeUpdateFormSuccess(delivery, pattern, folder, isEditable) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_UPDATE_FORM_INIT_SUCCESS,
    payload: {
      delivery: delivery,
      pattern: pattern,
      folder: folder,
      isEditable: isEditable
    }
  };
};
var cleanFormFields = function cleanFormFields() {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_FORM_CLEAN
  };
};
var changePristine = function changePristine(isPristine) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_PRISTINE_CHANGE,
    payload: isPristine
  };
};
var changeValidation = function changeValidation(isValid) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_VALIDATION_CHANGE,
    payload: isValid
  };
};
var changeModel = function changeModel(model) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_MODEL_CHANGE,
    payload: model
  };
};
var createOrUpdateDelivery = function createOrUpdateDelivery() {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_OR_UPDATE_REQUEST
  };
};
var deliveryCreateSuccess = function deliveryCreateSuccess(delivery) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_SUCCESS,
    payload: delivery
  };
};
var deliveryUpdateSuccess = function deliveryUpdateSuccess(delivery, pattern, folder) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_UPDATE_SUCCESS,
    payload: {
      delivery: delivery,
      pattern: pattern,
      folder: folder
    }
  };
};
var cancelDelivery = function cancelDelivery() {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_CANCEL_REQUEST
  };
};
var properties_actions_onDiscardDeliveryChanges = function onDiscardDeliveryChanges() {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_DISCARD_CHANGES_REQUEST
  };
};
var goToDeliveryPatternDetails = function goToDeliveryPatternDetails(patternId) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_GO_TO_PATTERN,
    payload: patternId
  };
};
var properties_actions_goToFolder = function goToFolder(folderId) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_GO_TO_FOLDER,
    payload: folderId
  };
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/ducks/properties.reducers.js


function properties_reducers_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function properties_reducers_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { properties_reducers_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { properties_reducers_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }





var properties_reducers_initialState = function initialState() {
  return {
    folderTree: {
      key: 0,
      data: []
    },
    form: {
      key: 0,
      model: {
        id: null,
        type: ciTypes.delivery,
        title: '',
        folder: {
          id: '',
          title: ''
        },
        pattern: {
          id: '',
          title: ''
        },
        description: '',
        plannedDuration: 0,
        startDate: new Date(),
        endDate: new Date(new Date().getTime() + 1)
      },
      pristine: true,
      valid: false,
      lastSave: 0,
      isCreateForm: null
    }
  };
};

var properties_reducers_delivery = function delivery() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : properties_reducers_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_FORM_INIT_SUCCESS:
      {
        var _action$payload = action.payload,
            pattern = _action$payload.pattern,
            folder = _action$payload.folder;
        var startDate = new Date();
        return properties_reducers_objectSpread({}, properties_reducers_initialState(), {
          form: properties_reducers_objectSpread({}, properties_reducers_initialState().form, {
            model: properties_reducers_objectSpread({}, properties_reducers_initialState().form.model, {
              description: pattern.description,
              startDate: startDate,
              endDate: moment_js_exposed_default()(startDate).add(pattern.plannedDuration || 1, pattern.plannedDuration ? 'hour' : 'month').toDate(),
              pattern: pattern,
              folder: folder
            }),
            isCreateForm: true
          })
        });
      }

    case properties_actions_actionTypes.RELEASE_DELIVERY_UPDATE_FORM_INIT_SUCCESS:
      {
        var _action$payload2 = action.payload,
            _delivery = _action$payload2.delivery,
            _pattern = _action$payload2.pattern,
            _folder = _action$payload2.folder,
            isEditable = _action$payload2.isEditable;
        return properties_reducers_objectSpread({}, properties_reducers_initialState(), {
          form: properties_reducers_objectSpread({}, properties_reducers_initialState().form, {
            key: moment_js_exposed_default()().valueOf(),
            model: properties_reducers_objectSpread({}, _delivery, {
              pattern: _pattern,
              folder: _folder,
              startDate: new Date(_delivery.startDate),
              endDate: new Date(_delivery.endDate)
            }),
            isCreateForm: false,
            isEditable: isEditable
          })
        });
      }

    case properties_actions_actionTypes.RELEASE_DELIVERY_MODEL_CHANGE:
      return properties_reducers_objectSpread({}, state, {
        form: properties_reducers_objectSpread({}, state.form, {
          model: action.payload
        })
      });

    case properties_actions_actionTypes.RELEASE_DELIVERY_FORM_CLEAN:
      {
        return properties_reducers_objectSpread({}, properties_reducers_initialState());
      }

    case properties_actions_actionTypes.RELEASE_DELIVERY_PRISTINE_CHANGE:
      return properties_reducers_objectSpread({}, state, {
        form: properties_reducers_objectSpread({}, state.form, {
          pristine: action.payload
        })
      });

    case properties_actions_actionTypes.RELEASE_DELIVERY_VALIDATION_CHANGE:
      return properties_reducers_objectSpread({}, state, {
        form: properties_reducers_objectSpread({}, state.form, {
          valid: action.payload
        })
      });

    case properties_actions_actionTypes.RELEASE_DELIVERY_UPDATE_SUCCESS:
      {
        var _action$payload3 = action.payload,
            _delivery2 = _action$payload3.delivery,
            _pattern2 = _action$payload3.pattern,
            _folder2 = _action$payload3.folder;
        return properties_reducers_objectSpread({}, state, {
          form: properties_reducers_objectSpread({}, state.form, {
            model: properties_reducers_objectSpread({}, _delivery2, {
              pattern: _pattern2,
              folder: _folder2,
              startDate: new Date(_delivery2.startDate),
              endDate: new Date(_delivery2.endDate)
            }),
            lastSave: new Date(),
            // Important for resetting pristinity on form
            key: moment_js_exposed_default()().valueOf()
          })
        });
      }

    default:
      return state;
  }
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/ducks/properties.sagas.js


var properties_sagas_marked = /*#__PURE__*/regenerator_default.a.mark(updateBreadcrumbs),
    properties_sagas_marked2 = /*#__PURE__*/regenerator_default.a.mark(initializeForm),
    properties_sagas_marked3 = /*#__PURE__*/regenerator_default.a.mark(save),
    properties_sagas_marked4 = /*#__PURE__*/regenerator_default.a.mark(cancel),
    properties_sagas_marked5 = /*#__PURE__*/regenerator_default.a.mark(discardChanges),
    properties_sagas_marked6 = /*#__PURE__*/regenerator_default.a.mark(goToDetails),
    properties_sagas_marked7 = /*#__PURE__*/regenerator_default.a.mark(properties_sagas_goToDeliveryPatternDetails),
    properties_sagas_marked8 = /*#__PURE__*/regenerator_default.a.mark(goToDeliveryFolder),
    properties_sagas_marked9 = /*#__PURE__*/regenerator_default.a.mark(addConfirmLeavePopup),
    properties_sagas_marked10 = /*#__PURE__*/regenerator_default.a.mark(removeConfirmLeavePopup),
    properties_sagas_marked11 = /*#__PURE__*/regenerator_default.a.mark(deliverySagas);








var getFormModel = function getFormModel(state) {
  return state.delivery.form.model;
};

var properties_sagas_isEditable = function isEditable(delivery) {
  return Object(angular_accessor["b" /* default */])('Authenticator').hasPermission(DELIVERY_EDIT_PERMISSION, delivery.$metadata) && delivery.status !== 'COMPLETED';
};

function updateBreadcrumbs(checkUrl, delivery) {
  var page;
  return regenerator_default.a.wrap(function updateBreadcrumbs$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], 'Page');

        case 2:
          page = _context.sent;

          if (page.isOnPage(checkUrl)) {
            page.setFolderEntityOpened(delivery.folderId, delivery);
          }

        case 4:
        case "end":
          return _context.stop();
      }
    }
  }, properties_sagas_marked);
}

function initializeForm(action) {
  var _action$payload, delivery, patternId, folder, pattern, _pattern, patternFolder;

  return regenerator_default.a.wrap(function initializeForm$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _action$payload = action.payload, delivery = _action$payload.delivery, patternId = _action$payload.patternId;
          folder = action.payload.folder;

          if (!(delivery && delivery.id)) {
            _context2.next = 10;
            break;
          }

          pattern = {
            id: null,
            title: null,
            hasViewAccess: false
          };

          if (delivery.originPatternId && delivery.$metadata.details && delivery.$metadata.details.pattern) {
            pattern.id = delivery.originPatternId;
            pattern.title = delivery.$metadata.details.pattern;
            pattern.hasViewAccess = delivery.$metadata.details.hasPatternViewAccess;
          }

          if (delivery.folderId && delivery.$metadata.details && delivery.$metadata.details.folder) {
            if (!folder) {
              folder = {
                id: null,
                title: null,
                hasViewAccess: false
              };
            }

            folder.id = folder.id || delivery.folderId;
            folder.title = folder.title || delivery.$metadata.details.folder;
            folder.hasViewAccess = delivery.$metadata.details.hasFolderViewAccess;
          }

          _context2.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(initializeUpdateFormSuccess(delivery, pattern, folder, properties_sagas_isEditable(delivery)));

        case 8:
          _context2.next = 17;
          break;

        case 10:
          if (!patternId) {
            _context2.next = 17;
            break;
          }

          _context2.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(delivery_pattern_service_fetchDeliveryPattern, patternId);

        case 13:
          _pattern = _context2.sent;
          patternFolder = {
            id: _pattern.folderId,
            title: _pattern.$metadata.details.folder,
            hasViewAccess: _pattern.$metadata.details.hasFolderViewAccess
          };
          _context2.next = 17;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(initializeCreateFormSuccess(_pattern, patternFolder));

        case 17:
        case "end":
          return _context2.stop();
      }
    }
  }, properties_sagas_marked2);
}

function save() {
  var deliveryModel, deliveryForm, $location, urlBeforeUpdate, updatedDeliveryResponse, createdDeliveryResponse;
  return regenerator_default.a.wrap(function save$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          _context3.prev = 0;
          _context3.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getFormModel);

        case 3:
          deliveryModel = _context3.sent;
          deliveryForm = {
            id: deliveryModel.id,
            type: deliveryModel.type,
            title: deliveryModel.title,
            folderId: deliveryModel.folder.id,
            description: deliveryModel.description,
            startDate: deliveryModel.startDate.toISOString(),
            endDate: deliveryModel.endDate.toISOString(),
            plannedDuration: deliveryModel.plannedDuration,
            releaseIds: deliveryModel.releaseIds
          };

          if (!deliveryForm.id) {
            _context3.next = 19;
            break;
          }

          _context3.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$location');

        case 8:
          $location = _context3.sent;
          urlBeforeUpdate = $location.path();
          _context3.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(services["g" /* updateDelivery */], deliveryForm);

        case 12:
          updatedDeliveryResponse = _context3.sent;
          _context3.next = 15;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(updateBreadcrumbs, urlBeforeUpdate, updatedDeliveryResponse.data);

        case 15:
          _context3.next = 17;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(deliveryUpdateSuccess(updatedDeliveryResponse.data, deliveryModel.pattern, deliveryModel.folder));

        case 17:
          _context3.next = 24;
          break;

        case 19:
          _context3.next = 21;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(services["a" /* createDeliveryFromPattern */], deliveryModel.pattern.id, deliveryForm);

        case 21:
          createdDeliveryResponse = _context3.sent;
          _context3.next = 24;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(deliveryCreateSuccess(createdDeliveryResponse.data));

        case 24:
          _context3.next = 29;
          break;

        case 26:
          _context3.prev = 26;
          _context3.t0 = _context3["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Something went wrong while creating or updating release delivery...', _context3.t0);
          /* eslint-enable */

        case 29:
        case "end":
          return _context3.stop();
      }
    }
  }, properties_sagas_marked3, null, [[0, 26]]);
}

function cancel() {
  var $window;
  return regenerator_default.a.wrap(function cancel$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          // yield call(removeConfirmLeavePopup);
          $window = Object(angular_accessor["b" /* default */])('$window');
          $window.history.back();
          _context4.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(cleanFormFields());

        case 4:
        case "end":
          return _context4.stop();
      }
    }
  }, properties_sagas_marked4);
}

function discardChanges(action) {
  var deliveryModel, deliveryResponse;
  return regenerator_default.a.wrap(function discardChanges$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _context5.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(changePristine(true));

        case 2:
          _context5.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getFormModel);

        case 4:
          deliveryModel = _context5.sent;
          _context5.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(services["d" /* getDelivery */], deliveryModel.id);

        case 7:
          deliveryResponse = _context5.sent;
          _context5.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(initializeUpdateFormSuccess(deliveryResponse.data, deliveryModel.pattern, deliveryModel.folder, properties_sagas_isEditable(deliveryResponse.data)));

        case 10:
        case "end":
          return _context5.stop();
      }
    }
  }, properties_sagas_marked5);
}

function goToDetails(action) {
  var $location, $rootScope;
  return regenerator_default.a.wrap(function goToDetails$(_context6) {
    while (1) {
      switch (_context6.prev = _context6.next) {
        case 0:
          $location = Object(angular_accessor["b" /* default */])('$location');
          $rootScope = Object(angular_accessor["b" /* default */])('$rootScope');
          $location.url("/deliveries/".concat(action.payload.id));
          $rootScope.$digest();

        case 4:
        case "end":
          return _context6.stop();
      }
    }
  }, properties_sagas_marked6);
}

function properties_sagas_goToDeliveryPatternDetails(action) {
  var $location, $rootScope;
  return regenerator_default.a.wrap(function goToDeliveryPatternDetails$(_context7) {
    while (1) {
      switch (_context7.prev = _context7.next) {
        case 0:
          $location = Object(angular_accessor["b" /* default */])('$location');
          $rootScope = Object(angular_accessor["b" /* default */])('$rootScope');
          $location.url("/delivery-patterns/".concat(action.payload));
          $rootScope.$digest();

        case 4:
        case "end":
          return _context7.stop();
      }
    }
  }, properties_sagas_marked7);
}
function goToDeliveryFolder(action) {
  var $location, $rootScope;
  return regenerator_default.a.wrap(function goToDeliveryFolder$(_context8) {
    while (1) {
      switch (_context8.prev = _context8.next) {
        case 0:
          $location = Object(angular_accessor["b" /* default */])('$location');
          $rootScope = Object(angular_accessor["b" /* default */])('$rootScope');
          $location.url("/folders/".concat(action.payload, "/deliveries"));
          $rootScope.$digest();

        case 4:
        case "end":
          return _context8.stop();
      }
    }
  }, properties_sagas_marked8);
} // TODO: don't use temporary

function addConfirmLeavePopup() {
  var confirmLeaveService;
  return regenerator_default.a.wrap(function addConfirmLeavePopup$(_context9) {
    while (1) {
      switch (_context9.prev = _context9.next) {
        case 0:
          _context9.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], 'ConfirmLeaveService');

        case 2:
          confirmLeaveService = _context9.sent;
          _context9.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(confirmLeaveService.requireConfirmation.bind(confirmLeaveService));

        case 5:
        case "end":
          return _context9.stop();
      }
    }
  }, properties_sagas_marked9);
} // TODO: don't use temporary

function removeConfirmLeavePopup() {
  var confirmLeaveService;
  return regenerator_default.a.wrap(function removeConfirmLeavePopup$(_context10) {
    while (1) {
      switch (_context10.prev = _context10.next) {
        case 0:
          _context10.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], 'ConfirmLeaveService');

        case 2:
          confirmLeaveService = _context10.sent;
          _context10.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(confirmLeaveService.disableConfirmation.bind(confirmLeaveService));

        case 5:
        case "end":
          return _context10.stop();
      }
    }
  }, properties_sagas_marked10);
}
function deliverySagas() {
  return regenerator_default.a.wrap(function deliverySagas$(_context11) {
    while (1) {
      switch (_context11.prev = _context11.next) {
        case 0:
          _context11.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(properties_actions_actionTypes.RELEASE_DELIVERY_FORM_INIT_REQUEST, initializeForm), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_OR_UPDATE_REQUEST, save), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_CANCEL_REQUEST, cancel), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_DISCARD_CHANGES_REQUEST, discardChanges), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_SUCCESS, goToDetails), // takeEvery(actionTypes.RELEASE_DELIVERY_PRISTINE_CHANGE, addConfirmLeavePopup),
          Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(properties_actions_actionTypes.RELEASE_DELIVERY_GO_TO_PATTERN, properties_sagas_goToDeliveryPatternDetails), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(properties_actions_actionTypes.RELEASE_DELIVERY_GO_TO_FOLDER, goToDeliveryFolder)]);

        case 2:
        case "end":
          return _context11.stop();
      }
    }
  }, properties_sagas_marked11);
}
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/ducks/index.js


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/properties.store.js



var properties_store_marked = /*#__PURE__*/regenerator_default.a.mark(properties_store_combinedSaga);

/* global window */




var properties_store_sagaMiddleware = Object(redux_saga_core_npm_proxy_esm["a" /* default */])();
/* eslint-disable no-underscore-dangle, angular/typecheck-object, angular/module-getter, no-console, angular/log, lodash/prefer-lodash-typecheck */

var properties_store_composeEnhancers = (typeof window === "undefined" ? "undefined" : typeof_default()(window)) === 'object' && window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ ? window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__({
  name: 'delivery-properties' // Specify extension’s options like name, actionsBlacklist, actionsCreators, serialize...

}) : redux["compose"];

function properties_store_combinedSaga() {
  return regenerator_default.a.wrap(function combinedSaga$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          if (false) {}

          _context.prev = 1;
          _context.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliverySagas)]);

        case 4:
          _context.next = 9;
          break;

        case 6:
          _context.prev = 6;
          _context.t0 = _context["catch"](1);
          console.error('Release delivery properties saga:', _context.t0);

        case 9:
          _context.next = 0;
          break;

        case 11:
        case "end":
          return _context.stop();
      }
    }
  }, properties_store_marked, null, [[1, 6]]);
}

function properties_store_configureStore(preloadedState) {
  var enhancer = properties_store_composeEnhancers(Object(redux["applyMiddleware"])(properties_store_sagaMiddleware));
  var store = Object(redux["createStore"])(Object(redux["combineReducers"])({
    delivery: properties_reducers_delivery
  }), preloadedState, enhancer);
  properties_store_sagaMiddleware.run(properties_store_combinedSaga);
  return store;
}

var properties_store_store = properties_store_configureStore();
/* eslint-enable no-underscore-dangle, angular/typecheck-object, angular/module-getter, no-console, angular/log, lodash/prefer-lodash-typecheck */
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/components/delivery-properties-header.component.js








function delivery_properties_header_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_properties_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_properties_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }




var delivery_properties_header_component_DeliveryPropertiesHeader = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPropertiesHeader, _Component);

  var _super = delivery_properties_header_component_createSuper(DeliveryPropertiesHeader);

  function DeliveryPropertiesHeader() {
    var _this;

    classCallCheck_default()(this, DeliveryPropertiesHeader);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "handleSave", function () {
      var onSaveDelivery = _this.props.onSaveDelivery;
      onSaveDelivery();
    });

    return _this;
  }

  createClass_default()(DeliveryPropertiesHeader, [{
    key: "renderCreateFormButtons",
    value: function renderCreateFormButtons() {
      var _this$props = this.props,
          onCancelDelivery = _this$props.onCancelDelivery,
          saveDisabled = _this$props.saveDisabled;
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement("button", {
        className: "button cancel",
        onClick: onCancelDelivery
      }, "Cancel"), /*#__PURE__*/react_default.a.createElement("button", {
        className: "button primary",
        disabled: saveDisabled,
        onClick: this.handleSave
      }, "Create"));
    }
  }, {
    key: "renderEditFormButtons",
    value: function renderEditFormButtons() {
      var _this$props2 = this.props,
          discardChangesDisabled = _this$props2.discardChangesDisabled,
          onDiscardDeliveryChanges = _this$props2.onDiscardDeliveryChanges,
          saveDisabled = _this$props2.saveDisabled,
          lastSave = _this$props2.lastSave;
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, lastSave !== 0 && /*#__PURE__*/react_default.a.createElement("span", {
        className: "last-save-date"
      }, "Last saved on ", moment(lastSave).format('lll')), /*#__PURE__*/react_default.a.createElement("button", {
        className: "button cancel",
        disabled: discardChangesDisabled,
        onClick: onDiscardDeliveryChanges
      }, "Discard changes"), /*#__PURE__*/react_default.a.createElement("button", {
        className: "button primary",
        disabled: saveDisabled,
        onClick: this.handleSave
      }, "Save"));
    }
  }, {
    key: "render",
    value: function render() {
      var isCreateForm = this.props.isCreateForm;
      return /*#__PURE__*/react_default.a.createElement("div", null, isCreateForm && this.renderCreateFormButtons(), isCreateForm === false && this.renderEditFormButtons());
    }
  }]);

  return DeliveryPropertiesHeader;
}(react["Component"]);

defineProperty_default()(delivery_properties_header_component_DeliveryPropertiesHeader, "propTypes", {
  discardChangesDisabled: prop_types_default.a.bool.isRequired,
  isCreateForm: prop_types_default.a.bool,
  lastSave: prop_types_default.a.any,
  onCancelDelivery: prop_types_default.a.func.isRequired,
  onDiscardDeliveryChanges: prop_types_default.a.func.isRequired,
  onSaveDelivery: prop_types_default.a.func.isRequired,
  saveDisabled: prop_types_default.a.bool.isRequired
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/view/delivery-properties-header.container.js




var delivery_properties_header_container_mapStateToProps = function mapStateToProps(state) {
  var delivery = state.delivery;
  return {
    discardChangesDisabled: delivery.form.pristine,
    isCreateForm: delivery.form.isCreateForm,
    lastSave: delivery.form.lastSave,
    saveDisabled: delivery.form.pristine || !delivery.form.valid
  };
};

var delivery_properties_header_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    onCancelDelivery: function onCancelDelivery() {
      return dispatch(cancelDelivery());
    },
    onDiscardDeliveryChanges: function onDiscardDeliveryChanges() {
      return dispatch(properties_actions_onDiscardDeliveryChanges());
    },
    onSaveDelivery: function onSaveDelivery() {
      return dispatch(createOrUpdateDelivery());
    }
  };
};

/* harmony default export */ var delivery_properties_header_container = (Object(es["connect"])(delivery_properties_header_container_mapStateToProps, delivery_properties_header_container_mapDispatchToProps)(delivery_properties_header_component_DeliveryPropertiesHeader));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/view/delivery-properties-header.page.js






function delivery_properties_header_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_properties_header_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_properties_header_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var delivery_properties_header_page_DeliveryPropertiesHeaderPage = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPropertiesHeaderPage, _Component);

  var _super = delivery_properties_header_page_createSuper(DeliveryPropertiesHeaderPage);

  function DeliveryPropertiesHeaderPage() {
    classCallCheck_default()(this, DeliveryPropertiesHeaderPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryPropertiesHeaderPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/react_default.a.createElement(es["Provider"], {
        store: properties_store_store
      }, /*#__PURE__*/react_default.a.createElement(delivery_properties_header_container, null));
    }
  }]);

  return DeliveryPropertiesHeaderPage;
}(react["Component"]);


// EXTERNAL MODULE: ./node_modules/lodash/isEmpty.js
var isEmpty = __webpack_require__(59);
var isEmpty_default = /*#__PURE__*/__webpack_require__.n(isEmpty);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/tracked-item.types.js

var tracked_item_types_TrackedItem = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  title: prop_types_default.a.string
});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/delivery-properties.types.js



var StageStatus = prop_types_default.a.oneOf(Object.values(stageStatus));
var delivery_properties_types_Stage = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  type: prop_types_default.a.oneOf([ciTypes.stage]),
  title: prop_types_default.a.string,
  status: StageStatus
});
var DeliveryStatus = prop_types_default.a.oneOf(Object.values(delivery_properties_constants_deliveryStatus));
var LinkObject = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  title: prop_types_default.a.string
});
var Folder = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  title: prop_types_default.a.string
});
var Delivery = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  type: prop_types_default.a.oneOf([ciTypes.delivery]),
  title: prop_types_default.a.string,
  status: DeliveryStatus,
  startDate: prop_types_default.a.any,
  //PropTypes.instanceOf(Date), // PropTypes.instanceOf(Moment)// TODO: check props type 2019-05-10T13:00:38+02:00
  endDate: prop_types_default.a.any,
  plannedDuration: prop_types_default.a.number,
  releaseIds: prop_types_default.a.arrayOf(prop_types_default.a.string),
  progress: prop_types_default.a.number,
  folder: LinkObject,
  pattern: LinkObject,
  stages: prop_types_default.a.arrayOf(delivery_properties_types_Stage),
  trackedItems: prop_types_default.a.arrayOf(tracked_item_types_TrackedItem),
  $metadata: prop_types_default.a.object
});
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/components/delivery-properties.less
var delivery_properties = __webpack_require__(2205);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/components/delivery-properties.component.js








function delivery_properties_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function delivery_properties_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_properties_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_properties_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function delivery_properties_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_properties_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_properties_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }









var nameFormMetadata = {
  label: 'Delivery name',
  placeholder: 'Add...',
  description: 'Name of the delivery',
  required: true
};
var patternFormMetadata = {
  label: 'Created from pattern'
};
var folderFormMetadata = {
  label: 'Folder'
};
var descriptionFormMetadata = {
  label: 'Description',
  placeholder: 'Set description...',
  description: 'Description of the delivery',
  size: 'MEDIUM'
};
var startDateFormMetadata = {
  label: 'Start date',
  placeholder: '',
  description: 'Date and time when you want the delivery to start'
};
var endDateFormMetadata = {
  label: 'End date',
  placeholder: '',
  description: 'Date and time when you want the delivery to end'
};

var delivery_properties_component_maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: Object(validators["e" /* validateMaxLength */])(inputText, maxLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};

var delivery_properties_component_DeliveryPropertiesComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPropertiesComponent, _Component);

  var _super = delivery_properties_component_createSuper(DeliveryPropertiesComponent);

  function DeliveryPropertiesComponent() {
    var _this;

    classCallCheck_default()(this, DeliveryPropertiesComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "isDescriptionPristine", true);

    defineProperty_default()(assertThisInitialized_default()(_this), "isNamePristine", true);

    defineProperty_default()(assertThisInitialized_default()(_this), "isStartDatePristine", true);

    defineProperty_default()(assertThisInitialized_default()(_this), "isStartTimePristine", true);

    defineProperty_default()(assertThisInitialized_default()(_this), "isEndDatePristine", true);

    defineProperty_default()(assertThisInitialized_default()(_this), "isEndTimePristine", true);

    defineProperty_default()(assertThisInitialized_default()(_this), "isNameValid", false);

    defineProperty_default()(assertThisInitialized_default()(_this), "isDescriptionValid", false);

    defineProperty_default()(assertThisInitialized_default()(_this), "isStartDateTimeValid", false);

    defineProperty_default()(assertThisInitialized_default()(_this), "isEndDateTimeValid", false);

    defineProperty_default()(assertThisInitialized_default()(_this), "onRegister", function (componentApi) {
      componentApi.focus();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "_handleKeyDown", function (e) {
      var valid = _this.props.valid;

      if (e.key === 'Enter' && valid) {
        _this.props.onSaveDelivery();
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNamePristine", function (pristine) {
      _this.isNamePristine = pristine;

      _this.props.onPristineChange(_this.isDeliveryFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDescPristine", function (pristine) {
      _this.isDescriptionPristine = pristine;

      _this.props.onPristineChange(_this.isDeliveryFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onStartDatePristineChange", function (pristine) {
      _this.isStartDatePristine = pristine;

      _this.props.onPristineChange(_this.isDeliveryFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onStartTimePristineChange", function (pristine) {
      _this.isStartTimePristine = pristine;

      _this.props.onPristineChange(_this.isDeliveryFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onEndDatePristineChange", function (pristine) {
      _this.isEndDatePristine = pristine;

      _this.props.onPristineChange(_this.isDeliveryFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onEndTimePristineChange", function (pristine) {
      _this.isEndTimePristine = pristine;

      _this.props.onPristineChange(_this.isDeliveryFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNameValidityChange", function (valid) {
      _this.isNameValid = valid;

      _this.props.onValidationChange(_this.isDeliveryFormValid);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDescriptionValidityChange", function (valid) {
      _this.isDescriptionValid = valid;

      _this.props.onValidationChange(_this.isDeliveryFormValid);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onStartDateTimeValidityChange", function (valid) {
      _this.isStartDateTimeValid = valid;

      _this.props.onValidationChange(_this.isDeliveryFormValid);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onEndDateTimeValidityChange", function (valid) {
      _this.isEndDateTimeValid = valid;

      _this.props.onValidationChange(_this.isDeliveryFormValid);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNameChange", function (title) {
      var _this$props = _this.props,
          model = _this$props.model,
          onFormChange = _this$props.onFormChange;

      if (title !== model.title) {
        onFormChange(delivery_properties_component_objectSpread({}, model, {
          title: title
        }));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDescriptionChange", function (description) {
      var _this$props2 = _this.props,
          model = _this$props2.model,
          onFormChange = _this$props2.onFormChange;

      if (description !== model.description) {
        onFormChange(delivery_properties_component_objectSpread({}, model, {
          description: description
        }));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onStartDatetimeChange", function (startDate) {
      var _this$props3 = _this.props,
          model = _this$props3.model,
          onFormChange = _this$props3.onFormChange;

      if (startDate !== model.startDate) {
        onFormChange(delivery_properties_component_objectSpread({}, model, {
          startDate: startDate
        }));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onEndDatetimeChange", function (endDate) {
      var _this$props4 = _this.props,
          model = _this$props4.model,
          onFormChange = _this$props4.onFormChange;

      if (endDate !== model.endDate) {
        onFormChange(delivery_properties_component_objectSpread({}, model, {
          endDate: endDate
        }));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "goToDeliveryPattern", function () {
      var _this$props5 = _this.props,
          model = _this$props5.model,
          goToDeliveryPattern = _this$props5.goToDeliveryPattern;
      goToDeliveryPattern(model.pattern.id);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "goToFolder", function () {
      var _this$props6 = _this.props,
          model = _this$props6.model,
          goToFolder = _this$props6.goToFolder;
      goToFolder(model.folder.id);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderPattern", function (isNew, pattern) {
      return isNew || pattern.hasViewAccess ? /*#__PURE__*/react_default.a.createElement("a", {
        className: "details-link",
        onClick: _this.goToDeliveryPattern
      }, pattern.title) : /*#__PURE__*/react_default.a.createElement("span", null, pattern.title);
    });

    return _this;
  }

  createClass_default()(DeliveryPropertiesComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props7 = this.props,
          delivery = _this$props7.delivery,
          folder = _this$props7.folder,
          initDeliveryForm = _this$props7.initDeliveryForm,
          patternId = _this$props7.patternId;
      initDeliveryForm(delivery, patternId, folder);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var cleanForm = this.props.cleanForm;
      cleanForm();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props8 = this.props,
          model = _this$props8.model,
          propertiesFormKey = _this$props8.propertiesFormKey,
          delivery = _this$props8.delivery; // eslint-disable-next-line angular/definedundefined

      var isEditable = this.props.isEditable !== undefined ? this.props.isEditable : true;
      /* eslint-enable angular/definedundefined */

      var isNew = isEmpty_default()(model.id);
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "row",
        id: "delivery-properties",
        key: propertiesFormKey
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "col-sm-7"
      }, /*#__PURE__*/react_default.a.createElement("fieldset", null, /*#__PURE__*/react_default.a.createElement("legend", null, "Properties ", !isNew && /*#__PURE__*/react_default.a.createElement("span", null, "for ", delivery.title)), /*#__PURE__*/react_default.a.createElement("div", {
        onKeyDown: this._handleKeyDown
      }, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetString"], {
        disabled: !isEditable,
        metadata: nameFormMetadata,
        model: model.title,
        onModelChange: this.onNameChange,
        onPristinityChange: this.onNamePristine,
        onValidityChange: this.onNameValidityChange,
        register: this.onRegister,
        validators: [delivery_properties_component_maxLengthValidator(nameFormMetadata.label, 255), Object(validators["c" /* reservedCharactersValidator */])(nameFormMetadata.label)]
      })), /*#__PURE__*/react_default.a.createElement("div", {
        className: "xl-react-components"
      }, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetLabel"], {
        metadata: patternFormMetadata
      }), model.pattern && model.pattern.id ? this.renderPattern(isNew, model.pattern) : /*#__PURE__*/react_default.a.createElement("span", null, "[Pattern has been deleted]")), /*#__PURE__*/react_default.a.createElement("div", {
        className: "xl-react-components"
      }, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetLabel"], {
        metadata: folderFormMetadata
      }), model.folder.hasViewAccess ? /*#__PURE__*/react_default.a.createElement("a", {
        className: "details-link",
        "data-test-id": "folderId",
        onClick: this.goToFolder
      }, model.folder.title) : /*#__PURE__*/react_default.a.createElement("span", {
        "data-test-id": "folderId"
      }, model.folder.title)), /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetString"], {
        disabled: !isEditable,
        metadata: descriptionFormMetadata,
        model: model.description,
        onModelChange: this.onDescriptionChange,
        onPristinityChange: this.onDescPristine,
        onValidityChange: this.onDescriptionValidityChange,
        validators: [delivery_properties_component_maxLengthValidator(descriptionFormMetadata.label, 1024)]
      }))), /*#__PURE__*/react_default.a.createElement("div", {
        className: "col-sm-5"
      }, /*#__PURE__*/react_default.a.createElement("fieldset", null, /*#__PURE__*/react_default.a.createElement("legend", null, "Delivery details"), /*#__PURE__*/react_default.a.createElement(widgets["a" /* WidgetDateTime */], {
        disabled: !isEditable,
        metadata: startDateFormMetadata,
        model: model.startDate,
        onDatePristinityChange: this.onStartDatePristineChange,
        onModelChange: this.onStartDatetimeChange,
        onTimePristinityChange: this.onStartTimePristineChange,
        onValidityChange: this.onStartDateTimeValidityChange
      }), /*#__PURE__*/react_default.a.createElement(widgets["a" /* WidgetDateTime */], {
        disabled: !isEditable,
        metadata: endDateFormMetadata,
        model: model.endDate,
        onDatePristinityChange: this.onEndDatePristineChange,
        onModelChange: this.onEndDatetimeChange,
        onTimePristinityChange: this.onEndTimePristineChange,
        onValidityChange: this.onEndDateTimeValidityChange
      }))));
    }
  }, {
    key: "isDeliveryFormPristine",
    get: function get() {
      return this.isDescriptionPristine && this.isNamePristine && this.isStartDatePristine && this.isStartTimePristine && this.isEndDatePristine && this.isEndTimePristine;
    }
  }, {
    key: "isDeliveryFormValid",
    get: function get() {
      return this.isNameValid && this.isDescriptionValid && this.isStartDateTimeValid && this.isEndDateTimeValid;
    }
  }]);

  return DeliveryPropertiesComponent;
}(react["Component"]);

defineProperty_default()(delivery_properties_component_DeliveryPropertiesComponent, "propTypes", {
  cleanForm: prop_types_default.a.func,
  delivery: Delivery,
  folder: Folder,
  goToDeliveryPattern: prop_types_default.a.func,
  goToFolder: prop_types_default.a.func,
  initDeliveryForm: prop_types_default.a.func,
  isEditable: prop_types_default.a.bool,
  lastSave: prop_types_default.a.any,
  model: Delivery,
  onFormChange: prop_types_default.a.func.isRequired,
  onPristineChange: prop_types_default.a.func.isRequired,
  onSaveDelivery: prop_types_default.a.func.isRequired,
  onValidationChange: prop_types_default.a.func.isRequired,
  patternId: prop_types_default.a.string,
  propertiesFormKey: prop_types_default.a.number.isRequired,
  valid: prop_types_default.a.bool.isRequired
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/view/delivery-properties.container.js




var delivery_properties_container_mapStateToProps = function mapStateToProps(state) {
  var delivery = state.delivery;
  return {
    isEditable: delivery.form.isEditable,
    model: delivery.form.model,
    propertiesFormKey: delivery.form.key,
    valid: delivery.form.valid
  };
};

var delivery_properties_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    initDeliveryForm: function initDeliveryForm(delivery, patternId, folder) {
      return dispatch(properties_actions_initDeliveryForm(delivery, patternId, folder));
    },
    cleanForm: function cleanForm() {
      return dispatch(cleanFormFields());
    },
    goToFolder: function goToFolder(folderId) {
      return dispatch(properties_actions_goToFolder(folderId));
    },
    goToDeliveryPattern: function goToDeliveryPattern(patternId) {
      return dispatch(goToDeliveryPatternDetails(patternId));
    },
    onFormChange: function onFormChange(model) {
      return dispatch(changeModel(model));
    },
    onPristineChange: function onPristineChange(pristine) {
      return dispatch(changePristine(pristine));
    },
    onValidationChange: function onValidationChange(valid) {
      return dispatch(changeValidation(valid));
    },
    onSaveDelivery: function onSaveDelivery() {
      return dispatch(createOrUpdateDelivery());
    }
  };
};

/* harmony default export */ var delivery_properties_container = (Object(es["connect"])(delivery_properties_container_mapStateToProps, delivery_properties_container_mapDispatchToProps)(delivery_properties_component_DeliveryPropertiesComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/view/delivery-properties.page.js







function delivery_properties_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_properties_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_properties_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }








var delivery_properties_page_DeliveryPropertiesPage = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPropertiesPage, _Component);

  var _super = delivery_properties_page_createSuper(DeliveryPropertiesPage);

  function DeliveryPropertiesPage() {
    classCallCheck_default()(this, DeliveryPropertiesPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryPropertiesPage, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          delivery = _this$props.delivery,
          folder = _this$props.folder,
          patternId = _this$props.patternId;
      return /*#__PURE__*/react_default.a.createElement(es["Provider"], {
        store: properties_store_store
      }, /*#__PURE__*/react_default.a.createElement(delivery_properties_container, {
        delivery: delivery,
        folder: folder,
        patternId: patternId
      }));
    }
  }]);

  return DeliveryPropertiesPage;
}(react["Component"]);

defineProperty_default()(delivery_properties_page_DeliveryPropertiesPage, "propTypes", {
  delivery: Delivery,
  folder: Folder,
  patternId: prop_types_default.a.string
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/index.js



angular.module('xlrelease').component('xlrDeliveryPropertiesHeader', Object(react2angular["react2angular"])(delivery_properties_header_page_DeliveryPropertiesHeaderPage)).component('xlrDeliveryProperties', Object(react2angular["react2angular"])(delivery_properties_page_DeliveryPropertiesPage));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/components/timeline-row-name.html
/* harmony default export */ var timeline_row_name = ("<div class=\"timeline-row-name\" ng-init=\"model = getValue()\">\n    <span class=\"timeline-row-name-release\" ng-if=\"!model.isDelivery\">\n        <a class=\"release-title\" ng-href=\"{{model.releaseEditorURL}}\">{{::model.title}}</a>\n    </span>\n    <span class=\"timeline-row-name-delivery\" ng-if=\"model.isDelivery\">\n        <i class=\"xl-icon group-icon\"></i>\n        <span class=\"delivery-title\">{{::model.title}}</span>\n    </span>\n</div>\n");
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/actions/deliveries-timeline-actions.js
var deliveries_timeline_actions = __webpack_require__(94);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/components/timeline-controller.js




function timeline_controller_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function timeline_controller_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { timeline_controller_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { timeline_controller_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }





var phaseContentTemplate = "\n    <div xlr-delivery-timeline-tooltip\n         class=\"fgt-timeline-task-content\">\n         {{::task.model.name}}\n     </div>\n";
var deliveryContentTemplate = "\n    <div xlr-delivery-timeline-tooltip>\n         {{::task.model.name}}\n     </div>\n";

var timeline_controller_TimelineController = /*#__PURE__*/function () {
  function TimelineController($ngRedux, $scope, ViewStorage, Ids, DateService, Authenticator) {
    classCallCheck_default()(this, TimelineController);

    this._scope = $scope;
    this._viewStorage = ViewStorage;
    this._Ids = Ids;
    this._DateService = DateService;
    this._Authenticator = Authenticator;
    this._unsubscribe = $ngRedux.connect(this._mapStateToThis.bind(this), this._mapDispatchToThis.bind(this))(this);
  }

  createClass_default()(TimelineController, [{
    key: "$onInit",
    value: function $onInit() {
      this.initGanttTableOptions();
      this.currentDate = new Date(); // For performance reasons, when a lot of tasks are loaded in the gantt chart,
      // tasks outside of the visible scrollable viewport are removed from the DOM.

      this.taskLimitThreshold = 30;
      this.registerGanttApi = this.registerGanttApi.bind(this);
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this.resetToInitialState();

      this._unsubscribe();
    }
  }, {
    key: "initGanttTableOptions",
    value: function initGanttTableOptions() {
      this.tableColumns = ['row.model.id'];
      this.tableHeaders = {
        'row.model.id': 'Name'
      };
      this.tableContents = {
        'row.model.id': timeline_row_name
      };
      this.tableFormatters = {
        'row.model.id': this.getRowModel.bind(this)
      };
    }
  }, {
    key: "getRowModel",
    value: function getRowModel(value, column, row) {
      var isDelivery = _.get(row, 'model.tasks[0].data.isDelivery');

      if (isDelivery) {
        return {
          title: row.model.name,
          isDelivery: isDelivery
        };
      }

      var release = _.get(row, 'model.data.release');

      return {
        title: release && release.title,
        releaseEditorURL: this.getReleaseEditorURL(release),
        isDelivery: isDelivery,
        isUpdatable: this.isUpdatable.bind(this)
      };
    }
  }, {
    key: "getReleaseEditorURL",
    value: function getReleaseEditorURL(release) {
      var releaseId = this._Ids.toInternalId(release.id);

      return "#".concat(this._viewStorage.getView(releaseId, "/releases/".concat(releaseId)));
    }
  }, {
    key: "_mapDispatchToThis",
    value: function _mapDispatchToThis(dispatch) {
      return {
        fetchDelivery: function (_fetchDelivery) {
          function fetchDelivery() {
            return _fetchDelivery.apply(this, arguments);
          }

          fetchDelivery.toString = function () {
            return _fetchDelivery.toString();
          };

          return fetchDelivery;
        }(function () {
          dispatch(fetchDelivery(this.delivery.id));
        }),
        resetToInitialState: function resetToInitialState() {
          dispatch(Object(deliveries_timeline_actions["c" /* resetToInitialState */])());
        }
      };
    }
  }, {
    key: "_mapStateToThis",
    value: function _mapStateToThis(state) {
      var reducer = state.deliveriesTimeline;
      var newGanttData = this.getGanttData(reducer.delivery, reducer.filteredReleases);
      var ganttData = _.isEqual(reducer.filteredReleasesDateStamp, this.filteredReleasesDateStamp) ? this.ganttData : newGanttData;
      return timeline_controller_objectSpread({
        delivery: reducer.delivery,
        loading: reducer.loading,
        hasReleases: !!reducer.filteredReleases.length,
        filters: reducer.filters,
        filteredReleasesDateStamp: reducer.filteredReleasesDateStamp
      }, reducer.zoomLevel, {}, ganttData);
    }
  }, {
    key: "registerGanttApi",
    value: function registerGanttApi(api) {
      api.directives.on.new(this._scope, function (dName, dScope, dElement) {
        if (dName === 'ganttTask') {
          var phaseColor = _.get(dScope, ['task', 'model', 'data', 'phase', 'color']);

          if (phaseColor) {
            dElement.css({
              'border-color': phaseColor
            });
          }
        }
      });
    }
  }, {
    key: "isUpdatable",
    value: function isUpdatable() {
      return Object(services["f" /* isDeliveryUpdatable */])(this.delivery) && this._Authenticator.hasDeliveryEditPermission(this.delivery);
    }
  }, {
    key: "getPhaseStartDate",
    value: function getPhaseStartDate(phase) {
      return phase.plannedStartDate;
    }
  }, {
    key: "getPhaseEndDate",
    value: function getPhaseEndDate(phase) {
      return phase.plannedEndDate;
    }
  }, {
    key: "getGanttData",
    value: function getGanttData(delivery, releases) {
      var _this = this;

      if (!delivery || !releases) {
        return {
          ganttData: {
            data: [],
            timespans: []
          }
        };
      }

      var height = 36;
      var deliveryTimespan = {
        from: moment(delivery.startDate).toDate(),
        to: moment(delivery.endDate).toDate()
      };

      var data = _.reduce(releases, function (rows, release) {
        rows.push({
          name: release.title,
          height: height,
          sortable: false,
          classes: 'gantt-row-milestone',
          tasks: (release.phases || []).filter(function (phase) {
            return _this.getPhaseStartDate(phase) && _this.getPhaseEndDate(phase);
          }).map(function (phase) {
            var from = moment(_this.getPhaseStartDate(phase));
            var to = moment(_this.getPhaseEndDate(phase));
            var classes = ['fgt-timeline-task-release-phase'];

            if (_this._DateService.isOverdue(to.valueOf())) {
              classes.push('fgt-timeline-task-incomplete');
            }

            return {
              name: phase.title,
              from: from.toDate(),
              to: to.toDate(),
              classes: classes,
              data: {
                phase: phase,
                release: release,
                $ctrl: _this
              },
              content: phaseContentTemplate
            };
          }),
          data: {
            release: release,
            isDelivery: false
          }
        });
        return rows;
      }, [{
        name: delivery.title,
        height: height,
        classes: ['fgt-timeline-task-delivery'],
        tasks: [timeline_controller_objectSpread({
          name: delivery.title,
          content: deliveryContentTemplate,
          data: {
            release: {
              status: 'PLANNED'
            },
            isDelivery: true
          }
        }, deliveryTimespan)]
      }]);

      return {
        ganttData: {
          data: data,
          timespans: data.length > 1 ? [deliveryTimespan] : []
        }
      };
    }
  }, {
    key: "getDateDiff",
    value: function getDateDiff(actualDate, expectedDate) {
      return this._DateService.getOverdueDuration(actualDate, expectedDate);
    }
  }, {
    key: "isDateOverdue",
    value: function isDateOverdue(actualDate, expectedDate) {
      return expectedDate && moment(actualDate, global_constants["a" /* dateTimeFormat */].unixMillisecondTimestamp).diff(moment(expectedDate, global_constants["a" /* dateTimeFormat */].unixMillisecondTimestamp)) > 0;
    }
  }, {
    key: "hasReleasesFound",
    value: function hasReleasesFound() {
      return this.hasReleases && !this.loading;
    }
  }]);

  return TimelineController;
}();

defineProperty_default()(timeline_controller_TimelineController, "$inject", ['$ngRedux', '$scope', 'ViewStorage', 'Ids', 'DateService', 'Authenticator']);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/components/timeline-tpl.html
/* harmony default export */ var timeline_tpl = ("<div class=\"content-under-header fgt-timeline\">\n    <div class=\"row\">\n        <div gantt\n             data=\"$ctrl.ganttData.data\"\n             timespans=\"$ctrl.ganttData.timespans\"\n             current-date-value=\"$ctrl.currentDate\"\n             column-width=\"$ctrl.columnWidth\"\n             view-scale=\"$ctrl.viewScale\"\n             headers=\"$ctrl.headers\"\n             headers-scales=\"$ctrl.headersScales\"\n             headers-formats=\"$ctrl.headersFormats\"\n\n             allow-side-resizing=\"false\"\n             api=\"::$ctrl.registerGanttApi\"\n             current-date=\"'line'\"\n             expand-to-fit=\"true\"\n             taskLimitThreshold=\"::$ctrl.taskLimitThreshold\"\n             max-height=\"'100%'\">\n            <gantt-table\n                    columns=\"::$ctrl.tableColumns\"\n                    headers=\"::$ctrl.tableHeaders\"\n                    contents=\"::$ctrl.tableContents\"\n                    formatters=\"::$ctrl.tableFormatters\">\n            </gantt-table>\n\n            <gantt-bounds></gantt-bounds>\n            <gantt-progress></gantt-progress>\n            <gantt-overlap></gantt-overlap>\n            <gantt-deliveries></gantt-deliveries>\n        </div>\n    </div>\n    <div class=\"row alert notice no-release-message\" ng-if=\"!$ctrl.hasReleasesFound() && !$ctrl.loading\">\n        <div>No releases found</div>\n    </div>\n    <div class=\"spinner\" ng-if=\"$ctrl.loading\">\n        <img src=\"static/9.7.7/styles/img/big-ajax-loader.gif\" alt=\"Loading...\" />\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/components/index.js


var timelineComponent = {
  bindings: {
    loading: '<',
    delivery: '<',
    onRefresh: '&'
  },
  controller: timeline_controller_TimelineController,
  template: timeline_tpl
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/components/timeline-phase-tooltip.html
/* harmony default export */ var timeline_phase_tooltip = ("<span class=\"fgt-timeline-text-ellipsis fgt-timeline-tooltip-phase_name\">Phase: {{::task.model.data.phase.title}}</span>\n<ul class=\"list-unstyled\" ng-init=\"phase = task.model.data.phase\">\n    <li ng-if=\"::!phase.startDate\" class=\"text-right\">\n        <span class=\"pull-left\">Estimated start date:</span>\n        <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(phase.plannedStartDate, phase.scheduledStartDate)}\">\n            {{::phase.plannedStartDate | mediumDateShortTime}}\n            <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(phase.plannedStartDate, phase.scheduledStartDate)}}</div>\n        </span>\n    </li>\n    <li ng-if=\"::phase.startDate\" class=\"text-right\">\n        <span class=\"pull-left\">Start date:</span>\n        <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(phase.startDate, phase.scheduledStartDate)}\">\n            {{::phase.startDate | mediumDateShortTime}}\n            <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(phase.startDate, phase.scheduledStartDate)}}</div>\n        </span>\n    </li>\n    <li ng-if=\"::!phase.endDate\" class=\"text-right\">\n        <span class=\"pull-left\">Estimated end date:</span>\n        <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(phase.plannedEndDate, phase.dueDate)}\">\n            {{::phase.plannedEndDate | mediumDateShortTime}}\n            <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(phase.plannedEndDate, phase.dueDate)}}</div>\n        </span>\n    </li>\n    <li ng-if=\"::phase.endDate\" class=\"text-right\">\n        <span class=\"pull-left\">End date:</span>\n        <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(phase.endDate, phase.dueDate)}\">\n            {{::phase.endDate | mediumDateShortTime}}\n            <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(phase.endDate, phase.dueDate)}}</div>\n        </span>\n    </li>\n</ul>\n<div class=\"running-task-info\" ng-show=\"::phase.currentTask\">\n    Running task: {{::phase.currentTask}}\n</div>\n<div class=\"fgt-timeline-tooltip-splitter\"></div>\n<div class=\"fgt-timeline-tooltip-release\">\n    <span class=\"fgt-timeline-tooltip-belongs_to\">Release: {{::task.model.data.release.title}}</span>\n    <span class=\"pull-right\">\n        <release-status-label release=\"task.model.data.release\" show-archived=\"true\"></release-status-label>\n    </span>\n</div>\n<ul class=\"list-unstyled\" ng-init=\"release = task.model.data.release\">\n    <li ng-if=\"::!release.startDate\" class=\"text-right\">\n        <span class=\"pull-left\">Planned start date:</span>\n        <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(release.plannedStartDate, release.scheduledStartDate)}\">\n            {{::release.plannedStartDate | mediumDateShortTime}}\n            <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(release.plannedStartDate, release.scheduledStartDate)}}</div>\n        </span>\n    </li>\n    <li ng-if=\"::release.startDate\" class=\"text-right\">\n        <span class=\"pull-left\">Start date:</span>\n        <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(release.startDate, release.scheduledStartDate)}\">\n            {{::release.startDate | mediumDateShortTime}}\n            <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(release.startDate, release.scheduledStartDate)}}</div>\n        </span>\n    </li>\n    <li ng-if=\"::!release.endDate\" class=\"text-right\">\n        <span class=\"pull-left\">Planned end date:</span>\n        <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(release.plannedEndDate, release.dueDate)}\">\n            {{::release.plannedEndDate | mediumDateShortTime}}\n            <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(release.plannedEndDate, release.dueDate)}}</div>\n        </span>\n    </li>\n    <li ng-if=\"::release.endDate\" class=\"text-right\">\n        <span class=\"pull-left\">End date:</span>\n        <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(release.endDate, release.dueDate)}\">\n            {{::release.endDate | mediumDateShortTime}}\n            <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(release.endDate, release.dueDate)}}</div>\n        </span>\n    </li>\n</ul>\n");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/components/timeline-delivery-tooltip.html
/* harmony default export */ var timeline_delivery_tooltip = ("<span class=\"fgt-timeline-text-ellipsis fgt-timeline-tooltip-phase_name\">Delivery: {{::task.model.name}}</span>\n<ul class=\"list-unstyled\">\n    <li>\n        <span>Start date:</span>\n        <span class=\"pull-right\">\n            {{::task.model.from.toDate() | mediumDateShortTime}}\n        </span>\n    </li>\n    <li>\n        <span>End date:</span>\n        <span class=\"pull-right\">\n            {{::task.model.to.toDate() | mediumDateShortTime}}\n        </span>\n    </li>\n</ul>\n");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/components/timeline-tooltip-directive.js


var tooltipTemplate = "\n    <div class='tooltip fgt-timeline-tooltip' role='tooltip'>\n        <div class='tooltip-arrow fgt-timeline-tooltip-arrow'></div>\n        <div class='tooltip-inner'></div>\n    </div>\n";
/* harmony default export */ var timeline_tooltip_directive = (['$compile', function ($compile) {
  return {
    restrict: 'A',
    link: function link(scope, element) {
      var template = _.get(scope, ['task', 'model', 'data', 'isDelivery']) ? timeline_delivery_tooltip : timeline_phase_tooltip;
      element.tooltip({
        title: $compile(template)(scope),
        delay: 50,
        trigger: 'hover',
        placement: 'auto',
        html: true,
        animation: false,
        container: 'body',
        template: tooltipTemplate
      });
      var offStateChangeStart = scope.$on('$stateChangeStart', function () {
        element.tooltip('destroy');
        offStateChangeStart();
      });

      var throttled = _.throttle(trackMove, 0);

      element.mousemove(throttled);

      function trackMove(event) {
        var tooltip = angular.element('.fgt-timeline-tooltip');
        var tooltipArrow = angular.element('.fgt-timeline-tooltip-arrow');
        var tooltipWidth = tooltip.outerWidth();
        var tooltipHalfWidth = tooltipWidth / 2;
        var clientX = parseInt(event.clientX);
        var marginRight = 5;

        if (event.clientX + tooltipHalfWidth + marginRight >= window.outerWidth) {
          tooltip.css('left', '');
          tooltip.css('right', "".concat(marginRight, "px"));
          tooltipArrow.css('left', "".concat(tooltipWidth - (window.outerWidth - clientX), "px"));
        } else {
          tooltipArrow.css('left', "".concat(tooltipHalfWidth, "px"));
          tooltip.css('left', "".concat(clientX - tooltipHalfWidth, "px"));
          tooltip.css('right', '');
        }
      }
    }
  };
}]);
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/delivery-timeline-page.less
var delivery_timeline_page = __webpack_require__(2206);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/delivery-timeline-page.js




function delivery_timeline_page_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function delivery_timeline_page_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_timeline_page_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_timeline_page_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var delivery_timeline_page_template = "\n<div id=\"deliveries\" class=\"fc-list fgd-deliveries\">\n    <xlr-delivery-details-header delivery=\"$ctrl.delivery\" class=\"delivery-header-gantt-fix\">\n        <filter class=\"filters\"\n                filters=\"$ctrl.filters\"\n                on-change=\"$ctrl.onFiltersChanged()\">\n            <div class=\"actions\">\n                <i class=\"button-toggle-filter-icon xl-icon search-icon\"/>\n                <text-filter field=\"'title'\" placeholder=\"'Search for releases'\"/>\n                <order-by-filter class=\"filter last\"/>\n                <span class=\"fgt-zoom filter\">\n                        <span class=\"filter-title\">Zoom</span>\n                        <div class=\"button-delivery\">\n                            <button class=\"btn btn-flat button-icon\"\n                                    ng-click=\"$ctrl.zoomLevelOut && $ctrl.zoomOut()\"\n                                    ng-disabled=\"!$ctrl.zoomLevelOut\"><i class=\"xl-icon minus-icon\"/></button>\n                        <button class=\"btn btn-flat button-icon\"\n                                ng-click=\"$ctrl.zoomLevelIn && $ctrl.zoomIn()\"\n                                ng-disabled=\"!$ctrl.zoomLevelIn\"><i class=\"xl-icon add-icon\"/></button>\n                        </div>\n                    </span>\n            </div>\n        </filter>\n\n        <div class=\"buttons\">\n            <span doc-icon=\"deliveries-details.html\"/>\n        </div>\n    </xlr-delivery-details-header>\n    <div class=\"fc-list-items-wrapper\">\n        <xlr-delivery-timeline delivery=\"$ctrl.delivery\" loading=\"$ctrl.loading\" on-refresh=\"$ctrl.onFiltersChanged()\"/>\n    </div>\n</div>\n";

var delivery_timeline_page_DeliveryTimelinePageController = /*#__PURE__*/function () {
  function DeliveryTimelinePageController($scope, Events, $ngRedux, Page) {
    classCallCheck_default()(this, DeliveryTimelinePageController);

    this._$scope = $scope;
    this._Events = Events;
    this._Page = Page;
    this._isBreadCrumbInitialized = false;
    this._unsubscribe = $ngRedux.connect(this._mapStateToThis.bind(this), this._mapDispatchToThis.bind(this))(this);
  }

  createClass_default()(DeliveryTimelinePageController, [{
    key: "$onInit",
    value: function $onInit() {
      this._$scope.$emit(this._Events.permission.refresh);

      this.fetchTimeline({});
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this.resetToInitialState();

      this._unsubscribe();
    }
  }, {
    key: "_mapDispatchToThis",
    value: function _mapDispatchToThis(dispatch) {
      return {
        resetToInitialState: function resetToInitialState() {
          dispatch(Object(deliveries_timeline_actions["c" /* resetToInitialState */])());
        },
        fetchTimeline: function fetchTimeline(filters) {
          dispatch(Object(deliveries_timeline_actions["b" /* getTimeline */])(this.delivery, filters));
        },
        updateFilters: function updateFilters(filters) {
          dispatch(Object(deliveries_timeline_actions["d" /* setFilters */])(filters));
        },
        zoomIn: function zoomIn() {
          dispatch({
            type: deliveries_timeline_actions["a" /* actionTypes */].ZOOM_IN
          });
        },
        zoomOut: function zoomOut() {
          dispatch({
            type: deliveries_timeline_actions["a" /* actionTypes */].ZOOM_OUT
          });
        }
      };
    }
  }, {
    key: "_mapStateToThis",
    value: function _mapStateToThis(_ref) {
      var deliveriesTimeline = _ref.deliveriesTimeline;
      var delivery = deliveriesTimeline.delivery;

      if (delivery) {
        this._setBreadcrumbs(delivery);
      }

      return delivery_timeline_page_objectSpread({
        gantt: deliveriesTimeline.gantt,
        delivery: delivery,
        loading: deliveriesTimeline.loading,
        filters: deliveriesTimeline.filters
      }, deliveriesTimeline.zoomLevel);
    }
  }, {
    key: "_setBreadcrumbs",
    value: function _setBreadcrumbs(delivery) {
      if (!this._isBreadCrumbInitialized) {
        this._Page.setFolderEntityOpened(delivery.folderId, delivery);

        this._isBreadCrumbInitialized = true;
      }
    }
  }, {
    key: "onFiltersChanged",
    value: function onFiltersChanged() {
      this.updateFilters(this.filters);
    }
  }]);

  return DeliveryTimelinePageController;
}();

defineProperty_default()(delivery_timeline_page_DeliveryTimelinePageController, "$inject", ['$scope', 'Events', '$ngRedux', 'Page']);

var deliveryTimelinePage = {
  bindings: {
    delivery: '<',
    folder: '<'
  },
  controller: delivery_timeline_page_DeliveryTimelinePageController,
  template: delivery_timeline_page_template
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/index.js



/* harmony default export */ var timeline = (angular.module('xlrelease.deliveriesDetails', ['gantt', 'gantt.table', 'gantt.bounds', 'gantt.progress', 'gantt.overlap', 'gantt.groups']).directive('xlrDeliveryTimelineTooltip', timeline_tooltip_directive).component('xlrDeliveryTimeline', timelineComponent).component('xlrDeliveryTimelinePage', deliveryTimelinePage));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/index.js



// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/services/index.js
var deliveries_details_services = __webpack_require__(236);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/activity-logs/delivery-activity-logs.html
/* harmony default export */ var delivery_activity_logs = ("<div id=\"logs\" ng-if=\"filters\">\n    <xlr-delivery-details-header delivery=\"delivery\">\n        <div class=\"filters\" ng-controller=\"FiltersController\">\n            <div class=\"actions\">\n                <input id=\"search-filter\" autofocus type=\"search\" class=\"filter\" placeholder=\"Filter by user or action...\" ng-model=\"filters.filter\">\n                <button type=\"button\" class=\"button dropdown-button filter\" bs-popover\n                        data-content-template=\"static/9.7.7/include/ActivityLogs/activity-logs-filter/activity-logs-categories-filter.html\"\n                        data-placement=\"bottom\" auto-close=\"true\">Filter categories\n                </button>\n                <span class=\"filter\" ng-include=\"'partials/filters/from-to-date-filters.html'\"/>\n            </div>\n        </div>\n        <span doc-icon=\"activity-logs.html\"></span>\n    </xlr-delivery-details-header>\n    <div class=\"content-under-header\">\n        <activity-logs-list filters=\"filters\" container-id=\"containerId\" />\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/activity-logs/delivery-activity-logs-controller.js



var delivery_activity_logs_controller_DeliveryActivityLogsController = function DeliveryActivityLogsController($scope, $stateParams, filterSettings, deliveryPromise) {
  classCallCheck_default()(this, DeliveryActivityLogsController);

  this._$scope = $scope;
  this._$scope.containerId = $stateParams.deliveryId;
  this._$scope.filters = filterSettings;
  this._$scope.activityFilters = [{
    id: "display-important",
    model: "important",
    label: "Important"
  }, {
    id: "display-lifecycle",
    model: "lifecycle",
    label: "Delivery life cycle"
  }, {
    id: "display-delivery_edit",
    model: "deliveryEdit",
    label: "Delivery edits"
  }, {
    id: "display-other",
    model: "other",
    label: "Other"
  }];
  this._$scope.delivery = deliveryPromise.data;
};

defineProperty_default()(delivery_activity_logs_controller_DeliveryActivityLogsController, "$inject", ['$scope', '$stateParams', 'filterSettings', 'deliveryPromise']);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/index.js









/* harmony default export */ var deliveries_details = (angular.module('xlrelease.deliveriesDetails').component('xlrDeliveryDetailsHeader', deliveryDetailsHeader).config(['$urlMatcherFactoryProvider', '$stateProvider', function ($urlMatcherFactoryProvider, $stateProvider) {
  $urlMatcherFactoryProvider.type('DeliveryId', {
    encode: angular.identity,
    decode: angular.identity,
    pattern: /Deliveries\/Delivery\w+/
  });
  $stateProvider.state('deliveryCreate', {
    url: '/deliveries/create?fromPatternId',
    controller: ['$stateParams', '$window', 'Ids', function ($stateParams, $window, Ids) {
      //redirect to previous page when patternId is not defined
      this.patternId = $stateParams.fromPatternId ? Ids.toDomainId($stateParams.fromPatternId) : $window.history.back();
    }],
    controllerAs: 'deliveryCreateCtrl',
    template: "\n                    <div id=\"delivery-details\">\n                        <xlr-delivery-details-header>\n                            <h4>Create new delivery</h4>\n                            <div class=\"buttons\">\n                                <xlr-delivery-properties-header></xlr-delivery-properties-header>\n                                <span doc-icon=\"deliveries.html\"></span>\n                            </div>\n                        </xlr-delivery-details-header>\n                    \n                        <div class=\"content-under-header\">\n                            <xlr-delivery-properties pattern-id=\"deliveryCreateCtrl.patternId\"></xlr-delivery-properties>\n                        </div>\n                    </div>"
  }).state('deliveriesDetails', {
    url: '/deliveries/{deliveryId: DeliveryId}',
    reloadOnSearch: false,
    template: delivery_details_page_extension_container,
    controller: deliveries_details_page_extension_controller_DeliveryDetailsPageExtensionController,
    controllerAs: 'deliveryDetailsPageExtension',
    resolve: {
      deliveryPromise: ['$stateParams', function ($stateParams) {
        return Promise.all([Object(deliveries_details_services["a" /* fetchDelivery */])($stateParams.deliveryId), deliveryFlowService.fetchStageReleases($stateParams.deliveryId)]).then(function (responses) {
          return responses;
        });
      }]
    }
  }).state('deliveryLogs', {
    url: '/deliveries/{deliveryId: DeliveryId}/logs',
    reloadOnSearch: false,
    template: delivery_activity_logs,
    controller: delivery_activity_logs_controller_DeliveryActivityLogsController,
    controllerAs: '$ctrl',
    resolve: {
      filterSettings: ['$stateParams', 'Filters', function ($stateParams, Filters) {
        return Filters.getLogsFiltersSettings($stateParams.deliveryId);
      }],
      deliveryPromise: ['$stateParams', function ($stateParams) {
        return Object(deliveries_details_services["a" /* fetchDelivery */])($stateParams.deliveryId);
      }]
    }
  }).state('deliveryDetailsPageExtension', {
    url: '/deliveries/{deliveryId: DeliveryId}/:extensionPath',
    template: delivery_details_page_extension_container,
    controller: deliveries_details_page_extension_controller_DeliveryDetailsPageExtensionController,
    controllerAs: 'deliveryDetailsPageExtension',
    resolve: {
      deliveryPromise: ['$stateParams', function ($stateParams) {
        if ($stateParams.extensionPath === "") {
          return Promise.all([Object(deliveries_details_services["a" /* fetchDelivery */])($stateParams.deliveryId), deliveryFlowService.fetchStageReleases($stateParams.deliveryId)]).then(function (responses) {
            return responses;
          });
        }

        return Object(deliveries_details_services["a" /* fetchDelivery */])($stateParams.deliveryId);
      }]
    }
  });
}]).name);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/get.js
var get = __webpack_require__(436);
var get_default = /*#__PURE__*/__webpack_require__.n(get);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-folder/folder-deliveries.html
/* harmony default export */ var folder_deliveries = ("\n<folder-details folder=\"$ctrl.folder\" ng-class=\"{'header-expanded': $ctrl.isHeaderExpanded}\" >\n    <header class=\"folder-deliveries-header\">\n      <delivery-filter\n          filters=\"$ctrl.filters\"\n          filters-changed=\"$ctrl.filtersChanged()\"\n          items-count=\"$ctrl.itemsCount\">\n      </delivery-filter>\n       <delivery-sub-header has-deliveries=\"$ctrl.hasDeliveries()\"></delivery-sub-header>\n    </header>\n    <content>\n        <div class=\"folder-deliveries-list\" id=\"deliveries\">\n            <xlr-delivery-list\n                 deliveries=\"$ctrl.deliveries\"\n                 deliveries-loading-status=\"$ctrl.loading\"\n                 deliveries-has-more=\"$ctrl.hasMoreDeliveries\"\n                 on-refresh=\"$ctrl.filtersChanged()\"\n                 on-show-more-deliveries=\"$ctrl.loadMoreDeliveries()\">\n            </xlr-delivery-list>\n        </div>\n    </content>\n</folder-details>\n");
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-folder/folder-deliveries-list.less
var folder_deliveries_list = __webpack_require__(2207);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-folder/folder-deliveries-component.js









function folder_deliveries_component_createSuper(Derived) { var hasNativeReflectConstruct = folder_deliveries_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function folder_deliveries_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }





var folder_deliveries_component_FolderDeliveriesController = /*#__PURE__*/function (_DeliveriesController) {
  inherits_default()(FolderDeliveriesController, _DeliveriesController);

  var _super = folder_deliveries_component_createSuper(FolderDeliveriesController);

  function FolderDeliveriesController(ClientSettings) {
    var _this;

    classCallCheck_default()(this, FolderDeliveriesController);

    for (var _len = arguments.length, superArguments = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      superArguments[_key - 1] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(superArguments));
    _this._ClientSettings = ClientSettings;
    return _this;
  }

  createClass_default()(FolderDeliveriesController, [{
    key: "filtersChanged",
    value: function filtersChanged() {
      this._ClientSettings.setDeliveryListFilters(this.filters);

      get_default()(getPrototypeOf_default()(FolderDeliveriesController.prototype), "filtersChanged", this).call(this);
    }
  }]);

  return FolderDeliveriesController;
}(deliveries_controller_DeliveriesController);

defineProperty_default()(folder_deliveries_component_FolderDeliveriesController, "$inject", ['ClientSettings'].concat(toConsumableArray_default()(deliveries_controller_DeliveriesController.$inject)));

var FolderDeliveriesComponent = {
  bindings: {
    folder: '<',
    filters: '<'
  },
  controller: folder_deliveries_component_FolderDeliveriesController,
  template: folder_deliveries
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-folder/index.js

angular.module('xlrelease.deliveries').component('folderDeliveriesList', FolderDeliveriesComponent);
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/index.less
var delivery_patterns = __webpack_require__(2208);

// EXTERNAL MODULE: ./modules/xlr-activity-logs-module/src/main/resources/web/include/ActivityLogs/activity-logs-list/activity-logs-list-controller.js
var activity_logs_list_controller = __webpack_require__(558);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-list-header.component.js







function delivery_pattern_list_header_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_list_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_list_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var delivery_pattern_list_header_component_filterOptions = {
  placeholder: 'Filter by name...'
};

var delivery_pattern_list_header_component_DeliveryPatternListHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternListHeaderComponent, _Component);

  var _super = delivery_pattern_list_header_component_createSuper(DeliveryPatternListHeaderComponent);

  function DeliveryPatternListHeaderComponent(props) {
    classCallCheck_default()(this, DeliveryPatternListHeaderComponent);

    return _super.call(this, props);
  }

  createClass_default()(DeliveryPatternListHeaderComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props = this.props,
          filter = _this$props.filter,
          onFilterChange = _this$props.onFilterChange;
      onFilterChange(filter);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          filter = _this$props2.filter,
          isCreateAllowed = _this$props2.isCreateAllowed,
          onCreateDeliveryPattern = _this$props2.onCreateDeliveryPattern,
          onFilterChange = _this$props2.onFilterChange;
      return /*#__PURE__*/react_default.a.createElement(react["Fragment"], null, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetFilter"], {
        metadata: delivery_pattern_list_header_component_filterOptions,
        model: filter,
        onUpdate: onFilterChange,
        style: {
          marginBottom: '0'
        }
      }), isCreateAllowed && /*#__PURE__*/react_default.a.createElement("div", {
        className: "buttons"
      }, /*#__PURE__*/react_default.a.createElement("button", {
        className: "button primary new-delivery-pattern",
        onClick: onCreateDeliveryPattern
      }, "New delivery pattern"), /*#__PURE__*/react_default.a.createElement(components["d" /* DocLink */], {
        section: "delivery-patterns.html"
      })));
    }
  }]);

  return DeliveryPatternListHeaderComponent;
}(react["Component"]);

defineProperty_default()(delivery_pattern_list_header_component_DeliveryPatternListHeaderComponent, "propTypes", {
  filter: prop_types_default.a.string.isRequired,
  isCreateAllowed: prop_types_default.a.bool.isRequired,
  onCreateDeliveryPattern: prop_types_default.a.func,
  onFilterChange: prop_types_default.a.func.isRequired
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/delivery-pattern.actions.js
var delivery_pattern_actions_actionTypes = {
  DELIVERY_PATTERN_CREATE_FORM: "DELIVERY_PATTERN/CREATE_FORM",
  DELIVERY_PATTERN_CREATE_DELIVERY_FORM: "DELIVERY_PATTERN/CREATE_DELIVERY_FORM",
  DELIVERY_PATTERN_LIST_SUCCEEDED: 'DELIVERY_PATTERN/LIST_SUCCEEDED',
  DELIVERY_PATTERN_CREATE_CANCEL_REQUESTED: 'DELIVERY_PATTERN/CREATE_CANCEL_REQUESTED',
  DELIVERY_PATTERN_CREATE_CANCEL_SUCCEEDED: 'DELIVERY_PATTERN/CREATE_CANCEL_SUCCEEDED',
  DELIVERY_PATTERN_PRISTINE: 'DELIVERY_PATTERN/PRISTINE',
  DELIVERY_PATTERN_VALID: 'DELIVERY_PATTERN/VALID',
  DELIVERY_PATTERN_MODEL_CHANGE: 'DELIVERY_PATTERN/MODEL_CHANGE',
  DELIVERY_PATTERN_CREATE_REQUESTED: 'DELIVERY_PATTERN/CREATE_REQUESTED',
  DELIVERY_PATTERN_CREATE_SUCCEEDED: 'DELIVERY_PATTERN/CREATE_SUCCEEDED',
  DELIVERY_PATTERN_UPDATE_REQUESTED: 'DELIVERY_PATTERN/UPDATE_REQUESTED',
  DELIVERY_PATTERN_UPDATE_SUCCEEDED: 'DELIVERY_PATTERN/UPDATE_SUCCEEDED',
  DELIVERY_PATTERN_DELETE_REQUESTED: 'DELIVERY_PATTERN/DELETE_REQUESTED',
  DELIVERY_PATTERN_DELETE_SUCCEEDED: 'DELIVERY_PATTERN/DELETE_SUCCEEDED',
  DELIVERY_PATTERN_FILTER_CHANGE_REQUESTED: 'DELIVERY_PATTERN/FILTER_CHANGE_REQUESTED',
  DELIVERY_PATTERN_LIST_FAILED: 'DELIVERY_PATTERN/LIST_FAILED',
  DELIVERY_PATTERN_GO_TO_DETAILS: 'DELIVERY_PATTERN/DETAILS',
  DELIVERY_PATTERN_GO_TO_CREATE_DELIVERY: 'DELIVERY_PATTERN/GO_TO_CREATE_DELIVERY',
  DELIVERY_PATTERN_LOAD_REQUESTED: 'DELIVERY_PATTERN/LOAD_REQUESTED',
  DELIVERY_PATTERN_LOAD_SUCCEEDED: 'DELIVERY_PATTERN/LOAD_SUCCEEDED',
  DELIVERY_PATTERN_RESET_REQUESTED: 'DELIVERY_PATTERN/RESET_REQUESTED',
  DELIVERY_PATTERN_COPY_REQUESTED: 'DELIVERY_PATTERN/COPY_REQUESTED',
  DELIVERY_PATTERN_GET_ALL_REQUESTED: 'DELIVERY_PATTERN/GET_ALL_REQUESTED',
  DELIVERY_PATTERN_GET_ALL_SUCCEEDED: 'DELIVERY_PATTERN/GET_ALL_SUCCEEDED',
  DELIVERY_PATTERN_VALIDATE_TITLE_REQUESTED: 'DELIVERY_PATTERN/VALIDATE_TITLE_REQUESTED',
  DELIVERY_PATTERN_VALIDATE_TITLE_SUCCEEDED: 'DELIVERY_PATTERN/VALIDATE_TITLE_SUCCEEDED'
};
var deliveryPatternForm = function deliveryPatternForm() {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_FORM
  };
};
var createDeliveryForm = function createDeliveryForm() {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_DELIVERY_FORM
  };
};
var listLoaded = function listLoaded(list) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_LIST_SUCCEEDED,
    payload: list
  };
};
var listFailed = function listFailed() {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_LIST_FAILED
  };
};
var cancelCreate = function cancelCreate() {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_CANCEL_REQUESTED
  };
};
var createCancelled = function createCancelled() {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_CANCEL_SUCCEEDED
  };
};
var delivery_pattern_actions_changeValidation = function changeValidation(valid) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_VALID,
    payload: valid
  };
};
var delivery_pattern_actions_changeModel = function changeModel(model) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_MODEL_CHANGE,
    payload: model
  };
};
var delivery_pattern_actions_createDeliveryPattern = function createDeliveryPattern() {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_REQUESTED
  };
};
var deliveryPatternCreated = function deliveryPatternCreated(deliveryPattern) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_SUCCEEDED,
    payload: deliveryPattern
  };
};
var delivery_pattern_actions_deleteDeliveryPattern = function deleteDeliveryPattern(id) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_DELETE_REQUESTED,
    payload: id
  };
};
var deliveryPatternDeleted = function deliveryPatternDeleted(id) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_DELETE_SUCCEEDED,
    payload: id
  };
};
var changeDeliveryPatternFilter = function changeDeliveryPatternFilter(filter) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_FILTER_CHANGE_REQUESTED,
    payload: filter
  };
};
var delivery_pattern_actions_goToDetails = function goToDetails(id) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_GO_TO_DETAILS,
    payload: id
  };
};
var goToCreateDelivery = function goToCreateDelivery(id) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_GO_TO_CREATE_DELIVERY,
    payload: id
  };
};
var deliveryLoaded = function deliveryLoaded(deliveryPattern) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_LOAD_SUCCEEDED,
    payload: deliveryPattern
  };
};
var delivery_pattern_actions_updateDeliveryPattern = function updateDeliveryPattern() {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_UPDATE_REQUESTED
  };
};
var deliveryPatternUpdated = function deliveryPatternUpdated(deliveryPattern) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_UPDATE_SUCCEEDED,
    payload: deliveryPattern
  };
};
var resetDeliveryPattern = function resetDeliveryPattern() {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_RESET_REQUESTED
  };
};
var delivery_pattern_actions_copyDeliveryPattern = function copyDeliveryPattern(deliveryPattern) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_COPY_REQUESTED,
    payload: deliveryPattern
  };
};
var delivery_pattern_actions_changePristine = function changePristine(pristine) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_PRISTINE,
    payload: pristine
  };
};
var allPatternsLoaded = function allPatternsLoaded(defs) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_GET_ALL_SUCCEEDED,
    payload: defs
  };
};
var delivery_pattern_actions_validateTitle = function validateTitle(id, title) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_VALIDATE_TITLE_REQUESTED,
    payload: {
      id: id,
      title: title
    }
  };
};
var titleValidated = function titleValidated(valid) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_VALIDATE_TITLE_SUCCEEDED,
    payload: valid
  };
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-list-header.container.js




var delivery_pattern_list_header_container_mapStateToProps = function mapStateToProps(state) {
  return {
    filter: state.deliveryPatterns.filter
  };
};

var delivery_pattern_list_header_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    onCreateDeliveryPattern: function onCreateDeliveryPattern() {
      return dispatch(deliveryPatternForm());
    },
    onFilterChange: function onFilterChange(title) {
      return dispatch(changeDeliveryPatternFilter(title));
    }
  };
};

/* harmony default export */ var delivery_pattern_list_header_container = (Object(es["connect"])(delivery_pattern_list_header_container_mapStateToProps, delivery_pattern_list_header_container_mapDispatchToProps)(delivery_pattern_list_header_component_DeliveryPatternListHeaderComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/delivery-pattern.reducer.js


function delivery_pattern_reducer_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function delivery_pattern_reducer_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_pattern_reducer_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_pattern_reducer_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }




var delivery_pattern_reducer_initialState = function initialState() {
  return {
    list: [],
    form: {
      model: {
        plannedDuration: 0,
        id: null,
        title: '',
        description: '',
        folderId: null
      },
      lastSaved: null,
      pristine: true,
      valid: false,
      isTitleValid: true,
      editable: true,
      all: []
    },
    loading: false,
    filter: "",
    canEdit: false
  };
};

var delivery_pattern_reducer_deliveryPatterns = function deliveryPatterns() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : delivery_pattern_reducer_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_FORM:
      return delivery_pattern_reducer_objectSpread({}, state, {
        form: {
          model: {
            plannedDuration: 0,
            id: null,
            title: '',
            description: ''
          },
          editable: true,
          pristine: true,
          isTitleValid: true,
          valid: false
        }
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_LIST_SUCCEEDED:
      var list = action.payload;
      return delivery_pattern_reducer_objectSpread({}, state, {
        list: list,
        loading: false
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_VALID:
      return delivery_pattern_reducer_objectSpread({}, state, {
        form: delivery_pattern_reducer_objectSpread({}, state.form, {
          valid: action.payload
        })
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_VALIDATE_TITLE_SUCCEEDED:
      return delivery_pattern_reducer_objectSpread({}, state, {
        form: delivery_pattern_reducer_objectSpread({}, state.form, {
          valid: state.form.valid && action.payload,
          isTitleValid: action.payload
        })
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_MODEL_CHANGE:
      return delivery_pattern_reducer_objectSpread({}, state, {
        form: delivery_pattern_reducer_objectSpread({}, state.form, {
          model: action.payload,
          pristine: false
        })
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_SUCCEEDED:
    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_CANCEL_SUCCEEDED:
      return delivery_pattern_reducer_objectSpread({}, state);

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_DELETE_SUCCEEDED:
      return delivery_pattern_reducer_objectSpread({}, state, {
        list: state.list.filter(function (item) {
          return item.id !== action.payload;
        })
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_FILTER_CHANGE_REQUESTED:
      return delivery_pattern_reducer_objectSpread({}, state, {
        filter: action.payload,
        loading: true
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_LIST_FAILED:
      return delivery_pattern_reducer_objectSpread({}, state, {
        loading: false
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_LOAD_SUCCEEDED:
      var _action$payload = action.payload,
          description = _action$payload.description,
          plannedDuration = _action$payload.plannedDuration,
          folderId = _action$payload.folderId,
          id = _action$payload.id,
          isEditable = _action$payload.isEditable,
          title = _action$payload.title;
      return delivery_pattern_reducer_objectSpread({}, state, {
        form: delivery_pattern_reducer_objectSpread({}, state.form, {
          model: {
            plannedDuration: plannedDuration,
            id: id,
            title: title,
            description: description,
            folderId: folderId
          },
          editable: isEditable,
          pristine: true
        })
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_PRISTINE:
      return delivery_pattern_reducer_objectSpread({}, state, {
        form: delivery_pattern_reducer_objectSpread({}, state.form, {
          pristine: action.payload
        })
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_GET_ALL_SUCCEEDED:
      return delivery_pattern_reducer_objectSpread({}, state, {
        form: delivery_pattern_reducer_objectSpread({}, state.form, {
          all: action.payload
        })
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_UPDATE_SUCCEEDED:
      return delivery_pattern_reducer_objectSpread({}, state, {
        form: delivery_pattern_reducer_objectSpread({}, state.form, {
          lastSaved: moment_js_exposed_default()().format('MMMM DD, YYYY h:mm:ss A'),
          pristine: true
        })
      });

    default:
      return state;
  }
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/tracked-item.actions.js
// -- ACTIONS --
var tracked_item_actions_actionTypes = {
  TRACKED_ITEM_CREATE_OR_UPDATE: "TRACKED_ITEM/CREATE_OR_UPDATE",
  TRACKED_ITEM_ADDED: "TRACKED_ITEM/ADDED",
  TRACKED_ITEM_UPDATED: "TRACKED_ITEM/UPDATED",
  TRACKED_ITEM_REMOVE: "TRACKED_ITEM/REMOVE",
  TRACKED_ITEM_REMOVED: "TRACKED_ITEM/REMOVED",
  TRACKED_ITEM_FETCH_LIST: "TRACKED_ITEM/FETCH_LIST",
  TRACKED_ITEM_SET_LIST: "TRACKED_ITEM/SET_LIST",
  TRACKED_ITEM_FILTER_CHANGED: "TRACKED_ITEM/FILTER_CHANGED"
};
var tracked_item_actions_createOrUpdateTrackedItem = function createOrUpdateTrackedItem(trackedItem, deliveryId) {
  return {
    type: tracked_item_actions_actionTypes.TRACKED_ITEM_CREATE_OR_UPDATE,
    payload: {
      trackedItem: trackedItem,
      deliveryId: deliveryId
    }
  };
};
var addedTrackedItem = function addedTrackedItem(trackedItem) {
  return {
    type: tracked_item_actions_actionTypes.TRACKED_ITEM_ADDED,
    payload: trackedItem
  };
};
var updatedTrackedItem = function updatedTrackedItem(trackedItem) {
  return {
    type: tracked_item_actions_actionTypes.TRACKED_ITEM_UPDATED,
    payload: trackedItem
  };
};
var tracked_item_actions_removeTrackedItem = function removeTrackedItem(id) {
  return {
    type: tracked_item_actions_actionTypes.TRACKED_ITEM_REMOVE,
    payload: id
  };
};
var tracked_item_actions_removedTrackedItem = function removedTrackedItem(id) {
  return {
    type: tracked_item_actions_actionTypes.TRACKED_ITEM_REMOVED,
    payload: id
  };
};
var fetchTrackedItems = function fetchTrackedItems(deliveryId) {
  return {
    type: tracked_item_actions_actionTypes.TRACKED_ITEM_FETCH_LIST,
    payload: deliveryId
  };
};
var setList = function setList(list) {
  return {
    type: tracked_item_actions_actionTypes.TRACKED_ITEM_SET_LIST,
    payload: list
  };
};
var changeFilter = function changeFilter(filter) {
  return {
    type: tracked_item_actions_actionTypes.TRACKED_ITEM_FILTER_CHANGED,
    payload: filter
  };
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/tracked-item.reducer.js



function tracked_item_reducer_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function tracked_item_reducer_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { tracked_item_reducer_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { tracked_item_reducer_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var tracked_item_reducer_initialState = function initialState() {
  return {
    list: [],
    filter: ''
  };
};

var tracked_item_reducer_trackedItems = function trackedItems() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : tracked_item_reducer_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case tracked_item_actions_actionTypes.TRACKED_ITEM_SET_LIST:
      {
        return tracked_item_reducer_objectSpread({}, state, {
          list: action.payload
        });
      }

    case tracked_item_actions_actionTypes.TRACKED_ITEM_ADDED:
      {
        var list = state.list;
        return tracked_item_reducer_objectSpread({}, state, {
          list: list.concat([action.payload])
        });
      }

    case tracked_item_actions_actionTypes.TRACKED_ITEM_UPDATED:
      {
        var _list = state.list;
        var _action$payload = action.payload,
            id = _action$payload.id,
            title = _action$payload.title;
        _list.find(function (item) {
          return item.id === id;
        }).title = title;
        return tracked_item_reducer_objectSpread({}, state, {
          list: toConsumableArray_default()(_list)
        });
      }

    case tracked_item_actions_actionTypes.TRACKED_ITEM_REMOVED:
      {
        var _list2 = state.list;
        return tracked_item_reducer_objectSpread({}, state, {
          list: _list2.filter(function (item) {
            return item.id !== action.payload;
          })
        });
      }

    case tracked_item_actions_actionTypes.TRACKED_ITEM_FILTER_CHANGED:
      {
        var filter = action.payload;
        return tracked_item_reducer_objectSpread({}, state, {
          filter: filter
        });
      }

    default:
      return state;
  }
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/delivery-pattern.sagas.js



function delivery_pattern_sagas_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function delivery_pattern_sagas_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_pattern_sagas_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_pattern_sagas_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var delivery_pattern_sagas_marked = /*#__PURE__*/regenerator_default.a.mark(delivery_pattern_sagas_updateBreadcrumbs),
    delivery_pattern_sagas_marked2 = /*#__PURE__*/regenerator_default.a.mark(loadDeliveryPattern),
    delivery_pattern_sagas_marked3 = /*#__PURE__*/regenerator_default.a.mark(flowView),
    delivery_pattern_sagas_marked4 = /*#__PURE__*/regenerator_default.a.mark(delivery_pattern_sagas_goToCreateDelivery),
    delivery_pattern_sagas_marked5 = /*#__PURE__*/regenerator_default.a.mark(delivery_pattern_sagas_cancelCreate),
    delivery_pattern_sagas_marked6 = /*#__PURE__*/regenerator_default.a.mark(delivery_pattern_sagas_searchDeliveryPatterns),
    delivery_pattern_sagas_marked7 = /*#__PURE__*/regenerator_default.a.mark(delivery_pattern_sagas_createDeliveryPattern),
    delivery_pattern_sagas_marked8 = /*#__PURE__*/regenerator_default.a.mark(delivery_pattern_sagas_updateDeliveryPattern),
    delivery_pattern_sagas_marked9 = /*#__PURE__*/regenerator_default.a.mark(removeDeliveryPattern),
    delivery_pattern_sagas_marked10 = /*#__PURE__*/regenerator_default.a.mark(delivery_pattern_sagas_resetDeliveryPattern),
    delivery_pattern_sagas_marked11 = /*#__PURE__*/regenerator_default.a.mark(duplicateDeliveryPattern),
    delivery_pattern_sagas_marked12 = /*#__PURE__*/regenerator_default.a.mark(setupConfirmLeavePopup),
    delivery_pattern_sagas_marked13 = /*#__PURE__*/regenerator_default.a.mark(getAllPatterns),
    delivery_pattern_sagas_marked14 = /*#__PURE__*/regenerator_default.a.mark(validatePatternTitle),
    delivery_pattern_sagas_marked15 = /*#__PURE__*/regenerator_default.a.mark(delivery_pattern_sagas_combinedSaga);








function delivery_pattern_sagas_isEditable(def) {
  var authenticator = Object(angular_accessor["b" /* default */])('Authenticator');
  return authenticator.hasPermission(DELIVERY_PATTERN_EDIT_PERMISSION, def.$metadata);
}

function delivery_pattern_sagas_canCreateDelivery(def) {
  var authenticator = Object(angular_accessor["b" /* default */])('Authenticator');
  return authenticator.hasPermission(DELIVERY_EDIT_PERMISSION, def.$metadata);
}

function delivery_pattern_sagas_isCreateDeliveryDisabled(def) {
  return def.stages.length === 0;
}

function listView() {
  var param = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  var $location = Object(angular_accessor["b" /* default */])('$location');
  var $stateParams = Object(angular_accessor["b" /* default */])('$stateParams');
  var $rootScope = Object(angular_accessor["b" /* default */])('$rootScope');
  $location.url("/folders/".concat($stateParams.folderId, "/delivery-patterns?").concat(param));
  $rootScope.$digest();
}

function delivery_pattern_sagas_deliveryPatternForm() {
  listView('action=create');
}

function delivery_pattern_sagas_createDeliveryForm() {
  var $state = Object(angular_accessor["b" /* default */])('$state');
  var Ids = Object(angular_accessor["b" /* default */])('Ids');
  var $stateParams = Object(angular_accessor["b" /* default */])('$stateParams');
  $state.go('deliveryCreate', {
    fromPatternId: Ids.toInternalId($stateParams.deliveryId)
  });
}

function delivery_pattern_sagas_updateBreadcrumbs(checkUrl, deliveryPattern) {
  var page;
  return regenerator_default.a.wrap(function updateBreadcrumbs$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], 'Page');

        case 2:
          page = _context.sent;

          if (page.isOnPage(checkUrl)) {
            page.setFolderEntityOpened(deliveryPattern.folderId, deliveryPattern);
          }

        case 4:
        case "end":
          return _context.stop();
      }
    }
  }, delivery_pattern_sagas_marked);
}

function loadDeliveryPattern(action) {
  var resp;
  return regenerator_default.a.wrap(function loadDeliveryPattern$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _context2.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(delivery_pattern_service_fetchDeliveryPattern, action.payload);

        case 3:
          resp = _context2.sent;
          _context2.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 6:
          _context2.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(deliveryLoaded(delivery_pattern_sagas_objectSpread({}, resp, {
            isEditable: delivery_pattern_sagas_isEditable(resp),
            canCreateDelivery: delivery_pattern_sagas_canCreateDelivery(resp)
          })));

        case 8:
          _context2.next = 13;
          break;

        case 10:
          _context2.prev = 10;
          _context2.t0 = _context2["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Error while loading delivery pattern...', _context2.t0);
          /* eslint-enable */

        case 13:
        case "end":
          return _context2.stop();
      }
    }
  }, delivery_pattern_sagas_marked2, null, [[0, 10]]);
}

function flowView(action) {
  return regenerator_default.a.wrap(function flowView$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          location.href = "#/delivery-patterns/".concat(action.payload);

        case 1:
        case "end":
          return _context3.stop();
      }
    }
  }, delivery_pattern_sagas_marked3);
}

function delivery_pattern_sagas_goToCreateDelivery(action) {
  var $state, $rootScope, idsFactory, fromPatternId;
  return regenerator_default.a.wrap(function goToCreateDelivery$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          $state = Object(angular_accessor["b" /* default */])('$state');
          $rootScope = Object(angular_accessor["b" /* default */])('$rootScope');
          idsFactory = Object(angular_accessor["b" /* default */])('Ids');
          fromPatternId = idsFactory.toInternalId(action.payload);
          $state.go('deliveryCreate', {
            fromPatternId: fromPatternId
          });
          $rootScope.$digest();

        case 6:
        case "end":
          return _context4.stop();
      }
    }
  }, delivery_pattern_sagas_marked4);
}

function delivery_pattern_sagas_cancelCreate() {
  var $window;
  return regenerator_default.a.wrap(function cancelCreate$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _context5.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 2:
          $window = Object(angular_accessor["b" /* default */])('$window');
          $window.history.back();
          _context5.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(createCancelled());

        case 6:
        case "end":
          return _context5.stop();
      }
    }
  }, delivery_pattern_sagas_marked5);
}

function delivery_pattern_sagas_searchDeliveryPatterns() {
  var folderId, filter, list;
  return regenerator_default.a.wrap(function searchDeliveryPatterns$(_context6) {
    while (1) {
      switch (_context6.prev = _context6.next) {
        case 0:
          _context6.prev = 0;
          folderId = Object(angular_accessor["b" /* default */])('$stateParams').folderId;
          _context6.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(function (state) {
            return state.deliveryPatterns.filter;
          });

        case 4:
          filter = _context6.sent;
          _context6.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(searchDeliveryPatterns, {
            title: filter,
            folderId: folderId
          });

        case 7:
          list = _context6.sent;
          _context6.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(listLoaded(list.map(function (d) {
            return {
              id: d.id,
              title: d.title,
              description: d.description,
              isEditable: delivery_pattern_sagas_isEditable(d),
              canCreateDelivery: delivery_pattern_sagas_canCreateDelivery(d),
              isCreateDeliveryDisabled: delivery_pattern_sagas_isCreateDeliveryDisabled(d)
            };
          })));

        case 10:
          _context6.next = 16;
          break;

        case 12:
          _context6.prev = 12;
          _context6.t0 = _context6["catch"](0);
          _context6.next = 16;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(listFailed());

        case 16:
        case "end":
          return _context6.stop();
      }
    }
  }, delivery_pattern_sagas_marked6, null, [[0, 12]]);
}

function delivery_pattern_sagas_createDeliveryPattern() {
  var def, created;
  return regenerator_default.a.wrap(function createDeliveryPattern$(_context7) {
    while (1) {
      switch (_context7.prev = _context7.next) {
        case 0:
          _context7.prev = 0;
          _context7.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(function (state) {
            return state.deliveryPatterns.form.model;
          });

        case 3:
          def = _context7.sent;
          def.folderId = Object(angular_accessor["b" /* default */])('$stateParams').folderId;
          _context7.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(createDeliveryPattern, def);

        case 7:
          created = _context7.sent;
          _context7.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(deliveryPatternCreated(created));

        case 10:
          _context7.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(delivery_pattern_actions_goToDetails(created.id));

        case 12:
          _context7.next = 17;
          break;

        case 14:
          _context7.prev = 14;
          _context7.t0 = _context7["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Error while creating delivery pattern...', _context7.t0);
          /* eslint-enable */

        case 17:
        case "end":
          return _context7.stop();
      }
    }
  }, delivery_pattern_sagas_marked7, null, [[0, 14]]);
}

function delivery_pattern_sagas_updateDeliveryPattern() {
  var $location, urlBeforeUpdate, def, updated;
  return regenerator_default.a.wrap(function updateDeliveryPattern$(_context8) {
    while (1) {
      switch (_context8.prev = _context8.next) {
        case 0:
          _context8.prev = 0;
          _context8.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$location');

        case 3:
          $location = _context8.sent;
          urlBeforeUpdate = $location.path();
          _context8.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(function (state) {
            return state.deliveryPatterns.form.model;
          });

        case 7:
          def = _context8.sent;
          _context8.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(updateDeliveryPattern, def);

        case 10:
          updated = _context8.sent;
          _context8.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(delivery_pattern_sagas_updateBreadcrumbs, urlBeforeUpdate, updated);

        case 13:
          _context8.next = 15;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 15:
          _context8.next = 17;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(getAllPatterns);

        case 17:
          _context8.next = 19;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(deliveryPatternUpdated(updated));

        case 19:
          _context8.next = 24;
          break;

        case 21:
          _context8.prev = 21;
          _context8.t0 = _context8["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Error while updating delivery pattern...', _context8.t0);
          /* eslint-enable */

        case 24:
        case "end":
          return _context8.stop();
      }
    }
  }, delivery_pattern_sagas_marked8, null, [[0, 21]]);
}

function removeDeliveryPattern(action) {
  return regenerator_default.a.wrap(function removeDeliveryPattern$(_context9) {
    while (1) {
      switch (_context9.prev = _context9.next) {
        case 0:
          _context9.prev = 0;
          _context9.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(delivery_pattern_service_deleteDeliveryPattern, action.payload);

        case 3:
          _context9.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(deliveryPatternDeleted(action.payload));

        case 5:
          _context9.next = 10;
          break;

        case 7:
          _context9.prev = 7;
          _context9.t0 = _context9["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Error while removing delivery pattern...', _context9.t0);
          /* eslint-enable */

        case 10:
        case "end":
          return _context9.stop();
      }
    }
  }, delivery_pattern_sagas_marked9, null, [[0, 7]]);
}

function delivery_pattern_sagas_resetDeliveryPattern() {
  var deliveryId, orig;
  return regenerator_default.a.wrap(function resetDeliveryPattern$(_context10) {
    while (1) {
      switch (_context10.prev = _context10.next) {
        case 0:
          _context10.prev = 0;
          _context10.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(delivery_pattern_actions_changePristine(true));

        case 3:
          _context10.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(function (state) {
            return state.deliveryPatterns.form.model.id;
          });

        case 5:
          deliveryId = _context10.sent;
          _context10.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(delivery_pattern_service_fetchDeliveryPattern, deliveryId);

        case 8:
          orig = _context10.sent;
          _context10.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 11:
          _context10.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(deliveryLoaded(delivery_pattern_sagas_objectSpread({}, orig, {
            isEditable: delivery_pattern_sagas_isEditable(orig),
            canCreateDelivery: delivery_pattern_sagas_canCreateDelivery(orig)
          })));

        case 13:
          _context10.next = 18;
          break;

        case 15:
          _context10.prev = 15;
          _context10.t0 = _context10["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Error while resetting delivery pattern...', _context10.t0);
          /* eslint-enable */

        case 18:
        case "end":
          return _context10.stop();
      }
    }
  }, delivery_pattern_sagas_marked10, null, [[0, 15]]);
}

function duplicateDeliveryPattern(action) {
  var copied;
  return regenerator_default.a.wrap(function duplicateDeliveryPattern$(_context11) {
    while (1) {
      switch (_context11.prev = _context11.next) {
        case 0:
          _context11.prev = 0;
          _context11.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(copyDeliveryPattern, action.payload);

        case 3:
          copied = _context11.sent;
          _context11.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(delivery_pattern_actions_goToDetails(copied.id));

        case 6:
          _context11.next = 11;
          break;

        case 8:
          _context11.prev = 8;
          _context11.t0 = _context11["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Error while duplicating delivery pattern...', _context11.t0);
          /* eslint-enable */

        case 11:
        case "end":
          return _context11.stop();
      }
    }
  }, delivery_pattern_sagas_marked11, null, [[0, 8]]);
}

function setupConfirmLeavePopup(action) {
  return regenerator_default.a.wrap(function setupConfirmLeavePopup$(_context12) {
    while (1) {
      switch (_context12.prev = _context12.next) {
        case 0:
          if (action.payload) {
            _context12.next = 5;
            break;
          }

          _context12.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["a" /* addConfirmLeavePopup */]);

        case 3:
          _context12.next = 7;
          break;

        case 5:
          _context12.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 7:
        case "end":
          return _context12.stop();
      }
    }
  }, delivery_pattern_sagas_marked12);
}

function getAllPatterns() {
  var _all;

  return regenerator_default.a.wrap(function getAllPatterns$(_context13) {
    while (1) {
      switch (_context13.prev = _context13.next) {
        case 0:
          _context13.prev = 0;
          _context13.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(searchDeliveryPatterns);

        case 3:
          _all = _context13.sent;
          _context13.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(allPatternsLoaded(_all));

        case 6:
          _context13.next = 11;
          break;

        case 8:
          _context13.prev = 8;
          _context13.t0 = _context13["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Error loading all patterns...', _context13.t0);
          /* eslint-enable */

        case 11:
        case "end":
          return _context13.stop();
      }
    }
  }, delivery_pattern_sagas_marked13, null, [[0, 8]]);
}

function validatePatternTitle(action) {
  var _action$payload, id, title, valid;

  return regenerator_default.a.wrap(function validatePatternTitle$(_context14) {
    while (1) {
      switch (_context14.prev = _context14.next) {
        case 0:
          _context14.prev = 0;
          _context14.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["e" /* delay */])(1000);

        case 3:
          _action$payload = action.payload, id = _action$payload.id, title = _action$payload.title;
          _context14.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(checkTitle, id, title);

        case 6:
          valid = _context14.sent;
          _context14.next = 9;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(titleValidated(valid));

        case 9:
          _context14.next = 14;
          break;

        case 11:
          _context14.prev = 11;
          _context14.t0 = _context14["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Error validating pattern title...', _context14.t0);
          /* eslint-enable */

        case 14:
        case "end":
          return _context14.stop();
      }
    }
  }, delivery_pattern_sagas_marked14, null, [[0, 11]]);
}

function delivery_pattern_sagas_combinedSaga() {
  return regenerator_default.a.wrap(function combinedSaga$(_context15) {
    while (1) {
      switch (_context15.prev = _context15.next) {
        case 0:
          _context15.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_FORM, delivery_pattern_sagas_deliveryPatternForm), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_DELIVERY_FORM, delivery_pattern_sagas_createDeliveryForm), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_CANCEL_REQUESTED, delivery_pattern_sagas_cancelCreate), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_REQUESTED, delivery_pattern_sagas_createDeliveryPattern), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_DELETE_REQUESTED, removeDeliveryPattern), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_FILTER_CHANGE_REQUESTED, delivery_pattern_sagas_searchDeliveryPatterns), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_LOAD_REQUESTED, loadDeliveryPattern), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_GO_TO_DETAILS, flowView), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_GO_TO_CREATE_DELIVERY, delivery_pattern_sagas_goToCreateDelivery), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_UPDATE_REQUESTED, delivery_pattern_sagas_updateDeliveryPattern), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_RESET_REQUESTED, delivery_pattern_sagas_resetDeliveryPattern), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_COPY_REQUESTED, duplicateDeliveryPattern), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_PRISTINE, setupConfirmLeavePopup), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_GET_ALL_REQUESTED, getAllPatterns), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_VALIDATE_TITLE_REQUESTED, validatePatternTitle)]);

        case 2:
        case "end":
          return _context15.stop();
      }
    }
  }, delivery_pattern_sagas_marked15);
}
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/tracked-item.service.js


function tracked_item_service_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function tracked_item_service_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { tracked_item_service_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { tracked_item_service_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }


var tracked_item_service_API_URL = 'api/v1/delivery-patterns';
function tracked_item_service_createItem(deliveryId, item) {
  return Object(http["d" /* httpPOST */])("".concat(tracked_item_service_API_URL, "/").concat(deliveryId, "/tracked-items"), tracked_item_service_objectSpread({}, item, {
    id: null,
    type: 'delivery.TrackedItem'
  })).then(function (res) {
    return res.data;
  });
}
function tracked_item_service_updateItem(item) {
  return Object(http["e" /* httpPUT */])("".concat(tracked_item_service_API_URL, "/").concat(item.id), item).then(function (res) {
    return res.data;
  });
}
function tracked_item_service_removeItem(itemId) {
  return Object(http["b" /* httpDELETE */])("".concat(tracked_item_service_API_URL, "/").concat(itemId)).then(function (res) {
    return res.data;
  });
}
function tracked_item_service_list(deliveryId) {
  return Object(http["c" /* httpGET */])("".concat(tracked_item_service_API_URL, "/").concat(deliveryId, "/tracked-items")).then(function (res) {
    return res.data;
  });
}
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/tracked-item.sagas.js


var tracked_item_sagas_marked = /*#__PURE__*/regenerator_default.a.mark(tracked_item_sagas_createOrUpdateItem),
    tracked_item_sagas_marked2 = /*#__PURE__*/regenerator_default.a.mark(tracked_item_sagas_removeItem),
    tracked_item_sagas_marked3 = /*#__PURE__*/regenerator_default.a.mark(tracked_item_sagas_list),
    tracked_item_sagas_marked4 = /*#__PURE__*/regenerator_default.a.mark(trackedItemSagas);



 // -- SAGAS --

function tracked_item_sagas_createOrUpdateItem(action) {
  var _action$payload, trackedItem, deliveryId, updated, created;

  return regenerator_default.a.wrap(function createOrUpdateItem$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _action$payload = action.payload, trackedItem = _action$payload.trackedItem, deliveryId = _action$payload.deliveryId;

          if (!trackedItem.id) {
            _context.next = 10;
            break;
          }

          _context.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(tracked_item_service_updateItem, trackedItem);

        case 5:
          updated = _context.sent;
          _context.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(updatedTrackedItem(updated));

        case 8:
          _context.next = 15;
          break;

        case 10:
          _context.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(tracked_item_service_createItem, deliveryId, trackedItem);

        case 12:
          created = _context.sent;
          _context.next = 15;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(addedTrackedItem(created));

        case 15:
          _context.next = 20;
          break;

        case 17:
          _context.prev = 17;
          _context.t0 = _context["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error("Something went wrong while creating or updating tracking item...", _context.t0);
          /* eslint-enable */

        case 20:
        case "end":
          return _context.stop();
      }
    }
  }, tracked_item_sagas_marked, null, [[0, 17]]);
}

function tracked_item_sagas_removeItem(action) {
  var id;
  return regenerator_default.a.wrap(function removeItem$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          id = action.payload;
          _context2.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(tracked_item_service_removeItem, id);

        case 4:
          _context2.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(tracked_item_actions_removedTrackedItem(id));

        case 6:
          _context2.next = 11;
          break;

        case 8:
          _context2.prev = 8;
          _context2.t0 = _context2["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error("Something went wrong while removing tracking item...", _context2.t0);
          /* eslint-enable */

        case 11:
        case "end":
          return _context2.stop();
      }
    }
  }, tracked_item_sagas_marked2, null, [[0, 8]]);
}

function tracked_item_sagas_list(action) {
  var deliveryId, trackedItems;
  return regenerator_default.a.wrap(function list$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          deliveryId = action.payload;
          _context3.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(tracked_item_service_list, deliveryId);

        case 3:
          trackedItems = _context3.sent;
          _context3.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(setList(trackedItems));

        case 6:
        case "end":
          return _context3.stop();
      }
    }
  }, tracked_item_sagas_marked3);
}

function trackedItemSagas() {
  return regenerator_default.a.wrap(function trackedItemSagas$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _context4.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(tracked_item_actions_actionTypes.TRACKED_ITEM_CREATE_OR_UPDATE, tracked_item_sagas_createOrUpdateItem), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(tracked_item_actions_actionTypes.TRACKED_ITEM_REMOVE, tracked_item_sagas_removeItem), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(tracked_item_actions_actionTypes.TRACKED_ITEM_FETCH_LIST, tracked_item_sagas_list)]);

        case 2:
        case "end":
          return _context4.stop();
      }
    }
  }, tracked_item_sagas_marked4);
}
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/stage.sagas.js


var stage_sagas_marked = /*#__PURE__*/regenerator_default.a.mark(stage_sagas_list),
    stage_sagas_marked2 = /*#__PURE__*/regenerator_default.a.mark(remove),
    stage_sagas_marked3 = /*#__PURE__*/regenerator_default.a.mark(edit),
    stage_sagas_marked4 = /*#__PURE__*/regenerator_default.a.mark(add),
    stage_sagas_marked5 = /*#__PURE__*/regenerator_default.a.mark(stageSagas);





function stage_sagas_list(action) {
  var stages;
  return regenerator_default.a.wrap(function list$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(fetchStages, action.payload);

        case 2:
          stages = _context.sent;
          _context.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(stagesLoaded(stages));

        case 5:
        case "end":
          return _context.stop();
      }
    }
  }, stage_sagas_marked);
}
function remove(action) {
  var stageId;
  return regenerator_default.a.wrap(function remove$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          stageId = action.payload;
          _context2.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deleteStage, stageId);

        case 3:
          _context2.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(stageDeleted(stageId));

        case 5:
        case "end":
          return _context2.stop();
      }
    }
  }, stage_sagas_marked2);
}
function edit(action) {
  var _action$payload, id, title, updated;

  return regenerator_default.a.wrap(function edit$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          _action$payload = action.payload, id = _action$payload.id, title = _action$payload.title;
          _context3.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(updateStage, id, title);

        case 3:
          updated = _context3.sent;
          _context3.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(stageEdited(updated));

        case 6:
        case "end":
          return _context3.stop();
      }
    }
  }, stage_sagas_marked3);
}
function add() {
  var $stateParams, added;
  return regenerator_default.a.wrap(function add$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _context4.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["a" /* asyncGetAngularService */], '$stateParams');

        case 2:
          $stateParams = _context4.sent;
          _context4.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(addStage, $stateParams.deliveryId);

        case 5:
          added = _context4.sent;
          _context4.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(stageAdded(added));

        case 8:
        case "end":
          return _context4.stop();
      }
    }
  }, stage_sagas_marked4);
}
function stageSagas() {
  return regenerator_default.a.wrap(function stageSagas$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _context5.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(stage_actions_actionTypes.STAGE_LIST_REQUESTED, stage_sagas_list), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(stage_actions_actionTypes.STAGE_DELETE_REQUESTED, remove), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(stage_actions_actionTypes.STAGE_EDIT_REQUESTED, edit), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(stage_actions_actionTypes.STAGE_ADD_REQUESTED, add)]);

        case 2:
        case "end":
          return _context5.stop();
      }
    }
  }, stage_sagas_marked5);
}
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/transition.sagas.js



function transition_sagas_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function transition_sagas_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { transition_sagas_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { transition_sagas_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var transition_sagas_marked = /*#__PURE__*/regenerator_default.a.mark(transition_sagas_add),
    transition_sagas_marked2 = /*#__PURE__*/regenerator_default.a.mark(transition_sagas_edit),
    transition_sagas_marked3 = /*#__PURE__*/regenerator_default.a.mark(transition_sagas_remove),
    transition_sagas_marked4 = /*#__PURE__*/regenerator_default.a.mark(transition_sagas_addCondition),
    transition_sagas_marked5 = /*#__PURE__*/regenerator_default.a.mark(transition_sagas_updateCondition),
    transition_sagas_marked6 = /*#__PURE__*/regenerator_default.a.mark(transition_sagas_deleteCondition),
    transition_sagas_marked7 = /*#__PURE__*/regenerator_default.a.mark(toggleOperator),
    transition_sagas_marked8 = /*#__PURE__*/regenerator_default.a.mark(transitionSagas);







var transition_sagas_getStages = function getStages(state) {
  return state.stages.list;
};
var getOperator = function getOperator(state, transitionId) {
  return state.stages.operators[transitionId];
};
function transition_sagas_add(action) {
  var stageId, added;
  return regenerator_default.a.wrap(function add$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          stageId = action.payload;
          _context.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(addTransition, stageId);

        case 3:
          added = _context.sent;
          _context.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(transitionAdded(added));

        case 6:
        case "end":
          return _context.stop();
      }
    }
  }, transition_sagas_marked);
}
function transition_sagas_edit(action) {
  var _action$payload, id, title, stages, transition, updated;

  return regenerator_default.a.wrap(function edit$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _action$payload = action.payload, id = _action$payload.id, title = _action$payload.title;
          _context2.prev = 1;
          _context2.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(transition_sagas_getStages);

        case 4:
          stages = _context2.sent;
          transition = cloneDeep_default()(stages.find(function (s) {
            return s.transition && s.transition.id === id;
          }).transition);
          transition.title = title;
          _context2.next = 9;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(updateTransition, transition);

        case 9:
          updated = _context2.sent;
          _context2.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(transitionUpdated(updated));

        case 12:
          _context2.next = 17;
          break;

        case 14:
          _context2.prev = 14;
          _context2.t0 = _context2["catch"](1);

          /* eslint-disable no-console, angular/log */
          console.error("Edit transition title: something went wrong while updating transition...", _context2.t0);
          /* eslint-enable */

        case 17:
        case "end":
          return _context2.stop();
      }
    }
  }, transition_sagas_marked2, null, [[1, 14]]);
}
function transition_sagas_remove(action) {
  var id;
  return regenerator_default.a.wrap(function remove$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          id = action.payload;
          _context3.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deleteTransition, id);

        case 3:
          _context3.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(transitionDeleted(id));

        case 5:
        case "end":
          return _context3.stop();
      }
    }
  }, transition_sagas_marked3);
}
function transition_sagas_addCondition(action) {
  var _action$payload2, transitionId, groupId, stages, operator, transition, defaultCondition, innerGroup, rootGroup, _innerGroup, updated;

  return regenerator_default.a.wrap(function addCondition$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _action$payload2 = action.payload, transitionId = _action$payload2.transitionId, groupId = _action$payload2.groupId;
          _context4.prev = 1;
          _context4.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(transition_sagas_getStages);

        case 4:
          stages = _context4.sent;
          _context4.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getOperator, transitionId);

        case 7:
          operator = _context4.sent;
          transition = cloneDeep_default()(stages.find(function (s) {
            return s.transition && s.transition.id === transitionId;
          }).transition);
          defaultCondition = {
            id: null,
            type: conditionTypes.STATE
          };

          if (!groupId) {
            innerGroup = {
              id: null,
              type: conditionTypes.GROUP,
              operator: stage_reducer_inverseOperator(operator),
              conditions: [defaultCondition]
            };

            if (transition.conditions.length > 0) {
              transition.conditions[0].conditions.push(innerGroup);
            } else {
              transition.conditions.push({
                id: null,
                type: conditionTypes.GROUP,
                operator: operator,
                conditions: [innerGroup]
              });
            }
          } else {
            rootGroup = transition.conditions[0];
            _innerGroup = rootGroup.conditions.find(function (group) {
              return group.id === groupId;
            });

            _innerGroup.conditions.push(defaultCondition);
          }

          _context4.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(updateTransition, transition);

        case 13:
          updated = _context4.sent;
          _context4.next = 16;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(transitionUpdated(updated));

        case 16:
          _context4.next = 21;
          break;

        case 18:
          _context4.prev = 18;
          _context4.t0 = _context4["catch"](1);

          /* eslint-disable no-console, angular/log */
          console.error("Add condition: something went wrong while updating transition...", _context4.t0);
          /* eslint-enable */

        case 21:
        case "end":
          return _context4.stop();
      }
    }
  }, transition_sagas_marked4, null, [[1, 18]]);
}
function transition_sagas_updateCondition(action) {
  var _action$payload3, transitionId, conditionId, change, stages, transition, rootGroup, condition, updated;

  return regenerator_default.a.wrap(function updateCondition$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _action$payload3 = action.payload, transitionId = _action$payload3.transitionId, conditionId = _action$payload3.conditionId, change = _action$payload3.change;

          if (!(conditionId && (change.type || change.value))) {
            _context5.next = 21;
            break;
          }

          _context5.prev = 2;
          _context5.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(transition_sagas_getStages);

        case 5:
          stages = _context5.sent;
          transition = cloneDeep_default()(stages.find(function (s) {
            return s.transition && s.transition.id === transitionId;
          }).transition);
          rootGroup = transition.conditions[0];
          condition = rootGroup.conditions.flatMap(function (g) {
            return g.conditions;
          }).find(function (c) {
            return c.id === conditionId;
          });

          if (change.type) {
            Object.keys(condition).forEach(function (key) {
              if (key !== 'id') delete condition[key];
            });
            condition.type = change.type;
          }

          if (change.value) {
            condition.startDateOffset = change.value;
          }

          _context5.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(updateTransition, transition);

        case 13:
          updated = _context5.sent;
          _context5.next = 16;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(transitionUpdated(updated));

        case 16:
          _context5.next = 21;
          break;

        case 18:
          _context5.prev = 18;
          _context5.t0 = _context5["catch"](2);

          /* eslint-disable no-console, angular/log */
          console.error("Update condition: something went wrong while updating transition...", _context5.t0);
          /* eslint-enable */

        case 21:
        case "end":
          return _context5.stop();
      }
    }
  }, transition_sagas_marked5, null, [[2, 18]]);
}
function transition_sagas_deleteCondition(action) {
  var _action$payload4, transitionId, conditionId, stages, transition, rootGroup, updated;

  return regenerator_default.a.wrap(function deleteCondition$(_context6) {
    while (1) {
      switch (_context6.prev = _context6.next) {
        case 0:
          _action$payload4 = action.payload, transitionId = _action$payload4.transitionId, conditionId = _action$payload4.conditionId;
          _context6.prev = 1;
          _context6.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(transition_sagas_getStages);

        case 4:
          stages = _context6.sent;
          transition = cloneDeep_default()(stages.find(function (s) {
            return s.transition && s.transition.id === transitionId;
          }).transition);
          rootGroup = transition.conditions[0];
          rootGroup.conditions = rootGroup.conditions.map(function (group) {
            return transition_sagas_objectSpread({}, group, {
              conditions: group.conditions.filter(function (c) {
                return c.id !== conditionId;
              })
            });
          }).filter(function (group) {
            return group.conditions.length !== 0;
          });
          _context6.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(updateTransition, transition);

        case 10:
          updated = _context6.sent;
          _context6.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(transitionUpdated(updated));

        case 13:
          _context6.next = 18;
          break;

        case 15:
          _context6.prev = 15;
          _context6.t0 = _context6["catch"](1);

          /* eslint-disable no-console, angular/log */
          console.error("Delete condition: something went wrong while updating transition...", _context6.t0);
          /* eslint-enable */

        case 18:
        case "end":
          return _context6.stop();
      }
    }
  }, transition_sagas_marked6, null, [[1, 15]]);
}
function toggleOperator(action) {
  var transitionId, stages, operator, transition, rootGroup, updated;
  return regenerator_default.a.wrap(function toggleOperator$(_context7) {
    while (1) {
      switch (_context7.prev = _context7.next) {
        case 0:
          transitionId = action.payload;

          if (!transitionId) {
            _context7.next = 28;
            break;
          }

          _context7.prev = 2;
          _context7.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(transition_sagas_getStages);

        case 5:
          stages = _context7.sent;
          _context7.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getOperator, transitionId);

        case 8:
          operator = _context7.sent;
          transition = cloneDeep_default()(stages.find(function (s) {
            return s.transition && s.transition.id === transitionId;
          }).transition);

          if (!(transition.conditions.length > 0)) {
            _context7.next = 21;
            break;
          }

          rootGroup = transition.conditions[0];
          rootGroup.operator = stage_reducer_inverseOperator(operator);
          rootGroup.conditions.forEach(function (g) {
            g.operator = operator;
          });
          _context7.next = 16;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(updateTransition, transition);

        case 16:
          updated = _context7.sent;
          _context7.next = 19;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(transitionUpdated(updated));

        case 19:
          _context7.next = 23;
          break;

        case 21:
          _context7.next = 23;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(conditionOperatorToggled(transitionId, operator));

        case 23:
          _context7.next = 28;
          break;

        case 25:
          _context7.prev = 25;
          _context7.t0 = _context7["catch"](2);

          /* eslint-disable no-console, angular/log */
          console.error("Toggle operator: something went wrong while updating transition...", _context7.t0);
          /* eslint-enable */

        case 28:
        case "end":
          return _context7.stop();
      }
    }
  }, transition_sagas_marked7, null, [[2, 25]]);
}
function transitionSagas() {
  return regenerator_default.a.wrap(function transitionSagas$(_context8) {
    while (1) {
      switch (_context8.prev = _context8.next) {
        case 0:
          _context8.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(transition_actions_actionTypes.TRANSITION_ADD_REQUESTED, transition_sagas_add), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(transition_actions_actionTypes.TRANSITION_UPDATE_REQUESTED, transition_sagas_edit), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(transition_actions_actionTypes.TRANSITION_DELETE_REQUESTED, transition_sagas_remove), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(transition_actions_actionTypes.TRANSITION_ADD_CONDITION_REQUESTED, transition_sagas_addCondition), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(transition_actions_actionTypes.TRANSITION_UPDATE_CONDITION_REQUESTED, transition_sagas_updateCondition), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(transition_actions_actionTypes.TRANSITION_DELETE_CONDITION_REQUESTED, transition_sagas_deleteCondition), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(transition_actions_actionTypes.TRANSITION_TOGGLE_OPERATOR_REQUESTED, toggleOperator)]);

        case 2:
        case "end":
          return _context8.stop();
      }
    }
  }, transition_sagas_marked8);
}
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/index.js







// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries.store.js



var deliveries_store_marked = /*#__PURE__*/regenerator_default.a.mark(deliveries_store_combinedSaga);

/* global window */




var deliveries_store_sagaMiddleware = Object(redux_saga_core_npm_proxy_esm["a" /* default */])();

function deliveries_store_combinedSaga() {
  return regenerator_default.a.wrap(function combinedSaga$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          if (false) {}

          _context.prev = 1;
          _context.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(trackedItemSagas), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(delivery_pattern_sagas_combinedSaga), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stageSagas), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(transitionSagas)]);

        case 4:
          _context.next = 9;
          break;

        case 6:
          _context.prev = 6;
          _context.t0 = _context["catch"](1);

          /* eslint-disable no-console, angular/log */
          console.error('Release deliveries root saga:', _context.t0);
          /* eslint-enable */

        case 9:
          _context.next = 0;
          break;

        case 11:
        case "end":
          return _context.stop();
      }
    }
  }, deliveries_store_marked, null, [[1, 6]]);
}
/* eslint-disable no-underscore-dangle,angular/typecheck-object,angular/module-getter,lodash/prefer-lodash-typecheck */


var deliveries_store_composeEnhancers = (typeof window === "undefined" ? "undefined" : typeof_default()(window)) === 'object' && window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ ? window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__({
  name: 'deliveries' // Specify extension’s options like name, actionsBlacklist, actionsCreators, serialize...

}) : redux["compose"];

function deliveries_store_configureStore(preloadedState) {
  var enhancer = deliveries_store_composeEnhancers(Object(redux["applyMiddleware"])(deliveries_store_sagaMiddleware));
  var store = Object(redux["createStore"])(Object(redux["combineReducers"])({
    trackedItems: tracked_item_reducer_trackedItems,
    deliveryPatterns: delivery_pattern_reducer_deliveryPatterns,
    stages: stage_reducer_stages
  }), preloadedState, enhancer);
  deliveries_store_sagaMiddleware.run(deliveries_store_combinedSaga);
  return store;
}

var deliveries_store_store = deliveries_store_configureStore();
/* eslint-enable no-underscore-dangle,angular/typecheck-object,angular/module-getter,lodash/prefer-lodash-typecheck */
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-list-header.page.js







function delivery_pattern_list_header_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_list_header_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_list_header_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }







var delivery_pattern_list_header_page_DeliveryPatternListHeaderPage = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternListHeaderPage, _Component);

  var _super = delivery_pattern_list_header_page_createSuper(DeliveryPatternListHeaderPage);

  function DeliveryPatternListHeaderPage() {
    classCallCheck_default()(this, DeliveryPatternListHeaderPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryPatternListHeaderPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/react_default.a.createElement(es["Provider"], {
        store: deliveries_store_store
      }, /*#__PURE__*/react_default.a.createElement(delivery_pattern_list_header_container, {
        isCreateAllowed: this.props.isCreateAllowed
      }));
    }
  }]);

  return DeliveryPatternListHeaderPage;
}(react["Component"]);

defineProperty_default()(delivery_pattern_list_header_page_DeliveryPatternListHeaderPage, "propTypes", {
  isCreateAllowed: prop_types_default.a.bool.isRequired
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-create-header.component.js







function delivery_pattern_create_header_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_create_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_create_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }





var delivery_pattern_create_header_component_DeliveryPatternCreateHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternCreateHeaderComponent, _Component);

  var _super = delivery_pattern_create_header_component_createSuper(DeliveryPatternCreateHeaderComponent);

  function DeliveryPatternCreateHeaderComponent() {
    classCallCheck_default()(this, DeliveryPatternCreateHeaderComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryPatternCreateHeaderComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          disabled = _this$props.disabled,
          onCancel = _this$props.onCancel,
          onCreate = _this$props.onCreate;
      return /*#__PURE__*/react_default.a.createElement(react["Fragment"], null, /*#__PURE__*/react_default.a.createElement("h4", null, "Create delivery pattern"), /*#__PURE__*/react_default.a.createElement("div", {
        className: "buttons"
      }, /*#__PURE__*/react_default.a.createElement("button", {
        className: "button cancel",
        onClick: onCancel
      }, "Cancel"), /*#__PURE__*/react_default.a.createElement("button", {
        className: "button primary",
        disabled: disabled,
        onClick: onCreate
      }, "Create"), /*#__PURE__*/react_default.a.createElement(components["d" /* DocLink */], {
        section: "delivery-patterns.html"
      })));
    }
  }]);

  return DeliveryPatternCreateHeaderComponent;
}(react["Component"]);

defineProperty_default()(delivery_pattern_create_header_component_DeliveryPatternCreateHeaderComponent, "propTypes", {
  disabled: prop_types_default.a.bool.isRequired,
  onCancel: prop_types_default.a.func.isRequired,
  onCreate: prop_types_default.a.func.isRequired
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-create-header.container.js




var delivery_pattern_create_header_container_mapStateToProps = function mapStateToProps(state) {
  var deliveryPatterns = state.deliveryPatterns;
  return {
    disabled: deliveryPatterns.form.pristine || !deliveryPatterns.form.valid
  };
};

var delivery_pattern_create_header_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    onCancel: function onCancel() {
      return dispatch(cancelCreate());
    },
    onCreate: function onCreate() {
      return dispatch(delivery_pattern_actions_createDeliveryPattern());
    }
  };
};

/* harmony default export */ var delivery_pattern_create_header_container = (Object(es["connect"])(delivery_pattern_create_header_container_mapStateToProps, delivery_pattern_create_header_container_mapDispatchToProps)(delivery_pattern_create_header_component_DeliveryPatternCreateHeaderComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-create-header.page.js






function delivery_pattern_create_header_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_create_header_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_create_header_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var delivery_pattern_create_header_page_DeliveryPatternListHeaderPage = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternListHeaderPage, _Component);

  var _super = delivery_pattern_create_header_page_createSuper(DeliveryPatternListHeaderPage);

  function DeliveryPatternListHeaderPage() {
    classCallCheck_default()(this, DeliveryPatternListHeaderPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryPatternListHeaderPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/react_default.a.createElement(es["Provider"], {
        store: deliveries_store_store
      }, /*#__PURE__*/react_default.a.createElement(delivery_pattern_create_header_container, null));
    }
  }]);

  return DeliveryPatternListHeaderPage;
}(react["Component"]);


// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-row.component.less
var delivery_pattern_row_component = __webpack_require__(2209);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-row.component.js








function delivery_pattern_row_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_row_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_row_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var delivery_pattern_row_component_DeliveryPatternRowComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternRowComponent, _Component);

  var _super = delivery_pattern_row_component_createSuper(DeliveryPatternRowComponent);

  function DeliveryPatternRowComponent() {
    var _this;

    classCallCheck_default()(this, DeliveryPatternRowComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "edit", function () {
      var _this$props = _this.props,
          onEdit = _this$props.onEdit,
          deliveryPattern = _this$props.deliveryPattern;
      onEdit(deliveryPattern.id);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "createDelivery", function (e) {
      e.stopPropagation();
      var _this$props2 = _this.props,
          onNewDelivery = _this$props2.onNewDelivery,
          deliveryPattern = _this$props2.deliveryPattern;
      onNewDelivery(deliveryPattern.id);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "delete", function (e) {
      e.stopPropagation();
      var _this$props3 = _this.props,
          onDelete = _this$props3.onDelete,
          deliveryPattern = _this$props3.deliveryPattern;
      onDelete(deliveryPattern);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "duplicate", function (e) {
      e.stopPropagation();
      var _this$props4 = _this.props,
          onCopy = _this$props4.onCopy,
          deliveryPattern = _this$props4.deliveryPattern;
      onCopy(deliveryPattern);
    });

    return _this;
  }

  createClass_default()(DeliveryPatternRowComponent, [{
    key: "render",
    value: function render() {
      var deliveryPattern = this.props.deliveryPattern;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "delivery-pattern-row",
        onClick: this.edit
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "col-xs-6",
        title: deliveryPattern.title
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "delivery-pattern-title"
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon pattern-icon icon-l"
      }), /*#__PURE__*/react_default.a.createElement("strong", {
        className: "truncate"
      }, deliveryPattern.title))), /*#__PURE__*/react_default.a.createElement("div", {
        className: "actions col-xs-6"
      }, /*#__PURE__*/react_default.a.createElement("span", {
        className: "pull-right"
      }, deliveryPattern.isEditable && /*#__PURE__*/react_default.a.createElement("span", {
        className: "link edit",
        onClick: this.edit
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "menu-item-icon xl-icon edit-icon",
        title: "Edit"
      }), /*#__PURE__*/react_default.a.createElement("span", {
        className: "action-label"
      }, "Edit")), !deliveryPattern.isEditable && !deliveryPattern.canCreateDelivery && /*#__PURE__*/react_default.a.createElement("span", {
        className: "link",
        onClick: this.edit
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "menu-item-icon xl-icon visibility-on-icon",
        title: "View"
      }), /*#__PURE__*/react_default.a.createElement("span", {
        className: "action-label"
      }, "View")), deliveryPattern.canCreateDelivery && /*#__PURE__*/react_default.a.createElement(components["b" /* ButtonWithPopover */], {
        buttonClassName: 'create-delivery',
        content: 'You require at least one stage to create a new delivery.',
        isDisabled: deliveryPattern.isCreateDeliveryDisabled,
        isTooltipVisible: deliveryPattern.isCreateDeliveryDisabled,
        label: /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement("i", {
          className: "menu-item-icon xl-icon add-icon",
          title: "New delivery"
        }), /*#__PURE__*/react_default.a.createElement("span", {
          className: "action-label"
        }, "New delivery")),
        onActionClick: this.createDelivery,
        placement: 'bottom',
        showAsLink: true
      }), deliveryPattern.isEditable && /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement("span", {
        className: "link copy",
        onClick: this.duplicate
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "menu-item-icon xl-icon duplicate-icon",
        title: "Copy"
      }), /*#__PURE__*/react_default.a.createElement("span", {
        className: "action-label"
      }, "Copy")), /*#__PURE__*/react_default.a.createElement("span", {
        className: "link delete",
        onClick: this.delete
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "menu-item-icon xl-icon delete-icon",
        title: "Delete"
      }), /*#__PURE__*/react_default.a.createElement("span", {
        className: "action-label"
      }, "Delete"))))));
    }
  }]);

  return DeliveryPatternRowComponent;
}(react["Component"]);

defineProperty_default()(delivery_pattern_row_component_DeliveryPatternRowComponent, "propTypes", {
  deliveryPattern: prop_types_default.a.shape({
    id: prop_types_default.a.string.isRequired,
    title: prop_types_default.a.string.isRequired,
    description: prop_types_default.a.string,
    isCreateDeliveryDisabled: prop_types_default.a.bool.isRequired,
    isEditable: prop_types_default.a.bool.isRequired,
    canCreateDelivery: prop_types_default.a.bool
  }).isRequired,
  onCopy: prop_types_default.a.func.isRequired,
  onDelete: prop_types_default.a.func.isRequired,
  onEdit: prop_types_default.a.func.isRequired,
  onNewDelivery: prop_types_default.a.func.isRequired
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-duplicate-modal.component.js








function delivery_pattern_duplicate_modal_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function delivery_pattern_duplicate_modal_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_pattern_duplicate_modal_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_pattern_duplicate_modal_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function delivery_pattern_duplicate_modal_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_duplicate_modal_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_duplicate_modal_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }





var delivery_pattern_duplicate_modal_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var createButton = {
  action: 'create',
  className: 'button primary',
  keyCodes: [13],
  label: 'Continue'
};
var delivery_pattern_duplicate_modal_component_nameFormMetadata = {
  label: 'Name',
  placeholder: 'Add...',
  description: 'Name of the delivery pattern',
  required: true
};
var delivery_pattern_duplicate_modal_component_descriptionFormMetadata = {
  label: 'Description',
  placeholder: 'Set description...',
  description: 'Description of the delivery pattern',
  size: 'MEDIUM'
};

var delivery_pattern_duplicate_modal_component_maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: Object(validators["e" /* validateMaxLength */])(inputText, maxLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};

var delivery_pattern_duplicate_modal_component_DeliveryPatternDuplicateModalComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternDuplicateModalComponent, _Component);

  var _super = delivery_pattern_duplicate_modal_component_createSuper(DeliveryPatternDuplicateModalComponent);

  function DeliveryPatternDuplicateModalComponent(props) {
    var _this;

    classCallCheck_default()(this, DeliveryPatternDuplicateModalComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "handleButtonClick", function (action) {
      var _this$props = _this.props,
          onCancel = _this$props.onCancel,
          onContinue = _this$props.onContinue;
      var deliveryPattern = _this.state.deliveryPattern;

      switch (action) {
        case 'create':
          onContinue(deliveryPattern);
          break;

        case 'cancel':
          onCancel();
          break;

        default:
          throw 'Unknown action';
      }

      _this.resetForm();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "resetForm", function () {
      _this.setState({
        deliveryPattern: null
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onRegister", function (componentApi) {
      componentApi.focus();
      _this.componentApi = componentApi;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onTitleChange", function (newTitle) {
      var deliveryPattern = _this.state.deliveryPattern;

      _this.setState({
        deliveryPattern: delivery_pattern_duplicate_modal_component_objectSpread({}, deliveryPattern, {
          title: newTitle
        })
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDescChange", function (newDescription) {
      var deliveryPattern = _this.state.deliveryPattern;

      _this.setState({
        deliveryPattern: delivery_pattern_duplicate_modal_component_objectSpread({}, deliveryPattern, {
          description: newDescription
        })
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNameValidityChange", function (isNameValid) {
      _this.isNameValid = isNameValid;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDescValidityChange", function (isDescValid) {
      _this.isDescValid = isDescValid;
    });

    _this.state = {
      deliveryPattern: null,
      prevModel: null
    };
    _this.isNameValid = null;
    _this.isDescValid = null;
    return _this;
  }

  createClass_default()(DeliveryPatternDuplicateModalComponent, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          isOpened = _this$props2.isOpened,
          modalTitle = _this$props2.modalTitle;
      var deliveryPattern = this.state.deliveryPattern;
      var modalHeader = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, modalTitle);
      createButton.disabled = !this.isNameValid || !this.isDescValid;
      return /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [delivery_pattern_duplicate_modal_component_cancelButton, createButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.handleButtonClick,
        show: isOpened,
        title: modalHeader
      }, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetString"], {
        metadata: delivery_pattern_duplicate_modal_component_nameFormMetadata,
        model: deliveryPattern.title,
        onModelChange: this.onTitleChange,
        onValidityChange: this.onNameValidityChange,
        register: this.onRegister,
        validators: [delivery_pattern_duplicate_modal_component_maxLengthValidator(delivery_pattern_duplicate_modal_component_nameFormMetadata.label, 255), Object(validators["c" /* reservedCharactersValidator */])(delivery_pattern_duplicate_modal_component_nameFormMetadata.label)]
      }), /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetString"], {
        metadata: delivery_pattern_duplicate_modal_component_descriptionFormMetadata,
        model: deliveryPattern.description,
        onModelChange: this.onDescChange,
        onValidityChange: this.onDescValidityChange,
        validators: [delivery_pattern_duplicate_modal_component_maxLengthValidator(delivery_pattern_duplicate_modal_component_descriptionFormMetadata.label, 1024)]
      }));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(props, state) {
      if (!state.deliveryPattern || props.model.title !== state.prevModel.title) {
        return delivery_pattern_duplicate_modal_component_objectSpread({}, state, {
          deliveryPattern: props.model,
          prevModel: props.model
        });
      }

      return null;
    }
  }]);

  return DeliveryPatternDuplicateModalComponent;
}(react["Component"]);

defineProperty_default()(delivery_pattern_duplicate_modal_component_DeliveryPatternDuplicateModalComponent, "propTypes", {
  isOpened: prop_types_default.a.bool.isRequired,
  modalTitle: prop_types_default.a.string.isRequired,
  model: prop_types_default.a.shape({
    id: prop_types_default.a.string,
    title: prop_types_default.a.string,
    description: prop_types_default.a.string
  }).isRequired,
  onCancel: prop_types_default.a.func.isRequired,
  onContinue: prop_types_default.a.func.isRequired
});


// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/no-data/no-data.js
var no_data = __webpack_require__(209);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-list.component.js








function delivery_pattern_list_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function delivery_pattern_list_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_pattern_list_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_pattern_list_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function delivery_pattern_list_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_list_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_list_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }







var delivery_pattern_list_component_deleteButton = {
  action: 'delete',
  className: 'button primary',
  keyCodes: [13],
  label: 'Delete'
};
var delivery_pattern_list_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};

var delivery_pattern_list_component_DeliveryPatternListComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternListComponent, _Component);

  var _super = delivery_pattern_list_component_createSuper(DeliveryPatternListComponent);

  function DeliveryPatternListComponent(props) {
    var _this;

    classCallCheck_default()(this, DeliveryPatternListComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onCloseDeleteModal", function (action) {
      var deliveryPattern = _this.state.deliveryPattern;

      if (action === 'delete') {
        _this.props.deleteDeliveryPattern(deliveryPattern.id);
      }

      _this.setState({
        deleteModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showDeleteModal", function (deliveryPattern) {
      return _this.setState({
        deleteModalIsOpen: true,
        deliveryPattern: deliveryPattern
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showDuplicateModal", function (deliveryPattern) {
      return _this.setState({
        duplicateModalIsOpen: true,
        deliveryPattern: delivery_pattern_list_component_objectSpread({}, deliveryPattern, {
          title: _this.generateDeliveryPatternCopyTitle(deliveryPattern.title)
        })
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleDuplicateCancel", function () {
      _this.setState({
        duplicateModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleDuplicateContinue", function (deliveryPattern) {
      _this.props.onCopyDeliveryPattern(deliveryPattern);

      _this.setState({
        duplicateModalIsOpen: false
      });
    });

    _this.state = {
      deleteModalIsOpen: false,
      duplicateModalIsOpen: false,
      deliveryPattern: {
        id: null,
        title: null,
        description: null
      }
    };
    return _this;
  }

  createClass_default()(DeliveryPatternListComponent, [{
    key: "renderDeleteModal",
    value: function renderDeleteModal() {
      var _this$state = this.state,
          deleteModalIsOpen = _this$state.deleteModalIsOpen,
          deliveryPattern = _this$state.deliveryPattern;
      var modalHeader = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, "Delete delivery pattern");
      return /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [delivery_pattern_list_component_cancelButton, delivery_pattern_list_component_deleteButton],
        dialogClassName: "xl-default-modal no-cross",
        onButtonClick: this.onCloseDeleteModal,
        show: deleteModalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/react_default.a.createElement("p", null, "You are about to delete delivery pattern ", /*#__PURE__*/react_default.a.createElement("strong", {
        className: "wrap-text"
      }, deliveryPattern.title), "."));
    }
  }, {
    key: "generateDeliveryPatternCopyTitle",
    value: function generateDeliveryPatternCopyTitle(title) {
      var regExp = /\(([0-9]+)\)$/;

      if (regExp.test(title)) {
        return title.replace(regExp, function (s, m1) {
          var nextNumber = parseInt(m1) + 1;
          return "(".concat(nextNumber, ")");
        });
      } else {
        return title + " (1)";
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          deliveryPatterns = _this$props.deliveryPatterns,
          onEditDeliveryPattern = _this$props.onEditDeliveryPattern,
          onNewDelivery = _this$props.onNewDelivery;
      var _this$state2 = this.state,
          duplicateModalIsOpen = _this$state2.duplicateModalIsOpen,
          deliveryPattern = _this$state2.deliveryPattern;
      var list = deliveryPatterns.map(function (item) {
        return /*#__PURE__*/react_default.a.createElement(delivery_pattern_row_component_DeliveryPatternRowComponent, {
          deliveryPattern: item,
          key: item.id,
          onCopy: _this2.showDuplicateModal,
          onDelete: _this2.showDeleteModal,
          onEdit: onEditDeliveryPattern,
          onNewDelivery: onNewDelivery
        });
      });
      return /*#__PURE__*/react_default.a.createElement(react["Fragment"], null, this.renderDeleteModal(), /*#__PURE__*/react_default.a.createElement(delivery_pattern_duplicate_modal_component_DeliveryPatternDuplicateModalComponent, {
        isOpened: duplicateModalIsOpen,
        modalTitle: "Copy delivery pattern",
        model: deliveryPattern,
        onCancel: this.handleDuplicateCancel,
        onContinue: this.handleDuplicateContinue
      }), /*#__PURE__*/react_default.a.createElement("div", {
        className: "mt-15"
      }, list, (!list || !list.length) && /*#__PURE__*/react_default.a.createElement("div", null, /*#__PURE__*/react_default.a.createElement(no_data["a" /* NoData */], {
        message: "No delivery patterns found."
      }))));
    }
  }]);

  return DeliveryPatternListComponent;
}(react["Component"]);

defineProperty_default()(delivery_pattern_list_component_DeliveryPatternListComponent, "propTypes", {
  deleteDeliveryPattern: prop_types_default.a.func.isRequired,
  deliveryPatterns: prop_types_default.a.arrayOf(prop_types_default.a.shape({
    id: prop_types_default.a.string.isRequired,
    title: prop_types_default.a.string.isRequired,
    description: prop_types_default.a.string,
    isCreateDeliveryDisabled: prop_types_default.a.bool.isRequired,
    isEditable: prop_types_default.a.bool.isRequired
  }).isRequired).isRequired,
  onCopyDeliveryPattern: prop_types_default.a.func.isRequired,
  onEditDeliveryPattern: prop_types_default.a.func.isRequired,
  onNewDelivery: prop_types_default.a.func.isRequired
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-list.container.js




var delivery_pattern_list_container_mapStateToProps = function mapStateToProps(state) {
  var deliveryPatterns = state.deliveryPatterns;
  return {
    deliveryPatterns: deliveryPatterns.list
  };
};

var delivery_pattern_list_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    onCopyDeliveryPattern: function onCopyDeliveryPattern(deliveryPattern) {
      return dispatch(delivery_pattern_actions_copyDeliveryPattern(deliveryPattern));
    },
    onEditDeliveryPattern: function onEditDeliveryPattern(id) {
      return dispatch(delivery_pattern_actions_goToDetails(id));
    },
    onNewDelivery: function onNewDelivery(id) {
      return dispatch(goToCreateDelivery(id));
    },
    deleteDeliveryPattern: function deleteDeliveryPattern(id) {
      return dispatch(delivery_pattern_actions_deleteDeliveryPattern(id));
    }
  };
};

/* harmony default export */ var delivery_pattern_list_container = (Object(es["connect"])(delivery_pattern_list_container_mapStateToProps, delivery_pattern_list_container_mapDispatchToProps)(delivery_pattern_list_component_DeliveryPatternListComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-list.page.js






function delivery_pattern_list_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_list_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_list_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var delivery_pattern_list_page_DeliveryPatternListPage = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternListPage, _Component);

  var _super = delivery_pattern_list_page_createSuper(DeliveryPatternListPage);

  function DeliveryPatternListPage() {
    classCallCheck_default()(this, DeliveryPatternListPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryPatternListPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/react_default.a.createElement(es["Provider"], {
        store: deliveries_store_store
      }, /*#__PURE__*/react_default.a.createElement(delivery_pattern_list_container, null));
    }
  }]);

  return DeliveryPatternListPage;
}(react["Component"]);


// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-form.component.less
var delivery_pattern_form_component = __webpack_require__(2210);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/functor.js



var functor_Functor = function Functor(v) {
  var _this = this;

  classCallCheck_default()(this, Functor);

  defineProperty_default()(this, "map", function (fn) {
    return new Functor(fn(_this.v));
  });

  defineProperty_default()(this, "identity", function () {
    return _this.v;
  });

  this.v = v;
};


// EXTERNAL MODULE: ./node_modules/pluralize/pluralize.js
var pluralize = __webpack_require__(76);
var pluralize_default = /*#__PURE__*/__webpack_require__.n(pluralize);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/duration-picker/duration-picker.js








function duration_picker_createSuper(Derived) { var hasNativeReflectConstruct = duration_picker_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function duration_picker_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var inputNames = ['months', 'days', 'hours'];
var duration_picker_DurationPicker = /*#__PURE__*/function (_React$Component) {
  inherits_default()(DurationPicker, _React$Component);

  var _super = duration_picker_createSuper(DurationPicker);

  createClass_default()(DurationPicker, null, [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(props, state) {
      if (props.hours !== state.originalValue) {
        var _mapHoursToValues = mapHoursToValues(props.hours),
            months = _mapHoursToValues.months,
            days = _mapHoursToValues.days,
            hours = _mapHoursToValues.hours;

        return {
          originalValue: Number(props.hours),
          months: months,
          days: days,
          hours: hours,
          editMode: false
        };
      }

      return null;
    }
  }]);

  function DurationPicker(props) {
    var _this;

    classCallCheck_default()(this, DurationPicker);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "handleOnBlur", function (e) {
      if (!(e.relatedTarget !== null && inputNames.includes(e.relatedTarget.name) || document.activeElement !== null && inputNames.includes(document.activeElement.name))) {
        _this.switchMode(e, true);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleKeyDown", function (e) {
      if (e.key === 'Escape') {
        _this.switchMode(e);
      }

      if (e.key === 'Enter') {
        _this.switchMode(e, true);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleEnter", function (e) {
      if (e.key === 'Enter') {
        _this.switchMode(e);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "editMode", function () {
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "duration-editor",
        style: styles.editStyle
      }, /*#__PURE__*/react_default.a.createElement("input", {
        autoFocus: true,
        name: "months",
        onBlur: _this.handleOnBlur,
        onChange: _this.onChange,
        onKeyDown: _this.handleKeyDown,
        style: styles.inputStyle,
        type: "text",
        value: _this.state.months
      }), /*#__PURE__*/react_default.a.createElement("label", {
        style: styles.labelStyle
      }, "months"), /*#__PURE__*/react_default.a.createElement("input", {
        name: "days",
        onBlur: _this.handleOnBlur,
        onChange: _this.onChange,
        onKeyDown: _this.handleKeyDown,
        style: styles.inputStyle,
        type: "text",
        value: _this.state.days
      }), /*#__PURE__*/react_default.a.createElement("label", {
        style: styles.labelStyle
      }, "days"), /*#__PURE__*/react_default.a.createElement("input", {
        name: "hours",
        onBlur: _this.handleOnBlur,
        onChange: _this.onChange,
        onKeyDown: _this.handleKeyDown,
        style: styles.inputStyle,
        type: "text",
        value: _this.state.hours
      }), /*#__PURE__*/react_default.a.createElement("label", {
        style: styles.labelStyle
      }, "hours"));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "validateMinimum", function (name, value, min) {
      var measures = ['days', 'hours', 'months'];
      measures.splice(measures.indexOf(name), 1);
      var found = measures.find(function (m) {
        var val = _this.state[m];
        return val > 0 && val >= min[m];
      });
      return value > 0 && value >= min[name] || !!found;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onChange", function (evt) {
      var minHours = _this.props.minHours;
      var target = evt.target;
      var name = target.name;
      var value = target.value;
      var isMoreThanMin = value >= 0;

      if (minHours) {
        isMoreThanMin = _this.validateMinimum(name, value, mapHoursToValues(minHours));
      }

      if (isNumeric(value) && isMoreThanMin && value <= 99) {
        _this.setState(defineProperty_default()({}, name, Math.max(0, value)));
      } else if (value === '') {
        _this.setState(defineProperty_default()({}, name, ''));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "switchMode", function (evt) {
      var set = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var _this$props = _this.props,
          onModelChange = _this$props.onModelChange,
          onPristinityChange = _this$props.onPristinityChange;
      var flag = !_this.state.editMode;

      if (set) {
        var _extractValues = extractValues(_this.state),
            months = _extractValues.months,
            days = _extractValues.days,
            hours = _extractValues.hours;

        var rs = evaluateDuration(months, days, hours);
        onModelChange(rs);

        if (onPristinityChange) {
          onPristinityChange(rs === _this.state.originalValue);
        }

        _this.setState({
          editMode: flag
        });
      } else {
        var _mapHoursToValues2 = mapHoursToValues(_this.state.originalValue),
            _months = _mapHoursToValues2.months,
            _days = _mapHoursToValues2.days,
            _hours = _mapHoursToValues2.hours;

        _this.setState({
          months: _months,
          days: _days,
          hours: _hours,
          editMode: flag
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "viewMode", function () {
      var _extractValues2 = extractValues(_this.state),
          months = _extractValues2.months,
          days = _extractValues2.days,
          hours = _extractValues2.hours;

      if (!months && !days && !hours) {
        var originals = mapHoursToValues(_this.state.originalValue);
        months = originals.months;
        days = originals.days;
        hours = originals.hours;
      }

      var view = new functor_Functor("").map(function (s) {
        return appendString(s, months, pluralize_default()('month', months));
      }).map(function (s) {
        return appendString(s, days, pluralize_default()('day', days));
      }).map(function (s) {
        return appendString(s, hours, pluralize_default()('hour', hours));
      }).map(function (s) {
        return _this.props.tip ? "".concat(s, " ").concat(_this.props.tip) : s;
      }).map(function (s) {
        return s === "" ? _this.props.placeholder || "Placeholder" : s;
      }).identity();
      return !_this.props.disabled ? /*#__PURE__*/react_default.a.createElement("input", {
        onClick: _this.switchMode,
        onKeyDown: _this.handleEnter,
        readOnly: true,
        style: styles.viewStyle,
        value: view
      }) : /*#__PURE__*/react_default.a.createElement("input", {
        readOnly: true,
        style: styles.viewDisabledStyle,
        value: view
      });
    });

    _this.state = {};
    return _this;
  }

  createClass_default()(DurationPicker, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          description = _this$props2.description,
          disabled = _this$props2.disabled,
          label = _this$props2.label;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "xl-react-components"
      }, label && /*#__PURE__*/react_default.a.createElement("div", {
        className: "xl-react-components-label"
      }, label), /*#__PURE__*/react_default.a.createElement("div", {
        className: "xl-react-components-input ".concat(disabled && 'is-disabled')
      }, this.state.editMode ? this.editMode() : this.viewMode(), /*#__PURE__*/react_default.a.createElement("div", {
        className: "xl-react-components-description"
      }, /*#__PURE__*/react_default.a.createElement("div", null, description))));
    }
  }]);

  return DurationPicker;
}(react_default.a.Component);

defineProperty_default()(duration_picker_DurationPicker, "propTypes", {
  description: prop_types_default.a.string,
  disabled: prop_types_default.a.bool.isRequired,
  hours: prop_types_default.a.number.isRequired,
  label: prop_types_default.a.string,
  minHours: prop_types_default.a.number,
  onModelChange: prop_types_default.a.func.isRequired,
  onPristinityChange: prop_types_default.a.func,
  placeholder: prop_types_default.a.string,
  tip: prop_types_default.a.string
});

function extractValues(state) {
  var months = state.months,
      days = state.days,
      hours = state.hours;
  return {
    months: defaultVal(months),
    days: defaultVal(days),
    hours: defaultVal(hours)
  };
}

function defaultVal(val) {
  return isNumeric(val) ? val : 0;
}

function isNumeric(n) {
  return !isNaN(parseFloat(n)) && isFinite(n);
}

function mapHoursToValues(hours) {
  var m = Math.floor(hours / 720);
  var remainder = hours - m * 720;
  var d = Math.floor(remainder / 24);
  var h = hours - m * 720 - d * 24;
  return {
    months: m,
    days: d,
    hours: h
  };
}

function evaluateDuration(months, days, hours) {
  return months * 720 + days * 24 + hours;
}

function appendString(str, value, marker) {
  return value !== 0 ? "".concat(str, " ").concat(value, " ").concat(marker) : str;
}

var styles = {
  editStyle: {
    display: "flex",
    flexDirection: "row",
    flexWrap: "nowrap",
    alignItems: "center"
  },
  viewDisabledStyle: {
    backgroundColor: colors["a" /* default */].background,
    borderWidth: 1,
    borderStyle: "solid",
    borderColor: colors["a" /* default */].lightgray,
    borderRadius: 4,
    minHeight: 30,
    display: "flex",
    alignItems: "center",
    paddingLeft: 10,
    color: colors["a" /* default */].gray,
    fontSize: 12,
    width: "100%"
  },
  viewStyle: {
    borderWidth: 1,
    borderStyle: "solid",
    borderColor: colors["a" /* default */].gray,
    borderRadius: 4,
    minHeight: 30,
    display: "flex",
    alignItems: "center",
    paddingLeft: 10,
    color: colors["a" /* default */].gray,
    fontSize: 12,
    width: "100%"
  },
  labelStyle: {
    fontSize: 11,
    cursor: "default",
    marginBottom: 0
  },
  inputStyle: {
    marginLeft: 5,
    marginRight: 5,
    marginBottom: 0,
    minHeight: 30,
    minWidth: 40,
    width: 40,
    borderRadius: 4
  },
  buttonStyle: {
    marginLeft: 5,
    marginRight: 5,
    marginBottom: 0,
    marginTop: 0,
    minHeight: 30,
    minWidth: 50,
    width: 50,
    borderRadius: 4,
    fontSize: 11
  }
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-form.component.js








function delivery_pattern_form_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function delivery_pattern_form_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_pattern_form_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_pattern_form_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function delivery_pattern_form_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_form_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_form_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }









var delivery_pattern_form_component_nameFormMetadata = {
  label: 'Name',
  placeholder: 'Add...',
  description: 'Name of the delivery pattern',
  required: true
};
var delivery_pattern_form_component_descriptionFormMetadata = {
  label: 'Description',
  placeholder: 'Set description...',
  description: 'Description of the delivery pattern',
  size: 'MEDIUM'
};

var delivery_pattern_form_component_maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: Object(validators["e" /* validateMaxLength */])(inputText, maxLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};

var delivery_pattern_form_component_DeliveryPatternFormComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternFormComponent, _Component);

  var _super = delivery_pattern_form_component_createSuper(DeliveryPatternFormComponent);

  function DeliveryPatternFormComponent(props) {
    var _this;

    classCallCheck_default()(this, DeliveryPatternFormComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onRegister", function (componentApi) {
      componentApi.focus();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "_handleKeyDown", function (e) {
      var _this$props = _this.props,
          model = _this$props.model,
          valid = _this$props.valid;

      if (e.key === 'Enter' && valid) {
        if (isEmpty_default()(model.id)) {
          _this.props.onCreate();
        } else {
          _this.props.onSave();
        }
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNameValidityChange", function (valid) {
      _this.props.onValidationChange(valid);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNameChange", function (title) {
      var _this$props2 = _this.props,
          model = _this$props2.model,
          onFormChange = _this$props2.onFormChange,
          validateTitle = _this$props2.validateTitle;

      if (title !== model.title) {
        onFormChange(delivery_pattern_form_component_objectSpread({}, model, {
          title: title
        }));
        validateTitle(model.id, title);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDescriptionChange", function (description) {
      var _this$props3 = _this.props,
          model = _this$props3.model,
          onFormChange = _this$props3.onFormChange;

      if (description !== model.description) {
        onFormChange(delivery_pattern_form_component_objectSpread({}, model, {
          description: description
        }));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDurationChange", function (plannedDuration) {
      var _this$props4 = _this.props,
          model = _this$props4.model,
          onFormChange = _this$props4.onFormChange;

      if (plannedDuration !== model.plannedDuration) {
        onFormChange(delivery_pattern_form_component_objectSpread({}, model, {
          plannedDuration: plannedDuration
        }));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNamePristine", function (pristine) {
      _this.setState({
        namePristine: pristine
      });

      var _this$state = _this.state,
          descriptionPristine = _this$state.descriptionPristine,
          durationPristine = _this$state.durationPristine;
      var isFormPristine = pristine && descriptionPristine && durationPristine;

      _this.props.onPristineChange(isFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDescPristine", function (pristine) {
      _this.setState({
        descriptionPristine: pristine
      });

      var _this$state2 = _this.state,
          namePristine = _this$state2.namePristine,
          durationPristine = _this$state2.durationPristine;
      var isFormPristine = pristine && namePristine && durationPristine;

      _this.props.onPristineChange(isFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDurationPristine", function (pristine) {
      _this.setState({
        durationPristine: pristine
      });

      var _this$state3 = _this.state,
          namePristine = _this$state3.namePristine,
          descriptionPristine = _this$state3.descriptionPristine;
      var isFormPristine = pristine && namePristine && descriptionPristine;

      _this.props.onPristineChange(isFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "findPatternTitleFromPatternList", function (patterns, deliveryId) {
      var pattern = patterns ? patterns.find(function (def) {
        return def.id === deliveryId;
      }) : null;
      return pattern ? pattern.title : '';
    });

    _this.state = {
      namePristine: true,
      descriptionPristine: true,
      durationPristine: true
    };
    return _this;
  }

  createClass_default()(DeliveryPatternFormComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props5 = this.props,
          delivery = _this$props5.delivery,
          onInit = _this$props5.onInit;

      if (delivery) {
        onInit(delivery);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.props.onPristineChange(true);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props6 = this.props,
          patterns = _this$props6.patterns,
          delivery = _this$props6.delivery,
          isEditable = _this$props6.isEditable,
          isTitleValid = _this$props6.isTitleValid,
          model = _this$props6.model;
      var isNew = isEmpty_default()(model.id);

      var titleValidator = function titleValidator() {
        return {
          condition: !isTitleValid,
          message: Object(validators["a" /* createErrorMessage */])('Pattern already exists')
        };
      };

      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "row",
        id: "delivery-pattern-form"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "col-sm-7"
      }, /*#__PURE__*/react_default.a.createElement("fieldset", null, /*#__PURE__*/react_default.a.createElement("legend", null, "Properties ", !isNew && /*#__PURE__*/react_default.a.createElement("span", null, "for ", this.findPatternTitleFromPatternList(patterns, delivery.id))), /*#__PURE__*/react_default.a.createElement("div", {
        onKeyDown: this._handleKeyDown
      }, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetString"], {
        disabled: !isEditable,
        metadata: delivery_pattern_form_component_nameFormMetadata,
        model: model.title,
        onModelChange: this.onNameChange,
        onPristinityChange: this.onNamePristine,
        onValidityChange: this.onNameValidityChange,
        register: this.onRegister,
        validators: [delivery_pattern_form_component_maxLengthValidator(delivery_pattern_form_component_nameFormMetadata.label, 255), titleValidator, Object(validators["c" /* reservedCharactersValidator */])(delivery_pattern_form_component_nameFormMetadata.label)]
      })), /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetString"], {
        disabled: !isEditable,
        metadata: delivery_pattern_form_component_descriptionFormMetadata,
        model: model.description,
        onModelChange: this.onDescriptionChange,
        onPristinityChange: this.onDescPristine,
        validators: [delivery_pattern_form_component_maxLengthValidator(delivery_pattern_form_component_descriptionFormMetadata.label, 1024)]
      }))), /*#__PURE__*/react_default.a.createElement("div", {
        className: "col-sm-5"
      }, /*#__PURE__*/react_default.a.createElement("fieldset", null, /*#__PURE__*/react_default.a.createElement("legend", null, "Pattern details"), /*#__PURE__*/react_default.a.createElement(duration_picker_DurationPicker, {
        description: "Duration of the delivery pattern",
        disabled: !isEditable,
        hours: model.plannedDuration,
        label: "Duration",
        onModelChange: this.onDurationChange,
        onPristinityChange: this.onDurationPristine,
        placeholder: "Set duration..."
      }))));
    }
  }]);

  return DeliveryPatternFormComponent;
}(react["Component"]);

defineProperty_default()(delivery_pattern_form_component_DeliveryPatternFormComponent, "propTypes", {
  delivery: DeliveryPattern,
  isEditable: prop_types_default.a.bool.isRequired,
  isTitleValid: prop_types_default.a.bool.isRequired,
  model: DeliveryPattern,
  onCreate: prop_types_default.a.func.isRequired,
  onFormChange: prop_types_default.a.func.isRequired,
  onInit: prop_types_default.a.func.isRequired,
  onPristineChange: prop_types_default.a.func.isRequired,
  onSave: prop_types_default.a.func.isRequired,
  onValidationChange: prop_types_default.a.func.isRequired,
  patterns: prop_types_default.a.arrayOf(DeliveryPattern),
  valid: prop_types_default.a.bool.isRequired,
  validateTitle: prop_types_default.a.func.isRequired
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-form.container.js




var delivery_pattern_form_container_mapStateToProps = function mapStateToProps(state) {
  var deliveryPatterns = state.deliveryPatterns;
  return {
    isEditable: deliveryPatterns.form.editable,
    isTitleValid: deliveryPatterns.form.isTitleValid,
    model: deliveryPatterns.form.model,
    valid: deliveryPatterns.form.valid
  };
};

var delivery_pattern_form_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    onPristineChange: function onPristineChange(pristine) {
      return dispatch(delivery_pattern_actions_changePristine(pristine));
    },
    onValidationChange: function onValidationChange(valid) {
      return dispatch(delivery_pattern_actions_changeValidation(valid));
    },
    onFormChange: function onFormChange(model) {
      return dispatch(delivery_pattern_actions_changeModel(model));
    },
    onInit: function onInit(pattern) {
      return dispatch(deliveryLoaded(pattern));
    },
    onCreate: function onCreate() {
      return dispatch(delivery_pattern_actions_createDeliveryPattern());
    },
    onSave: function onSave() {
      return dispatch(delivery_pattern_actions_updateDeliveryPattern());
    },
    validateTitle: function validateTitle(id, title) {
      return dispatch(delivery_pattern_actions_validateTitle(id, title));
    }
  };
};

/* harmony default export */ var delivery_pattern_form_container = (Object(es["connect"])(delivery_pattern_form_container_mapStateToProps, delivery_pattern_form_container_mapDispatchToProps)(delivery_pattern_form_component_DeliveryPatternFormComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-form.page.js







function delivery_pattern_form_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_form_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_form_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }







var delivery_pattern_form_page_DeliveryPatternFormPage = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternFormPage, _Component);

  var _super = delivery_pattern_form_page_createSuper(DeliveryPatternFormPage);

  function DeliveryPatternFormPage() {
    classCallCheck_default()(this, DeliveryPatternFormPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryPatternFormPage, [{
    key: "render",
    value: function render() {
      var delivery = this.props.delivery;
      return /*#__PURE__*/react_default.a.createElement(es["Provider"], {
        store: deliveries_store_store
      }, /*#__PURE__*/react_default.a.createElement(delivery_pattern_form_container, {
        delivery: delivery
      }));
    }
  }]);

  return DeliveryPatternFormPage;
}(react["Component"]);

defineProperty_default()(delivery_pattern_form_page_DeliveryPatternFormPage, "propTypes", {
  delivery: DeliveryPattern
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ng/folders-delivery-patterns.js




var folders_delivery_patterns_template = "\n    <ng-switch on=\"$ctrl.getViewMode()\">\n        <div ng-switch-default>\n            <folder-details folder=\"$ctrl.folder\">\n                <header>\n                    <delivery-pattern-list-header class=\"folder-delivery-patterns-header\" is-create-allowed=\"$ctrl.isCreateAllowed\"/>\n                </header>\n                <content class=\"content-under-header form-content\">\n                    <delivery-pattern-list />\n                </content>\n            </folder-details>\n        </div>\n    \n        <div ng-switch-when=\"create\">\n            <folder-details folder=\"$ctrl.folder\">\n                <header>\n                    <delivery-pattern-create-header class=\"folder-delivery-patterns-header\"/>\n                </header>\n                <content class=\"content-under-header form-content\">\n                    <delivery-pattern-form />\n                </content>\n            </folder-details>\n        </div>\n    </ng-switch>\n";

var folders_delivery_patterns_DeliveryPatternsController = /*#__PURE__*/function () {
  function DeliveryPatternsController($location, Authenticator) {
    classCallCheck_default()(this, DeliveryPatternsController);

    this._$location = $location;
    this._Authenticator = Authenticator;
  }

  createClass_default()(DeliveryPatternsController, [{
    key: "$onInit",
    value: function $onInit() {
      this.isCreateAllowed = this._Authenticator.hasPermission(DELIVERY_PATTERN_EDIT_PERMISSION, this.folder.$metadata);
    }
  }, {
    key: "getViewMode",
    value: function getViewMode() {
      var action = this._$location.search().action;

      if (!_.isUndefined(action) && action === 'create') {
        return 'create';
      } else {
        return 'list';
      }
    }
  }]);

  return DeliveryPatternsController;
}();

defineProperty_default()(folders_delivery_patterns_DeliveryPatternsController, "$inject", ['$location', 'Authenticator']);

var DeliveryPatternsComponent = {
  bindings: {
    folder: '<'
  },
  controller: folders_delivery_patterns_DeliveryPatternsController,
  template: folders_delivery_patterns_template
};
/* harmony default export */ var folders_delivery_patterns = (DeliveryPatternsComponent);
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/tracked-items/tracked-item-row.less
var tracked_item_row = __webpack_require__(2211);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/tracked-items/tracked-item-row.component.js







function tracked_item_row_component_createSuper(Derived) { var hasNativeReflectConstruct = tracked_item_row_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function tracked_item_row_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var tracked_item_row_component_TrackedItemRowComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(TrackedItemRowComponent, _Component);

  var _super = tracked_item_row_component_createSuper(TrackedItemRowComponent);

  function TrackedItemRowComponent() {
    classCallCheck_default()(this, TrackedItemRowComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(TrackedItemRowComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          isEditable = _this$props.isEditable,
          onDelete = _this$props.onDelete,
          onEdit = _this$props.onEdit,
          trackedItem = _this$props.trackedItem;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "track-panel"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "col-xs-8 panel-data",
        title: trackedItem.title
      }, trackedItem.title), isEditable && /*#__PURE__*/react_default.a.createElement("div", {
        className: "actions col-xs-4"
      }, /*#__PURE__*/react_default.a.createElement("span", {
        className: "pull-right"
      }, /*#__PURE__*/react_default.a.createElement("span", {
        className: "link color-inherited",
        onClick: function onClick() {
          return onEdit(trackedItem);
        }
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "menu-item-icon xl-icon edit-icon",
        title: "Edit"
      }), /*#__PURE__*/react_default.a.createElement("span", {
        className: "action-label"
      }, "Edit")), /*#__PURE__*/react_default.a.createElement("span", {
        className: "link delete",
        onClick: function onClick() {
          return onDelete(trackedItem);
        }
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "menu-item-icon xl-icon delete-icon",
        title: "Delete"
      }), /*#__PURE__*/react_default.a.createElement("span", {
        className: "action-label"
      }, "Delete")))));
    }
  }]);

  return TrackedItemRowComponent;
}(react["Component"]);

defineProperty_default()(tracked_item_row_component_TrackedItemRowComponent, "propTypes", {
  isEditable: prop_types_default.a.bool.isRequired,
  onDelete: prop_types_default.a.func.isRequired,
  onEdit: prop_types_default.a.func.isRequired,
  trackedItem: tracked_item_types_TrackedItem.isRequired
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/tracked-items/tracked-item-edit-modal.component.js








function tracked_items_tracked_item_edit_modal_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function tracked_items_tracked_item_edit_modal_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { tracked_items_tracked_item_edit_modal_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { tracked_items_tracked_item_edit_modal_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function tracked_item_edit_modal_component_createSuper(Derived) { var hasNativeReflectConstruct = tracked_item_edit_modal_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function tracked_item_edit_modal_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var tracked_item_edit_modal_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var tracked_item_edit_modal_component_nameOptions = {
  label: 'Name',
  description: 'Name of the tracked item',
  required: true
};

var tracked_items_tracked_item_edit_modal_component_nameValidator = function nameValidator(trackedItemList) {
  var id = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  return function (title) {
    return {
      condition: Object(validators["b" /* itemAlreadyDefined */])(trackedItemList, id, 'title', title),
      message: Object(validators["a" /* createErrorMessage */])('Tracked item already exists')
    };
  };
};

var tracked_items_tracked_item_edit_modal_component_maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: Object(validators["e" /* validateMaxLength */])(inputText, maxLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};

var tracked_items_tracked_item_edit_modal_component_TrackedItemEditModalComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(TrackedItemEditModalComponent, _Component);

  var _super = tracked_item_edit_modal_component_createSuper(TrackedItemEditModalComponent);

  createClass_default()(TrackedItemEditModalComponent, null, [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(props, state) {
      if (!state.trackedItem || props.model.title !== state.prevModel.title || props.model.title === state.prevModel.title && props.model.id !== state.prevModel.id) {
        return tracked_items_tracked_item_edit_modal_component_objectSpread({}, state, {
          trackedItem: props.model,
          prevModel: props.model
        });
      }

      return null;
    }
  }]);

  function TrackedItemEditModalComponent(props) {
    var _this;

    classCallCheck_default()(this, TrackedItemEditModalComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onRegister", function (componentApi) {
      componentApi.focus();
      _this.componentApi = componentApi;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleButtonClick", function (action) {
      var _this$props = _this.props,
          onCancel = _this$props.onCancel,
          onSave = _this$props.onSave;
      var trackedItem = _this.state.trackedItem;

      switch (action) {
        case 'update':
          onSave(trackedItem);
          break;

        case 'cancel':
          onCancel();
          break;

        default:
          throw 'Unknown action';
      }

      _this.resetForm();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleModelChange", function (newTitle) {
      var trackedItem = _this.state.trackedItem;

      if (newTitle !== trackedItem.title) {
        _this.setState({
          trackedItem: tracked_items_tracked_item_edit_modal_component_objectSpread({}, trackedItem, {
            title: newTitle
          })
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleValidityChange", function (valid) {
      _this.isValid = valid;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handlePristinityChange", function (pristine) {
      _this.isPristine = pristine;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "resetForm", function () {
      _this.setState({
        trackedItem: null
      });

      if (_this.componentApi) {
        _this.componentApi.resetPristinity();
      }
    });

    _this.state = {
      trackedItem: null,
      prevModel: null
    };
    _this.isPristine = null;
    _this.isValid = null;
    _this.componentApi = null;
    return _this;
  }

  createClass_default()(TrackedItemEditModalComponent, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          isOpened = _this$props2.isOpened,
          trackedItems = _this$props2.trackedItems;
      var trackedItem = this.state.trackedItem;
      var disableSaving = this.isPristine || !this.isValid;
      var updateButton = {
        action: 'update',
        className: 'button primary',
        disabled: disableSaving,
        keyCodes: [13],
        label: 'Save'
      };
      var modalHeader = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, "Edit tracked item");
      return /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [tracked_item_edit_modal_component_cancelButton, updateButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.handleButtonClick,
        show: isOpened,
        title: modalHeader
      }, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetString"], {
        metadata: tracked_item_edit_modal_component_nameOptions,
        model: trackedItem.title,
        onModelChange: this.handleModelChange,
        onPristinityChange: this.handlePristinityChange,
        onValidityChange: this.handleValidityChange,
        register: this.onRegister,
        validators: [tracked_items_tracked_item_edit_modal_component_nameValidator(trackedItems, trackedItem.id), tracked_items_tracked_item_edit_modal_component_maxLengthValidator(tracked_item_edit_modal_component_nameOptions.label, 255), Object(validators["c" /* reservedCharactersValidator */])(tracked_item_edit_modal_component_nameOptions.label)]
      }));
    }
  }]);

  return TrackedItemEditModalComponent;
}(react["Component"]);

defineProperty_default()(tracked_items_tracked_item_edit_modal_component_TrackedItemEditModalComponent, "propTypes", {
  isOpened: prop_types_default.a.bool.isRequired,
  model: tracked_item_types_TrackedItem.isRequired,
  onCancel: prop_types_default.a.func.isRequired,
  onSave: prop_types_default.a.func.isRequired,
  trackedItems: prop_types_default.a.arrayOf(tracked_item_types_TrackedItem).isRequired
});


// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/tracked-items/tracked-item-list.less
var tracked_item_list = __webpack_require__(2212);

// EXTERNAL MODULE: ./core/xlr-ui/app/react/styles/common.less
var common = __webpack_require__(777);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/tracked-items/tracked-item-list.component.js








function tracked_item_list_component_createSuper(Derived) { var hasNativeReflectConstruct = tracked_item_list_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function tracked_item_list_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }










 // import {alertType, WidgetAlertMessage} from '../../shared/widgets/widget-alert-message';

var tracked_item_list_component_deleteButton = {
  action: 'delete',
  className: 'button primary',
  keyCodes: [13],
  label: 'Delete'
};
var tracked_item_list_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};

var tracked_item_list_component_TrackedItemListComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(TrackedItemListComponent, _Component);

  var _super = tracked_item_list_component_createSuper(TrackedItemListComponent);

  function TrackedItemListComponent(props) {
    var _this;

    classCallCheck_default()(this, TrackedItemListComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "showDeleteModal", function (trackedItem) {
      return _this.setState({
        deleteModalIsOpen: true,
        trackedItem: trackedItem
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showEditModal", function (trackedItem) {
      return _this.setState({
        editModalIsOpen: true,
        trackedItem: trackedItem
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCloseDeleteModal", function (action) {
      var trackedItem = _this.state.trackedItem;

      if (action === 'delete') {
        _this.props.deleteTrackedItem(trackedItem.id);
      }

      _this.setState({
        deleteModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleTrackedItemEditSave", function (trackedItem) {
      var _this$props = _this.props,
          saveTrackedItem = _this$props.saveTrackedItem,
          deliveryId = _this$props.deliveryId;
      saveTrackedItem(trackedItem, deliveryId);

      _this.setState({
        editModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleTrackedItemEditCancel", function () {
      _this.setState({
        editModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "closeModal", function () {
      _this.setState({
        deleteModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderTrackedItem", function (item) {
      return /*#__PURE__*/react_default.a.createElement(tracked_item_row_component_TrackedItemRowComponent, {
        isEditable: _this.props.isEditable,
        key: item.id,
        onDelete: _this.showDeleteModal,
        onEdit: _this.showEditModal,
        trackedItem: item
      });
    });

    _this.state = {
      deleteModalIsOpen: false,
      disabledUpdateButton: true,
      editModalIsOpen: false,
      trackedItem: {
        id: null,
        title: null
      }
    };
    return _this;
  }

  createClass_default()(TrackedItemListComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.props.searchTrackedItems(this.props.deliveryId);
    }
  }, {
    key: "renderDeleteModal",
    value: function renderDeleteModal() {
      var _this$state = this.state,
          deleteModalIsOpen = _this$state.deleteModalIsOpen,
          trackedItem = _this$state.trackedItem;
      var modalHeader = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, "Delete tracked item", /*#__PURE__*/react_default.a.createElement("button", {
        className: "btn-close",
        onClick: this.closeModal,
        type: "button"
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [tracked_item_list_component_cancelButton, tracked_item_list_component_deleteButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onCloseDeleteModal,
        show: deleteModalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/react_default.a.createElement("p", null, "You are about to delete tracked item ", /*#__PURE__*/react_default.a.createElement("strong", {
        className: "wrap-text"
      }, trackedItem.title), "."));
    }
  }, {
    key: "renderTrackedItems",
    value: function renderTrackedItems() {
      var _this$props2 = this.props,
          filter = _this$props2.filter,
          trackedItems = _this$props2.trackedItems;
      var list = trackedItems.filter(function (ti) {
        return ti.title.toLowerCase().includes(filter.toLowerCase());
      }).map(this.renderTrackedItem);
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "track-items"
      }, /*#__PURE__*/react_default.a.createElement("h4", {
        className: "page-title"
      }, "Tracked items (", list.length, ")"), /*#__PURE__*/react_default.a.createElement(components["f" /* HelpBlock */], {
        className: "help-message-container"
      }, "Tracked items can be components, features, services, changes, or other items that are part of your releases. You can add tracked items to a delivery to help you synchronize releases. Use ", /*#__PURE__*/react_default.a.createElement("strong", null, "Register Tracked Items"), " task to create the link."), list.length ? list : /*#__PURE__*/react_default.a.createElement("div", null, /*#__PURE__*/react_default.a.createElement(no_data["a" /* NoData */], {
        message: "No tracked items found."
      })));
    }
  }, {
    key: "render",
    value: function render() {
      var trackedItems = this.props.trackedItems;
      var _this$state2 = this.state,
          trackedItem = _this$state2.trackedItem,
          editModalIsOpen = _this$state2.editModalIsOpen;
      return /*#__PURE__*/react_default.a.createElement("div", null, this.renderDeleteModal(), /*#__PURE__*/react_default.a.createElement(tracked_items_tracked_item_edit_modal_component_TrackedItemEditModalComponent, {
        isOpened: editModalIsOpen,
        model: trackedItem,
        onCancel: this.handleTrackedItemEditCancel,
        onSave: this.handleTrackedItemEditSave,
        trackedItems: trackedItems
      }), /*#__PURE__*/react_default.a.createElement("div", null, this.renderTrackedItems()));
    }
  }]);

  return TrackedItemListComponent;
}(react["Component"]);

defineProperty_default()(tracked_item_list_component_TrackedItemListComponent, "propTypes", {
  deleteTrackedItem: prop_types_default.a.func.isRequired,
  deliveryId: prop_types_default.a.string.isRequired,
  filter: prop_types_default.a.string.isRequired,
  isEditable: prop_types_default.a.bool.isRequired,
  saveTrackedItem: prop_types_default.a.func,
  searchTrackedItems: prop_types_default.a.func.isRequired,
  trackedItems: prop_types_default.a.arrayOf(tracked_item_types_TrackedItem).isRequired
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/tracked-item.container.js




var tracked_item_container_mapStateToProps = function mapStateToProps(state) {
  var trackedItems = state.trackedItems;
  return {
    filter: trackedItems.filter,
    trackedItems: trackedItems.list
  };
};

var tracked_item_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    deleteTrackedItem: function deleteTrackedItem(id) {
      return dispatch(tracked_item_actions_removeTrackedItem(id));
    },
    searchTrackedItems: function searchTrackedItems(deliveryId) {
      return dispatch(fetchTrackedItems(deliveryId));
    },
    saveTrackedItem: function saveTrackedItem(item, deliveryId) {
      return dispatch(tracked_item_actions_createOrUpdateTrackedItem(item, deliveryId));
    }
  };
};

/* harmony default export */ var tracked_item_container = (Object(es["connect"])(tracked_item_container_mapStateToProps, tracked_item_container_mapDispatchToProps)(tracked_item_list_component_TrackedItemListComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/tracked-item.page.js







function tracked_item_page_createSuper(Derived) { var hasNativeReflectConstruct = tracked_item_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function tracked_item_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }







var tracked_item_page_TrackedItemsPage = /*#__PURE__*/function (_Component) {
  inherits_default()(TrackedItemsPage, _Component);

  var _super = tracked_item_page_createSuper(TrackedItemsPage);

  function TrackedItemsPage() {
    classCallCheck_default()(this, TrackedItemsPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(TrackedItemsPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/react_default.a.createElement(es["Provider"], {
        store: deliveries_store_store
      }, /*#__PURE__*/react_default.a.createElement(tracked_item_container, {
        deliveryId: this.props.deliveryId,
        isEditable: this.props.isEditable
      }));
    }
  }]);

  return TrackedItemsPage;
}(react["Component"]);

defineProperty_default()(tracked_item_page_TrackedItemsPage, "propTypes", {
  deliveryId: prop_types_default.a.string.isRequired,
  isEditable: prop_types_default.a.bool.isRequired
});


// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/styles/modal.less
var modal = __webpack_require__(342);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/tracked-items/tracked-item-header.component.js








function tracked_item_header_component_createSuper(Derived) { var hasNativeReflectConstruct = tracked_item_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function tracked_item_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }








var tracked_item_header_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var tracked_item_header_component_createButton = {
  action: 'create',
  className: 'button primary',
  keyCodes: [13],
  label: 'Create'
};
var tracked_item_header_component_nameOptions = {
  label: 'Name',
  placeholder: 'Add...',
  description: 'Name of the tracked item',
  required: true
};

var tracked_item_header_component_nameValidator = function nameValidator(trackedItemList) {
  return function (title) {
    return {
      condition: Object(validators["b" /* itemAlreadyDefined */])(trackedItemList, null, 'title', title),
      message: Object(validators["a" /* createErrorMessage */])('Tracked item already existing')
    };
  };
};

var tracked_item_header_component_maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: Object(validators["e" /* validateMaxLength */])(inputText, maxLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};

var tracked_item_header_component_TrackedItemHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(TrackedItemHeaderComponent, _Component);

  var _super = tracked_item_header_component_createSuper(TrackedItemHeaderComponent);

  function TrackedItemHeaderComponent(props) {
    var _this;

    classCallCheck_default()(this, TrackedItemHeaderComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onRegister", function (componentApi) {
      componentApi.focus();
      _this.componentApi = componentApi;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCreate", function () {
      _this.setState({
        modalIsOpen: true
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleButtonClick", function (action) {
      var _this$props = _this.props,
          deliveryId = _this$props.deliveryId,
          onSave = _this$props.onSave;

      switch (action) {
        case 'create':
          onSave({
            title: _this.state.title
          }, deliveryId);

          _this.setState({
            modalIsOpen: _this.state.createAnother,
            title: ''
          });

          if (_this.state.createAnother) {
            _this.componentApi.resetPristinity();
          }

          break;

        case 'cancel':
          _this.setState({
            createAnother: false,
            title: '',
            modalIsOpen: false
          });

          break;

        default:
          throw 'Unknown action';
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onModelChange", function (title) {
      _this.setState({
        title: title
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onValidityChange", function (valid) {
      _this.setState({
        createButtonDisabled: !valid
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCheckboxClick", function (event) {
      _this.setState({
        createAnother: event.target.checked
      });
    });

    _this.state = {
      createAnother: false,
      createButtonDisabled: false,
      modalIsOpen: false,
      title: ''
    };
    _this.componentApi = null;
    return _this;
  }

  createClass_default()(TrackedItemHeaderComponent, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          isEditable = _this$props2.isEditable,
          onFilterChange = _this$props2.onFilterChange,
          trackedItems = _this$props2.trackedItems;
      var _this$state = this.state,
          modalIsOpen = _this$state.modalIsOpen,
          createButtonDisabled = _this$state.createButtonDisabled;
      var filterOptions = {
        placeholder: 'Filter by tracked item...'
      };
      tracked_item_header_component_createButton.disabled = createButtonDisabled;
      var modalHeader = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, "New tracked item");
      return /*#__PURE__*/react_default.a.createElement("div", {
        id: "header-tracked-items"
      }, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetFilter"], {
        metadata: filterOptions,
        onUpdate: onFilterChange
      }), isEditable && /*#__PURE__*/react_default.a.createElement("div", {
        className: "buttons"
      }, /*#__PURE__*/react_default.a.createElement("button", {
        className: "button primary",
        onClick: this.onCreate
      }, "Add tracked item"), /*#__PURE__*/react_default.a.createElement(components["d" /* DocLink */], {
        section: "delivery-patterns.html"
      })), /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [tracked_item_header_component_cancelButton, tracked_item_header_component_createButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.handleButtonClick,
        onCheckboxClick: this.onCheckboxClick,
        show: modalIsOpen,
        skin: "checkbox",
        title: modalHeader
      }, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetString"], {
        metadata: tracked_item_header_component_nameOptions,
        model: this.state.title,
        onModelChange: this.onModelChange,
        onValidityChange: this.onValidityChange,
        register: this.onRegister,
        validators: [tracked_item_header_component_nameValidator(trackedItems), tracked_item_header_component_maxLengthValidator(tracked_item_header_component_nameOptions.label, 255), Object(validators["c" /* reservedCharactersValidator */])(tracked_item_header_component_nameOptions.label)]
      })));
    }
  }]);

  return TrackedItemHeaderComponent;
}(react["Component"]);

defineProperty_default()(tracked_item_header_component_TrackedItemHeaderComponent, "propTypes", {
  deliveryId: prop_types_default.a.string.isRequired,
  isEditable: prop_types_default.a.bool.isRequired,
  onFilterChange: prop_types_default.a.func.isRequired,
  onSave: prop_types_default.a.func.isRequired,
  trackedItems: prop_types_default.a.arrayOf(tracked_item_types_TrackedItem).isRequired
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/tracked-item-header.container.js




var tracked_item_header_container_mapStateToProps = function mapStateToProps(state) {
  var trackedItems = state.trackedItems;
  return {
    filter: trackedItems.filter,
    trackedItems: trackedItems.list
  };
};

var tracked_item_header_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    onFilterChange: function onFilterChange(filter) {
      return dispatch(changeFilter(filter));
    },
    onSave: function onSave(item, deliveryId) {
      return dispatch(tracked_item_actions_createOrUpdateTrackedItem(item, deliveryId));
    }
  };
};

/* harmony default export */ var tracked_item_header_container = (Object(es["connect"])(tracked_item_header_container_mapStateToProps, tracked_item_header_container_mapDispatchToProps)(tracked_item_header_component_TrackedItemHeaderComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/tracked-item-header.page.js







function tracked_item_header_page_createSuper(Derived) { var hasNativeReflectConstruct = tracked_item_header_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function tracked_item_header_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }







var tracked_item_header_page_TrackedItemHeaderPage = /*#__PURE__*/function (_Component) {
  inherits_default()(TrackedItemHeaderPage, _Component);

  var _super = tracked_item_header_page_createSuper(TrackedItemHeaderPage);

  function TrackedItemHeaderPage() {
    classCallCheck_default()(this, TrackedItemHeaderPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(TrackedItemHeaderPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/react_default.a.createElement(es["Provider"], {
        store: deliveries_store_store
      }, /*#__PURE__*/react_default.a.createElement(tracked_item_header_container, {
        deliveryId: this.props.deliveryId,
        isEditable: this.props.isEditable
      }));
    }
  }]);

  return TrackedItemHeaderPage;
}(react["Component"]);

defineProperty_default()(tracked_item_header_page_TrackedItemHeaderPage, "propTypes", {
  deliveryId: prop_types_default.a.string.isRequired,
  isEditable: prop_types_default.a.bool.isRequired
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-properties-header.component.js








function delivery_pattern_properties_header_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_properties_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_properties_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }





var delivery_pattern_properties_header_component_DeliveryPatternPropertiesHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternPropertiesHeaderComponent, _Component);

  var _super = delivery_pattern_properties_header_component_createSuper(DeliveryPatternPropertiesHeaderComponent);

  function DeliveryPatternPropertiesHeaderComponent(props) {
    var _this;

    classCallCheck_default()(this, DeliveryPatternPropertiesHeaderComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "reset", function () {
      var _this$props = _this.props,
          pristine = _this$props.pristine,
          onCancel = _this$props.onCancel;

      if (!pristine) {
        onCancel();
      }
    });

    return _this;
  }

  createClass_default()(DeliveryPatternPropertiesHeaderComponent, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          lastSaved = _this$props2.lastSaved,
          onSave = _this$props2.onSave,
          pristine = _this$props2.pristine,
          valid = _this$props2.valid;
      return /*#__PURE__*/react_default.a.createElement(react["Fragment"], null, /*#__PURE__*/react_default.a.createElement("div", {
        className: "buttons"
      }, lastSaved && /*#__PURE__*/react_default.a.createElement("span", {
        className: "last-save-date"
      }, "Last saved on ", lastSaved), /*#__PURE__*/react_default.a.createElement("button", {
        className: "button cancel",
        disabled: pristine,
        onClick: this.reset
      }, "Discard changes"), /*#__PURE__*/react_default.a.createElement("button", {
        className: "button primary",
        disabled: pristine || !valid,
        onClick: onSave
      }, "Save"), /*#__PURE__*/react_default.a.createElement(components["d" /* DocLink */], {
        section: "delivery-patterns.html"
      })));
    }
  }]);

  return DeliveryPatternPropertiesHeaderComponent;
}(react["Component"]);

defineProperty_default()(delivery_pattern_properties_header_component_DeliveryPatternPropertiesHeaderComponent, "propTypes", {
  lastSaved: prop_types_default.a.string,
  onCancel: prop_types_default.a.func.isRequired,
  onSave: prop_types_default.a.func.isRequired,
  pristine: prop_types_default.a.bool.isRequired,
  valid: prop_types_default.a.bool.isRequired
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-properties-header.container.js




var delivery_pattern_properties_header_container_mapStateToProps = function mapStateToProps(state) {
  var deliveryPatterns = state.deliveryPatterns;
  return {
    lastSaved: deliveryPatterns.form.lastSaved,
    model: deliveryPatterns.form.model,
    pristine: deliveryPatterns.form.pristine,
    valid: deliveryPatterns.form.valid
  };
};

var delivery_pattern_properties_header_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    onCancel: function onCancel() {
      return dispatch(resetDeliveryPattern());
    },
    onSave: function onSave() {
      return dispatch(delivery_pattern_actions_updateDeliveryPattern());
    }
  };
};

/* harmony default export */ var delivery_pattern_properties_header_container = (Object(es["connect"])(delivery_pattern_properties_header_container_mapStateToProps, delivery_pattern_properties_header_container_mapDispatchToProps)(delivery_pattern_properties_header_component_DeliveryPatternPropertiesHeaderComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-properties-header.page.js






function delivery_pattern_properties_header_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_properties_header_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_properties_header_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var delivery_pattern_properties_header_page_DeliveryPatternPropertiesHeaderPage = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternPropertiesHeaderPage, _Component);

  var _super = delivery_pattern_properties_header_page_createSuper(DeliveryPatternPropertiesHeaderPage);

  function DeliveryPatternPropertiesHeaderPage() {
    classCallCheck_default()(this, DeliveryPatternPropertiesHeaderPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryPatternPropertiesHeaderPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/react_default.a.createElement(es["Provider"], {
        store: deliveries_store_store
      }, /*#__PURE__*/react_default.a.createElement(delivery_pattern_properties_header_container, null));
    }
  }]);

  return DeliveryPatternPropertiesHeaderPage;
}(react["Component"]);


// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/stage/stage-list.component.less
var stage_list_component = __webpack_require__(2213);

// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/transition/transition.component.less
var transition_component = __webpack_require__(2214);

// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/transition/condition-block.component.less
var condition_block_component = __webpack_require__(2215);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/transition/condition-block.component.js







function condition_block_component_createSuper(Derived) { var hasNativeReflectConstruct = condition_block_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function condition_block_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }








var condition_block_component_typeToValue = function typeToValue(type) {
  return conditionValueOpts[type];
};

var condition_block_component_valueToType = function valueToType(value) {
  return Object.keys(conditionValueOpts).find(function (key) {
    return conditionValueOpts[key] === value;
  });
};

var condition_block_component_ConditionBlockComponent = /*#__PURE__*/function (_React$Component) {
  inherits_default()(ConditionBlockComponent, _React$Component);

  var _super = condition_block_component_createSuper(ConditionBlockComponent);

  function ConditionBlockComponent(props) {
    classCallCheck_default()(this, ConditionBlockComponent);

    return _super.call(this, props);
  }

  createClass_default()(ConditionBlockComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          group = _this$props.group,
          isEditable = _this$props.isEditable,
          onAdd = _this$props.onAdd,
          onChange = _this$props.onChange,
          onDelete = _this$props.onDelete,
          op = _this$props.op;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "condition-block"
      }, group.conditions && group.conditions.map(function (condition, idx) {
        return /*#__PURE__*/react_default.a.createElement("div", {
          className: "condition-wrapper",
          key: condition.id
        }, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetAutocomplete"], {
          disabled: !isEditable,
          handlers: {
            addCandidates: function addCandidates() {
              return Promise.resolve(Object.values(conditionValueOpts).reduce(function (a, v) {
                a.push({
                  'id': v
                });
                return a;
              }, []));
            }
          },
          metadata: {
            placeholder: ''
          },
          model: conditionValueOpts[condition.type],
          onModelChange: function onModelChange(option) {
            if (condition_block_component_typeToValue(condition.type) !== option) {
              onChange(condition.id, {
                type: condition_block_component_valueToType(option)
              });
            }
          }
        }), isEditable && /*#__PURE__*/react_default.a.createElement("span", {
          className: "link delete-condition-btn",
          onClick: function onClick() {
            return onDelete(condition.id);
          }
        }, /*#__PURE__*/react_default.a.createElement("i", {
          className: "menu-item-icon xl-icon delete-icon",
          title: "Delete"
        })), condition.type === conditionTypes.TIMED && /*#__PURE__*/react_default.a.createElement(duration_picker_DurationPicker, {
          disabled: !isEditable,
          hours: condition.startDateOffset,
          minHours: 1,
          onModelChange: function onModelChange(value) {
            return onChange(condition.id, {
              value: value
            });
          },
          placeholder: "Set schedule...",
          tip: "from delivery start date"
        }), group.conditions.length !== idx + 1 && /*#__PURE__*/react_default.a.createElement("div", {
          style: {
            width: '100%'
          }
        }, /*#__PURE__*/react_default.a.createElement("h4", {
          className: "condition-block-expr"
        }, /*#__PURE__*/react_default.a.createElement("span", null, op))));
      }), isEditable && /*#__PURE__*/react_default.a.createElement("p", {
        className: "add-condition-btn",
        onClick: function onClick() {
          return onAdd(group.id);
        }
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon icon-xl add-icon"
      }), " Add condition to this group"));
    }
  }]);

  return ConditionBlockComponent;
}(react_default.a.Component);

defineProperty_default()(condition_block_component_ConditionBlockComponent, "propTypes", {
  group: ConditionGroup.isRequired,
  isEditable: prop_types_default.a.bool.isRequired,
  onAdd: prop_types_default.a.func.isRequired,
  onChange: prop_types_default.a.func.isRequired,
  onDelete: prop_types_default.a.func.isRequired,
  op: prop_types_default.a.string.isRequired
});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/transition/transition.component.js








function transition_component_createSuper(Derived) { var hasNativeReflectConstruct = transition_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function transition_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }










var transition_component_deleteButton = {
  action: 'delete',
  className: 'button primary',
  keyCodes: [13],
  label: 'Delete'
};
var transition_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};

var transition_component_existenceValidator = function existenceValidator(filledlabel) {
  return function (inputText) {
    return {
      condition: Object(validators["d" /* validateExistence */])(inputText),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filledlabel, " must be set"))
    };
  };
};

var transition_component_minLengthValidator = function minLengthValidator(filledlabel, minLength) {
  return function (inputText) {
    return {
      condition: Object(validators["f" /* validateMinLength */])(inputText, minLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filledlabel, " must be set"))
    };
  };
};

var transition_component_actions = [{
  status: 'Completed',
  label: 'Move to next stage',
  iconClass: 'circle-check-icon'
}, {
  status: 'In progress',
  label: 'Mark as descoped',
  iconClass: 'progress-icon'
}, {
  status: 'Waiting',
  label: 'Mark as descoped',
  iconClass: 'pending-icon'
}];
var transition_component_TransitionComponent = /*#__PURE__*/function (_React$Component) {
  inherits_default()(TransitionComponent, _React$Component);

  var _super = transition_component_createSuper(TransitionComponent);

  function TransitionComponent(props) {
    var _this;

    classCallCheck_default()(this, TransitionComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "handleFocusOut", function (title, rollback) {
      if (_this.state.isValid && title.trim() !== _this.props.model.title) {
        _this.props.onUpdate(_this.props.model.id, title);
      } else {
        rollback();

        _this.setState({
          isValid: true
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleValidityChange", function (isValid) {
      _this.setState({
        isValid: isValid
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCloseDeleteModal", function (action) {
      if (action === 'delete') {
        _this.props.onDelete(_this.props.model.id);
      }

      _this.setState({
        deleteModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showDeleteModal", function () {
      return _this.setState({
        deleteModalIsOpen: true
      });
    });

    _this.state = {
      deleteModalIsOpen: false,
      isValid: true
    };
    return _this;
  }

  createClass_default()(TransitionComponent, [{
    key: "renderSlimView",
    value: function renderSlimView() {
      var onAdd = this.props.onAdd;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "transition-add"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "add-button",
        "data-cy": "btn-transition-add",
        onClick: onAdd
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon add-icon"
      })), /*#__PURE__*/react_default.a.createElement("div", {
        className: "slim-main"
      }));
    }
  }, {
    key: "renderMainView",
    value: function renderMainView() {
      var _this$props = this.props,
          isEditable = _this$props.isEditable,
          model = _this$props.model,
          onAddCondition = _this$props.onAddCondition,
          onDeleteCondition = _this$props.onDeleteCondition,
          onToggleOperator = _this$props.onToggleOperator,
          onUpdateCondition = _this$props.onUpdateCondition,
          operator = _this$props.operator;
      var rootGroup = model.conditions.length > 0 ? model.conditions[0] : null;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "transition"
      }, this.renderDeleteModal(), /*#__PURE__*/react_default.a.createElement("div", {
        className: "main"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "header"
      }, /*#__PURE__*/react_default.a.createElement(components["e" /* EditableLabel */], {
        disabled: !isEditable,
        inputMaxLength: 255,
        inputWidth: "400px",
        labelClassName: "truncate",
        labelFontSize: "14px",
        labelFontWeight: "bold",
        onFocusOut: this.handleFocusOut,
        onValidityChange: this.handleValidityChange,
        required: true,
        text: model.title,
        validators: [transition_component_existenceValidator('Transition title'), Object(validators["c" /* reservedCharactersValidator */])('Transition title'), transition_component_minLengthValidator('Transition title', 1)]
      }), isEditable && /*#__PURE__*/react_default.a.createElement("span", {
        className: "pull-right"
      }, /*#__PURE__*/react_default.a.createElement("span", {
        className: "link",
        onClick: this.showDeleteModal
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "menu-item-icon xl-icon delete-icon",
        title: "Delete"
      })))), /*#__PURE__*/react_default.a.createElement("div", {
        className: "scroll-container"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "content-wrapper"
      }, /*#__PURE__*/react_default.a.createElement("h4", null, "Conditions"), isEditable && /*#__PURE__*/react_default.a.createElement("p", null, /*#__PURE__*/react_default.a.createElement("span", {
        className: "condition-switch-label"
      }, "Toggle operator"), /*#__PURE__*/react_default.a.createElement("span", {
        className: "condition-switch-wrapper"
      }, "Groups", /*#__PURE__*/react_default.a.createElement("span", {
        className: "condition-switch",
        onClick: function onClick() {
          return onToggleOperator(model.id);
        }
      }, /*#__PURE__*/react_default.a.createElement("span", {
        className: "condition-op"
      }, operator), /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon change-icon"
      }), /*#__PURE__*/react_default.a.createElement("span", {
        className: "condition-op"
      }, stage_reducer_inverseOperator(operator))), "Conditions")), rootGroup && rootGroup.conditions.map(function (group, idx) {
        return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, {
          key: idx
        }, /*#__PURE__*/react_default.a.createElement(condition_block_component_ConditionBlockComponent, {
          group: group,
          isEditable: isEditable,
          onAdd: function onAdd(groupId) {
            return onAddCondition(model.id, groupId);
          },
          onChange: function onChange(conditionId, type) {
            return onUpdateCondition(model.id, conditionId, type);
          },
          onDelete: function onDelete(conditionId) {
            return onDeleteCondition(model.id, conditionId);
          },
          op: stage_reducer_inverseOperator(operator)
        }), rootGroup.conditions.length !== idx + 1 && /*#__PURE__*/react_default.a.createElement("h4", {
          className: "condition-block-expr"
        }, operator));
      }), isEditable && /*#__PURE__*/react_default.a.createElement("button", {
        className: "btn-add-condition-block",
        onClick: function onClick() {
          return onAddCondition(model.id);
        }
      }, /*#__PURE__*/react_default.a.createElement("span", null, "Add condition group"), /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon icon-xl add-icon"
      })), /*#__PURE__*/react_default.a.createElement("div", {
        className: "cover"
      })), /*#__PURE__*/react_default.a.createElement("div", {
        className: "shadow"
      }), /*#__PURE__*/react_default.a.createElement("div", {
        className: "content-wrapper"
      }, /*#__PURE__*/react_default.a.createElement("h4", null, "Actions"), /*#__PURE__*/react_default.a.createElement("p", null, "Actions to execute after conditions defined above are satisfied"), transition_component_actions.map(function (action, idx) {
        return /*#__PURE__*/react_default.a.createElement("div", {
          className: "action",
          key: idx
        }, /*#__PURE__*/react_default.a.createElement("span", {
          className: "status"
        }, /*#__PURE__*/react_default.a.createElement("i", {
          className: "xl-icon ".concat(action.iconClass)
        }), action.status, " items"), /*#__PURE__*/react_default.a.createElement("span", {
          className: "type"
        }, action.label));
      })))));
    }
  }, {
    key: "renderDeleteModal",
    value: function renderDeleteModal() {
      var deleteModalIsOpen = this.state.deleteModalIsOpen;
      var modalHeader = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, "Delete transition");
      return /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [transition_component_cancelButton, transition_component_deleteButton],
        dialogClassName: "xl-default-modal no-cross",
        onButtonClick: this.onCloseDeleteModal,
        show: deleteModalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/react_default.a.createElement("p", null, "You are about to delete transition ", /*#__PURE__*/react_default.a.createElement("strong", {
        className: "wrap-text"
      }, this.props.model.title), "."));
    }
  }, {
    key: "render",
    value: function render() {
      return this.props.model ? this.renderMainView() : this.props.isEditable && this.renderSlimView();
    }
  }]);

  return TransitionComponent;
}(react_default.a.Component);

defineProperty_default()(transition_component_TransitionComponent, "propTypes", {
  isEditable: prop_types_default.a.bool.isRequired,
  model: Transition,
  onAdd: prop_types_default.a.func.isRequired,
  onAddCondition: prop_types_default.a.func.isRequired,
  onDelete: prop_types_default.a.func.isRequired,
  onDeleteCondition: prop_types_default.a.func.isRequired,
  onToggleOperator: prop_types_default.a.func.isRequired,
  onUpdate: prop_types_default.a.func.isRequired,
  onUpdateCondition: prop_types_default.a.func.isRequired,
  operator: prop_types_default.a.string
});
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/stage/stage.component.less
var stage_component = __webpack_require__(2216);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/stage/stage.component.js








function stage_component_createSuper(Derived) { var hasNativeReflectConstruct = stage_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function stage_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }









var stage_component_deleteButton = {
  action: 'delete',
  className: 'button primary',
  keyCodes: [13],
  label: 'Delete'
};
var stage_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};

var stage_component_existenceValidator = function existenceValidator(filedLabel) {
  return function (inputText) {
    return {
      condition: Object(validators["d" /* validateExistence */])(inputText),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be set"))
    };
  };
};

var stage_component_nameValidator = function nameValidator(stageList, id) {
  return function (name) {
    return {
      condition: Object(validators["b" /* itemAlreadyDefined */])(stageList, id, 'title', name),
      message: Object(validators["a" /* createErrorMessage */])('Stage already exists')
    };
  };
};

var stage_component_PatternStageComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(PatternStageComponent, _Component);

  var _super = stage_component_createSuper(PatternStageComponent);

  function PatternStageComponent(props) {
    var _this;

    classCallCheck_default()(this, PatternStageComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "handleFocusOut", function (title, rollback) {
      if (_this.state.isValid && title.trim() !== _this.props.stage.title) {
        _this.props.onUpdate(_this.props.stage.id, title);
      } else {
        rollback();

        _this.setState({
          isValid: true
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCloseDeleteModal", function (action) {
      if (action === 'delete') {
        _this.props.onDelete(_this.props.stage.id);
      }

      _this.setState({
        deleteModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showDeleteModal", function () {
      return _this.setState({
        deleteModalIsOpen: true
      });
    });

    _this.state = {
      deleteModalIsOpen: false,
      isValid: true
    };
    return _this;
  }

  createClass_default()(PatternStageComponent, [{
    key: "handleValidityChange",
    value: function handleValidityChange(isValid) {
      this.setState({
        isValid: isValid
      });
    }
  }, {
    key: "renderDeleteModal",
    value: function renderDeleteModal() {
      var deleteModalIsOpen = this.state.deleteModalIsOpen;
      var modalHeader = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, "Delete stage");
      return /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [stage_component_cancelButton, stage_component_deleteButton],
        dialogClassName: "xl-default-modal no-cross",
        onButtonClick: this.onCloseDeleteModal,
        show: deleteModalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/react_default.a.createElement("p", null, "You are about to delete stage ", /*#__PURE__*/react_default.a.createElement("strong", {
        className: "wrap-text"
      }, this.props.stage.title), "."));
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          isEditable = _this$props.isEditable,
          stage = _this$props.stage;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "stage"
      }, this.renderDeleteModal(), /*#__PURE__*/react_default.a.createElement("div", {
        className: "stage-title"
      }, /*#__PURE__*/react_default.a.createElement(components["e" /* EditableLabel */], {
        disabled: !isEditable,
        inputMaxLength: 255,
        inputWidth: "100%",
        labelClassName: "truncate",
        labelFontSize: "14px",
        labelFontWeight: "bold",
        onFocusOut: this.handleFocusOut,
        onValidityChange: this.handleValidityChange.bind(this),
        required: true,
        text: stage.title,
        validators: [stage_component_existenceValidator('Stage title'), stage_component_nameValidator(this.props.stages, stage.id), Object(validators["c" /* reservedCharactersValidator */])('Stage title')]
      }), isEditable && /*#__PURE__*/react_default.a.createElement("span", {
        className: "stage-actions"
      }, /*#__PURE__*/react_default.a.createElement("span", {
        className: "link",
        onClick: this.showDeleteModal
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "menu-item-icon xl-icon delete-icon",
        title: "Delete"
      })))));
    }
  }]);

  return PatternStageComponent;
}(react["Component"]);

defineProperty_default()(stage_component_PatternStageComponent, "propTypes", {
  isEditable: prop_types_default.a.bool.isRequired,
  onDelete: prop_types_default.a.func.isRequired,
  onUpdate: prop_types_default.a.func.isRequired,
  stage: Stage.isRequired,
  stages: prop_types_default.a.arrayOf(Stage)
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/stage/stage-list.component.js







function stage_list_component_createSuper(Derived) { var hasNativeReflectConstruct = stage_list_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function stage_list_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }








var stage_list_component_DefStageListComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DefStageListComponent, _Component);

  var _super = stage_list_component_createSuper(DefStageListComponent);

  function DefStageListComponent() {
    classCallCheck_default()(this, DefStageListComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(DefStageListComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.props.getStages(this.props.deliveryId);
    }
  }, {
    key: "renderStages",
    value: function renderStages() {
      var _this$props = this.props,
          isEditable = _this$props.isEditable,
          onAddStage = _this$props.onAddStage,
          onAddTransition = _this$props.onAddTransition,
          onAddCondition = _this$props.onAddCondition,
          onUpdateTransition = _this$props.onUpdateTransition,
          onUpdateCondition = _this$props.onUpdateCondition,
          onDeleteTransition = _this$props.onDeleteTransition,
          onDeleteCondition = _this$props.onDeleteCondition,
          onDeleteStage = _this$props.onDeleteStage,
          onToggleOperator = _this$props.onToggleOperator,
          onUpdateStage = _this$props.onUpdateStage,
          operators = _this$props.operators,
          stages = _this$props.stages;
      return stages.map(function (stage, key) {
        return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, {
          key: stage.id
        }, /*#__PURE__*/react_default.a.createElement(stage_component_PatternStageComponent, {
          isEditable: isEditable,
          onDelete: onDeleteStage,
          onUpdate: onUpdateStage,
          stage: stage,
          stages: stages
        }), stages.length !== key + 1 && /*#__PURE__*/react_default.a.createElement(transition_component_TransitionComponent, {
          isEditable: isEditable,
          model: stage.transition,
          onAdd: function onAdd() {
            return onAddTransition(stage.id);
          },
          onAddCondition: onAddCondition,
          onDelete: onDeleteTransition,
          onDeleteCondition: onDeleteCondition,
          onToggleOperator: onToggleOperator,
          onUpdate: function onUpdate(id, title) {
            return onUpdateTransition(id, stage.id, title);
          },
          onUpdateCondition: onUpdateCondition,
          operator: stage.transition && operators[stage.transition.id]
        }), isEditable && stages.length === key + 1 && /*#__PURE__*/react_default.a.createElement("button", {
          className: "button add-stage",
          onClick: onAddStage
        }, /*#__PURE__*/react_default.a.createElement("i", {
          className: "xl-icon icon-xl add-icon"
        }), /*#__PURE__*/react_default.a.createElement("p", null, "Add stage")));
      });
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "stages"
      }, this.renderStages(), /*#__PURE__*/react_default.a.createElement("div", {
        style: {
          minWidth: '1px'
        }
      }));
    }
  }]);

  return DefStageListComponent;
}(react["Component"]);

defineProperty_default()(stage_list_component_DefStageListComponent, "propTypes", {
  deliveryId: prop_types_default.a.string.isRequired,
  getStages: prop_types_default.a.func.isRequired,
  isEditable: prop_types_default.a.bool.isRequired,
  onAddCondition: prop_types_default.a.func.isRequired,
  onAddStage: prop_types_default.a.func.isRequired,
  onAddTransition: prop_types_default.a.func.isRequired,
  onDeleteCondition: prop_types_default.a.func.isRequired,
  onDeleteStage: prop_types_default.a.func.isRequired,
  onDeleteTransition: prop_types_default.a.func.isRequired,
  onToggleOperator: prop_types_default.a.func.isRequired,
  onUpdateCondition: prop_types_default.a.func.isRequired,
  onUpdateStage: prop_types_default.a.func.isRequired,
  onUpdateTransition: prop_types_default.a.func.isRequired,
  operators: prop_types_default.a.object.isRequired,
  stages: prop_types_default.a.arrayOf(Stage)
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/stage-list.container.js





var stage_list_container_mapStateToProps = function mapStateToProps(state) {
  return {
    stages: state.stages.list,
    operators: state.stages.operators
  };
};

var stage_list_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    getStages: function getStages(deliveryId) {
      dispatch(loadStages(deliveryId));
    },
    onAddStage: function onAddStage() {
      dispatch(stage_actions_addStage());
    },
    onAddCondition: function onAddCondition(transitionId, groupId) {
      dispatch(addCondition(transitionId, groupId));
    },
    onAddTransition: function onAddTransition(stageId) {
      dispatch(transition_actions_addTransition(stageId));
    },
    onDeleteStage: function onDeleteStage(stageId) {
      dispatch(stage_actions_deleteStage(stageId));
    },
    onDeleteCondition: function onDeleteCondition(transitionId, conditionId) {
      dispatch(deleteCondition(transitionId, conditionId));
    },
    onDeleteTransition: function onDeleteTransition(transitionId) {
      dispatch(transition_actions_deleteTransition(transitionId));
    },
    onToggleOperator: function onToggleOperator(transitionId) {
      dispatch(toggleConditionOperator(transitionId));
    },
    onUpdateCondition: function onUpdateCondition(transitionId, conditionId, change) {
      dispatch(transition_actions_updateCondition(transitionId, conditionId, change));
    },
    onUpdateTransition: function onUpdateTransition(transitionId, stageId, title) {
      return dispatch(transition_actions_updateTransition(transitionId, stageId, title));
    },
    onUpdateStage: function onUpdateStage(stageId, title) {
      dispatch(editStage(stageId, title));
    }
  };
};

/* harmony default export */ var stage_list_container = (Object(es["connect"])(stage_list_container_mapStateToProps, stage_list_container_mapDispatchToProps)(stage_list_component_DefStageListComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-flow.page.js







function delivery_pattern_flow_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_flow_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_flow_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }








var delivery_pattern_flow_page_PatternFlowPage = /*#__PURE__*/function (_Component) {
  inherits_default()(PatternFlowPage, _Component);

  var _super = delivery_pattern_flow_page_createSuper(PatternFlowPage);

  function PatternFlowPage() {
    classCallCheck_default()(this, PatternFlowPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(PatternFlowPage, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          delivery = _this$props.delivery,
          isEditable = _this$props.isEditable;
      return /*#__PURE__*/react_default.a.createElement(es["Provider"], {
        store: deliveries_store_store
      }, /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement("div", {
        className: "def-flow-subheader"
      }, /*#__PURE__*/react_default.a.createElement("h4", {
        className: "page-title"
      }, "Delivery flow")), /*#__PURE__*/react_default.a.createElement(stage_list_container, {
        deliveryId: delivery.id,
        isEditable: isEditable
      })));
    }
  }]);

  return PatternFlowPage;
}(react["Component"]);

defineProperty_default()(delivery_pattern_flow_page_PatternFlowPage, "propTypes", {
  delivery: prop_types_default.a.any.isRequired,
  isEditable: prop_types_default.a.bool.isRequired
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/stage/stage-list-header.component.js







function stage_list_header_component_createSuper(Derived) { var hasNativeReflectConstruct = stage_list_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function stage_list_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var stage_list_header_component_StageListHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(StageListHeaderComponent, _Component);

  var _super = stage_list_header_component_createSuper(StageListHeaderComponent);

  function StageListHeaderComponent() {
    classCallCheck_default()(this, StageListHeaderComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(StageListHeaderComponent, [{
    key: "renderAddStageButton",
    value: function renderAddStageButton() {
      return /*#__PURE__*/react_default.a.createElement("button", {
        className: "button",
        "data-cy": "btn-stage-add",
        onClick: this.props.onAddStage,
        style: {
          marginRight: '15px'
        }
      }, "Add stage");
    }
  }, {
    key: "renderAddCreateDeliveryButton",
    value: function renderAddCreateDeliveryButton(isDisabled) {
      return /*#__PURE__*/react_default.a.createElement(components["b" /* ButtonWithPopover */], {
        buttonClassName: 'primary',
        content: 'You require at least one stage to create a new delivery.',
        isDisabled: isDisabled,
        isTooltipVisible: isDisabled,
        label: 'New delivery',
        onActionClick: this.props.onCreateDelivery,
        placement: 'bottom'
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          canAddStage = _this$props.canAddStage,
          canCreateDelivery = _this$props.canCreateDelivery,
          isCreateDeliveryDisabled = _this$props.isCreateDeliveryDisabled;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "buttons"
      }, canAddStage && this.renderAddStageButton(), canCreateDelivery && this.renderAddCreateDeliveryButton(isCreateDeliveryDisabled), /*#__PURE__*/react_default.a.createElement(components["d" /* DocLink */], {
        section: "delivery-patterns.html"
      }));
    }
  }]);

  return StageListHeaderComponent;
}(react["Component"]);

defineProperty_default()(stage_list_header_component_StageListHeaderComponent, "propTypes", {
  canAddStage: prop_types_default.a.bool.isRequired,
  canCreateDelivery: prop_types_default.a.bool.isRequired,
  isCreateDeliveryDisabled: prop_types_default.a.bool.isRequired,
  onAddStage: prop_types_default.a.func.isRequired,
  onCreateDelivery: prop_types_default.a.func.isRequired
});


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/stage-list-header.container.js





var stage_list_header_container_mapStateToProps = function mapStateToProps(state) {
  return {
    isCreateDeliveryDisabled: state.stages.isCreateDeliveryDisabled
  };
};

var stage_list_header_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    onAddStage: function onAddStage() {
      return dispatch(stage_actions_addStage());
    },
    onCreateDelivery: function onCreateDelivery() {
      return dispatch(createDeliveryForm());
    }
  };
};

/* harmony default export */ var stage_list_header_container = (Object(es["connect"])(stage_list_header_container_mapStateToProps, stage_list_header_container_mapDispatchToProps)(stage_list_header_component_StageListHeaderComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-flow-header.page.js







function delivery_pattern_flow_header_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_flow_header_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_flow_header_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }







var delivery_pattern_flow_header_page_PatternFlowHeaderPage = /*#__PURE__*/function (_Component) {
  inherits_default()(PatternFlowHeaderPage, _Component);

  var _super = delivery_pattern_flow_header_page_createSuper(PatternFlowHeaderPage);

  function PatternFlowHeaderPage() {
    classCallCheck_default()(this, PatternFlowHeaderPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(PatternFlowHeaderPage, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          canAddStage = _this$props.canAddStage,
          canCreateDelivery = _this$props.canCreateDelivery;
      return /*#__PURE__*/react_default.a.createElement(es["Provider"], {
        store: deliveries_store_store
      }, /*#__PURE__*/react_default.a.createElement(stage_list_header_container, {
        canAddStage: canAddStage,
        canCreateDelivery: canCreateDelivery
      }));
    }
  }]);

  return PatternFlowHeaderPage;
}(react["Component"]);

defineProperty_default()(delivery_pattern_flow_header_page_PatternFlowHeaderPage, "propTypes", {
  canAddStage: prop_types_default.a.bool.isRequired,
  canCreateDelivery: prop_types_default.a.bool.isRequired
});


// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-sub-header-label.component.less
var delivery_pattern_sub_header_label_component = __webpack_require__(2217);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-sub-header-label.component.js






function delivery_pattern_sub_header_label_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_sub_header_label_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_sub_header_label_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }




var delivery_pattern_sub_header_label_component_DeliveryPatternSubHeaderLabelComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternSubHeaderLabelComponent, _Component);

  var _super = delivery_pattern_sub_header_label_component_createSuper(DeliveryPatternSubHeaderLabelComponent);

  function DeliveryPatternSubHeaderLabelComponent() {
    classCallCheck_default()(this, DeliveryPatternSubHeaderLabelComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryPatternSubHeaderLabelComponent, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "pattern-sub-header text-center"
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon pattern-icon"
      }), /*#__PURE__*/react_default.a.createElement("strong", null, "PATTERN"));
    }
  }]);

  return DeliveryPatternSubHeaderLabelComponent;
}(react["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/index.js
















/* harmony default export */ var include_delivery_patterns = (angular.module('xlrelease.deliveryPatterns', []).component('deliveryPatternListHeader', Object(react2angular["react2angular"])(delivery_pattern_list_header_page_DeliveryPatternListHeaderPage)).component('deliveryPatternList', Object(react2angular["react2angular"])(delivery_pattern_list_page_DeliveryPatternListPage)).component('deliveryPatternForm', Object(react2angular["react2angular"])(delivery_pattern_form_page_DeliveryPatternFormPage)).component('deliveryPatternCreateHeader', Object(react2angular["react2angular"])(delivery_pattern_create_header_page_DeliveryPatternListHeaderPage)).component('folderDeliveryPatterns', folders_delivery_patterns).component('patternTrackedItems', Object(react2angular["react2angular"])(tracked_item_page_TrackedItemsPage)).component('patternTrackedItemsHeader', Object(react2angular["react2angular"])(tracked_item_header_page_TrackedItemHeaderPage)).component('deliveryPatternPropertiesHeader', Object(react2angular["react2angular"])(delivery_pattern_properties_header_page_DeliveryPatternPropertiesHeaderPage)).component('patternFlow', Object(react2angular["react2angular"])(delivery_pattern_flow_page_PatternFlowPage)).component('patternSubHeaderLabel', Object(react2angular["react2angular"])(delivery_pattern_sub_header_label_component_DeliveryPatternSubHeaderLabelComponent)).component('patternFlowHeader', Object(react2angular["react2angular"])(delivery_pattern_flow_header_page_PatternFlowHeaderPage)).config(['$stateProvider', function ($stateProvider) {
  $stateProvider.state('deliveryPatternsDetails', {
    url: '/delivery-patterns/{deliveryId: DeliveryId}',
    template: delivery_details_page_extension_container,
    controller: deliveries_details_page_extension_controller_DeliveryDetailsPageExtensionController,
    controllerAs: 'deliveryDetailsPageExtension',
    resolve: {
      deliveryPromise: ['$stateParams', function ($stateParams) {
        return delivery_pattern_service_fetchDeliveryPattern($stateParams.deliveryId);
      }]
    }
  }).state('deliveryPatternsDetailsPageExtension', {
    url: '/delivery-patterns/{deliveryId: DeliveryId}/:extensionPath',
    template: delivery_details_page_extension_container,
    controller: deliveries_details_page_extension_controller_DeliveryDetailsPageExtensionController,
    controllerAs: 'deliveryDetailsPageExtension',
    resolve: {
      deliveryPromise: ['$stateParams', function ($stateParams) {
        return delivery_pattern_service_fetchDeliveryPattern($stateParams.deliveryId);
      }]
    }
  });
}]).name);
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/index.js






/***/ }),

/***/ 2268:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/react2angular/index.js
var react2angular = __webpack_require__(64);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/classCallCheck.js
var classCallCheck = __webpack_require__(4);
var classCallCheck_default = /*#__PURE__*/__webpack_require__.n(classCallCheck);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/createClass.js
var createClass = __webpack_require__(5);
var createClass_default = /*#__PURE__*/__webpack_require__.n(createClass);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/inherits.js
var inherits = __webpack_require__(12);
var inherits_default = /*#__PURE__*/__webpack_require__.n(inherits);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js
var possibleConstructorReturn = __webpack_require__(11);
var possibleConstructorReturn_default = /*#__PURE__*/__webpack_require__.n(possibleConstructorReturn);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/getPrototypeOf.js
var getPrototypeOf = __webpack_require__(9);
var getPrototypeOf_default = /*#__PURE__*/__webpack_require__.n(getPrototypeOf);

// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__(0);
var react_default = /*#__PURE__*/__webpack_require__.n(react);

// EXTERNAL MODULE: ./node_modules/react-redux/es/index.js + 22 modules
var es = __webpack_require__(30);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/typeof.js
var helpers_typeof = __webpack_require__(86);
var typeof_default = /*#__PURE__*/__webpack_require__.n(helpers_typeof);

// EXTERNAL MODULE: ./node_modules/redux/es/redux.js
var redux = __webpack_require__(55);

// EXTERNAL MODULE: ./node_modules/redux-saga/dist/redux-saga-core-npm-proxy.esm.js + 2 modules
var redux_saga_core_npm_proxy_esm = __webpack_require__(147);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/regenerator/index.js
var regenerator = __webpack_require__(8);
var regenerator_default = /*#__PURE__*/__webpack_require__.n(regenerator);

// EXTERNAL MODULE: ./node_modules/redux-saga/dist/redux-saga-effects-npm-proxy.esm.js + 1 modules
var redux_saga_effects_npm_proxy_esm = __webpack_require__(3);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/toastrFactory.js
var toastrFactory = __webpack_require__(51);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/actions/environment-actions.js
var actionTypes = {
  ENVIRONMENTS_SEARCH_REQUEST: 'envMgmt/ENVIRONMENTS_SEARCH_REQUEST',
  ENVIRONMENTS_SEARCH_SUCCESS: 'envMgmt/ENVIRONMENTS_SEARCH_SUCCESS',
  ENVIRONMENTS_SEARCH_FAILURE: 'envMgmt/ENVIRONMENTS_SEARCH_FAILURE',
  ENVIRONMENT_ADD: 'envMgmt/ENVIRONMENT_ADD',
  ENVIRONMENT_EDIT: 'envMgmt/ENVIRONMENT_EDIT',
  ENVIRONMENT_DELETE_REQUEST: 'envMgmt/ENVIRONMENT_DELETE_REQUEST',
  ENVIRONMENT_DELETE_SUCCESS: 'envMgmt/ENVIRONMENT_DELETE_SUCCESS',
  ENVIRONMENT_DELETE_FAILURE: 'envMgmt/ENVIRONMENT_DELETE_FAILURE',
  INIT_ENVIRONMENT_LIST: 'envMgmt/INIT_ENVIRONMENT_LIST',
  INIT_ENVIRONMENT_LIST_SUCCESS: 'envMgmt/INIT_ENVIRONMENT_LIST_SUCCESS',
  INIT_ENVIRONMENT_LIST_FAILURE: 'envMgmt/INIT_ENVIRONMENT_LIST_FAILURE',
  TITLE_FILTER_CHANGE: 'envMgmt/TITLE_FILTER_CHANGE',
  STAGE_FILTER_CHANGE: 'envMgmt/STAGE_FILTER_CHANGE'
};
var environment_actions_onAddEnvironment = function onAddEnvironment() {
  return {
    type: actionTypes.ENVIRONMENT_ADD
  };
};
var environment_actions_onEditEnvironment = function onEditEnvironment(environment) {
  return {
    type: actionTypes.ENVIRONMENT_EDIT,
    payload: environment
  };
};
var searchEnvironments = function searchEnvironments(_ref) {
  var title = _ref.title,
      stageTitle = _ref.stageTitle;
  return {
    type: actionTypes.ENVIRONMENTS_SEARCH_REQUEST,
    payload: {
      title: title,
      stageTitle: stageTitle
    }
  };
};
var environment_actions_onDeleteEnvironment = function onDeleteEnvironment(environment) {
  return {
    type: actionTypes.ENVIRONMENT_DELETE_REQUEST,
    payload: environment
  };
};
var initEnvironmentList = function initEnvironmentList() {
  return {
    type: actionTypes.INIT_ENVIRONMENT_LIST
  };
};
var initEnvironmentListSuccess = function initEnvironmentListSuccess(environments, stages) {
  return {
    type: actionTypes.INIT_ENVIRONMENT_LIST_SUCCESS,
    payload: {
      environments: environments,
      stages: stages
    }
  };
};
var titleFilterChange = function titleFilterChange(title) {
  return {
    type: actionTypes.TITLE_FILTER_CHANGE,
    payload: title
  };
};
var stageFilterChange = function stageFilterChange(stageTitle) {
  return {
    type: actionTypes.STAGE_FILTER_CHANGE,
    payload: stageTitle
  };
};
// EXTERNAL MODULE: ./core/xlr-ui/app/features/common/services/angular-accessor.js
var angular_accessor = __webpack_require__(34);

// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/common/environment-service.js
var environment_service = __webpack_require__(137);

// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/common/stage-service.js
var stage_service = __webpack_require__(155);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/sagas/environment-list-saga.js


var _marked = /*#__PURE__*/regenerator_default.a.mark(search),
    _marked2 = /*#__PURE__*/regenerator_default.a.mark(addEnvironment),
    _marked3 = /*#__PURE__*/regenerator_default.a.mark(editEnvironment),
    _marked4 = /*#__PURE__*/regenerator_default.a.mark(_deleteEnvironment),
    _marked5 = /*#__PURE__*/regenerator_default.a.mark(environment_list_saga_initEnvironmentList),
    _marked6 = /*#__PURE__*/regenerator_default.a.mark(environmentListSaga);







var toastr = Object(toastrFactory["a" /* default */])();
var getFilters = function getFilters(state) {
  return state.environmentList.filters;
};
function search(action) {
  var _action$payload, title, stageTitle, stage, environments;

  return regenerator_default.a.wrap(function search$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _action$payload = action.payload, title = _action$payload.title, stageTitle = _action$payload.stageTitle;
          stage = stageTitle || null;
          _context.prev = 2;
          _context.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["e" /* searchEnvironments */], {
            title: title,
            stage: stage
          });

        case 5:
          environments = _context.sent;
          _context.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: actionTypes.ENVIRONMENTS_SEARCH_SUCCESS,
            payload: environments
          });

        case 8:
          _context.next = 14;
          break;

        case 10:
          _context.prev = 10;
          _context.t0 = _context["catch"](2);
          _context.next = 14;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: actionTypes.ENVIRONMENTS_SEARCH_FAILURE
          });

        case 14:
        case "end":
          return _context.stop();
      }
    }
  }, _marked, null, [[2, 10]]);
}
function addEnvironment() {
  var $state;
  return regenerator_default.a.wrap(function addEnvironment$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _context2.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$state');

        case 2:
          $state = _context2.sent;
          _context2.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])($state.go, 'environmentCreate');

        case 5:
        case "end":
          return _context2.stop();
      }
    }
  }, _marked2);
}
function editEnvironment(action) {
  var $state;
  return regenerator_default.a.wrap(function editEnvironment$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          _context3.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$state');

        case 2:
          $state = _context3.sent;
          _context3.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])($state.go, 'environmentCreate', {
            environmentId: action.payload.id
          });

        case 5:
        case "end":
          return _context3.stop();
      }
    }
  }, _marked3);
}
function _deleteEnvironment(action) {
  var environment, currentFilter;
  return regenerator_default.a.wrap(function _deleteEnvironment$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          environment = action.payload;
          _context4.prev = 1;
          _context4.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["b" /* deleteEnvironment */], environment.id);

        case 4:
          _context4.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: actionTypes.ENVIRONMENT_DELETE_SUCCESS
          });

        case 6:
          _context4.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(toastr.success, "Environment [".concat(environment.title, "] deleted."));

        case 8:
          _context4.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getFilters);

        case 10:
          currentFilter = _context4.sent;
          _context4.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: actionTypes.ENVIRONMENTS_SEARCH_REQUEST,
            payload: currentFilter
          });

        case 13:
          _context4.next = 19;
          break;

        case 15:
          _context4.prev = 15;
          _context4.t0 = _context4["catch"](1);
          _context4.next = 19;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: actionTypes.ENVIRONMENT_DELETE_FAILURE
          });

        case 19:
        case "end":
          return _context4.stop();
      }
    }
  }, _marked4, null, [[1, 15]]);
}
function environment_list_saga_initEnvironmentList() {
  var environments, stages;
  return regenerator_default.a.wrap(function initEnvironmentList$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _context5.prev = 0;
          _context5.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["e" /* searchEnvironments */], {
            title: '',
            stageTitle: ''
          });

        case 3:
          environments = _context5.sent;
          _context5.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_service["c" /* searchStages */]);

        case 6:
          stages = _context5.sent;
          _context5.next = 9;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(initEnvironmentListSuccess(environments, stages));

        case 9:
          _context5.next = 15;
          break;

        case 11:
          _context5.prev = 11;
          _context5.t0 = _context5["catch"](0);
          _context5.next = 15;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: actionTypes.INIT_ENVIRONMENT_LIST_FAILURE
          });

        case 15:
        case "end":
          return _context5.stop();
      }
    }
  }, _marked5, null, [[0, 11]]);
}
function environmentListSaga() {
  return regenerator_default.a.wrap(function environmentListSaga$(_context6) {
    while (1) {
      switch (_context6.prev = _context6.next) {
        case 0:
          _context6.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(actionTypes.ENVIRONMENT_ADD, addEnvironment), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(actionTypes.ENVIRONMENT_EDIT, editEnvironment), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(actionTypes.ENVIRONMENT_DELETE_REQUEST, _deleteEnvironment), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(actionTypes.ENVIRONMENTS_SEARCH_REQUEST, search), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(actionTypes.INIT_ENVIRONMENT_LIST, environment_list_saga_initEnvironmentList)]);

        case 2:
        case "end":
          return _context6.stop();
      }
    }
  }, _marked6);
}
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/slicedToArray.js
var slicedToArray = __webpack_require__(54);
var slicedToArray_default = /*#__PURE__*/__webpack_require__.n(slicedToArray);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/actions/environment-form-actions.js
var environment_form_actions_actionTypes = {
  ENVIRONMENT_EDIT_SAVE_FORM: 'envMgmt/ENVIRONMENT_EDIT_SAVE_FORM',
  ENVIRONMENT_EDIT_CANCEL_FORM: 'envMgmt/ENVIRONMENT_EDIT_CANCEL_FORM',
  ENVIRONMENT_EDIT_CLEAN_FORM: 'envMgmt/ENVIRONMENT_EDIT_CLEAN_FORM',
  ENVIRONMENT_EDIT_VALID_FORM: 'envMgmt/ENVIRONMENT_EDIT_VALID_FORM',
  ENVIRONMENT_EDIT_PRISTINE_FORM: 'envMgmt/ENVIRONMENT_EDIT_PRISTINE_FORM',
  ENVIRONMENT_EDIT_CHANGE_FORM: 'envMgmt/ENVIRONMENT_EDIT_CHANGE_FORM',
  ENVIRONMENT_EDIT_CHECK_LEAVE: 'envMgmt/ENVIRONMENT_EDIT_CHECK_LEAVE',
  ENVIRONMENT_LOAD: 'envMgmt/ENVIRONMENT_LOAD',
  ENVIRONMENT_LOAD_SUCCESS: 'envMgmt/ENVIRONMENT_LOAD_SUCCESS',
  ENVIRONMENT_SEARCH: 'envMgmt/ENVIRONMENT_SEARCH',
  ENVIRONMENT_SEARCH_SUCCESS: 'envMgmt/ENVIRONMENT_SEARCH_SUCCESS',
  INIT_ENVIRONMENT_FORM: 'envMgmt/INIT_ENVIRONMENT_FORM',
  INIT_ENVIRONMENT_FORM_SUCCESS: 'envMgmt/INIT_ENVIRONMENT_FORM_SUCCESS',
  INIT_ENVIRONMENT_FORM_FAILURE: 'envMgmt/INIT_ENVIRONMENT_FORM_FAILURE'
};
var onFormChange = function onFormChange(environment) {
  return {
    type: environment_form_actions_actionTypes.ENVIRONMENT_EDIT_CHANGE_FORM,
    payload: environment
  };
};
var onFormSave = function onFormSave(environment) {
  return {
    type: environment_form_actions_actionTypes.ENVIRONMENT_EDIT_SAVE_FORM,
    payload: environment
  };
};
var environment_form_actions_onFormCancel = function onFormCancel() {
  return {
    type: environment_form_actions_actionTypes.ENVIRONMENT_EDIT_CANCEL_FORM
  };
};
var onFormValidChange = function onFormValidChange(valid) {
  return {
    type: environment_form_actions_actionTypes.ENVIRONMENT_EDIT_VALID_FORM,
    payload: valid
  };
};
var onFormPristineChange = function onFormPristineChange(pristine) {
  return {
    type: environment_form_actions_actionTypes.ENVIRONMENT_EDIT_PRISTINE_FORM,
    payload: pristine
  };
};
var cleanEnvironment = function cleanEnvironment() {
  return {
    type: environment_form_actions_actionTypes.ENVIRONMENT_EDIT_CHECK_LEAVE
  };
};
var loadEnvironment = function loadEnvironment(environmentId) {
  return {
    type: environment_form_actions_actionTypes.ENVIRONMENT_LOAD,
    payload: environmentId
  };
};
var environment_form_actions_searchEnvironments = function searchEnvironments(title) {
  return {
    type: environment_form_actions_actionTypes.ENVIRONMENT_SEARCH,
    payload: title
  };
};
var initEnvironmentForm = function initEnvironmentForm(environmentId) {
  return {
    type: environment_form_actions_actionTypes.INIT_ENVIRONMENT_FORM,
    payload: environmentId
  };
};
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/actions/stage-actions.js
var stage_actions_actionTypes = {
  STAGE_SEARCH: 'envMgmt/STAGE_SEARCH',
  STAGE_SEARCH_SUCCESS: 'envMgmt/STAGE_SEARCH_SUCCESS',
  STAGE_SEARCH_FAILURE: 'envMgmt/STAGE_SEARCH_FAILURE',
  DELETE_STAGE: 'envMgmt/STAGE_DELETE_STAGE',
  DELETE_STAGE_SUCCESS: 'envMgmt/DELETE_STAGE_SUCCESS',
  DELETE_STAGE_FAILURE: 'envMgmt/DELETE_STAGE_FAILURE',
  SAVE_STAGE: 'envMgmt/STAGE_SAVE_STAGE',
  SAVE_STAGE_SUCCESS: 'envMgmt/SAVE_STAGE_SUCCESS',
  SAVE_STAGE_FAILURE: 'envMgmt/SAVE_STAGE_FAILURE'
};
var searchStages = function searchStages(title) {
  return {
    type: stage_actions_actionTypes.STAGE_SEARCH,
    payload: title
  };
};
var deleteStage = function deleteStage(stage) {
  return {
    type: stage_actions_actionTypes.DELETE_STAGE,
    payload: stage
  };
};
var stage_actions_saveStage = function saveStage(stage) {
  return {
    type: stage_actions_actionTypes.SAVE_STAGE,
    payload: stage
  };
};
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/actions/label-actions.js
var label_actions_actionTypes = {
  LABEL_SEARCH: 'envMgmt/LABEL_SEARCH',
  LABEL_SEARCH_SUCCESS: 'envMgmt/LABEL_SEARCH_SUCCESS',
  LABEL_SEARCH_FAILURE: 'envMgmt/LABEL_SEARCH_FAILURE',
  SAVE_LABEL: 'envMgmt/LABEL_SAVE_LABEL',
  SAVE_LABEL_SUCCESS: 'envMgmt/SAVE_LABEL_SUCCESS',
  SAVE_LABEL_FAILURE: 'envMgmt/SAVE_LABEL_FAILURE',
  DELETE_LABEL: 'envMgmt/DELETE_LABEL_LABEL',
  DELETE_LABEL_SUCCESS: 'envMgmt/DELETE_LABEL_SUCCESS',
  DELETE_LABEL_FAILURE: 'envMgmt/DELETE_LABEL_FAILURE'
};
var searchLabels = function searchLabels(title) {
  return {
    type: label_actions_actionTypes.LABEL_SEARCH,
    payload: title
  };
};
var label_actions_saveLabel = function saveLabel(envType) {
  return {
    type: label_actions_actionTypes.SAVE_LABEL,
    payload: envType
  };
};
var deleteLabel = function deleteLabel(envType) {
  return {
    type: label_actions_actionTypes.DELETE_LABEL,
    payload: envType
  };
};
// EXTERNAL MODULE: ./node_modules/lodash/isEmpty.js
var isEmpty = __webpack_require__(59);
var isEmpty_default = /*#__PURE__*/__webpack_require__.n(isEmpty);

// EXTERNAL MODULE: ./node_modules/lodash/map.js
var map = __webpack_require__(66);
var map_default = /*#__PURE__*/__webpack_require__.n(map);

// EXTERNAL MODULE: ./core/xlr-ui/app/react/utils/sagas.js
var sagas = __webpack_require__(108);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/sagas/environment-form-saga.js



var environment_form_saga_marked = /*#__PURE__*/regenerator_default.a.mark(save),
    environment_form_saga_marked2 = /*#__PURE__*/regenerator_default.a.mark(cancel),
    environment_form_saga_marked3 = /*#__PURE__*/regenerator_default.a.mark(environment_form_saga_initEnvironmentForm),
    environment_form_saga_marked4 = /*#__PURE__*/regenerator_default.a.mark(environment_form_saga_cleanEnvironment),
    environment_form_saga_marked5 = /*#__PURE__*/regenerator_default.a.mark(environmentFormSaga);











var cleanFormFields = {
  type: environment_form_actions_actionTypes.ENVIRONMENT_EDIT_CLEAN_FORM
};
var environment_form_saga_toastr = Object(toastrFactory["a" /* default */])();
function save(action) {
  var $state, environment, environmentForm;
  return regenerator_default.a.wrap(function save$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 3:
          _context.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$state');

        case 5:
          $state = _context.sent;
          environment = action.payload;
          environmentForm = {
            title: environment.title,
            stageId: environment.stage.id,
            description: environment.description,
            labelIds: map_default()(environment.labels, 'id')
          };

          if (!isEmpty_default()(environment.id)) {
            _context.next = 15;
            break;
          }

          _context.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["a" /* createEnvironment */], environmentForm);

        case 11:
          _context.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_form_saga_toastr.success, "Environment [".concat(environment.title, "] created"));

        case 13:
          _context.next = 19;
          break;

        case 15:
          _context.next = 17;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["f" /* updateEnvironment */], environment.id, environmentForm);

        case 17:
          _context.next = 19;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_form_saga_toastr.success, "Environment [".concat(environment.title, "] updated"));

        case 19:
          _context.next = 21;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])($state.go, 'environmentList');

        case 21:
          _context.next = 27;
          break;

        case 23:
          _context.prev = 23;
          _context.t0 = _context["catch"](0);
          _context.next = 27;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(console.error, 'Environment form saga:', _context.t0);

        case 27:
          _context.prev = 27;
          _context.next = 30;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(cleanFormFields);

        case 30:
          return _context.finish(27);

        case 31:
        case "end":
          return _context.stop();
      }
    }
  }, environment_form_saga_marked, null, [[0, 23, 27, 31]]);
}
function cancel() {
  var $state;
  return regenerator_default.a.wrap(function cancel$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _context2.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 2:
          _context2.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$state');

        case 4:
          $state = _context2.sent;
          _context2.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])($state.go, 'environmentList');

        case 7:
          _context2.next = 9;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(cleanFormFields);

        case 9:
        case "end":
          return _context2.stop();
      }
    }
  }, environment_form_saga_marked2);
}
function environment_form_saga_initEnvironmentForm(_ref) {
  var environmentId, _yield$all, _yield$all2, environments, environment, _environments;

  return regenerator_default.a.wrap(function initEnvironmentForm$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          environmentId = _ref.payload;
          _context3.prev = 1;

          if (!environmentId) {
            _context3.next = 13;
            break;
          }

          _context3.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["e" /* searchEnvironments */], {}), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["d" /* loadEnvironment */], environmentId)]);

        case 5:
          _yield$all = _context3.sent;
          _yield$all2 = slicedToArray_default()(_yield$all, 2);
          environments = _yield$all2[0];
          environment = _yield$all2[1];
          _context3.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: environment_form_actions_actionTypes.INIT_ENVIRONMENT_FORM_SUCCESS,
            payload: {
              environment: environment,
              environments: environments
            }
          });

        case 11:
          _context3.next = 18;
          break;

        case 13:
          _context3.next = 15;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["e" /* searchEnvironments */], {});

        case 15:
          _environments = _context3.sent;
          _context3.next = 18;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: environment_form_actions_actionTypes.INIT_ENVIRONMENT_FORM_SUCCESS,
            payload: {
              environments: _environments
            }
          });

        case 18:
          _context3.next = 20;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(searchStages(null));

        case 20:
          _context3.next = 22;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(searchLabels(null));

        case 22:
          _context3.next = 28;
          break;

        case 24:
          _context3.prev = 24;
          _context3.t0 = _context3["catch"](1);
          _context3.next = 28;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: environment_form_actions_actionTypes.INIT_ENVIRONMENT_FORM_FAILURE
          });

        case 28:
        case "end":
          return _context3.stop();
      }
    }
  }, environment_form_saga_marked3, null, [[1, 24]]);
}
function environment_form_saga_cleanEnvironment() {
  return regenerator_default.a.wrap(function cleanEnvironment$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _context4.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 2:
          _context4.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(cleanFormFields);

        case 4:
        case "end":
          return _context4.stop();
      }
    }
  }, environment_form_saga_marked4);
}
function environmentFormSaga() {
  return regenerator_default.a.wrap(function environmentFormSaga$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _context5.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(environment_form_actions_actionTypes.ENVIRONMENT_EDIT_CANCEL_FORM, cancel), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(environment_form_actions_actionTypes.ENVIRONMENT_EDIT_SAVE_FORM, save), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(environment_form_actions_actionTypes.INIT_ENVIRONMENT_FORM, environment_form_saga_initEnvironmentForm), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(environment_form_actions_actionTypes.ENVIRONMENT_EDIT_PRISTINE_FORM, sagas["a" /* addConfirmLeavePopup */]), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(environment_form_actions_actionTypes.ENVIRONMENT_EDIT_CHECK_LEAVE, environment_form_saga_cleanEnvironment)]);

        case 2:
        case "end":
          return _context5.stop();
      }
    }
  }, environment_form_saga_marked5);
}
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/sagas/stage-saga.js


var stage_saga_marked = /*#__PURE__*/regenerator_default.a.mark(_searchStages),
    stage_saga_marked2 = /*#__PURE__*/regenerator_default.a.mark(_saveStage),
    stage_saga_marked3 = /*#__PURE__*/regenerator_default.a.mark(_deleteStage),
    stage_saga_marked4 = /*#__PURE__*/regenerator_default.a.mark(stageSaga);






var stage_saga_toastr = Object(toastrFactory["a" /* default */])();
function _searchStages(action) {
  var stages;
  return regenerator_default.a.wrap(function _searchStages$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_service["c" /* searchStages */], action.payload);

        case 3:
          stages = _context.sent;
          _context.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: stage_actions_actionTypes.STAGE_SEARCH_SUCCESS,
            payload: stages
          });

        case 6:
          _context.next = 12;
          break;

        case 8:
          _context.prev = 8;
          _context.t0 = _context["catch"](0);
          _context.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: stage_actions_actionTypes.STAGE_SEARCH_FAILURE
          });

        case 12:
        case "end":
          return _context.stop();
      }
    }
  }, stage_saga_marked, null, [[0, 8]]);
}
function _saveStage(action) {
  var stage;
  return regenerator_default.a.wrap(function _saveStage$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          stage = action.payload;
          _context2.prev = 1;

          if (!isEmpty_default()(stage.id)) {
            _context2.next = 9;
            break;
          }

          _context2.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_service["a" /* createStage */], stage);

        case 5:
          _context2.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_saga_toastr.success, "Stage [".concat(stage.title, "] created"));

        case 7:
          _context2.next = 13;
          break;

        case 9:
          _context2.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_service["d" /* updateStage */], stage.id, stage);

        case 11:
          _context2.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_saga_toastr.success, "Stage [".concat(stage.title, "] updated"));

        case 13:
          _context2.next = 15;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: stage_actions_actionTypes.SAVE_STAGE_SUCCESS
          });

        case 15:
          _context2.next = 21;
          break;

        case 17:
          _context2.prev = 17;
          _context2.t0 = _context2["catch"](1);
          _context2.next = 21;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: stage_actions_actionTypes.SAVE_STAGE_FAILURE
          });

        case 21:
        case "end":
          return _context2.stop();
      }
    }
  }, stage_saga_marked2, null, [[1, 17]]);
}
function _deleteStage(action) {
  var stage;
  return regenerator_default.a.wrap(function _deleteStage$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          stage = action.payload;
          _context3.prev = 1;
          _context3.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_service["b" /* deleteStage */], stage.id);

        case 4:
          _context3.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_saga_toastr.success, "Stage [".concat(stage.title, "] deleted"));

        case 6:
          _context3.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: stage_actions_actionTypes.DELETE_STAGE_SUCCESS
          });

        case 8:
          _context3.next = 14;
          break;

        case 10:
          _context3.prev = 10;
          _context3.t0 = _context3["catch"](1);
          _context3.next = 14;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: stage_actions_actionTypes.DELETE_STAGE_FAILURE
          });

        case 14:
        case "end":
          return _context3.stop();
      }
    }
  }, stage_saga_marked3, null, [[1, 10]]);
}
function stageSaga() {
  return regenerator_default.a.wrap(function stageSaga$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _context4.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(stage_actions_actionTypes.SAVE_STAGE, _saveStage), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(stage_actions_actionTypes.DELETE_STAGE, _deleteStage), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])([stage_actions_actionTypes.STAGE_SEARCH, stage_actions_actionTypes.DELETE_STAGE_SUCCESS, stage_actions_actionTypes.SAVE_STAGE_SUCCESS], _searchStages)]);

        case 2:
        case "end":
          return _context4.stop();
      }
    }
  }, stage_saga_marked4);
}
// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/common/label-service.js
var label_service = __webpack_require__(216);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/sagas/label-saga.js


var label_saga_marked = /*#__PURE__*/regenerator_default.a.mark(_searchLabels),
    label_saga_marked2 = /*#__PURE__*/regenerator_default.a.mark(_saveLabel),
    label_saga_marked3 = /*#__PURE__*/regenerator_default.a.mark(_deleteLabel),
    label_saga_marked4 = /*#__PURE__*/regenerator_default.a.mark(labelSaga);






var label_saga_toastr = Object(toastrFactory["a" /* default */])();
function _searchLabels(action) {
  var labels;
  return regenerator_default.a.wrap(function _searchLabels$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(label_service["c" /* searchLabels */], action.payload);

        case 3:
          labels = _context.sent;
          _context.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: label_actions_actionTypes.LABEL_SEARCH_SUCCESS,
            payload: labels
          });

        case 6:
          _context.next = 12;
          break;

        case 8:
          _context.prev = 8;
          _context.t0 = _context["catch"](0);
          _context.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: label_actions_actionTypes.LABEL_SEARCH_FAILURE
          });

        case 12:
        case "end":
          return _context.stop();
      }
    }
  }, label_saga_marked, null, [[0, 8]]);
}
function _saveLabel(action) {
  var envLabel;
  return regenerator_default.a.wrap(function _saveLabel$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          envLabel = action.payload;
          _context2.prev = 1;

          if (!isEmpty_default()(envLabel.id)) {
            _context2.next = 9;
            break;
          }

          _context2.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(label_service["a" /* createLabel */], envLabel);

        case 5:
          _context2.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(label_saga_toastr.success, "Label [".concat(envLabel.title, "] created"));

        case 7:
          _context2.next = 13;
          break;

        case 9:
          _context2.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(label_service["d" /* updateLabel */], envLabel.id, envLabel);

        case 11:
          _context2.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(label_saga_toastr.success, "Label [".concat(envLabel.title, "] updated"));

        case 13:
          _context2.next = 15;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: label_actions_actionTypes.SAVE_LABEL_SUCCESS
          });

        case 15:
          _context2.next = 21;
          break;

        case 17:
          _context2.prev = 17;
          _context2.t0 = _context2["catch"](1);
          _context2.next = 21;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: label_actions_actionTypes.SAVE_LABEL_FAILURE
          });

        case 21:
        case "end":
          return _context2.stop();
      }
    }
  }, label_saga_marked2, null, [[1, 17]]);
}
function _deleteLabel(action) {
  var envLabel;
  return regenerator_default.a.wrap(function _deleteLabel$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          envLabel = action.payload;
          _context3.prev = 1;
          _context3.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(label_service["b" /* deleteLabel */], envLabel.id);

        case 4:
          _context3.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(label_saga_toastr.success, "Label [".concat(envLabel.title, "] deleted"));

        case 6:
          _context3.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: label_actions_actionTypes.DELETE_LABEL_SUCCESS
          });

        case 8:
          _context3.next = 14;
          break;

        case 10:
          _context3.prev = 10;
          _context3.t0 = _context3["catch"](1);
          _context3.next = 14;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: label_actions_actionTypes.DELETE_LABEL_FAILURE
          });

        case 14:
        case "end":
          return _context3.stop();
      }
    }
  }, label_saga_marked3, null, [[1, 10]]);
}
function labelSaga() {
  return regenerator_default.a.wrap(function labelSaga$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _context4.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(label_actions_actionTypes.SAVE_LABEL, _saveLabel), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(label_actions_actionTypes.DELETE_LABEL, _deleteLabel), Object(redux_saga_effects_npm_proxy_esm["m" /* throttle */])(200, [label_actions_actionTypes.LABEL_SEARCH, label_actions_actionTypes.SAVE_LABEL_SUCCESS, label_actions_actionTypes.DELETE_LABEL_SUCCESS], _searchLabels)]);

        case 2:
        case "end":
          return _context4.stop();
      }
    }
  }, label_saga_marked4);
}
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/actions/application-actions.js
var application_actions_actionTypes = {
  APPLICATION_SEARCH_REQUEST: 'envMgmt/APPLICATION_SEARCH_REQUEST',
  APPLICATION_SEARCH_SUCCESS: 'envMgmt/APPLICATION_SEARCH_SUCCESS',
  APPLICATION_SEARCH_FAILURE: 'envMgmt/APPLICATION_SEARCH_FAILURE',
  APPLICATION_GOTO_CREATE_PAGE: 'envMgmt/APPLICATION_GOTO_CREATE_PAGE',
  APPLICATION_GOTO_EDIT_PAGE: 'envMgmt/APPLICATION_GOTO_EDIT_PAGE',
  APPLICATION_DELETE_REQUEST: 'envMgmt/APPLICATION_DELETE_REQUEST',
  APPLICATION_DELETE_SUCCESS: 'envMgmt/APPLICATION_DELETE_SUCCESS',
  APPLICATION_DELETE_FAILURE: 'envMgmt/APPLICATION_DELETE_FAILURE',
  APPLICATION_FORM_CANCEL: 'envMgmt/APPLICATION_FORM_CANCEL',
  APPLICATION_FORM_CLEAN: 'envMgmt/APPLICATION_FORM_CLEAN',
  APPLICATION_FORM_INIT: 'envMgmt/APPLICATION_FORM_INIT',
  APPLICATION_FORM_FAILURE: 'envMgmt/APPLICATION_FORM_FAILURE',
  APPLICATION_LOAD_REQUEST: 'envMgmt/APPLICATION_LOAD_REQUEST',
  APPLICATION_LOAD_SUCCESS: 'envMgmt/APPLICATION_LOAD_SUCCESS',
  APPLICATION_ENV_LOAD_SUCCESS: 'envMgmt/APPLICATION_ENV_LOAD_SUCCESS',
  APPLICATION_STAGE_LOAD_SUCCESS: 'envMgmt/APPLICATION_STAGE_LOAD_SUCCESS',
  APPLICATION_LIST_LOAD_SUCCESS: 'envMgmt/APPLICATION_LIST_LOAD_SUCCESS',
  APPLICATION_FORM_UPDATE_MODEL: 'envMgmt/APPLICATION_FORM_UPDATE_MODEL',
  APPLICATION_FORM_PRISTINE: 'envMgmt/APPLICATION_FORM_PRISTINE',
  APPLICATION_SAVE_REQUEST: 'envMgmt/APPLICATION_SAVE_REQUEST',
  APPLICATION_SAVE_FAILURE: 'envMgmt/APPLICATION_SAVE_FAILURE'
};
var application_actions_applicationList = {
  searchApplications: function searchApplications(applicationName) {
    return {
      type: application_actions_actionTypes.APPLICATION_SEARCH_REQUEST,
      payload: applicationName
    };
  },
  goToCreatePage: function goToCreatePage() {
    return {
      type: application_actions_actionTypes.APPLICATION_GOTO_CREATE_PAGE
    };
  },
  goToEditPage: function goToEditPage(application) {
    return {
      type: application_actions_actionTypes.APPLICATION_GOTO_EDIT_PAGE,
      payload: application
    };
  },
  deleteApplication: function deleteApplication(application) {
    return {
      type: application_actions_actionTypes.APPLICATION_DELETE_REQUEST,
      payload: application
    };
  }
};
var applicationForm = {
  initForm: function initForm(applicationId) {
    return {
      type: application_actions_actionTypes.APPLICATION_FORM_INIT,
      payload: applicationId
    };
  },
  cancelForm: function cancelForm() {
    return {
      type: application_actions_actionTypes.APPLICATION_FORM_CANCEL
    };
  },
  saveApplication: function saveApplication(application) {
    return {
      type: application_actions_actionTypes.APPLICATION_SAVE_REQUEST,
      payload: application
    };
  },
  updateModel: function updateModel(application) {
    return {
      type: application_actions_actionTypes.APPLICATION_FORM_UPDATE_MODEL,
      payload: application
    };
  },
  pristineFormChange: function pristineFormChange(pristine) {
    return {
      type: application_actions_actionTypes.APPLICATION_FORM_PRISTINE,
      payload: pristine
    };
  }
};
// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/common/application-service.js
var application_service = __webpack_require__(167);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/sagas/application-list-saga.js


var application_list_saga_marked = /*#__PURE__*/regenerator_default.a.mark(searchApplications),
    application_list_saga_marked2 = /*#__PURE__*/regenerator_default.a.mark(goToApplicationCreate),
    application_list_saga_marked3 = /*#__PURE__*/regenerator_default.a.mark(goToApplicationEdit),
    application_list_saga_marked4 = /*#__PURE__*/regenerator_default.a.mark(deleteApplication),
    application_list_saga_marked5 = /*#__PURE__*/regenerator_default.a.mark(applicationListSaga);






var application_list_saga_toastr = Object(toastrFactory["a" /* default */])();
function searchApplications(action) {
  var applications;
  return regenerator_default.a.wrap(function searchApplications$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_service["d" /* searchApp */], action.payload);

        case 3:
          applications = _context.sent;
          _context.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_SEARCH_SUCCESS,
            payload: applications
          });

        case 6:
          _context.next = 12;
          break;

        case 8:
          _context.prev = 8;
          _context.t0 = _context["catch"](0);
          _context.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_SEARCH_FAILURE
          });

        case 12:
        case "end":
          return _context.stop();
      }
    }
  }, application_list_saga_marked, null, [[0, 8]]);
}
function goToApplicationCreate() {
  var $state;
  return regenerator_default.a.wrap(function goToApplicationCreate$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _context2.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_FORM_CLEAN
          });

        case 2:
          _context2.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$state');

        case 4:
          $state = _context2.sent;
          _context2.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])($state.go, 'applicationCreate');

        case 7:
        case "end":
          return _context2.stop();
      }
    }
  }, application_list_saga_marked2);
}
function goToApplicationEdit(action) {
  var $state;
  return regenerator_default.a.wrap(function goToApplicationEdit$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          _context3.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_FORM_CLEAN
          });

        case 2:
          _context3.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$state');

        case 4:
          $state = _context3.sent;
          _context3.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])($state.go, 'applicationCreate', {
            applicationId: action.payload.id
          });

        case 7:
        case "end":
          return _context3.stop();
      }
    }
  }, application_list_saga_marked3);
}
function deleteApplication(action) {
  var application;
  return regenerator_default.a.wrap(function deleteApplication$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _context4.prev = 0;
          application = action.payload;
          _context4.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_service["b" /* deleteApp */], application.id);

        case 4:
          _context4.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_DELETE_SUCCESS,
            payload: action.payload
          });

        case 6:
          _context4.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_list_saga_toastr.success, "Deleted application [".concat(application.title, "]"));

        case 8:
          _context4.next = 14;
          break;

        case 10:
          _context4.prev = 10;
          _context4.t0 = _context4["catch"](0);
          _context4.next = 14;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_DELETE_FAILURE
          });

        case 14:
        case "end":
          return _context4.stop();
      }
    }
  }, application_list_saga_marked4, null, [[0, 10]]);
}
function applicationListSaga() {
  return regenerator_default.a.wrap(function applicationListSaga$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _context5.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(application_actions_actionTypes.APPLICATION_GOTO_CREATE_PAGE, goToApplicationCreate);

        case 2:
          _context5.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(application_actions_actionTypes.APPLICATION_GOTO_EDIT_PAGE, goToApplicationEdit);

        case 4:
          _context5.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(application_actions_actionTypes.APPLICATION_DELETE_REQUEST, deleteApplication);

        case 6:
          _context5.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["m" /* throttle */])(200, application_actions_actionTypes.APPLICATION_SEARCH_REQUEST, searchApplications);

        case 8:
        case "end":
          return _context5.stop();
      }
    }
  }, application_list_saga_marked5);
}
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/sagas/application-form-saga.js


var application_form_saga_marked = /*#__PURE__*/regenerator_default.a.mark(initApplicationForm),
    application_form_saga_marked2 = /*#__PURE__*/regenerator_default.a.mark(cancelApplicationForm),
    application_form_saga_marked3 = /*#__PURE__*/regenerator_default.a.mark(updateApplicationModel),
    application_form_saga_marked4 = /*#__PURE__*/regenerator_default.a.mark(saveApplication),
    application_form_saga_marked5 = /*#__PURE__*/regenerator_default.a.mark(applicationFormSaga);










var application_form_saga_toastr = Object(toastrFactory["a" /* default */])();
var application_form_saga_cleanFormFields = {
  type: application_actions_actionTypes.APPLICATION_FORM_CLEAN
};
function initApplicationForm(action) {
  var applicationId, application, environments, stages, applications;
  return regenerator_default.a.wrap(function initApplicationForm$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          applicationId = action.payload;

          if (isEmpty_default()(applicationId)) {
            _context.next = 8;
            break;
          }

          _context.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_service["c" /* getApp */], applicationId);

        case 5:
          application = _context.sent;
          _context.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_LOAD_SUCCESS,
            payload: application
          });

        case 8:
          _context.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["e" /* searchEnvironments */], '');

        case 10:
          environments = _context.sent;
          _context.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_ENV_LOAD_SUCCESS,
            payload: environments
          });

        case 13:
          _context.next = 15;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_service["c" /* searchStages */], '');

        case 15:
          stages = _context.sent;
          _context.next = 18;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_STAGE_LOAD_SUCCESS,
            payload: stages
          });

        case 18:
          _context.next = 20;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_service["d" /* searchApp */], '');

        case 20:
          applications = _context.sent;
          _context.next = 23;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_LIST_LOAD_SUCCESS,
            payload: applications
          });

        case 23:
          _context.next = 29;
          break;

        case 25:
          _context.prev = 25;
          _context.t0 = _context["catch"](0);
          _context.next = 29;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_FORM_FAILURE
          });

        case 29:
        case "end":
          return _context.stop();
      }
    }
  }, application_form_saga_marked, null, [[0, 25]]);
}
function cancelApplicationForm() {
  var $state;
  return regenerator_default.a.wrap(function cancelApplicationForm$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _context2.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 2:
          _context2.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$state');

        case 4:
          $state = _context2.sent;
          _context2.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])($state.go, 'applicationList');

        case 7:
          _context2.next = 9;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(application_form_saga_cleanFormFields);

        case 9:
        case "end":
          return _context2.stop();
      }
    }
  }, application_form_saga_marked2);
}
function updateApplicationModel(action) {
  return regenerator_default.a.wrap(function updateApplicationModel$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          _context3.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_LOAD_SUCCESS,
            payload: action.payload
          });

        case 2:
        case "end":
          return _context3.stop();
      }
    }
  }, application_form_saga_marked3);
}
function saveApplication(action) {
  var application, $state;
  return regenerator_default.a.wrap(function saveApplication$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _context4.prev = 0;
          application = action.payload;
          application.environmentIds = application.environments.map(function (env) {
            return env.id;
          });
          _context4.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$state');

        case 5:
          $state = _context4.sent;
          _context4.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 8:
          if (!isEmpty_default()(application.id)) {
            _context4.next = 17;
            break;
          }

          _context4.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_service["a" /* createApp */], application);

        case 11:
          _context4.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_form_saga_toastr.success, "Created application [".concat(action.payload.title, "]"));

        case 13:
          _context4.next = 15;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])($state.go, 'applicationList');

        case 15:
          _context4.next = 23;
          break;

        case 17:
          _context4.next = 19;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_service["e" /* updateApp */], application);

        case 19:
          _context4.next = 21;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_form_saga_toastr.success, "Updated application [".concat(action.payload.title, "]"));

        case 21:
          _context4.next = 23;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])($state.go, 'applicationList');

        case 23:
          _context4.next = 29;
          break;

        case 25:
          _context4.prev = 25;
          _context4.t0 = _context4["catch"](0);
          _context4.next = 29;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_SAVE_FAILURE,
            error: _context4.t0 // for testing purposes

          });

        case 29:
        case "end":
          return _context4.stop();
      }
    }
  }, application_form_saga_marked4, null, [[0, 25]]);
}
function applicationFormSaga() {
  return regenerator_default.a.wrap(function applicationFormSaga$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _context5.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(application_actions_actionTypes.APPLICATION_SAVE_REQUEST, saveApplication);

        case 2:
          _context5.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(application_actions_actionTypes.APPLICATION_FORM_INIT, initApplicationForm);

        case 4:
          _context5.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(application_actions_actionTypes.APPLICATION_FORM_UPDATE_MODEL, updateApplicationModel);

        case 6:
          _context5.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(application_actions_actionTypes.APPLICATION_FORM_CANCEL, cancelApplicationForm);

        case 8:
          _context5.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(application_actions_actionTypes.APPLICATION_FORM_PRISTINE, sagas["a" /* addConfirmLeavePopup */]);

        case 10:
        case "end":
          return _context5.stop();
      }
    }
  }, application_form_saga_marked5);
}
// EXTERNAL MODULE: ./node_modules/moment/moment.js-exposed
var moment_js_exposed = __webpack_require__(43);
var moment_js_exposed_default = /*#__PURE__*/__webpack_require__.n(moment_js_exposed);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/actions/scheduling-environment-reservation-form-actions.js
var scheduling_environment_reservation_form_actions_actionTypes = {
  SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE',
  SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_ENVIRONMENT_CHANGE: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_ENVIRONMENT_CHANGE',
  SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED',
  SCHEDULE_ENVIRONMENT_RESERVATION_CLEAN_FORM: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_CLEAN_FORM',
  SCHEDULE_ENVIRONMENT_RESERVATION_PRISTINE_FORM: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_PRISTINE_FORM',
  SCHEDULE_ENVIRONMENT_RESERVATION_VALID_FORM: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_VALID_FORM',
  SCHEDULE_ENVIRONMENT_RESERVE: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVE',
  SCHEDULE_ENVIRONMENT_RESERVE_CANCEL: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVE_CANCEL',
  SCHEDULE_ENVIRONMENT_RESERVE_FAILURE: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVE_FAILURE',
  SCHEDULE_ENVIRONMENT_DELETE_RESERVATION: 'envMgmt/SCHEDULE_ENVIRONMENT_DELETE_RESERVATION',
  SCHEDULE_ENVIRONMENT_DELETE_RESERVATION_FAILED: 'envMgmt/SCHEDULE_ENVIRONMENT_DELETE_RESERVATION_FAILED',
  SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT',
  SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT_FAILED: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT_FAILED'
};
var onReserveEnvironment = function onReserveEnvironment(reservationModel) {
  return {
    type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVE,
    payload: reservationModel
  };
};
var scheduling_environment_reservation_form_actions_onReserveEnvironmentCancel = function onReserveEnvironmentCancel() {
  return {
    type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVE_CANCEL
  };
};
var onDeleteEnvironmentReservation = function onDeleteEnvironmentReservation(reservationId) {
  return {
    type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_DELETE_RESERVATION,
    payload: reservationId
  };
};
var scheduling_environment_reservation_form_actions_onReservationFormChange = function onReservationFormChange(reservationModel) {
  return {
    type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE,
    payload: reservationModel
  };
};
var scheduling_environment_reservation_form_actions_onReservationEnvironmentChange = function onReservationEnvironmentChange(reservationModel) {
  return {
    type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_ENVIRONMENT_CHANGE,
    payload: reservationModel
  };
};
var scheduling_environment_reservation_form_actions_onReservationFormPristineChange = function onReservationFormPristineChange(pristine) {
  return {
    type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_PRISTINE_FORM,
    payload: pristine
  };
};
var scheduling_environment_reservation_form_actions_onReservationFormValidChange = function onReservationFormValidChange(valid) {
  return {
    type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_VALID_FORM,
    payload: valid
  };
};
var initEnvironmentReservationForm = function initEnvironmentReservationForm(reservationId) {
  return {
    type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT,
    payload: reservationId
  };
};
// EXTERNAL MODULE: ./core/xlr-ui/app/features/common/services/http.js
var http = __webpack_require__(16);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/common/scheduling-service.js

var scheduling_service_searchReservations = function searchReservations(schedulerFilter) {
  return Object(http["d" /* httpPOST */])('api/v1/environments/reservations/search', schedulerFilter).then(function (response) {
    return response.data;
  });
};
var scheduling_service_createReservation = function createReservation(reservation) {
  return Object(http["d" /* httpPOST */])('api/v1/environments/reservations', reservation);
};
var scheduling_service_updateReservation = function updateReservation(reservationId, reservation) {
  return Object(http["e" /* httpPUT */])("api/v1/environments/reservations/".concat(reservationId), reservation);
};
var scheduling_service_fetchReservation = function fetchReservation(reservationId) {
  return Object(http["c" /* httpGET */])("api/v1/environments/reservations/".concat(reservationId)).then(function (response) {
    return response.data;
  });
};
var scheduling_service_deleteReservation = function deleteReservation(reservationId) {
  return Object(http["b" /* httpDELETE */])("api/v1/environments/reservations/".concat(reservationId));
};
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/actions/scheduling-actions.js
var scheduling_actions_actionTypes = {
  SCHEDULE_SEARCH_REQUEST: 'envMgmt/SCHEDULE_SEARCH_REQUEST',
  SCHEDULE_SEARCH_SUCCESS: 'envMgmt/SCHEDULE_SEARCH_SUCCESS',
  SCHEDULE_SEARCH_FAILURE: 'envMgmt/SCHEDULE_SEARCH_FAILURE',
  SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM: 'envMgmt/SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM',
  SCHEDULE_SHOW_RESERVATION_SIDEBAR: 'envMgmt/SCHEDULE_SHOW_RESERVATION_SIDEBAR',
  SCHEDULE_INIT_HEADER_REQUEST: 'envMgmt/SCHEDULE_INIT_HEADER_REQUEST',
  SCHEDULE_INIT_HEADER_SUCCESS: 'envMgmt/SCHEDULE_INIT_HEADER_SUCCESS',
  SCHEDULE_CLEAN_STATE: 'envMgmt/SCHEDULE_CLEAN_STATE'
};
var onSearchReservations = function onSearchReservations(schedulerFilter) {
  return {
    type: scheduling_actions_actionTypes.SCHEDULE_SEARCH_REQUEST,
    payload: schedulerFilter
  };
};
var openEnvironmentReservationForm = function openEnvironmentReservationForm(reservationId) {
  return {
    type: scheduling_actions_actionTypes.SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM,
    payload: reservationId
  };
};
var showReservationSidebar = function showReservationSidebar(isOpen) {
  return {
    type: scheduling_actions_actionTypes.SCHEDULE_SHOW_RESERVATION_SIDEBAR,
    payload: isOpen
  };
};
var initHeader = function initHeader() {
  return {
    type: scheduling_actions_actionTypes.SCHEDULE_INIT_HEADER_REQUEST
  };
};
var cleanSchedulingState = function cleanSchedulingState() {
  return {
    type: scheduling_actions_actionTypes.SCHEDULE_CLEAN_STATE
  };
};
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/sagas/scheduling-environment-reservation-form-saga.js


var scheduling_environment_reservation_form_saga_marked = /*#__PURE__*/regenerator_default.a.mark(reservationEnvironmentChange),
    scheduling_environment_reservation_form_saga_marked2 = /*#__PURE__*/regenerator_default.a.mark(reserveEnvironment),
    scheduling_environment_reservation_form_saga_marked3 = /*#__PURE__*/regenerator_default.a.mark(scheduling_environment_reservation_form_saga_cancel),
    scheduling_environment_reservation_form_saga_marked4 = /*#__PURE__*/regenerator_default.a.mark(deleteEnvironmentReservation),
    scheduling_environment_reservation_form_saga_marked5 = /*#__PURE__*/regenerator_default.a.mark(scheduling_environment_reservation_form_saga_initEnvironmentForm),
    scheduling_environment_reservation_form_saga_marked6 = /*#__PURE__*/regenerator_default.a.mark(scheduleEnvironmentReservationFormSaga);









var scheduling_environment_reservation_form_saga_cleanFormFields = {
  type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_CLEAN_FORM
};
var scheduling_environment_reservation_form_saga_toastr = Object(toastrFactory["a" /* default */])();
var getStateSchedulerFilter = function getStateSchedulerFilter(state) {
  return state.scheduling.schedulerFilter;
};
function reservationEnvironmentChange(action) {
  var applications;
  return regenerator_default.a.wrap(function reservationEnvironmentChange$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;

          if (!isEmpty_default()(action.payload)) {
            _context.next = 5;
            break;
          }

          _context.t0 = [];
          _context.next = 8;
          break;

        case 5:
          _context.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["c" /* getDeployableApplicationsForEnvironment */], action.payload.id);

        case 7:
          _context.t0 = _context.sent;

        case 8:
          applications = _context.t0;
          _context.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED,
            payload: applications
          });

        case 11:
          _context.next = 17;
          break;

        case 13:
          _context.prev = 13;
          _context.t1 = _context["catch"](0);
          _context.next = 17;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED,
            payload: []
          });

        case 17:
        case "end":
          return _context.stop();
      }
    }
  }, scheduling_environment_reservation_form_saga_marked, null, [[0, 13]]);
}
function reserveEnvironment(action) {
  var reservationModel, reservationForm, schedulerFilter;
  return regenerator_default.a.wrap(function reserveEnvironment$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          reservationModel = action.payload;
          reservationForm = {
            environmentId: reservationModel.environment.id,
            applicationIds: reservationModel.applications.map(function (app) {
              return app.id;
            }),
            startDate: moment_js_exposed_default()(reservationModel.startDate).valueOf(),
            endDate: moment_js_exposed_default()(reservationModel.endDate).valueOf(),
            note: isEmpty_default()(reservationModel.note) ? null : reservationModel.note
          };
          _context2.prev = 2;

          if (!isEmpty_default()(reservationModel.id)) {
            _context2.next = 10;
            break;
          }

          _context2.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(scheduling_service_createReservation, reservationForm);

        case 6:
          _context2.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(scheduling_environment_reservation_form_saga_toastr.success, "Environment reserved.");

        case 8:
          _context2.next = 14;
          break;

        case 10:
          _context2.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(scheduling_service_updateReservation, reservationModel.id, reservationForm);

        case 12:
          _context2.next = 14;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(scheduling_environment_reservation_form_saga_toastr.success, "Environment reservation updated.");

        case 14:
          _context2.next = 16;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(showReservationSidebar(false));

        case 16:
          _context2.next = 18;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(scheduling_environment_reservation_form_saga_cleanFormFields);

        case 18:
          _context2.next = 20;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getStateSchedulerFilter);

        case 20:
          schedulerFilter = _context2.sent;
          _context2.next = 23;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(onSearchReservations(schedulerFilter));

        case 23:
          _context2.next = 29;
          break;

        case 25:
          _context2.prev = 25;
          _context2.t0 = _context2["catch"](2);
          _context2.next = 29;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVE_FAILURE
          });

        case 29:
        case "end":
          return _context2.stop();
      }
    }
  }, scheduling_environment_reservation_form_saga_marked2, null, [[2, 25]]);
}
function scheduling_environment_reservation_form_saga_cancel() {
  return regenerator_default.a.wrap(function cancel$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          _context3.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(showReservationSidebar(false));

        case 2:
          _context3.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(scheduling_environment_reservation_form_saga_cleanFormFields);

        case 4:
        case "end":
          return _context3.stop();
      }
    }
  }, scheduling_environment_reservation_form_saga_marked3);
}
function deleteEnvironmentReservation(action) {
  var schedulerFilter;
  return regenerator_default.a.wrap(function deleteEnvironmentReservation$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _context4.prev = 0;
          _context4.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(scheduling_service_deleteReservation, action.payload);

        case 3:
          _context4.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(scheduling_environment_reservation_form_saga_toastr.success, "Reservation deleted.", action.payload);

        case 5:
          _context4.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(showReservationSidebar(false));

        case 7:
          _context4.next = 9;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(scheduling_environment_reservation_form_saga_cleanFormFields);

        case 9:
          _context4.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getStateSchedulerFilter);

        case 11:
          schedulerFilter = _context4.sent;
          _context4.next = 14;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(onSearchReservations(schedulerFilter));

        case 14:
          _context4.next = 20;
          break;

        case 16:
          _context4.prev = 16;
          _context4.t0 = _context4["catch"](0);
          _context4.next = 20;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_DELETE_RESERVATION_FAILED
          });

        case 20:
        case "end":
          return _context4.stop();
      }
    }
  }, scheduling_environment_reservation_form_saga_marked4, null, [[0, 16]]);
}
function scheduling_environment_reservation_form_saga_initEnvironmentForm(action) {
  var reservationId, reservation, reservationModel;
  return regenerator_default.a.wrap(function initEnvironmentForm$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _context5.prev = 0;
          _context5.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(scheduling_environment_reservation_form_saga_cleanFormFields);

        case 3:
          reservationId = action.payload;

          if (isEmpty_default()(reservationId)) {
            _context5.next = 11;
            break;
          }

          _context5.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(scheduling_service_fetchReservation, reservationId);

        case 7:
          reservation = _context5.sent;
          reservationModel = {
            id: reservation.id,
            environment: {
              id: reservation.environment.id,
              title: reservation.environment.title
            },
            applications: reservation.applications,
            startDate: new Date(reservation.startDate),
            endDate: new Date(reservation.endDate),
            note: reservation.note
          };
          _context5.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE,
            payload: reservationModel
          });

        case 11:
          _context5.next = 17;
          break;

        case 13:
          _context5.prev = 13;
          _context5.t0 = _context5["catch"](0);
          _context5.next = 17;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT_FAILED
          });

        case 17:
        case "end":
          return _context5.stop();
      }
    }
  }, scheduling_environment_reservation_form_saga_marked5, null, [[0, 13]]);
}
function scheduleEnvironmentReservationFormSaga() {
  return regenerator_default.a.wrap(function scheduleEnvironmentReservationFormSaga$(_context6) {
    while (1) {
      switch (_context6.prev = _context6.next) {
        case 0:
          _context6.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_ENVIRONMENT_CHANGE, reservationEnvironmentChange), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVE, reserveEnvironment), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_DELETE_RESERVATION, deleteEnvironmentReservation), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVE_CANCEL, scheduling_environment_reservation_form_saga_cancel), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT, scheduling_environment_reservation_form_saga_initEnvironmentForm)]);

        case 2:
        case "end":
          return _context6.stop();
      }
    }
  }, scheduling_environment_reservation_form_saga_marked6);
}
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/sagas/scheduling-saga.js


var scheduling_saga_marked = /*#__PURE__*/regenerator_default.a.mark(searchReservation),
    scheduling_saga_marked2 = /*#__PURE__*/regenerator_default.a.mark(scheduling_saga_openEnvironmentReservationForm),
    scheduling_saga_marked3 = /*#__PURE__*/regenerator_default.a.mark(loadApplicationsStagesAndLabels),
    scheduling_saga_marked4 = /*#__PURE__*/regenerator_default.a.mark(schedulingSaga);








function searchReservation(action) {
  var environmentReservations;
  return regenerator_default.a.wrap(function searchReservation$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(scheduling_service_searchReservations, action.payload);

        case 3:
          environmentReservations = _context.sent;
          _context.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_actions_actionTypes.SCHEDULE_SEARCH_SUCCESS,
            payload: environmentReservations
          });

        case 6:
          _context.next = 12;
          break;

        case 8:
          _context.prev = 8;
          _context.t0 = _context["catch"](0);
          _context.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_actions_actionTypes.SCHEDULE_SEARCH_FAILURE
          });

        case 12:
        case "end":
          return _context.stop();
      }
    }
  }, scheduling_saga_marked, null, [[0, 8]]);
}
function scheduling_saga_openEnvironmentReservationForm(action) {
  return regenerator_default.a.wrap(function openEnvironmentReservationForm$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _context2.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(initEnvironmentReservationForm(action.payload));

        case 3:
          _context2.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_actions_actionTypes.SCHEDULE_SHOW_RESERVATION_SIDEBAR,
            payload: true
          });

        case 5:
          _context2.next = 11;
          break;

        case 7:
          _context2.prev = 7;
          _context2.t0 = _context2["catch"](0);
          _context2.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_actions_actionTypes.SCHEDULE_SHOW_RESERVATION_SIDEBAR,
            payload: false
          });

        case 11:
        case "end":
          return _context2.stop();
      }
    }
  }, scheduling_saga_marked2, null, [[0, 7]]);
}
function loadApplicationsStagesAndLabels() {
  var applications, stages, labels;
  return regenerator_default.a.wrap(function loadApplicationsStagesAndLabels$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          _context3.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_service["d" /* searchApp */], '');

        case 2:
          applications = _context3.sent;
          _context3.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_service["c" /* searchStages */], '');

        case 5:
          stages = _context3.sent;
          _context3.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(label_service["c" /* searchLabels */], '');

        case 8:
          labels = _context3.sent;
          _context3.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_actions_actionTypes.SCHEDULE_INIT_HEADER_SUCCESS,
            payload: {
              applications: applications,
              stages: stages,
              labels: labels
            }
          });

        case 11:
        case "end":
          return _context3.stop();
      }
    }
  }, scheduling_saga_marked3);
}
function schedulingSaga() {
  return regenerator_default.a.wrap(function schedulingSaga$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _context4.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["m" /* throttle */])(200, scheduling_actions_actionTypes.SCHEDULE_SEARCH_REQUEST, searchReservation), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(scheduling_actions_actionTypes.SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM, scheduling_saga_openEnvironmentReservationForm), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(scheduling_actions_actionTypes.SCHEDULE_INIT_HEADER_REQUEST, loadApplicationsStagesAndLabels)]);

        case 2:
        case "end":
          return _context4.stop();
      }
    }
  }, scheduling_saga_marked4);
}
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/sagas/sagas.js


var sagas_marked = /*#__PURE__*/regenerator_default.a.mark(combinedSaga);










function combinedSaga() {
  return regenerator_default.a.wrap(function combinedSaga$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          if (false) {}

          _context.prev = 1;
          _context.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environmentListSaga), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environmentFormSaga), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stageSaga), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(labelSaga), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(applicationListSaga), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(applicationFormSaga), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(scheduleEnvironmentReservationFormSaga), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(schedulingSaga)]);

        case 4:
          _context.next = 9;
          break;

        case 6:
          _context.prev = 6;
          _context.t0 = _context["catch"](1);

          /* eslint-disable no-console, angular/log */
          console.error('Environment management root saga:', _context.t0);
          /* eslint-enable */

        case 9:
          _context.next = 0;
          break;

        case 11:
        case "end":
          return _context.stop();
      }
    }
  }, sagas_marked, null, [[1, 6]]);
}
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/defineProperty.js
var defineProperty = __webpack_require__(1);
var defineProperty_default = /*#__PURE__*/__webpack_require__.n(defineProperty);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/reducers/environment-form-reducer.js


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var environment_form_reducer_initialState = function initialState() {
  return {
    environmentModel: {
      stage: {},
      id: null,
      labels: [],
      title: '',
      description: ''
    },
    environments: [],
    formIsPristine: true,
    formIsValid: false
  };
};

/* harmony default export */ var environment_form_reducer = (function () {
  var _state$environmentMod;

  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : environment_form_reducer_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case environment_form_actions_actionTypes.ENVIRONMENT_EDIT_CLEAN_FORM:
      return _objectSpread({}, environment_form_reducer_initialState(), {
        environmentModel: _objectSpread({}, environment_form_reducer_initialState().environmentModel, {
          stage: (_state$environmentMod = state.environmentModel) === null || _state$environmentMod === void 0 ? void 0 : _state$environmentMod.stage
        }),
        formIsPristine: state.formIsPristine
      });

    case environment_form_actions_actionTypes.ENVIRONMENT_EDIT_VALID_FORM:
      return _objectSpread({}, state, {
        formIsValid: action.payload
      });

    case environment_form_actions_actionTypes.ENVIRONMENT_EDIT_PRISTINE_FORM:
      return _objectSpread({}, state, {
        formIsPristine: action.payload
      });

    case environment_form_actions_actionTypes.ENVIRONMENT_EDIT_CHANGE_FORM:
      return _objectSpread({}, state, {
        environmentModel: action.payload
      });

    case environment_form_actions_actionTypes.ENVIRONMENT_LOAD_SUCCESS:
      return _objectSpread({}, state, {
        environmentModel: action.payload
      });

    case environment_form_actions_actionTypes.ENVIRONMENT_SEARCH_SUCCESS:
      return _objectSpread({}, state, {
        environments: action.payload
      });

    case environment_form_actions_actionTypes.INIT_ENVIRONMENT_FORM_SUCCESS:
      var _action$payload = action.payload,
          environment = _action$payload.environment,
          environments = _action$payload.environments;
      return _objectSpread({}, state, {
        environmentModel: environment || environment_form_reducer_initialState().environmentModel,
        environments: environments
      });

    default:
      return state;
  }
});
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/utils.js
function by(fieldSelector) {
  return function (a, b) {
    var nameA = fieldSelector(a).toLowerCase();
    var nameB = fieldSelector(b).toLowerCase();

    if (nameA < nameB) {
      return -1;
    }

    if (nameA > nameB) {
      return 1;
    }

    return 0;
  };
}

var byTitle = by(function (it) {
  return it.title;
});
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/reducers/environment-list-reducer.js


function environment_list_reducer_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function environment_list_reducer_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { environment_list_reducer_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { environment_list_reducer_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var environment_list_reducer_initialState = function initialState() {
  return {
    list: [],
    filters: {
      title: '',
      stage: {}
    },
    loading: false
  };
};
/* harmony default export */ var environment_list_reducer = (function () {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : environment_list_reducer_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case actionTypes.INIT_ENVIRONMENT_LIST:
    case actionTypes.ENVIRONMENTS_SEARCH_REQUEST:
      return environment_list_reducer_objectSpread({}, state, {
        loading: true
      });

    case actionTypes.ENVIRONMENTS_SEARCH_SUCCESS:
      {
        var environments = action.payload.sort(byTitle);
        return environment_list_reducer_objectSpread({}, state, {
          list: environments,
          loading: false
        });
      }

    case actionTypes.ENVIRONMENTS_SEARCH_FAILURE:
      return environment_list_reducer_objectSpread({}, state, {
        loading: false
      });

    case actionTypes.ENVIRONMENT_DELETE_REQUEST:
      return environment_list_reducer_objectSpread({}, state, {
        loading: true
      });

    case actionTypes.ENVIRONMENT_DELETE_SUCCESS:
      return environment_list_reducer_objectSpread({}, state, {
        loading: false
      });

    case actionTypes.ENVIRONMENT_DELETE_FAILURE:
      return environment_list_reducer_objectSpread({}, state, {
        loading: false
      });

    case actionTypes.INIT_ENVIRONMENT_LIST_SUCCESS:
      {
        var _environments = action.payload.environments;
        return environment_list_reducer_objectSpread({}, state, {
          list: _environments.sort(byTitle),
          loading: false
        });
      }

    case actionTypes.INIT_ENVIRONMENT_LIST_FAILURE:
      return environment_list_reducer_objectSpread({}, state, {
        loading: false
      });

    case actionTypes.TITLE_FILTER_CHANGE:
      var title = action.payload;
      return environment_list_reducer_objectSpread({}, state, {
        filters: environment_list_reducer_objectSpread({}, state.filters, {
          title: title
        })
      });

    case actionTypes.STAGE_FILTER_CHANGE:
      var stage = action.payload;
      return environment_list_reducer_objectSpread({}, state, {
        filters: environment_list_reducer_objectSpread({}, state.filters, {
          stage: stage
        })
      });

    default:
      return state;
  }
});
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/reducers/stage-reducer.js


function stage_reducer_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function stage_reducer_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { stage_reducer_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { stage_reducer_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }





var stage_reducer_initialState = function initialState() {
  return {
    stageList: []
  };
};
/* harmony default export */ var stage_reducer = (function () {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : stage_reducer_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case stage_actions_actionTypes.STAGE_SEARCH_SUCCESS:
      {
        var stages = action.payload.sort(byTitle);
        return stage_reducer_objectSpread({}, state, {
          stageList: stages
        });
      }

    case scheduling_actions_actionTypes.SCHEDULE_INIT_HEADER_SUCCESS:
      {
        var _stages = action.payload.stages;
        return stage_reducer_objectSpread({}, state, {
          stageList: _stages.sort(byTitle)
        });
      }

    case actionTypes.INIT_ENVIRONMENT_LIST_SUCCESS:
      {
        var _stages2 = action.payload.stages;
        return stage_reducer_objectSpread({}, state, {
          stageList: _stages2.sort(byTitle)
        });
      }

    default:
      return state;
  }
});
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/reducers/label-reducer.js


function label_reducer_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function label_reducer_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { label_reducer_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { label_reducer_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }





var label_reducer_initialState = function initialState() {
  return {
    labelList: []
  };
};

/* harmony default export */ var label_reducer = (function () {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : label_reducer_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case label_actions_actionTypes.LABEL_SEARCH_SUCCESS:
      {
        var labels = action.payload;
        return label_reducer_objectSpread({}, state, {
          labelList: labels.sort(byTitle)
        });
      }

    case scheduling_actions_actionTypes.SCHEDULE_INIT_HEADER_SUCCESS:
      {
        var _labels = action.payload.labels;
        return label_reducer_objectSpread({}, state, {
          labelList: _labels.sort(byTitle)
        });
      }

    default:
      return state;
  }
});
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/reducers/scheduling-environment-reservation-form-reducer.js


function scheduling_environment_reservation_form_reducer_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function scheduling_environment_reservation_form_reducer_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { scheduling_environment_reservation_form_reducer_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { scheduling_environment_reservation_form_reducer_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }


var scheduling_environment_reservation_form_reducer_initialState = function initialState() {
  return {
    reservationModel: {
      id: null,
      environment: {},
      applications: [],
      startDate: new Date(),
      endDate: new Date(new Date().getTime() + 1),
      note: ''
    },
    applications: [],
    environments: [],
    reservationFormIsPristine: true,
    reservationFormIsValid: false
  };
};
/* harmony default export */ var scheduling_environment_reservation_form_reducer = (function () {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : scheduling_environment_reservation_form_reducer_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE:
      return scheduling_environment_reservation_form_reducer_objectSpread({}, state, {
        reservationModel: action.payload
      });

    case scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED:
      return scheduling_environment_reservation_form_reducer_objectSpread({}, state, {
        applications: action.payload
      });

    case scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_CLEAN_FORM:
      return scheduling_environment_reservation_form_reducer_objectSpread({}, scheduling_environment_reservation_form_reducer_initialState());

    case scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_VALID_FORM:
      return scheduling_environment_reservation_form_reducer_objectSpread({}, state, {
        reservationFormIsValid: action.payload
      });

    case scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_PRISTINE_FORM:
      return scheduling_environment_reservation_form_reducer_objectSpread({}, state, {
        reservationFormIsPristine: action.payload
      });

    case scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVE_FAILURE:
      return scheduling_environment_reservation_form_reducer_objectSpread({}, state);

    case scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT_FAILED:
      return scheduling_environment_reservation_form_reducer_objectSpread({}, state, {
        reservationModel: scheduling_environment_reservation_form_reducer_initialState().reservationModel
      });

    default:
      return state;
  }
});
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/reducers/scheduling-reducer.js


function scheduling_reducer_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function scheduling_reducer_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { scheduling_reducer_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { scheduling_reducer_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }




var scheduling_reducer_initialState = function initialState() {
  return {
    environmentsReservations: [],
    schedulerFilter: {
      environmentTitle: '',
      from: moment_js_exposed_default()().startOf('month').valueOf(),
      to: moment_js_exposed_default()().endOf('month').valueOf(),
      applications: [],
      stages: [],
      labels: []
    },
    reservationSidebarIsOpen: false
  };
};
/* harmony default export */ var scheduling_reducer = (function () {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : scheduling_reducer_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case scheduling_actions_actionTypes.SCHEDULE_SEARCH_REQUEST:
      return scheduling_reducer_objectSpread({}, state, {
        schedulerFilter: action.payload
      });

    case scheduling_actions_actionTypes.SCHEDULE_SEARCH_SUCCESS:
      {
        var environmentsReservations = action.payload;
        return scheduling_reducer_objectSpread({}, state, {
          environmentsReservations: environmentsReservations.sort(byTitle)
        });
      }

    case scheduling_actions_actionTypes.SCHEDULE_SEARCH_FAILURE:
      return scheduling_reducer_objectSpread({}, state);

    case scheduling_actions_actionTypes.SCHEDULE_SHOW_RESERVATION_SIDEBAR:
      return scheduling_reducer_objectSpread({}, state, {
        reservationSidebarIsOpen: action.payload
      });

    case scheduling_actions_actionTypes.SCHEDULE_CLEAN_STATE:
      return scheduling_reducer_objectSpread({}, scheduling_reducer_initialState());

    default:
      return state;
  }
});
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/reducers/application-list-reducer.js


function application_list_reducer_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function application_list_reducer_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { application_list_reducer_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { application_list_reducer_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }




var application_list_reducer_initialState = function initialState() {
  return {
    applications: []
  };
};
/* harmony default export */ var application_list_reducer = (function () {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : application_list_reducer_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case application_actions_actionTypes.APPLICATION_SEARCH_SUCCESS:
      {
        var applications = action.payload.sort(byTitle);
        return application_list_reducer_objectSpread({}, state, {
          applications: applications
        });
      }

    case scheduling_actions_actionTypes.SCHEDULE_INIT_HEADER_SUCCESS:
      {
        var _applications = action.payload.applications;
        return application_list_reducer_objectSpread({}, state, {
          applications: _applications.sort(byTitle)
        });
      }

    case application_actions_actionTypes.APPLICATION_DELETE_SUCCESS:
      {
        return application_list_reducer_objectSpread({}, state, {
          applications: state.applications.filter(function (app) {
            return app.id !== action.payload.id;
          })
        });
      }

    default:
      return state;
  }
});
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/reducers/application-form-reducer.js


function application_form_reducer_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function application_form_reducer_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { application_form_reducer_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { application_form_reducer_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }


var application_form_reducer_initialState = function initialState() {
  return {
    stages: [],
    environments: [],
    application: {
      title: "",
      environments: []
    },
    applications: []
  };
};
/* harmony default export */ var application_form_reducer = (function () {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : application_form_reducer_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case application_actions_actionTypes.APPLICATION_LOAD_SUCCESS:
      return application_form_reducer_objectSpread({}, state, {
        application: action.payload
      });

    case application_actions_actionTypes.APPLICATION_ENV_LOAD_SUCCESS:
      return application_form_reducer_objectSpread({}, state, {
        environments: action.payload
      });

    case application_actions_actionTypes.APPLICATION_STAGE_LOAD_SUCCESS:
      return application_form_reducer_objectSpread({}, state, {
        stages: action.payload
      });

    case application_actions_actionTypes.APPLICATION_LIST_LOAD_SUCCESS:
      return application_form_reducer_objectSpread({}, state, {
        applications: action.payload
      });

    case application_actions_actionTypes.APPLICATION_FORM_CLEAN:
      return application_form_reducer_objectSpread({}, state, {
        application: application_form_reducer_initialState().application
      });

    default:
      return state;
  }
});
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/reducers/reducers.js









/* harmony default export */ var reducers = (Object(redux["combineReducers"])({
  environmentForm: environment_form_reducer,
  environmentList: environment_list_reducer,
  stages: stage_reducer,
  labels: label_reducer,
  schedulingEnvironmentReservationForm: scheduling_environment_reservation_form_reducer,
  scheduling: scheduling_reducer,
  applicationList: application_list_reducer,
  applicationForm: application_form_reducer
}));
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/store/environment-management-store.js


/* global window */




var sagaMiddleware = Object(redux_saga_core_npm_proxy_esm["a" /* default */])();
/* eslint-disable no-underscore-dangle,angular/typecheck-object,angular/module-getter,lodash/prefer-lodash-typecheck */

var composeEnhancers = (typeof window === "undefined" ? "undefined" : typeof_default()(window)) === 'object' && window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ ? window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__({
  name: 'env-manager' // Specify extension’s options like name, actionsBlacklist, actionsCreators, serialize...

}) : redux["compose"];

function configureStore(preloadedState) {
  var enhancer = composeEnhancers(Object(redux["applyMiddleware"])(sagaMiddleware));
  var store = Object(redux["createStore"])(reducers, preloadedState, enhancer);
  sagaMiddleware.run(combinedSaga);
  return store;
}

var environment_management_store_store = environment_management_store_store || configureStore();
/* eslint-enable no-underscore-dangle,angular/typecheck-object,angular/module-getter,lodash/prefer-lodash-typecheck */
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/assertThisInitialized.js
var assertThisInitialized = __webpack_require__(6);
var assertThisInitialized_default = /*#__PURE__*/__webpack_require__.n(assertThisInitialized);

// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__(2);
var prop_types_default = /*#__PURE__*/__webpack_require__.n(prop_types);

// EXTERNAL MODULE: ./node_modules/xl-react-components/dist/index.js
var dist = __webpack_require__(21);

// EXTERNAL MODULE: ./node_modules/lodash/includes.js
var includes = __webpack_require__(65);
var includes_default = /*#__PURE__*/__webpack_require__.n(includes);

// EXTERNAL MODULE: ./node_modules/lodash/sortBy.js
var sortBy = __webpack_require__(124);
var sortBy_default = /*#__PURE__*/__webpack_require__.n(sortBy);

// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/header/header-component.less
var header_component = __webpack_require__(1972);

// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/index.js + 25 modules
var components = __webpack_require__(27);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/header/header-component.js







function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var header_component_HeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(HeaderComponent, _Component);

  var _super = _createSuper(HeaderComponent);

  function HeaderComponent() {
    classCallCheck_default()(this, HeaderComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(HeaderComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          helpUrl = _this$props.helpUrl;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "header",
        id: "header-environment"
      }, children, /*#__PURE__*/react_default.a.createElement(components["d" /* DocLink */], {
        section: helpUrl
      }));
    }
  }]);

  return HeaderComponent;
}(react["Component"]);

defineProperty_default()(header_component_HeaderComponent, "propTypes", {
  children: prop_types_default.a.element,
  helpUrl: prop_types_default.a.string.isRequired
});


// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/types/index.js

var Label = prop_types_default.a.shape({
  id: prop_types_default.a.string.isRequired,
  title: prop_types_default.a.string.isRequired,
  color: prop_types_default.a.string.isRequired
});
var Stage = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  title: prop_types_default.a.string
});
var Environment = prop_types_default.a.shape({
  stage: Stage,
  id: prop_types_default.a.string,
  title: prop_types_default.a.string,
  description: prop_types_default.a.string,
  labels: prop_types_default.a.arrayOf(Label)
});
var Application = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  title: prop_types_default.a.string,
  environments: prop_types_default.a.arrayOf(Environment)
});
var ReservationModel = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  environment: Environment,
  applications: prop_types_default.a.arrayOf(prop_types_default.a.any),
  startDate: prop_types_default.a.any,
  endDate: prop_types_default.a.any,
  note: prop_types_default.a.string
});
var EnvironmentReservation = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  title: prop_types_default.a.string,
  description: prop_types_default.a.string,
  stage: Stage,
  labels: prop_types_default.a.arrayOf(Label),
  reservations: prop_types_default.a.arrayOf(ReservationModel)
});
var SchedulerFilter = prop_types_default.a.shape({
  environmentTitle: prop_types_default.a.string,
  from: prop_types_default.a.number.isRequired,
  to: prop_types_default.a.number.isRequired,
  applications: prop_types_default.a.arrayOf(Application),
  stages: prop_types_default.a.arrayOf(Stage),
  labels: prop_types_default.a.arrayOf(Label)
});
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/list/environment-list-header-component.js







function environment_list_header_component_createSuper(Derived) { var hasNativeReflectConstruct = environment_list_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function environment_list_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }








var selectStageMetadata = {
  placeholder: 'Filter by stage...'
};

var environment_list_header_component_EnvironmentListHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(EnvironmentListHeaderComponent, _Component);

  var _super = environment_list_header_component_createSuper(EnvironmentListHeaderComponent);

  function EnvironmentListHeaderComponent() {
    classCallCheck_default()(this, EnvironmentListHeaderComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(EnvironmentListHeaderComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          stages = _this$props.stages,
          filterStage = _this$props.filterStage,
          filterEnvironmentName = _this$props.filterEnvironmentName,
          onAddNewEnvironment = _this$props.onAddNewEnvironment,
          onStageChange = _this$props.onStageChange,
          onFilterChange = _this$props.onFilterChange;
      var filterOptions = {
        placeholder: 'Filter by environment...'
      };

      var autocompleteHandler = function autocompleteHandler(_ref) {
        var metadata = _ref.metadata,
            objLabel = _ref.objLabel,
            suggestedElements = _ref.suggestedElements,
            value = _ref.value;
        return Promise.resolve(sortBy_default()(stages.filter(function (c) {
          return includes_default()(c.title.toLowerCase(), value.toLowerCase());
        }), ['title']));
      };

      var autocompleteHandlers = {
        addCandidates: autocompleteHandler
      };
      return /*#__PURE__*/react_default.a.createElement(header_component_HeaderComponent, {
        helpUrl: "environments.html"
      }, /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetFilter"], {
        metadata: filterOptions,
        model: filterEnvironmentName,
        onUpdate: onFilterChange
      }), /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetAutocomplete"], {
        className: "env-stage-filter",
        handlers: autocompleteHandlers,
        metadata: selectStageMetadata,
        model: filterStage,
        objLabel: 'title',
        onModelChange: onStageChange
      }), /*#__PURE__*/react_default.a.createElement("div", {
        className: "buttons"
      }, /*#__PURE__*/react_default.a.createElement("button", {
        className: "button primary",
        onClick: onAddNewEnvironment
      }, "New environment"))));
    }
  }]);

  return EnvironmentListHeaderComponent;
}(react["Component"]);

defineProperty_default()(environment_list_header_component_EnvironmentListHeaderComponent, "propTypes", {
  filterEnvironmentName: prop_types_default.a.string.isRequired,
  filterStage: Stage,
  onAddNewEnvironment: prop_types_default.a.func.isRequired,
  onFilterChange: prop_types_default.a.func.isRequired,
  onStageChange: prop_types_default.a.func.isRequired,
  stages: prop_types_default.a.arrayOf(Stage)
});


// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__(13);
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/shared/label/label-item.less
var label_item = __webpack_require__(1973);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/shared/label/label-item.js








function label_item_createSuper(Derived) { var hasNativeReflectConstruct = label_item_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function label_item_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }





var componentSize = ['small', 'normal'];
var skinType = ['plus', 'remove', 'normal'];

var label_item_LabelItem = /*#__PURE__*/function (_Component) {
  inherits_default()(LabelItem, _Component);

  var _super = label_item_createSuper(LabelItem);

  function LabelItem() {
    var _this;

    classCallCheck_default()(this, LabelItem);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "handleClick", function (label) {
      var onClickLabel = _this.props.onClickLabel;

      if (onClickLabel) {
        onClickLabel(label);
      }
    });

    return _this;
  }

  createClass_default()(LabelItem, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          envLabel = _this$props.envLabel,
          size = _this$props.size,
          isEditable = _this$props.isEditable,
          skin = _this$props.skin;
      var style = classnames_default()('label-box', size, {
        'editable-label': isEditable
      });
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: style,
        onClick: function onClick() {
          return _this2.handleClick(envLabel);
        },
        style: {
          backgroundColor: envLabel.color
        },
        title: "Click to edit"
      }, skin === 'plus' && /*#__PURE__*/react_default.a.createElement("i", {
        className: "menu-item-icon xl-icon add-icon icon-s",
        title: "Add"
      }), /*#__PURE__*/react_default.a.createElement("span", null, envLabel.title), skin === 'remove' && /*#__PURE__*/react_default.a.createElement("i", {
        className: "menu-item-icon xl-icon close-icon icon-s",
        title: "Remove"
      }));
    }
  }]);

  return LabelItem;
}(react["Component"]);

defineProperty_default()(label_item_LabelItem, "propTypes", {
  envLabel: prop_types_default.a.shape({
    color: prop_types_default.a.string.isRequired,
    id: prop_types_default.a.string.isRequired,
    title: prop_types_default.a.string.isRequired
  }).isRequired,
  isEditable: prop_types_default.a.bool,
  onClickLabel: prop_types_default.a.func,
  size: prop_types_default.a.oneOf(componentSize),
  skin: prop_types_default.a.oneOf(skinType)
});

defineProperty_default()(label_item_LabelItem, "defaultProps", {
  isEditable: false,
  size: 'normal',
  skin: 'normal'
});


// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/list/environment-list-item-component.less
var environment_list_item_component = __webpack_require__(1974);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/list/environment-list-item-component.js








function environment_list_item_component_createSuper(Derived) { var hasNativeReflectConstruct = environment_list_item_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function environment_list_item_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }








var environment_list_item_component_EnvironmentListItemComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(EnvironmentListItemComponent, _Component);

  var _super = environment_list_item_component_createSuper(EnvironmentListItemComponent);

  function EnvironmentListItemComponent(props) {
    var _this;

    classCallCheck_default()(this, EnvironmentListItemComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onEditEnvironment", function (event) {
      event.stopPropagation();

      _this.props.onEditEnvironment(_this.props.environment);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDeleteEnvironment", function (event) {
      event.stopPropagation();

      _this.props.onDeleteEnvironment(_this.props.environment);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderEnvironmentTitle", function () {
      var environment = _this.props.environment;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "environment-title-container"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "col-xs-7 environment-title",
        title: environment.title
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon environment-icon"
      }), /*#__PURE__*/react_default.a.createElement("strong", null, environment.title)), /*#__PURE__*/react_default.a.createElement("span", {
        className: "col-xs-2"
      }, environment.stage.title), /*#__PURE__*/react_default.a.createElement("div", {
        className: "actions-container col-xs-3"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "actions pull-right"
      }, /*#__PURE__*/react_default.a.createElement("span", {
        className: "link color-inherited",
        "data-test": "edit-action",
        onClick: _this.onEditEnvironment
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "menu-item-icon xl-icon edit-icon",
        title: "Edit"
      }), /*#__PURE__*/react_default.a.createElement("span", {
        className: "action-label"
      }, "Edit")), /*#__PURE__*/react_default.a.createElement("span", {
        className: "link delete",
        "data-test": "delete-action",
        onClick: _this.onDeleteEnvironment
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "menu-item-icon xl-icon delete-icon",
        title: "Delete"
      }), /*#__PURE__*/react_default.a.createElement("span", {
        className: "action-label"
      }, "Delete")))));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderEnvironmentLabels", function () {
      var labels = _this.props.environment.labels;

      if (!labels.length) {
        return null;
      }

      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "environment-labels"
      }, labels.map(function (type) {
        return /*#__PURE__*/react_default.a.createElement(label_item_LabelItem, {
          envLabel: type,
          key: type.id
        });
      }));
    });

    _this.state = {
      isSelected: false
    };
    return _this;
  }

  createClass_default()(EnvironmentListItemComponent, [{
    key: "render",
    value: function render() {
      var environment = this.props.environment;
      var isSelected = this.state.isSelected;
      var panelClass = classnames_default()('panel', 'panel-default', 'environment-panel', {
        'panel-hover': isSelected
      });
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: panelClass,
        onClick: this.onEditEnvironment
      }, this.renderEnvironmentTitle(), (environment.description || !!environment.labels.length) && /*#__PURE__*/react_default.a.createElement("div", {
        className: "environment-title-separator"
      }), environment.description && /*#__PURE__*/react_default.a.createElement("div", {
        className: "environment-description"
      }, environment.description), this.renderEnvironmentLabels());
    }
  }]);

  return EnvironmentListItemComponent;
}(react["Component"]);

defineProperty_default()(environment_list_item_component_EnvironmentListItemComponent, "propTypes", {
  environment: Environment.isRequired,
  onDeleteEnvironment: prop_types_default.a.func.isRequired,
  onEditEnvironment: prop_types_default.a.func.isRequired
});


// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/styles/common.less
var common = __webpack_require__(298);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/list/environment-list-component.js








function environment_list_component_createSuper(Derived) { var hasNativeReflectConstruct = environment_list_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function environment_list_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var helpMessage = "Use Environments to define environments that are available in your organization. You can also use Environments to filter the environment scheduler and dashboards.";

var environment_list_component_EnvironmentListComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(EnvironmentListComponent, _Component);

  var _super = environment_list_component_createSuper(EnvironmentListComponent);

  function EnvironmentListComponent() {
    var _this;

    classCallCheck_default()(this, EnvironmentListComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "renderHeader", function () {
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "application-list-header"
      }, /*#__PURE__*/react_default.a.createElement("span", {
        className: "col-xs-7"
      }, "Name"), /*#__PURE__*/react_default.a.createElement("span", {
        className: "col-xs-2"
      }, "Stage"), /*#__PURE__*/react_default.a.createElement("div", {
        className: "col-xs-3"
      }, /*#__PURE__*/react_default.a.createElement("span", {
        className: "pull-right action-section"
      }, "Actions")));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderEnvironmentList", function () {
      var _this$props = _this.props,
          environments = _this$props.environments,
          onEditEnvironment = _this$props.onEditEnvironment,
          onDeleteEnvironment = _this$props.onDeleteEnvironment;
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, _this.renderHeader(), environments.map(function (environment) {
        return /*#__PURE__*/react_default.a.createElement(environment_list_item_component_EnvironmentListItemComponent, {
          environment: environment,
          key: environment.title,
          onDeleteEnvironment: onDeleteEnvironment,
          onEditEnvironment: onEditEnvironment
        });
      }));
    });

    return _this;
  }

  createClass_default()(EnvironmentListComponent, [{
    key: "render",
    value: function render() {
      var environments = this.props.environments;
      return /*#__PURE__*/react_default.a.createElement("div", null, /*#__PURE__*/react_default.a.createElement("h4", {
        className: "page-title"
      }, "Environments (", environments.length, ")"), /*#__PURE__*/react_default.a.createElement(components["f" /* HelpBlock */], {
        className: "help-message-container"
      }, helpMessage), environments.length ? this.renderEnvironmentList() : /*#__PURE__*/react_default.a.createElement(components["g" /* NoData */], {
        message: "No environments found."
      }));
    }
  }]);

  return EnvironmentListComponent;
}(react["Component"]);

defineProperty_default()(environment_list_component_EnvironmentListComponent, "propTypes", {
  environments: prop_types_default.a.arrayOf(prop_types_default.a.shape({
    id: prop_types_default.a.string,
    title: prop_types_default.a.string.isRequired,
    description: prop_types_default.a.string
  }).isRequired).isRequired,
  onDeleteEnvironment: prop_types_default.a.func.isRequired,
  onEditEnvironment: prop_types_default.a.func.isRequired
});


// EXTERNAL MODULE: ./node_modules/reselect/es/index.js
var reselect_es = __webpack_require__(432);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/selectors/environment-selectors.js


var getEnvironments = function getEnvironments(state) {
  return state.environmentList.list;
};

var getEnvironmentFilters = function getEnvironmentFilters(state) {
  return state.environmentList.filters;
};

var getFilteredEnvironments = Object(reselect_es["a" /* createSelector */])([getEnvironments, getEnvironmentFilters], function (environments, filters) {
  var title = filters.title,
      stage = filters.stage;
  return environments.filter(function (env) {
    return env.title.toUpperCase().includes(title.toUpperCase()) && (!stage.title || env.stage.title.toUpperCase() === stage.title.toUpperCase());
  });
});
// EXTERNAL MODULE: ./node_modules/react-sidebar/dist/react-sidebar.esm.js
var react_sidebar_esm = __webpack_require__(197);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/colors.js
var colors = __webpack_require__(23);

// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/sidebar-environment-navigation.less
var sidebar_environment_navigation = __webpack_require__(1978);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/sidebar-environment-navigation.js







function sidebar_environment_navigation_createSuper(Derived) { var hasNativeReflectConstruct = sidebar_environment_navigation_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function sidebar_environment_navigation_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }







var menuItems = ['Environments', 'Stages', 'Labels'];
var menuItemsLinks = {
  Environments: '#/environments',
  Stages: '#/environments/stages',
  Labels: '#/environments/labels'
};
var styleSidebar = {
  root: {
    top: '50px'
  },
  content: {
    paddingLeft: '15px',
    paddingRight: '15px'
  },
  sidebar: {
    backgroundColor: colors["a" /* default */].white,
    minWidth: '260px',
    boxShadow: "10px 0 10px -10px ".concat(colors["a" /* default */].background)
  }
};

var sidebar_environment_navigation_EnvironmentSidebarComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(EnvironmentSidebarComponent, _Component);

  var _super = sidebar_environment_navigation_createSuper(EnvironmentSidebarComponent);

  function EnvironmentSidebarComponent() {
    classCallCheck_default()(this, EnvironmentSidebarComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(EnvironmentSidebarComponent, [{
    key: "renderItem",
    value: function renderItem(item) {
      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var style = classnames_default()('item', {
        selected: selected
      });
      return /*#__PURE__*/react_default.a.createElement("a", {
        className: style,
        href: menuItemsLinks[item],
        key: item
      }, item);
    }
  }, {
    key: "renderMenu",
    value: function renderMenu() {
      var _this = this;

      var menuSelected = this.props.menuSelected;
      var items = menuItems.map(function (it) {
        return _this.renderItem(it, menuSelected === it);
      });
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "environment-sidebar"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "sidebar-title"
      }, "Setup"), items);
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/react_default.a.createElement(react_sidebar_esm["a" /* default */], {
        docked: true,
        open: true,
        shadow: false,
        sidebar: this.renderMenu(),
        styles: styleSidebar,
        transitions: false
      }, this.props.children);
    }
  }]);

  return EnvironmentSidebarComponent;
}(react["Component"]);

defineProperty_default()(sidebar_environment_navigation_EnvironmentSidebarComponent, "propTypes", {
  children: prop_types_default.a.element.isRequired,
  menuSelected: prop_types_default.a.oneOf(menuItems).isRequired
});


// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/styles/modal.less
var modal = __webpack_require__(342);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/list/environment-list-page-container.js








function environment_list_page_container_createSuper(Derived) { var hasNativeReflectConstruct = environment_list_page_container_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function environment_list_page_container_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }













var environment_list_page_container_EnvironmentListPageContainer = /*#__PURE__*/function (_Component) {
  inherits_default()(EnvironmentListPageContainer, _Component);

  var _super = environment_list_page_container_createSuper(EnvironmentListPageContainer);

  createClass_default()(EnvironmentListPageContainer, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.props.initEnvironmentList();
    }
  }]);

  function EnvironmentListPageContainer(props) {
    var _this;

    classCallCheck_default()(this, EnvironmentListPageContainer);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "handleFilterChange", function (environmentName) {
      _this.props.titleFilterChange(environmentName);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleStageChange", function (stage) {
      if (stage) {
        _this.props.stageFilterChange(stage);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "buttons", [{
      action: 'cancel',
      className: 'button cancel',
      keyCodes: [27],
      label: 'Cancel'
    }, {
      action: 'ok',
      className: 'button primary',
      keyCodes: [13],
      label: 'Delete'
    }]);

    defineProperty_default()(assertThisInitialized_default()(_this), "openConfirmationDialog", function (environment) {
      _this.setState({
        show: true,
        environmentForDelete: environment
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onClose", function (action) {
      if (action === 'ok') {
        _this.props.onDeleteEnvironment(_this.state.environmentForDelete);
      }

      _this.setState({
        show: false,
        environmentForDelete: null
      });
    });

    _this.state = {
      show: false,
      environmentForDelete: null
    };
    return _this;
  }

  createClass_default()(EnvironmentListPageContainer, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          stages = _this$props.stages,
          filterStage = _this$props.filterStage,
          filterEnvironmentName = _this$props.filterEnvironmentName,
          onAddEnvironment = _this$props.onAddEnvironment,
          environments = _this$props.environments,
          onEditEnvironment = _this$props.onEditEnvironment;
      return /*#__PURE__*/react_default.a.createElement("div", null, /*#__PURE__*/react_default.a.createElement(environment_list_header_component_EnvironmentListHeaderComponent, {
        filterEnvironmentName: filterEnvironmentName,
        filterStage: filterStage,
        onAddNewEnvironment: onAddEnvironment,
        onFilterChange: this.handleFilterChange,
        onStageChange: this.handleStageChange,
        stages: stages
      }), /*#__PURE__*/react_default.a.createElement(sidebar_environment_navigation_EnvironmentSidebarComponent, {
        menuSelected: "Environments"
      }, /*#__PURE__*/react_default.a.createElement(environment_list_component_EnvironmentListComponent, {
        environments: environments,
        onDeleteEnvironment: this.openConfirmationDialog,
        onEditEnvironment: onEditEnvironment
      })), /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: this.buttons,
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onClose,
        show: this.state.show,
        title: "Delete environment"
      }, /*#__PURE__*/react_default.a.createElement(components["a" /* AlertMessage */], {
        alertType: components["q" /* alertType */].WARNING
      }, /*#__PURE__*/react_default.a.createElement("p", null, "Deleting an environment can lead to missing data for connected resources on reporting and environment scheduling.")), /*#__PURE__*/react_default.a.createElement("p", null, "You are about to delete environment ", /*#__PURE__*/react_default.a.createElement("strong", null, this.state.environmentForDelete ? this.state.environmentForDelete.title : ''), ".")));
    }
  }]);

  return EnvironmentListPageContainer;
}(react["Component"]);

defineProperty_default()(environment_list_page_container_EnvironmentListPageContainer, "propTypes", {
  environments: prop_types_default.a.arrayOf(prop_types_default.a.shape({
    id: prop_types_default.a.string,
    title: prop_types_default.a.string.isRequired,
    description: prop_types_default.a.string
  }).isRequired).isRequired,
  filterEnvironmentName: prop_types_default.a.string.isRequired,
  filterStage: Stage,
  initEnvironmentList: prop_types_default.a.func.isRequired,
  onAddEnvironment: prop_types_default.a.func.isRequired,
  onDeleteEnvironment: prop_types_default.a.func.isRequired,
  onEditEnvironment: prop_types_default.a.func.isRequired,
  searchEnvironments: prop_types_default.a.func.isRequired,
  stageFilterChange: prop_types_default.a.func.isRequired,
  stages: prop_types_default.a.arrayOf(Stage),
  titleFilterChange: prop_types_default.a.func.isRequired
});

var environment_list_page_container_mapStateToProps = function mapStateToProps(state) {
  return {
    stages: state.stages.stageList,
    environments: getFilteredEnvironments(state),
    filterStage: state.environmentList.filters.stage,
    filterEnvironmentName: state.environmentList.filters.title
  };
};

/* harmony default export */ var environment_list_page_container = (Object(es["connect"])(environment_list_page_container_mapStateToProps, {
  stageFilterChange: stageFilterChange,
  initEnvironmentList: initEnvironmentList,
  onAddEnvironment: environment_actions_onAddEnvironment,
  onDeleteEnvironment: environment_actions_onDeleteEnvironment,
  onEditEnvironment: environment_actions_onEditEnvironment,
  searchEnvironments: searchEnvironments,
  titleFilterChange: titleFilterChange
})(environment_list_page_container_EnvironmentListPageContainer));
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/list/environment-list-page.js






function environment_list_page_createSuper(Derived) { var hasNativeReflectConstruct = environment_list_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function environment_list_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var environment_list_page_EnvironmentListPage = /*#__PURE__*/function (_Component) {
  inherits_default()(EnvironmentListPage, _Component);

  var _super = environment_list_page_createSuper(EnvironmentListPage);

  function EnvironmentListPage() {
    classCallCheck_default()(this, EnvironmentListPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(EnvironmentListPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/react_default.a.createElement(es["Provider"], {
        store: environment_management_store_store
      }, /*#__PURE__*/react_default.a.createElement(environment_list_page_container, null));
    }
  }]);

  return EnvironmentListPage;
}(react["Component"]);


// EXTERNAL MODULE: ./node_modules/lodash/clone.js
var clone = __webpack_require__(271);
var clone_default = /*#__PURE__*/__webpack_require__.n(clone);

// EXTERNAL MODULE: ./node_modules/lodash/differenceWith.js
var differenceWith = __webpack_require__(807);
var differenceWith_default = /*#__PURE__*/__webpack_require__.n(differenceWith);

// EXTERNAL MODULE: ./node_modules/lodash/isEqual.js
var isEqual = __webpack_require__(131);
var isEqual_default = /*#__PURE__*/__webpack_require__.n(isEqual);

// EXTERNAL MODULE: ./node_modules/lodash/reject.js
var reject = __webpack_require__(435);
var reject_default = /*#__PURE__*/__webpack_require__.n(reject);

// EXTERNAL MODULE: ./node_modules/lodash/some.js
var some = __webpack_require__(194);
var some_default = /*#__PURE__*/__webpack_require__.n(some);

// EXTERNAL MODULE: ./core/xlr-ui/app/react/utils/validators.js
var validators = __webpack_require__(39);

// EXTERNAL MODULE: ./node_modules/lodash/isNil.js
var isNil = __webpack_require__(808);
var isNil_default = /*#__PURE__*/__webpack_require__.n(isNil);

// EXTERNAL MODULE: ./node_modules/react-color/lib/index.js
var lib = __webpack_require__(559);

// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/label/label-modal-form-component.less
var label_modal_form_component = __webpack_require__(748);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/label/label-modal-form-component.js








function label_modal_form_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function label_modal_form_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { label_modal_form_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { label_modal_form_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function label_modal_form_component_createSuper(Derived) { var hasNativeReflectConstruct = label_modal_form_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function label_modal_form_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }












var cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var createButton = {
  action: 'create',
  className: 'button primary',
  keyCodes: [13],
  label: 'Create'
};
var label_modal_form_component_updateButton = {
  action: 'update',
  className: 'button primary',
  keyCodes: [13],
  label: 'Save'
};
var deleteButton = {
  action: 'delete',
  className: 'button secondary',
  label: 'Delete'
};
var deleteModalDeleteButton = {
  action: 'delete-modal-ok',
  className: 'button primary',
  keyCodes: [13],
  label: 'Delete'
};
var deleteModalCancelButton = {
  action: 'delete-modal-cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var titleFieldMetadata = {
  label: 'Name',
  placeholder: 'Add...',
  description: 'Name of the label',
  required: true
};

var label_modal_form_component_nameValidator = function nameValidator(envLabelList) {
  var id = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  return function (name) {
    return {
      condition: Object(validators["b" /* itemAlreadyDefined */])(envLabelList, id, 'title', name),
      message: Object(validators["a" /* createErrorMessage */])('Label already exists')
    };
  };
};

var label_modal_form_component_maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: Object(validators["e" /* validateMaxLength */])(inputText, maxLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};

var defaultColorList = [colors["a" /* default */].blue, colors["a" /* default */].green, colors["a" /* default */].orange, colors["a" /* default */].red, colors["a" /* default */].gray, colors["a" /* default */].purple];

var label_modal_form_component_LabelModalFormComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(LabelModalFormComponent, _Component);

  var _super = label_modal_form_component_createSuper(LabelModalFormComponent);

  createClass_default()(LabelModalFormComponent, null, [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(props, state) {
      if (!state.labelModel || props.envLabelModel.title !== state.prevModel.title) {
        return label_modal_form_component_objectSpread({}, state, {
          labelModel: props.envLabelModel,
          prevModel: props.envLabelModel
        });
      }

      return null;
    }
  }]);

  function LabelModalFormComponent(props) {
    var _this;

    classCallCheck_default()(this, LabelModalFormComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onRegister", function (componentApi) {
      componentApi.focus();
      _this.componentApi = componentApi;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "closeModal", function () {
      _this.cancelForm();

      _this.resetForm();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onButtonClick", function (action) {
      var _this$props = _this.props,
          onModalConfirm = _this$props.onModalConfirm,
          onModalDelete = _this$props.onModalDelete;
      var _this$state = _this.state,
          createAnother = _this$state.createAnother,
          labelModel = _this$state.labelModel;

      switch (action) {
        case createButton.action:
          onModalConfirm(labelModel, createAnother);

          _this.resetForm();

          break;

        case label_modal_form_component_updateButton.action:
          onModalConfirm(labelModel, createAnother);

          _this.resetForm();

          break;

        case deleteButton.action:
          _this.setState({
            isDeleteModal: true
          });

          break;

        case deleteModalCancelButton.action:
          _this.setState({
            isDeleteModal: false
          });

          break;

        case deleteModalDeleteButton.action:
          _this.setState({
            isDeleteModal: false
          });

          if (onModalDelete) {
            onModalDelete(labelModel);
          }

          break;

        default:
          _this.cancelForm();

          _this.resetForm();

      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "cancelForm", function () {
      _this.setState({
        createAnother: false
      });

      _this.props.onModalCancel();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "resetForm", function () {
      _this.colorIsChanged = null;

      _this.setState({
        labelModel: null
      });

      if (_this.componentApi) {
        _this.componentApi.resetPristinity();

        _this.componentApi.focus();
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCheckboxClick", function (value) {
      _this.setState({
        createAnother: value.target.checked
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onModelChange", function (title) {
      var labelModel = _this.state.labelModel;

      if (title !== labelModel.title) {
        _this.setState({
          labelModel: label_modal_form_component_objectSpread({}, labelModel, {
            title: title
          })
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleValidityChange", function (valid) {
      _this.isValid = valid;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handlePristinityChange", function (pristine) {
      _this.isPristine = pristine;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onColorChangeComplete", function (color) {
      var labelModel = _this.state.labelModel;

      if (labelModel.color !== color.hex) {
        _this.colorIsChanged = true;
      }

      _this.setState({
        displayColorPicker: false,
        labelModel: label_modal_form_component_objectSpread({}, labelModel, {
          color: color.hex
        })
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "openColorPicker", function () {
      _this.setState({
        displayColorPicker: !_this.state.displayColorPicker
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "closeColorPicker", function () {
      _this.setState({
        displayColorPicker: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderColorPickerPopover", function () {
      var displayColorPicker = _this.state.displayColorPicker;
      var color = _this.props.envLabelModel.color;
      return displayColorPicker ? /*#__PURE__*/react_default.a.createElement("div", {
        className: "color-picker-popover"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "cover",
        onClick: _this.closeColorPicker
      }), /*#__PURE__*/react_default.a.createElement(lib["TwitterPicker"], {
        color: color,
        colors: defaultColorList,
        onChangeComplete: _this.onColorChangeComplete,
        width: "204"
      })) : null;
    });

    _this.state = {
      createAnother: false,
      displayColorPicker: false,
      isDeleteModal: false,
      labelModel: null,
      prevModel: null
    };
    _this.isPristine = null;
    _this.isValid = null;
    _this.colorIsChanged = null;
    _this.componentApi = null;
    return _this;
  }

  createClass_default()(LabelModalFormComponent, [{
    key: "renderDeleteModal",
    value: function renderDeleteModal() {
      var _this$props2 = this.props,
          envLabelModel = _this$props2.envLabelModel,
          modalIsOpen = _this$props2.modalIsOpen;
      return /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [deleteModalCancelButton, deleteModalDeleteButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onButtonClick,
        show: modalIsOpen,
        title: "Delete label"
      }, /*#__PURE__*/react_default.a.createElement(components["a" /* AlertMessage */], {
        alertType: components["q" /* alertType */].WARNING
      }, /*#__PURE__*/react_default.a.createElement("p", null, "Deleting a label can lead to missing data for connected resources on reporting and environment scheduling.")), /*#__PURE__*/react_default.a.createElement("p", null, "You are about to delete label ", /*#__PURE__*/react_default.a.createElement("strong", null, envLabelModel.title), "."));
    }
  }, {
    key: "renderEditModal",
    value: function renderEditModal() {
      var _this$props3 = this.props,
          modalIsOpen = _this$props3.modalIsOpen,
          envLabelList = _this$props3.envLabelList,
          envLabelModel = _this$props3.envLabelModel;
      var labelModel = this.state.labelModel;
      var confirmActionButtonDisabled = this.isPristine && !this.colorIsChanged || !this.isValid;
      var buttons = [cancelButton];
      var modalTitle, modalSkin;

      if (isNil_default()(envLabelModel.id)) {
        createButton.disabled = confirmActionButtonDisabled;
        buttons.push(createButton);
        modalTitle = 'New label';
        modalSkin = 'checkbox';
      } else {
        label_modal_form_component_updateButton.disabled = confirmActionButtonDisabled;
        buttons.push(deleteButton);
        buttons.push(label_modal_form_component_updateButton);
        modalTitle = 'Edit label';
        modalSkin = 'default';
      }

      if (isEmpty_default()(envLabelModel.color)) {
        envLabelModel.color = defaultColorList[0];
      }

      var modalHeader = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, modalTitle, /*#__PURE__*/react_default.a.createElement("button", {
        className: "btn-close",
        onClick: this.closeModal,
        type: "button"
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: buttons,
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onButtonClick,
        onCheckboxClick: this.onCheckboxClick,
        show: modalIsOpen,
        skin: modalSkin,
        title: modalHeader
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "environment-label-form"
      }, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetString"], {
        metadata: titleFieldMetadata,
        model: labelModel.title,
        onModelChange: this.onModelChange,
        onPristinityChange: this.handlePristinityChange,
        onValidityChange: this.handleValidityChange,
        register: this.onRegister,
        validators: [label_modal_form_component_nameValidator(envLabelList, labelModel.id), label_modal_form_component_maxLengthValidator(titleFieldMetadata.label, 255)]
      }), /*#__PURE__*/react_default.a.createElement("div", {
        className: "xl-react-components"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "xl-react-components-label"
      }, /*#__PURE__*/react_default.a.createElement("label", null, "Color", /*#__PURE__*/react_default.a.createElement("span", {
        className: "required"
      }, "*"))), /*#__PURE__*/react_default.a.createElement("div", {
        className: "xl-react-components-input"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "swatch",
        onClick: this.openColorPicker
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "color",
        style: {
          background: labelModel.color
        }
      })), this.renderColorPickerPopover()))));
    }
  }, {
    key: "render",
    value: function render() {
      var isDeleteModal = this.state.isDeleteModal;
      return isDeleteModal ? this.renderDeleteModal() : this.renderEditModal();
    }
  }]);

  return LabelModalFormComponent;
}(react["Component"]);

defineProperty_default()(label_modal_form_component_LabelModalFormComponent, "propTypes", {
  envLabelList: prop_types_default.a.arrayOf(prop_types_default.a.shape({
    color: prop_types_default.a.string.isRequired,
    id: prop_types_default.a.string.isRequired,
    title: prop_types_default.a.string.isRequired
  }).isRequired).isRequired,
  envLabelModel: prop_types_default.a.shape({
    color: prop_types_default.a.string,
    id: prop_types_default.a.string,
    title: prop_types_default.a.string
  }).isRequired,
  modalIsOpen: prop_types_default.a.bool.isRequired,
  onModalCancel: prop_types_default.a.func.isRequired,
  onModalConfirm: prop_types_default.a.func.isRequired,
  onModalDelete: prop_types_default.a.func
});


// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/label/label-list-header-component.js








function label_list_header_component_createSuper(Derived) { var hasNativeReflectConstruct = label_list_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function label_list_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }









var label_list_header_component_LabelListHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(LabelListHeaderComponent, _Component);

  var _super = label_list_header_component_createSuper(LabelListHeaderComponent);

  function LabelListHeaderComponent() {
    var _this;

    classCallCheck_default()(this, LabelListHeaderComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "showCreateModal", function () {
      _this.props.onCreate();
    });

    return _this;
  }

  createClass_default()(LabelListHeaderComponent, [{
    key: "render",
    value: function render() {
      var onFilterChange = this.props.onFilterChange;
      var filterFieldMetadata = {
        placeholder: 'Filter by label...'
      };
      return /*#__PURE__*/react_default.a.createElement(header_component_HeaderComponent, {
        helpUrl: "environments.html"
      }, /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetFilter"], {
        metadata: filterFieldMetadata,
        onUpdate: onFilterChange
      }), /*#__PURE__*/react_default.a.createElement("div", {
        className: "buttons"
      }, /*#__PURE__*/react_default.a.createElement("button", {
        className: "button primary",
        onClick: this.showCreateModal
      }, "New label"))));
    }
  }]);

  return LabelListHeaderComponent;
}(react["Component"]);

defineProperty_default()(label_list_header_component_LabelListHeaderComponent, "propTypes", {
  onCreate: prop_types_default.a.func.isRequired,
  onFilterChange: prop_types_default.a.func.isRequired
});


// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/label/label-list-component.js








function label_list_component_createSuper(Derived) { var hasNativeReflectConstruct = label_list_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function label_list_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }










var initEnvLabelState = function initEnvLabelState() {
  return {
    id: null,
    title: '',
    color: ''
  };
};
var label_list_component_helpMessage = "Use Labels to identify your environments. You also use Labels to filter the environment scheduler and dashboards.";

var label_list_component_LabelListComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(LabelListComponent, _Component);

  var _super = label_list_component_createSuper(LabelListComponent);

  function LabelListComponent(props) {
    var _this;

    classCallCheck_default()(this, LabelListComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onFilterChange", function (title) {
      _this.props.searchLabels(title);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showCreateModal", function () {
      _this.setState({
        modalIsOpen: true,
        envLabel: initEnvLabelState()
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showEditModal", function (envLabel) {
      _this.setState({
        modalIsOpen: true,
        envLabel: clone_default()(envLabel)
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onConfirmEditModal", function (envLabel, isCreateAnother) {
      _this.props.saveLabel(envLabel);

      var envLabelState = initEnvLabelState();

      if (isCreateAnother) {
        envLabelState.color = envLabel.color;
      }

      _this.setState({
        modalIsOpen: isCreateAnother,
        envLabel: envLabelState
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCancelEditModal", function () {
      _this.setState({
        modalIsOpen: false,
        envLabel: initEnvLabelState()
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onConfirmDeleteModal", function (envLabel) {
      _this.props.deleteLabel(envLabel);

      _this.onCancelEditModal();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderEnvLabel", function (envLabel) {
      return /*#__PURE__*/react_default.a.createElement(label_item_LabelItem, {
        envLabel: envLabel,
        isEditable: true,
        key: envLabel.id,
        onClickLabel: _this.showEditModal
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderLabels", function () {
      var labelList = _this.props.labelList;
      var labels = labelList.map(_this.renderEnvLabel);
      return /*#__PURE__*/react_default.a.createElement("div", null, /*#__PURE__*/react_default.a.createElement("h4", {
        className: "page-title"
      }, "Labels (", labels.length, ")"), /*#__PURE__*/react_default.a.createElement(components["f" /* HelpBlock */], {
        className: "help-message-container"
      }, label_list_component_helpMessage), labels.length ? labels : /*#__PURE__*/react_default.a.createElement(components["g" /* NoData */], {
        className: "no-labels-message",
        message: "No labels found."
      }));
    });

    _this.state = {
      modalIsOpen: false,
      envLabel: initEnvLabelState()
    };
    return _this;
  }

  createClass_default()(LabelListComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.props.searchLabels();
    }
  }, {
    key: "render",
    value: function render() {
      var labelList = this.props.labelList;
      var _this$state = this.state,
          modalIsOpen = _this$state.modalIsOpen,
          envLabel = _this$state.envLabel;
      return /*#__PURE__*/react_default.a.createElement("div", null, /*#__PURE__*/react_default.a.createElement(label_list_header_component_LabelListHeaderComponent, {
        onCreate: this.showCreateModal,
        onFilterChange: this.onFilterChange
      }), /*#__PURE__*/react_default.a.createElement(sidebar_environment_navigation_EnvironmentSidebarComponent, {
        menuSelected: "Labels"
      }, this.renderLabels()), /*#__PURE__*/react_default.a.createElement(label_modal_form_component_LabelModalFormComponent, {
        envLabelList: labelList,
        envLabelModel: envLabel,
        modalIsOpen: modalIsOpen,
        onModalCancel: this.onCancelEditModal,
        onModalConfirm: this.onConfirmEditModal,
        onModalDelete: this.onConfirmDeleteModal
      }));
    }
  }]);

  return LabelListComponent;
}(react["Component"]);

defineProperty_default()(label_list_component_LabelListComponent, "propTypes", {
  deleteLabel: prop_types_default.a.func.isRequired,
  labelList: prop_types_default.a.arrayOf(prop_types_default.a.shape({
    color: prop_types_default.a.string.isRequired,
    id: prop_types_default.a.string.isRequired,
    title: prop_types_default.a.string.isRequired
  }).isRequired).isRequired,
  saveLabel: prop_types_default.a.func.isRequired,
  searchLabels: prop_types_default.a.func.isRequired
});


// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/edit/sidebar-label-list.less
var sidebar_label_list = __webpack_require__(2040);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/edit/sidebar-label-list.js








function sidebar_label_list_createSuper(Derived) { var hasNativeReflectConstruct = sidebar_label_list_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function sidebar_label_list_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }









var filterLabelFieldMetadata = {
  placeholder: 'Filter by label...'
};

var sidebar_label_list_SidebarLabelList = /*#__PURE__*/function (_Component) {
  inherits_default()(SidebarLabelList, _Component);

  var _super = sidebar_label_list_createSuper(SidebarLabelList);

  function SidebarLabelList(props) {
    var _this;

    classCallCheck_default()(this, SidebarLabelList);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onNameChange", function (name) {
      _this.setState({
        labelFilterText: name
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "filterLabels", function (envLabel) {
      var labelFilterText = _this.state.labelFilterText;
      return includes_default()(envLabel.title.toLowerCase(), labelFilterText.toLowerCase());
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showCreateLabelModal", function () {
      _this.setState({
        modalIsOpen: true,
        envLabel: initEnvLabelState()
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onConfirmEditModal", function (envLabel, isCreateAnother) {
      _this.props.saveLabel({
        title: envLabel.title,
        color: envLabel.color
      });

      _this.setState({
        modalIsOpen: isCreateAnother,
        envLabel: initEnvLabelState()
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCancelEditModal", function () {
      _this.setState({
        modalIsOpen: false,
        envLabel: initEnvLabelState()
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderLabels", function () {
      var _this$props = _this.props,
          labelList = _this$props.labelList,
          onClickLabel = _this$props.onClickLabel;
      return labelList.filter(function (envLabel) {
        return _this.filterLabels(envLabel);
      }).map(function (envLabel) {
        return /*#__PURE__*/react_default.a.createElement(label_item_LabelItem, {
          envLabel: envLabel,
          key: envLabel.id,
          onClickLabel: onClickLabel,
          skin: 'plus'
        });
      });
    });

    _this.state = {
      envLabel: initEnvLabelState(),
      modalIsOpen: false,
      labelFilterText: ''
    };
    return _this;
  }

  createClass_default()(SidebarLabelList, [{
    key: "render",
    value: function render() {
      var labelList = this.props.labelList;
      var _this$state = this.state,
          envLabel = _this$state.envLabel,
          modalIsOpen = _this$state.modalIsOpen;
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement("div", {
        className: "environment-label-sidebar"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "header"
      }, /*#__PURE__*/react_default.a.createElement("h4", {
        className: "page-title"
      }, "Labels", /*#__PURE__*/react_default.a.createElement("button", {
        className: "button pull-right",
        onClick: this.showCreateLabelModal,
        type: "button"
      }, "New label")), /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetFilter"], {
        metadata: filterLabelFieldMetadata,
        onUpdate: this.onNameChange
      })), /*#__PURE__*/react_default.a.createElement("div", {
        className: "environment-sidebar-label-list"
      }, this.renderLabels())), /*#__PURE__*/react_default.a.createElement(label_modal_form_component_LabelModalFormComponent, {
        envLabelList: labelList,
        envLabelModel: envLabel,
        modalIsOpen: modalIsOpen,
        onModalCancel: this.onCancelEditModal,
        onModalConfirm: this.onConfirmEditModal
      }));
    }
  }]);

  return SidebarLabelList;
}(react["Component"]);

defineProperty_default()(sidebar_label_list_SidebarLabelList, "propTypes", {
  labelList: prop_types_default.a.arrayOf(prop_types_default.a.shape({
    color: prop_types_default.a.string.isRequired,
    id: prop_types_default.a.string.isRequired,
    title: prop_types_default.a.string.isRequired
  }).isRequired).isRequired,
  onClickLabel: prop_types_default.a.func.isRequired,
  saveLabel: prop_types_default.a.func.isRequired
});

defineProperty_default()(sidebar_label_list_SidebarLabelList, "defaultProps", {
  labelList: {}
});


// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/shared/widgets/widget-linked-labels.less
var widget_linked_labels = __webpack_require__(2041);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/shared/widgets/widget-linked-labels.js








function widget_linked_labels_createSuper(Derived) { var hasNativeReflectConstruct = widget_linked_labels_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function widget_linked_labels_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }








var labelsFiledMetadata = {
  label: 'Labels',
  required: false
};

var widget_linked_labels_WidgetLinkedLabels = /*#__PURE__*/function (_Component) {
  inherits_default()(WidgetLinkedLabels, _Component);

  var _super = widget_linked_labels_createSuper(WidgetLinkedLabels);

  function WidgetLinkedLabels() {
    var _this;

    classCallCheck_default()(this, WidgetLinkedLabels);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "renderEmptyContainer", function () {
      return /*#__PURE__*/react_default.a.createElement(components["f" /* HelpBlock */], null, "Click a label on the right to assign it to the environment");
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderContainer", function (labelList) {
      var onDelete = _this.props.onDelete;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "list-block-label-title"
      }, labelList.map(function (envLabel) {
        return /*#__PURE__*/react_default.a.createElement(label_item_LabelItem, {
          envLabel: envLabel,
          key: envLabel.id,
          onClickLabel: onDelete,
          skin: 'remove'
        });
      }));
    });

    return _this;
  }

  createClass_default()(WidgetLinkedLabels, [{
    key: "render",
    value: function render() {
      var labelList = this.props.labelList;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "xl-react-components"
      }, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetLabel"], {
        metadata: labelsFiledMetadata
      }), /*#__PURE__*/react_default.a.createElement("div", {
        className: "xl-react-components-input"
      }, labelList.length ? this.renderContainer(labelList) : this.renderEmptyContainer()));
    }
  }]);

  return WidgetLinkedLabels;
}(react["Component"]);

defineProperty_default()(widget_linked_labels_WidgetLinkedLabels, "propTypes", {
  labelList: prop_types_default.a.arrayOf(Label).isRequired,
  onDelete: prop_types_default.a.func.isRequired
});

defineProperty_default()(widget_linked_labels_WidgetLinkedLabels, "defaultProps", {
  labelList: []
});


// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/edit/environment-form-component.less
var environment_form_component = __webpack_require__(2042);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/edit/environment-form-component.js








function environment_form_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function environment_form_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { environment_form_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { environment_form_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function environment_form_component_createSuper(Derived) { var hasNativeReflectConstruct = environment_form_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function environment_form_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }


















var nameFormMetadata = {
  label: 'Name',
  placeholder: 'Add...',
  description: 'Name of the environment',
  required: true
};
var descriptionFormMetadata = {
  label: 'Description',
  placeholder: 'Set description...',
  description: 'Description of the environment',
  size: 'MEDIUM'
};
var selectFormMetadata = {
  description: 'Name of the stage',
  label: 'Stage',
  placeholder: 'Select stage...',
  required: true
};

var findEnvironmentById = function findEnvironmentById(environments, id) {
  return environments.find(function (e) {
    return e.id === id;
  }) || {};
};

var environment_form_component_nameValidator = function nameValidator(environments, selectedId) {
  return function (name) {
    return {
      condition: Object(validators["b" /* itemAlreadyDefined */])(environments, selectedId, 'title', name),
      message: Object(validators["a" /* createErrorMessage */])('Environment already exists')
    };
  };
};

var environment_form_component_maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: Object(validators["e" /* validateMaxLength */])(inputText, maxLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};

var environment_form_component_EnvironmentFormComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(EnvironmentFormComponent, _Component);

  var _super = environment_form_component_createSuper(EnvironmentFormComponent);

  function EnvironmentFormComponent(props) {
    var _this;

    classCallCheck_default()(this, EnvironmentFormComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onRegister", function (componentApi) {
      componentApi.focus();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNameChange", function (title) {
      var _this$props = _this.props,
          environmentModel = _this$props.environmentModel,
          onFormChange = _this$props.onFormChange;

      if (title !== environmentModel.title) {
        onFormChange(environment_form_component_objectSpread({}, environmentModel, {
          title: title
        }));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onStageChange", function (stage) {
      var _this$props2 = _this.props,
          environmentModel = _this$props2.environmentModel,
          onFormChange = _this$props2.onFormChange;

      if (stage && stage.id !== environmentModel.stage.id) {
        onFormChange(environment_form_component_objectSpread({}, environmentModel, {
          stage: stage
        }));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDescriptionChange", function (description) {
      var _this$props3 = _this.props,
          environmentModel = _this$props3.environmentModel,
          onFormChange = _this$props3.onFormChange;

      if (description !== environmentModel.description) {
        onFormChange(environment_form_component_objectSpread({}, environmentModel, {
          description: description
        }));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onAddLabel", function (envLabel) {
      var environmentModel = _this.props.environmentModel;
      var labels = clone_default()(environmentModel.labels);

      if (!some_default()(environmentModel.labels, {
        id: envLabel.id
      })) {
        labels.push(envLabel);
      }

      _this.props.onFormChange(environment_form_component_objectSpread({}, environmentModel, {
        labels: labels
      }));

      _this.props.onPristinityChange(false);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onRemoveLabel", function (envLabel) {
      var environmentModel = _this.props.environmentModel;
      var labels = reject_default()(environmentModel.labels, {
        id: envLabel.id
      });

      _this.props.onFormChange(environment_form_component_objectSpread({}, environmentModel, {
        labels: labels
      }));

      _this.props.onPristinityChange(false);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNameValidityChange", function (valid) {
      var onValidationChange = _this.props.onValidationChange;
      _this.isNameValid = valid;
      onValidationChange(_this.isFormValid);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onStageValidityChange", function (valid) {
      var onValidationChange = _this.props.onValidationChange;
      _this.isStageValid = valid;
      onValidationChange(_this.isFormValid);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNamePristine", function (pristine) {
      _this.setState({
        namePristine: pristine
      });

      var _this$state = _this.state,
          descriptionPristine = _this$state.descriptionPristine,
          stagePristine = _this$state.stagePristine;
      var isFormPristine = pristine && descriptionPristine && stagePristine;

      _this.props.onPristinityChange(isFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDescPristine", function (pristine) {
      _this.setState({
        descriptionPristine: pristine
      });

      var _this$state2 = _this.state,
          namePristine = _this$state2.namePristine,
          stagePristine = _this$state2.stagePristine;
      var isFormPristine = pristine && namePristine && stagePristine;

      _this.props.onPristinityChange(isFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onStagePristine", function (pristine) {
      _this.setState({
        stagePristine: pristine
      });

      var _this$state3 = _this.state,
          namePristine = _this$state3.namePristine,
          descriptionPristine = _this$state3.descriptionPristine;
      var isFormPristine = pristine && namePristine && descriptionPristine;

      _this.props.onPristinityChange(isFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderSidebarContent", function () {
      var _this$props4 = _this.props,
          environmentModel = _this$props4.environmentModel,
          labelList = _this$props4.labelList,
          saveLabel = _this$props4.saveLabel;
      var filteredLabelList = differenceWith_default()(labelList, environmentModel.labels, isEqual_default.a);
      return /*#__PURE__*/react_default.a.createElement(sidebar_label_list_SidebarLabelList, {
        labelList: filteredLabelList,
        onClickLabel: _this.onAddLabel,
        saveLabel: saveLabel
      });
    });

    _this.state = {
      namePristine: true,
      descriptionPristine: true,
      stagePristine: true
    };
    _this.isNameValid = false;
    _this.isStageValid = false;
    return _this;
  }

  createClass_default()(EnvironmentFormComponent, [{
    key: "render",
    value: function render() {
      var _this$props5 = this.props,
          environmentModel = _this$props5.environmentModel,
          environments = _this$props5.environments,
          stageList = _this$props5.stageList;
      var env = findEnvironmentById(environments, environmentModel.id);
      var subtitle = isEmpty_default()(env) ? 'New Environment' : env.title;

      var autocompleteHandler = function autocompleteHandler(_ref) {
        var metadata = _ref.metadata,
            objLabel = _ref.objLabel,
            suggestedElements = _ref.suggestedElements,
            value = _ref.value;
        return Promise.resolve(sortBy_default()(stageList.filter(function (c) {
          return includes_default()(c.title.toLowerCase(), value.toLowerCase());
        }), ['title']));
      };

      var autocompleteHandlers = {
        addCandidates: autocompleteHandler
      };
      return /*#__PURE__*/react_default.a.createElement(react_sidebar_esm["a" /* default */], {
        contentClassName: "environment-form-content",
        docked: true,
        open: true,
        pullRight: true,
        shadow: false,
        sidebar: this.renderSidebarContent(),
        sidebarClassName: "environment-form-sidebar",
        transitions: false
      }, /*#__PURE__*/react_default.a.createElement("h4", {
        className: "page-title",
        id: "environment-form-title"
      }, "Environments / ", subtitle), /*#__PURE__*/react_default.a.createElement("div", {
        className: "environment-form"
      }, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetString"], {
        metadata: nameFormMetadata,
        model: environmentModel.title,
        onModelChange: this.onNameChange,
        onPristinityChange: this.onNamePristine,
        onValidityChange: this.onNameValidityChange,
        register: this.onRegister,
        validators: [environment_form_component_nameValidator(environments, environmentModel.id), environment_form_component_maxLengthValidator(nameFormMetadata.label, 255)]
      }), /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetAutocomplete"], {
        handlers: autocompleteHandlers,
        metadata: selectFormMetadata,
        model: environmentModel.stage,
        objLabel: 'title',
        onModelChange: this.onStageChange,
        onPristinityChange: this.onStagePristine,
        onValidityChange: this.onStageValidityChange
      }), /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetString"], {
        metadata: descriptionFormMetadata,
        model: environmentModel.description,
        onModelChange: this.onDescriptionChange,
        onPristinityChange: this.onDescPristine,
        validators: [environment_form_component_maxLengthValidator(descriptionFormMetadata.label, 1024)]
      }), /*#__PURE__*/react_default.a.createElement(widget_linked_labels_WidgetLinkedLabels, {
        labelList: environmentModel.labels,
        onDelete: this.onRemoveLabel
      })));
    }
  }, {
    key: "isFormValid",
    get: function get() {
      return this.isNameValid && this.isStageValid;
    }
  }]);

  return EnvironmentFormComponent;
}(react["Component"]);

defineProperty_default()(environment_form_component_EnvironmentFormComponent, "propTypes", {
  environmentModel: prop_types_default.a.shape({
    stage: prop_types_default.a.shape({
      id: prop_types_default.a.string,
      title: prop_types_default.a.string
    }),
    description: prop_types_default.a.string.isRequired,
    title: prop_types_default.a.string.isRequired,
    id: prop_types_default.a.string,
    labels: prop_types_default.a.arrayOf(prop_types_default.a.shape({
      color: prop_types_default.a.string.isRequired,
      id: prop_types_default.a.string.isRequired,
      title: prop_types_default.a.string.isRequired
    }))
  }).isRequired,
  environments: prop_types_default.a.arrayOf(prop_types_default.a.shape({
    id: prop_types_default.a.string,
    title: prop_types_default.a.string.isRequired,
    description: prop_types_default.a.string
  })).isRequired,
  labelList: prop_types_default.a.arrayOf(prop_types_default.a.shape({
    color: prop_types_default.a.string.isRequired,
    id: prop_types_default.a.string.isRequired,
    title: prop_types_default.a.string.isRequired
  }).isRequired).isRequired,
  onFormChange: prop_types_default.a.func.isRequired,
  onPristinityChange: prop_types_default.a.func.isRequired,
  onValidationChange: prop_types_default.a.func.isRequired,
  saveLabel: prop_types_default.a.func.isRequired,
  stageList: prop_types_default.a.arrayOf(prop_types_default.a.shape({
    id: prop_types_default.a.string.isRequired,
    title: prop_types_default.a.string.isRequired
  })).isRequired
});


// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/edit/environment-form-container.js








function environment_form_container_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function environment_form_container_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { environment_form_container_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { environment_form_container_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function environment_form_container_createSuper(Derived) { var hasNativeReflectConstruct = environment_form_container_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function environment_form_container_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }







var environment_form_container_EnvironmentFormContainer = /*#__PURE__*/function (_Component) {
  inherits_default()(EnvironmentFormContainer, _Component);

  var _super = environment_form_container_createSuper(EnvironmentFormContainer);

  function EnvironmentFormContainer() {
    var _this;

    classCallCheck_default()(this, EnvironmentFormContainer);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "handleFormChange", function (environment) {
      var onFormChange = _this.props.onFormChange;
      onFormChange(environment);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleFormPristineChange", function (pristine) {
      var onFormPristineChange = _this.props.onFormPristineChange;
      onFormPristineChange(pristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleFormValidChange", function (valid) {
      var onFormValidChange = _this.props.onFormValidChange;
      onFormValidChange(valid);
    });

    return _this;
  }

  createClass_default()(EnvironmentFormContainer, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var initEnvironmentForm = this.props.initEnvironmentForm;
      initEnvironmentForm();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var cleanEnvironment = this.props.cleanEnvironment;
      cleanEnvironment();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          stageList = _this$props.stageList,
          environments = _this$props.environments,
          environmentModel = _this$props.environmentModel,
          saveLabel = _this$props.saveLabel,
          labelList = _this$props.labelList;
      return /*#__PURE__*/react_default.a.createElement("div", null, /*#__PURE__*/react_default.a.createElement(environment_form_component_EnvironmentFormComponent, {
        environmentModel: environmentModel,
        environments: environments,
        labelList: labelList,
        onFormChange: this.handleFormChange,
        onPristinityChange: this.handleFormPristineChange,
        onValidationChange: this.handleFormValidChange,
        saveLabel: saveLabel,
        stageList: stageList
      }));
    }
  }]);

  return EnvironmentFormContainer;
}(react["Component"]);

defineProperty_default()(environment_form_container_EnvironmentFormContainer, "propTypes", {
  cleanEnvironment: prop_types_default.a.func.isRequired,
  environmentId: prop_types_default.a.string,
  environmentModel: prop_types_default.a.shape({
    stage: prop_types_default.a.shape({
      id: prop_types_default.a.string,
      title: prop_types_default.a.string
    }),
    id: prop_types_default.a.string,
    labels: prop_types_default.a.arrayOf(prop_types_default.a.shape({
      color: prop_types_default.a.string.isRequired,
      id: prop_types_default.a.string.isRequired,
      title: prop_types_default.a.string.isRequired
    })),
    title: prop_types_default.a.string.isRequired,
    description: prop_types_default.a.string.isRequired
  }).isRequired,
  environments: prop_types_default.a.arrayOf(prop_types_default.a.shape({
    id: prop_types_default.a.string,
    title: prop_types_default.a.string.isRequired,
    description: prop_types_default.a.string
  })).isRequired,
  initEnvironmentForm: prop_types_default.a.func.isRequired,
  labelList: prop_types_default.a.arrayOf(prop_types_default.a.shape({
    color: prop_types_default.a.string.isRequired,
    id: prop_types_default.a.string.isRequired,
    title: prop_types_default.a.string.isRequired
  }).isRequired).isRequired,
  onFormChange: prop_types_default.a.func.isRequired,
  onFormPristineChange: prop_types_default.a.func.isRequired,
  onFormValidChange: prop_types_default.a.func.isRequired,
  saveLabel: prop_types_default.a.func.isRequired,
  stageList: prop_types_default.a.arrayOf(prop_types_default.a.shape({
    id: prop_types_default.a.string.isRequired,
    title: prop_types_default.a.string.isRequired
  })).isRequired
});

var environment_form_container_mapStateToProps = function mapStateToProps(state) {
  return {
    environmentModel: state.environmentForm.environmentModel,
    environments: state.environmentForm.environments,
    stageList: state.stages.stageList,
    labelList: state.labels.labelList
  };
};

var mergeProps = function mergeProps(stateProps, dispatchProps, ownProps) {
  return environment_form_container_objectSpread({}, ownProps, {}, stateProps, {}, dispatchProps, {
    initEnvironmentForm: function initEnvironmentForm() {
      return dispatchProps.initEnvironmentForm(ownProps.environmentId, ownProps.environments);
    }
  });
};

/* harmony default export */ var environment_form_container = (Object(es["connect"])(environment_form_container_mapStateToProps, {
  cleanEnvironment: cleanEnvironment,
  initEnvironmentForm: initEnvironmentForm,
  onFormChange: onFormChange,
  onFormPristineChange: onFormPristineChange,
  onFormValidChange: onFormValidChange,
  saveLabel: label_actions_saveLabel
}, mergeProps)(environment_form_container_EnvironmentFormContainer));
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/edit/environment-edit-header-component.js







function environment_edit_header_component_createSuper(Derived) { var hasNativeReflectConstruct = environment_edit_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function environment_edit_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var environment_edit_header_component_EnvironmentEditHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(EnvironmentEditHeaderComponent, _Component);

  var _super = environment_edit_header_component_createSuper(EnvironmentEditHeaderComponent);

  function EnvironmentEditHeaderComponent() {
    classCallCheck_default()(this, EnvironmentEditHeaderComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(EnvironmentEditHeaderComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          onCancel = _this$props.onCancel,
          onSave = _this$props.onSave,
          saveEnabled = _this$props.saveEnabled,
          environmentId = _this$props.environmentId;
      var caption = isEmpty_default()(environmentId) ? 'Create' : 'Save';
      return /*#__PURE__*/react_default.a.createElement(header_component_HeaderComponent, {
        helpUrl: "environments.html"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "buttons"
      }, /*#__PURE__*/react_default.a.createElement("button", {
        className: "button cancel",
        onClick: onCancel
      }, "Cancel"), /*#__PURE__*/react_default.a.createElement("button", {
        className: "button primary",
        disabled: !saveEnabled,
        onClick: onSave
      }, caption)));
    }
  }]);

  return EnvironmentEditHeaderComponent;
}(react["Component"]);

defineProperty_default()(environment_edit_header_component_EnvironmentEditHeaderComponent, "propTypes", {
  environmentId: prop_types_default.a.string,
  onCancel: prop_types_default.a.func.isRequired,
  onSave: prop_types_default.a.func.isRequired,
  saveEnabled: prop_types_default.a.bool.isRequired
});


// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/edit/environment-edit-page-container.js








function environment_edit_page_container_createSuper(Derived) { var hasNativeReflectConstruct = environment_edit_page_container_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function environment_edit_page_container_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }








var environment_edit_page_container_EnvironmentEditPageContainer = /*#__PURE__*/function (_Component) {
  inherits_default()(EnvironmentEditPageContainer, _Component);

  var _super = environment_edit_page_container_createSuper(EnvironmentEditPageContainer);

  function EnvironmentEditPageContainer() {
    var _this;

    classCallCheck_default()(this, EnvironmentEditPageContainer);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "onSave", function () {
      var _this$props = _this.props,
          environmentModel = _this$props.environmentModel,
          onFormSave = _this$props.onFormSave;
      onFormSave(environmentModel);
    });

    return _this;
  }

  createClass_default()(EnvironmentEditPageContainer, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          formIsPristine = _this$props2.formIsPristine,
          formIsValid = _this$props2.formIsValid,
          environmentId = _this$props2.environmentId,
          onFormCancel = _this$props2.onFormCancel;
      var saveEnabled = !formIsPristine && formIsValid;
      return /*#__PURE__*/react_default.a.createElement("div", null, /*#__PURE__*/react_default.a.createElement(environment_edit_header_component_EnvironmentEditHeaderComponent, {
        environmentId: environmentId,
        onCancel: onFormCancel,
        onSave: this.onSave,
        saveEnabled: saveEnabled
      }), /*#__PURE__*/react_default.a.createElement(sidebar_environment_navigation_EnvironmentSidebarComponent, {
        menuSelected: "Environments"
      }, /*#__PURE__*/react_default.a.createElement(environment_form_container, {
        environmentId: environmentId
      })));
    }
  }]);

  return EnvironmentEditPageContainer;
}(react["Component"]);

defineProperty_default()(environment_edit_page_container_EnvironmentEditPageContainer, "propTypes", {
  environmentId: prop_types_default.a.string,
  environmentModel: prop_types_default.a.shape({
    id: prop_types_default.a.string,
    title: prop_types_default.a.string.isRequired,
    description: prop_types_default.a.string.isRequired
  }).isRequired,
  formIsPristine: prop_types_default.a.bool.isRequired,
  formIsValid: prop_types_default.a.bool.isRequired,
  onFormCancel: prop_types_default.a.func.isRequired,
  onFormSave: prop_types_default.a.func.isRequired
});

var environment_edit_page_container_mapStateToProps = function mapStateToProps(state) {
  return {
    environmentModel: state.environmentForm.environmentModel,
    formIsValid: state.environmentForm.formIsValid,
    formIsPristine: state.environmentForm.formIsPristine
  };
};

/* harmony default export */ var environment_edit_page_container = (Object(es["connect"])(environment_edit_page_container_mapStateToProps, {
  onFormCancel: environment_form_actions_onFormCancel,
  onFormSave: onFormSave
})(environment_edit_page_container_EnvironmentEditPageContainer));
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/edit/environment-edit-page.js







function environment_edit_page_createSuper(Derived) { var hasNativeReflectConstruct = environment_edit_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function environment_edit_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }







var environment_edit_page_EnvironmentEditPage = /*#__PURE__*/function (_Component) {
  inherits_default()(EnvironmentEditPage, _Component);

  var _super = environment_edit_page_createSuper(EnvironmentEditPage);

  function EnvironmentEditPage() {
    classCallCheck_default()(this, EnvironmentEditPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(EnvironmentEditPage, [{
    key: "render",
    value: function render() {
      var environmentId = this.props.environmentId;
      return /*#__PURE__*/react_default.a.createElement(es["Provider"], {
        store: environment_management_store_store
      }, /*#__PURE__*/react_default.a.createElement(environment_edit_page_container, {
        environmentId: environmentId
      }));
    }
  }]);

  return EnvironmentEditPage;
}(react["Component"]);

defineProperty_default()(environment_edit_page_EnvironmentEditPage, "propTypes", {
  environmentId: prop_types_default.a.string
});


// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/application/list/application-list-header-component.js








function application_list_header_component_createSuper(Derived) { var hasNativeReflectConstruct = application_list_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function application_list_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }





var application_list_header_component_filterOptions = {
  placeholder: 'Filter by application...'
};

var application_list_header_component_ApplicationListHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ApplicationListHeaderComponent, _Component);

  var _super = application_list_header_component_createSuper(ApplicationListHeaderComponent);

  function ApplicationListHeaderComponent(props) {
    var _this;

    classCallCheck_default()(this, ApplicationListHeaderComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onFilterChange", function (filter) {
      _this.props.onApplicationFilterChange(filter);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCreate", function () {
      _this.props.onCreate();
    });

    _this.state = {
      createButtonDisabled: false,
      modalIsOpen: false,
      title: ''
    };
    return _this;
  }

  createClass_default()(ApplicationListHeaderComponent, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/react_default.a.createElement(header_component_HeaderComponent, {
        helpUrl: "applications.html"
      }, /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetFilter"], {
        metadata: application_list_header_component_filterOptions,
        onUpdate: this.onFilterChange
      }), /*#__PURE__*/react_default.a.createElement("div", {
        className: "buttons"
      }, /*#__PURE__*/react_default.a.createElement("button", {
        className: "button primary",
        onClick: this.onCreate
      }, "New application"))));
    }
  }]);

  return ApplicationListHeaderComponent;
}(react["Component"]);

defineProperty_default()(application_list_header_component_ApplicationListHeaderComponent, "propTypes", {
  onApplicationFilterChange: prop_types_default.a.func.isRequired,
  onCreate: prop_types_default.a.func.isRequired
});


// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/application/list/application-list-item-component.less
var application_list_item_component = __webpack_require__(2043);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/application/list/application-list-item-component.js








function application_list_item_component_createSuper(Derived) { var hasNativeReflectConstruct = application_list_item_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function application_list_item_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }







var application_list_item_component_ApplicationListItemComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ApplicationListItemComponent, _Component);

  var _super = application_list_item_component_createSuper(ApplicationListItemComponent);

  function ApplicationListItemComponent(props) {
    var _this;

    classCallCheck_default()(this, ApplicationListItemComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onEditApplication", function (event) {
      event.stopPropagation();
      var _this$props = _this.props,
          application = _this$props.application,
          onEdit = _this$props.onEdit;
      onEdit(application);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDeleteApplication", function (event) {
      event.stopPropagation();
      var _this$props2 = _this.props,
          application = _this$props2.application,
          onDelete = _this$props2.onDelete;
      onDelete(application);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderLinkedEnvironments", function () {
      var environments = _this.props.application.environments;
      var environmentNames = environments ? environments.map(function (env) {
        return env.title;
      }).join(', ') : [];
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "application-item-environments col-xs-5"
      }, environmentNames.length ? /*#__PURE__*/react_default.a.createElement("span", {
        title: environmentNames
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon environment-icon"
      }), environmentNames) : 'All environments');
    });

    return _this;
  }

  createClass_default()(ApplicationListItemComponent, [{
    key: "render",
    value: function render() {
      var application = this.props.application;
      var panelClass = classnames_default()('panel', 'panel-default', 'application-panel');
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: panelClass,
        onClick: this.onEditApplication
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "application-item-title col-xs-5",
        title: application.title
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon app-icon"
      }), /*#__PURE__*/react_default.a.createElement("strong", null, application.title)), this.renderLinkedEnvironments(), /*#__PURE__*/react_default.a.createElement("div", {
        className: "actions-container col-xs-2"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "actions pull-right"
      }, /*#__PURE__*/react_default.a.createElement("span", {
        className: "link color-inherited",
        "data-test": "edit-action",
        onClick: this.onEditApplication
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "menu-item-icon xl-icon edit-icon",
        title: "Edit"
      }), /*#__PURE__*/react_default.a.createElement("span", {
        className: "action-label"
      }, "Edit")), /*#__PURE__*/react_default.a.createElement("span", {
        className: "link delete",
        "data-test": "delete-action",
        onClick: this.onDeleteApplication
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "menu-item-icon xl-icon delete-icon",
        title: "Delete"
      }), /*#__PURE__*/react_default.a.createElement("span", {
        className: "action-label"
      }, "Delete")))));
    }
  }]);

  return ApplicationListItemComponent;
}(react["Component"]);

defineProperty_default()(application_list_item_component_ApplicationListItemComponent, "propTypes", {
  application: Application.isRequired,
  onDelete: prop_types_default.a.func.isRequired,
  onEdit: prop_types_default.a.func.isRequired
});


// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/application/list/application-list-component.less
var application_list_component = __webpack_require__(2044);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/application/list/application-list-component.js








function application_list_component_createSuper(Derived) { var hasNativeReflectConstruct = application_list_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function application_list_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }










var application_list_component_deleteButton = {
  action: 'delete',
  className: 'button primary',
  keyCodes: [13],
  label: 'Delete'
};
var application_list_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var application_list_component_helpMessage = "Use Applications to logically group applications and the environments they must be deployed to.";

var application_list_component_ApplicationListComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ApplicationListComponent, _Component);

  var _super = application_list_component_createSuper(ApplicationListComponent);

  function ApplicationListComponent(props) {
    var _this;

    classCallCheck_default()(this, ApplicationListComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onFilterChange", function (appName) {
      _this.props.searchApplications(appName);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "goToEditPage", function (application) {
      _this.props.onEditApplication(application);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "goToNewPage", function () {
      _this.props.onAddApplication();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showDeleteModal", function (application) {
      _this.setState({
        deleteModalIsOpen: true,
        applicationToDelete: application
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCloseDeleteModal", function (action) {
      var applicationToDelete = _this.state.applicationToDelete;

      if (action === 'delete') {
        _this.props.onDeleteApplication(applicationToDelete);
      }

      _this.setState({
        deleteModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderHeader", function () {
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "application-list-header"
      }, /*#__PURE__*/react_default.a.createElement("span", {
        className: "col-xs-5"
      }, "Name"), /*#__PURE__*/react_default.a.createElement("span", {
        className: "col-xs-5"
      }, "Environment"), /*#__PURE__*/react_default.a.createElement("div", {
        className: "col-xs-2"
      }, /*#__PURE__*/react_default.a.createElement("span", {
        className: "pull-right action-section"
      }, "Actions")));
    });

    _this.state = {
      deleteModalIsOpen: false,
      applicationToDelete: {}
    };
    return _this;
  }

  createClass_default()(ApplicationListComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.props.searchApplications('');
    }
  }, {
    key: "renderDeleteModal",
    value: function renderDeleteModal() {
      var _this$state = this.state,
          deleteModalIsOpen = _this$state.deleteModalIsOpen,
          applicationToDelete = _this$state.applicationToDelete;
      return /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [application_list_component_cancelButton, application_list_component_deleteButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onCloseDeleteModal,
        show: deleteModalIsOpen,
        title: "Delete application"
      }, /*#__PURE__*/react_default.a.createElement(components["a" /* AlertMessage */], {
        alertType: components["q" /* alertType */].WARNING
      }, /*#__PURE__*/react_default.a.createElement("p", null, "Deleting an application can lead to missing data for connected resources on reporting and environment scheduling.")), /*#__PURE__*/react_default.a.createElement("p", null, "You are about to delete application ", /*#__PURE__*/react_default.a.createElement("strong", null, applicationToDelete.title), "."));
    }
  }, {
    key: "renderList",
    value: function renderList() {
      var _this2 = this;

      var applications = this.props.applications;
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, this.renderDeleteModal(), this.renderHeader(), applications.map(function (app) {
        return /*#__PURE__*/react_default.a.createElement(application_list_item_component_ApplicationListItemComponent, {
          application: app,
          key: app.id,
          onDelete: _this2.showDeleteModal,
          onEdit: _this2.goToEditPage
        });
      }));
    }
  }, {
    key: "render",
    value: function render() {
      var applications = this.props.applications;
      return /*#__PURE__*/react_default.a.createElement("div", null, /*#__PURE__*/react_default.a.createElement(application_list_header_component_ApplicationListHeaderComponent, {
        onApplicationFilterChange: this.onFilterChange,
        onCreate: this.goToNewPage
      }), /*#__PURE__*/react_default.a.createElement("div", {
        className: "application-list-component"
      }, /*#__PURE__*/react_default.a.createElement("h4", {
        className: "page-title"
      }, "Applications (", applications.length, ")"), /*#__PURE__*/react_default.a.createElement(components["f" /* HelpBlock */], {
        className: "help-message-container"
      }, application_list_component_helpMessage), applications.length ? this.renderList() : /*#__PURE__*/react_default.a.createElement(components["g" /* NoData */], {
        message: "No applications found."
      })));
    }
  }]);

  return ApplicationListComponent;
}(react["Component"]);

defineProperty_default()(application_list_component_ApplicationListComponent, "propTypes", {
  applications: prop_types_default.a.arrayOf(Application).isRequired,
  onAddApplication: prop_types_default.a.func.isRequired,
  onDeleteApplication: prop_types_default.a.func.isRequired,
  onEditApplication: prop_types_default.a.func.isRequired,
  searchApplications: prop_types_default.a.func.isRequired
});


// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/application/list/application-list-page-container.js




var application_list_page_container_mapStateToProps = function mapStateToProps(state) {
  return {
    applications: state.applicationList.applications
  };
};

/* harmony default export */ var application_list_page_container = (Object(es["connect"])(application_list_page_container_mapStateToProps, {
  onAddApplication: application_actions_applicationList.goToCreatePage,
  onEditApplication: application_actions_applicationList.goToEditPage,
  onDeleteApplication: application_actions_applicationList.deleteApplication,
  searchApplications: application_actions_applicationList.searchApplications
})(application_list_component_ApplicationListComponent));
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/application/list/application-list-page.js






function application_list_page_createSuper(Derived) { var hasNativeReflectConstruct = application_list_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function application_list_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var application_list_page_ApplicationListPage = /*#__PURE__*/function (_Component) {
  inherits_default()(ApplicationListPage, _Component);

  var _super = application_list_page_createSuper(ApplicationListPage);

  function ApplicationListPage() {
    classCallCheck_default()(this, ApplicationListPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(ApplicationListPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/react_default.a.createElement(es["Provider"], {
        store: environment_management_store_store
      }, /*#__PURE__*/react_default.a.createElement(application_list_page_container, null));
    }
  }]);

  return ApplicationListPage;
}(react["Component"]);


// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/toConsumableArray.js
var toConsumableArray = __webpack_require__(25);
var toConsumableArray_default = /*#__PURE__*/__webpack_require__.n(toConsumableArray);

// EXTERNAL MODULE: ./node_modules/lodash/differenceBy.js
var differenceBy = __webpack_require__(437);
var differenceBy_default = /*#__PURE__*/__webpack_require__.n(differenceBy);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/application/edit/application-edit-header-component.js







function application_edit_header_component_createSuper(Derived) { var hasNativeReflectConstruct = application_edit_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function application_edit_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }





var application_edit_header_component_ApplicationEditHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ApplicationEditHeaderComponent, _Component);

  var _super = application_edit_header_component_createSuper(ApplicationEditHeaderComponent);

  function ApplicationEditHeaderComponent() {
    classCallCheck_default()(this, ApplicationEditHeaderComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(ApplicationEditHeaderComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          saveCaption = _this$props.saveCaption,
          saveEnabled = _this$props.saveEnabled,
          onSave = _this$props.onSave,
          onCancel = _this$props.onCancel;
      return /*#__PURE__*/react_default.a.createElement(header_component_HeaderComponent, {
        helpUrl: "applications.html"
      }, /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement("div", {
        className: "buttons"
      }, /*#__PURE__*/react_default.a.createElement("button", {
        className: "button cancel",
        onClick: onCancel
      }, "Cancel"), /*#__PURE__*/react_default.a.createElement("button", {
        className: "button primary",
        disabled: !saveEnabled,
        onClick: onSave
      }, saveCaption))));
    }
  }]);

  return ApplicationEditHeaderComponent;
}(react["Component"]);

defineProperty_default()(application_edit_header_component_ApplicationEditHeaderComponent, "propTypes", {
  onCancel: prop_types_default.a.func.isRequired,
  onSave: prop_types_default.a.func.isRequired,
  saveCaption: prop_types_default.a.string.isRequired,
  saveEnabled: prop_types_default.a.bool.isRequired
});


// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/shared/list-block/list-block.less
var list_block = __webpack_require__(2045);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/shared/list-block/list-block.js




var list_block_ListBlock = function ListBlock(_ref) {
  var children = _ref.children,
      childrenClassName = _ref.childrenClassName,
      listBlockClassName = _ref.listBlockClassName,
      onDelete = _ref.onDelete;
  return /*#__PURE__*/react_default.a.createElement("div", {
    className: "list-block ".concat(listBlockClassName)
  }, /*#__PURE__*/react_default.a.createElement("div", {
    className: "list-block-children ".concat(childrenClassName)
  }, children), /*#__PURE__*/react_default.a.createElement("span", {
    className: "cross xl-icon close-icon",
    onClick: onDelete
  }));
};

list_block_ListBlock.propTypes = {
  children: prop_types_default.a.element.isRequired,
  childrenClassName: prop_types_default.a.string,
  listBlockClassName: prop_types_default.a.string,
  onDelete: prop_types_default.a.func.isRequired
};
list_block_ListBlock.defaultProps = {
  childrenClassName: '',
  listBlockClassName: ''
};
/* harmony default export */ var list_block_list_block = (list_block_ListBlock);
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/shared/list-block/index.js

// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/shared/widgets/widget-linked-environments.less
var widget_linked_environments = __webpack_require__(2046);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/shared/widgets/widget-linked-environments.js








function widget_linked_environments_createSuper(Derived) { var hasNativeReflectConstruct = widget_linked_environments_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function widget_linked_environments_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }








var environmentsMetadata = {
  label: 'Linked environments',
  required: false
};

var widget_linked_environments_WidgetLinkedEnvironments = /*#__PURE__*/function (_Component) {
  inherits_default()(WidgetLinkedEnvironments, _Component);

  var _super = widget_linked_environments_createSuper(WidgetLinkedEnvironments);

  function WidgetLinkedEnvironments() {
    var _this;

    classCallCheck_default()(this, WidgetLinkedEnvironments);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "onClickDelete", function (environment) {
      _this.props.onDelete(environment);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderEmptyContainer", function () {
      return /*#__PURE__*/react_default.a.createElement(components["f" /* HelpBlock */], null, "Click an environment on the right to link it to the application");
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderEnvironmentLinked", function (environment) {
      return /*#__PURE__*/react_default.a.createElement(list_block_list_block, {
        childrenClassName: "list-block-env-title",
        key: environment.id,
        onDelete: function onDelete() {
          return _this.onClickDelete(environment);
        }
      }, /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon environment-icon mrs"
      }), /*#__PURE__*/react_default.a.createElement("span", {
        title: environment.title
      }, environment.title)));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderContainer", function (environments) {
      return /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, environments.map(function (e) {
        return _this.renderEnvironmentLinked(e);
      }));
    });

    return _this;
  }

  createClass_default()(WidgetLinkedEnvironments, [{
    key: "render",
    value: function render() {
      var environments = this.props.environments;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "xl-react-components"
      }, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetLabel"], {
        metadata: environmentsMetadata
      }), /*#__PURE__*/react_default.a.createElement("div", {
        className: "xl-react-components-input"
      }, environments.length ? this.renderContainer(environments) : this.renderEmptyContainer()));
    }
  }]);

  return WidgetLinkedEnvironments;
}(react["Component"]);

defineProperty_default()(widget_linked_environments_WidgetLinkedEnvironments, "propTypes", {
  environments: prop_types_default.a.arrayOf(Environment),
  onDelete: prop_types_default.a.func.isRequired
});

defineProperty_default()(widget_linked_environments_WidgetLinkedEnvironments, "defaultProps", {
  environments: []
});


// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/application/edit/form/application-form-component.less
var application_form_component = __webpack_require__(2047);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/application/edit/form/application-form-component.js








function application_form_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function application_form_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { application_form_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { application_form_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function application_form_component_createSuper(Derived) { var hasNativeReflectConstruct = application_form_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function application_form_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }










var application_form_component_nameFormMetadata = {
  label: 'Name',
  placeholder: 'Add name...',
  description: 'Name of the application',
  required: true
};

var application_form_component_nameValidator = function nameValidator(applications, selectedId) {
  return function (name) {
    return {
      condition: Object(validators["b" /* itemAlreadyDefined */])(applications, selectedId, 'title', name),
      message: Object(validators["a" /* createErrorMessage */])('Application already exists')
    };
  };
};

var application_form_component_maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: Object(validators["e" /* validateMaxLength */])(inputText, maxLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};

var findApplicationById = function findApplicationById(applications, id) {
  return applications.find(function (e) {
    return e.id === id;
  }) || {};
};

var application_form_component_ApplicationFormComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ApplicationFormComponent, _Component);

  var _super = application_form_component_createSuper(ApplicationFormComponent);

  function ApplicationFormComponent(props) {
    var _this;

    classCallCheck_default()(this, ApplicationFormComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onRegister", function (componentApi) {
      componentApi.focus();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNameChange", function (title) {
      var applicationModel = _this.props.applicationModel;

      if (title !== applicationModel.title) {
        _this.props.onFormChange(application_form_component_objectSpread({}, applicationModel, {
          title: title
        }));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onEnvironmentDeleted", function (environment) {
      var applicationModel = _this.props.applicationModel;
      var environments = applicationModel.environments.filter(function (e) {
        return e.id !== environment.id;
      });

      _this.props.onFormChange(application_form_component_objectSpread({}, applicationModel, {
        environments: environments
      }));

      _this.props.onPristinityChange(false);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNameValidityChange", function (valid) {
      _this.props.onValidationChange(valid);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNamePristine", function (pristine) {
      _this.props.onPristinityChange(pristine);
    });

    return _this;
  }

  createClass_default()(ApplicationFormComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          applicationModel = _this$props.applicationModel,
          applicationList = _this$props.applicationList;
      var app = findApplicationById(applicationList, applicationModel.id);
      var subtitle = isEmpty_default()(app) ? 'New Application' : app.title;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "application-edit-form"
      }, /*#__PURE__*/react_default.a.createElement("h4", {
        className: "page-title"
      }, "Applications / ", subtitle), /*#__PURE__*/react_default.a.createElement("div", {
        className: "application-form"
      }, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetString"], {
        metadata: application_form_component_nameFormMetadata,
        model: applicationModel.title,
        onModelChange: this.onNameChange,
        onPristinityChange: this.onNamePristine,
        onValidityChange: this.onNameValidityChange,
        register: this.onRegister,
        validators: [application_form_component_nameValidator(applicationList, applicationModel.id), application_form_component_maxLengthValidator(application_form_component_nameFormMetadata.label, 255)]
      }), /*#__PURE__*/react_default.a.createElement(widget_linked_environments_WidgetLinkedEnvironments, {
        environments: applicationModel.environments,
        onDelete: this.onEnvironmentDeleted
      })));
    }
  }]);

  return ApplicationFormComponent;
}(react["Component"]);

defineProperty_default()(application_form_component_ApplicationFormComponent, "propTypes", {
  applicationList: prop_types_default.a.arrayOf(Application).isRequired,
  applicationModel: Application,
  onFormChange: prop_types_default.a.func.isRequired,
  onPristinityChange: prop_types_default.a.func.isRequired,
  onValidationChange: prop_types_default.a.func.isRequired
});

defineProperty_default()(application_form_component_ApplicationFormComponent, "defaultProps", {
  applicationModel: {}
});


// EXTERNAL MODULE: ./node_modules/lodash/defaults.js
var defaults = __webpack_require__(560);
var defaults_default = /*#__PURE__*/__webpack_require__.n(defaults);

// EXTERNAL MODULE: ./node_modules/antd/es/popover/index.js + 15 modules
var popover = __webpack_require__(2291);

// EXTERNAL MODULE: ./node_modules/react-dom/index.js
var react_dom = __webpack_require__(32);
var react_dom_default = /*#__PURE__*/__webpack_require__.n(react_dom);

// EXTERNAL MODULE: ./node_modules/lodash/takeRight.js
var takeRight = __webpack_require__(809);
var takeRight_default = /*#__PURE__*/__webpack_require__.n(takeRight);

// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/shared/label/label-list-truncated.less
var label_list_truncated = __webpack_require__(2048);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/shared/label/label-list-truncated.js








function label_list_truncated_createSuper(Derived) { var hasNativeReflectConstruct = label_list_truncated_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function label_list_truncated_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }









var label_list_truncated_LabelListTruncated = /*#__PURE__*/function (_Component) {
  inherits_default()(LabelListTruncated, _Component);

  var _super = label_list_truncated_createSuper(LabelListTruncated);

  function LabelListTruncated(props) {
    var _this;

    classCallCheck_default()(this, LabelListTruncated);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "setItemRef", function (el) {
      _this.itemRefs.push(el);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderLabelList", function (labels) {
      return labels.map(function (label) {
        return /*#__PURE__*/react_default.a.createElement(label_item_LabelItem, {
          envLabel: label,
          key: label.id,
          ref: _this.setItemRef,
          size: "small"
        });
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderPopupContent", function () {
      var labels = _this.props.labels;
      var moreItems = _this.state.moreItems;
      var labelListInPopup = takeRight_default()(labels, moreItems);
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "type-popup-content"
      }, _this.renderLabelList(labelListInPopup));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderLabelListPopup", function () {
      var moreItems = _this.state.moreItems;
      return !!moreItems && /*#__PURE__*/react_default.a.createElement(popover["a" /* default */], {
        arrowPointAtCenter: true,
        content: _this.renderPopupContent(),
        overlayClassName: "type-popup",
        placement: "bottomRight",
        trigger: "hover"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "more-labels"
      }, moreItems, " more..."));
    });

    _this.containerRef = react_default.a.createRef();
    _this.itemRefs = [];
    _this.state = {
      moreItems: null
    };
    return _this;
  }

  createClass_default()(LabelListTruncated, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      /* eslint-disable react/no-find-dom-node */
      var container = react_dom_default.a.findDOMNode(this.containerRef.current);
      /* eslint-enable react/no-find-dom-node */

      if (container && this.itemRefs.length) {
        var bound = container.getBoundingClientRect();
        var moreItems = this.itemRefs.reduce(function (acc, curr) {
          /* eslint-disable react/no-find-dom-node */
          var node = react_dom_default.a.findDOMNode(curr);
          /* eslint-enable react/no-find-dom-node */

          if (node) {
            var rect = node.getBoundingClientRect();

            if (rect.top - bound.top > bound.height / 2) {
              return acc + 1;
            }
          }

          return acc;
        }, 0);

        if (moreItems) {
          /* eslint-disable react/no-did-mount-set-state */
          this.setState({
            moreItems: moreItems
          });
          /* eslint-enable react/no-did-mount-set-state */
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      var labels = this.props.labels;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "label-list",
        ref: this.containerRef
      }, this.renderLabelList(labels), this.renderLabelListPopup());
    }
  }]);

  return LabelListTruncated;
}(react["Component"]);

defineProperty_default()(label_list_truncated_LabelListTruncated, "propTypes", {
  labels: prop_types_default.a.arrayOf(prop_types_default.a.object)
});

/* harmony default export */ var label_label_list_truncated = (label_list_truncated_LabelListTruncated);
// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/shared/environment/environment-sidebar-item.less
var environment_sidebar_item = __webpack_require__(2049);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/shared/environment/environment-sidebar-item.js








function environment_sidebar_item_createSuper(Derived) { var hasNativeReflectConstruct = environment_sidebar_item_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function environment_sidebar_item_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }









var environment_sidebar_item_EnvironmentSideBarItem = /*#__PURE__*/function (_Component) {
  inherits_default()(EnvironmentSideBarItem, _Component);

  var _super = environment_sidebar_item_createSuper(EnvironmentSideBarItem);

  function EnvironmentSideBarItem() {
    var _this;

    classCallCheck_default()(this, EnvironmentSideBarItem);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "onClick", function (environment) {
      var onClick = _this.props.onClick;

      if (onClick) {
        onClick(environment);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderEnvironmentDescriptionPopup", function (description) {
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "description-content"
      }, description);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderEnvironmentDescriptionPopover", function (environment) {
      return /*#__PURE__*/react_default.a.createElement(popover["a" /* default */], {
        arrowPointAtCenter: true,
        content: _this.renderEnvironmentDescriptionPopup(environment.description),
        overlayClassName: "description-popup",
        placement: "bottomRight",
        trigger: "hover"
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "icon-info xl-icon info-icon"
      }));
    });

    return _this;
  }

  createClass_default()(EnvironmentSideBarItem, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          environment = _this$props.environment,
          isClickable = _this$props.isClickable;
      var containerClass = classnames_default()('environment-item-container', {
        'clickable': isClickable
      });
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: containerClass,
        onClick: function onClick() {
          return _this2.onClick(environment);
        }
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "environment-item-title-container"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "title",
        title: environment.title
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon environment-icon"
      }), environment.title), environment.description && this.renderEnvironmentDescriptionPopover(environment)), /*#__PURE__*/react_default.a.createElement("div", null, environment.labels && !!environment.labels.length && /*#__PURE__*/react_default.a.createElement(label_label_list_truncated, {
        labels: environment.labels
      })));
    }
  }]);

  return EnvironmentSideBarItem;
}(react["Component"]);

defineProperty_default()(environment_sidebar_item_EnvironmentSideBarItem, "propTypes", {
  environment: Environment.isRequired,
  isClickable: prop_types_default.a.bool,
  onClick: prop_types_default.a.func
});

defineProperty_default()(environment_sidebar_item_EnvironmentSideBarItem, "defaultProps", {
  isClickable: false,
  environments: []
});


// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/application/edit/form/sidebar-environment-list.less
var sidebar_environment_list = __webpack_require__(2050);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/application/edit/form/sidebar-environment-list.js








function sidebar_environment_list_createSuper(Derived) { var hasNativeReflectConstruct = sidebar_environment_list_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function sidebar_environment_list_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }










var stageMetadata = {
  label: '',
  placeholder: 'Filter by stage...'
};
var sidebar_environment_list_filterOptions = {
  placeholder: 'Filter environment name...'
};

var sidebar_environment_list_SidebarEnvironmentList = /*#__PURE__*/function (_Component) {
  inherits_default()(SidebarEnvironmentList, _Component);

  var _super = sidebar_environment_list_createSuper(SidebarEnvironmentList);

  function SidebarEnvironmentList(props) {
    var _this;

    classCallCheck_default()(this, SidebarEnvironmentList);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onStageChange", function (stage) {
      _this.setState({
        stageSelected: stage
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNameChange", function (name) {
      _this.setState({
        environmentFilter: name
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onEnvironmentClick", function (environment) {
      _this.props.onClickEnvironment(environment);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "filterEnvironments", function (environment) {
      var _this$state = _this.state,
          environmentFilter = _this$state.environmentFilter,
          stageSelected = _this$state.stageSelected;
      defaults_default()(stageSelected, {
        title: ''
      });
      return includes_default()(environment.title.toLowerCase(), environmentFilter.toLowerCase()) && includes_default()(environment.stage.title.toLowerCase(), stageSelected.title.toLowerCase());
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderEnvironments", function () {
      var environments = _this.props.environments;
      return environments.filter(function (env) {
        return _this.filterEnvironments(env);
      }).map(function (env) {
        return /*#__PURE__*/react_default.a.createElement(environment_sidebar_item_EnvironmentSideBarItem, {
          environment: env,
          isClickable: true,
          key: env.id,
          onClick: _this.onEnvironmentClick
        });
      });
    });

    _this.state = {
      stageSelected: {
        title: ''
      },
      environmentFilter: ''
    };
    return _this;
  }

  createClass_default()(SidebarEnvironmentList, [{
    key: "render",
    value: function render() {
      var stages = this.props.stages;
      var stageSelected = this.state.stageSelected;

      var autocompleteHandler = function autocompleteHandler(_ref) {
        var metadata = _ref.metadata,
            objLabel = _ref.objLabel,
            suggestedElements = _ref.suggestedElements,
            value = _ref.value;
        return Promise.resolve(sortBy_default()(stages.filter(function (c) {
          return includes_default()(c.title.toLowerCase(), value.toLowerCase());
        }), ['title']));
      };

      var autocompleteHandlers = {
        addCandidates: autocompleteHandler
      };
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "application-form-environment-sidebar"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "header"
      }, /*#__PURE__*/react_default.a.createElement("h4", {
        className: "page-title"
      }, "Environments"), /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetAutocomplete"], {
        handlers: autocompleteHandlers,
        metadata: stageMetadata,
        model: stageSelected,
        objLabel: 'title',
        onModelChange: this.onStageChange
      }), /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetFilter"], {
        metadata: sidebar_environment_list_filterOptions,
        onUpdate: this.onNameChange
      })), /*#__PURE__*/react_default.a.createElement("div", {
        className: "environment-sidebar-list"
      }, this.renderEnvironments()));
    }
  }]);

  return SidebarEnvironmentList;
}(react["Component"]);

defineProperty_default()(sidebar_environment_list_SidebarEnvironmentList, "propTypes", {
  environments: prop_types_default.a.arrayOf(Environment),
  onClickEnvironment: prop_types_default.a.func.isRequired,
  stages: prop_types_default.a.arrayOf(Stage)
});

defineProperty_default()(sidebar_environment_list_SidebarEnvironmentList, "defaultProps", {
  stages: [],
  environments: []
});


// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/application/edit/application-edit-page-component.less
var application_edit_page_component = __webpack_require__(2051);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/application/edit/application-edit-page-component.js









function application_edit_page_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function application_edit_page_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { application_edit_page_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { application_edit_page_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function application_edit_page_component_createSuper(Derived) { var hasNativeReflectConstruct = application_edit_page_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function application_edit_page_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }











var application_edit_page_component_styleSidebar = {
  root: {
    top: '50px'
  }
};

var application_edit_page_component_ApplicationEditPageComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ApplicationEditPageComponent, _Component);

  var _super = application_edit_page_component_createSuper(ApplicationEditPageComponent);

  createClass_default()(ApplicationEditPageComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props = this.props,
          applicationId = _this$props.applicationId,
          initComponent = _this$props.initComponent;
      initComponent(applicationId);
    }
  }]);

  function ApplicationEditPageComponent(props) {
    var _this;

    classCallCheck_default()(this, ApplicationEditPageComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onSave", function () {
      var application = _this.props.application;

      _this.props.onSaveApplication(application);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onFormValidChange", function (valid) {
      _this.setState({
        formValid: valid
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onApplicationChange", function (application) {
      _this.props.onUpdateApplication(application);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onAddEnvironment", function (environment) {
      _this.setState({
        formPristine: false
      });

      var application = _this.props.application;

      var updatedApp = application_edit_page_component_objectSpread({}, application, {
        environments: [].concat(toConsumableArray_default()(application.environments), [environment])
      });

      _this.props.onUpdateApplication(updatedApp);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onPristinityChange", function (pristine) {
      _this.setState({
        formPristine: pristine
      });

      if (!pristine) {
        _this.props.onFormPristine(pristine);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderSidebarContent", function () {
      var _this$props2 = _this.props,
          application = _this$props2.application,
          environments = _this$props2.environments,
          stages = _this$props2.stages;
      var filteredEnvironments = differenceBy_default()(environments, application.environments, 'id');
      return /*#__PURE__*/react_default.a.createElement(sidebar_environment_list_SidebarEnvironmentList, {
        environments: filteredEnvironments,
        onClickEnvironment: _this.onAddEnvironment,
        stages: stages
      });
    });

    _this.state = {
      formValid: false,
      formPristine: true
    };
    return _this;
  }

  createClass_default()(ApplicationEditPageComponent, [{
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          application = _this$props3.application,
          applications = _this$props3.applications,
          onFormCancel = _this$props3.onFormCancel;
      var _this$state = this.state,
          formValid = _this$state.formValid,
          formPristine = _this$state.formPristine;
      var saveEnabled = !formPristine && formValid;
      var saveButtonCaption = isEmpty_default()(application) ? 'Create' : 'Save';
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "application-form-view"
      }, /*#__PURE__*/react_default.a.createElement(application_edit_header_component_ApplicationEditHeaderComponent, {
        onCancel: onFormCancel,
        onSave: this.onSave,
        saveCaption: saveButtonCaption,
        saveEnabled: saveEnabled
      }), /*#__PURE__*/react_default.a.createElement(react_sidebar_esm["a" /* default */], {
        contentClassName: "application-form-content",
        docked: true,
        open: true,
        pullRight: true,
        shadow: false,
        sidebar: this.renderSidebarContent(),
        sidebarClassName: "application-form-sidebar",
        styles: application_edit_page_component_styleSidebar,
        transitions: false
      }, /*#__PURE__*/react_default.a.createElement(application_form_component_ApplicationFormComponent, {
        applicationList: applications,
        applicationModel: application,
        onFormChange: this.onApplicationChange,
        onPristinityChange: this.onPristinityChange,
        onValidationChange: this.onFormValidChange
      })));
    }
  }]);

  return ApplicationEditPageComponent;
}(react["Component"]);

defineProperty_default()(application_edit_page_component_ApplicationEditPageComponent, "propTypes", {
  application: Application,
  applicationId: prop_types_default.a.string,
  applications: prop_types_default.a.arrayOf(Application),
  environments: prop_types_default.a.arrayOf(Environment),
  initComponent: prop_types_default.a.func.isRequired,
  onFormCancel: prop_types_default.a.func.isRequired,
  onFormPristine: prop_types_default.a.func.isRequired,
  onSaveApplication: prop_types_default.a.func.isRequired,
  onUpdateApplication: prop_types_default.a.func.isRequired,
  stages: prop_types_default.a.arrayOf(Stage)
});

defineProperty_default()(application_edit_page_component_ApplicationEditPageComponent, "defaultProps", {
  application: {},
  stages: [],
  environments: [],
  applications: []
});


// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/application/edit/application-edit-page-container.js





var application_edit_page_container_mapStateToProps = function mapStateToProps(state) {
  return {
    application: state.applicationForm.application,
    applications: state.applicationForm.applications,
    environments: state.applicationForm.environments,
    stages: state.applicationForm.stages
  };
};

/* harmony default export */ var application_edit_page_container = (Object(es["connect"])(application_edit_page_container_mapStateToProps, {
  onSaveApplication: applicationForm.saveApplication,
  initComponent: applicationForm.initForm,
  onUpdateApplication: applicationForm.updateModel,
  onFormCancel: applicationForm.cancelForm,
  onFormPristine: applicationForm.pristineFormChange
})(application_edit_page_component_ApplicationEditPageComponent));
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/application/edit/application-edit-page.js







function application_edit_page_createSuper(Derived) { var hasNativeReflectConstruct = application_edit_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function application_edit_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }







var application_edit_page_ApplicationEditPage = /*#__PURE__*/function (_Component) {
  inherits_default()(ApplicationEditPage, _Component);

  var _super = application_edit_page_createSuper(ApplicationEditPage);

  function ApplicationEditPage() {
    classCallCheck_default()(this, ApplicationEditPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(ApplicationEditPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/react_default.a.createElement(es["Provider"], {
        store: environment_management_store_store
      }, /*#__PURE__*/react_default.a.createElement(application_edit_page_container, {
        applicationId: this.props.applicationId
      }));
    }
  }]);

  return ApplicationEditPage;
}(react["Component"]);

defineProperty_default()(application_edit_page_ApplicationEditPage, "propTypes", {
  applicationId: prop_types_default.a.string
});


// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/stage/stage-list-header-component.js








function stage_list_header_component_createSuper(Derived) { var hasNativeReflectConstruct = stage_list_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function stage_list_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }







var stage_list_header_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var stage_list_header_component_createButton = {
  action: 'create',
  className: 'button primary',
  keyCodes: [13],
  label: 'Create'
};
var nameOptions = {
  label: 'Name',
  placeholder: 'Add...',
  description: 'Name of the stage',
  required: true
};

var stage_list_header_component_nameValidator = function nameValidator(stageList) {
  return function (name) {
    return {
      condition: Object(validators["b" /* itemAlreadyDefined */])(stageList, null, 'title', name),
      message: Object(validators["a" /* createErrorMessage */])('Stage already existing')
    };
  };
};

var stage_list_header_component_maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: Object(validators["e" /* validateMaxLength */])(inputText, maxLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};

var stage_list_header_component_StageListHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(StageListHeaderComponent, _Component);

  var _super = stage_list_header_component_createSuper(StageListHeaderComponent);

  function StageListHeaderComponent(props) {
    var _this;

    classCallCheck_default()(this, StageListHeaderComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onRegister", function (componentApi) {
      componentApi.focus();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCreate", function () {
      _this.setState({
        modalIsOpen: true
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onClose", function (action) {
      if (action === 'create') {
        _this.props.onSave({
          title: _this.state.title
        });
      }

      _this.setState({
        modalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "closeModal", function () {
      _this.onClose(stage_list_header_component_cancelButton.action);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onModelChange", function (title) {
      _this.setState({
        title: title
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onValidityChange", function (valid) {
      _this.setState({
        createButtonDisabled: !valid
      });
    });

    _this.state = {
      createButtonDisabled: false,
      modalIsOpen: false,
      title: ''
    };
    return _this;
  }

  createClass_default()(StageListHeaderComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          onFilterChange = _this$props.onFilterChange,
          stageList = _this$props.stageList;
      var _this$state = this.state,
          modalIsOpen = _this$state.modalIsOpen,
          createButtonDisabled = _this$state.createButtonDisabled;
      var filterOptions = {
        placeholder: 'Filter by stage...'
      };
      stage_list_header_component_createButton.disabled = createButtonDisabled;
      var modalHeader = /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, "New stage", /*#__PURE__*/react_default.a.createElement("button", {
        className: "btn-close",
        onClick: this.closeModal,
        type: "button"
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/react_default.a.createElement(header_component_HeaderComponent, {
        helpUrl: "environments.html"
      }, /*#__PURE__*/react_default.a.createElement(react_default.a.Fragment, null, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetFilter"], {
        metadata: filterOptions,
        onUpdate: onFilterChange
      }), /*#__PURE__*/react_default.a.createElement("div", {
        className: "buttons"
      }, /*#__PURE__*/react_default.a.createElement("button", {
        className: "button primary",
        onClick: this.onCreate
      }, "New stage")), /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [stage_list_header_component_cancelButton, stage_list_header_component_createButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onClose,
        show: modalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/react_default.a.createElement(dist["XlReactWidgetString"], {
        metadata: nameOptions,
        onModelChange: this.onModelChange,
        onValidityChange: this.onValidityChange,
        register: this.onRegister,
        validators: [stage_list_header_component_nameValidator(stageList), stage_list_header_component_maxLengthValidator(nameOptions.label, 255)]
      }))));
    }
  }]);

  return StageListHeaderComponent;
}(react["Component"]);

defineProperty_default()(stage_list_header_component_StageListHeaderComponent, "propTypes", {
  onFilterChange: prop_types_default.a.func.isRequired,
  onSave: prop_types_default.a.func.isRequired,
  stageList: prop_types_default.a.arrayOf(prop_types_default.a.shape({
    id: prop_types_default.a.string.isRequired,
    title: prop_types_default.a.string.isRequired
  }).isRequired).isRequired
});


// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/stage/stage-list-item-component.less
var stage_list_item_component = __webpack_require__(2052);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/stage/stage-list-item-component.js







function stage_list_item_component_createSuper(Derived) { var hasNativeReflectConstruct = stage_list_item_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function stage_list_item_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }





var stage_list_item_component_StageListItemComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(StageListItemComponent, _Component);

  var _super = stage_list_item_component_createSuper(StageListItemComponent);

  function StageListItemComponent() {
    classCallCheck_default()(this, StageListItemComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(StageListItemComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          stage = _this$props.stage,
          onDelete = _this$props.onDelete,
          onEdit = _this$props.onEdit;
      return /*#__PURE__*/react_default.a.createElement("div", {
        className: "stage-panel"
      }, /*#__PURE__*/react_default.a.createElement("div", {
        className: "title env-stage-title col-xs-8",
        title: stage.title
      }, stage.title), /*#__PURE__*/react_default.a.createElement("div", {
        className: "actions col-xs-4"
      }, /*#__PURE__*/react_default.a.createElement("span", {
        className: "pull-right"
      }, /*#__PURE__*/react_default.a.createElement("span", {
        className: "link color-inherited",
        onClick: function onClick() {
          return onEdit(stage);
        }
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "menu-item-icon xl-icon edit-icon",
        title: "Edit"
      }), /*#__PURE__*/react_default.a.createElement("span", {
        className: "action-label"
      }, "Edit")), /*#__PURE__*/react_default.a.createElement("span", {
        className: "link delete",
        onClick: function onClick() {
          return onDelete(stage);
        }
      }, /*#__PURE__*/react_default.a.createElement("i", {
        className: "menu-item-icon xl-icon delete-icon",
        title: "Delete"
      }), /*#__PURE__*/react_default.a.createElement("span", {
        className: "action-label"
      }, "Delete")))));
    }
  }]);

  return StageListItemComponent;
}(react["Component"]);

defineProperty_default()(stage_list_item_component_StageListItemComponent, "propTypes", {
  onDelete: prop_types_default.a.func.isRequired,
  onEdit: prop_types_default.a.func.isRequired,
  stage: prop_types_default.a.shape({
    id: prop_types_default.a.string.isRequired,
    title: prop_types_default.a.string.isRequired
  }).isRequired
});


// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/components/environment/stage/stage-edit-modal.js








function stage_edit_modal_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function stage_edit_modal_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { stage_edit_modal_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { stage_edit_modal_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function stage_edit_modal_createSuper(Derived) { var hasNativeReflectConstruct = stage_edit_modal_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function stage_edit_modal_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var stage_edit_modal_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var stage_edit_modal_nameOptions = {
  label: 'Name',
  description: 'Name of the stage',
  required: true
};

var stage_edit_modal_nameValidator = function nameValidator(stageList, id) {
  return function (name) {
    return {
      condition: Object(validators["b" /* itemAlreadyDefined */])(stageList, id, 'title', name),
      message: Object(validators["a" /* createErrorMessage */])('Stage already exists')
    };
  };
};

var stage_edit_modal_maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: Object(validators["e" /* validateMaxLength */])(inputText, maxLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};

var stage_edit_modal_StageEditModal = /*#__PURE__*/function (_Component) {
  inherits_default()(StageEditModal, _Component);

  var _super = stage_edit_modal_createSuper(StageEditModal);

  createClass_default()(StageEditModal, null, [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(props, state) {
      if (!state.stage || props.model.title !== state.prevModel.title || props.model.title === state.prevModel.title && props.model.id !== state.prevModel.id) {
        return stage_edit_modal_objectSpread({}, state, {
          stage: props.model,
          prevModel: props.model
        });
      }

      return null;
    }
  }]);

  function StageEditModal(props) {
    var _this;

    classCallCheck_default()(this, StageEditModal);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onRegister", function (componentApi) {
      componentApi.focus();
      _this.componentApi = componentApi;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "closeModal", function () {
      _this.handleButtonClick(stage_edit_modal_cancelButton.action);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleButtonClick", function (action) {
      var _this$props = _this.props,
          onCancel = _this$props.onCancel,
          onSave = _this$props.onSave;
      var stage = _this.state.stage;

      switch (action) {
        case 'update':
          onSave(stage);
          break;

        case 'cancel':
          onCancel();
          break;

        default:
          throw 'Unknown action';
      }

      _this.resetForm();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleModelChange", function (newTitle) {
      var stage = _this.state.stage;

      if (newTitle !== stage.title) {
        _this.setState({
          stage: stage_edit_modal_objectSpread({}, stage, {
            title: newTitle
          })
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleValidityChange", function (valid) {
      _this.isValid = valid;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handlePristinityChange", function (pristine) {
      _this.isPristine = pristine;
    });

    defineProperty_default()(assertTh