/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.utils.ResponseHelper;
import com.xebialabs.xlrelease.api.v1.TeamFacade;
import com.xebialabs.xlrelease.api.v1.VariableComponent;
import com.xebialabs.xlrelease.api.v1.forms.AbortRelease;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.api.v1.forms.Variable;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.api.v1.views.TeamView;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.PhaseVersion;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.search.ReleaseCountResults;
import com.xebialabs.xlrelease.search.ReleaseFullSearchResult;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.AttachmentService;
import com.xebialabs.xlrelease.service.FolderVariableService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.VariableService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/releases")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AllCILevels
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class ReleaseApi
implements ApiService {
    private static final Logger logger = LoggerFactory.getLogger(ReleaseApi.class);
    public static final String SERVICE_NAME = "releaseApi";
    private static final long DEFAULT_RESULTS_PER_PAGE = 100L;
    private static final long DEFAULT_PAGE = 0L;
    private static final String ARCHIVE_PAGE = "archivePage";
    private static final String ARCHIVE_RESULTS_PER_PAGE = "archiveResultsPerPage";
    private PermissionChecker permissions;
    private ReleaseService releaseService;
    private ReleaseSearchService releaseSearchService;
    private ReleaseActorService releaseActorService;
    private VariableComponent variableComponent;
    private TeamFacade teamFacade;
    private AttachmentService attachmentService;
    private VariableService variableService;
    private FolderVariableService folderVariableService;

    @Autowired
    public ReleaseApi(PermissionChecker permissions, ReleaseService releaseService, ReleaseSearchService releaseSearchService, VariableComponent variableComponent, ReleaseActorService releaseActorService, TeamFacade teamFacade, AttachmentService attachmentService, VariableService variableService, FolderVariableService folderVariableService) {
        this.permissions = permissions;
        this.releaseService = releaseService;
        this.releaseSearchService = releaseSearchService;
        this.releaseActorService = releaseActorService;
        this.variableComponent = variableComponent;
        this.teamFacade = teamFacade;
        this.attachmentService = attachmentService;
        this.variableService = variableService;
        this.folderVariableService = folderVariableService;
    }

    public String serviceName() {
        return SERVICE_NAME;
    }

    @GET
    @Workdir(prefix="download", clean=Workdir.Clean.ONLY_ON_EXCEPTION)
    @Path(value="attachments/{attachmentId:.*/Attachment[^/]*}")
    @Produces(value={"application/octet-stream"})
    @Timed
    public Response downloadAttachment(@PathParam(value="attachmentId") String attachmentId) {
        this.permissions.checkView(Ids.releaseIdFrom((String)attachmentId));
        Attachment attachment = this.attachmentService.findByIdIncludingArchived(attachmentId);
        StreamingOutput output = outputStream -> {
            try (InputStream inputStream = attachment.getFile().getInputStream();){
                ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                outputStream.flush();
            }
        };
        String fileName = attachment.getFile().getName();
        return ResponseHelper.streamFile(fileName, output, attachment.getContentType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublicApiMember
    @Timed
    public byte[] getAttachment(String attachmentId) throws IOException {
        byte[] byteArray;
        this.permissions.checkView(Ids.releaseIdFrom((String)attachmentId));
        WorkdirHolder.initWorkdir((String)"download");
        Attachment attachment = this.attachmentService.findByIdIncludingArchived(attachmentId);
        WorkDir workDir = WorkDirContext.get();
        try (InputStream inputStream = attachment.getFile().getInputStream();){
            byteArray = ByteStreams.toByteArray((InputStream)inputStream);
        }
        finally {
            workDir.delete();
        }
        return byteArray;
    }

    @POST
    @Timed
    @Path(value="count")
    public ReleaseCountResults countReleases(ReleasesFilters releasesFilters) {
        if (null == releasesFilters) {
            releasesFilters = new ReleasesFilters();
        }
        return this.releaseSearchService.count(releasesFilters);
    }

    @POST
    @Path(value="search")
    @PublicApiMember
    @Timed
    public List<Release> searchReleases(ReleasesFilters releasesFilters, @DefaultValue(value="0") @QueryParam(value="page") Long page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") Long resultsPerPage, @QueryParam(value="pageIsOffset") boolean pageIsOffset) {
        Checks.checkArgument((resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        if (null == releasesFilters) {
            releasesFilters = new ReleasesFilters();
        }
        return this.releaseSearchService.search(releasesFilters, (long)page, (long)resultsPerPage, pageIsOffset).getReleases();
    }

    @PublicApiMember
    @Timed
    public List<Release> searchReleases(ReleasesFilters releasesFilters) {
        return this.searchReleases(releasesFilters, 0L, 100L, false);
    }

    @POST
    @Timed
    @Path(value="fullSearch")
    public ReleaseFullSearchResult fullSearchReleases(@QueryParam(value="page") Long page, @QueryParam(value="archivePage") Long archivePage, @QueryParam(value="resultsPerPage") Long resultsPerPage, @QueryParam(value="archiveResultsPerPage") Long archiveResultsPerPage, ReleasesFilters releasesFilters) {
        Optional<Object> size = Optional.ofNullable(resultsPerPage);
        Page pageForCurrent = Page.parse(Optional.ofNullable(page), size, Optional.empty());
        Optional<Object> archiveSize = Optional.ofNullable(archiveResultsPerPage).map(Optional::of).orElse(size);
        Optional<Object> archiveOrCurrentPage = Optional.ofNullable(archivePage).map(Optional::of).orElse(Optional.ofNullable(page));
        Page pageForArchive = Page.parse(archiveOrCurrentPage, archiveSize, Optional.empty());
        return this.releaseSearchService.fullSearch(releasesFilters, pageForCurrent, pageForArchive);
    }

    @GET
    @Path(value="/")
    @PublicApiMember
    @Timed
    public List<Release> getReleases(@DefaultValue(value="0") @QueryParam(value="page") Long page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") Long resultsPerPage, @DefaultValue(value="1") @QueryParam(value="depth") Integer depth) {
        Checks.checkArgument((resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        ReleasesFilters filters = new ReleasesFilters();
        filters.setPlanned(true);
        filters.setActive(true);
        filters.setOrderBy(ReleaseOrderMode.start_date);
        ReleaseSearchResult searchResult = this.releaseSearchService.search(filters, (long)page, (long)resultsPerPage, depth);
        return searchResult.getReleases();
    }

    @PublicApiMember
    @Timed
    public List<Release> getReleases() {
        return this.getReleases(0L, 100L, Integer.MAX_VALUE);
    }

    @GET
    @Path(value="/{releaseId:((?!archived).)*Release[^/]*}")
    @PublicApiMember
    @Timed
    public Release getRelease(@PathParam(value="releaseId") String releaseId) {
        Release release = this.releaseService.findById(releaseId);
        this.permissions.checkView(release);
        return release;
    }

    @GET
    @Path(value="/archived/{releaseId:.*Release[^/]*}")
    @PublicApiMember
    @Timed
    public Release getArchivedRelease(@PathParam(value="releaseId") String releaseId) {
        Release release = this.releaseService.findByIdInArchive(releaseId);
        this.permissions.checkView(release);
        return release;
    }

    @GET
    @Path(value="/{releaseId:.*Release[^/]*}/active-tasks")
    @PublicApiMember
    @Timed
    public List<Task> getActiveTasks(@PathParam(value="releaseId") String releaseId) {
        Release release = this.releaseService.findById(releaseId);
        this.permissions.checkView(release);
        return release.getActiveTasks();
    }

    @POST
    @Path(value="/{releaseId:.*Release[^/]*}/start")
    @PublicApiMember
    @Timed
    public Release start(@PathParam(value="releaseId") String releaseId) {
        this.permissions.check(XLReleasePermissions.START_RELEASE, releaseId);
        Checks.checkArgument((!this.releaseService.isTemplate(releaseId) ? 1 : 0) != 0, (String)String.format("Could not start %s because it is a template.", releaseId), (Object[])new Object[0]);
        try {
            return this.releaseActorService.startRelease(releaseId, User.AUTHENTICATED_USER);
        }
        catch (IllegalStateException e) {
            logger.error("Could not start release " + releaseId, (Throwable)e);
            throw new Checks.IncorrectArgumentException(e.getMessage(), new Object[0]);
        }
    }

    @PUT
    @Path(value="/{releaseId:.*Release[^/]*}")
    @Timed
    public Release updateRelease(@PathParam(value="releaseId") String releaseId, Release release) {
        this.permissions.checkEdit(releaseId);
        return this.releaseActorService.updateRelease(releaseId, release);
    }

    @PublicApiMember
    @Timed
    public Release updateRelease(Release release) {
        return this.updateRelease(release.getId(), release);
    }

    @DELETE
    @Path(value="/{releaseId:.*Release[^/]*}")
    @PublicApiMember
    @Timed
    public void delete(@PathParam(value="releaseId") String releaseId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.releaseActorService.deleteRelease(releaseId);
    }

    @POST
    @Path(value="/{releaseId:.*Release[^/]*}/abort")
    @Timed
    public Release abort(@PathParam(value="releaseId") String releaseId, AbortRelease abortRelease) {
        this.permissions.check(XLReleasePermissions.ABORT_RELEASE, releaseId);
        return this.abort(releaseId, abortRelease.getAbortComment());
    }

    @PublicApiMember
    @Timed
    public Release abort(String releaseId, String abortComment) {
        this.permissions.check(XLReleasePermissions.ABORT_RELEASE, releaseId);
        return this.releaseActorService.abortRelease(releaseId, abortComment);
    }

    @GET
    @Path(value="/byTitle")
    @PublicApiMember
    @Timed
    public List<Release> searchReleasesByTitle(@QueryParam(value="releaseTitle") String releaseTitle) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)releaseTitle) ? 1 : 0) != 0, (String)"Query parameter releaseTitle must be provided", (Object[])new Object[0]);
        return this.releaseSearchService.searchReleasesByTitle(releaseTitle, 0L, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @GET
    @Path(value="/{releaseId:.*Release[^/]*}/variables")
    @PublicApiMember
    @Timed
    public List<com.xebialabs.xlrelease.domain.variables.Variable> getVariables(@PathParam(value="releaseId") String releaseId) {
        return this.variableComponent.getVariables(releaseId);
    }

    @GET
    @Path(value="/{releaseId:.*Release[^/]*}/variableValues")
    @PublicApiMember
    @Timed
    public Map<String, String> getVariableValues(@PathParam(value="releaseId") String releaseId) {
        List variables = this.variableService.findGlobalVariablesOrEmpty().getVariables();
        List folderVariables = this.folderVariableService.getAllFromAncestry(Ids.findFolderId((String)releaseId)).getVariables();
        variables.addAll(folderVariables);
        variables.addAll(this.variableComponent.getVariables(releaseId));
        return VariableHelper.getStringVariableValues((List)variables);
    }

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @PublicApiMember
    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable getVariable(@PathParam(value="variableId") String variableId) {
        return this.variableComponent.getVariable(variableId);
    }

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}/possibleValues")
    @PublicApiMember
    @Timed
    public Collection<Object> getVariablePossibleValues(@PathParam(value="variableId") String variableId) {
        return this.variableComponent.getVariablePossibleValues(variableId);
    }

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}/used")
    @PublicApiMember
    @Timed
    public Boolean isVariableUsed(@PathParam(value="variableId") String variableId) {
        return this.variableComponent.isVariableUsed(variableId);
    }

    @POST
    @Path(value="/{variableId:.*/Variable[^/]*}/replace")
    @PublicApiMember
    @Timed
    public void replaceVariable(@PathParam(value="variableId") String variableId, VariableOrValue variableOrValue) {
        this.variableComponent.replaceVariable(variableId, variableOrValue);
    }

    @DELETE
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @PublicApiMember
    @Timed
    public void deleteVariable(@PathParam(value="variableId") String variableId) {
        this.variableComponent.deleteVariable(variableId);
    }

    @POST
    @Path(value="/{releaseId:.*?}/variables")
    @PublicApiMember
    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable createVariable(@PathParam(value="releaseId") String releaseId, Variable variable) {
        return this.variableComponent.createVariable(releaseId, variable);
    }

    @PUT
    @Path(value="/{releaseId:.*?}/variables")
    @PublicApiMember
    @Timed
    public List<com.xebialabs.xlrelease.domain.variables.Variable> updateVariables(@PathParam(value="releaseId") String releaseId, List<com.xebialabs.xlrelease.domain.variables.Variable> variables) {
        return this.variableComponent.updateVariables(releaseId, variables);
    }

    @PUT
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(@PathParam(value="variableId") String variableId, com.xebialabs.xlrelease.domain.variables.Variable variable) {
        return this.variableComponent.updateVariable(variableId, variable);
    }

    @PublicApiMember
    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(com.xebialabs.xlrelease.domain.variables.Variable variable) {
        return this.variableComponent.updateVariable(variable.getId(), variable);
    }

    @GET
    @Path(value="/permissions")
    @PublicApiMember
    @Timed
    public List<String> getPermissions() {
        return XLReleasePermissions.getReleasePermissions();
    }

    @GET
    @Path(value="/{releaseId:.*Release[^/]*}/teams")
    @PublicApiMember
    @Timed
    public List<TeamView> getTeams(@PathParam(value="releaseId") String releaseId) {
        return this.teamFacade.getTeams(releaseId);
    }

    @POST
    @Path(value="/{releaseId:.*Release[^/]*}/teams")
    @PublicApiMember
    @Timed
    public List<TeamView> setTeams(@PathParam(value="releaseId") String releaseId, List<TeamView> teams) {
        return this.teamFacade.setTeams(releaseId, teams);
    }

    @POST
    @Path(value="/{releaseId:.*Release[^/]*}/resume")
    @PublicApiMember
    @Timed
    public Release resume(@PathParam(value="releaseId") String releaseId) {
        this.permissions.checkEdit(releaseId);
        try {
            return this.releaseActorService.resume(releaseId);
        }
        catch (IllegalStateException e) {
            logger.error("Could not resume release " + releaseId, (Throwable)e);
            throw new Checks.IncorrectArgumentException(e.getMessage(), new Object[0]);
        }
    }

    @POST
    @Path(value="/{releaseId:.*Release[^/]*}/restart")
    @Timed
    public Release restartPhases(@PathParam(value="releaseId") String releaseId, @QueryParam(value="fromPhaseId") String phaseId, @QueryParam(value="fromTaskId") String taskId, @QueryParam(value="phaseVersion") PhaseVersion phaseVersion, @QueryParam(value="resume") boolean resumeRelease) {
        Checks.checkNotNull((Object)releaseId, (String)"releaseId");
        Checks.checkNotNull((Object)phaseId, (String)"fromPhaseId");
        Checks.checkNotNull((Object)taskId, (String)"fromTaskId");
        Checks.checkNotNull((Object)((Object)phaseVersion), (String)"phaseVersion");
        this.permissions.checkEdit(releaseId);
        try {
            return this.releaseActorService.restartPhase(releaseId, phaseId, taskId, phaseVersion, resumeRelease);
        }
        catch (IllegalStateException e) {
            logger.error("Could not restart phases of release " + releaseId, (Throwable)e);
            throw new Checks.IncorrectArgumentException(e.getMessage(), new Object[0]);
        }
    }

    @PublicApiMember
    @Timed
    public Release restartPhase(Release release) {
        return this.restartPhase(release, false);
    }

    @PublicApiMember
    public Release restartPhase(Release release, boolean resumeRelease) {
        Checks.checkNotNull((Object)release, (String)"given release");
        Checks.checkArgument((boolean)release.hasCurrentPhase(), (String)"Release '%s' must have a current phase in order to restart phases", (Object[])new Object[]{release.getTitle()});
        Checks.checkArgument((!release.getCurrentPhase().getTasks().isEmpty() ? 1 : 0) != 0, (String)"The given release does not have any task", (Object[])new Object[0]);
        return this.restartPhase(release, release.getCurrentPhase(), release.getCurrentPhase().getTask(Integer.valueOf(0)), PhaseVersion.ALL, resumeRelease);
    }

    @PublicApiMember
    @Timed
    public Release restartPhase(Release release, Phase phase) {
        return this.restartPhase(release, phase, PhaseVersion.ALL);
    }

    @PublicApiMember
    public Release restartPhase(Release release, Phase phase, PhaseVersion phaseVersion) {
        Checks.checkNotNull((Object)release, (String)"given release");
        Checks.checkNotNull((Object)phase, (String)"given phase");
        Checks.checkArgument((!phase.getTasks().isEmpty() ? 1 : 0) != 0, (String)"The release with given phase does not have any task", (Object[])new Object[0]);
        return this.restartPhases(release.getId(), phase.getId(), phase.getTask(Integer.valueOf(0)).getId(), phaseVersion, false);
    }

    @PublicApiMember
    @Timed
    public Release restartPhase(Release release, Phase phase, Task task) {
        return this.restartPhase(release, phase, task, PhaseVersion.ALL);
    }

    @PublicApiMember
    public Release restartPhase(Release release, Phase phase, Task task, PhaseVersion phaseVersion) {
        Checks.checkNotNull((Object)release, (String)"given release");
        Checks.checkNotNull((Object)phase, (String)"given phase");
        Checks.checkNotNull((Object)task, (String)"given task");
        return this.restartPhases(release.getId(), phase.getId(), task.getId(), phaseVersion, false);
    }

    @PublicApiMember
    public Release restartPhase(Release release, Phase phase, Task task, PhaseVersion phaseVersion, boolean resumeRelease) {
        Checks.checkNotNull((Object)release, (String)"given release");
        Checks.checkNotNull((Object)phase, (String)"given phase");
        Checks.checkNotNull((Object)task, (String)"given task");
        return this.restartPhases(release.getId(), phase.getId(), task.getId(), phaseVersion, resumeRelease);
    }
}

