global deliveryApi, deliveryId, task, stage

from com.xebialabs.xlrelease.delivery.domain import StageCompletionSubscriber
from delivery import handle_subscription, make_delivery_hyperlink

delivery = deliveryApi.getDelivery(deliveryId)
delivery_stage = delivery.getStageByIdOrTitle(stage)

task.setStatusLine(make_delivery_hyperlink(delivery.title, delivery.id))
print("Waiting for stage '%s' in delivery : %s\n" % (delivery_stage.title, make_delivery_hyperlink(delivery.title, delivery.id)))

subscriber = StageCompletionSubscriber()
subscriber.setSourceId(task.getId())
subscriber.setStageId(delivery_stage.getId())
subscription = deliveryApi.registerSubscriber(deliveryId, subscriber)

waitForSignal = handle_subscription(subscription)
