/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathRevision;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNAmbientDepthFilterEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNReporter17;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback2;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackWrapper;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffEditor;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffStatusReceiver;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnFilterDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgDiffUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemoteDiffEditor2;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnReverseOrderDiffCallback;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnDiff;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgDiff
extends SvnNgOperationRunner<Void, SvnDiff> {
    @Override
    public SvnWcGeneration getWcGeneration() {
        return SvnWcGeneration.NOT_DETECTED;
    }

    @Override
    public boolean isApplicable(SvnDiff operation, SvnWcGeneration wcGeneration) throws SVNException {
        if (operation.getSource() != null) {
            return !operation.getSource().isFile() || wcGeneration == SvnWcGeneration.V17;
        }
        if (operation.getFirstSource().isFile() && wcGeneration != SvnWcGeneration.V17) {
            return false;
        }
        return !operation.getSecondSource().isFile() || wcGeneration == SvnWcGeneration.V17;
    }

    @Override
    protected Void run(SVNWCContext context) throws SVNException {
        if (this.isPeggedDiff()) {
            SvnTarget target = ((SvnDiff)this.getOperation()).getSource();
            SVNRevision revision1 = ((SvnDiff)this.getOperation()).getStartRevision();
            SVNRevision revision2 = ((SvnDiff)this.getOperation()).getEndRevision();
            SVNRevision pegRevision = target.getPegRevision();
            this.doDiff(target, revision1, pegRevision, target, revision2);
        } else {
            SvnTarget target1 = ((SvnDiff)this.getOperation()).getFirstSource();
            SvnTarget target2 = ((SvnDiff)this.getOperation()).getSecondSource();
            SVNRevision revision1 = target1.getPegRevision();
            SVNRevision revision2 = target2.getPegRevision();
            SVNRevision pegRevision = SVNRevision.UNDEFINED;
            this.doDiff(target1, revision1, pegRevision, target2, revision2);
        }
        return null;
    }

    private void doDiff(SvnTarget target1, SVNRevision revision1, SVNRevision pegRevision, SvnTarget target2, SVNRevision revision2) throws SVNException {
        boolean isRepos2;
        boolean isRepos1;
        boolean isLocalRev2;
        if (revision1 == SVNRevision.UNDEFINED || revision2 == SVNRevision.UNDEFINED) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all required revisions are specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        boolean isLocalRev1 = revision1 == SVNRevision.BASE || revision1 == SVNRevision.WORKING;
        boolean bl = isLocalRev2 = revision2 == SVNRevision.BASE || revision2 == SVNRevision.WORKING;
        if (pegRevision != SVNRevision.UNDEFINED) {
            if (isLocalRev1 && isLocalRev2) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "At least one revision must be non-local for a pegged diff");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            isRepos1 = !isLocalRev1;
            isRepos2 = !isLocalRev2;
        } else {
            isRepos1 = !isLocalRev1 || target1.isURL();
            boolean bl2 = isRepos2 = !isLocalRev2 || target2.isURL();
        }
        if (isRepos1) {
            if (isRepos2) {
                this.doDiffReposRepos(this.getWcContext(), null, target1, revision1, pegRevision, target2, revision2);
            } else {
                this.doDiffReposWC(target1, revision1, pegRevision, target2, revision2, false);
            }
        } else if (isRepos2) {
            this.doDiffReposWC(target2, revision2, pegRevision, target1, revision1, true);
        } else if (revision1 == SVNRevision.WORKING && revision2 == SVNRevision.WORKING) {
            ISvnDiffGenerator generator = this.getDiffGenerator();
            generator.setOriginalTargets(target1, target2);
            generator.setAnchors(target1, target2);
            SvnNgDiffUtil.doArbitraryNodesDiff(target1, target2, ((SvnDiff)this.getOperation()).getDepth(), this.getWcContext(), this.createDiffCallback(generator, false, -1L, -1L), ((SvnDiff)this.getOperation()).getEventHandler());
        } else {
            this.doDiffWCWC(target1, revision1, target2, revision2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffReposRepos(SVNWCContext context, DiffDriverInfo diffDriverInfo, SvnTarget svnTarget1, SVNRevision revision1, SVNRevision pegRevision, SvnTarget svnTarget2, SVNRevision revision2) throws SVNException {
        SVNRepository[] outputRepository = new SVNRepository[1];
        DiffPrepareReposInfo[] prepareReposInfos = this.diffPrepareReposRepos(context, svnTarget1, svnTarget2, revision1, revision2, pegRevision, outputRepository);
        DiffPrepareReposInfo prepareReposInfo1 = prepareReposInfos[0];
        DiffPrepareReposInfo prepareReposInfo2 = prepareReposInfos[1];
        SVNURL url1 = prepareReposInfo1.url;
        SVNURL url2 = prepareReposInfo2.url;
        long rev1 = prepareReposInfo1.revision;
        long rev2 = prepareReposInfo2.revision;
        SVNURL anchor1 = prepareReposInfo1.anchor;
        SVNURL anchor2 = prepareReposInfo2.anchor;
        String target1 = prepareReposInfo1.target;
        String target2 = prepareReposInfo2.target;
        SVNNodeKind kind1 = prepareReposInfo1.kind;
        SVNNodeKind kind2 = prepareReposInfo2.kind;
        SVNRepository repository = outputRepository[0];
        File basePath = null;
        if (svnTarget1.getFile() != null) {
            basePath = svnTarget1.getFile();
        }
        if (svnTarget2.getFile() != null) {
            basePath = svnTarget2.getFile();
        }
        if (diffDriverInfo != null) {
            // empty if block
        }
        boolean nonDir = kind1 != SVNNodeKind.DIR || kind2 != SVNNodeKind.DIR;
        SVNURL repositoryRoot = null;
        ISvnDiffGenerator generator = this.getDiffGenerator();
        generator.setOriginalTargets(SvnTarget.fromURL(url1), SvnTarget.fromURL(url2));
        generator.setAnchors(SvnTarget.fromURL(kind1 == SVNNodeKind.FILE ? anchor1 : url1), SvnTarget.fromURL(kind2 == SVNNodeKind.FILE ? anchor2 : url2));
        SvnDiffCallback oldCallback = this.createDiffCallback(generator, false, rev1, rev2);
        ISvnDiffCallback2 callback = new SvnDiffCallbackWrapper(oldCallback, ((SvnDiff)this.getOperation()).isRecurseIntoDeletedDirectories(), basePath != null ? (nonDir ? basePath.getParentFile() : basePath) : new File("").getAbsoluteFile());
        if (kind2 == SVNNodeKind.NONE) {
            SVNURL tmpUrl = url1;
            url1 = url2;
            url2 = tmpUrl;
            long tmpRev = rev1;
            rev1 = rev2;
            rev2 = tmpRev;
            tmpUrl = anchor1;
            anchor1 = anchor2;
            anchor2 = tmpUrl;
            String tmpTarget = target1;
            target1 = target2;
            target2 = tmpTarget;
            callback = new SvnReverseOrderDiffCallback(callback, null);
        }
        if (kind1 != SVNNodeKind.FILE && kind2 != SVNNodeKind.FILE && target1.length() > 0) {
            callback = new SvnFilterDiffCallback(SVNFileUtil.createFilePath(target1), callback);
        }
        SVNRepository extraRepository = this.getRepositoryAccess().createRepository(repository.getLocation(), null, false);
        if (((SvnDiff)this.getOperation()).isUseGitDiffFormat()) {
            if (repositoryRoot == null) {
                repositoryRoot = extraRepository.getRepositoryRoot(true);
            }
            generator.setRepositoryRoot(SvnTarget.fromURL(repositoryRoot));
        }
        SvnNgRemoteDiffEditor2 editor = null;
        try {
            editor = new SvnNgRemoteDiffEditor2(rev1, true, extraRepository, callback);
            final long finalRev1 = rev1;
            ISVNReporterBaton reporter = new ISVNReporterBaton(){

                @Override
                public void report(ISVNReporter reporter) throws SVNException {
                    reporter.setPath("", null, finalRev1, SVNDepth.INFINITY, false);
                    reporter.finishReport();
                }
            };
            repository.diff(url2, rev2, rev1, target1, ((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).getDepth(), true, reporter, SVNCancellableEditor.newInstance(editor, this, SVNDebugLog.getDefaultLog()));
        }
        finally {
            extraRepository.closeSession();
            if (editor != null) {
                editor.cleanup();
            }
        }
    }

    private DiffPrepareReposInfo[] diffPrepareReposRepos(SVNWCContext context, SvnTarget svnTarget1, SvnTarget svnTarget2, SVNRevision revision1, SVNRevision revision2, SVNRevision pegRevision, SVNRepository[] outputRepository) throws SVNException {
        Structure<SvnRepositoryAccess.RevisionsPair> revisionNumber;
        SVNPathRevision resolved2;
        DiffPrepareReposInfo reposInfo1 = new DiffPrepareReposInfo();
        DiffPrepareReposInfo reposInfo2 = new DiffPrepareReposInfo();
        File localAbsPath1 = null;
        File localAbsPath2 = null;
        File wriAbsPath = null;
        if (!svnTarget2.isURL()) {
            localAbsPath2 = svnTarget2.getFile();
            reposInfo2.url = context.getNodeUrl(localAbsPath2);
            wriAbsPath = localAbsPath2;
        } else {
            reposInfo2.url = svnTarget2.getURL();
        }
        if (!svnTarget1.isURL()) {
            wriAbsPath = localAbsPath1 = svnTarget1.getFile();
        }
        SVNRepository repository = this.getRepositoryAccess().createRepository(reposInfo2.url, wriAbsPath);
        SVNPathRevision resolved1 = null;
        if (pegRevision == SVNRevision.UNDEFINED || svnTarget1 == svnTarget2 || localAbsPath2 != null) {
            try {
                resolved2 = this.getRepositoryAccess().resolveRevisionAndUrl(repository, svnTarget2, pegRevision, revision2);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.CLIENT_UNRELATED_RESOURCES && e.getErrorMessage().getErrorCode() != SVNErrorCode.FS_NOT_FOUND) {
                    throw e;
                }
                resolved2 = null;
            }
        } else {
            resolved2 = null;
        }
        if (pegRevision == SVNRevision.UNDEFINED || svnTarget1 == svnTarget2 || localAbsPath1 != null) {
            try {
                resolved1 = this.getRepositoryAccess().resolveRevisionAndUrl(repository, svnTarget1, pegRevision, revision1);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.CLIENT_UNRELATED_RESOURCES && e.getErrorMessage().getErrorCode() != SVNErrorCode.FS_NOT_FOUND) {
                    throw e;
                }
                resolved1 = null;
            }
        } else {
            revision1 = null;
        }
        if (resolved1 != null) {
            reposInfo1.url = resolved1.getUrl();
            reposInfo1.revision = resolved1.getRevision();
        } else {
            if (resolved2 != null && (pegRevision != SVNRevision.UNDEFINED || svnTarget1 == svnTarget2)) {
                reposInfo1.url = resolved2.getUrl();
            } else if (localAbsPath1 == null) {
                reposInfo1.url = svnTarget1.getURL();
            } else {
                reposInfo1.url = context.getNodeUrl(localAbsPath1);
            }
            revisionNumber = this.getRepositoryAccess().getRevisionNumber(repository, null, revision1, null);
            reposInfo1.revision = revisionNumber.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        }
        if (resolved2 != null) {
            reposInfo2.url = resolved2.getUrl();
            reposInfo2.revision = resolved2.getRevision();
        } else {
            if (resolved1 != null && (pegRevision != SVNRevision.UNDEFINED || svnTarget1 == svnTarget2)) {
                reposInfo2.url = resolved1.getUrl();
            }
            revisionNumber = this.getRepositoryAccess().getRevisionNumber(repository, null, revision2, null);
            reposInfo2.revision = revisionNumber.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        }
        repository.setLocation(reposInfo2.url, false);
        reposInfo2.kind = repository.checkPath("", reposInfo2.revision);
        repository.setLocation(reposInfo1.url, false);
        reposInfo1.kind = repository.checkPath("", reposInfo1.revision);
        if (reposInfo1.kind == SVNNodeKind.NONE && reposInfo2.kind == SVNNodeKind.NONE) {
            SVNErrorMessage errorMessage;
            if (reposInfo1.url.equals(reposInfo2.url)) {
                errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff target ''{0}'' was not found in the repository at revisions ''{1}'' and ''{2}''", reposInfo1.url, reposInfo1.revision, reposInfo2.revision);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            } else {
                errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff targets ''{0}'' and ''{1}'' were not found in the repository at revisions ''{2}'' and ''{3}''", reposInfo1.url, reposInfo2.url, reposInfo1.revision, reposInfo2.revision);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
        } else if (reposInfo1.kind == SVNNodeKind.NONE) {
            this.checkDiffTargetExists(reposInfo1.url, reposInfo2.revision, reposInfo1.revision, repository);
        } else if (reposInfo2.kind == SVNNodeKind.NONE) {
            this.checkDiffTargetExists(reposInfo2.url, reposInfo1.revision, reposInfo2.revision, repository);
        }
        SVNURL repositoryRoot = repository.getRepositoryRoot(false);
        reposInfo1.anchor = reposInfo1.url;
        reposInfo2.anchor = reposInfo2.url;
        reposInfo1.target = "";
        reposInfo2.target = "";
        if (!reposInfo1.url.equals(repositoryRoot) && !reposInfo2.url.equals(repositoryRoot)) {
            reposInfo1.anchor = reposInfo1.url.removePathTail();
            reposInfo1.target = SVNPathUtil.tail(reposInfo1.url.getPath());
            reposInfo2.anchor = reposInfo2.url.removePathTail();
            reposInfo2.target = SVNPathUtil.tail(reposInfo2.url.getPath());
            repository.setLocation(reposInfo1.anchor, false);
            try {
                repository.checkPath("", reposInfo1.revision);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.RA_DAV_FORBIDDEN || e.getErrorMessage().getErrorCode() != SVNErrorCode.RA_NOT_AUTHORIZED) {
                    reposInfo1.anchor = reposInfo1.anchor.appendPath(reposInfo1.target, false);
                    reposInfo2.anchor = reposInfo2.anchor.appendPath(reposInfo2.target, false);
                    reposInfo1.target = "";
                    reposInfo2.target = "";
                    repository.setLocation(reposInfo1.anchor, false);
                }
                throw e;
            }
        }
        if (outputRepository != null) {
            outputRepository[0] = repository;
        }
        return new DiffPrepareReposInfo[]{reposInfo1, reposInfo2};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffReposWC(SvnTarget target1, SVNRevision revision1, SVNRevision pegRevision, SvnTarget target2, SVNRevision revision2, boolean reverse) throws SVNException {
        SvnDiffEditor svnDiffEditor;
        assert (!target2.isURL());
        SVNURL url1 = this.getRepositoryAccess().getTargetURL(target1);
        String target = this.getWcContext().getActualTarget(target2.getFile());
        File anchor = target == null || target.length() == 0 ? target2.getFile() : SVNFileUtil.getParentFile(target2.getFile());
        SVNURL anchorUrl = this.getWcContext().getNodeUrl(anchor);
        if (anchorUrl == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Directory ''{0}'' has no URL", (Object)anchor);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        ISvnDiffGenerator generator = this.getDiffGenerator();
        if (pegRevision != SVNRevision.UNDEFINED) {
            url1 = (SVNURL)this.getRepositoryAccess().getLocations(null, target1, pegRevision, revision1, SVNRevision.UNDEFINED).get(SvnRepositoryAccess.LocationsInfo.startUrl);
            if (!reverse) {
                generator.setOriginalTargets(SvnTarget.fromURL(url1), SvnTarget.fromURL(anchorUrl.appendPath(target, false)));
                generator.setAnchors(SvnTarget.fromURL(url1), SvnTarget.fromURL(anchorUrl.appendPath(target, false)));
            } else {
                generator.setOriginalTargets(SvnTarget.fromURL(anchorUrl.appendPath(target, false)), SvnTarget.fromURL(url1));
                generator.setAnchors(SvnTarget.fromURL(anchorUrl.appendPath(target, false)), SvnTarget.fromURL(url1));
            }
        } else if (!reverse) {
            generator.setOriginalTargets(target1, target2);
            generator.setAnchors(target1, target2);
        } else {
            generator.setOriginalTargets(target2, target1);
            generator.setAnchors(target2, target1);
        }
        SVNRepository repository2 = this.getRepositoryAccess().createRepository(anchorUrl, null, true);
        if (((SvnDiff)this.getOperation()).isUseGitDiffFormat()) {
            File wcRoot = this.getWcContext().getDb().getWCRoot(anchor);
            generator.setRepositoryRoot(SvnTarget.fromFile(wcRoot));
        }
        boolean serverSupportsDepth = repository2.hasCapability(SVNCapability.DEPTH);
        long revisionNumber1 = this.getRepositoryAccess().getRevisionNumber(repository2, url1.equals(target1.getURL()) ? null : target1, revision1, null).lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        SvnDiffCallback callback = this.createDiffCallback(generator, reverse, revisionNumber1, -1L);
        SVNReporter17 reporter = new SVNReporter17(target2.getFile(), this.getWcContext(), false, !serverSupportsDepth, ((SvnDiff)this.getOperation()).getDepth(), false, false, true, false, SVNDebugLog.getDefaultLog());
        boolean revisionIsBase = this.isRevisionBase(revision2);
        ISVNUpdateEditor updateEditor = svnDiffEditor = new SvnDiffEditor(anchor, target, callback, ((SvnDiff)this.getOperation()).getDepth(), this.getWcContext(), reverse, revisionIsBase, ((SvnDiff)this.getOperation()).isShowCopiesAsAdds(), ((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).isRecurseIntoDeletedDirectories(), ((SvnDiff)this.getOperation()).getApplicableChangelists(), ((SvnDiff)this.getOperation()).isUseGitDiffFormat(), this);
        if (!serverSupportsDepth && ((SvnDiff)this.getOperation()).getDepth() == SVNDepth.UNKNOWN) {
            updateEditor = new SVNAmbientDepthFilterEditor17(updateEditor, this.getWcContext(), anchor, target, revisionIsBase);
        }
        ISVNEditor editor = SVNCancellableEditor.newInstance(updateEditor, this, SVNDebugLog.getDefaultLog());
        try {
            repository2.diff(url1, revisionNumber1, revisionNumber1, target, ((SvnDiff)this.getOperation()).isIgnoreAncestry(), this.getDiffDepth(((SvnDiff)this.getOperation()).getDepth()), true, (ISVNReporterBaton)reporter, editor);
        }
        finally {
            svnDiffEditor.cleanup();
        }
    }

    private void doDiffWCWC(SvnTarget target1, SVNRevision revision1, SvnTarget target2, SVNRevision revision2) throws SVNException {
        long revisionNumber1;
        File path2;
        assert (!target1.isURL());
        assert (!target2.isURL());
        File path1 = target1.getFile();
        if (!path1.equals(path2 = target2.getFile()) || revision1 != SVNRevision.BASE || revision2 != SVNRevision.WORKING) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Summarized diffs are only supported between a path's text-base and its working files at this time");
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        try {
            revisionNumber1 = this.getRepositoryAccess().getRevisionNumber(null, target1, revision1, null).lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.CLIENT_BAD_REVISION) {
                revisionNumber1 = 0L;
            }
            throw e;
        }
        SVNNodeKind kind = SVNFileType.getNodeKind(SVNFileType.getType(path1));
        String targetString1 = kind == SVNNodeKind.DIR ? "" : SVNFileUtil.getFileName(path1);
        ISvnDiffGenerator generator = this.getDiffGenerator();
        generator.setOriginalTargets(target1, target2);
        generator.setAnchors(target1, target2);
        if (((SvnDiff)this.getOperation()).isUseGitDiffFormat()) {
            generator.setRepositoryRoot(SvnTarget.fromFile(this.getWcContext().getDb().getWCRoot(target1.getFile())));
        }
        SvnDiffCallback callback = this.createDiffCallback(generator, false, revisionNumber1, -1L);
        SvnNgDiffUtil.doDiffWCWC(path1, this.getRepositoryAccess(), this.getWcContext(), ((SvnDiff)this.getOperation()).getDepth(), !((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).isRecurseIntoDeletedDirectories(), ((SvnDiff)this.getOperation()).getApplicableChangelists(), ((SvnDiff)this.getOperation()).isShowCopiesAsAdds(), ((SvnDiff)this.getOperation()).isUseGitDiffFormat(), generator, callback, ((SvnDiff)this.getOperation()).getEventHandler());
    }

    private void doDiffWC(File localAbspath, ISvnDiffCallback callback) throws SVNException {
        boolean getAll = ((SvnDiff)this.getOperation()).isShowCopiesAsAdds() || ((SvnDiff)this.getOperation()).isUseGitDiffFormat();
        boolean diffIgnored = false;
        SvnDiffStatusReceiver statusHandler = new SvnDiffStatusReceiver(this.getWcContext(), localAbspath, this.getWcContext().getDb(), callback, ((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).isShowCopiesAsAdds(), ((SvnDiff)this.getOperation()).isUseGitDiffFormat(), ((SvnDiff)this.getOperation()).getApplicableChangelists());
        SVNStatusEditor17 statusEditor = new SVNStatusEditor17(localAbspath, this.getWcContext(), ((SvnDiff)this.getOperation()).getOptions(), true, getAll, ((SvnDiff)this.getOperation()).getDepth(), statusHandler);
        statusEditor.walkStatus(localAbspath, ((SvnDiff)this.getOperation()).getDepth(), getAll, true, false, ((SvnDiff)this.getOperation()).getApplicableChangelists());
    }

    private SVNURL resolvePeggedDiffTargetUrl(SVNURL url, File path, SVNRevision pegRevision, SVNRevision revision) throws SVNException {
        try {
            Structure<SvnRepositoryAccess.LocationsInfo> locationsInfo = this.getRepositoryAccess().getLocations(null, url == null ? SvnTarget.fromFile(path) : SvnTarget.fromURL(url), pegRevision, revision, SVNRevision.UNDEFINED);
            return (SVNURL)locationsInfo.get(SvnRepositoryAccess.LocationsInfo.startUrl);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.CLIENT_UNRELATED_RESOURCES || e.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                return null;
            }
            throw e;
        }
    }

    private void checkDiffTargetExists(SVNURL url, long revision, long otherRevision, SVNRepository repository) throws SVNException {
        repository.setLocation(url, false);
        SVNNodeKind kind = repository.checkPath("", revision);
        if (kind == SVNNodeKind.NONE) {
            if (revision == otherRevision) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff target ''{0}'' was not found in the repository at revision ''{1}''", url, new Long(revision));
                SVNErrorManager.error(err, SVNLogType.WC);
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff target ''{0}'' was not found in the repository at revisions ''{1}'' and ''{2}''", url, new Long(revision), new Long(otherRevision));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
    }

    private SVNURL getURL(File path1) throws SVNException {
        return (SVNURL)this.getRepositoryAccess().getURLFromPath(SvnTarget.fromFile(path1), SVNRevision.UNDEFINED, null).get(SvnRepositoryAccess.UrlInfo.url);
    }

    private long getRevisionNumber(SVNRevision revision, SVNRepository repository, SvnTarget target) throws SVNException {
        Structure<SvnRepositoryAccess.RevisionsPair> revisionNumber = this.getRepositoryAccess().getRevisionNumber(repository, target, revision, null);
        return revisionNumber.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
    }

    private boolean isPeggedDiff() {
        return ((SvnDiff)this.getOperation()).getSource() != null;
    }

    private boolean isRevisionBase(SVNRevision revision2) {
        return revision2 == SVNRevision.BASE;
    }

    private SVNDepth getDiffDepth(SVNDepth depth) {
        return depth != SVNDepth.INFINITY ? depth : SVNDepth.UNKNOWN;
    }

    private SvnDiffCallback createDiffCallback(ISvnDiffGenerator generator, boolean reverse, long revisionNumber1, long revisionNumber2) {
        return new SvnDiffCallback(generator, reverse ? revisionNumber2 : revisionNumber1, reverse ? revisionNumber1 : revisionNumber2, ((SvnDiff)this.getOperation()).isShowCopiesAsAdds(), false, ((SvnDiff)this.getOperation()).getOutput());
    }

    private ISvnDiffGenerator getDiffGenerator() {
        ISvnDiffGenerator diffGenerator = ((SvnDiff)this.getOperation()).getDiffGenerator();
        if (diffGenerator == null) {
            diffGenerator = new SvnDiffGenerator();
        }
        diffGenerator.setUseGitFormat(((SvnDiff)this.getOperation()).isUseGitDiffFormat());
        if (((SvnDiff)this.getOperation()).getRelativeToDirectory() != null) {
            if (diffGenerator instanceof SvnDiffGenerator) {
                ((SvnDiffGenerator)diffGenerator).setRelativeToTarget(SvnTarget.fromFile(((SvnDiff)this.getOperation()).getRelativeToDirectory()));
            } else {
                diffGenerator.setBaseTarget(SvnTarget.fromFile(((SvnDiff)this.getOperation()).getRelativeToDirectory()));
            }
        }
        return diffGenerator;
    }

    private static class DiffDriverInfo {
        private Object anchor;
        private String repositoryRelPath;
        private String origPath1;
        private String origPath2;

        private DiffDriverInfo() {
        }
    }

    private static class DiffPrepareReposInfo {
        private SVNURL url;
        private long revision;
        private SVNURL anchor;
        private String target;
        private SVNNodeKind kind;

        private DiffPrepareReposInfo() {
        }
    }
}

