/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.DependencyBuilder;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.DependencyCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.EventBus;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.gate.TargetIdResolutionFailedException;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.IdMatchers$PhaseId$;
import com.xebialabs.xlrelease.repository.IdMatchers$ReleaseId$;
import com.xebialabs.xlrelease.repository.IdMatchers$TaskId$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions$;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyCandidateCollector;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseTreeBuilder;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.views.ReleaseTree;
import com.xebialabs.xlrelease.views.ReleaseTreeItem;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\tme\u0001B\u0013'\u0001=B\u0001\"\u0012\u0001\u0003\u0006\u0004%\tA\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u000f\"Aa\n\u0001BC\u0002\u0013\u0005q\n\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003Q\u0011!!\u0006A!b\u0001\n\u0003)\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011i\u0003!Q1A\u0005\u0002mC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tA\u0002\u0011)\u0019!C\u0001C\"A!\u000e\u0001B\u0001B\u0003%!\r\u0003\u0005l\u0001\t\u0015\r\u0011\"\u0001m\u0011!\u0001\bA!A!\u0002\u0013i\u0007\u0002C9\u0001\u0005\u000b\u0007I\u0011\u0001:\t\u0011Y\u0004!\u0011!Q\u0001\nMD\u0001b\u001e\u0001\u0003\u0006\u0004%\t\u0001\u001f\u0005\ty\u0002\u0011\t\u0011)A\u0005s\")Q\u0010\u0001C\u0001}\"I\u0011q\u0006\u0001C\u0002\u0013\u0005\u0011\u0011\u0007\u0005\t\u00037\u0002\u0001\u0015!\u0003\u00024!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0003bBAF\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0003/\u0003A\u0011AAM\u0011\u001d\t9\u000b\u0001C\u0001\u0003SCq!!3\u0001\t\u0003\tY\rC\u0004\u0002Z\u0002!\t!a7\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\"I\u0011\u0011 \u0001\u0012\u0002\u0013%\u00111 \u0005\n\u0005\u001f\u0001\u0011\u0013!C\u0005\u0005#AqA!\u0006\u0001\t\u0003\u00119\u0002C\u0004\u0003 \u0001!\tA!\t\t\u000f\tM\u0002\u0001\"\u0001\u00036!9!q\t\u0001\u0005\u0002\t%\u0003b\u0002B*\u0001\u0011\u0005!Q\u000b\u0005\b\u0005_\u0002A\u0011\u0002B9\u0011\u001d\u0011\t\t\u0001C\t\u0005\u0007CqAa\"\u0001\t#\u0011IIA\tEKB,g\u000eZ3oGf\u001cVM\u001d<jG\u0016T!a\n\u0015\u0002\u000fM,'O^5dK*\u0011\u0011FK\u0001\nq2\u0014X\r\\3bg\u0016T!a\u000b\u0017\u0002\u0013a,'-[1mC\n\u001c(\"A\u0017\u0002\u0007\r|Wn\u0001\u0001\u0014\u000b\u0001\u0001dGO\u001f\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\r\u0005s\u0017PU3g!\t9\u0004(D\u0001'\u0013\tIdE\u0001\nSK2,\u0017m]3Ue\u0016,')^5mI\u0016\u0014\bCA\u001c<\u0013\tadE\u0001\u000fEKB,g\u000eZ3oGf\u001c\u0015M\u001c3jI\u0006$XmQ8mY\u0016\u001cGo\u001c:\u0011\u0005y\u001aU\"A \u000b\u0005\u0001\u000b\u0015!B:mMRR'\"\u0001\"\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!\u0001R \u0003\u000f1{wmZ5oO\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0016\u0003\u001d\u0003\"\u0001S&\u000e\u0003%S!A\u0013\u0015\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002M\u0013\n\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0002%I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0015e\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u0016\u0003A\u0003\"aN)\n\u0005I3#\u0001\u0006*fY\u0016\f7/Z*fCJ\u001c\u0007nU3sm&\u001cW-A\u000bsK2,\u0017m]3TK\u0006\u00148\r[*feZL7-\u001a\u0011\u0002%Ad\u0017M\\%uK6\u0014V\r]8tSR|'/_\u000b\u0002-B\u0011\u0001jV\u0005\u00031&\u0013!\u0003\u00157b]&#X-\u001c*fa>\u001c\u0018\u000e^8ss\u0006\u0019\u0002\u000f\\1o\u0013R,WNU3q_NLGo\u001c:zA\u0005!B-\u001a9f]\u0012,gnY=SKB|7/\u001b;pef,\u0012\u0001\u0018\t\u0003\u0011vK!AX%\u0003)\u0011+\u0007/\u001a8eK:\u001c\u0017PU3q_NLGo\u001c:z\u0003U!W\r]3oI\u0016t7-\u001f*fa>\u001c\u0018\u000e^8ss\u0002\n\u0001\"\u001a<f]R\u0014Uo]\u000b\u0002EB\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\u0007KZ,g\u000e^:\u000b\u0005\u001dD\u0013A\u00023p[\u0006Lg.\u0003\u0002jI\nAQI^3oi\n+8/A\u0005fm\u0016tGOQ;tA\u0005qA/Y:l%\u0016\u0004xn]5u_JLX#A7\u0011\u0005!s\u0017BA8J\u00059!\u0016m]6SKB|7/\u001b;pef\fq\u0002^1tWJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\fG&LEmU3sm&\u001cW-F\u0001t!\t9D/\u0003\u0002vM\tY1)[%e'\u0016\u0014h/[2f\u00031\u0019\u0017.\u00133TKJ4\u0018nY3!\u0003A\t'o\u00195jm&twmU3sm&\u001cW-F\u0001z!\t9$0\u0003\u0002|M\t\u0001\u0012I]2iSZLgnZ*feZL7-Z\u0001\u0012CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\t\u0000\u0003\u0003\t\u0019!!\u0002\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\u0001\"a\u000e\u0001\t\u000b\u0015\u000b\u0002\u0019A$\t\u000b9\u000b\u0002\u0019\u0001)\t\u000bQ\u000b\u0002\u0019\u0001,\t\u000bi\u000b\u0002\u0019\u0001/\t\u000b\u0001\f\u0002\u0019\u00012\t\u000b-\f\u0002\u0019A7\t\u000bE\f\u0002\u0019A:\t\u000b]\f\u0002\u0019A=)\u0007E\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005-RBAA\f\u0015\u0011\tI\"a\u0007\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002\u001e\u0005}\u0011a\u00024bGR|'/\u001f\u0006\u0005\u0003C\t\u0019#A\u0003cK\u0006t7O\u0003\u0003\u0002&\u0005\u001d\u0012aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005%\u0012aA8sO&!\u0011QFA\f\u0005%\tU\u000f^8xSJ,G-\u0001\rbGRLg/\u001a#fa\u0016tG-\u001a8dsN#\u0018\r^;tKN,\"!a\r\u0011\r\u0005U\u0012QIA&\u001d\u0011\t9$!\u0011\u000f\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u0010/\u0003\u0019a$o\\8u}%\t1'C\u0002\u0002DI\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002H\u0005%#aA*fc*\u0019\u00111\t\u001a\u0011\t\u00055\u0013Q\u000b\b\u0005\u0003\u001f\n\t\u0006E\u0002\u0002:IJ1!a\u00153\u0003\u0019\u0001&/\u001a3fM&!\u0011qKA-\u0005\u0019\u0019FO]5oO*\u0019\u00111\u000b\u001a\u00023\u0005\u001cG/\u001b<f\t\u0016\u0004XM\u001c3f]\u000eL8\u000b^1ukN,7\u000fI\u0001\u0007GJ,\u0017\r^3\u0015\r\u0005\u0005\u0014\u0011NA:!\u0011\t\u0019'!\u001a\u000e\u0003\u0019L1!a\u001ag\u0005)!U\r]3oI\u0016t7-\u001f\u0005\b\u0003W\"\u0002\u0019AA7\u0003\u00119\u0017\r^3\u0011\t\u0005\r\u0014qN\u0005\u0004\u0003c2'\u0001C$bi\u0016$\u0016m]6\t\u000f\u0005UD\u00031\u0001\u0002L\u0005\u0011B/\u0019:hKRLEm\u0014:WCJL\u0017M\u00197fQ\r!\u0012\u0011\u0010\t\u0005\u0003w\n9)\u0004\u0002\u0002~)!\u0011\u0011DA@\u0015\u0011\t\t)a!\u0002\u000f5,GO]5dg*\u0019\u0011Q\u0011\u0017\u0002\u0011\r|G-\u00195bY\u0016LA!!#\u0002~\t)A+[7fI\u0006aQ\u000f\u001d3bi\u0016$\u0016M]4fiR1\u0011\u0011MAH\u0003'Cq!!%\u0016\u0001\u0004\tY%\u0001\u0007eKB,g\u000eZ3oGfLE\rC\u0004\u0002vU\u0001\r!a\u0013)\u0007U\tI(\u0001\u0004eK2,G/\u001a\u000b\u0005\u00037\u000b\t\u000bE\u00022\u0003;K1!a(3\u0005\u0011)f.\u001b;\t\u000f\u0005\rf\u00031\u0001\u0002L\u0005\u0011\u0011\u000e\u001a\u0015\u0004-\u0005e\u0014!F4fi\u000e{W\u000e\u001d7fi\u0006\u0014G.Z$bi\u0016LEm\u001d\u000b\u0005\u0003W\u000bY\f\u0005\u0004\u0002.\u0006]\u00161J\u0007\u0003\u0003_SA!!-\u00024\u0006!Q\u000f^5m\u0015\t\t),\u0001\u0003kCZ\f\u0017\u0002BA]\u0003_\u0013!bQ8mY\u0016\u001cG/[8o\u0011\u001d\til\u0006a\u0001\u0003\u007f\u000bq\u0001^1sO\u0016$8\u000f\u0005\u0004\u0002.\u0006]\u0016\u0011\u0019\t\u0005\u0003G\n\u0019-C\u0002\u0002F\u001a\u0014\u0001\u0002\u00157b]&#X-\u001c\u0015\u0004/\u0005e\u0014!\u00074j]\u0012\f5\r^5wK&s7m\\7j]\u001e<\u0015\r^3JIN$B!!4\u0002TB1\u0011QVAh\u0003\u0017JA!!5\u00020\n!A*[:u\u0011\u001d\t)\u000e\u0007a\u0001\u0003\u0017\n\u0001\u0002]1sK:$\u0018\n\u001a\u0015\u00041\u0005e\u0014AE4fi\u001a\u000b\u0017\u000e\\1cY\u0016<\u0015\r^3JIN$B!a+\u0002^\"9\u0011q\\\rA\u0002\u0005}\u0016AD1c_J$X\r\u001a+be\u001e,Go\u001d\u0015\u00043\u0005e\u0014\u0001\b4j]\u0012\fE\u000e\\%oG>l\u0017N\\4EKB,g\u000eZ3oGfLEm\u001d\u000b\t\u0003g\t9/a;\u0002p\"9\u0011\u0011\u001e\u000eA\u0002\u0005M\u0012!\u0003;be\u001e,G/\u00133t\u0011%\tiO\u0007I\u0001\u0002\u0004\t\u0019$\u0001\u0005ti\u0006$Xo]3t\u0011%\t\tP\u0007I\u0001\u0002\u0004\t\u00190A\nsK\u001a,'/\u001a8dS:<7\t[5mIJ,g\u000eE\u00022\u0003kL1!a>3\u0005\u001d\u0011un\u001c7fC:\faEZ5oI\u0006cG.\u00138d_6Lgn\u001a#fa\u0016tG-\u001a8ds&#7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tiP\u000b\u0003\u00024\u0005}8F\u0001B\u0001!\u0011\u0011\u0019Aa\u0003\u000e\u0005\t\u0015!\u0002\u0002B\u0004\u0005\u0013\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005e!'\u0003\u0003\u0003\u000e\t\u0015!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00061c-\u001b8e\u00032d\u0017J\\2p[&tw\rR3qK:$WM\\2z\u0013\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tM!\u0006BAz\u0003\u007f\f1DZ5oI\u0006\u001bG/\u001b<f\u001fV$xm\\5oOR\u000b'oZ3u\u0013\u0012\u001cH\u0003BAg\u00053AqAa\u0007\u001e\u0001\u0004\tY%A\u0005sK2,\u0017m]3JI\"\u001aQ$!\u001f\u0002\u001d\u001d,GOU3mK\u0006\u001cX\r\u0016:fKR!!1\u0005B\u0018!\u0011\u0011)Ca\u000b\u000e\u0005\t\u001d\"b\u0001B\u0015Q\u0005)a/[3xg&!!Q\u0006B\u0014\u0005-\u0011V\r\\3bg\u0016$&/Z3\t\u000f\tma\u00041\u0001\u0002L!\u001aa$!\u001f\u00027U\u0004H-\u0019;f\u000f\u0006$XMU3gKJ,gnY5oOBC\u0017m]3t)\u0019\tYJa\u000e\u0003<!9!\u0011H\u0010A\u0002\u0005-\u0013AB4bi\u0016LE\rC\u0004\u0003>}\u0001\rAa\u0010\u0002!=\u0014\u0018nZ5o)>\u0014Vm\u001d;pe\u0016$\u0007\u0003CAW\u0005\u0003\n\t-!1\n\t\t\r\u0013q\u0016\u0002\u0004\u001b\u0006\u0004\bfA\u0010\u0002z\u0005\u0019\u0012M]2iSZ,G)\u001a9f]\u0012,gnY5fgR1\u00111\u0014B&\u0005\u001bBqAa\u0007!\u0001\u0004\tY\u0005C\u0004\u0003P\u0001\u0002\r!a\r\u0002\u001b\u0011,\u0007/\u001a8eK:\u001c\u00170\u00133tQ\r\u0001\u0013\u0011P\u0001\u001fM&tG\rR3qK:$WM\\2z)\u0006\u0014x-\u001a;CsR\u000b'oZ3u\u0013\u0012,BAa\u0016\u0003^Q!!\u0011\fB5!\u0011\u0011YF!\u0018\r\u0001\u00119!qL\u0011C\u0002\t\u0005$!\u0001+\u0012\t\t\r\u0014\u0011\u0019\t\u0004c\t\u0015\u0014b\u0001B4e\t9aj\u001c;iS:<\u0007b\u0002B6C\u0001\u0007\u00111J\u0001\ti\u0006\u0014x-\u001a;JI\"\u001a\u0011%!\u001f\u0002!\u0019Lg\u000e\u001a)mC:LE/Z7Cs&#W\u0003\u0002B:\u0005{\"BA!\u001e\u0003\u0000A)\u0011Ga\u001e\u0003|%\u0019!\u0011\u0010\u001a\u0003\r=\u0003H/[8o!\u0011\u0011YF! \u0005\u000f\t}#E1\u0001\u0003b!9!1\u000e\u0012A\u0002\u0005-\u0013!\b4j]\u0012Le\u000e\u0015:pOJ,7o]%oG>l\u0017N\\4HCR,\u0017\nZ:\u0015\t\u0005M\"Q\u0011\u0005\b\u0003S\u001c\u0003\u0019AA\u001a\u0003)I7\u000fV3na2\fG/\u001a\u000b\u0005\u0003g\u0014Y\tC\u0004\u0002\u0012\u0012\u0002\r!a\u0013)\u0007\u0001\u0011y\t\u0005\u0003\u0003\u0012\n]UB\u0001BJ\u0015\u0011\u0011)*a\t\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0003\u001a\nM%aB*feZL7-\u001a")
public class DependencyService
implements ReleaseTreeBuilder,
DependencyCandidateCollector,
Logging {
    private final ReleaseRepository releaseRepository;
    private final ReleaseSearchService releaseSearchService;
    private final PlanItemRepository planItemRepository;
    private final DependencyRepository dependencyRepository;
    private final EventBus eventBus;
    private final TaskRepository taskRepository;
    private final CiIdService ciIdService;
    private final ArchivingService archivingService;
    private final Seq<String> activeDependencyStatuses;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    @Timed
    public List<Release> findAllDependencyCandidates(String gateId) {
        return DependencyCandidateCollector.findAllDependencyCandidates$(this, gateId);
    }

    @Override
    @Timed
    public Release getDependencyCandidate(String gateId, String targetReleaseId) {
        return DependencyCandidateCollector.getDependencyCandidate$(this, gateId, targetReleaseId);
    }

    @Override
    public Seq<String> getReferencedCis(String gateReleaseId) {
        return DependencyCandidateCollector.getReferencedCis$(this, gateReleaseId);
    }

    @Override
    public boolean isReferencable(PlanItem planItem, Seq<String> referencedIds) {
        return DependencyCandidateCollector.isReferencable$(this, planItem, referencedIds);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, PlanItem item) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, item);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, TaskGroup taskGroup) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, taskGroup);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, GateTask gateTask) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, gateTask);
    }

    @Override
    public Object loadDependentRelease(Dependency dependency, String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.loadDependentRelease$(this, dependency, releaseId, dependentReleases);
    }

    @Override
    public PartialFunction<Task, ReleaseTreeItem> taskMatcher(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.taskMatcher$(this, releaseId, dependentReleases);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyService dependencyService = this;
        synchronized (dependencyService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    public PlanItemRepository planItemRepository() {
        return this.planItemRepository;
    }

    @Override
    public DependencyRepository dependencyRepository() {
        return this.dependencyRepository;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public Seq<String> activeDependencyStatuses() {
        return this.activeDependencyStatuses;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dependency create(GateTask gate, String targetIdOrVariable) {
        void var3_3;
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't add a dependency to a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkCreateDependency((Task)gate);
        Dependency dependency = DependencyBuilder.newDependency().withId(this.ciIdService().getUniqueId(Type.valueOf(Dependency.class), gate.getId())).build();
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
        } else {
            Object target = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTarget(target);
        }
        gate.addDependency(dependency);
        dependency.setGateTask(gate);
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().create(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyCreatedEvent(dependency));
        return var3_3;
    }

    @Timed
    public Dependency updateTarget(String dependencyId, String targetIdOrVariable) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't edit a dependency on a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkUpdateDependency((Task)gate);
        Dependency dependency = gate.getDependencies().stream().filter(d -> {
            String string = dependencyId;
            String string2 = d.getId();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).findFirst().orElseThrow(() -> new NotFoundException(String.format("Dependency with Id '%s' not found.", dependencyId), new Object[0]));
        Dependency original = CiCloneHelper.cloneCi(dependency);
        Checks.checkArgument((!dependency.isDone() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be updated", (Object[])new Object[0]);
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(null);
        } else {
            Object newTarget = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(newTarget);
        }
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().update(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, dependency));
        return dependency;
    }

    @Timed
    public void delete(String id) {
        Dependency dependency = this.dependencyRepository().findById(id);
        GateTask gate = dependency.getGateTask();
        LockedTaskOperationChecks$.MODULE$.checkDeleteDependency((Task)gate);
        Checks.checkArgument((!dependency.isDone() || gate.isPlanned() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be deleted", (Object[])new Object[0]);
        this.dependencyRepository().delete(dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyDeletedEvent(dependency));
    }

    @Timed
    public Collection<String> getCompletableGateIds(Collection<PlanItem> targets) {
        Seq doneTargetIds = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(targets).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDone()))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Iterable$.MODULE$.canBuildFrom())).toSeq();
        return (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)this.findInProgressIncomingGateIds((Seq<String>)doneTargetIds).map((Function1 & Serializable & scala.Serializable)id -> (GateTask)this.taskRepository().findById((String)id), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isCompletable()))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getId(), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    public List<String> findActiveIncomingGateIds(String parentId) {
        Seq seq;
        if (this.planItemRepository().exists(parentId)) {
            seq = (Seq)((SeqLike)((TraversableLike)this.findAllIncomingDependencyIds((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{parentId}))), this.activeDependencyStatuses(), true).filterNot((Function1 & Serializable & scala.Serializable)dependencyId -> BoxesRunTime.boxToBoolean((boolean)this.isTemplate(dependencyId)))).map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getParentId((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Plan item ").append(parentId).append(" not found. It is either archived, or does not exist. Returning no dependencies").toString());
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(seq).asJava();
    }

    @Timed
    public Collection<String> getFailableGateIds(Collection<PlanItem> abortedTargets) {
        return (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.findInProgressIncomingGateIds((Seq<String>)((Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(abortedTargets).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getId(), Seq$.MODULE$.canBuildFrom())))).asJava();
    }

    private Seq<String> findAllIncomingDependencyIds(Seq<String> targetIds, Seq<String> statuses, boolean referencingChildren) {
        return (Seq)this.dependencyRepository().findAllIncomingDependencies(targetIds, statuses, referencingChildren).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getId(), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<String> findAllIncomingDependencyIds$default$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private boolean findAllIncomingDependencyIds$default$3() {
        return false;
    }

    @Timed
    public List<String> findActiveOutgoingTargetIds(String releaseId) {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.dependencyRepository().findByReleaseId(releaseId)).asScala()).filter((Function1 & Serializable & scala.Serializable)dep -> BoxesRunTime.boxToBoolean((boolean)DependencyService.$anonfun$findActiveOutgoingTargetIds$1(dep)))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getTargetId(), Buffer$.MODULE$.canBuildFrom())).distinct()).asJava();
    }

    @Timed
    public ReleaseTree getReleaseTree(String releaseId) {
        ReleaseTree releaseTree;
        if (this.archivingService().exists(releaseId)) {
            releaseTree = new ReleaseTree();
        } else {
            scala.collection.mutable.Map dependentReleases = Map$.MODULE$.empty();
            Release release = this.releaseRepository().findById(releaseId);
            this.toTreeItem(releaseId, (scala.collection.mutable.Map<String, ReleaseTreeItem>)dependentReleases, (PlanItem)release);
            ReleaseTree tree = new ReleaseTree();
            tree.releaseId_$eq(releaseId);
            tree.dependentReleases_$eq((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)dependentReleases.values().toList()).asJava());
            releaseTree = tree;
        }
        return releaseTree;
    }

    @Timed
    public void updateGateReferencingPhases(String gateId, Map<PlanItem, PlanItem> originToRestored) {
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Release release = gate.getRelease();
        gate.getDependencies().forEach(dependency -> {
            block0: {
                PlanItem target = dependency.getTarget();
                if (!originToRestored.containsKey(target)) break block0;
                Dependency original = CiCloneHelper.cloneCi(dependency);
                dependency.setTarget((PlanItem)originToRestored.get(target));
                Dependency updatedDependency = this.dependencyRepository().update(release, (Dependency)dependency);
                this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, updatedDependency));
            }
        });
    }

    @Timed
    public void archiveDependencies(String releaseId, Seq<String> dependencyIds) {
        Release referencingRelease = this.releaseRepository().findById(releaseId);
        Buffer dependenciesToArchive = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(referencingRelease.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$9.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)dependencyIds.contains((Object)d.getId())));
        dependenciesToArchive.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.archive();
            return BoxedUnit.UNIT;
        });
        this.dependencyRepository().archive(referencingRelease, (Seq<Dependency>)dependenciesToArchive);
    }

    @Timed
    public <T extends PlanItem> T findDependencyTargetByTargetId(String targetId) {
        PlanItem planItem;
        String string = targetId;
        Option<String> option = IdMatchers$ReleaseId$.MODULE$.unapply(string);
        if (!option.isEmpty()) {
            planItem = (PlanItem)this.findPlanItemById(targetId).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.archivingService().getRelease(targetId));
        } else {
            Option<String> option2 = IdMatchers$PhaseId$.MODULE$.unapply(string);
            if (!option2.isEmpty()) {
                planItem = (PlanItem)this.findPlanItemById(targetId).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.archivingService().getPhase(targetId));
            } else {
                Option<String> option3 = IdMatchers$TaskId$.MODULE$.unapply(string);
                if (!option3.isEmpty()) {
                    planItem = (PlanItem)this.findPlanItemById(targetId).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.archivingService().getTask(targetId));
                } else {
                    throw new TargetIdResolutionFailedException(new StringBuilder(35).append("Target is not plan item, targetId= ").append(targetId).toString());
                }
            }
        }
        return (T)planItem;
    }

    private <T extends PlanItem> Option<T> findPlanItemById(String targetId) {
        Some some;
        try {
            some = new Some(this.planItemRepository().findById(targetId, ResolveOptions$.MODULE$.MINIMAL()));
        }
        catch (NotFoundException notFoundException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public Seq<String> findInProgressIncomingGateIds(Seq<String> targetIds) {
        return (Seq)((SeqLike)this.findAllIncomingDependencyIds(targetIds, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TaskStatus.IN_PROGRESS.name()}))), this.findAllIncomingDependencyIds$default$3()).map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getParentId((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
    }

    public boolean isTemplate(String dependencyId) {
        return this.releaseRepository().isTemplate(Ids.releaseIdFrom((String)dependencyId));
    }

    public static final /* synthetic */ boolean $anonfun$findActiveOutgoingTargetIds$1(Dependency dep) {
        return dep.hasResolvedTarget() && !dep.isDone();
    }

    @Autowired
    public DependencyService(ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, PlanItemRepository planItemRepository, DependencyRepository dependencyRepository, EventBus eventBus, TaskRepository taskRepository, CiIdService ciIdService, ArchivingService archivingService) {
        this.releaseRepository = releaseRepository;
        this.releaseSearchService = releaseSearchService;
        this.planItemRepository = planItemRepository;
        this.dependencyRepository = dependencyRepository;
        this.eventBus = eventBus;
        this.taskRepository = taskRepository;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        ReleaseTreeBuilder.$init$(this);
        DependencyCandidateCollector.$init$(this);
        Logging.$init$((Logging)this);
        this.activeDependencyStatuses = (Seq)((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])TaskStatus.ACTIVE_STATUSES)).toSeq().$colon$plus((Object)TaskStatus.PLANNED, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom());
    }
}

