/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plumbing.ExecutionOutputWriter;
import com.xebialabs.deployit.plumbing.PollingExecutionOutputHandler;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.platform.script.jython.JythonSupport$;
import com.xebialabs.platform.script.jython.ThreadLocalWriterDecorator;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.internal.ReleaseServerUrlDecorator;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.BaseScriptTask;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ResolvableScriptTask;
import com.xebialabs.xlrelease.domain.ScriptHelper;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.recover.TaskRecoverOp;
import com.xebialabs.xlrelease.domain.utils.PythonScriptCiHelper;
import com.xebialabs.xlrelease.domain.variables.ScriptValueProviderConfiguration;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.ReleaseVariablesUpdateOperation;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.events.XLReleaseOperation;
import com.xebialabs.xlrelease.events.XLReleaseOperations;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.script.EncryptionHelper;
import com.xebialabs.xlrelease.script.ExecuteRecoverCallback;
import com.xebialabs.xlrelease.script.OutputHandler;
import com.xebialabs.xlrelease.script.ScriptCallback;
import com.xebialabs.xlrelease.script.ScriptExecutor;
import com.xebialabs.xlrelease.script.ScriptLifeCycle;
import com.xebialabs.xlrelease.script.ScriptService;
import com.xebialabs.xlrelease.script.ScriptServiceHelper;
import com.xebialabs.xlrelease.script.ScriptVariables;
import com.xebialabs.xlrelease.script.TruncatingCommentUpdater;
import com.xebialabs.xlrelease.script.VariablesHolderForScriptContext;
import com.xebialabs.xlrelease.script.XlrScriptContext;
import com.xebialabs.xlrelease.security.FacetPermissionChecker;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.authentication.AuthenticationService;
import com.xebialabs.xlrelease.service.AttachmentService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.FacetService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.RestartPhasesException;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.SensitiveValueScrubber;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptException;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.python.core.PyException;
import org.python.core.PyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;

public abstract class DefaultScriptService
implements ScriptService,
ExecuteRecoverCallback {
    private static final String MDC_KEY_TASK = "task";
    public static final String OUTPUT_TOO_LONG_MESSAGE = "This value was too long and has been cut off at the end. ";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ScriptVariables scriptVariables;
    protected Scheduler scheduler;
    protected ReleaseActorService releaseActorService;
    protected ScriptLifeCycle scriptLifeCycle;
    protected ScriptExecutor scriptExecutor;
    protected ThreadLocalWriterDecorator executionLog = JythonSupport$.MODULE$.outWriterDecorator();
    protected AuthenticationService authenticationService;
    private ReleaseService releaseService;
    protected PermissionChecker permissions;
    protected CiIdService ciIdService;
    protected CommentService commentService;
    protected XlrConfig xlrConfig;
    private XLReleaseEventBus eventBus;
    protected TaskRepository taskRepository;
    private FacetService facetService;
    private FacetPermissionChecker facetPermissions;
    protected ServerConfiguration serverConfiguration;
    private AttachmentService attachmentService;

    protected DefaultScriptService(Scheduler scheduler, ReleaseActorService releaseActorService, ScriptLifeCycle scriptLifeCycle, ScriptExecutor scriptExecutor, AuthenticationService authenticationService, ReleaseService releaseService, ScriptVariables scriptVariables, PermissionChecker permissions, CiIdService ciIdService, CommentService commentService, XlrConfig xlrConfig, XLReleaseEventBus eventBus, TaskRepository taskRepository, ServerConfiguration serverConfiguration, FacetService facetService, FacetPermissionChecker facetPermissions, AttachmentService attachmentService) {
        this.scheduler = scheduler;
        this.releaseActorService = releaseActorService;
        this.scriptLifeCycle = scriptLifeCycle;
        this.scriptExecutor = scriptExecutor;
        this.authenticationService = authenticationService;
        this.releaseService = releaseService;
        this.permissions = permissions;
        this.ciIdService = ciIdService;
        this.commentService = commentService;
        this.xlrConfig = xlrConfig;
        this.eventBus = eventBus;
        this.taskRepository = taskRepository;
        this.facetService = facetService;
        this.facetPermissions = facetPermissions;
        this.scriptVariables = scriptVariables;
        this.serverConfiguration = serverConfiguration;
        this.attachmentService = attachmentService;
    }

    @Override
    public void executeScriptTask(ResolvableScriptTask task, ScriptCallback onSuccess, ScriptCallback onFailure, SensitiveValueScrubber scrubber) {
        this.scriptLifeCycle.register(task.getExecutionId());
        this.scheduler.execute(() -> {
            block11: {
                this.registerWriterForTask((Task)task, scrubber);
                XlrScriptContext scriptContext = null;
                VariablesHolderForScriptContext variablesHolderForScriptContext = new VariablesHolderForScriptContext(this.scriptVariables.initialReleaseVariables(task.getRelease()), this.scriptVariables.initialFolderVariable(task.getRelease().findFolderId()), this.scriptVariables.initialGlobalVariables(), this.variablesSynchronizationCallback((Task)task));
                try {
                    this.authenticationService.loginScriptUser((Task)task, variablesHolderForScriptContext);
                    scriptContext = this.prepareScriptTaskContext((Task)task, (Writer)this.executionLog, this.scriptVariables.toVariableValues(variablesHolderForScriptContext.getPreviousGlobalVariables()), this.scriptVariables.toVariableValues(variablesHolderForScriptContext.getPreviousFolderVariables()), this.scriptVariables.toVariableValues(variablesHolderForScriptContext.getPreviousReleaseVariables()));
                    variablesHolderForScriptContext.setScriptContext(scriptContext);
                    this.executeScript(task.getScript(), scriptContext, (Task)task, true);
                    variablesHolderForScriptContext.synchronize();
                    this.runScriptCallback(this.executionLog, onSuccess, task.getId());
                }
                catch (ScriptException exception) {
                    try {
                        variablesHolderForScriptContext.synchronize();
                        if (this.isSystemExit0(exception)) {
                            this.runScriptCallback(this.executionLog, onSuccess, task.getId());
                            break block11;
                        }
                        if (this.isRestartPhasesException(exception)) {
                            this.onRestartPhasesException((RestartPhasesException)((Object)((Object)ExceptionUtils.getRootCause((Throwable)exception))), this.executionLog, onFailure, (BaseScriptTask)task);
                            break block11;
                        }
                        this.onScriptException(exception, this.executionLog, onFailure, task.getId());
                    }
                    catch (Exception resultsException) {
                        this.onException(resultsException, this.executionLog, onFailure, task.getId(), exception.toString() + "\n", "Exception saving script results of script task '{}':");
                    }
                }
                catch (Exception exception) {
                    this.onException(exception, this.executionLog, onFailure, task.getId(), "Exception during execution:\n", "Unexpected exception during execution of script task '{}':");
                }
                finally {
                    this.authenticationService.logoutScriptUser();
                    this.finishScript(task.getExecutionId());
                }
            }
        });
    }

    @Override
    public void executeCustomScriptTask(CustomScriptTask task, ScriptCallback onSuccess, ScriptCallback onFailure, SensitiveValueScrubber scrubber) {
        this.scriptLifeCycle.register(task.getExecutionId());
        this.fixVariableMapping(task);
        this.scheduler.execute(() -> {
            block13: {
                String script;
                this.registerWriterForTask((Task)task, scrubber);
                try {
                    script = task.isAbortScriptInProgress() ? task.getPythonScript().getAbortScript() : task.getPythonScript().getScript();
                }
                catch (IOException exception) {
                    this.onException(exception, this.executionLog, onFailure, task.getId(), "Exception while loading script:\n", "Error while loading script on task '{}':");
                    this.finishScript(task.getExecutionId());
                    return;
                }
                XlrScriptContext scriptContext = null;
                try {
                    scriptContext = this.prepareCustomScriptTaskContext(task, (Writer)this.executionLog);
                    this.doExecuteScript(task, scriptContext, script, onSuccess, scrubber);
                }
                catch (ScriptException exception) {
                    try {
                        if (this.isSystemExit0(exception)) {
                            this.saveCustomScriptResults(task, scriptContext, scrubber);
                            this.runScriptCallback(this.executionLog, onSuccess, task.getId());
                            break block13;
                        }
                        if (this.isRestartPhasesException(exception)) {
                            this.onRestartPhasesException((RestartPhasesException)((Object)((Object)ExceptionUtils.getRootCause((Throwable)exception))), this.executionLog, onFailure, (BaseScriptTask)task);
                            break block13;
                        }
                        this.onScriptException(exception, this.executionLog, onFailure, task.getId());
                    }
                    catch (Exception resultsException) {
                        this.onException(resultsException, this.executionLog, onFailure, task.getId(), exception.toString() + "\n", "Exception saving script results of custom script task '{}':");
                    }
                }
                catch (Exception exception) {
                    this.onException(exception, this.executionLog, onFailure, task.getId(), "Exception during execution:\n", "Unexpected exception during execution of task '{}':");
                }
                finally {
                    this.authenticationService.logoutScriptUser();
                    this.finishScript(task.getExecutionId());
                }
            }
        });
    }

    protected void saveCustomScriptResults(CustomScriptTask task, XlrScriptContext scriptContext, SensitiveValueScrubber scrubber) {
        this.releaseActorService.saveCustomScriptResults(task.getId(), new CustomScriptTaskResults(ScriptServiceHelper.extractTransitionalAndOutputPropertyValues(task, scriptContext, scrubber), task.getExecutionId(), task.getStatusLine(), task.getNextScriptPath(), task.getInterval()));
    }

    private void finishScript(String executionId) {
        this.removeWriter();
        this.scriptLifeCycle.unregister(executionId);
    }

    private void fixVariableMapping(CustomScriptTask task) {
        Collection outputProperties = task.getPythonScript().getOutputProperties();
        boolean updated = false;
        for (PropertyDescriptor propertyDescriptor : outputProperties) {
            String propertyName = propertyDescriptor.getName();
            String fqPropertyName = "pythonScript." + propertyName;
            Object propertyValue = task.getPythonScript().getProperty(propertyName);
            if (!(propertyValue instanceof String) || !VariableHelper.containsOnlyVariable((String)((String)propertyValue)) || task.getVariableMapping().containsKey(fqPropertyName)) continue;
            this.logger.debug("adding variable pre 5.0 [{}] with value [{}]", (Object)fqPropertyName, propertyValue);
            task.getVariableMapping().put(fqPropertyName, (String)propertyValue);
            updated = true;
        }
        if (updated) {
            this.taskRepository.update((Task)task);
        }
    }

    @Override
    public Object executeScript(String script, XlrScriptContext scriptContext) {
        scriptContext.setWriter((Writer)this.executionLog);
        return this.executeScriptWithWriter(script, scriptContext, false, false);
    }

    public Object executeScriptWithWriter(String script, XlrScriptContext scriptContext) {
        return this.executeScriptWithWriter(script, scriptContext, false, false);
    }

    /*
     * Exception decompiling
     */
    public Object executeScriptWithWriter(String script, XlrScriptContext scriptContext, boolean checkPolicyPermissions, boolean withApi) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void executePrecondition(final Task task, final ScriptCallback preconditionValidCallback, final ScriptCallback preconditionInvalidCallback, final ScriptCallback preconditionExceptionCallback) {
        this.scriptLifeCycle.register(task.getExecutionId());
        this.scheduler.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DefaultScriptService.this.registerWriterForTask(task, SensitiveValueScrubber.disabled());
                String script = task.getPrecondition();
                try {
                    DefaultScriptService.this.authenticationService.loginScriptUser(task);
                    XlrScriptContext scriptContext = DefaultScriptService.this.prepareScriptTaskContext(task, (Writer)DefaultScriptService.this.executionLog);
                    Object statementResult = DefaultScriptService.this.executeScript(script, scriptContext, task, true);
                    Object resultVariable = scriptContext.getAttribute("result");
                    if (statementResult == null && resultVariable == null) {
                        DefaultScriptService.this.executionLog.append((CharSequence)"Precondition did not return anything\n");
                        this.runCallback(preconditionExceptionCallback);
                    } else if (this.isTrue(statementResult) || this.isTrue(resultVariable)) {
                        DefaultScriptService.this.executionLog.append((CharSequence)"Precondition is valid (returned True)\n");
                        this.runCallback(preconditionValidCallback);
                    } else {
                        DefaultScriptService.this.executionLog.append((CharSequence)"Precondition is invalid (returned a value that is not True)\n");
                        this.runCallback(preconditionInvalidCallback);
                    }
                }
                catch (Exception exception) {
                    DefaultScriptService.this.onException(exception, DefaultScriptService.this.executionLog, preconditionExceptionCallback, task.getId(), "Exception during execution:\n", "Unexpected exception during precondition check of script task '{}':");
                }
                finally {
                    DefaultScriptService.this.authenticationService.logoutScriptUser();
                    DefaultScriptService.this.finishScript(task.getExecutionId());
                }
            }

            private void runCallback(ScriptCallback callback) {
                callback.setExecutionLog(DefaultScriptService.this.executionLog.toString());
                DefaultScriptService.this.closeWriter();
                callback.run();
            }

            private boolean isTrue(Object preconditionResult) {
                return preconditionResult instanceof Boolean && (Boolean)preconditionResult != false;
            }
        });
    }

    @Override
    public void executeFacetCheck(final Task task, final ScriptCallback validCallback, final ScriptCallback invalidCallback, final ScriptCallback exceptionCallback) {
        this.scriptLifeCycle.register(task.getExecutionId());
        this.scheduler.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DefaultScriptService.this.registerWriterForTask(task, SensitiveValueScrubber.disabled());
                try {
                    List facetsWithScript = task.getFacets().stream().filter(f -> f.hasProperty("scriptLocation")).collect(Collectors.toList());
                    boolean executeSuccessful = false;
                    for (Facet facetWithScript : facetsWithScript) {
                        String script = ScriptHelper.getScript((ConfigurationItem)facetWithScript);
                        DefaultScriptService.this.authenticationService.loginScriptUser(task);
                        XlrScriptContext scriptContext = DefaultScriptService.this.prepareScriptTaskContext(task, (Writer)DefaultScriptService.this.executionLog);
                        scriptContext.setAttribute("currentFacet", facetWithScript, 100);
                        Object statementResult = DefaultScriptService.this.executeScript(script, scriptContext, task, true);
                        Object resultVariable = scriptContext.getAttribute("result");
                        if (statementResult == null && resultVariable == null) {
                            DefaultScriptService.this.executionLog.append((CharSequence)"Environment is not available: script did not return anything\n");
                            this.runCallback(exceptionCallback);
                            executeSuccessful = false;
                            break;
                        }
                        if (this.isTrue(statementResult) || this.isTrue(resultVariable)) {
                            executeSuccessful = true;
                            continue;
                        }
                        DefaultScriptService.this.executionLog.append((CharSequence)"Environment is not available: script returned a value that is not True\n");
                        this.runCallback(invalidCallback);
                        executeSuccessful = false;
                        break;
                    }
                    if (executeSuccessful) {
                        DefaultScriptService.this.executionLog.append((CharSequence)"Environment is available: script is valid (returned True)\n");
                        this.runCallback(validCallback);
                    }
                }
                catch (Exception exception) {
                    DefaultScriptService.this.onException(exception, DefaultScriptService.this.executionLog, exceptionCallback, task.getId(), "Exception during execution:\n", "Unexpected exception during attribute check of task '{}':");
                }
                finally {
                    DefaultScriptService.this.authenticationService.logoutScriptUser();
                    DefaultScriptService.this.finishScript(task.getExecutionId());
                }
            }

            private void runCallback(ScriptCallback callback) {
                callback.setExecutionLog(DefaultScriptService.this.executionLog.toString());
                DefaultScriptService.this.closeWriter();
                callback.run();
            }

            private boolean isTrue(Object result) {
                return result instanceof Boolean && (Boolean)result != false;
            }
        });
    }

    @Override
    public Collection<Object> executeScriptValueProvider(ScriptValueProviderConfiguration valueProviderConfiguration) {
        CompletableFuture future = new CompletableFuture();
        Variable variable = valueProviderConfiguration.getVariable();
        String releaseId = Ids.releaseIdFrom((String)variable.getId());
        Release release = this.releaseService.findById(releaseId);
        this.scheduler.submit(() -> {
            this.authenticationService.loginScriptUser(release);
            XlrScriptContext scriptContext = this.prepareScriptValueProviderContext(release, valueProviderConfiguration);
            DefaultResourceLoader loader = new DefaultResourceLoader();
            Resource resource = loader.getResource(valueProviderConfiguration.getScript());
            Collection<Object> res = null;
            try (InputStream is = resource.getInputStream();){
                String script = StreamUtils.copyToString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                this.executeScriptWithApi(script, scriptContext, false);
                res = scriptContext.getValueProviderResult();
            }
            catch (Exception e) {
                this.logger.error("unknown exception: ", (Throwable)e);
            }
            finally {
                this.authenticationService.logoutScriptUser();
            }
            future.complete(res);
        });
        long releaseActionTimeoutSeconds = this.xlrConfig.timeoutSettings().releaseActionResponse().toSeconds();
        try {
            return (Collection)future.get(releaseActionTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            future.cancel(true);
            String message = String.format("Execution of value provider for variable [%s] with release id [%s] was terminated due to timeout of [%s] seconds. Consider to increase 'xl.timeouts.releaseActionResponse' property", variable.getKey(), release.getId(), releaseActionTimeoutSeconds);
            this.logger.warn(message);
            return Collections.emptyList();
        }
    }

    @Override
    public void executeFailureHandler(Task task) {
        this.scriptLifeCycle.register(task.getExecutionId());
        ScriptCallback callback = this.recoverCallback(task);
        Future<?> future = this.scheduler.submit(() -> {
            block12: {
                this.registerWriterForTask(task, SensitiveValueScrubber.disabled());
                XlrScriptContext scriptContext = null;
                VariablesHolderForScriptContext variablesHolderForScriptContext = new VariablesHolderForScriptContext(this.scriptVariables.initialReleaseVariables(task.getRelease()), this.scriptVariables.initialFolderVariable(task.getRelease().findFolderId()), this.scriptVariables.initialGlobalVariables(), this.variablesSynchronizationCallback(task));
                try {
                    this.authenticationService.loginScriptUser(task, variablesHolderForScriptContext);
                    scriptContext = this.prepareScriptTaskContext(task, (Writer)this.executionLog, this.scriptVariables.toVariableValues(variablesHolderForScriptContext.getPreviousGlobalVariables()), this.scriptVariables.toVariableValues(variablesHolderForScriptContext.getPreviousFolderVariables()), this.scriptVariables.toVariableValues(variablesHolderForScriptContext.getPreviousReleaseVariables()));
                    variablesHolderForScriptContext.setScriptContext(scriptContext);
                    String failureHandlerScript = task.getFailureHandler();
                    if (this.isScriptRunnable(task, failureHandlerScript)) {
                        this.executeScript(failureHandlerScript, scriptContext, task, true);
                        variablesHolderForScriptContext.synchronize();
                    }
                    if (task.isFailureHandlerEnabled()) {
                        this.runScriptCallback(this.executionLog, callback, task.getId());
                    }
                }
                catch (ScriptException exception) {
                    this.logger.warn("ScriptException: ", (Throwable)exception);
                    try {
                        variablesHolderForScriptContext.synchronize();
                        if (this.isSystemExit0(exception)) {
                            this.runScriptCallback(this.executionLog, callback, task.getId());
                            break block12;
                        }
                        this.onScriptException(exception, this.executionLog, (ScriptCallback)this.fallbackCallback(task).apply((Object)exception), task.getId());
                    }
                    catch (Exception resultsException) {
                        this.onException(resultsException, this.executionLog, (ScriptCallback)this.fallbackCallback(task).apply((Object)exception), task.getId(), exception.toString() + "\n", "Exception saving script results of task '{}':");
                    }
                }
                catch (Exception exception) {
                    this.logger.warn("unknown exception: ", (Throwable)exception);
                    this.onException(exception, this.executionLog, (ScriptCallback)this.fallbackCallback(task).apply((Object)exception), task.getId(), "Exception during execution:\n", "Unexpected exception during execution of failure handler for task '{}':");
                }
                finally {
                    this.authenticationService.logoutScriptUser();
                    this.finishScript(task.getExecutionId());
                }
            }
        });
        this.executeTaskWithTimeout(task, future, this.xlrConfig.timeoutSettings().failureHandlerTimeout().toSeconds(), "Failure handler of task [%s] with script execution [%s] was terminated due to timeout of [%s] seconds. Consider to increase 'xl.timeouts.failureHandlerTimeout' property");
    }

    private void executeTaskWithTimeout(Task task, Future<?> future, long timeout, String exceptionMessage) {
        this.scheduler.execute(() -> {
            try {
                future.get(timeout, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                future.cancel(true);
                String message = String.format(exceptionMessage, task.getId(), task.getExecutionId(), timeout);
                this.logger.warn(message);
                this.releaseActorService.addCommentToTask(task.getId(), message);
            }
        });
    }

    private void doExecuteScript(CustomScriptTask task, XlrScriptContext scriptContext, String script, ScriptCallback onSuccess, SensitiveValueScrubber scrubber) throws Exception {
        this.authenticationService.loginScriptUser((Task)task);
        this.executeScript(script, scriptContext, (Task)task, false);
        this.saveCustomScriptResults(task, scriptContext, scrubber);
        this.runScriptCallback(this.executionLog, onSuccess, task.getId());
    }

    private boolean isScriptRunnable(Task task, String script) {
        return Strings.isNotBlank((String)script) && task.isTaskFailureHandlerEnabled() && task.isFailureHandlerEnabled() && TaskRecoverOp.RUN_SCRIPT == task.getTaskRecoverOp();
    }

    XlrScriptContext prepareScriptTaskContext(Task task, Writer log, Map<String, Object> globalVariables, Map<String, Object> folderVariables, Map<String, Object> releaseVariables) {
        XlrScriptContext scriptContext = this.makeScriptContext(log);
        if (!this.xlrConfig.isScriptSandboxDecryptPasswords()) {
            Release clonedRelease = CiCloneHelper.cloneCi(task.getRelease());
            String serverUrl = ReleaseServerUrlDecorator.SERVER_URL();
            clonedRelease.get$metadata().put(serverUrl, task.getRelease().get$metadata().get(serverUrl));
            scriptContext.addDomainObjects(clonedRelease.getTask(task.getId()));
        } else {
            scriptContext.addDomainObjects(task);
        }
        EncryptionHelper.decrypt((ConfigurationItem)task.getRelease());
        scriptContext.addReleaseVariables(task.getRelease(), this.permissions, releaseVariables);
        scriptContext.addGlobalVariables(this.permissions, globalVariables);
        this.addFolderVariables(task.getRelease(), scriptContext, folderVariables);
        scriptContext.addApi();
        scriptContext.addScriptLogger();
        return scriptContext;
    }

    XlrScriptContext prepareScriptTaskContext(Task task, Writer log) {
        String maybeFolderId = task.getRelease().findFolderId();
        Map<String, Object> folderVariables = Ids.isFolderId((String)maybeFolderId) ? this.scriptVariables.folderVariables(maybeFolderId) : null;
        Map<String, Object> globalVariables = this.scriptVariables.globalVariables();
        Map<String, Object> releaseVariables = this.scriptVariables.releaseVariables(task.getRelease());
        return this.prepareScriptTaskContext(task, log, globalVariables, folderVariables, releaseVariables);
    }

    XlrScriptContext prepareCustomScriptTaskContext(CustomScriptTask task, Writer log) {
        EncryptionHelper.decrypt((ConfigurationItem)task.getRelease());
        EncryptionHelper.decrypt((ConfigurationItem)task.getPythonScript());
        XlrScriptContext scriptContext = this.makeCustomScriptContext(log, task);
        scriptContext.addDomainObjects((Task)task);
        scriptContext.addCustomScriptApi(this.facetService, this.permissions, this.facetPermissions);
        return scriptContext;
    }

    XlrScriptContext prepareScriptValueProviderContext(Release release, ScriptValueProviderConfiguration configuration) {
        EncryptionHelper.decrypt((ConfigurationItem)release);
        EncryptionHelper.decrypt((ConfigurationItem)configuration);
        XlrScriptContext scriptContext = new XlrScriptContext();
        scriptContext.setAttribute("release", release, 100);
        scriptContext.setAttribute("_valueProvider", (Object)configuration, 100);
        scriptContext.addReleaseVariables(release, this.permissions, this.scriptVariables.releaseVariables(release));
        scriptContext.addGlobalVariables(this.permissions, this.scriptVariables.globalVariables());
        this.addFolderVariables(release, scriptContext, this.scriptVariables.folderVariables(release.findFolderId()));
        scriptContext.addApi();
        scriptContext.addScriptLogger();
        return scriptContext;
    }

    private void addFolderVariables(Release release, XlrScriptContext scriptContext, Map<String, Object> folderVariables) {
        String maybeFolderId = release.findFolderId();
        if (Ids.isFolderId((String)maybeFolderId)) {
            scriptContext.addFolderVariables(maybeFolderId, this.permissions, folderVariables);
        }
    }

    private void registerWriterForTask(Task task, SensitiveValueScrubber scrubber) {
        String taskId = task.getId();
        MDC.put((String)MDC_KEY_TASK, (String)taskId);
        int maxCommentSize = task.getMaxCommentSize();
        TruncatingCommentUpdater commentUpdater = new TruncatingCommentUpdater(this.commentService, task, maxCommentSize);
        long pollingInterval = this.xlrConfig.durations_scriptOutputPollingInterval().toMillis();
        PollingExecutionOutputHandler pollingHandler = PollingExecutionOutputHandler.pollingHandler(this.scheduler, commentUpdater, true, pollingInterval, pollingInterval);
        ScriptTaskOutputWriter scriptOutputWriter = new ScriptTaskOutputWriter(this.attachmentService, task);
        this.registerWriterWithHandlers(scrubber, scriptOutputWriter, OutputHandler.debug(this.logger), pollingHandler);
    }

    private void registerWriterWithHandlers(SensitiveValueScrubber scrubber, Writer writer, OverthereExecutionOutputHandler ... handlers) {
        this.executionLog.registerWriter((Writer)new ExecutionOutputWriter(scrubber, writer, handlers));
    }

    private void closeWriter() {
        try {
            this.executionLog.getWriter().close();
        }
        catch (IOException e) {
            this.logger.warn("Error closing script output logger", (Throwable)e);
        }
    }

    private void removeWriter() {
        this.closeWriter();
        this.executionLog.removeWriter();
        MDC.remove((String)MDC_KEY_TASK);
    }

    boolean isSystemExit0(ScriptException exception) {
        if (!(exception.getCause() instanceof PyException)) {
            return false;
        }
        PyException pyE = (PyException)exception.getCause();
        String pyEtoString = pyE.toString();
        PyType pyET = (PyType)pyE.type;
        String pyETName = pyET.getName();
        return pyETName.equals("SystemExit") && pyEtoString.contains("SystemExit: 0");
    }

    private XlrScriptContext makeScriptContext(Writer output) {
        XlrScriptContext context = new XlrScriptContext();
        context.setWriter(output);
        return context;
    }

    private XlrScriptContext makeCustomScriptContext(Writer executionLog, CustomScriptTask task) {
        XlrScriptContext scriptContext = this.makeScriptContext(executionLog);
        PythonScript pythonScript = task.getPythonScript();
        List<PropertyDescriptor> ctxProperties = Stream.concat(pythonScript.getInputProperties().stream(), pythonScript.getTransitionalProperties().stream()).collect(Collectors.toList());
        if (task.hasNextScriptToExecute()) {
            ctxProperties.addAll(pythonScript.getOutputProperties());
            task.resetSchedule();
        }
        scriptContext.setScriptPathForLog(task.getScriptPath());
        scriptContext.addProperties((ConfigurationItem)pythonScript, ctxProperties);
        scriptContext.addPropertyBindings(pythonScript.getTransitionalAndOutputProperties());
        return scriptContext;
    }

    public UpdatedVariables saveScriptResults(String taskId, ScriptTaskResults scriptTaskResults) {
        Object task = this.taskRepository.findById(taskId, new ResolveOptionsBuilder().withEverything().build());
        ScriptVariables.VariablesChanges releaseVariablesChanges = this.scriptVariables.detectReleaseVariablesChanges((Task)task, scriptTaskResults);
        ScriptVariables.VariablesChanges globalVariablesChanges = this.scriptVariables.detectGlobalVariablesChanges((Task)task, scriptTaskResults);
        ScriptVariables.VariablesChanges folderVariablesChanges = this.scriptVariables.detectFolderVariablesChanges((Task)task, scriptTaskResults);
        ArrayList<XLReleaseOperation> allOperations = new ArrayList<XLReleaseOperation>(releaseVariablesChanges.operations);
        allOperations.addAll(globalVariablesChanges.operations);
        allOperations.addAll(folderVariablesChanges.operations);
        XLReleaseOperations.runActionInterceptors(allOperations, this.eventBus);
        this.scriptVariables.processReleaseVariablesChanges(task.getRelease(), releaseVariablesChanges);
        this.scriptVariables.processGlobalVariablesChanges(globalVariablesChanges);
        this.scriptVariables.processFolderVariablesChanges(folderVariablesChanges);
        return new UpdatedVariables(globalVariablesChanges.updatedVariablesMap, folderVariablesChanges.updatedVariablesMap, releaseVariablesChanges.updatedVariablesMap);
    }

    public void saveCustomScriptResults(String taskId, CustomScriptTaskResults results) {
        CustomScriptTask task = (CustomScriptTask)this.taskRepository.findById(taskId, new ResolveOptionsBuilder().withEverything().build());
        task.setNextScriptPath(results.getNextScriptPath());
        task.setStatusLine(results.getStatusLine());
        task.setInterval(results.getInterval());
        if (!task.isStillExecutingScript(results.getScriptExecutionId())) {
            this.logger.debug("Will not save script results of task: '{}' : it has been aborted.", (Object)task.getId());
            return;
        }
        Changes changes = this.processCustomScriptTaskResults(task, results.getOutputVariables());
        this.taskRepository.update((Task)task);
        changes.getCommentsByTask().get((Object)task).forEach(userAndComment -> this.commentService.create((Task)task, (String)userAndComment._2(), User.SYSTEM, false));
        XLReleaseOperations.publishEvents(changes.getOperations(), this.eventBus);
    }

    Changes processCustomScriptTaskResults(CustomScriptTask task, Map<String, Object> outputAttributes) {
        this.setTransitionalProperties(task, outputAttributes);
        return this.setOutputPropertiesAndVariables(task, outputAttributes);
    }

    private void setTransitionalProperties(CustomScriptTask task, Map<String, Object> outputAttributes) {
        task.getPythonScript().getTransitionalProperties().forEach(propertyDescriptor -> {
            String propertyName = propertyDescriptor.getName();
            Object value = outputAttributes.get(propertyName);
            if (value == null) {
                this.logger.debug("Python script task {} did not return a value for property {}", (Object)task.getId(), (Object)propertyDescriptor.getName());
            } else {
                task.getPythonScript().setProperty(propertyName, value);
            }
        });
    }

    private Changes setOutputPropertiesAndVariables(CustomScriptTask task, Map<String, Object> outputAttributes) {
        Changes changes = new Changes();
        Release release = task.getRelease();
        Collection outputProperties = task.getPythonScript().getOutputProperties();
        HashMap<String, Object> newVariableValues = new HashMap<String, Object>();
        HashMap<String, Object> newPasswordVariableValues = new HashMap<String, Object>();
        String taskId = task.getId();
        for (PropertyDescriptor propertyDescriptor : outputProperties) {
            String propertyName = propertyDescriptor.getName();
            String fqPropertyName = "pythonScript." + propertyName;
            String variableName = null;
            Object propertyValue = task.getPythonScript().getProperty(propertyName);
            if (propertyValue instanceof String && VariableHelper.containsOnlyVariable((String)((String)propertyValue))) {
                variableName = (String)propertyValue;
            }
            if (task.getVariableMapping().containsKey(fqPropertyName)) {
                variableName = (String)task.getVariableMapping().get(fqPropertyName);
                if (!task.hasNextScriptToExecute()) {
                    task.getVariableMapping().remove(fqPropertyName);
                }
            }
            Object value = outputAttributes.get(propertyName);
            if (task.isKeepPreviousOutputPropertiesOnRetry() && !PythonScriptCiHelper.isEmpty((Object)task.getPythonScript().getProperty(propertyName))) {
                value = task.getPythonScript().getProperty(propertyName);
                if (propertyDescriptor.getKind() == PropertyKind.STRING) {
                    value = VariableHelper.withoutVariableSyntax((String)((String)value));
                }
            }
            if (value == null) {
                this.logger.debug("Python script task {} did not return a value for property {}", (Object)taskId, (Object)propertyDescriptor.getName());
                continue;
            }
            if (propertyDescriptor.getKind() == PropertyKind.STRING) {
                value = this.truncateValue(task, propertyDescriptor.getLabel(), value.toString(), changes);
            }
            task.getPythonScript().setProperty(propertyName, value);
            if (com.google.common.base.Strings.isNullOrEmpty((String)variableName)) {
                this.logger.debug("Missing output variable on Python script task {} for property {}", (Object)taskId, (Object)propertyDescriptor.getName());
                continue;
            }
            if (propertyDescriptor.isPassword()) {
                newPasswordVariableValues.put(variableName, value);
                continue;
            }
            newVariableValues.put(variableName, value);
        }
        List oldVariables = CiCloneHelper.cloneCis(release.getVariables());
        release.setVariableValues(newVariableValues);
        release.setPasswordVariableValues(newPasswordVariableValues);
        VariablePersistenceHelper.fixUpVariableIds(release.getId(), release.getVariables(), this.ciIdService);
        changes.addOperation((XLReleaseOperation)new ReleaseVariablesUpdateOperation(oldVariables, release.getVariables(), true));
        return changes;
    }

    private String truncateValue(CustomScriptTask task, String propertyLabel, String value, Changes changes) {
        int maxOutputPropertySize = task.getPythonScript().getMaxOutputPropertySize();
        if (value.length() > maxOutputPropertySize) {
            value = OUTPUT_TOO_LONG_MESSAGE.concat(value.substring(0, maxOutputPropertySize));
            this.logger.warn("The content of the output property '{}' from task '{}' has been truncated to {} characters", new Object[]{propertyLabel, task.getName(), maxOutputPropertySize});
            changes.addComment((Task)task, String.format("*Warning*: the value for property '%s' has been truncated because it was too large", propertyLabel));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object executeScript(String script, XlrScriptContext scriptContext, Task task, boolean checkPolicyPermissions) throws Exception {
        this.scriptLifeCycle.start(task.getExecutionId());
        try {
            Object object = this.scriptExecutor.evalScriptWithApi(script, scriptContext, checkPolicyPermissions);
            return object;
        }
        finally {
            this.scriptLifeCycle.end(task.getExecutionId());
            String logMessage = this.executionLog.toString();
            this.logger.debug("Script '{}' output : {}", (Object)scriptContext.getScriptPathForLog(), (Object)logMessage);
        }
    }

    Object executeScript(String script, XlrScriptContext scriptContext, boolean checkPolicyPermissions) throws Exception {
        return this.scriptExecutor.evalScript(script, scriptContext, checkPolicyPermissions);
    }

    Object executeScriptWithApi(String script, XlrScriptContext scriptContext, boolean checkPolicyPermissions) throws Exception {
        return this.scriptExecutor.evalScriptWithApi(script, scriptContext, checkPolicyPermissions);
    }

    protected void runScriptCallback(ThreadLocalWriterDecorator executionLog, ScriptCallback onSuccess, String taskId) {
        try {
            onSuccess.setExecutionLog(executionLog.toString());
            this.closeWriter();
            ExecutionOutputWriter executionOutputWriter = (ExecutionOutputWriter)executionLog.getWriter();
            ScriptTaskOutputWriter scriptWriter = (ScriptTaskOutputWriter)executionOutputWriter.getWriter();
            onSuccess.setAttachmentId(scriptWriter.getAttachmentId());
        }
        catch (Exception exception) {
            this.logger.warn("Unable to update XL Release task: '{}'", (Object)taskId, (Object)exception);
        }
        onSuccess.run();
    }

    protected void onScriptException(ScriptException exception, ThreadLocalWriterDecorator executionLog, ScriptCallback onFailure, String taskId) {
        String logMsg = "Exception during execution";
        String executionLogMsg = String.format("%s:%n", logMsg);
        this.onException(exception, executionLog, onFailure, taskId, executionLogMsg, logMsg);
    }

    protected void onException(Exception exception, ThreadLocalWriterDecorator executionLog, ScriptCallback onFailure, String taskId, String executionLogMessage, String logMessage) {
        this.logger.warn(logMessage, (Object)taskId, (Object)exception);
        String defaultMessage = Objects.toString(this.sanitizeServerPath(exception.toString()), "");
        try {
            executionLog.append((CharSequence)executionLogMessage);
            executionLog.append((CharSequence)defaultMessage);
            executionLog.flush();
            onFailure.setExecutionLog(Objects.toString(executionLog.toString(), defaultMessage));
            this.closeWriter();
            ExecutionOutputWriter executionOutputWriter = (ExecutionOutputWriter)executionLog.getWriter();
            ScriptTaskOutputWriter scriptWriter = (ScriptTaskOutputWriter)executionOutputWriter.getWriter();
            onFailure.setAttachmentId(scriptWriter.getAttachmentId());
        }
        catch (Exception e) {
            this.logger.warn("Unable to update XL Release task: '{}'", (Object)taskId, (Object)e);
        }
        onFailure.run();
    }

    protected String sanitizeServerPath(String message) {
        return message == null ? null : message.replace(System.getProperty("user.dir"), "{ServerWorkingDirectory}");
    }

    private boolean isRestartPhasesException(ScriptException exception) {
        return ExceptionUtils.getRootCause((Throwable)exception) instanceof RestartPhasesException;
    }

    private void onRestartPhasesException(RestartPhasesException ex, ThreadLocalWriterDecorator executionLog, ScriptCallback onFailure, BaseScriptTask task) {
        Release release = this.releaseService.findById(ex.getReleaseId());
        List runningAutomatedTaskIds = release.getActiveTasks().stream().filter(Task::isAutomated).map(BaseConfigurationItem::getId).collect(Collectors.toList());
        if (!runningAutomatedTaskIds.contains(task.getId())) {
            this.onException((Exception)((Object)ex), executionLog, onFailure, task.getId(), "Exception during execution:\n", "You can not restart phases in another release when an automated task is running");
        } else if (runningAutomatedTaskIds.size() > 1) {
            this.onException((Exception)((Object)ex), executionLog, onFailure, task.getId(), "Exception during execution:\n", "You can not restart phases when there are other automated task running");
        } else {
            onFailure.run();
            this.releaseActorService.restartPhase(ex.getReleaseId(), ex.getPhaseId(), ex.getTaskId(), ex.getPhaseVersion(), ex.isResumeRelease());
        }
    }

    private Function<VariablesHolderForScriptContext, UpdatedVariables> variablesSynchronizationCallback(Task task) {
        return v -> {
            this.logger.debug("Synchronizing variables from script execution of task '{}'", (Object)task.getTitle());
            return this.releaseActorService.saveScriptResults(task.getId(), new ScriptTaskResults(ScriptServiceHelper.extractReleaseVariables(v.getScriptContext()), ScriptServiceHelper.extractGlobalVariables(v.getScriptContext()), ScriptServiceHelper.extractFolderVariables(v.getScriptContext()), v.getPreviousReleaseVariables(), v.getPreviousGlobalVariables(), v.getPreviousFolderVariables()));
        };
    }

    ThreadLocalWriterDecorator getExecutionLog() {
        return this.executionLog;
    }

    static class RingWriter
    extends Writer {
        private CircularFifoQueue<Character> queue;

        public RingWriter(int size) {
            this.queue = new CircularFifoQueue(size);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i = off; i < len; ++i) {
                this.queue.add((Object)Character.valueOf(cbuf[i]));
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        public String toString() {
            return this.queue.stream().collect(Collector.of(StringBuilder::new, StringBuilder::append, StringBuilder::append, StringBuilder::toString, new Collector.Characteristics[0]));
        }
    }

    class ScriptTaskOutputWriter
    extends Writer {
        boolean closed = false;
        private final AttachmentService attachmentService;
        private final DeferredFileOutputStream dfos;
        private final OutputStreamWriter writer;
        private final RingWriter ringWriter;
        private final Task task;
        private final WorkDir workDir;
        private String attachmentId;

        public ScriptTaskOutputWriter(AttachmentService attachmentService, Task task) {
            this.attachmentService = attachmentService;
            int maxCommentSize = task.getMaxCommentSize();
            this.task = task;
            this.ringWriter = new RingWriter(maxCommentSize);
            WorkDirContext.initWorkdir();
            this.workDir = WorkDirContext.get();
            File workDirFile = new File(this.workDir.getPath());
            this.dfos = new DeferredFileOutputStream(maxCommentSize, task.getName(), ".log", workDirFile);
            this.writer = new OutputStreamWriter((OutputStream)this.dfos, StandardCharsets.UTF_8);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.writer.write(cbuf, off, len);
            this.ringWriter.write(cbuf, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
            if (!this.closed) {
                this.saveArtifact();
            }
            this.workDir.delete();
            this.closed = true;
        }

        private void saveArtifact() {
            if (this.contentLength() > 0L) {
                try {
                    InputStream content = this.getContent();
                    String artifactName = new SimpleDateFormat("'script_output_'yyyyMMddHHmmss'.log'").format(new Date());
                    this.attachmentId = this.attachmentService.insertArtifact(this.task.getRelease(), artifactName, content);
                }
                catch (FileNotFoundException e) {
                    String msg = String.format("Unable to fetch script log file of a task '%s'", this.task.getId());
                    DefaultScriptService.this.logger.warn(msg, (Throwable)e);
                    DefaultScriptService.this.commentService.appendComment(this.task, null, msg);
                }
                catch (Exception e) {
                    DefaultScriptService.this.logger.error("Unable to save attachment of a task '{}'.", (Object)this.task.getId(), (Object)e);
                    DefaultScriptService.this.commentService.appendComment(this.task, null, "Unable to save attachment. Please check `xl-release.log`");
                }
            }
        }

        private long contentLength() {
            return this.dfos.getByteCount();
        }

        private InputStream getContent() throws FileNotFoundException {
            InputStream content = this.dfos.isInMemory() ? new ByteArrayInputStream(this.dfos.getData()) : new FileInputStream(this.dfos.getFile());
            return content;
        }

        public String toString() {
            return this.ringWriter.toString();
        }

        public String getAttachmentId() {
            return this.attachmentId;
        }
    }

    public static class UpdatedVariables {
        private Map<String, Variable> globalVariables;
        private Map<String, Variable> folderVariables;
        private Map<String, Variable> releaseVariables;

        public UpdatedVariables(Map<String, Variable> globalVariables, Map<String, Variable> folderVariables, Map<String, Variable> releaseVariables) {
            this.globalVariables = globalVariables;
            this.folderVariables = folderVariables;
            this.releaseVariables = releaseVariables;
        }

        public Map<String, Variable> getGlobalVariables() {
            return this.globalVariables;
        }

        public Map<String, Variable> getFolderVariables() {
            return this.folderVariables;
        }

        public Map<String, Variable> getReleaseVariables() {
            return this.releaseVariables;
        }
    }

    public static class ScriptTaskResults
    implements Serializable {
        private Map<String, Object> releaseVariables;
        private Map<String, Object> globalVariables;
        private Map<String, Object> folderVariables;
        private Map<String, Variable> initialReleaseVariables;
        private Map<String, Variable> initialGlobalVariables;
        private Map<String, Variable> initialFolderVariables;

        public ScriptTaskResults(Map<String, Object> releaseVariables, Map<String, Object> globalVariables, Map<String, Object> folderVariables, Map<String, Variable> initialReleaseVariables, Map<String, Variable> initialGlobalVariables, Map<String, Variable> initialFolderVariables) {
            this.releaseVariables = releaseVariables;
            this.globalVariables = globalVariables;
            this.folderVariables = folderVariables;
            this.initialReleaseVariables = initialReleaseVariables;
            this.initialGlobalVariables = initialGlobalVariables;
            this.initialFolderVariables = initialFolderVariables;
        }

        public Map<String, Object> getReleaseVariables() {
            return this.releaseVariables;
        }

        public Map<String, Object> getGlobalVariables() {
            return this.globalVariables;
        }

        public Map<String, Variable> getInitialReleaseVariables() {
            return this.initialReleaseVariables;
        }

        public Map<String, Variable> getInitialGlobalVariables() {
            return this.initialGlobalVariables;
        }

        public Map<String, Object> getFolderVariables() {
            return this.folderVariables;
        }

        public Map<String, Variable> getInitialFolderVariables() {
            return this.initialFolderVariables;
        }
    }

    public static class CustomScriptTaskResults
    implements Serializable {
        private Map<String, Object> outputVariables;
        private String scriptExecutionId;
        private String statusLine;
        private String nextScriptPath;
        private Integer interval;

        public CustomScriptTaskResults(Map<String, Object> outputVariables, String scriptExecutionId, String statusLine, String nextScriptPath, Integer interval) {
            this.outputVariables = outputVariables;
            this.scriptExecutionId = scriptExecutionId;
            this.statusLine = statusLine;
            this.nextScriptPath = nextScriptPath;
            this.interval = interval;
        }

        public Map<String, Object> getOutputVariables() {
            return this.outputVariables;
        }

        public String getScriptExecutionId() {
            return this.scriptExecutionId;
        }

        public String getStatusLine() {
            return this.statusLine;
        }

        public String getNextScriptPath() {
            return this.nextScriptPath;
        }

        public Integer getInterval() {
            return this.interval;
        }
    }
}

