/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.BaseScriptTask;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.TaskExecutor;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.script.ScriptCallback;
import com.xebialabs.xlrelease.script.ScriptService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.SensitiveValueScrubber;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public abstract class BaseScriptTaskExecutor<T extends BaseScriptTask>
implements TaskExecutor<T> {
    private static final Logger logger = LoggerFactory.getLogger(BaseScriptTaskExecutor.class);
    protected TaskRepository taskRepository;
    protected ReleaseActorService releaseActorService;
    private Map<String, ScriptService> scriptServices = new HashMap<String, ScriptService>();

    protected BaseScriptTaskExecutor(TaskRepository taskRepository, ReleaseActorService releaseActorService, Collection<? extends ScriptService> scriptServices) {
        this.taskRepository = taskRepository;
        this.releaseActorService = releaseActorService;
        scriptServices.forEach(scriptService -> this.scriptServices.put(scriptService.engine(), (ScriptService)scriptService));
    }

    protected ScriptService scriptServiceFor(BaseScriptTask task) {
        return this.scriptServices.get(task.getEngine());
    }

    @VisibleForTesting
    public ScriptCallback onSuccess(T task, SensitiveValueScrubber scrubber) {
        return new ScriptCallback((BaseScriptTask)task){
            final /* synthetic */ BaseScriptTask val$task;
            {
                this.val$task = baseScriptTask;
            }

            @Override
            public void run() {
                Option logArtifactId = Option.apply((Object)this.getAttachmentId());
                BaseScriptTaskExecutor.this.scriptTaskCompleted(this.val$task.getId(), this.getExecutionLog(), this.val$task.getExecutionId(), (Option<String>)logArtifactId);
            }
        };
    }

    @VisibleForTesting
    public ScriptCallback onFailure(T task) {
        return new ScriptCallback((BaseScriptTask)task){
            final /* synthetic */ BaseScriptTask val$task;
            {
                this.val$task = baseScriptTask;
            }

            @Override
            public void run() {
                Option logArtifactId = Option.apply((Object)this.getAttachmentId());
                BaseScriptTaskExecutor.this.releaseActorService.failScriptTask(this.val$task.getId(), this.getExecutionLog(), this.val$task.getExecutionId(), (Option<String>)logArtifactId);
            }
        };
    }

    protected void scriptTaskCompleted(String taskId, String executionLog, String scriptExecutionId, Option<String> logArtifactId) {
        BaseScriptTask task = (BaseScriptTask)this.taskRepository.findById(taskId, new ResolveOptionsBuilder().build());
        if (task.isStillExecutingScript(scriptExecutionId)) {
            this.releaseActorService.markTaskAsDone(TaskStatus.COMPLETED, taskId, executionLog, logArtifactId, User.LOG_OUTPUT);
        } else {
            logger.debug("Will not complete task: '{}', it has been aborted.", (Object)task.getId());
        }
    }
}

