/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.lucene.DocOrderNodeIteratorImpl;
import org.apache.jackrabbit.core.query.lucene.ExcerptProvider;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.RowIteratorImpl;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.ScoreNodeIterator;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.SpellSuggestion;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResultImpl
implements QueryResult {
    private static final Logger log = LoggerFactory.getLogger((Class)QueryResultImpl.class);
    private final SearchIndex index;
    private final ItemManager itemMgr;
    protected final SessionImpl session;
    private final AccessManager accessMgr;
    protected final AbstractQueryImpl queryImpl;
    protected final Query query;
    protected final SpellSuggestion spellSuggestion;
    protected final Name[] selectProps;
    protected final Name[] orderProps;
    protected final boolean[] orderSpecs;
    private final List resultNodes = new ArrayList();
    private int numResults = -1;
    private int invalid = 0;
    private final boolean docOrder;
    private ExcerptProvider excerptProvider;
    private final long offset;
    private final long limit;

    public QueryResultImpl(SearchIndex index, ItemManager itemMgr, SessionImpl session, AccessManager accessMgr, AbstractQueryImpl queryImpl, Query query, SpellSuggestion spellSuggestion, Name[] selectProps, Name[] orderProps, boolean[] orderSpecs, boolean documentOrder, long offset, long limit) throws RepositoryException {
        this.index = index;
        this.itemMgr = itemMgr;
        this.session = session;
        this.accessMgr = accessMgr;
        this.queryImpl = queryImpl;
        this.query = query;
        this.spellSuggestion = spellSuggestion;
        this.selectProps = selectProps;
        this.orderProps = orderProps;
        this.orderSpecs = orderSpecs;
        this.docOrder = orderProps.length == 0 && documentOrder;
        this.offset = offset;
        this.limit = limit;
        this.getResults(this.docOrder ? Integer.MAX_VALUE : (long)index.getResultFetchSize());
    }

    public String[] getColumnNames() throws RepositoryException {
        try {
            String[] propNames = new String[this.selectProps.length];
            for (int i = 0; i < this.selectProps.length; ++i) {
                propNames[i] = this.session.getJCRName(this.selectProps[i]);
            }
            return propNames;
        }
        catch (NamespaceException npde) {
            String msg = "encountered invalid property name";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)npde);
        }
    }

    public NodeIterator getNodes() throws RepositoryException {
        return this.getNodeIterator();
    }

    public RowIterator getRows() throws RepositoryException {
        if (this.excerptProvider == null) {
            try {
                this.excerptProvider = this.index.createExcerptProvider(this.query);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return new RowIteratorImpl(this.getNodeIterator(), this.selectProps, this.queryImpl.getSelectorNames(), this.itemMgr, this.session, this.excerptProvider, this.spellSuggestion);
    }

    protected MultiColumnQueryHits executeQuery() throws IOException {
        return this.index.executeQuery(this.session, this.queryImpl, this.query, this.orderProps, this.orderSpecs);
    }

    private ScoreNodeIterator getNodeIterator() {
        if (this.docOrder) {
            return new DocOrderNodeIteratorImpl(this.itemMgr, this.resultNodes, 0);
        }
        return new LazyScoreNodeIterator(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getResults(long size) throws RepositoryException {
        if (log.isDebugEnabled()) {
            log.debug("getResults({}) limit={}", (Object)new Long(size), (Object)new Long(this.limit));
        }
        long maxResultSize = size;
        if (this.limit > 0L) {
            maxResultSize = this.limit;
        }
        if ((long)this.resultNodes.size() >= maxResultSize) {
            return;
        }
        MultiColumnQueryHits result = null;
        try {
            long time = System.currentTimeMillis();
            result = this.executeQuery();
            log.debug("query executed in {} ms", (Object)new Long(System.currentTimeMillis() - time));
            if (this.resultNodes.isEmpty() && this.offset > 0L) {
                this.collectScoreNodes(result, new ArrayList(), this.offset);
            } else {
                int start = this.resultNodes.size() + this.invalid + (int)this.offset;
                result.skip(start);
            }
            time = System.currentTimeMillis();
            this.collectScoreNodes(result, this.resultNodes, maxResultSize);
            log.debug("retrieved ScoreNodes in {} ms", (Object)new Long(System.currentTimeMillis() - time));
            this.numResults = result.getSize();
        }
        catch (IOException e) {
            log.error("Exception while executing query: ", (Throwable)e);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close query result: " + e);
                }
            }
        }
    }

    private void collectScoreNodes(MultiColumnQueryHits hits, List collector, long maxResults) throws IOException, RepositoryException {
        ScoreNode[] sn;
        while ((long)collector.size() < maxResults && (sn = hits.nextScoreNodes()) != null) {
            if (this.isAccessGranted(sn)) {
                collector.add(sn);
                continue;
            }
            ++this.invalid;
        }
    }

    private boolean isAccessGranted(ScoreNode[] nodes) throws RepositoryException {
        for (int i = 0; i < nodes.length; ++i) {
            try {
                if (nodes[i] == null || this.accessMgr.isGranted(nodes[i].getNodeId(), 1)) continue;
                return false;
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    public int getTotalSize() {
        if (this.numResults == -1) {
            return -1;
        }
        return this.numResults - this.invalid;
    }

    private final class LazyScoreNodeIterator
    implements ScoreNodeIterator {
        private int position = -1;
        private boolean initialized = false;
        private NodeImpl next;
        private final int selectorIndex;

        private LazyScoreNodeIterator(int selectorIndex) {
            this.selectorIndex = selectorIndex;
        }

        public float getScore() {
            this.initialize();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ((ScoreNode[])QueryResultImpl.this.resultNodes.get(this.position))[this.selectorIndex].getScore();
        }

        public ScoreNode[] getScoreNodes() {
            this.initialize();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (ScoreNode[])QueryResultImpl.this.resultNodes.get(this.position);
        }

        public NodeImpl nextNodeImpl() {
            this.initialize();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            NodeImpl n = this.next;
            this.fetchNext();
            return n;
        }

        public Node nextNode() {
            return this.nextNodeImpl();
        }

        public void skip(long skipNum) {
            this.initialize();
            if (skipNum < 0L) {
                throw new IllegalArgumentException("skipNum must not be negative");
            }
            if (skipNum != 0L) {
                try {
                    QueryResultImpl.this.getResults(this.position + QueryResultImpl.this.invalid + (int)skipNum);
                    if ((long)QueryResultImpl.this.resultNodes.size() < (long)this.position + skipNum) {
                        throw new NoSuchElementException();
                    }
                    this.position = (int)((long)this.position + (skipNum - 1L));
                    this.fetchNext();
                }
                catch (RepositoryException e) {
                    throw new NoSuchElementException(e.getMessage());
                }
            }
        }

        public long getSize() {
            int total = QueryResultImpl.this.getTotalSize();
            if (total == -1) {
                return -1L;
            }
            long size = (long)total - QueryResultImpl.this.offset;
            if (QueryResultImpl.this.limit > 0L && size > QueryResultImpl.this.limit) {
                return QueryResultImpl.this.limit;
            }
            return size;
        }

        public long getPosition() {
            this.initialize();
            return this.position;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public boolean hasNext() {
            this.initialize();
            return this.next != null;
        }

        public Object next() {
            return this.nextNodeImpl();
        }

        private void initialize() {
            if (!this.initialized) {
                this.fetchNext();
                this.initialized = true;
            }
        }

        private void fetchNext() {
            this.next = null;
            int nextPos = this.position + 1;
            while (this.next == null) {
                if (nextPos >= QueryResultImpl.this.resultNodes.size()) {
                    if (QueryResultImpl.this.numResults != -1 && nextPos + QueryResultImpl.this.invalid >= QueryResultImpl.this.numResults) break;
                    try {
                        int num = QueryResultImpl.this.resultNodes.size() == 0 ? QueryResultImpl.this.index.getResultFetchSize() : QueryResultImpl.this.resultNodes.size() * 2;
                        QueryResultImpl.this.getResults(num);
                    }
                    catch (RepositoryException e) {
                        log.warn("Exception getting more results: " + (Object)((Object)e));
                    }
                    if (nextPos >= QueryResultImpl.this.resultNodes.size()) break;
                }
                ScoreNode[] sn = (ScoreNode[])QueryResultImpl.this.resultNodes.get(nextPos);
                try {
                    this.next = (NodeImpl)QueryResultImpl.this.itemMgr.getItem(sn[this.selectorIndex].getNodeId());
                }
                catch (RepositoryException e) {
                    log.warn("Exception retrieving Node with UUID: " + sn[this.selectorIndex].getNodeId() + ": " + e.toString());
                    QueryResultImpl.this.resultNodes.remove(nextPos);
                    QueryResultImpl.this.invalid++;
                }
            }
            ++this.position;
        }
    }
}

