/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import java.util.regex.Pattern;

public class Ids {
    public static final String ROOT_FOLDER_ID = Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName();
    public static final String SEPARATOR = "/";
    public static final String RELEASE_PREFIX = "Release";
    public static final String TRIGGER_PREFIX = "Trigger";
    public static final String PHASE_PREFIX = "Phase";
    public static final String TASK_PREFIX = "Task";
    public static final String VARIABLE_PREFIX = "Variable";
    public static final String CONFIGURATION_PREFIX = "Configuration";
    public static final String VALUE_PROVIDER_SUFFIX = "valueProvider";
    public static final String DEPENDENCY_PREFIX = "Dependency";
    public static final String FOLDER_PREFIX = "Folder";
    public static final String ATTACHMENT_PREFIX = "Attachment";
    public static final String TEAM_PREFIX = "Team";
    public static final String DELIVERY_PREFIX = "Delivery";
    private static final String STAGE_PREFIX = "Stage";
    public static final String CUSTOM_CONFIGURATION_ROOT = Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/Custom";
    public static final String CALENDAR_ROOT = Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/Calendar";
    public static final String DELIVERIES_ROOT = "Deliveries";
    private static final String DELIVERY_REGEX = "((Deliveries/Delivery)|(Delivery))[a-zA-Z0-9]{32}";
    private static final Pattern DELIVERY_PATTERN = Pattern.compile("((Deliveries/Delivery)|(Delivery))[a-zA-Z0-9]{32}");
    private static final Pattern STAGE_PATTERN = Pattern.compile("((Deliveries/Delivery)|(Delivery))[a-zA-Z0-9]{32}/Stage[a-zA-Z0-9]{32}");

    private Ids() {
    }

    public static String getParentId(String id) {
        if (Ids.isRoot(id)) {
            throw new IllegalArgumentException("Not a proper ID for a children: " + id);
        }
        return id.substring(0, id.lastIndexOf(SEPARATOR));
    }

    public static boolean isRoot(String id) {
        return !id.contains(SEPARATOR);
    }

    public static String releaseIdFrom(String id) {
        return Ids.findInAncestry(id, RELEASE_PREFIX);
    }

    public static String triggerIdFrom(String id) {
        return Ids.findInAncestry(id, TRIGGER_PREFIX);
    }

    public static String deliveryIdFrom(String id) {
        return Ids.findInAncestry(id, DELIVERY_PREFIX);
    }

    public static String phaseIdFrom(String id) {
        return Ids.findInAncestry(id, PHASE_PREFIX);
    }

    public static String taskIdFrom(String id) {
        return Ids.findInAncestry(id, TASK_PREFIX);
    }

    public static boolean isNullId(String id) {
        return id == null || id.trim().isEmpty() || "null".equals(id.trim().toLowerCase());
    }

    public static boolean isPlanItemId(String id) {
        return Ids.isReleaseId(id) || Ids.isPhaseId(id) || Ids.isTaskId(id);
    }

    public static boolean isReleaseId(String id) {
        Ids.checkIdNotNull(id);
        return Ids.getName(id).startsWith(RELEASE_PREFIX);
    }

    public static boolean isTriggerId(String id) {
        Ids.checkIdNotNull(id);
        return Ids.getName(id).startsWith(TRIGGER_PREFIX);
    }

    public static boolean isPhaseId(String id) {
        Ids.checkIdNotNull(id);
        return Ids.getName(id).startsWith(PHASE_PREFIX);
    }

    public static boolean isAttachmentId(String id) {
        Ids.checkIdNotNull(id);
        return Ids.getName(id).startsWith(ATTACHMENT_PREFIX);
    }

    public static boolean isTaskId(String id) {
        Ids.checkIdNotNull(id);
        return Ids.getName(id).startsWith(TASK_PREFIX);
    }

    public static boolean isVariableId(String id) {
        Ids.checkIdNotNull(id);
        return Ids.getName(id).startsWith(VARIABLE_PREFIX);
    }

    public static boolean isDependencyId(String id) {
        Ids.checkIdNotNull(id);
        return Ids.getName(id).startsWith(DEPENDENCY_PREFIX);
    }

    public static boolean isFolderId(String id) {
        Ids.checkIdNotNull(id);
        return Ids.getName(id).startsWith(FOLDER_PREFIX);
    }

    public static boolean isCustomConfigurationId(String id) {
        Ids.checkIdNotNull(id);
        return id.startsWith(CUSTOM_CONFIGURATION_ROOT);
    }

    public static boolean isConfigurationId(String id) {
        Ids.checkIdNotNull(id);
        return id.startsWith(Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName()) || id.startsWith(Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName()) && Ids.getName(id).startsWith(CONFIGURATION_PREFIX);
    }

    public static boolean isTeamId(String id) {
        Ids.checkIdNotNull(id);
        return Ids.getName(id).startsWith(TEAM_PREFIX);
    }

    public static boolean isDomainId(String id) {
        Ids.checkIdNotNull(id);
        return id.startsWith(Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName());
    }

    public static boolean isValueProviderId(String id) {
        Ids.checkIdNotNull(id);
        int i = id.lastIndexOf(47);
        if (i < 1) {
            return false;
        }
        String[] stringArray = new String[]{id.substring(0, i), id.substring(i + 1)};
        return Ids.isVariableId(stringArray[0]) && stringArray[1].equals(VALUE_PROVIDER_SUFFIX);
    }

    public static boolean isCalendarId(String id) {
        Ids.checkIdNotNull(id);
        return id.startsWith(CALENDAR_ROOT);
    }

    public static boolean isDeliveryId(String id) {
        Ids.checkIdNotNull(id);
        return DELIVERY_PATTERN.matcher(id).matches();
    }

    public static boolean isStageId(String id) {
        Ids.checkIdNotNull(id);
        return STAGE_PATTERN.matcher(id).matches();
    }

    public static boolean isInFolder(String id) {
        return !Ids.isRoot(id) && Ids.isFolderId(Ids.getParentId(id));
    }

    public static boolean isInRootFolder(String id) {
        return !Ids.isNullId(id) && ROOT_FOLDER_ID.equals(Ids.getParentId(id));
    }

    public static boolean isInRelease(String id) {
        try {
            return !Ids.isReleaseId(id) && Ids.releaseIdFrom(id) != null;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static String findInAncestry(String id, String prefix) {
        if (!id.contains(prefix)) {
            throw new IllegalArgumentException(String.format("ID '%s' does not contain prefix '%s'", id, prefix));
        }
        try {
            String ancestryId = id;
            while (!Ids.getName(ancestryId).startsWith(prefix)) {
                ancestryId = Ids.getParentId(ancestryId);
            }
            return ancestryId;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(String.format("Unable to find ancestor ID of the following ID: '%s' and prefix: '%s'", id, prefix), ex);
        }
    }

    private static void checkIdNotNull(String id) {
        if (id == null) {
            throw new IllegalArgumentException("ID may not be null");
        }
    }

    public static String getName(String id) {
        if (id == null || !id.contains(SEPARATOR)) {
            return id;
        }
        return id.substring(id.lastIndexOf(SEPARATOR) + 1);
    }

    public static String getReleaselessChildId(String childId) {
        if (Ids.isReleaseId(childId)) {
            return null;
        }
        return childId.substring(Ids.releaseIdFrom(childId).length() + 1);
    }

    public static String getFolderlessId(String id) {
        String folderId = Ids.findFolderId(id);
        if (Ids.isFolderId(folderId) || ROOT_FOLDER_ID.equals(folderId)) {
            return Ids.relativePathFrom(folderId, Ids.normalizeId(id));
        }
        return Ids.normalizeId(id);
    }

    public static String relativePathFrom(String fromPath, String fullPath) {
        if (fullPath.equals(fromPath)) {
            return "";
        }
        if (fullPath.startsWith(fromPath)) {
            return fullPath.substring(fromPath.length() + 1);
        }
        throw new IllegalArgumentException(String.format("'%s' does not contain '%s'", fullPath, fromPath));
    }

    public static String getFullTaskName(String id) {
        return id.substring(Ids.phaseIdFrom(id).length() + 1);
    }

    public static String getTopLevelTaskId(String id) {
        String topLevelTaskId = id;
        while (Ids.isTaskId(Ids.getParentId(topLevelTaskId))) {
            topLevelTaskId = Ids.getParentId(topLevelTaskId);
        }
        return topLevelTaskId;
    }

    public static String releasePathInRootFolder(String releaseId) {
        Ids.checkIdNotNull(releaseId);
        return releaseId.replace(ROOT_FOLDER_ID + SEPARATOR, "");
    }

    public static String findFolderId(String id) {
        String parentId = Ids.normalizeId(id);
        while (!Ids.isFolderId(parentId) && !Ids.isRoot(parentId)) {
            parentId = Ids.getParentId(parentId);
        }
        return parentId;
    }

    public static String findCommonParent(String id1, String id2) {
        String[] path1 = id1.split(SEPARATOR);
        String[] path2 = id2.split(SEPARATOR);
        StringBuilder parent = new StringBuilder();
        for (int i = 0; i < path1.length; ++i) {
            String item2;
            String item1 = path1[i];
            if (i == path2.length || !item1.equals(item2 = path2[i])) break;
            parent.append(item1).append(SEPARATOR);
        }
        return parent.length() > 0 ? parent.toString().substring(0, parent.length() - 1) : "";
    }

    public static String normalizeId(String id) {
        if (id == null) {
            return null;
        }
        return id.startsWith(SEPARATOR) ? id.substring(1) : id;
    }

    public static String formatWithFolderId(String folderId, String containerId) {
        return String.format("%s/%s", folderId != null ? folderId : ROOT_FOLDER_ID, containerId);
    }

    public static String releaseActorId(String releaseId) {
        return Ids.normalizeId(Ids.getFolderlessId(Ids.releaseIdFrom(releaseId)));
    }
}

